// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Extrema_GenExtPS_HeaderFile
#define _Extrema_GenExtPS_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TColgp_HArray2OfPnt_HeaderFile
#include <Handle_TColgp_HArray2OfPnt.hxx>
#endif
#ifndef _Extrema_FuncExtPS_HeaderFile
#include <Extrema_FuncExtPS.hxx>
#endif
#ifndef _Adaptor3d_SurfacePtr_HeaderFile
#include <Adaptor3d_SurfacePtr.hxx>
#endif
class TColgp_HArray2OfPnt;
class StdFail_NotDone;
class Standard_OutOfRange;
class Standard_TypeMismatch;
class gp_Pnt;
class Adaptor3d_Surface;
class Extrema_POnSurf;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! It calculates all the extremum distances <br>
//!          between a point and a surface. <br>
//!          These distances can be minimum or maximum. <br>
class Extrema_GenExtPS  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Extrema_GenExtPS();

//! It calculates all the distances. <br>
//!          The function F(u,v)=distance(P,S(u,v)) has an <br>
//!          extremum when gradient(F)=0. The algorithm searchs <br>
//!          all the zeros inside the definition ranges of the <br>
//!          surface. <br>
//!          NbU and NbV are used to locate the close points <br>
//!          to find the zeros. They must be great enough <br>
//!          such that if there is N extrema, there will <br>
//!          be N extrema between P and the grid. <br>
//!          TolU et TolV are used to determine the conditions <br>
//!          to stop the iterations; at the iteration number n: <br>
//!           (Un - Un-1) < TolU and (Vn - Vn-1) < TolV . <br>
Standard_EXPORT Extrema_GenExtPS(const gp_Pnt& P,const Adaptor3d_Surface& S,const Standard_Integer NbU,const Standard_Integer NbV,const Standard_Real TolU,const Standard_Real TolV);

//! It calculates all the distances. <br>
//!          The function F(u,v)=distance(P,S(u,v)) has an <br>
//!          extremum when gradient(F)=0. The algorithm searchs <br>
//!          all the zeros inside the definition ranges of the <br>
//!          surface. <br>
//!          NbU and NbV are used to locate the close points <br>
//!          to find the zeros. They must be great enough <br>
//!          such that if there is N extrema, there will <br>
//!          be N extrema between P and the grid. <br>
//!          TolU et TolV are used to determine the conditions <br>
//!          to stop the iterations; at the iteration number n: <br>
//!           (Un - Un-1) < TolU and (Vn - Vn-1) < TolV . <br>
Standard_EXPORT Extrema_GenExtPS(const gp_Pnt& P,const Adaptor3d_Surface& S,const Standard_Integer NbU,const Standard_Integer NbV,const Standard_Real Umin,const Standard_Real Usup,const Standard_Real Vmin,const Standard_Real Vsup,const Standard_Real TolU,const Standard_Real TolV);


Standard_EXPORT   void Initialize(const Adaptor3d_Surface& S,const Standard_Integer NbU,const Standard_Integer NbV,const Standard_Real TolU,const Standard_Real TolV) ;


Standard_EXPORT   void Initialize(const Adaptor3d_Surface& S,const Standard_Integer NbU,const Standard_Integer NbV,const Standard_Real Umin,const Standard_Real Usup,const Standard_Real Vmin,const Standard_Real Vsup,const Standard_Real TolU,const Standard_Real TolV) ;

//! the algorithm is done with the point P. <br>
//!          An exception is raised if the fields have not <br>
//!          been initialized. <br>
Standard_EXPORT   void Perform(const gp_Pnt& P) ;

//! Returns True if the distances are found. <br>
Standard_EXPORT   Standard_Boolean IsDone() const;

//! Returns the number of extremum distances. <br>
Standard_EXPORT   Standard_Integer NbExt() const;

//! Returns the value of the Nth resulting distance. <br>
Standard_EXPORT   Standard_Real Value(const Standard_Integer N) const;

//! Returns the point of the Nth resulting distance. <br>
Standard_EXPORT   Extrema_POnSurf Point(const Standard_Integer N) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Adaptor3d_SurfacePtr Bidon() const;


 // Fields PRIVATE
 //
Standard_Boolean myDone;
Standard_Boolean myInit;
Standard_Real myumin;
Standard_Real myusup;
Standard_Real myvmin;
Standard_Real myvsup;
Standard_Integer myusample;
Standard_Integer myvsample;
Handle_TColgp_HArray2OfPnt mypoints;
Standard_Real mytolu;
Standard_Real mytolv;
Extrema_FuncExtPS myF;
Adaptor3d_SurfacePtr myS;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
