// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _FairCurve_BattenLaw_HeaderFile
#define _FairCurve_BattenLaw_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _math_Function_HeaderFile
#include <math_Function.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class compute the Heigth of an batten <br>
class FairCurve_BattenLaw  : public math_Function {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructor of linear batten with <br>
//!          Heigth : the Heigth at the middle point <br>
//!          Slope  : the geometric slope of the batten <br>
//!          Sliding : Active Length of the batten without extension <br>
Standard_EXPORT FairCurve_BattenLaw(const Standard_Real Heigth,const Standard_Real Slope,const Standard_Real Sliding);
//! Change the value of sliding <br>
  void SetSliding(const Standard_Real Sliding) ;
//! Change the value of Heigth at the middle point. <br>
  void SetHeigth(const Standard_Real Heigth) ;
//! Change the value of the geometric slope. <br>
  void SetSlope(const Standard_Real Slope) ;
//! computes the value of  the heigth for the parameter T <br>
//!          on  the neutral fibber <br>
virtual  Standard_Boolean Value(const Standard_Real T,Standard_Real& THeigth) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real MiddleHeigth;
Standard_Real GeometricSlope;
Standard_Real LengthSliding;


};


#include <FairCurve_BattenLaw.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
