// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom2dHatch_Intersector_HeaderFile
#define _Geom2dHatch_Intersector_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Geom2dInt_GInter_HeaderFile
#include <Geom2dInt_GInter.hxx>
#endif
class Geom2dAdaptor_Curve;
class gp_Lin2d;
class gp_Dir2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class Geom2dHatch_Intersector  : public Geom2dInt_GInter {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 
//! Creates an intersector. <br>
Geom2dHatch_Intersector(const Standard_Real Confusion,const Standard_Real Tangency);
//! Returns the confusion tolerance of the <br>
//!          intersector. <br>
  Standard_Real ConfusionTolerance() const;
//! Sets the confusion tolerance of the intersector. <br>
  void SetConfusionTolerance(const Standard_Real Confusion) ;
//! Returns the tangency tolerance of the <br>
//!          intersector. <br>
  Standard_Real TangencyTolerance() const;
//! Sets the tangency tolerance of the intersector. <br>
  void SetTangencyTolerance(const Standard_Real Tangency) ;
//! Intersects the curves C1 and C2. <br>
//!          The results are retreived by the usual methods <br>
//!          described in IntRes2d_Intersection. <br>//! Creates an intersector. <br>
  void Intersect(const Geom2dAdaptor_Curve& C1,const Geom2dAdaptor_Curve& C2) ;


Standard_EXPORT Geom2dHatch_Intersector();

//! Performs the intersection   between the  2d   line <br>
//!          segment (<L>, <P>) and  the  Curve <E>.  The  line <br>
//!          segment  is the  part  of  the  2d   line   <L> of <br>
//!          parameter range [0, <P>] (P is positive and can be <br>
//!          RealLast()). Tol is the  Tolerance on the segment. <br>
//!          The order  is relevant, the  first argument is the <br>
//!          segment, the second the Edge. <br>
Standard_EXPORT   void Perform(const gp_Lin2d& L,const Standard_Real P,const Standard_Real Tol,const Geom2dAdaptor_Curve& E) ;

//! Returns in <T>,  <N> and <C>  the tangent,  normal <br>
//!          and  curvature of the edge  <E> at parameter value <br>
//!          <U>. <br>
Standard_EXPORT   void LocalGeometry(const Geom2dAdaptor_Curve& E,const Standard_Real U,gp_Dir2d& T,gp_Dir2d& N,Standard_Real& C) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real myConfusionTolerance;
Standard_Real myTangencyTolerance;


};


#include <Geom2dHatch_Intersector.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
