// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GeomLib_MakeCurvefromApprox_HeaderFile
#define _GeomLib_MakeCurvefromApprox_HeaderFile

#ifndef _AdvApprox_ApproxAFunction_HeaderFile
#include <AdvApprox_ApproxAFunction.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Geom2d_BSplineCurve_HeaderFile
#include <Handle_Geom2d_BSplineCurve.hxx>
#endif
#ifndef _Handle_Geom_BSplineCurve_HeaderFile
#include <Handle_Geom_BSplineCurve.hxx>
#endif
class StdFail_NotDone;
class Standard_OutOfRange;
class AdvApprox_ApproxAFunction;
class Geom2d_BSplineCurve;
class Geom_BSplineCurve;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! this class is used to  construct the BSpline curve <br>
//!          from an Approximation ( ApproxAFunction from AdvApprox). <br>
class GeomLib_MakeCurvefromApprox  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT GeomLib_MakeCurvefromApprox(const AdvApprox_ApproxAFunction& Approx);

  Standard_Boolean IsDone() const;

//! returns the number of 1D spaces of the Approx <br>
Standard_EXPORT   Standard_Integer Nb1DSpaces() const;

//! returns the number of 3D spaces of the Approx <br>
Standard_EXPORT   Standard_Integer Nb2DSpaces() const;

//! returns the number of 3D spaces of the Approx <br>
Standard_EXPORT   Standard_Integer Nb3DSpaces() const;

//! returns a polynomial curve whose poles correspond to <br>
//! the Index2d 2D space <br>//! if Index2d not in the Range [1,Nb2dSpaces] <br>//! if the Approx is not Done <br>
Standard_EXPORT   Handle_Geom2d_BSplineCurve Curve2d(const Standard_Integer Index2d) const;

//! returns a 2D curve building it from the 1D curve <br>
//!          in x at Index1d and y at Index2d amongst the <br>
//!          1D curves <br>//! if Index1d not in the Range [1,Nb1dSpaces] <br>
//!          if Index2d not in the Range [1,Nb1dSpaces] <br>//! if the Approx is not Done <br>
Standard_EXPORT   Handle_Geom2d_BSplineCurve Curve2dFromTwo1d(const Standard_Integer Index1d,const Standard_Integer Index2d) const;

//! returns a rational curve whose poles correspond to <br>
//! the index2d of the 2D space and whose weights correspond <br>
//! to one dimensional space of index 1d <br>//! if Index1d not in the Range [1,Nb1dSpaces] <br>
//!          if Index2d not in the Range [1,Nb2dSpaces] <br>//! if the Approx is not Done <br>
Standard_EXPORT   Handle_Geom2d_BSplineCurve Curve2d(const Standard_Integer Index1d,const Standard_Integer Index2d) const;

//!  returns a polynomial curve whose poles correspond to <br>
//! the Index3D 3D space <br>//! if Index3D not in the Range [1,Nb3dSpaces] <br>//! if the Approx is not Done <br>
Standard_EXPORT   Handle_Geom_BSplineCurve Curve(const Standard_Integer Index3d) const;

//! returns a rational curve whose poles correspond to <br>
//! the index3D of the 3D space and whose weights correspond <br>
//! to the index1d 1D space. <br>//! if Index1D not in the Range [1,Nb1dSpaces] <br>
//!          if Index3D not in the Range [1,Nb3dSpaces] <br>//! if the Approx is not Done <br>
Standard_EXPORT   Handle_Geom_BSplineCurve Curve(const Standard_Integer Index1D,const Standard_Integer Index3D) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
AdvApprox_ApproxAFunction myApprox;


};


#include <GeomLib_MakeCurvefromApprox.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
