// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Graphic2d_Line_HeaderFile
#define _Graphic2d_Line_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Graphic2d_Line_HeaderFile
#include <Handle_Graphic2d_Line.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Graphic2d_TypeOfPolygonFilling_HeaderFile
#include <Graphic2d_TypeOfPolygonFilling.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Graphic2d_Primitive_HeaderFile
#include <Graphic2d_Primitive.hxx>
#endif
#ifndef _Handle_Graphic2d_GraphicObject_HeaderFile
#include <Handle_Graphic2d_GraphicObject.hxx>
#endif
#ifndef _Handle_Graphic2d_Drawer_HeaderFile
#include <Handle_Graphic2d_Drawer.hxx>
#endif
#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
#ifndef _Aspect_FStream_HeaderFile
#include <Aspect_FStream.hxx>
#endif
#ifndef _Aspect_IFStream_HeaderFile
#include <Aspect_IFStream.hxx>
#endif
class Graphic2d_GraphicObject;
class Graphic2d_Drawer;
class TShort_Array1OfShortReal;


//! Groups all the primitives which behaves like <br>
//!	    geometrical lines. <br>
//!	    for example: Polyline, Circle ... <br>
class Graphic2d_Line : public Graphic2d_Primitive {

public:
 // Methods PUBLIC
 // 

//! Defines the index, in the width map, of the line width. <br>
//!  Warning: Note that the index 0 can be undefined as a WidthMapEntry, <br>
//!	    in this case the default line width of 1 pixel is taken. <br>
Standard_EXPORT   void SetWidthIndex(const Standard_Integer anIndex) ;

//! Defines the index, in the type map, of the line type. <br>
//!  Warning: Note that the index 0 can be undefined as a TypeMapEntry, <br>
//!  	    in this case the default line type SOLID is taken. <br>
Standard_EXPORT   void SetTypeIndex(const Standard_Integer anIndex) ;

//! Defines the index, in the color map, of the interior <br>
//!	    color. <br>
//!  Warning: The type of polygon filling must be : <br>
//!		Graphic2d_TOPF_FILLED <br>
Standard_EXPORT   void SetInteriorColorIndex(const Standard_Integer anIndex) ;

//! Defines if the edges are drawn or not. <br>
//!  Warning: The type of polygon filling must be : <br>
//!		Graphic2d_TOPF_FILLED or <br>
//!		Graphic2d_TOPF_PATTERNED <br>
Standard_EXPORT   void SetDrawEdge(const Standard_Boolean aDraw) ;

//! Defines the pattern for closed lines. <br>
//!  Warning: The type of polygon filling must be : <br>
//!		Graphic2d_TOPF_PATTERNED <br>
Standard_EXPORT   void SetInteriorPattern(const Standard_Integer anIndex) ;

//! Defines the pattern for closed lines. <br>
//!	TypeOfPolygonFilling is : <br>
//!		- Graphic2d_TOPF_EMPTY <br>
//!		- Graphic2d_TOPF_FILLED <br>
//!		- Graphic2d_TOPF_PATTERNED <br>
Standard_EXPORT   void SetTypeOfPolygonFilling(const Graphic2d_TypeOfPolygonFilling aType) ;

//! Returns the interior color used. <br>
Standard_EXPORT   Standard_Integer InteriorColorIndex() const;

//! Returns the interior pattern used. <br>
Standard_EXPORT   Standard_Integer InteriorPattern() const;

//! Returns the type of polygon filling used. <br>
Standard_EXPORT   Graphic2d_TypeOfPolygonFilling TypeOfPolygonFilling() const;

//! Returns the line type index used. <br>
Standard_EXPORT   Standard_Integer TypeIndex() const;

//! Returns the line width index used. <br>
Standard_EXPORT   Standard_Integer WidthIndex() const;


Standard_EXPORT   void Save(Aspect_FStream& aFStream) const;


Standard_EXPORT   void Retrieve(Aspect_IFStream& anIFStream) ;
//Standard_EXPORT ~Graphic2d_Line();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Defines a line with the following default values : <br>
//!		- Color Index = 1 (the first user defined color) <br>
//!		- Width Index = 0 (default 1 pixel width) <br>
//!		- Type Index = 0  (default solid line) <br>
//!		- Draw Edge = Standard_True <br>
//!		- Type Of Polygon Filling = Graphic2d_TOPF_EMPTY <br>
//!		- Pattern Index = 0 (default solid polygon filling) <br>
//!		- Interior Color Index = 1 (the first user defined color) <br>
Standard_EXPORT Graphic2d_Line(const Handle(Graphic2d_GraphicObject)& aGraphicObject);

//! Sets line attributes and polyline attributes <br>
//!	    in the drawer <aDrawer>. <br>
Standard_EXPORT   void DrawLineAttrib(const Handle(Graphic2d_Drawer)& aDrawer) const;

//! Sets marker attributes -in the drawer <aDrawer>. <br>
Standard_EXPORT   void DrawMarkerAttrib(const Handle(Graphic2d_Drawer)& aDrawer) const;

//! Returns Standard_True if (<aX>, <aY>) belongs to <br>
//!	    the segment (<aX1>, <aY1>), (<aX2>, <aY2>). <br>
Standard_EXPORT static  Standard_Boolean IsOn(const Standard_ShortReal aX,const Standard_ShortReal aY,const Standard_ShortReal aX1,const Standard_ShortReal aY1,const Standard_ShortReal aX2,const Standard_ShortReal aY2,const Standard_ShortReal aPrecision) ;

//! Returns Standard_True if (<aX>, <aY>) is inside the <br>
//!	    wire defined by the array <X> and <Y>. <br>
Standard_EXPORT static  Standard_Boolean IsIn(const Standard_ShortReal aX,const Standard_ShortReal aY,const TShort_Array1OfShortReal& X,const TShort_Array1OfShortReal& Y,const Standard_ShortReal aPrecision) ;


 // Fields PROTECTED
 //
Graphic2d_TypeOfPolygonFilling myTypeOfPolygonFilling;
Standard_Boolean myDrawEdge;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer myWidthIndex;
Standard_Integer myTypeIndex;
Standard_Integer myPatternIndex;
Standard_Integer myInteriorColorIndex;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
