// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _HLRAlgo_EdgeIterator_HeaderFile
#define _HLRAlgo_EdgeIterator_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class HLRAlgo_EdgeStatus;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class HLRAlgo_EdgeIterator  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Iterator  on the  visible or  hidden  parts of  an <br>
//!          edge. <br>
Standard_EXPORT HLRAlgo_EdgeIterator();


Standard_EXPORT   void InitHidden(const HLRAlgo_EdgeStatus& status) ;

  Standard_Boolean MoreHidden() const;


Standard_EXPORT   void NextHidden() ;
//! Returns the bounds and the tolerances <br>
//!          of the current Hidden Interval <br>
  void Hidden(Standard_Real& Start,Standard_ShortReal& TolStart,Standard_Real& End,Standard_ShortReal& TolEnd) const;

  void InitVisible(const HLRAlgo_EdgeStatus& status) ;

  Standard_Boolean MoreVisible() const;

  void NextVisible() ;
//! Returns the bounds and the tolerances <br>
//!          of the current Visible Interval <br>
  void Visible(Standard_Real& Start,Standard_ShortReal& TolStart,Standard_Real& End,Standard_ShortReal& TolEnd) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer myNbVis;
Standard_Integer myNbHid;
Standard_Address EVis;
Standard_Address EHid;
Standard_Integer iVis;
Standard_Integer iHid;
Standard_Real myHidStart;
Standard_Real myHidEnd;
Standard_ShortReal myHidTolStart;
Standard_ShortReal myHidTolEnd;


};


#include <HLRAlgo_EdgeIterator.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
