// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESGeom_TabulatedCylinder_HeaderFile
#define _IGESGeom_TabulatedCylinder_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESGeom_TabulatedCylinder_HeaderFile
#include <Handle_IGESGeom_TabulatedCylinder.hxx>
#endif

#ifndef _Handle_IGESData_IGESEntity_HeaderFile
#include <Handle_IGESData_IGESEntity.hxx>
#endif
#ifndef _gp_XYZ_HeaderFile
#include <gp_XYZ.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
class IGESData_IGESEntity;
class gp_XYZ;
class gp_Pnt;


//! defines IGESTabulatedCylinder, Type <122> Form <0> <br>
//!          in package IGESGeom <br>
//!          A tabulated cylinder is a surface formed by moving a line <br>
//!          segment called generatrix parallel to itself along a curve <br>
//!          called directrix. The curve may be a line, circular arc, <br>
//!          conic arc, parametric spline curve, rational B-spline <br>
//!          curve or composite curve. <br>
class IGESGeom_TabulatedCylinder : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESGeom_TabulatedCylinder();

//! This method is used to set the fields of the class <br>
//!           TabulatedCylinder <br>
//!       - aDirectrix : Directrix Curve of the tabulated cylinder <br>
//!       - anEnd      : Coordinates of the terminate point of the <br>
//!                      generatrix <br>
//! The start point of the directrix is identical to the start <br>
//! point of the generatrix <br>
Standard_EXPORT   void Init(const Handle(IGESData_IGESEntity)& aDirectrix,const gp_XYZ& anEnd) ;

//! returns the directrix curve of the tabulated cylinder <br>
Standard_EXPORT   Handle_IGESData_IGESEntity Directrix() const;

//! returns end point of generatrix of the tabulated cylinder <br>
Standard_EXPORT   gp_Pnt EndPoint() const;

//! returns end point of generatrix of the tabulated cylinder <br>
//! after applying Transf. Matrix <br>
Standard_EXPORT   gp_Pnt TransformedEndPoint() const;
//Standard_EXPORT ~IGESGeom_TabulatedCylinder();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_IGESData_IGESEntity theDirectrix;
gp_XYZ theEnd;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
