// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Interface_BitMap_HeaderFile
#define _Interface_BitMap_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfAsciiString_HeaderFile
#include <Handle_TColStd_HSequenceOfAsciiString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
class TColStd_HArray1OfInteger;
class TColStd_HSequenceOfAsciiString;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! A bit map simply allows to associate a boolean flag to each <br>
//!           item of a list, such as a list of entities, etc... numbered <br>
//!           between 1 and a positive count nbitems <br>
//! <br>
//!           The BitMap class allows to associate several binary flags, <br>
//!           each of one is identified by a number from 0 to a count <br>
//!           which can remain at zero or be positive : nbflags <br>
//! <br>
//!           Flags lists over than numflag=0 are added after creation <br>
//!           Each of one can be named, hence the user can identify it <br>
//!           either by its flag number or by a name which gives a flag n0 <br>
//!           (flag n0 0 has no name) <br>
class Interface_BitMap  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a BitMap for <nbitems> items <br>
//!           One flag is defined, n0 0 <br>
//!           <resflags> prepares allocation for <resflags> more flags <br>
//!           Flags values start at false <br>
Standard_EXPORT Interface_BitMap(const Standard_Integer nbitems,const Standard_Integer resflags = 0);

//! Creates a BitMap from another one <br>
//!           if <copied> is True, copies data <br>
//!           else, data are not copied, only the header object is <br>
Standard_EXPORT Interface_BitMap(const Interface_BitMap& other,const Standard_Boolean copied = Standard_False);

//! Returns internal values, used for copying <br>
//!           Flags values start at false <br>
Standard_EXPORT   void Internals(Standard_Integer& nbitems,Standard_Integer& nbwords,Standard_Integer& nbflags,Handle(TColStd_HArray1OfInteger)& flags,Handle(TColStd_HSequenceOfAsciiString)& names) const;

//! Reservates for a count of more flags <br>
Standard_EXPORT   void Reservate(const Standard_Integer moreflags) ;

//! Sets for a new count of items, which can be either less or <br>
//!           greater than the former one <br>
//!           For new items, their flags start at false <br>
Standard_EXPORT   void SetLength(const Standard_Integer nbitems) ;

//! Adds a flag, a name can be attached to it <br>
//!           Returns its flag number <br>
//!           Makes required reservation <br>
Standard_EXPORT   Standard_Integer AddFlag(const Standard_CString name = "") ;

//! Adds several flags (<more>) with no name <br>
//!           Returns the number of last added flag <br>
Standard_EXPORT   Standard_Integer AddSomeFlags(const Standard_Integer more) ;

//! Removes a flag given its number. <br>
//!           Returns True if done, false if num is out of range <br>
Standard_EXPORT   Standard_Boolean RemoveFlag(const Standard_Integer num) ;

//! Sets a name for a flag, given its number <br>
//!           name can be empty (to erase the name of a flag) <br>
//!           Returns True if done, false if : num is out of range, or <br>
//!           name non-empty already set to another flag <br>
Standard_EXPORT   Standard_Boolean SetFlagName(const Standard_Integer num,const Standard_CString name) ;

//! Returns the count of flags (flag 0 not included) <br>
Standard_EXPORT   Standard_Integer NbFlags() const;

//! Returns the count of items (i.e. the length of the bitmap) <br>
Standard_EXPORT   Standard_Integer Length() const;

//! Returns the name recorded for a flag, or an empty string <br>
Standard_EXPORT   Standard_CString FlagName(const Standard_Integer num) const;

//! Returns the number or a flag given its name, or zero <br>
Standard_EXPORT   Standard_Integer FlagNumber(const Standard_CString name) const;

//! Returns the value (true/false) of a flag, from : <br>
//!           - the number of the item <br>
//!           - the flag number, by default 0 <br>
Standard_EXPORT   Standard_Boolean Value(const Standard_Integer item,const Standard_Integer flag = 0) const;

//! Sets a new value for a flag <br>
Standard_EXPORT   void SetValue(const Standard_Integer item,const Standard_Boolean val,const Standard_Integer flag = 0) const;

//! Sets a flag to True <br>
Standard_EXPORT   void SetTrue(const Standard_Integer item,const Standard_Integer flag = 0) const;

//! Sets a flag to False <br>
Standard_EXPORT   void SetFalse(const Standard_Integer item,const Standard_Integer flag = 0) const;

//! Returns the former value for a flag and sets it to True <br>
//!           (before : value returned; after : True) <br>
Standard_EXPORT   Standard_Boolean CTrue(const Standard_Integer item,const Standard_Integer flag = 0) const;

//! Returns the former value for a flag and sets it to False <br>
//!           (before : value returned; after : False) <br>
Standard_EXPORT   Standard_Boolean CFalse(const Standard_Integer item,const Standard_Integer flag = 0) const;

//! Initialises all the values of Flag Number <flag> to a given <br>
//!           value <val> <br>
Standard_EXPORT   void Init(const Standard_Boolean val,const Standard_Integer flag = 0) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer thenbitems;
Standard_Integer thenbwords;
Standard_Integer thenbflags;
Handle_TColStd_HArray1OfInteger theflags;
Handle_TColStd_HSequenceOfAsciiString thenames;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
