// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Interface_Static_HeaderFile
#define _Interface_Static_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Interface_Static_HeaderFile
#include <Handle_Interface_Static.hxx>
#endif

#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Interface_ParamType_HeaderFile
#include <Interface_ParamType.hxx>
#endif
#ifndef _Handle_Standard_Type_HeaderFile
#include <Handle_Standard_Type.hxx>
#endif
#ifndef _Handle_Interface_Static_HeaderFile
#include <Handle_Interface_Static.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfAsciiString_HeaderFile
#include <Handle_TColStd_HArray1OfAsciiString.hxx>
#endif
#ifndef _Handle_Dico_DictionaryOfInteger_HeaderFile
#include <Handle_Dico_DictionaryOfInteger.hxx>
#endif
#ifndef _Interface_StaticSatisfies_HeaderFile
#include <Interface_StaticSatisfies.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Interface_TypedValue_HeaderFile
#include <Interface_TypedValue.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
#ifndef _Standard_Character_HeaderFile
#include <Standard_Character.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfHAsciiString_HeaderFile
#include <Handle_TColStd_HSequenceOfHAsciiString.hxx>
#endif
class Standard_Type;
class TColStd_HArray1OfAsciiString;
class Dico_DictionaryOfInteger;
class TCollection_HAsciiString;
class Standard_Transient;
class Interface_InterfaceError;
class TColStd_HSequenceOfHAsciiString;


//! This class gives a way to manage meaningfull static variables, <br>
//!           used as "global" parameters in various procedures. <br>
//! <br>
//!           A Static brings a specification (its type, constraints if any) <br>
//!           and a value. Its basic form is a string, it can be specified <br>
//!           as integer or real or enumerative string, and queried as such. <br>
//!           Its string content, which is a Handle(HAsciiString) can be <br>
//!           shared by other data structures, hence gives a direct on line <br>
//!           access to its value. <br>
//! <br>
//!           All this description is inherited from TypedValue <br>
//! <br>
//!           A Static can be given an initial value, it can be filled from, <br>
//!           either a set of Resources (an applicative feature which <br>
//!           accesses and manages parameter files), or environment or <br>
//!           internal definition : these define families of Static. <br>
//!           In addition, it supports a status for reinitialisation : an <br>
//!           initialisation procedure can ask if the value of the Static <br>
//!           has changed from its last call, in this case does something <br>
//!           then marks the Status "uptodate", else it does nothing. <br>
//! <br>
//!           Statics are named and recorded then accessed in an alphabetic <br>
//!           dictionary <br>
class Interface_Static : public Interface_TypedValue {

public:
 // Methods PUBLIC
 // 

//! Creates and records a Static, with a family and a name <br>
//!           family can report to a name of ressource or to a system or <br>
//!           internal definition. The name must be unique. <br>
//! <br>
//!           type gives the type of the parameter, default is free text <br>
//!           Also available : Integer, Real, Enum, Entity (i.e. Object) <br>
//!           More precise specifications, titles, can be given to the <br>
//!           Static once created <br>
//! <br>
//!           init gives an initial value. If it is not given, the Static <br>
//!           begin as "not set", its value is empty <br>
Standard_EXPORT Interface_Static(const Standard_CString family,const Standard_CString name,const Interface_ParamType type = Interface_ParamText,const Standard_CString init = "");

//! Creates a new Static with same definition as another one <br>
//!           (value is copied, except for Entity : it remains null) <br>
Standard_EXPORT Interface_Static(const Standard_CString family,const Standard_CString name,const Handle(Interface_Static)& other);

//! Writes the properties of a <br>
//! parameter in the diagnostic file. These include: <br>
//! - Name <br>
//! - Family, <br>
//! - Wildcard (if it has one) <br>
//! - Current status (empty  string if it was updated or <br>
//!   if it is the original one) <br>
//! - Value <br>
Standard_EXPORT   void PrintStatic(Standard_OStream& S) const;

//! Returns the family. It can be : a resource name for applis, <br>
//!           an internal name between : $e (environment variables), <br>
//!           $l (other, purely local) <br>
Standard_EXPORT   Standard_CString Family() const;

//! Sets a "wild-card" static : its value will be considered <br>
//!           if <me> is not properly set. (reset by set a null one) <br>
Standard_EXPORT   void SetWild(const Handle(Interface_Static)& wildcard) ;

//! Returns the wildcard static, which can be (is most often) null <br>
Standard_EXPORT   Handle_Interface_Static Wild() const;

//! Records a Static has "uptodate", i.e. its value has been taken <br>
//!           into account by a reinitialisation procedure <br>
//!           This flag is reset at each successful SetValue <br>
Standard_EXPORT   void SetUptodate() ;

//! Returns the status "uptodate" <br>
Standard_EXPORT   Standard_Boolean UpdatedStatus() const;

//! Declares a new Static (by calling its constructor) <br>
//!           If this name is already taken, does nothing and returns False <br>
//!           Else, creates it and returns True <br>
//!           For additional definitions, get the Static then edit it <br>
Standard_EXPORT static  Standard_Boolean Init(const Standard_CString family,const Standard_CString name,const Interface_ParamType type = Interface_ParamText,const Standard_CString init = "") ;

//! As Init with ParamType, but type is given as a character <br>
//!           This allows a simpler call <br>
//!           Types : 'i' Integer, 'r' Real, 't' Text, 'e' Enum, 'o' Object <br>
//!           '=' for same definition as, <init> gives the initial Static <br>
//!           Returns False if <type> does not match this list <br>
Standard_EXPORT static  Standard_Boolean Init(const Standard_CString family,const Standard_CString name,const Standard_Character type = 't',const Standard_CString init = "") ;

//! Returns a Static from its name. Null Handle if not present <br>
Standard_EXPORT static  Handle_Interface_Static Static(const Standard_CString name) ;

//! Returns True if a Static named <name> is present, False else <br>
Standard_EXPORT static  Standard_Boolean IsPresent(const Standard_CString name) ;

//! Returns a part of the definition of a Static, as a CString <br>
//!           The part is designated by its name, as a CString <br>
//!           If the required value is not a string, it is converted to a <br>
//!           CString then returned <br>
//!           If <name> is not present, or <part> not defined for <name>, <br>
//!           this function returns an empty string <br>
//! <br>
//!           Allowed parts for CDef : <br>
//!             family : the family <br>
//!             type  : the type ("integer","real","text","enum") <br>
//!             label : the label <br>
//!             satis : satisfy function name if any <br>
//!             rmin : minimum real value <br>
//!             rmax : maximum real value <br>
//!             imin : minimum integer value <br>
//!             imax : maximum integer value <br>
//!             enum nn (nn : value of an integer) : enum value for nn <br>
//!             unit : unit definition for a real <br>
Standard_EXPORT static  Standard_CString CDef(const Standard_CString name,const Standard_CString part) ;

//! Returns a part of the definition of a Static, as an Integer <br>
//!           The part is designated by its name, as a CString <br>
//!           If the required value is not a string, returns zero <br>
//!           For a Boolean, 0 for false, 1 for true <br>
//!           If <name> is not present, or <part> not defined for <name>, <br>
//!           this function returns zero <br>
//! <br>
//!           Allowed parts for IDef : <br>
//!             imin, imax : minimum or maximum integer value <br>
//!             estart : starting number for enum <br>
//!             ecount : count of enum values (starting from estart) <br>
//!             ematch : exact match status <br>
//!             eval val : case determined from a string <br>
Standard_EXPORT static  Standard_Integer IDef(const Standard_CString name,const Standard_CString part) ;

//! Returns True if <name> is present AND set <br>
//!           <proper> True (D) : considers this item only <br>
//!           <proper> False    : if not set and attached to a wild-card, <br>
//!             considers this wild-card <br>
Standard_EXPORT static  Standard_Boolean IsSet(const Standard_CString name,const Standard_Boolean proper = Standard_True) ;

//! Returns the value of the <br>
//! parameter identified by the string name. <br>
//! If the specified parameter does not exist, an empty <br>
//! string is returned. <br>
//! Example <br>
//! Interface_Static::CVal("write.step.schema"); <br>
//! which could return: <br>
//! "AP214" <br>
Standard_EXPORT static  Standard_CString CVal(const Standard_CString name) ;

//!  Returns the integer value of <br>
//! the translation parameter identified by the string name. <br>
//! Returns the value 0 if the parameter does not exist. <br>
//! Example <br>
//! Interface_Static::IVal("write.step.schema"); <br>
//! which could return: 3 <br>
Standard_EXPORT static  Standard_Integer IVal(const Standard_CString name) ;

//!  Returns the value of a static <br>
//! translation parameter identified by the string name. <br>
//! Returns the value 0.0 if the parameter does not exist. <br>
Standard_EXPORT static  Standard_Real RVal(const Standard_CString name) ;

//! Modifies the value of the <br>
//! parameter identified by name. The modification is specified <br>
//! by the string val. false is returned if the parameter does not exist. <br>
//! Example <br>
//! Interface_Static::SetCVal <br>
//! ("write.step.schema","AP203") <br>
//! This syntax specifies a switch from the default STEP 214 mode to STEP 203 mode. <br>
Standard_EXPORT static  Standard_Boolean SetCVal(const Standard_CString name,const Standard_CString val) ;

//! Modifies the value of the <br>
//! parameter identified by name. The modification is specified <br>
//! by the integer value val. false is returned if the <br>
//! parameter does not exist. <br>
//! Example <br>
//! Interface_Static::SetIVal <br>
//! ("write.step.schema", 3) <br>
//! This syntax specifies a switch from the default STEP 214 mode to STEP 203 mode.S <br>
Standard_EXPORT static  Standard_Boolean SetIVal(const Standard_CString name,const Standard_Integer val) ;

//!  Modifies the value of a <br>
//! translation parameter. false is returned if the <br>
//! parameter does not exist. The modification is specified <br>
//! by the real number value val. <br>
Standard_EXPORT static  Standard_Boolean SetRVal(const Standard_CString name,const Standard_Real val) ;

//! Sets a Static to be "uptodate" <br>
//!           Returns False if <name> is not present <br>
//!           This status can be used by a reinitialisation procedure to <br>
//!           rerun if a value has been changed <br>
Standard_EXPORT static  Standard_Boolean Update(const Standard_CString name) ;

//! Returns the status "uptodate" from a Static <br>
//!           Returns False if <name> is not present <br>
Standard_EXPORT static  Standard_Boolean IsUpdated(const Standard_CString name) ;

//! Returns a list of names of statics : <br>
//!           <mode> = 0 (D) : criter is for family <br>
//!           <mode> = 1 : criter is regexp on names, takes final items <br>
//!             (ignore wild cards) <br>
//!           <mode> = 2 : idem but take only wilded, not final items <br>
//!           <mode> = 3 : idem, take all items matching criter <br>
//!           idem + 100 : takes only non-updated items <br>
//!           idem + 200 : takes only updated items <br>
//!           criter empty (D) : returns all names <br>
//!           else returns names which match the given criter <br>
//!           Remark : families beginning by '$' are not listed by criter "" <br>
//!           they are listed only by criter "$" <br>
//! <br>
//!           This allows for instance to set new values after having loaded <br>
//!           or reloaded a resource, then to update them as required <br>
Standard_EXPORT static  Handle_TColStd_HSequenceOfHAsciiString Items(const Standard_Integer mode = 0,const Standard_CString criter = "") ;

//! Initializes all standard static parameters, which can be used <br>
//!           by every function. statics specific of a norm or a function <br>
//!           must be defined around it <br>
Standard_EXPORT static  void Standards() ;
//Standard_EXPORT ~Interface_Static();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TCollection_AsciiString thefamily;
TCollection_AsciiString thename;
TCollection_AsciiString thelabel;
Interface_ParamType thetype;
Handle_Standard_Type theotyp;
Handle_Interface_Static thewild;
Standard_Integer thelims;
Standard_Integer theintlow;
Standard_Integer theintup;
Standard_Real therealow;
Standard_Real therealup;
TCollection_AsciiString theunidef;
Handle_TColStd_HArray1OfAsciiString theenums;
Handle_Dico_DictionaryOfInteger theeadds;
Interface_StaticSatisfies thesatisf;
TCollection_AsciiString thesatisn;
Standard_Boolean theupdate;
Standard_Integer theival;
Handle_TCollection_HAsciiString thehval;
Handle_Standard_Transient theoval;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
