// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TDF_AttributeDelta_HeaderFile
#define _TDF_AttributeDelta_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_TDF_AttributeDelta_HeaderFile
#include <Handle_TDF_AttributeDelta.hxx>
#endif

#ifndef _Handle_TDF_Attribute_HeaderFile
#include <Handle_TDF_Attribute.hxx>
#endif
#ifndef _TDF_Label_HeaderFile
#include <TDF_Label.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class TDF_Attribute;
class TDF_Label;
class Standard_GUID;


//! This class discribes the services we need to <br>
//!           implement Delta and Undo/Redo services. <br>
//! <br>
//!          AttributeDeltas are applied in an unpredictable <br>
//!          order. But by the redefinition of the method <br>
//!          IsNowApplicable, a condition can be verified <br>
//!          before application. If the AttributeDelta is not <br>
//!          yet applicable, it is put at the end of the <br>
//!          AttributeDelta list, to be treated later. If a <br>
//!          dead lock if found on the list, the <br>
//!          AttributeDeltas are forced to be applied in an <br>
//!          unpredictable order. <br>
class TDF_AttributeDelta : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Applies the delta to the attribute. <br>
Standard_EXPORT virtual  void Apply()  = 0;

//! Returns the label concerned by <me>. <br>
Standard_EXPORT   TDF_Label Label() const;

//! Returns the reference attribute. <br>
Standard_EXPORT   Handle_TDF_Attribute Attribute() const;

//! Returns the ID of the attribute concerned by <me>. <br>
Standard_EXPORT   Standard_GUID ID() const;

//! Dumps the contents. <br>
//! <br>
Standard_EXPORT virtual  Standard_OStream& Dump(Standard_OStream& OS) const;
  Standard_OStream& operator<<(Standard_OStream& OS) const
{
  return Dump(OS);
}

//Standard_EXPORT ~TDF_AttributeDelta();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


Standard_EXPORT TDF_AttributeDelta(const Handle(TDF_Attribute)& anAttribute);


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TDF_Attribute myAttribute;
TDF_Label myLabel;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
