// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TNaming_NamedShape_HeaderFile
#define _TNaming_NamedShape_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_TNaming_NamedShape_HeaderFile
#include <Handle_TNaming_NamedShape.hxx>
#endif

#ifndef _TNaming_PtrNode_HeaderFile
#include <TNaming_PtrNode.hxx>
#endif
#ifndef _TNaming_Evolution_HeaderFile
#include <TNaming_Evolution.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TDF_Attribute_HeaderFile
#include <TDF_Attribute.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_TDF_Attribute_HeaderFile
#include <Handle_TDF_Attribute.hxx>
#endif
#ifndef _Handle_TDF_DeltaOnModification_HeaderFile
#include <Handle_TDF_DeltaOnModification.hxx>
#endif
#ifndef _Handle_TDF_DeltaOnRemoval_HeaderFile
#include <Handle_TDF_DeltaOnRemoval.hxx>
#endif
#ifndef _Handle_TDF_RelocationTable_HeaderFile
#include <Handle_TDF_RelocationTable.hxx>
#endif
#ifndef _Handle_TDF_DataSet_HeaderFile
#include <Handle_TDF_DataSet.hxx>
#endif
#ifndef _Handle_TDF_AttributeDelta_HeaderFile
#include <Handle_TDF_AttributeDelta.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class TNaming_Builder;
class TNaming_Iterator;
class TNaming_NewShapeIterator;
class TNaming_OldShapeIterator;
class Standard_GUID;
class TopoDS_Shape;
class TDF_Attribute;
class TDF_DeltaOnModification;
class TDF_DeltaOnRemoval;
class TDF_RelocationTable;
class TDF_DataSet;
class TDF_AttributeDelta;


//! The basis to define an attribute for the storage of <br>
//! topology and naming data. <br>
//! This attribute contains two parts: <br>
//! -   The type of evolution, a term of the <br>
//!   enumeration TNaming_Evolution <br>
//! -   A list of pairs of shapes called the "old" <br>
//!   shape and the "new" shape. The meaning <br>
//!   depends on the type of evolution. <br>
class TNaming_NamedShape : public TDF_Attribute {

public:
 // Methods PUBLIC
 // 

//! class method <br>
//!          ============ <br>//! Returns the GUID for named shapes. <br>
Standard_EXPORT static const Standard_GUID& GetID() ;


Standard_EXPORT TNaming_NamedShape();


Standard_EXPORT   Standard_Boolean IsEmpty() const;

//! Returns the shapes contained in <NS>. Returns a null <br>
//!          shape if IsEmpty. <br>
Standard_EXPORT   TopoDS_Shape Get() const;
//! Returns the Evolution of the attribute. <br>
  TNaming_Evolution Evolution() const;
//! Returns the Version of the attribute. <br>
  Standard_Integer Version() const;
//! Set the Version of the attribute. <br>
  void SetVersion(const Standard_Integer version) ;


Standard_EXPORT   void Clear() ;
//! Returns the ID of the attribute. <br>
 const Standard_GUID& ID() const;

//! Copies  the attribute  contents into  a  new other <br>
//!          attribute. It is used by Backup(). <br>
Standard_EXPORT virtual  Handle_TDF_Attribute BackupCopy() const;

//! Restores the contents from <anAttribute> into this <br>
//!          one. It is used when aborting a transaction. <br>
//! <br>
Standard_EXPORT virtual  void Restore(const Handle(TDF_Attribute)& anAttribute) ;

//! Makes a DeltaOnModification between <me> and <br>
//!         <anOldAttribute. <br>
Standard_EXPORT virtual  Handle_TDF_DeltaOnModification DeltaOnModification(const Handle(TDF_Attribute)& anOldAttribute) const;

//! Applies a DeltaOnModification to <me>. <br>
Standard_EXPORT virtual  void DeltaOnModification(const Handle(TDF_DeltaOnModification)& aDelta) ;

//! Makes a DeltaOnRemoval on <me> because <me> has <br>
//!         disappeared from the DS. <br>
Standard_EXPORT virtual  Handle_TDF_DeltaOnRemoval DeltaOnRemoval() const;

//! Returns an new empty attribute from the good end <br>
//!          type. It is used by the copy algorithm. <br>
Standard_EXPORT virtual  Handle_TDF_Attribute NewEmpty() const;

//! This method is different from the "Copy" one, <br>
//!          because it is used when copying an attribute from <br>
//!          a source structure into a target structure. This <br>
//!          method pastes the current attribute to the label <br>
//!          corresponding to the insertor. The pasted <br>
//!          attribute may be a brand new one or a new version <br>
//!          of the previous one. <br>
Standard_EXPORT virtual  void Paste(const Handle(TDF_Attribute)& intoAttribute,const Handle(TDF_RelocationTable)& aRelocTationable) const;


Standard_EXPORT   void OldPaste(const Handle(TDF_Attribute)& intoAttribute,const Handle(TDF_RelocationTable)& aRelocTationable) const;

//! Adds the directly referenced attributes and labels <br>
//!          to <aDataSet>. "Directly" means we have only to <br>
//!          look at the first level of references. <br>
Standard_EXPORT virtual  void References(const Handle(TDF_DataSet)& aDataSet) const;


Standard_EXPORT virtual  void BeforeRemoval() ;

//! Something to do before applying <anAttDelta> <br>
Standard_EXPORT virtual  Standard_Boolean BeforeUndo(const Handle(TDF_AttributeDelta)& anAttDelta,const Standard_Boolean forceIt = Standard_False) ;

//! Something to do after applying <anAttDelta>. <br>
Standard_EXPORT virtual  Standard_Boolean AfterUndo(const Handle(TDF_AttributeDelta)& anAttDelta,const Standard_Boolean forceIt = Standard_False) ;

//! Dumps the attribute on <aStream>. <br>
Standard_EXPORT virtual  Standard_OStream& Dump(Standard_OStream& anOS) const;
//Standard_EXPORT ~TNaming_NamedShape();


friend class TNaming_Builder;
friend class TNaming_Iterator;
friend class TNaming_NewShapeIterator;
friend class TNaming_OldShapeIterator;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Adds an evolution <br>
Standard_EXPORT   void Add(TNaming_PtrNode& Evolution) ;


 // Fields PRIVATE
 //
TNaming_PtrNode myNode;
TNaming_Evolution myEvolution;
Standard_Integer myVersion;


};


#include <TNaming_NamedShape.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
