// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TPrsStd_ConstraintTools_HeaderFile
#define _TPrsStd_ConstraintTools_HeaderFile

#ifndef _Handle_TDataStd_Constraint_HeaderFile
#include <Handle_TDataStd_Constraint.hxx>
#endif
#ifndef _Handle_AIS_InteractiveObject_HeaderFile
#include <Handle_AIS_InteractiveObject.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom_Geometry_HeaderFile
#include <Handle_Geom_Geometry.hxx>
#endif
class TDataStd_Constraint;
class AIS_InteractiveObject;
class TCollection_ExtendedString;
class TopoDS_Shape;
class Geom_Geometry;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class TPrsStd_ConstraintTools  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT static  void UpdateOnlyValue(const Handle(TDataStd_Constraint)& aConst,const Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputeDistance(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputeParallel(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputeTangent(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputePerpendicular(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputeConcentric(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputeSymmetry(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputeMidPoint(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputeAngle(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputeRadius(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputeMinRadius(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputeMaxRadius(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputeEqualDistance(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputeEqualRadius(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputeFix(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputeDiameter(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputeOffset(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputePlacement(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputeCoincident(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputeRound(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputeOthers(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;


Standard_EXPORT static  void ComputeTextAndValue(const Handle(TDataStd_Constraint)& aConst,Standard_Real& aValue,TCollection_ExtendedString& aText,const Standard_Boolean anIsAngle) ;


Standard_EXPORT static  void ComputeAngleForOneFace(const Handle(TDataStd_Constraint)& aConst,Handle(AIS_InteractiveObject)& anAIS) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT static  void GetOneShape(const Handle(TDataStd_Constraint)& aConst,TopoDS_Shape& aShape) ;


Standard_EXPORT static  void GetGeom(const Handle(TDataStd_Constraint)& aConst,Handle(Geom_Geometry)& aGeom) ;


Standard_EXPORT static  void GetTwoShapes(const Handle(TDataStd_Constraint)& aConst,TopoDS_Shape& aShape1,TopoDS_Shape& aShape2) ;


Standard_EXPORT static  void GetShapesAndGeom(const Handle(TDataStd_Constraint)& aConst,TopoDS_Shape& aShape1,TopoDS_Shape& aShape2,Handle(Geom_Geometry)& aGeom) ;


Standard_EXPORT static  void GetShapesAndGeom(const Handle(TDataStd_Constraint)& aConst,TopoDS_Shape& aShape1,TopoDS_Shape& aShape2,TopoDS_Shape& aShape3,Handle(Geom_Geometry)& aGeom) ;


Standard_EXPORT static  void GetShapesAndGeom(const Handle(TDataStd_Constraint)& aConst,TopoDS_Shape& aShape1,TopoDS_Shape& aShape2,TopoDS_Shape& aShape3,TopoDS_Shape& aShape4,Handle(Geom_Geometry)& aGeom) ;


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
