// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopExp_Explorer_HeaderFile
#define _TopExp_Explorer_HeaderFile

#ifndef _TopExp_Stack_HeaderFile
#include <TopExp_Stack.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
class Standard_NoMoreObject;
class Standard_NoSuchObject;
class TopoDS_Shape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! An Explorer is a Tool to visit  a Topological Data <br>
//!          Structure form the TopoDS package. <br>
//! <br>
//!          An Explorer is built with : <br>
//! <br>
//!            * The Shape to explore. <br>
//! <br>
//!            * The type of Shapes to find : e.g VERTEX, EDGE. <br>
//!            This type cannot be SHAPE. <br>
//! <br>
//!            * The type of Shapes to avoid. e.g  SHELL, EDGE. <br>
//!            By default   this type is  SHAPE which  means no <br>
//!            restriction on the exploration. <br>
//! <br>
//! <br>
//!          The Explorer  visits  all the  structure   to find <br>
//!          shapes of the   requested  type  which   are   not <br>
//!          contained in the type to avoid. <br>
//! <br>
//!          Example to find all the Faces in the Shape S : <br>
//! <br>
//!          TopExp_Explorer Ex; <br>
//!          for (Ex.Init(S,TopAbs_FACE); Ex.More(); Ex.Next()) { <br>
//!            ProcessFace(Ex.Current()); <br>
//!            } <br>
//! <br>
//!          // an other way <br>
//!          TopExp_Explorer Ex(S,TopAbs_FACE); <br>
//!          while (Ex.More()) { <br>
//!            ProcessFace(Ex.Current()); <br>
//!            Ex.Next(); <br>
//!            } <br>
//! <br>
//!          To find all the vertices which are not in an edge : <br>
//! <br>
//!          for (Ex.Init(S,TopAbs_VERTEX,TopAbs_EDGE); ...) <br>
//! <br>
//! <br>
//!          To  find all the faces  in   a SHELL, then all the <br>
//!          faces not in a SHELL : <br>
//! <br>
//!          TopExp_Explorer Ex1, Ex2; <br>
//! <br>
//!          for (Ex1.Init(S,TopAbs_SHELL),...) { <br>
//!            // visit all shells <br>
//!            for (Ex2.Init(Ex1.Current(),TopAbs_FACE),...) { <br>
//!              // visit all the faces of the current shell <br>
//!              } <br>
//!            } <br>
//! <br>
//!          for (Ex1.Init(S,TopAbs_FACE,TopAbs_SHELL),...) { <br>
//!            // visit all faces not in a shell <br>
//!            } <br>
//! <br>
//! <br>
//!          If   the type  to avoid  is   the same  or is less <br>
//!          complex than the type to find it has no effect. <br>
//! <br>
//!          For example searching edges  not in a vertex  does <br>
//!          not make a difference. <br>
//! <br>
class TopExp_Explorer  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an empty explorer, becomes usefull after Init. <br>
Standard_EXPORT TopExp_Explorer();

//! Creates an Explorer on the Shape <S>. <br>
//! <br>
//!          <ToFind> is the type of shapes to search. <br>
//!              TopAbs_VERTEX, TopAbs_EDGE, ... <br>
//! <br>
//!          <ToAvoid>   is the type   of shape to  skip in the <br>
//!          exploration.   If   <ToAvoid>  is  equal  or  less <br>
//!          complex than <ToFind> or if  <ToAVoid> is SHAPE it <br>
//!          has no effect on the exploration. <br>
//! <br>
Standard_EXPORT TopExp_Explorer(const TopoDS_Shape& S,const TopAbs_ShapeEnum ToFind,const TopAbs_ShapeEnum ToAvoid = TopAbs_SHAPE);

//! Resets this explorer on the shape S. It is initialized to <br>
//! search the shape S, for shapes of type ToFind, that <br>
//! are not part of a shape ToAvoid. <br>
//! If the shape ToAvoid is equal to TopAbs_SHAPE, or <br>
//! if it is the same as, or less complex than, the shape <br>
//! ToFind it has no effect on the search. <br>
Standard_EXPORT   void Init(const TopoDS_Shape& S,const TopAbs_ShapeEnum ToFind,const TopAbs_ShapeEnum ToAvoid = TopAbs_SHAPE) ;
//! Returns  True if  there are   more  shapes in  the <br>
//!          exploration. <br>
  Standard_Boolean More() const;

//! Moves to the next Shape in the exploration. <br>
//! Exceptions <br>
//! Standard_NoMoreObject if there are no more shapes to explore. <br>
Standard_EXPORT   void Next() ;

//! Returns the current shape in the exploration. <br>
//! Exceptions <br>
//! Standard_NoSuchObject if this explorer has no more shapes to explore. <br>
Standard_EXPORT  const TopoDS_Shape& Current() const;

//! Reinitialize  the    exploration with the original <br>
//!          arguments. <br>
Standard_EXPORT   void ReInit() ;
//! Returns the current depth of the exploration. 0 is <br>
//!          the shape to explore itself. <br>
  Standard_Integer Depth() const;
//! Clears the content of the explorer. It will return <br>
//!          False on More(). <br>
  void Clear() ;


Standard_EXPORT   void Destroy() ;
~TopExp_Explorer()
{
  Destroy();
}






protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopExp_Stack myStack;
Standard_Integer myTop;
Standard_Integer mySizeOfStack;
TopoDS_Shape myShape;
Standard_Boolean hasMore;
TopAbs_ShapeEnum toFind;
TopAbs_ShapeEnum toAvoid;


};


#include <TopExp_Explorer.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
