// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Units_ShiftedToken_HeaderFile
#define _Units_ShiftedToken_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Units_ShiftedToken_HeaderFile
#include <Handle_Units_ShiftedToken.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Units_Token_HeaderFile
#include <Units_Token.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_Units_Dimensions_HeaderFile
#include <Handle_Units_Dimensions.hxx>
#endif
#ifndef _Handle_Units_Token_HeaderFile
#include <Handle_Units_Token.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Units_Dimensions;
class Units_Token;


//! The  ShiftedToken class  inherits   from Token and <br>
//!          describes tokens which have  a gap in  addition of <br>
//!          the  multiplicative factor.   This kind  of  token <br>
//!          allows  the  description of linear functions which <br>
//!          do not pass through the origin, of the form : <br>
//! <br>
//!           y = ax  +b <br>
//! <br>
//!          where <x> and  <y>  are the unknown variables, <a> <br>
//!          the mutiplicative factor, and <b> the gap relative <br>
//!          to the ordinate axis. <br>
//! <br>
//!          An example is the  tranlation between the  Celsius <br>
//!          and Fahrenheit degree of temperature. <br>
class Units_ShiftedToken : public Units_Token {

public:
 // Methods PUBLIC
 // 

//! Creates and returns a  shifted   token.  <aword> is  a <br>
//!          string containing the   available word, <amean>  gives <br>
//!          the signification   of the   token,  <avalue> is   the <br>
//!          numeric value  of the  dimension, <amove> is  the gap, <br>
//!          and <adimensions> is  the dimension of the given  word <br>
//!          <aword>. <br>
Standard_EXPORT Units_ShiftedToken(const Standard_CString aword,const Standard_CString amean,const Standard_Real avalue,const Standard_Real amove,const Handle(Units_Dimensions)& adimensions);

//! Creates and returns a  token, which is a ShiftedToken. <br>
Standard_EXPORT virtual  Handle_Units_Token Creates() const;

//! Returns the gap <themove> <br>
Standard_EXPORT   Standard_Real Move() const;

//! This  virtual   method  is  called  by the Measurement <br>
//!          methods,  to   compute  the   measurement    during  a <br>
//!          conversion. <br>
Standard_EXPORT virtual  Standard_Real Multiplied(const Standard_Real avalue) const;

//! This   virtual  method is  called  by  the Measurement <br>
//!          methods,   to   compute   the   measurement   during a <br>
//!          conversion. <br>
Standard_EXPORT virtual  Standard_Real Divided(const Standard_Real avalue) const;

//! Destroies the Token <br>
Standard_EXPORT virtual  void Destroy() ;
~Units_ShiftedToken()
{
  Destroy();
}



Standard_EXPORT virtual  void Dump(const Standard_Integer ashift,const Standard_Integer alevel) const;




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real themove;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
