// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Vrml_Cone_HeaderFile
#define _Vrml_Cone_HeaderFile

#ifndef _Vrml_ConeParts_HeaderFile
#include <Vrml_ConeParts.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! defines a Cone node of VRML specifying geometry shapes. <br>
//! This  node  represents  a  simple  cone,  whose  central  axis  is  aligned <br>
//! with  the  y-axis.  By  default ,  the  cone  is  centred  at  (0,0,0) <br>
//! and  has  size  of  -1  to  +1  in  the  all  three  directions. <br>
//! the  cone  has  a  radius  of  1  at  the  bottom  and  height  of  2, <br>
//! with  its  apex  at  1  and  its  bottom  at  -1.  The  cone  has  two  parts: <br>
//! the  sides  and  the  bottom <br>
class Vrml_Cone  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Vrml_Cone(const Vrml_ConeParts aParts = Vrml_ConeALL,const Standard_Real aBottomRadius = 1,const Standard_Real aHeight = 2);


Standard_EXPORT   void SetParts(const Vrml_ConeParts aParts) ;


Standard_EXPORT   Vrml_ConeParts Parts() const;


Standard_EXPORT   void SetBottomRadius(const Standard_Real aBottomRadius) ;


Standard_EXPORT   Standard_Real BottomRadius() const;


Standard_EXPORT   void SetHeight(const Standard_Real aHeight) ;


Standard_EXPORT   Standard_Real Height() const;


Standard_EXPORT   Standard_OStream& Print(Standard_OStream& anOStream) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Vrml_ConeParts myParts;
Standard_Real myBottomRadius;
Standard_Real myHeight;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
