// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Xw_TextManager_HeaderFile
#define _Xw_TextManager_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Xw_TextManager_HeaderFile
#include <Handle_Xw_TextManager.hxx>
#endif

#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _MFT_TextManager_HeaderFile
#include <MFT_TextManager.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
#ifndef _Quantity_PlaneAngle_HeaderFile
#include <Quantity_PlaneAngle.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Aspect_TypeOfText_HeaderFile
#include <Aspect_TypeOfText.hxx>
#endif
class Xw_Driver;


//! defines the common behaviour of the Xw output driver. <br>
//!  Warning: Permits to receives draw primitives from the FontManager <br>
//!	    at DrawText(...) time. <br>
//!	    This class must be redefined by the user as an application class. <br>
class Xw_TextManager : public MFT_TextManager {

public:
 // Methods PUBLIC
 // 

//! Does NOTHING <br>
Standard_EXPORT Xw_TextManager(const Standard_Address aDrawable,const Standard_Address aWidthMap);

//! Calls when string drawing is started. <br>
//!          with a string aspect <aPaintType> : <br>
//!            0 for filled string <br>
//!            1 for stroke string <br>
//!            2 for outline string <br>
//!          The origine of the string <X>,<Y>, <br>
//!          The orientation of the string <anOrientation>, <br>
//!          The medium size of the char <aWidth,aHeight>, <br>
//!          The Slant of the char <aSlant>, <br>
Standard_EXPORT virtual  void BeginString(const Quantity_Length X,const Quantity_Length Y,const Quantity_PlaneAngle anOrientation,const Quantity_Length aWidth,const Quantity_Length aHeight,const Quantity_PlaneAngle aSlant,const Standard_Integer aPaintType) ;

//! Calls when a char drawing is started <br>
//!          and give the current string position for this char. <br>
//!          and give the relative char position from the beginning <br>
//!          of the string. <br>
//!          The application can returns FALSE for skipping the char drawing. <br>
Standard_EXPORT virtual  Standard_Boolean BeginChar(const Standard_Integer aCharCode,const Quantity_Length X,const Quantity_Length Y) ;

//! Calls to defines the current char bounding-box. <br>
//!	    The application can returns FALSE for ending the char drawing. <br>
Standard_EXPORT virtual  Standard_Boolean SetCharBoundingBox(const Quantity_Length X1,const Quantity_Length Y1,const Quantity_Length X2,const Quantity_Length Y2,const Quantity_Length X3,const Quantity_Length Y3,const Quantity_Length X4,const Quantity_Length Y4) ;

//! Calls to defines the current char encoding. <br>
//!  Warning: The application can returns FALSE for skipping the char drawing. <br>
Standard_EXPORT virtual  Standard_Boolean SetCharEncoding(const Standard_CString anEncoding) ;

//! Calls to sets the current string position. <br>
//!	    The application can returns FALSE for ending the char drawing. <br>
Standard_EXPORT virtual  Standard_Boolean Moveto(const Quantity_Length X,const Quantity_Length Y) ;

//! Calls to drawn to the current string position. <br>
//!	    The application can returns FALSE for ending the char drawing. <br>
Standard_EXPORT virtual  Standard_Boolean Lineto(const Quantity_Length X,const Quantity_Length Y) ;

//! Calls to drawn to the current string position. <br>
//!          The application can drawn the curve defined by <br>
//!          his descriptor P1,P2,P3,P4 or <br>
//!          returns FALSE to let the interpretor compute the curve <br>
//!          vectors. <br>
Standard_EXPORT virtual  Standard_Boolean Curveto(const Quantity_Length X1,const Quantity_Length Y1,const Quantity_Length X2,const Quantity_Length Y2,const Quantity_Length X3,const Quantity_Length Y3,const Quantity_Length X4,const Quantity_Length Y4) ;

//! Calls when a char path drawing is ended <br>
Standard_EXPORT virtual  void ClosePath() ;

//! Calls when a char drawing is ended <br>
//!          and give the relative char ending position from the <br>
//!          beginning of the string. <br>
//!          The application can returns FALSE for skipping the string <br>
//!          drawing. <br>
Standard_EXPORT virtual  Standard_Boolean EndChar(const Quantity_Length X,const Quantity_Length Y) ;

//! Calls when string drawing is ended (Normally the last call). <br>
Standard_EXPORT virtual  void EndString() ;
//Standard_EXPORT ~Xw_TextManager();


friend class Xw_Driver;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Sets the current attribs of the text. <br>
Standard_EXPORT   void SetTextAttribs(const Standard_Integer aTextColor,const Aspect_TypeOfText aTypeOfText,const Quantity_Length anUnderlinePosition = 0.0) ;


 // Fields PRIVATE
 //
Standard_Address myDrawable;
Standard_Address myWidthMap;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
