// File generated by CPPExt (Storable)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _gp_Cone_HeaderFile
#define _gp_Cone_HeaderFile

#ifndef _gp_Ax3_HeaderFile
#include <gp_Ax3.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Storable_HeaderFile
#include <Standard_Storable.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _gp_Ax1_HeaderFile
#include <gp_Ax1.hxx>
#endif
#ifndef _Standard_PrimitiveTypes_HeaderFile
#include <Standard_PrimitiveTypes.hxx>
#endif
class Standard_ConstructionError;
class gp_Ax3;
class gp_Ax1;
class gp_Pnt;
class gp_Ax2;
class gp_Trsf;
class gp_Vec;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

Standard_EXPORT Handle_Standard_Type& gp_Cone_Type_();


//!  Defines an infinite conical surface. <br>
//! A cone is defined by its half-angle at the apex and <br>
//! positioned in space with a coordinate system (a gp_Ax3 <br>
//! object) and a "reference radius" where: <br>
//! -   the "main Axis" of the coordinate system is the axis of   revolution of the cone, <br>
//! -   the plane defined by the origin, the "X Direction" and <br>
//!   the "Y Direction" of the coordinate system is the <br>
//!   reference plane of the cone; the intersection of the <br>
//!   cone with this reference plane is a circle of radius <br>
//!   equal to the reference radius, <br>
//!   if the half-angle is positive, the apex of the cone is on <br>
//!   the negative side of the "main Axis" of the coordinate <br>
//!   system. If the half-angle is negative, the apex is on the   positive side. <br>
//!   This coordinate system is the "local coordinate system" of the cone. <br>
//! Note: when a gp_Cone cone is converted into a <br>
//! Geom_ConicalSurface cone, some implicit properties of <br>
//! its local coordinate system are used explicitly: <br>
//! -   its origin, "X Direction", "Y Direction" and "main <br>
//!   Direction" are used directly to define the parametric <br>
//! directions on the cone and the origin of the parameters, <br>
//! -   its implicit orientation (right-handed or left-handed) <br>
//!   gives the orientation (direct or indirect) of the <br>
//!   Geom_ConicalSurface cone. <br>
//! See Also <br>
//! gce_MakeCone which provides functions for more <br>
//! complex cone constructions <br>
//! Geom_ConicalSurface which provides additional <br>
//! functions for constructing cones and works, in particular, <br>
//! with the parametric equations of cones gp_Ax3 <br>
class gp_Cone  {

public:
    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }

 // Methods PUBLIC
 // 
//! Creates an indefinite Cone. <br>
gp_Cone();

//!  Creates an infinite conical surface. A3 locates the cone <br>
//!  in the space and defines the reference plane of the surface. <br>
//!  Ang is the conical surface semi-angle between 0 and PI/2 radians. <br>
//!  Radius is the radius of the circle in the reference plane of <br>
//!  the cone. <br>
//! Raises ConstructionError <br>
//!  . if Radius is lower than 0.0 <br>
//!  . Ang < Resolution from gp  or Ang >= (PI/2) - Resolution. <br>
gp_Cone(const gp_Ax3& A3,const Standard_Real Ang,const Standard_Real Radius);
//!  Changes the symmetry axis of the cone.  Raises ConstructionError <br>
//!  the direction of A1 is parallel to the "XDirection" <br>
//!  of the coordinate system of the cone. <br>
  void SetAxis(const gp_Ax1& A1) ;
//! Changes the location of the cone. <br>
  void SetLocation(const gp_Pnt& Loc) ;

//!  Changes the local coordinate system of the cone. <br>
//!  This coordinate system defines the reference plane of the cone. <br>
  void SetPosition(const gp_Ax3& A3) ;

//!  Changes the radius of the cone in the reference plane of <br>
//!  the cone. <br>//! Raised if R < 0.0 <br>
  void SetRadius(const Standard_Real R) ;

//!  Changes the semi-angle of the cone. <br>
//!  Ang is the conical surface semi-angle  ]0,PI/2[. <br>
//!    Raises ConstructionError if Ang < Resolution from gp or Ang >= PI/2 - Resolution <br>
  void SetSemiAngle(const Standard_Real Ang) ;

//!  Computes the cone's top. The Apex of the cone is on the <br>
//!  negative side of the symmetry axis of the cone. <br>
  gp_Pnt Apex() const;
//! Reverses the   U   parametrization of   the  cone <br>
//!          reversing the YAxis. <br>
  void UReverse() ;
//! Reverses the   V   parametrization of   the  cone  reversing the ZAxis. <br>
  void VReverse() ;
//! Returns true if the local coordinate system of this cone is right-handed. <br>
  Standard_Boolean Direct() const;
//! returns the symmetry axis of the cone. <br>
 const gp_Ax1& Axis() const;


//!  Computes the coefficients of the implicit equation of the quadric <br>
//!  in the absolute cartesian coordinates system : <br>
//! A1.X**2 + A2.Y**2 + A3.Z**2 + 2.(B1.X.Y + B2.X.Z + B3.Y.Z) + <br>
//! 2.(C1.X + C2.Y + C3.Z) + D = 0.0 <br>
Standard_EXPORT   void Coefficients(Standard_Real& A1,Standard_Real& A2,Standard_Real& A3,Standard_Real& B1,Standard_Real& B2,Standard_Real& B3,Standard_Real& C1,Standard_Real& C2,Standard_Real& C3,Standard_Real& D) const;
//! returns the "Location" point of the cone. <br>
 const gp_Pnt& Location() const;

//!  Returns the local coordinates system of the cone. <br>
 const gp_Ax3& Position() const;

//!  Returns the radius of the cone in the reference plane. <br>
  Standard_Real RefRadius() const;
//! Returns the half-angle at the apex of this cone. <br>
  Standard_Real SemiAngle() const;
//! Returns the XAxis of the reference plane. <br>
  gp_Ax1 XAxis() const;
//! Returns the YAxis of the reference plane. <br>
  gp_Ax1 YAxis() const;


Standard_EXPORT   void Mirror(const gp_Pnt& P) ;


//!  Performs the symmetrical transformation of a cone <br>
//!  with respect to the point P which is the center of the <br>
//!  symmetry. <br>
Standard_EXPORT   gp_Cone Mirrored(const gp_Pnt& P) const;


Standard_EXPORT   void Mirror(const gp_Ax1& A1) ;


//!  Performs the symmetrical transformation of a cone with <br>
//!  respect to an axis placement which is the axis of the <br>
//!  symmetry. <br>
Standard_EXPORT   gp_Cone Mirrored(const gp_Ax1& A1) const;


Standard_EXPORT   void Mirror(const gp_Ax2& A2) ;


//!  Performs the symmetrical transformation of a cone with respect <br>
//!  to a plane. The axis placement A2 locates the plane of the <br>
//!  of the symmetry : (Location, XDirection, YDirection). <br>
Standard_EXPORT   gp_Cone Mirrored(const gp_Ax2& A2) const;

  void Rotate(const gp_Ax1& A1,const Standard_Real Ang) ;

//!  Rotates a cone. A1 is the axis of the rotation. <br>
//!  Ang is the angular value of the rotation in radians. <br>
  gp_Cone Rotated(const gp_Ax1& A1,const Standard_Real Ang) const;

  void Scale(const gp_Pnt& P,const Standard_Real S) ;

//!  Scales a cone. S is the scaling value. <br>
//!  The absolute value of S is used to scale the cone <br>
  gp_Cone Scaled(const gp_Pnt& P,const Standard_Real S) const;

  void Transform(const gp_Trsf& T) ;

//!  Transforms a cone with the transformation T from class Trsf. <br>
  gp_Cone Transformed(const gp_Trsf& T) const;

  void Translate(const gp_Vec& V) ;

//!  Translates a cone in the direction of the vector V. <br>
//!  The magnitude of the translation is the vector's magnitude. <br>
  gp_Cone Translated(const gp_Vec& V) const;

  void Translate(const gp_Pnt& P1,const gp_Pnt& P2) ;

//!  Translates a cone from the point P1 to the point P2. <br>
  gp_Cone Translated(const gp_Pnt& P1,const gp_Pnt& P2) const;
    const gp_Ax3& _CSFDB_Getgp_Conepos() const { return pos; }
    Standard_Real _CSFDB_Getgp_Coneradius() const { return radius; }
    void _CSFDB_Setgp_Coneradius(const Standard_Real p) { radius = p; }
    Standard_Real _CSFDB_Getgp_ConesemiAngle() const { return semiAngle; }
    void _CSFDB_Setgp_ConesemiAngle(const Standard_Real p) { semiAngle = p; }




 // Type management
 //
 Standard_EXPORT friend Handle_Standard_Type& gp_Cone_Type_();

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Ax3 pos;
Standard_Real radius;
Standard_Real semiAngle;


};


#include <gp_Cone.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
