// File:        DDataStd_BasicCommands.cxx
// Created:     Wed Jul 30 16:19:35 1997
// Author:      Denis PASCAL
//              <dp@dingox.paris1.matra-dtv.fr>

#include <DDataStd.hxx>
#include <DDF.hxx>
#include <Draw_Interpretor.hxx>
#include <Draw_Appli.hxx>
#include <DrawTrSurf.hxx>

#include <DDF.hxx>

#include <TDF_Data.hxx>
#include <TDF_Label.hxx>
#include <TDF_Tool.hxx>
#include <TDF_AttributeSequence.hxx>
#include <TDF_AttributeList.hxx>
#include <TDF_ListIteratorOfAttributeList.hxx>

#include <DBRep.hxx>
#include <TopAbs.hxx>
#include <TopoDS.hxx>
#include <TopoDS_Vertex.hxx>
#include <TopoDS_Edge.hxx>
#include <TopoDS_Wire.hxx>
#include <TopoDS_Face.hxx>
#include <TopoDS_Shell.hxx>
#include <TopoDS_Solid.hxx>
#include <TopoDS_Shape.hxx>

#include <gp_Pnt.hxx>
#include <gp_Dir.hxx>
#include <gp_Pln.hxx>

#include <TCollection_AsciiString.hxx>

// LES ATTRIBUTES
#include <TDataStd.hxx>
#include <TDataStd_Comment.hxx>
#include <TDataStd_Integer.hxx>
#include <TDataStd_Real.hxx>
#include <TDF_Reference.hxx>
#include <TDataStd_UAttribute.hxx>
#include <TDataStd_IntegerArray.hxx>
#include <TDataStd_RealArray.hxx>
#include <TDataStd_Variable.hxx>
#include <TDataStd_ExtStringArray.hxx>
#include <TDataStd_Position.hxx>

#include <TDF_Tool.hxx>

#include <Standard_Macro.hxx>

//=======================================================================
//function : DDataStd_SetInteger
//purpose  : SetInteger (DF, entry, value)
//=======================================================================

static Standard_Integer DDataStd_SetInteger (Draw_Interpretor& di,
                                              Standard_Integer nb, 
                                              char** arg) 
{     
  if (nb == 4) {    
    Handle(TDF_Data) DF;
    if (!DDF::GetDF(arg[1],DF)) return 1;
    TDF_Label L;
    DDF::AddLabel(DF, arg[2], L);
    TDataStd_Integer::Set(L,atoi(arg[3]));  
    return 0;
  }
  di << "DDataStd_SetInteger : Error" << "\n";
  return 1;
}

//=======================================================================
//function : DDataStd_SetReal
//purpose  : SetReal (DF, entry, value)
//=======================================================================

static Standard_Integer DDataStd_SetReal (Draw_Interpretor& di,
                                           Standard_Integer nb, 
                                           char** arg) 
{   
  if (nb == 4) {    
    Handle(TDF_Data) DF;
    if (!DDF::GetDF(arg[1],DF)) return 1;
    TDF_Label L;
    DDF::AddLabel(DF, arg[2], L);
    TDataStd_Real::Set(L,atof(arg[3]));  
    return 0;
  } 
  di << "DDataStd_SetReal : Error" << "\n";
  return 1;
}



//=======================================================================
//function : DDataStd_SetReference
//purpose  : SetReference (DF, entry, reference)
//=======================================================================

static Standard_Integer DDataStd_SetReference (Draw_Interpretor& di,
                                               Standard_Integer nb, 
                                               char** arg) 
{   
  if (nb == 4) {    
    Handle(TDF_Data) DF;
    if (!DDF::GetDF(arg[1],DF)) return 1;
    TDF_Label L;
    DDF::AddLabel(DF, arg[2], L);  
    TDF_Label LREF;
    if (!DDF::FindLabel(DF,arg[3],LREF)) return 1;
    TDF_Reference::Set(L,LREF);  
    return 0;
  } 
  di << "DDataStd_SetReference : Error" << "\n";
  return 1;
}


//=======================================================================
//function : DDataStd_SetComment
//purpose  : SetComment (DF, entry, Comment)
//=======================================================================

static Standard_Integer DDataStd_SetComment (Draw_Interpretor& di,
                                               Standard_Integer nb, 
                                               char** arg) 
{   
  if (nb == 4) {    
    Handle(TDF_Data) DF;
    if (!DDF::GetDF(arg[1],DF)) return 1;
    TDF_Label L;
    DDF::AddLabel(DF, arg[2], L);
    TDataStd_Comment::Set(L,arg[3]);  
    return 0;
  }
  di << "DDataStd_SetComment : Error" << "\n";
  return 1;
}



//=======================================================================
//function : DDataStd_GetInteger
//purpose  : GetReal (DF, entry, [drawname])
//=======================================================================

static Standard_Integer DDataStd_GetInteger (Draw_Interpretor& di,
                                              Standard_Integer nb, 
                                              char** arg) 
{     
  if (nb == 3 || nb == 4) {
    Handle(TDF_Data) DF;
    if (!DDF::GetDF(arg[1],DF)) return 1;
    Handle(TDataStd_Integer) A;
    if (!DDF::Find(DF,arg[2],TDataStd_Integer::GetID(),A)) return 1;
    if (nb == 4) Draw::Set(arg[3],A->Get());
    else         Draw::Set(arg[2],A->Get());
    di << A->Get();
    return 0;
  }
  di << "DDataStd_GetInteger : Error" << "\n";
  return 1;
}

//=======================================================================
//function : DDataStd_GetReal
//purpose  : GetReal (DF, entry, [drawname])
//=======================================================================

static Standard_Integer DDataStd_GetReal (Draw_Interpretor& di,
                                          Standard_Integer nb, 
                                          char** arg) 
{  
  if (nb == 3 || nb == 4) {
    Handle(TDF_Data) DF;
    if (!DDF::GetDF(arg[1],DF)) return 1;
    Handle(TDataStd_Real) A;
    if (!DDF::Find(DF,arg[2],TDataStd_Real::GetID(),A)) return 1;
    if (nb == 4) Draw::Set(arg[3],A->Get());
    else         Draw::Set(arg[2],A->Get());
    di << A->Get();
    return 0;
  }
  di << "DDataStd_GetReal : Error" << "\n";
  return 1;
}


//=======================================================================
//function : DDataStd_GetReference
//purpose  : GetShape (DF, entry)
//=======================================================================

static Standard_Integer DDataStd_GetReference (Draw_Interpretor& di,
                                               Standard_Integer nb, 
                                               char** arg) 
{  
  if (nb == 3) {
    Handle(TDF_Data) DF;
    if (!DDF::GetDF(arg[1],DF)) return 1;
    Handle(TDF_Reference) REF;
    if (!DDF::Find(DF,arg[2],TDF_Reference::GetID(),REF)) return 1;
    TCollection_AsciiString entry; TDF_Tool::Entry(REF->Get(),entry);
    di << entry.ToCString();
    return 0;
  }
  di << "DDataStd_GetReference : Error" << "\n";
  return 1;
}

//=======================================================================
//function : DDataStd_GetComment
//purpose  : GetShape (DF, entry)
//=======================================================================

static Standard_Integer DDataStd_GetComment (Draw_Interpretor& di,
                                          Standard_Integer nb, 
                                          char** arg) 
{ 
  if (nb == 3) {
    Handle(TDF_Data) DF;
    if (!DDF::GetDF(arg[1],DF)) return 1;
    Handle(TDataStd_Comment) A;
    if (!DDF::Find(DF,arg[2],TDataStd_Comment::GetID(),A)) return 1;
    TCollection_AsciiString s(A->Get(),'?');
    di << s.ToCString();
    return 0;
  }
  di << "DDataStd_GetComment : Error" << "\n";
  return 1;
}



//=======================================================================
//function :
//purpose  : Self (document,label)
//=======================================================================

static Standard_Integer DDataStd_Self (Draw_Interpretor& di,
                                       Standard_Integer nb, 
                                       char** arg) 
{    
  TCollection_AsciiString s;  
  if (nb == 3) {  
    Handle(TDF_Data) DF;
    if (!DDF::GetDF(arg[1],DF)) return 1;
    TDF_Label L;
    if (!DDF::FindLabel(DF,arg[2],L)) return 1; 
//    TDataStd::MakeSelfContained(L,removed);
//    if (removed.IsEmpty()) cout << "noone attriburte removed" << endl;
//    for (TDF_ListIteratorOfAttributeList it(removed);it.More();it.Next()) {
//      TDF_Tool::Entry(it.Value()->Label(),s); cout  << s << " ";
//      cout << endl;
//    }
    return 0;
  } 
  di << "Self : Error" << "\n";
  return 0;
}



//=======================================================================
//function : SetUObject (DF, entry, ObjectID)
//=======================================================================
// static Standard_Integer DDataStd_SetUObject (Draw_Interpretor&,
//                                            Standard_Integer nb, 
//                                            char** arg) 
// {   
//   if( nb == 4 ) {
//     Handle(TDF_Data) DF;
//     if (!DDF::GetDF(arg[1],DF))  return 1;
//     TDF_Label label;
//     DDF::AddLabel(DF, arg[2], label);

//     Standard_GUID guid(arg[3]);  //"00000000-0000-0000-1111-000000000000");
//     TDataStd_UObject::Set(label, guid);
//     return 0;
//   }

//   cout << "Wrong arguments"  << endl;  
//   return 1;
// } 

//=======================================================================
//function : SetUAttribute (DF, entry, LocalID)
//=======================================================================
static Standard_Integer DDataStd_SetUAttribute (Draw_Interpretor& di,
                                                Standard_Integer nb, 
                                                char** arg) 
{   
  if( nb == 4 ) { 
    Handle(TDF_Data) DF;
    if (!DDF::GetDF(arg[1],DF))  return 1; 
    TDF_Label label;
    DDF::AddLabel(DF, arg[2], label);

    Standard_GUID guid(arg[3]);  //"00000000-0000-0000-2222-000000000000");
    TDataStd_UAttribute::Set(label, guid);
    return 0; 
  }

  di << "Wrong arguments"  << "\n";  
  return 1; 
} 

//=======================================================================
//function : GetUAttribute (DF, entry, LoaclID)
//=======================================================================
static Standard_Integer DDataStd_GetUAttribute (Draw_Interpretor& di,
                                                Standard_Integer nb, 
                                                char** arg) 
{   
  if( nb == 4 ) {  
    Handle(TDF_Data) DF;
    if (!DDF::GetDF(arg[1],DF)) return 1; 
    TDF_Label label;
    if( !DDF::FindLabel(DF, arg[2], label) ) {
     di << "No label for entry"  << "\n";
     return 1;
    }
    Standard_GUID guid(arg[3]);  //"00000000-0000-0000-2222-000000000000");

    Handle(TDataStd_UAttribute) UA;    
    if( !label.FindAttribute(guid, UA) ) {
      di << "No UAttribute Attribute on label"   << "\n";
    }
    else {
//      UA->ID().ShallowDump(cout);
//      cout << endl; 
      char *aStrGUID = new char[37];
      UA->ID().ToCString(aStrGUID);
      di << aStrGUID;
    }
    return 0;  
  }

  di << "Wrong arguments"  << "\n";  
  return 1;  
} 


//=======================================================================
//function : CheckUObject (DF, entry, ObjectID)
//=======================================================================
// static Standard_Integer DDataStd_CheckUObject (Draw_Interpretor&,
//                                           Standard_Integer nb, 
//                                           char** arg) 
// {   
//   if( nb == 4 ) {   
//     Handle(TDF_Data) DF;
//     if (!DDF::GetDF(arg[1],DF)) return 1;  
//     TDF_Label label;
//     if( !DDF::FindLabel(DF, arg[2], label) ) { 
//      cout << "No label for entry"  << endl;
//      return 1; 
//     }
//     Handle(TDataStd_Object) O;
//     Handle(TDataStd_UObject) UO;    
//     Standard_GUID guidUO(arg[3]);

//     if( !label.FindAttribute( TDataStd_Object::GetID(), O) ) {
//       cout << "No Object Attribute on label"   << endl;
//     }
//     else { 
//       cout << "UObject is found with ObjectID = ";
//       O->Find(label, guidUO, UO);
//       UO->ObjectID().ShallowDump(cout);
//       cout << endl; 
//     }
//     return 0;   
//   }

//   cout << "Wrong arguments"  << endl;  
//   return 1;  
// }


//=======================================================================
//function : SetIntArray (DF, entry , From, To,  elmt1, elmt2, ...
//=======================================================================
static Standard_Integer DDataStd_SetIntArray (Draw_Interpretor& di,
                                              Standard_Integer, 
                                              char** arg) 
{   


  Handle(TDF_Data) DF;
  if (!DDF::GetDF(arg[1],DF))  return 1; 
  TDF_Label label;
  DDF::AddLabel(DF, arg[2], label);
 
  Standard_Integer From = atoi(arg[3]), To = atoi( arg[4] ), j;
  di << "Array of Standard_Integer with bounds from = " << From  << " to = " << To  << "\n";
  Handle(TDataStd_IntegerArray) A = TDataStd_IntegerArray::Set(label, From, To);
  
  j = 5;
  for(Standard_Integer i = From; i<=To; i++) {
    A->SetValue(i, atoi(arg[j]) ); 
    j++;
  }

  return 0; 
} 

//=======================================================================
//function : GetIntArray (DF, entry )
//=======================================================================
static Standard_Integer DDataStd_GetIntArray (Draw_Interpretor& di,
                                              Standard_Integer, 
                                              char** arg) 
{   


  Handle(TDF_Data) DF;
  if (!DDF::GetDF(arg[1],DF))  return 1;  
  TDF_Label label;
  if( !DDF::FindLabel(DF, arg[2], label) ) {
    di << "No label for entry"  << "\n";
    return 1;
  }
 
  Handle(TDataStd_IntegerArray) A;
  if ( !label.FindAttribute(TDataStd_IntegerArray::GetID(), A) ) { 
    di << "There is no TDataStd_IntegerArray under label"  << "\n";
    return 1;
  }
  
  for(Standard_Integer i = A->Lower(); i<=A->Upper(); i++){
    //cout <<  A->Value(i)   << endl;
    di  <<  A->Value(i);
    if(i<A->Upper())  
     di<<" ";
  }
  di<<"\n";
  return 0; 
} 


//=======================================================================
//function : SetRealArray (DF, entry , From, To,  elmt1, elmt2, ...
//=======================================================================
static Standard_Integer DDataStd_SetRealArray (Draw_Interpretor& di,
                                               Standard_Integer, 
                                               char** arg) 
{   


  Handle(TDF_Data) DF;
  if (!DDF::GetDF(arg[1],DF))  return 1;  
  TDF_Label label; 
  DDF::AddLabel(DF, arg[2], label);
 
  Standard_Integer From = atoi(arg[3]), To = atoi( arg[4] ), j;
  di << " Array of Standard_Real with bounds from = " << From  << " to = " << To  << "\n";
  Handle(TDataStd_RealArray) A = TDataStd_RealArray::Set(label, From, To);
  
  j = 5;
  for(Standard_Integer i = From; i<=To; i++) { 
    A->SetValue(i, atof(arg[j]) ); 
    j++;
  }

  return 0;  
} 

//=======================================================================
//function : GetRealArray (DF, entry )
//=======================================================================
static Standard_Integer DDataStd_GetRealArray (Draw_Interpretor& di,
                                               Standard_Integer, 
                                               char** arg) 
{   


  Handle(TDF_Data) DF;
  if (!DDF::GetDF(arg[1],DF))  return 1;  
  TDF_Label label;
  if( !DDF::FindLabel(DF, arg[2], label) ) { 
    di << "No label for entry"  << "\n";
    return 1; 
  }
 
  Handle(TDataStd_RealArray) A;
  if ( !label.FindAttribute(TDataStd_RealArray::GetID(), A) ) { 
    di << "There is no TDataStd_RealArray under label"  << "\n";
    return 1; 
  }
  
  for(Standard_Integer i = A->Lower(); i<=A->Upper(); i++){
    //cout <<  A->Value(i)   << endl; 
    di   <<  A->Value(i);
    if(i<A->Upper())  
     di<<" ";
  }  
  di<<"\n";

  return 0;  
} 

//=======================================================================
//function : SetVariable (DF, entry, isConstant[0/1], units)
//=======================================================================
static Standard_Integer DDataStd_SetVariable (Draw_Interpretor& di,
                                              Standard_Integer nb, 
                                              char** arg)
{
  if (nb == 5)
  {
    Handle(TDF_Data) DF;
    if (!DDF::GetDF(arg[1],DF))  return 1; 
    TDF_Label label;
    DDF::AddLabel(DF, arg[2], label);

    Handle(TDataStd_Variable) aV = TDataStd_Variable::Set(label);

    char* aUnits = arg[4];
    aV->Unit(Standard_CString(aUnits));

    aV->Constant(Standard_Boolean(atoi(arg[3])));
    return 0; 
  }

  di << "Wrong arguments" << "\n";  
  return 1; 
} 

//=======================================================================
//function : GetVariable (DF, entry, [isConstant], [units])
//=======================================================================
static Standard_Integer DDataStd_GetVariable (Draw_Interpretor& di,
                                              Standard_Integer nb, 
                                              char** arg)
{
  if (nb == 5)
  {
    Handle(TDF_Data) DF;
    if (!DDF::GetDF(arg[1],DF))  return 1; 
    TDF_Label label;
    DDF::AddLabel(DF, arg[2], label);

    Handle(TDataStd_Variable) aV;
    if (!label.FindAttribute(TDataStd_Variable::GetID(), aV))
    {
      di << "TDataStd_Variable: no such attribute" << "\n";
    }

    Draw::Set(arg[3],TCollection_AsciiString(Standard_Integer(aV->IsConstant())).ToCString());
    Draw::Set(arg[4],aV->Unit().ToCString());
    return 0; 
  }

  di << "Wrong arguments" << "\n";  
  return 1; 
} 

#include <TDataStd_Relation.hxx>
#include <TDataStd_Variable.hxx>
//=======================================================================
//function : SetRelation (DF, entry, expression, var1[, var2, ...])
//=======================================================================
static Standard_Integer DDataStd_SetRelation (Draw_Interpretor& di,
                                              Standard_Integer nb, char** arg) 
{
  if (nb >= 5)
  {
    Handle(TDF_Data) DF;
    if (!DDF::GetDF(arg[1],DF)) return 1;
    TDF_Label label;
    DDF::AddLabel(DF, arg[2], label);

    Standard_CString expr (arg[3]);
    Handle(TDataStd_Relation) aR = TDataStd_Relation::Set(label);
    aR->SetRelation(expr);
    Handle(TDataStd_Variable) aV;

    for (Standard_Integer i = 4; i < nb; i++)
    {
      if (!DDF::FindLabel(DF, arg[i], label))
      {
        di << "No label for entry" << arg[i] << "\n";
        return 1;
      }
      if (!label.FindAttribute(TDataStd_Variable::GetID(), aV))
      {
        di << "No TDataStd_Variable Attribute on label" << "\n";
        return 1;
      }
      aR->GetVariables().Append(aV);
    }
    return 0;
  }
  di << "Usage: SetRelation (DF, entry, expression, var1[, var2, ...])" << "\n";
  return 1;
}

//=======================================================================
//function : DumpRelation (DF, entry)
//=======================================================================
static Standard_Integer DDataStd_DumpRelation (Draw_Interpretor& di,
                                               Standard_Integer nb, char** arg) 
{
  if (nb == 3)
  {
    Handle(TDF_Data) DF;
    if (!DDF::GetDF(arg[1],DF)) return 1;

    TDF_Label label;
    if (!DDF::FindLabel(DF, arg[2], label))
    {
      di << "No label for entry " << arg[2] << "\n";
      return 1;
    }
    Handle(TDataStd_Relation) aR;
    if (!label.FindAttribute(TDataStd_Relation::GetID(), aR))
    {
      di << "No TDataStd_Relation Attribute on label " << arg[2] << "\n";
      return 1;
    }

    TCollection_ExtendedString expr = aR->GetRelation();
    Standard_SStream aStream;
    expr.Print(aStream);
    aStream << ends;
    di << "Relation: expression = \"" << GetSString(aStream)
       << "\" variables list = (";

    Handle(TDF_Attribute) aV;
    TCollection_AsciiString anEntry;

    TDF_ListIteratorOfAttributeList it;
    for (it.Initialize(aR->GetVariables()); it.More(); it.Next())
    {
      aV = it.Value(); 
      if (!aV.IsNull())
      {
        label = aV->Label();
        TDF_Tool::Entry(label, anEntry);
        di << anEntry.ToCString() << " ";
      }
    }
    di << ")";
    return 0;
  }
  di << "Usage: DumpRelation (DF, entry)" << "\n";
  return 1;
}

#include <TFunction_Function.hxx>
//=======================================================================
//function : SetFunction (DF, entry, guid, failure)
//=======================================================================
static Standard_Integer DDataStd_SetFunction (Draw_Interpretor& di,
                                              Standard_Integer nb, char** arg)
{
  if (nb == 5)
  {
    Handle(TDF_Data) DF;
    if (!DDF::GetDF(arg[1],DF))  return 1;
    TDF_Label label;
    DDF::AddLabel(DF, arg[2], label);

    Standard_GUID guid (arg[3]);
    Handle(TFunction_Function) aF = TFunction_Function::Set(label, guid);

    int fail = atoi(arg[4]);
    aF->SetFailure(fail);

    return 0;
  }

  di << "Wrong arguments"  << "\n";
  return 1;
}

//=======================================================================
//function : GetFunction (DF, entry, guid(out), failure(out))
//=======================================================================
static Standard_Integer DDataStd_GetFunction (Draw_Interpretor& di,
                                              Standard_Integer nb, char** arg) 
{   
  if (nb == 5)
  {  
    Handle(TDF_Data) DF;
    if (!DDF::GetDF(arg[1],DF)) return 1; 
    TDF_Label label;
    if (!DDF::FindLabel(DF, arg[2], label))
    {
     di << "No label for entry"  << "\n";
     return 1;
    }

    Handle(TFunction_Function) aF;    
    if (!label.FindAttribute(TFunction_Function::GetID(), aF))
    {
      di << "No TFunction_Function Attribute on label" << "\n";
    }
    else
    {
      char *aStrGUID = new char[37];
      aF->GetDriverGUID().ToCString(aStrGUID);
      Draw::Set(arg[3],aStrGUID);

      Draw::Set(arg[4],TCollection_AsciiString(aF->GetFailure()).ToCString());
    }
    return 0;  
  }

  di << "Wrong arguments"  << "\n";  
  return 1;  
} 

//=======================================================================
//function : SetExtStringArray (DF, entry , From, To,  elmt1, elmt2, ...
//=======================================================================
static Standard_Integer DDataStd_SetExtStringArray (Draw_Interpretor& di,
						    Standard_Integer, 
						    char** arg) 
{   


  Handle(TDF_Data) DF;
  if (!DDF::GetDF(arg[1],DF))  return 1; 
  TDF_Label label;
  DDF::AddLabel(DF, arg[2], label);
 
  Standard_Integer From = atoi(arg[3]), To = atoi( arg[4] ), j;
  di << "Array of ExtString with bounds from = " << From  << " to = " << To  << "\n";
  Handle(TDataStd_ExtStringArray) A = TDataStd_ExtStringArray::Set(label, From, To);
  
  j = 5;
  for(Standard_Integer i = From; i<=To; i++) {
    A->SetValue(i, arg[j] ); 
    j++;
  }

  return 0; 
} 

//=======================================================================
//function : GetExtStringArray (DF, entry )
//=======================================================================
static Standard_Integer DDataStd_GetExtStringArray (Draw_Interpretor& di,
						    Standard_Integer, 
						    char** arg) 
{   


  Handle(TDF_Data) DF;
  if (!DDF::GetDF(arg[1],DF))  return 1;  
  TDF_Label label;
  if( !DDF::FindLabel(DF, arg[2], label) ) {
    di << "No label for entry"  << "\n";
    return 1;
  }
 
  Handle(TDataStd_ExtStringArray) A;
  if ( !label.FindAttribute(TDataStd_ExtStringArray::GetID(), A) ) { 
    di << "There is no TDataStd_ExtStringArray under label"  << "\n";
    return 1;
  }
  
  TCollection_ExtendedString anExtendedString;
  TCollection_AsciiString anAsciiString;
  for(Standard_Integer i = A->Lower(); i<=A->Upper(); i++){
    anExtendedString = A->Value(i);
    anAsciiString = TCollection_AsciiString (A->Value(i),'?');
    //cout << anAsciiString.ToCString() << endl;
    di << anAsciiString.ToCString();
    if(i<A->Upper())  
      di<<" ";
  }
  di<<"\n";
  return 0; 
} 

//=======================================================================
//function : DDataStd_SetPosition
//purpose  : SetPosition (DF, entry, X, Y, Z)
//=======================================================================
static Standard_Integer DDataStd_SetPosition (Draw_Interpretor& di,
                                             Standard_Integer nb, char** arg) 
{     
  if (nb == 6)
  {    
    Handle(TDF_Data) DF;
    if (!DDF::GetDF(arg[1],DF)) return 1;
    TDF_Label L;
    DDF::AddLabel(DF, arg[2], L);

    Standard_Real X = atof(arg[3]), Y = atof(arg[4]), Z = atof(arg[5]);
    gp_Pnt aPos (X, Y, Z);

    TDataStd_Position::Set(L,aPos);  
    return 0;
  }
  di << "Usage: SetPosition (DF, entry, X, Y, Z)" << "\n";
  return 1;
}

//=======================================================================
//function : DDataStd_GetPosition
//purpose  : GetPosition (DF, entry, X(out), Y(out), Z(out))
//=======================================================================
static Standard_Integer DDataStd_GetPosition (Draw_Interpretor& di,
                                             Standard_Integer nb, char** arg) 
{     
  if (nb == 6)
  {    
    Handle(TDF_Data) DF;
    if (!DDF::GetDF(arg[1],DF)) return 1;
    TDF_Label L;
    DDF::AddLabel(DF, arg[2], L);

    gp_Pnt aPos;
    if (!TDataStd_Position::Get(L, aPos))
    {
      di << "There is no TDataStd_Position attribute on this label" << "\n";
      return -1;
    }

    Draw::Set(arg[3],TCollection_AsciiString(aPos.X()).ToCString());
    Draw::Set(arg[4],TCollection_AsciiString(aPos.Y()).ToCString());
    Draw::Set(arg[5],TCollection_AsciiString(aPos.Z()).ToCString());
    return 0;
  }
  di << "Usage: GetPosition (DF, entry, X(out), Y(out), Z(out))" << "\n";
  return 1;
}


//=======================================================================
//function : BasicCommands
//purpose  : 
//=======================================================================

void DDataStd::BasicCommands (Draw_Interpretor& theCommands)
{  

  static Standard_Boolean done = Standard_False;
  if (done) return;
  done = Standard_True;

  char* g = "DData : Standard Attribute Commands";


  // SET

  theCommands.Add ("SetInteger", 
                   "SetInteger (DF, entry, value)",
                   __FILE__, DDataStd_SetInteger, g);

  theCommands.Add ("SetIntArray", 
                   "SetIntArray (DF, entry, From, To, elmt1, elmt2, ...  )",
                   __FILE__, DDataStd_SetIntArray, g);
  
  theCommands.Add ("SetReal", 
                   "SetReal (DF, entry, value)",
                   __FILE__, DDataStd_SetReal, g); 

  theCommands.Add ("SetRealArray", 
                   "SetRealArray (DF, entry, From, To, elmt1, elmt2, ...  )",
                   __FILE__, DDataStd_SetRealArray, g);

  theCommands.Add ("SetReference", 
                   "SetReference (DF, entry, reference)",
                   __FILE__, DDataStd_SetReference, g);  


  theCommands.Add ("SetComment", 
                   "SetComment (DF, entry, comment)",
                   __FILE__, DDataStd_SetComment, g);    

  //theCommands.Add ("SetUObject", 
  //                 "SetUObject (DF, entry, ObjectID)",
        //         __FILE__, DDataStd_SetUObject, g);

  theCommands.Add ("SetUAttribute", 
                   "SetUAttribute (DF, entry, LocalID)",
                   __FILE__, DDataStd_SetUAttribute, g);

  theCommands.Add ("SetVariable", 
                   "SetVariable (DF, entry, isConstant[0/1], units)",
                   __FILE__, DDataStd_SetVariable, g);

  // GET

  theCommands.Add ("GetInteger", 
                   "GetInteger (DF, entry, [drawname])",
                    __FILE__, DDataStd_GetInteger, g);

  theCommands.Add ("GetIntArray", 
                   "GetIntArray (DF, entry )",
                   __FILE__, DDataStd_GetIntArray, g);

  theCommands.Add ("GetRealArray", 
                   "GetRealArray (DF, entry )",
                   __FILE__, DDataStd_GetRealArray, g);

  theCommands.Add ("GetReal", 
                   "GetReal (DF, entry, [drawname])",
                    __FILE__, DDataStd_GetReal, g);  

  theCommands.Add ("GetReference", 
                   "GetReference (DF, entry)",
                   __FILE__, DDataStd_GetReference, g);

  
  theCommands.Add ("GetComment", 
                   "GetComment (DF, entry)",
                   __FILE__, DDataStd_GetComment, g); 

  theCommands.Add("Self", 
                  "Self(document, entry)", 
                  __FILE__, DDataStd_Self, g);  

  theCommands.Add ("GetUAttribute", 
                   "GetUAttribute (DF, entry)",
                   __FILE__, DDataStd_GetUAttribute, g);

  //theCommands.Add ("CheckUObject", 
  //                 "SetUAttribute (DF, entry, ObjectID)",
        //         __FILE__, DDataStd_CheckUObject, g);

  theCommands.Add ("GetVariable", 
                   "GetVariable (DF, entry, [isConstant], [units])",
                   __FILE__, DDataStd_GetVariable, g);

  theCommands.Add ("SetRelation", 
                   "SetRelation (DF, entry, expression, var1[, var2, ...])",
                   __FILE__, DDataStd_SetRelation, g);

  theCommands.Add ("DumpRelation", 
                   "DumpRelation (DF, entry)",
                   __FILE__, DDataStd_DumpRelation, g);

  // TFunction commands
  char* gg = "DFunction Commands";

  theCommands.Add ("SetFunction", 
                   "SetFunction (DF, entry, guid, failure)",
                   __FILE__, DDataStd_SetFunction, gg);

  theCommands.Add ("GetFunction", 
                   "GetFunction (DF, entry, guid(out), failure(out))",
                   __FILE__, DDataStd_GetFunction, gg);


  // TDataStd_ExtStringArray attribute
  theCommands.Add ("SetExtStringArray", 
                   "SetExtStringArray (DF, entry, From, To, elmt1, elmt2, ...  )",
                   __FILE__, DDataStd_SetExtStringArray, g);
  
  theCommands.Add ("GetExtStringArray", 
                   "GetExtStringArray (DF, entry )",
                   __FILE__, DDataStd_GetExtStringArray, g);

  // TDataStd_Position attribute
  theCommands.Add ("SetPosition", 
                   "SetPosition (DF, entry, X, Y, Z)",
                   __FILE__, DDataStd_SetPosition, g);

  theCommands.Add ("GetPosition", 
                   "GetPosition (DF, entry, X(out), Y(out), Z(out))",
                   __FILE__, DDataStd_GetPosition, g);
}
