// File         Graphic3d_GraphicDriver_Print.c
// Created      March 2000
// Author       THA
// e-mail	t-hartl@muenchen.matra-dtv.fr

#define VIRTUAL
/************************************************************************/
/* Includes                                                             */
/************************************************************************/

#include <Graphic3d_GraphicDriver.jxx>
#include <Aspect_DriverDefinitionError.hxx>

extern "C" {
#include <InterfaceGraphic_Cextern.hxx>
}


/************************************************************************/
/* Print Methods                                                        */
/************************************************************************/

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::Print (const Graphic3d_CView& , 
									 const Aspect_CLayer2d& , 
									 const Aspect_CLayer2d& , 
									 const Aspect_Handle& ,
									 const Standard_Boolean ,
									 const Standard_CString ) const {
#else
void Graphic3d_GraphicDriver::Print (const Graphic3d_CView& ACView, 
									 const Aspect_CLayer2d& ACUnderLayer, 
									 const Aspect_CLayer2d& ACOverLayer, 
									 const Aspect_Handle& hPrintDC,
									 const Standard_Boolean showBackground
									 const Standard_CString filename) const {

	Graphic3d_CView MyCView = ACView;
	Aspect_CLayer2d MyCUnderLayer = ACUnderLayer;
	Aspect_CLayer2d MyCOverLayer = ACOverLayer;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_print");
		PrintCView (MyCView, 1);
	}
	call_togl_print (&MyCView, &MyCUnderLayer, &MyCOverLayer, hPrintDC, (int)showBackground, filename);
#endif
}
