// File:	MDataStd_GeometryStorageDriver.cxx
// Created:	Wed Nov 19 16:00:50 1997
// Author:	Denis PASCAL
//		<dp@dingox.paris1.matra-dtv.fr>


#include <MDataStd_GeometryStorageDriver.ixx> 
#include <TDataStd_GeometryEnum.hxx>
#include <MDataStd.hxx>
#include <TDataStd_Geometry.hxx>
#include <PDataStd_Geometry.hxx>
#include <CDM_MessageDriver.hxx>


//=======================================================================
//function : MDataStd_GeometryStorageDriver
//purpose  : 
//=======================================================================

MDataStd_GeometryStorageDriver::MDataStd_GeometryStorageDriver(const Handle(CDM_MessageDriver)& theMsgDriver):MDF_ASDriver(theMsgDriver)
{
}


//=======================================================================
//function : VersionNumber
//purpose  : 
//=======================================================================

Standard_Integer MDataStd_GeometryStorageDriver::VersionNumber() const
{ return 0; }


//=======================================================================
//function : SourceType
//purpose  : 
//=======================================================================

Handle(Standard_Type) MDataStd_GeometryStorageDriver::SourceType() const
{ return STANDARD_TYPE (TDataStd_Geometry); }


//=======================================================================
//function : NewEmpty
//purpose  : 
//=======================================================================

Handle(PDF_Attribute) MDataStd_GeometryStorageDriver::NewEmpty() const
{ return new PDataStd_Geometry; }


//=======================================================================
//function : Paste
//purpose  : 
//=======================================================================

void MDataStd_GeometryStorageDriver::Paste (
  const Handle(TDF_Attribute)&        Source,
  const Handle(PDF_Attribute)&        Target,
//  const Handle(MDF_SRelocationTable)& RelocTable) const
  const Handle(MDF_SRelocationTable)& ) const
{
  Handle(TDataStd_Geometry) S = 
     Handle(TDataStd_Geometry)::DownCast (Source);
  Handle(PDataStd_Geometry) T = 
    Handle(PDataStd_Geometry)::DownCast (Target);
  
  T->SetType (MDataStd::GeometryTypeToInteger(S->GetType ()));

}





