/* MPOCRB.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#ifdef WNT
#include <MathBase.h>
#else 
#define  __MathBase_API
#endif
/* Subroutine */ __MathBase_API int mmpocrb_(ndimax, ncoeff, courbe, ndim, tparam, pntcrb)
integer *ndimax, *ncoeff;
doublereal *courbe;
integer *ndim;
doublereal *tparam, *pntcrb;
{
    /* System generated locals */
    integer courbe_dim1, courbe_offset, i__1, i__2;

    /* Local variables */
    static integer ncof2;
    extern /* Subroutine */ int miraz_();
    static integer isize, nd, kcf, ncf;
    extern /* Subroutine */ int mvpscr2_(), mvpscr3_();



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*        CALCULE LES COORDONNEES D'UN POINT D'UNE COURBE DE PARAMETRE */
/*        DONNE TPARAM ( CECI EN 2D, 3D OU PLUS) */

/*     MOTS CLES : */
/*     ----------- */
/*       TOUS , MATH_ACCES :: COURBE&,PARAMETRE& , POSITIONNEMENT , &POINT
 */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*        NDIMAX : format / dimension de la courbe */
/*        NCOEFF : Nbre de coefficients de la courbe */
/*        COURBE : Matrice des coefficients de la courbe */
/*        NDIM   : Dimension utile de l'espace de travail */
/*        TPARAM : Valeur du parametre ou est calcule le point */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*        PNTCRB : Coordonnees du point calcule */

/*     COMMONS UTILISES   : */
/*     ---------------- */

/*      .Neant. */

/*     REFERENCES APPELEES   : */
/*     ---------------------- */
/*     Type  Name */
/*           MIRAZ                MVPSCR2              MVPSCR3 */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*       20-11-89 : JG : VERSION ORIGINALE */
/* > */
/* ***********************************************************************
 */


/* ***********************************************************************
 */

    /* Parameter adjustments */
    courbe_dim1 = *ndimax;
    courbe_offset = courbe_dim1 + 1;
    courbe -= courbe_offset;
    --pntcrb;

    /* Function Body */
    isize = *ndim << 3;
    miraz_(&isize, &pntcrb[1]);

    if (*ncoeff <= 0) {
	goto L9999;
    }

/*   Traitement optimal 3d */

    if (*ndim == 3 && *ndimax == 3) {
	mvpscr3_(ncoeff, &courbe[courbe_offset], tparam, &pntcrb[1]);

/*   Traitement optimal 2d */

    } else if (*ndim == 2 && *ndimax == 2) {
	mvpscr2_(ncoeff, &courbe[courbe_offset], tparam, &pntcrb[1]);

/*   Dimension quelconque - schema de HORNER */

    } else if (*tparam == 0.) {
	i__1 = *ndim;
	for (nd = 1; nd <= i__1; ++nd) {
	    pntcrb[nd] = courbe[nd + courbe_dim1];
/* L100: */
	}
    } else if (*tparam == 1.) {
	i__1 = *ncoeff;
	for (ncf = 1; ncf <= i__1; ++ncf) {
	    i__2 = *ndim;
	    for (nd = 1; nd <= i__2; ++nd) {
		pntcrb[nd] += courbe[nd + ncf * courbe_dim1];
/* L300: */
	    }
/* L200: */
	}
    } else {
	ncof2 = *ncoeff + 2;
	i__1 = *ndim;
	for (nd = 1; nd <= i__1; ++nd) {
	    i__2 = *ncoeff;
	    for (ncf = 2; ncf <= i__2; ++ncf) {
		kcf = ncof2 - ncf;
		pntcrb[nd] = (pntcrb[nd] + courbe[nd + kcf * courbe_dim1]) * *
			tparam;
/* L500: */
	    }
	    pntcrb[nd] += courbe[nd + courbe_dim1];
/* L400: */
	}
    }

L9999:
 return 0   ;
} /* mmpocrb_ */

