/* MNATPT.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"

/* Subroutine */ int mmnatpt_(npoint, ndecop, nptcnt, tparam, tdecop, tcontr, 
	tpospt, typept, iercod)
integer *npoint, *ndecop, *nptcnt;
doublereal *tparam, *tdecop;
integer *tcontr, *tpospt, *typept, *iercod;
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static logical ldbg;
    static integer e, i__;
    extern integer mnfndeb_();
    extern /* Subroutine */ int maermsg_(), mgenmsg_(), mgsomsg_();



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*       DETERMINE LA NATURE DES POINTS (POSITION DANS LA DECOUPE ET */
/*       TYPE DE POINT: POINT A LISSER OU POINT CONTRAINT) */

/*     MOTS CLES : */
/*     ----------- */
/*      RESERVE, LISSAGE, CONTRAINTES, POINTS */

/*     ARGUMENTS D'ENTREE : */
/*     -------------------- */
/*       NPOINT: NOMBRE DE POINTS */
/*       NDECOP: NOMBRE DE DECOUPES */
/*       NPTCNT: NOMBRE DE POINTS CONTRAINTS */
/*       TPARAM: TABLE DES PARAMETRES DES POINTS */
/*       TDECOP: TABLE DES NOEUDS DE DECOUPE */
/*      TCONTR: TABLE DONNANT LE TYPE ET LES INDICES DES POINTS CONTRAINTS
*/

/*     ARGUMENTS DE SORTIE : */
/*     --------------------- */
/*       TPOSPT(I): CONTIENT LE PLUS GRAND NUMERO DE L'ELEMENT E TEL QUE 
*/
/*                  LE PARAMETRE t(I)<= U(E) */
/*       TYPEPT(I): =0 SI LE POINT P(I) EST UN POINT A LISSER */
/*                   =1 ................................CONTRAINT */
/*     COMMONS UTILISES : */
/*     ------------------ */


/*     REFERENCES APPELEES : */
/*     --------------------- */


/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */
/*      POUR QUE LA MATRICE HESSIENNE SOIT DEFINI POSITIV */
/*       LE PREMIER POINT SERA TOUJOURS UN POINT A LISSER */


/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*     2-09-95 : KHN; ECRITURE VERSION ORIGINALE. */
/* > */
/* ***********************************************************************
 */
/*                            DECLARATIONS */
/* ***********************************************************************
 */



/* ***********************************************************************
 */
/*                      INITIALISATIONS */
/* ***********************************************************************
 */

    /* Parameter adjustments */
    --typept;
    --tpospt;
    --tparam;
    tcontr -= 3;

    /* Function Body */
    ldbg = mnfndeb_() >= 2;
    if (ldbg) {
	mgenmsg_("MMNATPT", 7L);
    }
    *iercod = 0;
    i__1 = *npoint;
    for (i__ = 1; i__ <= i__1; ++i__) {
	typept[i__] = 0;
    }

/* ***********************************************************************
 */
/*                     TRAITEMENT */
/* ***********************************************************************
 */

    if (*nptcnt > *npoint) {
	goto L9101;
    }


    e = 1;
    i__1 = *npoint;
    for (i__ = 1; i__ <= i__1; ++i__) {
	if (tparam[i__] <= tdecop[e]) {
	    tpospt[i__] = e;
	} else {
	    while(tparam[i__] > tdecop[e]) {
		++e;
	    }
	    tpospt[i__] = e;
	}
    }

/*     --- les premiers et derniers points apparaissent toujours dans les 
*/
/*         moindres carres afin de garantir l'inversibilite de H. */

    i__1 = *nptcnt - 1;
    for (i__ = 2; i__ <= i__1; ++i__) {
	typept[tcontr[(i__ << 1) + 1]] = 1;
    }




    goto L9999;

/* ***********************************************************************
 */
/*                   TRAITEMENT DES ERREURS */
/* ***********************************************************************
 */


L9101:
    *iercod = 1;
    goto L9999;


/* ***********************************************************************
 */
/*                   RETOUR PROGRAMME APPELANT */
/* ***********************************************************************
 */

L9999:


    maermsg_("MMNATPT", iercod, 7L);
    if (ldbg) {
	mgsomsg_("MMNATPT", 7L);
    }
 return 0 ;
} /* mmnatpt_ */

