/* MOTLIS.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#include <Data_Data.h>
/* Common Block Declarations */

/*extern __Data_API struct {*/
extern struct {
    integer nbr[1001];
} minombr_;

#define minombr_1 minombr_

/* Table of constant values */

static integer c__100 = 100;
static integer c__30 = 30;
static integer c__500 = 500;

/* Subroutine */ int mmotlis_(ndimen, nbcrmx, ncflim, nbrpnt, nbcntr, orcont, 
	tabpnt, tbpoid, typcnt, tabcnt, tbopnt, matrj1, matrj2, matrj3, 
	vpoids, alpha, jestim, ttheta, tfthet, cblong, tabpar, nbcrbe, ncftab,
	 crbtab, tabint, tbecar, numpnt, errmax, errmoy, valcri, iercod)
integer *ndimen, *nbcrmx, *ncflim, *nbrpnt, *nbcntr, *orcont;
doublereal *tabpnt, *tbpoid;
integer *typcnt;
doublereal *tabcnt, *tbopnt, *matrj1, *matrj2, *matrj3, *vpoids, *alpha, *
	jestim, *ttheta, *tfthet, *cblong, *tabpar;
integer *nbcrbe, *ncftab;
doublereal *crbtab, *tabint, *tbecar;
integer *numpnt;
doublereal *errmax, *errmoy, *valcri;
integer *iercod;
{
    /* Initialized data */

    static integer mxiter = 2;
    static integer mxest = 5;
    static doublereal jesmin[3];

    /* System generated locals */
    integer tabpnt_dim1, tabpnt_offset, tabcnt_dim1, tabcnt_offset, 
	    ttheta_dim1, ttheta_dim2, ttheta_offset, tfthet_dim1, tfthet_dim2,
	     tfthet_offset, crbtab_dim1, crbtab_dim2, crbtab_offset, i__1;
    doublereal d__1;

    /* Builtin functions */
    double sqrt();

    /* Local variables */
    static logical ldbg;
    static integer iter, nest;
    static doublereal poid1, poid2, poid3, cbold[500], erold;
    static integer iregr;
    static doublereal lnold;
    static integer cbsiz, iprog;
    static doublereal vocri[3], tpold[100];
    static integer nsize, tpsiz, icdana, ii, decima, ncbold, ncfold[30];
    static doublereal deltat;
    static logical lencor, lproch;
    static long int ioftvc, ioftpo, iofint, ioftyp, ioftp, 
	           ioftcb, iofncf;
    static logical lestim;
    static integer dimtvc;
    static logical loptim;
    static doublereal errqua;
    static doublereal tvcint[30], epslon;
    extern /* Subroutine */ int macrai4_(), macrdi4_();
    static integer typept[100], tpospt[100];
    extern /* Subroutine */ int macrar8_(), macrdr8_(), mmnewt3_();
    static integer ier;
    extern integer mnfndeb_();
    extern /* Subroutine */ int mmliacr_(), maermsg_(), mmbulld_(), mgenmsg_()
	    , mminimi_(), msifill_(), mmlierq_(), mmlicup_(), msrfill_(), 
	    mgsomsg_();
    static doublereal mat1[231], mat2[231], mat3[231];
    extern /* Subroutine */ int mmotest_();



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*       Moteur d'optimisation du lissage de courbes par une methode */
/*       variationnelle lineaire. */

/*     MOTS CLES : */
/*     ----------- */
/*      LISSAGE, VARIATIONNELLE, JACCOBI */

/*     ARGUMENTS D'ENTREE : */
/*     -------------------- */
/*     NDIMEN : Dimension de l'espace */
/*     NBCRMX : Nombre maxi de courbes polynomiales a calculer. */
/*     NCFLIM : Nombre LIMITE de coeff des "courbes" polynomiales */
/*              d' approximation. */
/*     NBRPNT : Nombre de points a lisser  (>= 2) */
/*     NBCNTR : Nombre de point contraints (<= NBRPNT) */
/*    TABPNT : Tableau des points a lisser, TYPCNT, TABCNT, TBOPNT, DEBFIN
,*/
/*     TYPCNT(1,i) :  Indice du point contraints */
/*     TYPCNT(2,i) :  Type de la contrainte */
/*                    0 -> de passage (G0) */
/*                    1 -> de tangence (G1) */
/*                    2 -> de courbure (G2) */
/*     TABCNT(*,1,i) : Vecteur tangent a respecter */
/*     TABCNT(*,2,i) : Vecteur courbure a respecter */
/*     TBOPNT : Tableau d'option du lissage */
/*        TBOPNT(1) : Nombre de pas d'optimisation */
/*               1 : 1 seul pas ( => pas d'optimisation des parametres) */
/*               > 1 : plusieurs pas et donc optimisation des parametres 
*/
/*        TBOPNT(2) : Decoupe avec ou sans */
/*               0 : Avec decoupe */
/*               1 : Sans decoupe */
/*     VPOIDS : Poid respectif des criteres moindre carreet qualite */
/*        VPOIDS(1) : Poid des moindre carre */
/*        VPOIDS(2) : Poid du critere de "qualite". */
/*     TABPAR : Parametres initiaux affectes aux points. */


/*     ARGUMENTS DE SORTIE : */
/*     --------------------- */
/*     TABPAR : Tableaux des paramtres corespondant aux points a lisser */
/*     NBCRBE : Nombre de courbes polynomiales creees. */
/*     NCFTAB : Table des nombres de coeff. significatifs des NBCRBE */
/*              "courbes" calculees. */
/*     CRBTAB : Tableau des coeff dans la base de jacobi des "courbes" */
/*              polynomiales calculees. */
/*              Doit etre dimensionne a CRBTAB(NDIMEN,NCOFMX,NBCRMX). */
/*     TABINT : Table des NBCRBE + 1 bornes des intervalles de decoupe */
/*       VALCRI(0) : Erreur quadratique */
/*       VALCRI(1) : Energie de Tension linearise */
/*       VALCRI(2) : Energie de Flexion linearise */
/*       VALCRI(3) : "Energie du 3eme ordre" linearise */

/*       IERCOD : code d'erreur */
/*          - 2 : Non respect de l'ecart max */
/*          0   : Ok */
/*         > 0 : Echec */
/*          1   : Arguments invalide */
/*          2   : Erreur dans un sous programme */
/*          3   : Probleme d'allocation dynamique */

/*     COMMONS UTILISES : */
/*     ------------------ */


/*     REFERENCES APPELEES : */
/*     --------------------- */


/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */


/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*     07-06-1996: PMN; Calcul les Estimations minimum en fonction de la */
/*                      taille des donnees.                           */
/*     17-06-1996: PMN; N'optimise les ti que si l'erreur quadratique */
/*                      est petite ( < 2*VPOIDS(2)) */
/*     21-11-1995: PMN; Pb d'allocation sur TVCINT, NCFOLD */
/*      5-10-1995: PMN; ECRITURE VERSION ORIGINALE. */
/* > */
/* ***********************************************************************
 */
/*                            DECLARATIONS */
/* ***********************************************************************
 */


/*     INCLUDE MINOMBR */
/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*        Sert a fournir les constantes entieres de 0 a 1000 */

/*     MOTS CLES : */
/*     ----------- */
/*        TOUS,ENTIERS */

/*     DEMSCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*     11-10-89 : DH ; Creation version originale */
/* > */
/* ***********************************************************************
 */


/* ***********************************************************************
 */







    /* Parameter adjustments */
    tfthet_dim1 = *ndimen;
    tfthet_dim2 = *ndimen - 1;
    tfthet_offset = tfthet_dim1 * (tfthet_dim2 + 1) + 1;
    tfthet -= tfthet_offset;
    ttheta_dim1 = *ndimen;
    ttheta_dim2 = *ndimen - 1;
    ttheta_offset = ttheta_dim1 * (ttheta_dim2 + 1) + 1;
    ttheta -= ttheta_offset;
    tabcnt_dim1 = *ndimen;
    tabcnt_offset = tabcnt_dim1 * 3 + 1;
    tabcnt -= tabcnt_offset;
    --ncftab;
    crbtab_dim1 = *ndimen;
    crbtab_dim2 = *ncflim;
    crbtab_offset = crbtab_dim1 * (crbtab_dim2 + 1) + 1;
    crbtab -= crbtab_offset;
    --matrj3;
    --matrj2;
    --matrj1;
    --tbecar;
    --tabpar;
    --tbpoid;
    tabpnt_dim1 = *ndimen;
    tabpnt_offset = tabpnt_dim1 + 1;
    tabpnt -= tabpnt_offset;
    typcnt -= 3;
    --tbopnt;
    --vpoids;
    --alpha;
    --jestim;

    /* Function Body */



/* ***********************************************************************
 */
/*                      INITIALISATIONS */
/* ***********************************************************************
 */

    ldbg = mnfndeb_() >= 2;
    if (ldbg) {
	mgenmsg_("MMOTLIS", 7L);
    }
    *iercod = 0;

/* ***********************************************************************
 */
/*                     TRAITEMENT */
/* ***********************************************************************
 */

    if (vpoids[1] < 0.) {
	goto L9101;
    }
    if (vpoids[2] < 1e-20) {
	goto L9101;
    }

/* (0.a) allocation dynamique */

    macrai4_(nbrpnt, &c__100, tpospt, &ioftpo, &ier);
    if (ier > 0) {
	goto L9103;
    }
    macrai4_(nbrpnt, &c__100, typept, &ioftyp, &ier);
    if (ier > 0) {
	goto L9103;
    }
    macrai4_(nbcrmx, &c__30, ncfold, &iofncf, &ier);
    if (ier > 0) {
	goto L9103;
    }
    dimtvc = *nbcrmx * 3;
    macrar8_(&dimtvc, &c__30, tvcint, &ioftvc, &ier);
    if (ier > 0) {
	goto L9103;
    }
    cbsiz = *ndimen * *nbcrmx * *ncflim;
    macrar8_(&cbsiz, &c__500, cbold, &ioftcb, &ier);
    if (ier > 0) {
	goto L9103;
    }
    tpsiz = *nbrpnt + *nbcrmx + 1;
    macrar8_(&tpsiz, &c__100, tpold, &ioftp, &ier);
    iofint = ioftp + *nbrpnt + 1;
    if (ier > 0) {
	goto L9103;
    }

/* (0.b) Initialisations */

    if (vpoids[1] == (float)0.) {
/* Computing MAX */
	d__1 = sqrt(jestim[1]);
	vpoids[1] = max(d__1,1.);
    }
    mxiter = (integer) tbopnt[1];

    jesmin[1] = 1.e-8;
    jesmin[2] = jesmin[3] = (jestim[1]+1.e-8)*1.e-6;

    erold = 1e37;
    for (ii = 1; ii <= 3; ++ii) {
	if (jestim[ii] < jesmin[ii - 1]) {
	    jestim[ii] = jesmin[ii - 1];
	}
	vocri[ii - 1] = 1e37;
    }

    poid1 = alpha[1] / jestim[1];
    poid2 = alpha[2] / jestim[2];
    poid3 = alpha[3] / jestim[3];

    nsize = *ncflim * (*ncflim + 1) / 2;
    i__1 = nsize;
    for (ii = 1; ii <= i__1; ++ii) {
	mat1[ii - 1] = matrj1[ii] * poid1;
	mat2[ii - 1] = matrj2[ii] * poid2;
	mat3[ii - 1] = matrj3[ii] * poid3;
    }

    lencor = TRUE_;

/* ============        Optimisation         ============================ 
*/

    while(lencor) {



/* (1) Boucle Optimisation / Estimation */


	lestim = TRUE_;
	nest = 0;

	while(lestim) {

/*     (1.1) Optimisation de la courbe */

	    mminimi_(ndimen, nbcrbe, cblong, ncflim, nbrpnt, nbcntr, orcont, &
		    tabpnt[tabpnt_offset], &tbpoid[1], &typcnt[3], &tabcnt[
		    tabcnt_offset], &tpospt[ioftpo], &typept[ioftyp], mat1, 
		    mat2, mat3, &vpoids[1], &ttheta[ttheta_offset], &tfthet[
		    tfthet_offset], &tabpar[1], tabint, &ncftab[1], &crbtab[
		    crbtab_offset], &tvcint[ioftvc], &ier);
	    if (ier > 0) {
		goto L9102;
	    }

/*        (1.2) calcul des criteres de qualites et amelioration */
/*              des estimation. */

	    mmotest_(ncflim, &matrj1[1], &matrj2[1], &matrj3[1], nbcrbe, &
		    tvcint[ioftvc], &alpha[1], &jestim[1], jesmin, mat1, mat2,
		     mat3, &valcri[1], &icdana, &ier);
	    if (ier > 0) {
		goto L9102;
	    }
	    mmlierq_(ndimen, nbrpnt, ncflim, &ncftab[1], nbcrbe, &tabpnt[
		    tabpnt_offset], &crbtab[crbtab_offset], tabint, &tabpar[1]
		    , errmax, &errqua, errmoy, &ier);
	    if (ier > 0) {
		goto L9102;
	    }
	    lproch = (sqrt(errqua / *nbrpnt) < vpoids[2] * 2) &&
	             (mxiter > 1);

/*       (1.3) Optimisation des ti par proj orthogonale */
/*             et calcul de l'erreur aux points. */

	    if (lproch) {

		mmnewt3_(&minombr_1.nbr[2], ndimen, nbrpnt, ncflim, &ncftab[1]
			, nbcrbe, &tabpnt[tabpnt_offset], &crbtab[
			crbtab_offset], tabint, &tabpar[1], &tbecar[1], 
			errmax, numpnt, &errqua, errmoy, &ier);
		if (ier > 0) {
		    goto L9102;
		}
	    }


/*         (1.4) Test de progression */

	    iprog = 0;
	    if (erold > vpoids[2] && *errmax < erold * (float).95) {
	      iprog = 1;
	    }
	    if (erold > vpoids[2] && *errmax < erold * (float).8) {
	      ++iprog;
	    }
	    if (erold > vpoids[2] && *errmax < vpoids[2]) {
	      ++iprog;
	    }
	    if (erold > vpoids[2] && *errmax < erold * (float).99 && *
		errmax < vpoids[2] * (float)1.1) {
	      ++iprog;
	    }
	    if (valcri[1] < vocri[0] * (float).975) {
	      ++iprog;
	    }
	    if (valcri[1] < vocri[0] * (float).9) {
	      ++iprog;
	    }
	    if (valcri[2] < vocri[1] * (float).95) {
	      ++iprog;
	    }
	    if (valcri[2] < vocri[1] * (float).8) {
	      ++iprog;
	    }
	    if (valcri[3] < vocri[2] * (float).95) {
	      ++iprog;
	    }
	    if (valcri[3] < vocri[2] * (float).8) {
	      ++iprog;
	    }
	    if (vocri[2] > 1e-9 && vocri[2] > 1e-9) {
	      if (valcri[2] / vocri[1] + valcri[3] * 2 / vocri[2] 
		  < (float)2.8) {
		++iprog;
	      }
	    }

	    if (nest == 0 &&iprog < 2) {
	      
/*             (1.5) On invalide la decoupe. */

	      valcri[1] = vocri[0];
	      valcri[2] = vocri[1];
	      valcri[3] = vocri[2];
	      *cblong = lnold;
	      *errmax = erold;

	      *nbcrbe = ncbold;
	      ii = *nbcrbe * *ndimen * *ncflim;
	      msifill_(nbcrbe, &ncfold[iofncf], &ncftab[1]);
	      msrfill_(&ii, &cbold[ioftcb], &crbtab[crbtab_offset]);
	      msrfill_(nbrpnt, &tpold[ioftp], &tabpar[1]);
	      msrfill_(nbcrbe, &tpold[iofint], &tabint[1]);

	      lencor = FALSE_;
	      goto L8000;
	    }

	/*     (1.6) Sauvgarde des criteres */
	    vocri[0] = valcri[1];
	    vocri[1] = valcri[2];
	    vocri[2] = valcri[3];
	    lnold = *cblong;
	    erold = *errmax;    
	  

/*       (1.7) Test si l'estimation est OK, sinon on recommence */

	    ++nest;
	    lestim = (nest < mxest) && (icdana == 2) && (iprog>0);

	    if (lestim && lproch) {

/*           (1.8) Optimisation des ti par ACR. */

		mmbulld_(nbrpnt, &minombr_1.nbr[1], &tabpar[1], &
			minombr_1.nbr[1]);

		decima = 4;
		epslon = *cblong * 1e-6 / *nbrpnt;

		mmliacr_(ndimen, ncflim, nbrpnt, nbcntr, &typcnt[3], &tabpar[
			1], nbcrbe, &ncftab[1], &crbtab[crbtab_offset], 
			tabint, &epslon, &decima, cblong, &ier);
		if (ier > 0) {
		    goto L9102;
		}
	    }

	}



/*     (2) Boucle d'optimisation parametrique / geometrique */

	iter = 1;
	loptim = iter < mxiter && lproch;

	while(loptim) {

	    ++iter;

/*     (2.1) Sauvgarde des criteres */

	    vocri[0] = valcri[1];
	    vocri[1] = valcri[2];
	    vocri[2] = valcri[3];
	    lnold = *cblong;
	    erold = *errmax;

	    msifill_(nbcrbe, &ncftab[1], &ncfold[iofncf]);
	    ii = *nbcrbe * *ndimen * *ncflim;
	    msrfill_(&ii, &crbtab[crbtab_offset], &cbold[ioftcb]);
	    msrfill_(nbrpnt, &tabpar[1], &tpold[ioftp]);
	    msrfill_(nbcrbe, &tabint[1], &tpold[iofint]);

/*     (2.2) Optimisation des ti par ACR. */

/*         ---> On trie, afin d'assurer l'ordre par la suite. */
	    mmbulld_(nbrpnt, &minombr_1.nbr[1], &tabpar[1], &minombr_1.nbr[1])
		    ;

/*         ---> On se rapproche de l'acr */
	    decima = 4;
	    epslon = *cblong * 1e-6 / *nbrpnt;

	    mmliacr_(ndimen, ncflim, nbrpnt, nbcntr, &typcnt[3], &tabpar[1], 
		    nbcrbe, &ncftab[1], &crbtab[crbtab_offset], tabint, &
		    epslon, &decima, cblong, &ier);
	    if (ier > 0) {
		goto L9102;
	    }

/*      (2.3) Optimisation des courbes */

	    mminimi_(ndimen, nbcrbe, cblong, ncflim, nbrpnt, nbcntr, orcont, &
		    tabpnt[tabpnt_offset], &tbpoid[1], &typcnt[3], &tabcnt[
		    tabcnt_offset], &tpospt[ioftpo], &typept[ioftyp], mat1, 
		    mat2, mat3, &vpoids[1], &ttheta[ttheta_offset], &tfthet[
		    tfthet_offset], &tabpar[1], tabint, &ncftab[1], &crbtab[
		    crbtab_offset], &tvcint[ioftvc], &ier);
	    if (ier > 0) {
		goto L9102;
	    }

/*      (2.4) calcul des criteres de qualites et amelioration */
/*              des estimation. */

	    mmotest_(ncflim, &matrj1[1], &matrj2[1], &matrj3[1], nbcrbe, &
		    tvcint[ioftvc], &alpha[1], &jestim[1], jesmin, mat1, mat2,
		     mat3, &valcri[1], &icdana, &ier);
	    if (ier > 0) {
		goto L9102;
	    }


/*       (2.5) Optimisation des ti par proj orthogonale */
/*             et calcul de l'erreur aux points. */

	    mmnewt3_(&minombr_1.nbr[2], ndimen, nbrpnt, ncflim, &ncftab[1], 
		    nbcrbe, &tabpnt[tabpnt_offset], &crbtab[crbtab_offset], 
		    tabint, &tabpar[1], &tbecar[1], errmax, numpnt, &errqua, 
		    errmoy, &ier);
	    if (ier > 0) {
		goto L9102;
	    }

/*       (2.6)  Test de non regression */

	    iregr = 0;
	    if (*nbcntr < *nbrpnt) {
		if (*errmax > vpoids[2] && *errmax > erold * (float)1.05) {
		    ++iregr;
		}
		if (*errmax > vpoids[2] && *errmax > erold * 2) {
		    ++iregr;
		}
		if (erold > vpoids[2] && *errmax <= erold * (float).5) {
		    --iregr;
		}
	    }
	    if (valcri[1] > jestim[1] && valcri[1] > vocri[0] * (float)1.1) {
		++iregr;
	    }
	    if (valcri[2] > jestim[2] && valcri[2] > vocri[1] * (float)1.1) {
		++iregr;
	    }
	    if (valcri[3] > jestim[3] && valcri[3] > vocri[2] * (float)1.1) {
		++iregr;
	    }

	    if (iregr >= 2) {

/*         (2.7) on restaure l'iteration precedente */

		valcri[1] = vocri[0];
		valcri[2] = vocri[1];
		valcri[3] = vocri[2];
		*cblong = lnold;
		*errmax = erold;

		ii = *nbcrbe * *ndimen * *ncflim;
		msifill_(nbcrbe, &ncfold[iofncf], &ncftab[1]);
		msrfill_(&ii, &cbold[ioftcb], &crbtab[crbtab_offset]);
		msrfill_(nbrpnt, &tpold[ioftp], &tabpar[1]);
		msrfill_(nbcrbe, &tpold[iofint], &tabint[1]);

		loptim = FALSE_;
	    }

	    if (iter >= mxiter) {
		loptim = FALSE_;
	    }

	}



/* (3) Decoupe eventuelle */

	if (*nbcrbe < *nbcrmx && tbopnt[2] == 0.) {

/*    (3.1) Sauvgarde de l'etat precedent */

	    ncbold = *nbcrbe;
	    vocri[0] = valcri[1];
	    vocri[1] = valcri[2];
	    vocri[2] = valcri[3];
	    lnold = *cblong;
	    erold = *errmax;

	    ii = *nbcrbe * *ndimen * *ncflim;
	    msifill_(nbcrbe, &ncftab[1], &ncfold[iofncf]);
	    msrfill_(&ii, &crbtab[crbtab_offset], &cbold[ioftcb]);
	    msrfill_(nbrpnt, &tabpar[1], &tpold[ioftp]);
	    msrfill_(nbcrbe, &tabint[1], &tpold[iofint]);

/*       (3.2) On arrange les ti : Trie + recadrage sur (0,1) */

/*         ---> On trie, afin d'assurer l'ordre par la suite. */
	    mmbulld_(nbrpnt, &minombr_1.nbr[1], &tabpar[1], &minombr_1.nbr[1])
		    ;

	    if (tabpar[1] != 0. || tabpar[*nbrpnt] != 1.) {

		deltat = 1. / (tabpar[*nbrpnt] - tabpar[1]);
		i__1 = *nbrpnt - 1;
		for (ii = 2; ii <= i__1; ++ii) {
		    tabpar[ii] = (tabpar[ii] - tabpar[1]) * deltat;
		}
		tabpar[1] = 0.;
		tabpar[*nbrpnt] = 1.;
	    }

/*       (3.3) Subdivision des intervalles */


	    mmlicup_(nbcrmx, &ncbold, ncflim, &ncftab[1], nbrpnt, &tabpar[1], 
		    tabint, nbcrbe, &ier);
	    if (ier > 0) {
		goto L9102;
	    }
	    if (*nbcrbe == ncbold) {
		lencor = FALSE_;
	    }

	} else {
	    lencor = FALSE_;
	}

/*     ================    Fin de la boucle globale  ================
=== */

L8000:

	;
    }

/* (4) Calcul plus fin de l'erreur. */

    mmnewt3_(&minombr_1.nbr[10], ndimen, nbrpnt, ncflim, &ncftab[1], nbcrbe, &
	    tabpnt[tabpnt_offset], &crbtab[crbtab_offset], tabint, &tabpar[1],
	     &tbecar[1], errmax, numpnt, &errqua, errmoy, iercod);
    if (*iercod > 0) {
	goto L9102;
    }

    valcri[0] = errqua;
    valcri[1] = sqrt(valcri[1]);
    valcri[2] = sqrt(valcri[2]);
    valcri[3] = sqrt(valcri[3]);

    if (*nbrpnt > *nbcntr) {
	*errmoy /= *nbrpnt - *nbcntr;
    } else {
	*errmoy /= *nbcntr;
    }


    goto L9999;

/* ***********************************************************************
 */
/*                   TRAITEMENT DES ERREURS */
/* ***********************************************************************
 */


L9101:
    *iercod = 1;
    goto L9999;

L9102:
    *iercod = 2;
    if (ier == 3) {
	*iercod = 3;
    }
    goto L9999;

L9103:
    *iercod = 3;
    goto L9999;


/* ***********************************************************************
 */
/*                   RETOUR PROGRAMME APPELANT */
/* ***********************************************************************
 */

L9999:


/* ___ DESALLOCATION, ... */

    macrdi4_(nbrpnt, &c__100, tpospt, &ioftpo, &ier);
    if (*iercod == 0 && ier > 0) {
	*iercod = 3;
    }
    macrdi4_(nbrpnt, &c__100, typept, &ioftyp, &ier);
    if (*iercod == 0 && ier > 0) {
	*iercod = 3;
    }
    macrdi4_(nbcrmx, &c__30, ncfold, &iofncf, &ier);
    if (*iercod == 0 && ier > 0) {
	*iercod = 3;
    }
    macrdr8_(&dimtvc, &c__30, tvcint, &ioftvc, &ier);
    if (*iercod == 0 && ier > 0) {
	*iercod = 3;
    }
    macrdr8_(&cbsiz, &c__500, cbold, &ioftcb, &ier);
    if (*iercod == 0 && ier > 0) {
	*iercod = 3;
    }
    macrdr8_(&tpsiz, &c__100, tpold, &ioftp, &ier);
    if (*iercod == 0 && ier > 0) {
	*iercod = 3;
    }

    maermsg_("MMOTLIS", iercod, 7L);
    if (ldbg) {
	mgsomsg_("MMOTLIS", 7L);
    }

 return 0 ;
} /* mmotlis_ */

