// -------------------------------------------------------------------------
// Definition des fonctions mathematiques hyperboliques: acosh, asinh, atanh
// pour Windows/NT uniquement.
// -------------------------------------------------------------------------
#ifdef WNT
#include <math.h>
#include <Standard_math.hxx>

#ifndef _Standard_MacroHeaderFile
# include <Standard_Macro.hxx>
#endif  // _Standard_MacroHeaderFile

Standard_EXPORT double  __cdecl acosh( double X)
{
	double  res;
	res = log(X + sqrt(X * X - 1));
	return res;
};
Standard_EXPORT double  __cdecl  asinh( double X)
{
	double  res;
	res = log(X + sqrt(X * X + 1));
	return res;
};
Standard_EXPORT double __cdecl  atanh( double X)
{
	double res;
	res = log((1 + X) / (1 - X)) / 2;
	return res;
};
#endif
