// File:	StepToGeom_MakeAxis1Placement.cxx
// Created:	Tue Jun 15 18:35:17 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>
// sln 22.10.2001. CTS23496: If problems with creation of axis's direction occur default direction is used (StepToGeom_MakeAxis1Placement(...) function)

#include <StepToGeom_MakeAxis1Placement.ixx>
#include <StepGeom_Direction.hxx>
#include <StepGeom_CartesianPoint.hxx>
#include <StepToGeom_MakeDirection.hxx>
#include <StepToGeom_MakeCartesianPoint.hxx>
#include <Geom_CartesianPoint.hxx>
#include <Geom_Direction.hxx>
#include <gp_Dir.hxx>
#include <gp_Pnt.hxx>
#include <Geom_Axis1Placement.hxx>
#include <StdFail_NotDone.hxx>

//=============================================================================
// Creation d' un Ax1Placement de Geom a partir d' un axis1_placement de Step
//=============================================================================

StepToGeom_MakeAxis1Placement::StepToGeom_MakeAxis1Placement
  ( const Handle(StepGeom_Axis1Placement)& Axis1)
{
  Handle(StepGeom_CartesianPoint) P;
  Handle(StepGeom_Direction)      D;
  Handle(Geom_CartesianPoint)         P1;
  Handle(Geom_Direction)              D1;
  gp_Pnt                              P2;
  gp_Dir                              D2;

  P = Axis1->Location();
  StepToGeom_MakeCartesianPoint MkPoint(P);
  P1 = MkPoint.Value();
  P2 = P1->Pnt();

  // sln 22.10.2001. CTS23496: If problems with creation of axis direction occur default direction is used
  Standard_Boolean isDefaultDirectionUsed = Standard_True;
  if (Axis1->HasAxis()) {
    D = Axis1->Axis();
    StepToGeom_MakeDirection MkDir(D);
    if(MkDir.IsDone()) {
      D1 = MkDir.Value();
      D2 = D1->Dir();
      isDefaultDirectionUsed = Standard_False;
    }
  }
  
  if(isDefaultDirectionUsed ) 
    D2 = gp_Dir(0.,0.,1.);
  
  theAxis1Placement = new Geom_Axis1Placement(P2,D2);
  done = Standard_True;
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_Axis1Placement) &
      StepToGeom_MakeAxis1Placement::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theAxis1Placement;
}
