// File:	StepToGeom_MakeParabola2d.cxx
// Created:	Thu Sep  1 13:57:24 1994
// Author:	Frederic MAUPAS
//		<fma@minox>


#include <StepToGeom_MakeParabola2d.ixx>
#include <StepGeom_Parabola.hxx>
#include <StepGeom_Axis2Placement2d.hxx>
#include <Geom2d_AxisPlacement.hxx>
#include <StepToGeom_MakeAxisPlacement.hxx>
#include <gp_Ax2.hxx>
#include <gp_Ax22d.hxx>

#include <StdFail_NotDone.hxx>

//=============================================================================
// Creation d' un Parabola de Geom2d a partir d' un Parabola de Step
//=============================================================================

StepToGeom_MakeParabola2d::StepToGeom_MakeParabola2d
  ( const Handle(StepGeom_Parabola)& C)
{
  StepGeom_Axis2Placement           AxisSelect;
  Handle(StepGeom_Axis2Placement2d) A;
  Handle(Geom2d_AxisPlacement)   A1;
  gp_Ax22d                       A2;
  Standard_Real                  focal;

  AxisSelect  = C->Position();
  if (AxisSelect.CaseNum(AxisSelect.Value()) == 1) {
    StepToGeom_MakeAxisPlacement
      MkAxis(Handle(StepGeom_Axis2Placement2d)::DownCast(AxisSelect.Value()));
    A1 = MkAxis.Value();
    A2 = gp_Ax22d( A1->Ax2d() );
    focal  = C->FocalDist(); 
    theParabola = new Geom2d_Parabola(A2, focal);
    done = Standard_True;
  }
  else {
    done= Standard_False;
  }
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom2d_Parabola) &
      StepToGeom_MakeParabola2d::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theParabola;
}
