// File:	TNaming_Name.cxx
// Created:	Fri Mar 21 15:07:41 1997
// Author:	Yves FRICAUD
//		<yfr@claquox.paris1.matra-dtv.fr>


#include <TNaming_Name.ixx>
#include <TNaming_NamingTool.hxx>
#include <TNaming_Naming.hxx>
#include <TNaming_ShapesSet.hxx>
#include <TNaming_Builder.hxx>
#include <TNaming_NamedShape.hxx>
#include <TNaming_Iterator.hxx>
#include <TNaming_NewShapeIterator.hxx>
#include <TNaming_ListOfNamedShape.hxx>
#include <TNaming_ListIteratorOfListOfNamedShape.hxx>
#include <TopExp.hxx>
#include <TopExp_Explorer.hxx>
#include <TopoDS_Compound.hxx>
#include <BRep_Builder.hxx>

#include <TopTools_MapOfShape.hxx>
#include <TopTools_MapIteratorOfMapOfShape.hxx>
#include <TDF_Label.hxx>
#include <TDF_LabelList.hxx>
#include <TDF_LabelMap.hxx>

#include <Standard_NotImplemented.hxx>
#include <Standard_ConstructionError.hxx>
#include <TopTools_Array1OfShape.hxx>
#include <TColStd_Array1OfInteger.hxx>
#include <TopoDS_Wire.hxx>
#include <TopoDS_Shell.hxx>

// mpv modifications 08.04.2002
#include <BRepBuilderAPI_MakeWire.hxx>
#include <BRepBuilderAPI_MakeFace.hxx>
#include <TopoDS.hxx>
#include <TopoDS_Solid.hxx>
#include <TopoDS_Face.hxx>
#include <TopoDS_CompSolid.hxx>
#include <TopoDS_Compound.hxx>

#include <TopoDS_Iterator.hxx>
#include <TopTools_ListOfShape.hxx>
#include <TopTools_ListIteratorOfListOfShape.hxx>
#include <BRepBuilderAPI_MakeSolid.hxx>
// end of mpv modifications 08.04.2002

#define BUC60925

#define OCC273
#define OCC352
#define OCC355
#ifdef DEB
#include <TCollection_AsciiString.hxx>
#include <TDF_Tool.hxx>
#include <BRepTools.hxx>
#include <TNaming_Tool.hxx>
//unreferenced function, commented  
/*static void ModDbgTools_Write(const TopoDS_Shape& shape,
		      const Standard_CString filename) 
{
  ofstream save;
  save.open(filename);
  save << "DBRep_DrawableShape" << endl << endl;
  if(!shape.IsNull()) BRepTools::Write(shape, save);
  save.close();
} 
static void ModDbgTools_WriteCurrentShape(const Handle(TNaming_NamedShape) & NS)
{
  TCollection_AsciiString entry;
  TDF_Tool::Entry(NS->Label(), entry);
  if (!NS.IsNull())
    {
      TopoDS_Shape Sh = TNaming_Tool::CurrentShape (NS);
      if(!Sh.IsNull()) {
	TCollection_AsciiString Entry = entry.Cat("_Cur.brep");
	ModDbgTools_Write(Sh, Entry.ToCString());
      }
      else 
	cout << "ModDbgTools::Write>>> TopoDS_Shape IS NULL on Entry = "<< entry << endl;
    }
  else
    cout << "ModDbgTools::Write>>>  CurrentShape of TNaming_NamedShape IS NULL on Entry = "<< entry << endl;
}*/
#endif

//====================================================================
static Standard_Boolean ValidArgs(const TNaming_ListOfNamedShape& Args)
{
  TNaming_ListIteratorOfListOfNamedShape it(Args);
  for (;it.More();it.Next()) {
    const Handle(TNaming_NamedShape)& aNS = it.Value();
    if(aNS.IsNull()) return Standard_False;
    else 
      if(aNS->IsEmpty()) return Standard_False;
      else 
	if(!aNS->IsValid()) return Standard_False; 
    }
  return Standard_True;
}

//=======================================================================
//function : TNaming_Name
//purpose  : 
//=======================================================================

TNaming_Name::TNaming_Name()
{
}


//=======================================================================
//function : Type
//purpose  : 
//=======================================================================

void TNaming_Name::Type(const TNaming_NameType aType) 
{
  myType = aType;
}

//=======================================================================
//function : Type
//purpose  : 
//=======================================================================

void TNaming_Name::ShapeType(const TopAbs_ShapeEnum T) 
{
  myShapeType = T;
}

//=======================================================================
//function : Shape
//purpose  : 
//=======================================================================

void TNaming_Name::Shape(const TopoDS_Shape& theShape) 
{
  myShape = theShape;
  
}

//=======================================================================
//function : Shape
//purpose  : 
//=======================================================================

TopoDS_Shape TNaming_Name::Shape() const
{
  return myShape;
}

//=======================================================================
//function : Append
//purpose  : 
//=======================================================================

void TNaming_Name::Append(const Handle(TNaming_NamedShape)& arg) 
{
  myArgs.Append (arg);
}

//=======================================================================
//function : StopNamedShape
//purpose  : 
//=======================================================================

void TNaming_Name::StopNamedShape (const Handle(TNaming_NamedShape)& arg) 
{
  myStop = arg;
}

//=======================================================================
//function : Index
//purpose  : 
//=======================================================================

void TNaming_Name::Index (const Standard_Integer I)
{
  myIndex = I;
}


//=======================================================================
//function : TNaming_NameType
//purpose  : 
//=======================================================================

TNaming_NameType TNaming_Name::Type() const 
{
  return myType;
}

//=======================================================================
//function : TNaming_NameType
//purpose  : 
//=======================================================================

TopAbs_ShapeEnum TNaming_Name::ShapeType() const 
{
  return myShapeType;
}

//=======================================================================
//function : Append
//purpose  : 
//=======================================================================

void TNaming_Name::Paste (TNaming_Name& into,
			  const Handle(TDF_RelocationTable)& RT) const
{
  into.myType      = myType;
  into.myShapeType = myShapeType;
  into.myShape     = myShape; //
  into.myArgs.Clear();
  Handle(TNaming_NamedShape) NS;

  for (TNaming_ListIteratorOfListOfNamedShape it(myArgs); it.More(); it.Next()) {
    RT->HasRelocation(it.Value(),NS);
    into.myArgs.Append (NS);
  }
  if (!myStop.IsNull()) {
    RT->HasRelocation(myStop,NS);
    into.myStop = NS;
  }
}

//=======================================================================
//function : Arguments
//purpose  : 
//=======================================================================
      
const TNaming_ListOfNamedShape& TNaming_Name::Arguments() const
{
  return myArgs;
}

//=======================================================================
//function : Arguments
//purpose  : 
//=======================================================================
      
Handle(TNaming_NamedShape) TNaming_Name::StopNamedShape() const
{
  return myStop;
}

//=======================================================================
//function : Index
//purpose  : 
//=======================================================================
      
Standard_Integer TNaming_Name::Index() const
{
  return myIndex;
}

//=======================================================================
//function : MakeShape
//purpose  : 
//=======================================================================

static TopoDS_Shape MakeShape (const TopTools_MapOfShape& MS) 
{  
  if (!MS.IsEmpty ()) {
    TopTools_MapIteratorOfMapOfShape it(MS);
    if (MS.Extent() == 1) {
      return it.Key();
    }
    else {
      TopoDS_Compound C;
      BRep_Builder B;
      B.MakeCompound(C);
      for (; it.More(); it.Next()){ 
	B.Add(C,it.Key());
      }
      return C;
    }
  }
  return TopoDS_Shape();  
}

#ifdef OCC352

//=======================================================================
//function : ShapeWithType
//purpose  : Tries to make shape with given type from given shape
//=======================================================================

static TopoDS_Shape ShapeWithType(const TopoDS_Shape     theShape,
				  const TopAbs_ShapeEnum theType ) {
  if (theShape.IsNull() || theType == TopAbs_SHAPE) return theShape;
  Standard_Integer aType = theShape.ShapeType();
  if (aType == theType) return theShape;

  TopTools_ListOfShape aShapes;
  if (aType == TopAbs_COMPOUND) {
    TopoDS_Iterator anIter(theShape);
    if (anIter.More()) aType = anIter.Value().ShapeType();
    for(;anIter.More();anIter.Next()) aShapes.Append(anIter.Value());
    if (aType == theType) {
      if (aShapes.Extent() == 1) return aShapes.First();
      else return theShape;
    }
  } else aShapes.Append(theShape);

  TopoDS_Shape aResult;
  TopTools_ListIteratorOfListOfShape aListIter(aShapes);

  if (aType < theType) {
    Standard_Integer aCount;
    for(aCount=0;aListIter.More();aListIter.Next()) {
      TopExp_Explorer anExp(aListIter.Value(),theType);
      if (anExp.More()) {
	if (!anExp.Current().IsNull()) {
	  aResult = anExp.Current();
	  aCount++;
	  if (aCount > 1) return theShape;
	}
      }
    }
    if (aCount == 1) return aResult;
  } else { // if the shape type more complex than shapes from aShapes list, try make it
    switch (aType) {
    case TopAbs_VERTEX: // can't do something from vertex
      break;
    case TopAbs_EDGE: {// make wire from edges
      if (theType <= TopAbs_SOLID) break;
      BRepBuilderAPI_MakeWire aMakeWire;
      aMakeWire.Add(aShapes);
      if (!aMakeWire.IsDone()) return theShape;
      if (theType == TopAbs_WIRE) return aMakeWire.Wire();
      aShapes.Clear(); // don't break: we can do something more of it
      aShapes.Append(aMakeWire.Wire());
      aListIter.Initialize(aShapes);
    }
    case TopAbs_WIRE: {// make faceS from wires (one per one)
      if (theType < TopAbs_SOLID) break;
      TopTools_ListOfShape aFaces;
      for(;aListIter.More();aListIter.Next()) {
	BRepBuilderAPI_MakeFace aMakeFace(TopoDS::Wire(aListIter.Value()));
	if (!aMakeFace.IsDone()) aFaces.Append(aMakeFace.Face());
      }
      if (theType == TopAbs_FACE) {
	if (aFaces.Extent() == 1) return aFaces.First();
	return theShape;
      }
      aShapes.Assign(aFaces); // don't break: we can do something more of it
      aListIter.Initialize(aShapes);
    }
    case TopAbs_FACE: {// make shell from faces
      if (theType < TopAbs_SOLID) break;
      BRep_Builder aShellBuilder;
      TopoDS_Shell aShell;
      aShellBuilder.MakeShell(aShell);
      for(;aListIter.More();aListIter.Next()) aShellBuilder.Add(aShell,TopoDS::Face(aListIter.Value()));
      if (theType == TopAbs_SHELL) return aShell;
      aShapes.Clear(); // don't break: we can do something more of it
      aShapes.Append(aShell);
      aListIter.Initialize(aShapes);
    }
    case TopAbs_SHELL: {// make solids from shells (one per one)
      TopTools_ListOfShape aSolids;
      for(;aListIter.More();aListIter.Next()) {
	BRepBuilderAPI_MakeSolid aMakeSolid(TopoDS::Shell(aListIter.Value()));
	if (aMakeSolid.IsDone()) aSolids.Append(aMakeSolid.Solid());
      }
      if (theType == TopAbs_SOLID) {
	if (aSolids.Extent() == 1) return aSolids.First();
	return theShape;
      }
      aShapes.Assign(aSolids); // don't break: we can do something more of it
      aListIter.Initialize(aShapes);
    }
    case TopAbs_SOLID: {// make compsolid from solids
      BRep_Builder aCompBuilder;
      TopoDS_CompSolid aCompSolid;
      aCompBuilder.MakeCompSolid(aCompSolid);
      for(;aListIter.More();aListIter.Next()) aCompBuilder.Add(aCompSolid,TopoDS::Solid(aListIter.Value()));
      if (theType == TopAbs_COMPSOLID) return aCompSolid;
    }
    }
  }
  return theShape;
}

#endif

//=======================================================================
//function : FindModifUntil
//purpose  : 
//=======================================================================

static Standard_Boolean FindModifUntil (TNaming_NewShapeIterator&         it,
			    TopTools_MapOfShape&              MS,
			    const TopoDS_Shape&               S,
			    const Handle(TNaming_NamedShape)& Context)
{ 
  Standard_Boolean found = Standard_False;
  for (; it.More(); it.Next()) {
    if (!it.Shape().IsNull()) {
      if (it.NamedShape() == Context) {
	MS.Add(S);
	found = Standard_True;
      }
      else {
	TNaming_NewShapeIterator it2(it);
	found = FindModifUntil (it2,MS,it.Shape(),Context);
      }
    }
  }
  return found;
}

//=======================================================================
//function : ModifUntil
//purpose  : returns map <theMS> of generators
//=======================================================================

static void SearchModifUntil (const TDF_LabelMap&               /*Valid*/,
			      const Handle(TNaming_NamedShape)& Target,
			      const TNaming_ListOfNamedShape& theListOfGenerators,
			      TopTools_MapOfShape&              theMS)
{
  // Test si S apparait comme oldshape dans Context.
  Standard_Boolean found = Standard_False;
  for (TNaming_ListIteratorOfListOfNamedShape it(theListOfGenerators); it.More(); it.Next()) {
    const Handle(TNaming_NamedShape)& aNS = it.Value();
    
    for (TNaming_Iterator itL (aNS); itL.More(); itL.Next()) { // <- generators
      const TopoDS_Shape& S = itL.NewShape();
      found = Standard_False;
      for  (TNaming_Iterator itC (Target); itC.More(); itC.Next()) {  // <- generated
	const TopoDS_Shape& OS = itC.OldShape();
 	if (OS.IsSame(S)) {
	  theMS.Add(S);
	  found = Standard_True;
	  break;
	}
      }
      if (!found) {
	TNaming_NewShapeIterator it1(itL);
	found = FindModifUntil (it1,theMS,S,Target);
      }
    }
  }
}

//=======================================================================
//function : ModifUntil
//purpose  : 
//=======================================================================

static Standard_Boolean ModifUntil (const TDF_Label&                  L,
				    const TDF_LabelMap&               Valid,
				    const TNaming_ListOfNamedShape&   Args,
				    const Handle(TNaming_NamedShape)& Stop)
{
  TopTools_MapOfShape MS; 
  TDF_LabelMap Forbiden;
#ifdef BUC60925
  if(!ValidArgs(Args)) return Standard_False;
#endif
  TNaming_NamingTool::BuildDescendants (Stop, Forbiden);
  TNaming_NamingTool::CurrentShape  (Valid, Forbiden,Args.Last(),MS);
  
  TNaming_Builder B(L);
  for (TopTools_MapIteratorOfMapOfShape itM(MS); itM.More(); itM.Next()) {
    const TopoDS_Shape& S = itM.Key();
    B.Select(S,S);
  }
  return Standard_True;
}

//=======================================================================
//function : ContShape
//purpose  : 
//=======================================================================

static Standard_Boolean ConstShape (const TDF_Label&                  L,
				    const TDF_LabelMap&               Valid,
				    const TNaming_ListOfNamedShape&   Args,
				    const Handle(TNaming_NamedShape)& Stop,
				    const Standard_Integer            Index)
{
  TopTools_MapOfShape MS; 
  TDF_LabelMap Forbiden;
#ifdef BUC60925
  if(!ValidArgs(Args)) return Standard_False;
#endif
  TNaming_NamingTool::BuildDescendants (Stop, Forbiden);

  TopoDS_Shape S;
  Standard_Integer i = 1;
  for (TNaming_Iterator it(Args.First()); it.More(); it.Next(), i++) {
    if (Index == i) {
      S = it.NewShape();
      break;
    }
  }
  if (S.IsNull()) return Standard_False;

  TNaming_NamingTool::CurrentShapeFromShape  (Valid,Forbiden,L,S,MS);

 
  TNaming_Builder B(L);
  for (TopTools_MapIteratorOfMapOfShape itM(MS); itM.More(); itM.Next()) {
    const TopoDS_Shape& SS = itM.Key();
    B.Select(SS,SS);
  }
  return Standard_True;
}

//=======================================================================
//function : Intersection
//purpose  : 
//=======================================================================

static Standard_Boolean Intersection (const TDF_Label&                  L,
				      const TDF_LabelMap&               Valid,
				      const TNaming_ListOfNamedShape&   Args,
				      const Handle(TNaming_NamedShape)& Stop,
				      const TopAbs_ShapeEnum            ShapeType)
{
  if (Args.IsEmpty()) return Standard_False;
#ifdef BUC60925
  if(!ValidArgs(Args)) return Standard_False;
#endif
  TNaming_ListIteratorOfListOfNamedShape it(Args);  
  TopTools_MapOfShape MS; 
  TDF_LabelMap        Forbiden;
  
  TNaming_NamingTool::BuildDescendants (Stop, Forbiden);
  TNaming_NamingTool::CurrentShape  (Valid, Forbiden,it.Value(),MS);
  TopoDS_Shape  CS = MakeShape(MS);
  TNaming_ShapesSet S(CS,ShapeType);

  it.Next();
  for (; it.More(); it.Next()) {
    MS.Clear();
    TNaming_NamingTool::CurrentShape (Valid,Forbiden,it.Value(),MS);
    CS = MakeShape(MS);
    TNaming_ShapesSet OS(CS,ShapeType);
    S.Filter(OS);
  }

  TNaming_Builder B(L);
  for (TopTools_MapIteratorOfMapOfShape itM(S.Map()); itM.More(); itM.Next()) {
    const TopoDS_Shape& S1 = itM.Key();
    B.Select(S1,S1);
  }
  return Standard_True;
}
//=======================================================================
//function : Union
//purpose  : 
//=======================================================================

static Standard_Boolean Union (const TDF_Label&                  L,
			       const TDF_LabelMap&               Valid,
			       const TNaming_ListOfNamedShape&   Args,
			       const Handle(TNaming_NamedShape)& Stop,
			       const TopAbs_ShapeEnum            ShapeType)
{  
  if (Args.IsEmpty()) return Standard_False;
#ifdef BUC60925
  if(!ValidArgs(Args)) return Standard_False;
#endif
  TNaming_ListIteratorOfListOfNamedShape it(Args);
  TopTools_MapOfShape MS; 
  TDF_LabelMap        Forbiden;
  
  TNaming_NamingTool::BuildDescendants (Stop, Forbiden);
  TNaming_NamingTool::CurrentShape  (Valid, Forbiden,it.Value(),MS);
  TopoDS_Shape  CS = MakeShape(MS);
  TNaming_ShapesSet S(CS,ShapeType);

  it.Next();
  for (; it.More(); it.Next()) {
    MS.Clear();
    TNaming_NamingTool::CurrentShape (Valid, Forbiden,it.Value(),MS);
    CS = MakeShape(MS);
    TNaming_ShapesSet OS(CS,ShapeType);
    S.Add(OS);
  }

  TNaming_Builder B(L);

#ifdef OCC352

  BRep_Builder aCompoundBuilder;
  TopoDS_Compound aCompound;
  aCompoundBuilder.MakeCompound(aCompound);
  for (TopTools_MapIteratorOfMapOfShape itM(S.Map()); itM.More(); itM.Next()) {
    aCompoundBuilder.Add(aCompound,itM.Key());
  }
  TopoDS_Shape aShape = ShapeWithType(aCompound,ShapeType);
  B.Select(aShape,aShape);

#else

  for (TopTools_MapIteratorOfMapOfShape itM(S.Map()); itM.More(); itM.Next()) {
    const TopoDS_Shape& S = itM.Key();
    B.Select(S,S);
  }

#endif

  return Standard_True;
}

//=======================================================================
// function: FindShape
//
//=======================================================================
static TopoDS_Shape FindShape(const TopTools_ListOfShape& theList) {
  Standard_Integer anUp = theList.Extent();
  TopoDS_Shape aShape;
  if(anUp < 1) return aShape;
  if(anUp == 1) return theList.First();
  Standard_Integer aLow = 1;
  TColStd_Array1OfInteger Ar1(aLow, anUp); 
  TopTools_Array1OfShape  Ars(aLow, anUp);
  TopTools_ListIteratorOfListOfShape it(theList);
  Standard_Integer i=0;
  for(i=aLow;it.More();it.Next(), i++) {
    Ars.SetValue(i, it.Value());
    Ar1.SetValue(i, 0);
  }
  for(i = aLow;i<= anUp;i++) {
    const TopoDS_Shape& aS = Ars.Value(i);
    for(Standard_Integer j=i;j<=anUp;j++)
      if(aS.IsSame(Ars.Value(j)))
	Ar1.SetValue(i, Ar1.Value(i)+1);
  }
  Standard_Integer aNum = Ar1.Value(1);
  Standard_Integer indx = aLow;
  for(i = aLow;i<= anUp;i++) {
    if(aNum < Ar1.Value(i)) {
       aNum = Ar1.Value(i);
       indx = i;
       }
  }

  return Ars.Value(indx);
}

//=======================================================================
//function : Generation
//purpose  : Resolves Name from arguments
//=======================================================================

static Standard_Boolean  Generated (const TDF_Label&                L,
				    const TDF_LabelMap&             Valid,
				    const TNaming_ListOfNamedShape& Args)
{
  if (Args.Extent() < 2) {
    Standard_ConstructionError::Raise("TNaming_Name::Solve: => Generated");
  }
  // First argument : label of generation
  // Next arguments : generators.

#ifdef BUC60925
  if(!ValidArgs(Args)) return Standard_False;
#endif

  TDF_Label   LabelOfGeneration = Args.First()->Label();

  // Nouvell valeurs des generateurs dans l attribut de generation
  TopTools_MapOfShape aMS;
  TNaming_ListOfNamedShape aGenerators; 
  aGenerators.Assign(Args); 
  aGenerators.RemoveFirst(); 
  SearchModifUntil (Valid, Args.First(), aGenerators, aMS);
  Handle(TNaming_Naming) aNaming;
  TopoDS_Shape aSelection;
  L.FindAttribute(TNaming_Naming::GetID(),aNaming);
  if(!aNaming.IsNull()) 
    aSelection = aNaming->GetName().Shape();

   Handle(TNaming_NamedShape) anOldNS;
   Standard_Integer aVer = -1;// Initial build of name
   L.FindAttribute(TNaming_NamedShape::GetID(),anOldNS);
   if(!anOldNS.IsNull()) 
     aVer = anOldNS->Version();

  TNaming_Builder B(L); // NS
  TopTools_ListOfShape aList;
  for (TopTools_MapIteratorOfMapOfShape itMS(aMS); itMS.More(); itMS.Next()) {
    const TopoDS_Shape& OS = itMS.Key();

    for (TNaming_NewShapeIterator itNew(OS,L); itNew.More(); itNew.Next()) 
      if (itNew.Label() == LabelOfGeneration) 
	aList.Append(itNew.Shape());//szy 21.10.03
  }

  if(aVer == -1) { //initial 
    Standard_Integer i = 1;
    TNaming_Name& aName =  aNaming->ChangeName();
    TopTools_ListIteratorOfListOfShape it(aList);
    if(!aSelection.IsNull()) {
      for(;it.More();it.Next(),i++) {
	if(it.Value().IsSame(aSelection)) {
	  B.Select(it.Value(), it.Value());
	  aName.Index(i); // for debug - index of selection in the list
	  break;
	}
      }
    } else {// Selection == Null
      for(;it.More();it.Next())
	B.Select(it.Value(), it.Value()); 
    }
  }
  else { 
    // *** Regeneration *** //
    if(aList.Extent() == 1) { // trivial case
      TopTools_ListIteratorOfListOfShape it(aList);
      for(;it.More();it.Next())
	B.Select(it.Value(), it.Value()); 
    } 
    else {
      TNaming_Name& aName =  aNaming->ChangeName();
      const TopAbs_ShapeEnum aType = aName.ShapeType();
      TopTools_ListOfShape aList2; 
      TopTools_ListIteratorOfListOfShape it(aList);
      for(;it.More();it.Next()) {
	if(it.Value().ShapeType() == aType) //collect only the same type
	  aList2.Append(it.Value());
      }
      if(!aList2.Extent()) return Standard_False; // Empty

      Standard_Boolean found = Standard_False;
      TopoDS_Shape aShape = FindShape(aList2);
      if(!aShape.IsNull()) found = Standard_True;
      if(found) {
	TopTools_ListOfShape aLM;
	Standard_Boolean aHas = Standard_False;
	Standard_Boolean a1NB = Standard_False;
	if(aGenerators.Extent() != aMS.Extent()) { //missed generators
	  aHas = Standard_True;//has lost generatos
	  for (TNaming_ListIteratorOfListOfNamedShape itg(aGenerators); itg.More(); itg.Next()) {
	    if(!aMS.Contains(itg.Value()->Get())) 
	      aLM.Append(itg.Value()->Get());
	  }
	  if(aLM.Extent() == 1) {//lost 1
	    TopTools_ListIteratorOfListOfShape itm(aLM);
	    TopoDS_Shape aSM = itm.Value(); // Missed
	    for (TopTools_MapIteratorOfMapOfShape itMS1(aMS); itMS1.More(); itMS1.Next()) {
	      const TopoDS_Shape& aS = itMS1.Key();
	      if(aSM.ShapeType() == aS.ShapeType()) {
		if(aS.ShapeType() == TopAbs_EDGE) {
		  TopoDS_Vertex aVCom;
		  if(TopExp::CommonVertex(TopoDS::Edge(aS), TopoDS::Edge(aSM), aVCom))
		    {a1NB = Standard_True; 
		     break;} //lost only 1 neigbour
		} else if(aS.ShapeType() == TopAbs_FACE) {
		  TopExp_Explorer expl1(aS, TopAbs_EDGE);
		  for(;expl1.More();expl1.Next()) {
		    TopExp_Explorer expl2(aSM, TopAbs_EDGE);
		    for(;expl2.More();expl2.Next()) {
		      if(expl1.Current().IsSame(expl2.Current()))
			{a1NB = Standard_True;
			 break;} //lost only 1 neigbour
		    }
		  }
		}
	      }
	    }
// 	    if(aShape.ShapeType() == TopAbs_VERTEX && a1NBE) {
// 	//if atleast 1 Gen was missed and the Gen is Edge
// 	      TopTools_ListIteratorOfListOfShape it(aList);
// 	      for(;it.More();it.Next()) {
// 		if(it.Value().ShapeType() == TopAbs_EDGE) {
// 		  const TopoDS_Shape& aV1 = TopExp::FirstVertex(TopoDS::Edge(it.Value()));
// 		  const TopoDS_Shape& aV2 = TopExp::LastVertex(TopoDS::Edge(it.Value()));
// 		  if(aShape.IsSame(aV1)) {aShape2 =  aV2; 	cout << "##### => V2 " <<endl;break;}
// 		  else 
// 		    if(aShape.IsSame(aV2)) {aShape2 =  aV1;	cout << "##### => V1 " <<endl;break;}
// 		}	  
// 	      }
// 	    }
	  }
	}
	if(!aHas) // all arguments were kept
	  B.Select(aShape, aShape); //only this case is correct on 100%
	else {
	  if (a1NB) //Has, but may be ...
	    B.Select(aShape, aShape); 	
	  else { 
	    // put Compound, may be if possible processed later in Sel. Driver
	    TopTools_ListIteratorOfListOfShape it1(aList2);
	    for(;it1.More();it1.Next())
	      B.Select(it1.Value(), it1.Value()); 
	  }
	}
      }
      else {	//not found
	TopTools_ListIteratorOfListOfShape it2(aList2);
	for(;it2.More();it2.Next())
	  B.Select(it2.Value(), it2.Value()); 
      }
    }
  }    
  return Standard_True;
}
//=======================================================================
//function : Identity
//purpose  : 
//=======================================================================

static Standard_Boolean Identity (const TDF_Label&                L,
				  const TDF_LabelMap&             Valid,
				  const TNaming_ListOfNamedShape& Args,
				  const TopAbs_ShapeEnum          ShapeType)
{
  if (Args.Extent() != 1) {
    Standard_ConstructionError::Raise("TNaming_Name::Solve");
  }
#ifdef BUC60925
  if(!ValidArgs(Args)) return Standard_False;
#endif
  const Handle(TNaming_NamedShape)& A = Args.Last();
  TopTools_MapOfShape MS; 
  TDF_LabelMap        Forbiden;
  TNaming_NamingTool::CurrentShape (Valid,Forbiden,A,MS);

  TNaming_Builder B(L);
  for (TopTools_MapIteratorOfMapOfShape itM(MS); itM.More(); itM.Next()) {
#ifdef OCC352
    const TopoDS_Shape& S = ShapeWithType(itM.Key(),ShapeType);
#else
    const TopoDS_Shape& S = itM.Key();
#endif
    B.Select(S,S);
  }
  return Standard_True;
}

//=======================================================================
//function : FilterByNeighbourgs
//purpose  : 
//=======================================================================

static Standard_Boolean  FilterByNeighbourgs (const TDF_Label&                L,
					      const TDF_LabelMap&             Valid,
					      const TNaming_ListOfNamedShape& Args,
					      const Handle(TNaming_NamedShape)& Stop,
					      const TopAbs_ShapeEnum          ShapeType)
{  

  TNaming_Builder B(L); 

  TDF_LabelMap        Forbiden;
#ifdef BUC60925
  if(!ValidArgs(Args)) return Standard_False;
#endif
  TNaming_NamingTool::BuildDescendants (Stop, Forbiden); 
  if (!Stop.IsNull())    Forbiden.Remove(Stop->Label());
  //----------------------------------------
  // Premier arguments : Ensemble a filtrer.
  //----------------------------------------
  Handle(TNaming_NamedShape) Cand  = Args.First();

  TopTools_MapOfShape    SCand;

#ifdef OCC273
// mpv : use given shape
  TNaming_Iterator itL (Cand);
  for (; itL.More(); itL.Next()) {
    if (!itL.NewShape().IsNull()) SCand.Add(itL.NewShape());
  }
#else
  TNaming_NamingTool::CurrentShape  (Valid, Forbiden,Cand,SCand);
#endif

  //------------------------------------------------------------
  // Autres arguments : contiennent les voisins du bon candidat.
  //------------------------------------------------------------
  TopAbs_ShapeEnum              TC = TopAbs_EDGE;
  if (ShapeType == TopAbs_EDGE) TC = TopAbs_VERTEX;
 
 
//  for (TNaming_Iterator itNS(Cand); itNS.More(); itNS.Next()) {

  for (TopTools_MapIteratorOfMapOfShape itCand(SCand); itCand.More(); itCand.Next()) {
    const TopoDS_Shape& S    = itCand.Key();
    TopTools_MapOfShape Boundaries;
    for (TopExp_Explorer exp(S,TC); exp.More(); exp.Next()) {
      Boundaries.Add (exp.Current());
    }
    
    TNaming_ListIteratorOfListOfNamedShape it(Args);
    it.Next(); 
    Standard_Boolean Keep = 1;
    for ( ; it.More(); it.Next()) {
      Standard_Boolean Connex = 0;
      // Le candidat doit etre  connexe a au moins un shape de
      // chaque NamedShape des voisins.
      const Handle(TNaming_NamedShape)& NSVois = it.Value();
      TopTools_MapOfShape    SVois;

#ifdef OCC273
// mpv : use given shape
      TNaming_Iterator itTL (NSVois);
      for (; itTL.More(); itTL.Next()) {
	if (!itTL.NewShape().IsNull()) {
	  SVois.Add(itTL.NewShape());
	  TNaming_NewShapeIterator aNewIter(itTL.NewShape(),L);
#ifdef OCC355
	  for(;aNewIter.More();aNewIter.Next()) {
	    if (aNewIter.Label().IsNull()) continue;
	    if (Forbiden.Contains(aNewIter.Label())) continue;
	    if (!Valid.IsEmpty() && !Valid.Contains(aNewIter.Label())) continue;
	    if (aNewIter.Shape().ShapeType() != ShapeType) continue;
	    SVois.Add(aNewIter.Shape());
	  }
#else
	  for(;aNewIter.More();aNewIter.Next()) SVois.Add(aNewIter.Shape());
#endif
	}
      }
#else
      TNaming_NamingTool::CurrentShape  (Valid, Forbiden,NSVois,SVois);
#endif

      for (TopTools_MapIteratorOfMapOfShape itVois(SVois); itVois.More(); itVois.Next()) {
	const TopoDS_Shape& Vois = itVois.Key();
	for (TopExp_Explorer exp1(Vois,TC); exp1.More(); exp1.Next()) {
	  if (Boundaries.Contains(exp1.Current())) {
	    Connex = 1;
	    break;
	  }
	}
	if (Connex) break;
      }
      if (!Connex) {
	Keep = 0;
	break;
      }
    }
    if (Keep) {
      B.Select (S,S);
    }
  }
  return Standard_True;
}

//=======================================================================
//function : Solve
//purpose  : 
//=======================================================================

Standard_Boolean TNaming_Name::Solve(const TDF_Label&    aLab,
				     const TDF_LabelMap& Valid) const
{
  Standard_Boolean Done = 0;

  switch (myType) {
  case TNaming_UNKNOWN :
    {
      break;
    }  
  case TNaming_IDENTITY :
    {  
      Done = Identity(aLab,Valid,myArgs,myShapeType);
      break;
    }
  case TNaming_MODIFUNTIL:
    {
      Done = ModifUntil (aLab,Valid,myArgs,myStop);
      break;
    }
  case TNaming_GENERATION:
    {
      Done = Generated (aLab,Valid,myArgs);
      break;
    }
  case TNaming_INTERSECTION:
    {
      Done = Intersection (aLab,Valid,myArgs,myStop,myShapeType); 
      break;
    }
  case TNaming_UNION:
    {
      Done = Union (aLab,Valid,myArgs,myStop,myShapeType);
      break;
    }
  case TNaming_SUBSTRACTION: 
    {
      Standard_NotImplemented::Raise();
//      Done = Substraction (aLab,Valid,myArgs);
      break;
    }
  case TNaming_CONSTSHAPE:
    {
      Done = ConstShape (aLab,Valid,myArgs,myStop,myIndex);
      break;
    }
  case TNaming_FILTERBYNEIGHBOURGS:
    {
      Done = FilterByNeighbourgs (aLab,Valid,myArgs,myStop,myShapeType);
      break;
    }
  }
  return Done;
}


