// File:	ViewerTest_EventManager.cxx
// Created:	Thu Aug 27 14:20:19 1998
// Author:	Robert COUBLANC
//		<rob@robox.paris1.matra-dtv.fr>


#include <ViewerTest_EventManager.ixx>
#include <AIS_InteractiveContext.hxx>

ViewerTest_EventManager::ViewerTest_EventManager(const Handle(AIS_InteractiveContext)& Ctx):
myCtx(Ctx){}


void ViewerTest_EventManager::MoveTo(const Standard_Integer XPix, 
				     const Standard_Integer YPix, 
				     const Handle(V3d_View)& aView)
{
  if(!myCtx.IsNull())
    myCtx->MoveTo(XPix,YPix,aView);
}

void ViewerTest_EventManager::Select(const Standard_Integer XPMin,
				     const Standard_Integer  YPMin,
				     const Standard_Integer  XPMax,
				     const Standard_Integer  YPMax, 
				     const Handle(V3d_View)& aView)
{
  if(!myCtx.IsNull())
    myCtx->Select(XPMin,YPMin,XPMax,YPMax,aView);
}

void ViewerTest_EventManager::ShiftSelect(const Standard_Integer  XPMin,
					  const Standard_Integer  YPMin,
					  const Standard_Integer  XPMax,
					  const Standard_Integer  YPMax, 
					  const Handle(V3d_View)& aView)
{ 
  if(!myCtx.IsNull())
    myCtx->AIS_InteractiveContext::ShiftSelect(XPMin,YPMin,XPMax,YPMax,aView,Standard_True);
}
void ViewerTest_EventManager::Select()
{
  if(!myCtx.IsNull())
    myCtx->Select();
}
void ViewerTest_EventManager::ShiftSelect()
{
  if(!myCtx.IsNull())
    myCtx->ShiftSelect(Standard_True);
}
