#include <stdio.h>

#ifdef MEMDBG
#include "memdbg.h"
#endif

#define BLOCKSIZE 256

#include "memory.h"

char *new_string()
/* allocates a new dynamic string structure */
{
	dynamic *tmp;

	tmp=(dynamic *)malloc(sizeof(dynamic));
	if(tmp==NULL)
		return(NULL);
	tmp->length=0;
	tmp->data=(char *)malloc(BLOCKSIZE+1);
	if(tmp->data==NULL)
	{
		free(tmp);
		return(NULL);
	}
	tmp->data[0]='\0';
	tmp->alloc=BLOCKSIZE;
	return((char *)tmp);
}

char *dstring(string)
char *string;
/* returns a pointer to the string itself.  DO NOT MODIFY IT'S LENGTH! */
{
	dynamic *tmp;

	tmp=(dynamic *)string;
	return(tmp->data);
}

int dlength(string)
char *string;
/* returns the length of the given string */
{
	dynamic *tmp;

	tmp=(dynamic *)string;
	return(tmp->length);
}

int del_string(string, loc, len)
/* deletes len characters starting at loc
** returns 1 of ok, 0 if no memory available */
char *string;
int len, loc;
{
	dynamic *tmp;
	char *check;
	char *a,*b, *c;

	if(len==0)
		return(1);
	tmp=(dynamic *)string;
	if(loc+len>tmp->length)
		len=tmp->length-loc;
	/* move end of string */
	a=&tmp->data[loc];
	b=&tmp->data[loc+len];
	c=&tmp->data[tmp->length];
	while(b<=c)
		*(a++)=*(b++);

	tmp->length-=len;
	return(1);
}

int ins_string(string, loc, str)
/* inserts a string at the desired location, allocating extra memory if needed.
** returns 1 of ok, 0 if no memory available */
char *string;
char *str;
int loc;
{
	dynamic *tmp;
	char *check;
	char *a,*b, *c;
	int len=strlen(str);

	if(len==0)
		return(1);
	tmp=(dynamic *)string;
	while(tmp->length+len>tmp->alloc)
	{
		check=(char *)realloc(tmp->data, tmp->alloc+BLOCKSIZE+1);
		if(check==NULL)
			return(0);
		else
		{
			tmp->data=check;
			tmp->alloc+=BLOCKSIZE;
		}
	}
	/* move end of string */
	a=&tmp->data[tmp->length];
	b=&tmp->data[tmp->length+len];
	c=&tmp->data[loc];
	while(a>=c)
		*(b--)=*(a--);

	strncpy(&tmp->data[loc], str, len);
	tmp->length+=len;
	return(1);
}

int ins_char(string, loc, ch)
/* inserts a character at the desired location, allocating extra memory if
	needed.  returns 1 of ok, 0 if no memory available */
char *string;
int ch;
int loc;
{
	dynamic *tmp;
	char *check;
	char *a,*b, *c;

	tmp=(dynamic *)string;
	if(tmp->length==tmp->alloc)
	{
		check=(char *)realloc(tmp->data, tmp->alloc+BLOCKSIZE+1);
		if(check==NULL)
			return(0);
		else
		{
			tmp->data=check;
			tmp->alloc+=BLOCKSIZE;
		}
	}
	/* move end of string */
	a=&tmp->data[tmp->length];
	b=&tmp->data[tmp->length+1];
	c=&tmp->data[loc];
	while(a>=c)
		*(b--)=*(a--);

	tmp->data[loc]=ch;
	tmp->length+=1;
	return(1);
}

int add_string(string, str)
/* adds a string to the dynamic string, allocating extra memory if needed.
** returns 1 of ok, 0 if no memory available */
char *string;
char *str;
{
	dynamic *tmp;
	char *check;

	if(strlen(str)==0)
		return(1);
	tmp=(dynamic *)string;
	while(tmp->length+strlen(str)>tmp->alloc)
	{
		check=(char *)realloc(tmp->data, tmp->alloc+BLOCKSIZE+1);
		if(check==NULL)
			return(0);
		else
		{
			tmp->data=check;
			tmp->alloc+=BLOCKSIZE;
		}
	}
	strcpy(&tmp->data[tmp->length], str);
	tmp->length+=strlen(str);
	return(1);
}

int add_char(string, ch)
/* adds a byte to the dynamic string, allocating extra memory if needed.
** returns 1 of ok, 0 if no memory available */
char *string;
int ch;
{
	dynamic *tmp;
	char *check;

	tmp=(dynamic *)string;
	if(tmp->length==tmp->alloc)
	{
		check=(char *)realloc(tmp->data, tmp->alloc+BLOCKSIZE+1);
		if(check==NULL)
			return(0);
		else
		{
			tmp->data=check;
			tmp->alloc+=BLOCKSIZE;
		}
	}
	tmp->data[tmp->length++]=ch;
	tmp->data[tmp->length]='\0';
	return(1);
}

char *dup_string(string)
dynamic *string;
{
	dynamic *tmp;

	tmp=(dynamic *)malloc(sizeof(dynamic));
	tmp->length=string->length;
	tmp->alloc=string->alloc;
	tmp->data=(char *)malloc(string->alloc+1);
	memcpy(tmp->data, string->data, string->length);
	return((char *)tmp);
}

char *freeze_string(string)
/* pulls the string data out of the dynamic string and makes a static string
** out of it.  returns NULL if there is no memory for the operation */
char *string;
{
	dynamic *tmp;

	tmp=(dynamic *)string;
	string=(char *)tmp->data;
	free(tmp);
	return(string);
}

#ifdef TESTING
t_memory()
{
	char *test;
	char *the;

	test=new_string();
	add_char(test, 'a');
	add_char(test, 'g');
	add_char(test, 'a');
	add_char(test, 'r');
	the=dstring(test);
	printf("should be: 'agar'\n");
	printf("%s\n", the);
	if(strcmp(the, "agar")!=0)
		printf("new;add a;add g;add a;add r;dstring!='agar'\n");
	add_string(test, " says hello when the moon shines!");
	the=dstring(test);
	printf("should be: 'agar says hello when the moon shines!'\n");
	printf("%s\n", the);
	if(strcmp(the, "agar says hello when the moon shines!")!=0)
		printf("new;add a;add g;add a;add r;add \"says...\";dstring!='agar says ...!'\n");
	del_string(test, 5, 11);
	the=dstring(test);
	printf("should be: 'agar when the moon shines!'\n");
	printf("%s\n", the);
	if(strcmp(the, "agar when the moon shines!")!=0)
		printf("del_string failed\n");
	ins_char(test, 0, 'h');
	the=dstring(test);
	printf("should be: 'hagar when the moon shines!'\n");
	printf("%s\n", the);
	if(strcmp(the, "hagar when the moon shines!")!=0)
		printf("ins_char failed\n");
	ins_string(test, 6, "says hello ");
	the=dstring(test);
	printf("should be: 'hagar says hello when the moon shines!'\n");
	printf("%s\n", the);
	if(strcmp(the, "hagar says hello when the moon shines!")!=0)
		printf("ins_string failed\n");
	del_string(test, 30, 30);
	the=dstring(test);
	printf("should be: 'hagar says hello when the moon'\n");
	printf("%s\n", the);
	if(strcmp(the, "hagar says hello when the moon")!=0)
		printf("del_string past end failed\n");
	add_string(test, " is full!");
	the=dstring(test);
	printf("should be: 'hagar says hello when the moon is full!'\n");
	printf("%s\n", the);
	if(strcmp(the, "hagar says hello when the moon is full!")!=0)
		printf("add_string after del_string past end failed\n");
	test=freeze_string(test);
	printf("should be: 'hagar says hello when the moon is full!'\n");
	printf("%s\n", test);
	if(strcmp(test, "hagar says hello when the moon is full!")!=0)
		printf("freeze_string failed\n");
	
	printf("I love it when a plan comes together!!!\n");
}
#endif /* TESTING */
