#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "interface.h"

#include "treedata.h"

#include "pics/flip_csr"
#include "pics/flip_msk"
#include "pics/tree_csr"
#include "pics/tree_msk"
#include "pics/i_beam_csr"
#include "pics/i_beam_msk"
#include "pics/move_csr"
#include "pics/move_msk"
#include "pics/hide_csr"
#include "pics/hide_msk"

static tpbutton flipb, etextb, etreeb=NULL, moveb, helpb, hideb;
static tcursor flipc, etextc, etreec, movec, helpc, hidec;
static tpic flipp, etextp, etreep, movep, helpp, hidep;

int do_flipb(b, e)
tpbutton b;
tevent e;
{
	tcursor_set(flipc, globals->c);
	do_command(GoEditFlip, NULL, NULL, 0.0, 0.0,
		0, 0, 0, 0, 0);
}

int do_etextb(b, e)
tpbutton b;
tevent e;
{
	tcursor_set(etextc, globals->c);
	do_command(GoEditText, NULL, NULL, 0.0, 0.0,
		0, 0, 0, 0, 0);
}

int do_etreeb(b, e)
tpbutton b;
tevent e;
{
	tcursor_set(etreec, globals->c);
	do_command(GoEditTree, NULL, NULL, 0.0, 0.0,
		0, 0, 0, 0, 0);
}

int do_moveb(b, e)
tpbutton b;
tevent e;
{
	tcursor_set(movec, globals->c);
	do_command(GoEditMove, NULL, NULL, 0.0, 0.0,
		0, 0, 0, 0, 0);
}

int do_helpb(b, e)
tpbutton b;
tevent e;
{
	tcursor_set(helpc, globals->c);
	/*do_command(GoEditHelp, NULL, NULL, 0.0, 0.0,*/
		/*0, 0, 0, 0, 0);*/
}

int do_hideb(b, e)
tpbutton b;
tevent e;
{
	tcursor_set(hidec, globals->c);
	do_command(GoEditHide, NULL, NULL, 0.0, 0.0,
		0, 0, 0, 0, 0);
}

int create_tools(p, args)
tframe p;
targs args;
{
	flipp=(tpic)tpic_new(flip_csr_bits,
		flip_csr_width, flip_csr_height);
	etextp=(tpic)tpic_new(i_beam_csr_bits,
		i_beam_csr_width, i_beam_csr_height);
	etreep=(tpic)tpic_new(tree_csr_bits,
		tree_csr_width, tree_csr_height);
	movep=(tpic)tpic_new(move_csr_bits,
		move_csr_width, move_csr_height);
	hidep=(tpic)tpic_new(hide_csr_bits,
		hide_csr_width, hide_csr_height);
	/*helpp=(tpic)tpic_new(help_csr_bits,*/
		/*help_csr_width, help_csr_height);*/

	flipc=(tcursor)tcursor_new(p, flip_csr_width, flip_csr_height,
		flip_csr_x_hot, flip_csr_y_hot,
		flip_csr_bits, flip_msk_bits,
		globals->b, globals->w);
	etextc=(tcursor)tcursor_new(p, i_beam_csr_width, i_beam_csr_height,
		i_beam_csr_x_hot, i_beam_csr_y_hot,
		i_beam_csr_bits, i_beam_msk_bits,
		globals->b, globals->w);
	etreec=(tcursor)tcursor_new(p, tree_csr_width, tree_csr_height,
		tree_csr_x_hot, tree_csr_y_hot,
		tree_csr_bits, tree_msk_bits,
		globals->b, globals->w);
	movec=(tcursor)tcursor_new(p, move_csr_width, move_csr_height,
		move_csr_x_hot, move_csr_y_hot,
		move_csr_bits, move_msk_bits,
		globals->b, globals->w);
	hidec=(tcursor)tcursor_new(p, hide_csr_width, hide_csr_height,
		hide_csr_x_hot, hide_csr_y_hot,
		hide_csr_bits, hide_msk_bits,
		globals->b, globals->w);
	/*helpc=(tcursor)tcursor_new(p, help_csr_width, help_csr_height,*/
		/*help_csr_x_hot, help_csr_y_hot,*/
		/*help_csr_bits, help_msk_bits,*/
		/*globals->b, globals->w);*/
}

int create_tool_buttons(p, menus)
tpanel p;
titem menus;
{
	int i;

	tcursor_set(etreec, globals->c);

	if(etreeb!=NULL)
		return(1);

	etreeb=(tpbutton)tpbutton_new_image(p,
		10,10,0,0,NULL,menus,etreep);
    tpbutton_set_event_procedure(etreeb, do_etreeb);
    etextb=(tpbutton)tpbutton_new_image(p,
		0,0,0,0,etreeb,menus,etextp);
    tpbutton_set_event_procedure(etextb, do_etextb);
    moveb=(tpbutton)tpbutton_new_image(p,
		0,0,0,0,etextb,menus,movep);
    tpbutton_set_event_procedure(moveb, do_moveb);
    flipb=(tpbutton)tpbutton_new_image(p,
		0,0,0,0,moveb,menus,flipp);
    tpbutton_set_event_procedure(flipb, do_flipb);
    hideb=(tpbutton)tpbutton_new_image(p,
		0,0,0,0,flipb,menus,hidep);
    tpbutton_set_event_procedure(hideb, do_hideb);
}

int set_tool_cursor(m)
mouse_mode m;
{
	switch(m)
	{
		case MouseTree:
			tcursor_set(etreec, globals->c);
			break;
		case MouseText:
			tcursor_set(etextc, globals->c);
			break;
		case MouseFlip:
			tcursor_set(flipc, globals->c);
			break;
		case MouseReRoot:
			break;
		case MouseMove:
			tcursor_set(movec, globals->c);
			break;
		case MouseHide:
			tcursor_set(hidec, globals->c);
			break;
		default:
			break;
	}
}
