/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt;

import ca.odell.glazedlists.impl.adt.IndexedTree;
import ca.odell.glazedlists.impl.adt.IndexedTreeNode;
import java.util.NoSuchElementException;

public class IndexedTreeIterator {
    private IndexedTree host = null;
    private IndexedTreeNode nextNode = null;
    private int nextIndex = 0;
    private IndexedTreeNode last = null;

    public IndexedTreeIterator(IndexedTree host, int index) {
        if (index < 0 || index > host.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.host = host;
        this.nextIndex = index;
        this.nextNode = this.nextIndex == host.size() ? null : host.root.getNodeWithIndex(this.nextIndex);
    }

    public IndexedTreeIterator(IndexedTree host, IndexedTreeNode nextNode) {
        if (host == null || nextNode == null) {
            throw new IllegalArgumentException();
        }
        this.host = host;
        this.nextNode = nextNode;
        this.nextIndex = this.nextNode.getIndex();
    }

    public boolean hasNext() {
        return this.nextIndex < this.host.size();
    }

    public int nextIndex() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nextIndex;
    }

    public IndexedTreeNode next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.last = this.nextNode;
        this.incrementNextNode();
        return this.last;
    }

    public boolean hasPrevious() {
        return this.nextIndex > 0;
    }

    public int previousIndex() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.nextIndex - 1;
    }

    public IndexedTreeNode previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.decrementNextNode();
        this.last = this.nextNode;
        return this.last;
    }

    public void remove() {
        if (this.last == null) {
            throw new NoSuchElementException();
        }
        this.last.removeFromTree(this.host);
        this.last = null;
        this.nextIndex = this.nextNode == null ? this.host.size() : this.nextNode.getIndex();
    }

    private void incrementNextNode() {
        this.nextNode = this.nextNode.next();
        ++this.nextIndex;
    }

    private void decrementNextNode() {
        this.nextNode = this.nextNode == null ? this.host.getNode(this.nextIndex - 1) : this.nextNode.previous();
        --this.nextIndex;
    }
}

