/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: offmgr_hyprlink.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:19:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifdef PRECOMPILED
#include "ofapch.hxx"
#endif

#pragma hdrstop

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef _INETIMG_HXX
#include <svtools/inetimg.hxx>
#endif
#ifndef _URLBMK_HXX
#include <svtools/urlbmk.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX
#include <bf_sfx2/viewfrm.hxx>
#endif
#ifndef _SFXDOCFILE_HXX
#include <bf_sfx2/docfile.hxx>
#endif
#ifndef _SFXIMGMGR_HXX //autogen
#include <bf_sfx2/imgmgr.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _SVX_HLNKITEM_HXX
#include <bf_svx/hlnkitem.hxx>
#endif
#ifndef _SVX_DIALOGS_HRC
#include <bf_svx/dialogs.hrc>
#endif
#include <svtools/urihelper.hxx>
#ifndef _OFF_APP_HXX
#include <app.hxx>
#endif
#include "hyprlink.hrc"
#include "resid.hxx"

#include "hyprlink.hxx"
#include "hyprdlg.hxx"
#include "so3/staticbaseurl.hxx"
namespace binfilter {

using namespace ::rtl;
using namespace ::com::sun::star;

// STATIC DATA -----------------------------------------------------------

/*************************************************************************
|*
|* Dialog zum Einf"ugen/"Andern eines Hyperlink
|*
\************************************************************************/

//STRIP001 SvxHyperlinkDlg::SvxHyperlinkDlg( SfxBindings *pBindings, Window* pParent) :
//STRIP001 
//STRIP001 	SfxControllerItem	( SID_HYPERLINK_SETLINK, *pBindings ),
//STRIP001 	ToolBox				( pParent, OffResId( RID_SVXDLG_HYPERLINK ) ),
//STRIP001 
//STRIP001 	aForwarder			( SID_HYPERLINK_GETLINK, *this ),
//STRIP001 	aHyperlinkDlgForward( SID_HYPERLINK_DIALOG , *this),
//STRIP001 
//STRIP001 	aNameCB				( this, ResId( CB_NAME ) ),
//STRIP001 	aUrlFT				( this, ResId( FT_URL ) ),
//STRIP001 	aUrlCB				( this, ResId( CB_URL ) ),
//STRIP001     aSearchConfig       (sal_True),
//STRIP001 	sAddress			( ResId( STR_ADDRESS ) ),
//STRIP001 	sExplorer			( ResId( STR_EXPLORER ) ),
//STRIP001 	sSearchTitle		( ResId( STR_BOOKMARK_SEARCH ) ),
//STRIP001 	aLinkPopup			( OffResId( RID_SVXMN_HYPERLINK) ),
//STRIP001 	pTargetMenu			( NULL ),
//STRIP001 
//STRIP001 	bHasOldName			( FALSE ),
//STRIP001 	bNoDoc				( TRUE ),
//STRIP001 	bHtmlMode			( FALSE )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001     mpManager = pBindings->GetImageManager();
//STRIP001 	mpManager->RegisterToolBox( this );
//STRIP001 
//STRIP001 	SetImages();
//STRIP001 
//STRIP001 	// save initial size
//STRIP001 	nMaxWidth = GetSizePixel().Width();
//STRIP001 	nMaxHeight = GetSizePixel().Height();
//STRIP001 
//STRIP001 	SetSizePixel(CalcWindowSizePixel());	// Groesse initialisieren
//STRIP001 
//STRIP001 	nMaxHeight = GetSizePixel().Height();	// Hoehe nochmal merken, da sie veraendert wurde
//STRIP001 											// SetSizePixel ruft Resize-Handler!
//STRIP001 
//STRIP001 	InsertSeparator( 0 );
//STRIP001 	InsertWindow( CB_URL, &aUrlCB, 0, 0 );
//STRIP001 	// we need an item text for accessibility
//STRIP001 	String sItemText = aUrlCB.GetText();
//STRIP001 	if ( sItemText.Len() == 0 )
//STRIP001 		sItemText = aUrlCB.GetQuickHelpText();
//STRIP001 	if ( sItemText.Len() > 0 )
//STRIP001 	{
//STRIP001 		SetItemText( CB_URL, sItemText );
//STRIP001 		sItemText.Erase();
//STRIP001 	}
//STRIP001 	InsertWindow( FT_URL, &aUrlFT, 0, 0 );
//STRIP001 	InsertSeparator( 0 );
//STRIP001 	InsertWindow( CB_NAME, &aNameCB, 0, 0 );
//STRIP001 	sItemText = aNameCB.GetText();
//STRIP001 	if ( sItemText.Len() == 0 )
//STRIP001 		sItemText = aNameCB.GetQuickHelpText();
//STRIP001 	if ( sItemText.Len() > 0 )
//STRIP001 		SetItemText( CB_NAME, sItemText );
//STRIP001 
//STRIP001 	Show();
//STRIP001 	Resize();
//STRIP001 
//STRIP001 	long nUrlWidth = aUrlCB.GetResizeWidth();
//STRIP001 	long nNameWidth = aNameCB.GetResizeWidth();
//STRIP001 	long nSum = nUrlWidth + nNameWidth;
//STRIP001 
//STRIP001 	aUrlCB.SetRatio((nUrlWidth * 100L) / nSum);
//STRIP001 	aNameCB.SetRatio((nNameWidth * 100L) / nSum);
//STRIP001 
//STRIP001 	aTimer.SetTimeout( 250 );
//STRIP001 	aTimer.SetTimeoutHdl( LINK( this, SvxHyperlinkDlg, TimeHdl ) );
//STRIP001 
//STRIP001 	SetClickHdl( LINK( this, SvxHyperlinkDlg, TBClickHdl ) );
//STRIP001 	SetSelectHdl( LINK( this, SvxHyperlinkDlg, TBSelectHdl ) );
//STRIP001 	SetDeactivateHdl( LINK( this, SvxHyperlinkDlg, TBDeactivateHdl ) );
//STRIP001 
//STRIP001 	aLinkPopup.SetSelectHdl(LINK(this, SvxHyperlinkDlg, LinkPopupSelectHdl));
//STRIP001 
//STRIP001 	Link aLk = LINK(this, SvxHyperlinkDlg, ComboSelectHdl);
//STRIP001 	aNameCB.SetSelectHdl(aLk);
//STRIP001 	aUrlCB.SetSelectHdl(aLk);
//STRIP001 
//STRIP001 	aLk = LINK(this, SvxHyperlinkDlg, ComboModifyHdl);
//STRIP001 	aNameCB.SetModifyHdl(aLk);
//STRIP001 	aUrlCB.SetModifyHdl(aLk);
//STRIP001 
//STRIP001     // Accessibility: Set the quick help text as accessible name for the
//STRIP001     // drop down lists.
//STRIP001     aNameCB.SetAccessibleName (aNameCB.GetQuickHelpText());
//STRIP001     aUrlCB.SetAccessibleName (aUrlCB.GetQuickHelpText());
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001SvxHyperlinkDlg::~SvxHyperlinkDlg()
//STRIP001{
//STRIP001    SfxImageManager* pManager = GetBindings().GetImageManager();
//STRIP001	pManager->ReleaseToolBox(this);
//STRIP001
//STRIP001	if (pTargetMenu != NULL)
//STRIP001		delete pTargetMenu;
//STRIP001}

/*--------------------------------------------------------------------
	Beschreibung: Leiste so resizen, dass die Comboboxen automatisch mit
	verkleinert werden
 --------------------------------------------------------------------*/

//STRIP001 void SvxHyperlinkDlg::Resize()
//STRIP001 {
//STRIP001 	long nWidth = GetSizePixel().Width();
//STRIP001 
//STRIP001 	ToolBox::Resize();
//STRIP001 
//STRIP001 	if (nWidth)	// nWidth ist manchmal 0
//STRIP001 	{
//STRIP001 		long nDeltaW = nMaxWidth - nWidth + aUrlCB.LogicToPixel(Size(3, 1)).Width() + 1;
//STRIP001 
//STRIP001 		long nNewUrlWidth = aUrlCB.CalcResizeWidth(nDeltaW);
//STRIP001 		long nNewNameWidth = aNameCB.CalcResizeWidth(nDeltaW);
//STRIP001 
//STRIP001 		if (nNewUrlWidth && nNewNameWidth)	// Flackern reduzieren
//STRIP001 		{
//STRIP001 			SetUpdateMode(FALSE);
//STRIP001 
//STRIP001 			// Comboboxen resizen
//STRIP001 			aUrlCB.DoResize(nNewUrlWidth);
//STRIP001 			aNameCB.DoResize(nNewNameWidth);
//STRIP001 			RecalcItems();	// Alle Elemente neu anordnen
//STRIP001 
//STRIP001 			SetUpdateMode(TRUE);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 void SvxHyperlinkDlg::Resizing(Size& rSize)
//STRIP001 {
//STRIP001 	if (rSize.Height() > nMaxHeight)
//STRIP001 		rSize.Height() = nMaxHeight;
//STRIP001 
//STRIP001 	if (rSize.Width() > nMaxWidth)
//STRIP001 		rSize.Width() = nMaxWidth;
//STRIP001 
//STRIP001 	ToolBox::Resizing(rSize);
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung: Im Dokument selektierten Hyperlink in Leiste anzeigen
 --------------------------------------------------------------------*/

//STRIP001 void SvxHyperlinkDlg::StateChanged( USHORT nSID, SfxItemState eState,
//STRIP001 													const SfxPoolItem* pState )
//STRIP001 {
//STRIP001 	if ( nSID == SID_HYPERLINK_DIALOG )
//STRIP001 	{
//STRIP001 		if( eState != SFX_ITEM_DISABLED)
//STRIP001 		{
//STRIP001 			EnableItem( BTN_OPENDIALOG, TRUE );
//STRIP001 
//STRIP001 			BOOL bItem = FALSE;
//STRIP001 			if ( pState && eState == SFX_ITEM_AVAILABLE )
//STRIP001 					bItem = ((SfxBoolItem*)pState)->GetValue();
//STRIP001 			SetItemState ( BTN_OPENDIALOG, bItem ? STATE_CHECK : STATE_NOCHECK );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SetItemState ( BTN_OPENDIALOG, STATE_NOCHECK );
//STRIP001 			EnableItem( BTN_OPENDIALOG, FALSE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nSID == SID_HYPERLINK_SETLINK)
//STRIP001 	{
//STRIP001 		if (eState == SFX_ITEM_DISABLED)
//STRIP001 			bNoDoc = TRUE;
//STRIP001 		else
//STRIP001 			bNoDoc = FALSE;
//STRIP001 		EnableItem(BTN_TARGET, !bNoDoc);
//STRIP001 		EnableLink();
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nSID == SID_HYPERLINK_GETLINK)
//STRIP001 	{
//STRIP001 		if (eState == SFX_ITEM_AVAILABLE)
//STRIP001 		{
//STRIP001 			const SvxHyperlinkItem& rHLnkItem = *((const SvxHyperlinkItem*)pState);
//STRIP001 
//STRIP001 			USHORT nNamePos = aNameCB.GetEntryPos(aNameCB.GetText());
//STRIP001 			USHORT nUrlPos = aUrlCB.GetEntryPos(aUrlCB.GetText());
//STRIP001 			USHORT nNotFound = COMBOBOX_ENTRY_NOTFOUND;
//STRIP001 
//STRIP001 			if (!bHasOldName &&
//STRIP001 				(nNamePos == nNotFound || nUrlPos == nNotFound))
//STRIP001 			{
//STRIP001 				sOldName = aNameCB.GetText();
//STRIP001 				bHasOldName = TRUE;
//STRIP001 			}
//STRIP001 			if (rHLnkItem.GetName().Len())
//STRIP001 			{
//STRIP001 				aNameCB.SetText(rHLnkItem.GetName());
//STRIP001 				::com::boModifyHdl(&aNameCB);
//STRIP001 			}
//STRIP001 			if (rHLnkItem.GetURL().Len() || rHLnkItem.GetName().Len())
//STRIP001 			{
//STRIP001 				String sUrl = INetURLObject(rHLnkItem.GetURL()).GetURLNoPass();
//STRIP001 				aUrlCB.SetText(sUrl);
//STRIP001 			}
//STRIP001 			else if (aUrlCB.GetEntryCount())
//STRIP001 			{	// Letzten Eintrag wieder selektieren
//STRIP001 				aNameCB.SetText(aNameCB.GetEntry(0));
//STRIP001 				aUrlCB.SetText(aUrlCB.GetEntry(0));
//STRIP001 			}
//STRIP001 
//STRIP001 			TargetMenu(rHLnkItem.GetTargetFrame(), FALSE);
//STRIP001 			bHtmlMode = (rHLnkItem.GetInsertMode() & HLINK_HTMLMODE) != 0;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			return;
//STRIP001 
//STRIP001 		::com::boModifyHdl(&aUrlCB);
//STRIP001 	}
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 IMPL_LINK( SvxHyperlinkDlg, TBClickHdl, ToolBox *, pBox )
//STRIP001 {
//STRIP001 	switch (pBox->GetCurItemId())
//STRIP001 	{
//STRIP001 		case BTN_OPENDIALOG:
//STRIP001 		{
//STRIP001 			GetBindings().GetDispatcher()->Execute( SID_HYPERLINK_DIALOG );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case BTN_LINK:
//STRIP001 		{
//STRIP001 			// Link-Popup anstossen
//STRIP001 			bSend = FALSE;
//STRIP001 			aTimer.Start();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case BTN_INET_SEARCH:
//STRIP001 		{
//STRIP001 			// Search-Engines per Popup auswaehlen
//STRIP001 			PopupMenu *pMenu = new PopupMenu;
//STRIP001 			pMenu->SetSelectHdl(LINK(this, SvxHyperlinkDlg, SearchPopupSelectHdl));
//STRIP001 
//STRIP001             sal_uInt16         nCount = aSearchConfig.Count();
//STRIP001 			String sFound;
//STRIP001             for (USHORT i = 0; i < nCount; i++)
//STRIP001             {
//STRIP001                 if (i)
//STRIP001                     pMenu->InsertSeparator();
//STRIP001                 const SvxSearchEngineData&  rData = aSearchConfig.GetData(i);
//STRIP001                 pMenu->InsertItem( i + 1, rData.sEngineName);
//STRIP001             }
//STRIP001             pBox->SetItemDown(BTN_INET_SEARCH, TRUE, TRUE);
//STRIP001             pMenu->Execute( this, GetItemRect( BTN_INET_SEARCH ), FLOATWIN_POPUPMODE_DOWN );
//STRIP001             pBox->SetItemDown(BTN_INET_SEARCH, FALSE, TRUE);
//STRIP001             EndSelection();
//STRIP001 			delete pMenu;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case BTN_TARGET:
//STRIP001 		{
//STRIP001 			// Target Frame einstellen
//STRIP001 			TargetMenu(GetSelTarget(), TRUE);
//STRIP001 			EndSelection();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 IMPL_LINK( SvxHyperlinkDlg, TBSelectHdl, ToolBox *, pBox )
//STRIP001 {
//STRIP001 	switch (pBox->GetCurItemId())
//STRIP001 	{
//STRIP001 		// Link als Bookmark im Explorer eintragen
//STRIP001 		// Soll erst im Loslassen der Maus gerufen werden, daher im Select-Hdl
//STRIP001 		case BTN_INSERT_BOOKMARK:
//STRIP001 		{
//STRIP001 			String sName = aNameCB.GetText();
//STRIP001 			if ( !sName.Len() )
//STRIP001 				sName = aUrlCB.GetText();
//STRIP001 
//STRIP001 			SfxStringItem aName( SID_BOOKMARK_TITLE, sName );
//STRIP001 			SfxStringItem aURL( SID_BOOKMARK_URL,
//STRIP001 								so3::StaticBaseUrl::SmartRelToAbs( aUrlCB.GetText(), FALSE,
//STRIP001 														  INetURLObject::WAS_ENCODED,
//STRIP001 														  INetURLObject::DECODE_UNAMBIGUOUS ) );
//STRIP001 			GetBindings().GetDispatcher()->Execute(
//STRIP001 				SID_CREATELINK, SFX_CALLMODE_ASYNCHRON, &aName, &aURL, 0L );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 void SvxHyperlinkDlg::TargetMenu(const String& rSelEntry, BOOL bExecute)
//STRIP001 {
//STRIP001 	if (pTargetMenu && !bExecute)
//STRIP001 	{
//STRIP001 		for (USHORT i = 1; i <= pTargetMenu->GetItemCount(); i++)
//STRIP001 		{
//STRIP001 			if (pTargetMenu->GetItemText(i) == rSelEntry)
//STRIP001 			{
//STRIP001 				pTargetMenu->CheckItem(i);
//STRIP001 				return;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxViewFrame* pVwFrm = SfxViewFrame::Current();
//STRIP001 
//STRIP001 	if (pVwFrm)	// Alle moeglichen Target Frames zusammensammeln und anzeigen
//STRIP001 	{
//STRIP001 		TargetList aList;
//STRIP001 		pVwFrm->GetTopFrame()->GetTargetList(aList);
//STRIP001 
//STRIP001 		USHORT nCount = (USHORT)aList.Count();
//STRIP001 		if( nCount )
//STRIP001 		{
//STRIP001 			BOOL bChecked = FALSE;
//STRIP001 
//STRIP001 			if (pTargetMenu != NULL)
//STRIP001 				delete pTargetMenu;
//STRIP001 
//STRIP001 			pTargetMenu = new PopupMenu;
//STRIP001 			pTargetMenu->SetMenuFlags( pTargetMenu->GetMenuFlags() |
//STRIP001 									   MENU_FLAG_NOAUTOMNEMONICS );
//STRIP001 
//STRIP001 			for ( USHORT i = 0; i < nCount; i++ )
//STRIP001 			{
//STRIP001 				String sEntry(*aList.GetObject(i));
//STRIP001 				pTargetMenu->InsertItem(i + 1, sEntry, MIB_RADIOCHECK|MIB_AUTOCHECK);
//STRIP001 
//STRIP001 				if (sEntry == rSelEntry)
//STRIP001 				{
//STRIP001 					pTargetMenu->CheckItem(i + 1);
//STRIP001 					bChecked = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			for ( i = nCount; i; i-- )
//STRIP001 				delete aList.GetObject( i - 1 );
//STRIP001 
//STRIP001 			if (!bChecked)
//STRIP001 				pTargetMenu->CheckItem(1);
//STRIP001 
//STRIP001 			if (bExecute)
//STRIP001 			{
//STRIP001 				USHORT nEntry = pTargetMenu->Execute(
//STRIP001 					this, GetItemRect( BTN_TARGET ), FLOATWIN_POPUPMODE_DOWN );
//STRIP001 				if ( nEntry )
//STRIP001 					pTargetMenu->CheckItem( nEntry );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 IMPL_LINK( SvxHyperlinkDlg, TBDeactivateHdl, ToolBox *, pBox )
//STRIP001 {
//STRIP001 	switch (pBox->GetCurItemId())
//STRIP001 	{
//STRIP001 		case BTN_LINK:
//STRIP001 		{
//STRIP001 			if (aTimer.IsActive())
//STRIP001 			{
//STRIP001 				aTimer.Stop();
//STRIP001 				if (!bSend)	// Link ins Dokument einfuegen
//STRIP001 					SendToApp(HLINK_DEFAULT);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 IMPL_LINK( SvxHyperlinkDlg, TimeHdl, Timer *, pTimer )
//STRIP001 {
//STRIP001 	EndSelection();	// Vor dem Execute, damit Popup den Focus bekommt
//STRIP001 	aLinkPopup.EnableItem(MN_BUTTON, !bHtmlMode);
//STRIP001 	aLinkPopup.Execute( this, GetItemRect( BTN_LINK ), FLOATWIN_POPUPMODE_DOWN );
//STRIP001 	return TRUE;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 IMPL_LINK( SvxHyperlinkDlg, LinkPopupSelectHdl, Menu *, pMenu )
//STRIP001 {
//STRIP001 	switch (pMenu->GetCurItemId())
//STRIP001 	{
//STRIP001 		case MN_FIELD:	// URL als Hyperlink ins Dok einfuegen
//STRIP001 			SendToApp(HLINK_FIELD);
//STRIP001 			break;
//STRIP001 		case MN_BUTTON:	// URL als Button ins Dok einfuegen
//STRIP001 			SendToApp(HLINK_BUTTON);
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 IMPL_LINK( SvxHyperlinkDlg, SearchPopupSelectHdl, Menu *, pMenu )
//STRIP001 {
//STRIP001     const SvxSearchEngineData&  rData = aSearchConfig.GetData(pMenu->GetCurItemId() - 1);
//STRIP001     String sText(aNameCB.GetText());
//STRIP001     sText.EraseLeadingChars().EraseTrailingChars();
//STRIP001 
//STRIP001     ::rtl::OUString   sPrefix;
//STRIP001     ::rtl::OUString   sSuffix;
//STRIP001     ::rtl::OUString   sSeparator;
//STRIP001     sal_Int32       nCaseMatch;
//STRIP001     sal_Unicode cToken = 0;
//STRIP001 
//STRIP001     if (sText.Search(' ') != STRING_NOTFOUND)
//STRIP001     {
//STRIP001         sPrefix = rData.sExactPrefix;
//STRIP001         sSuffix = rData.sExactSuffix;
//STRIP001         sSeparator = rData.sExactSeparator;
//STRIP001         nCaseMatch = rData.nExactCaseMatch;
//STRIP001         cToken = ' ';
//STRIP001     }
//STRIP001     else if (sText.Search('+') != STRING_NOTFOUND)
//STRIP001     {
//STRIP001         sPrefix = rData.sAndPrefix;
//STRIP001         sSuffix = rData.sAndSuffix;
//STRIP001         sSeparator = rData.sAndSeparator;
//STRIP001         nCaseMatch = rData.nAndCaseMatch;
//STRIP001         cToken = '+';
//STRIP001     }
//STRIP001     else if (sText.Search(',') != STRING_NOTFOUND)
//STRIP001     {
//STRIP001         sPrefix = rData.sOrPrefix;
//STRIP001         sSuffix = rData.sOrSuffix;
//STRIP001         sSeparator = rData.sOrSeparator;
//STRIP001         nCaseMatch = rData.nOrCaseMatch;
//STRIP001         cToken = ',';
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         sPrefix = rData.sExactPrefix;
//STRIP001         sSuffix = rData.sExactSuffix;
//STRIP001         nCaseMatch = rData.nExactCaseMatch;
//STRIP001         cToken = 0;
//STRIP001     }
//STRIP001 
//STRIP001     String sURL = sPrefix;
//STRIP001 	xub_StrLen nTok;
//STRIP001 
//STRIP001     if(1 == nCaseMatch)
//STRIP001         sText.ToUpperAscii();
//STRIP001     else if(2 == nCaseMatch)
//STRIP001         sText.ToLowerAscii();
//STRIP001 
//STRIP001     if ((nTok = sText.GetTokenCount(cToken)) > 1)
//STRIP001 	{
//STRIP001 		for (USHORT i = 0; i < nTok; i++)
//STRIP001 		{
//STRIP001             sURL += sText.GetToken(i, cToken);
//STRIP001             if(i < nTok -1)
//STRIP001                 sURL += (String)sSeparator;
//STRIP001 		}
//STRIP001         sURL += (String)sSuffix;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001         sURL += sText;
//STRIP001         sURL += (String)sSuffix;
//STRIP001 	}
//STRIP001     sURL.EraseAllChars();   // remove all spaces
//STRIP001     SfxViewFrame* pViewFrame = SfxViewFrame::Current();
//STRIP001     if ( pViewFrame )
//STRIP001         pViewFrame = pViewFrame->GetTopViewFrame();
//STRIP001     OpenDoc( sURL, pViewFrame );
//STRIP001 
//STRIP001     return TRUE;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 IMPL_LINK( SvxHyperlinkDlg, BookmarkFoundHdl, String *, pUrl )
//STRIP001 {
//STRIP001 	if (pUrl && pUrl->Len())
//STRIP001 	{
//STRIP001 		aUrlCB.SetText(*pUrl);
//STRIP001 		::com::boModifyHdl(&aUrlCB);
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }
/*--------------------------------------------------------------------
	Beschreibung: Link-Button enablen/disablen
 --------------------------------------------------------------------*/

//STRIP001 void SvxHyperlinkDlg::EnableLink()
//STRIP001 {
//STRIP001 	BOOL bEnable = aUrlCB.GetText().Len() != 0;
//STRIP001 
//STRIP001 	EnableItem(BTN_LINK, (!bNoDoc) & bEnable);
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung: URL im Dokument einfuegen
 --------------------------------------------------------------------*/

//STRIP001 void SvxHyperlinkDlg::SendToApp(USHORT nType)
//STRIP001 {
//STRIP001 	BOOL bIsFile = FALSE;
//STRIP001 	bSend = TRUE;
//STRIP001 	String sURL( aUrlCB.GetText() );
//STRIP001 
//STRIP001 	if ( !sURL.Len() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	INetURLObject aObj( so3::StaticBaseUrl::SmartRelToAbs( sURL, FALSE,
//STRIP001 												  INetURLObject::WAS_ENCODED,
//STRIP001 												  INetURLObject::DECODE_UNAMBIGUOUS ) );
//STRIP001 	sURL = aObj.GetMainURL( INetURLObject::NO_DECODE );
//STRIP001 	if ( aObj.GetProtocol() == INET_PROT_FILE )
//STRIP001 		bIsFile = TRUE;
//STRIP001 
//STRIP001 	if ( bIsFile )
//STRIP001 	{
//STRIP001 		EnterWait();
//STRIP001 		SfxMedium aMedium( sURL, STREAM_STD_READ, TRUE );
//STRIP001 		if ( aMedium.Exists( FALSE ) == FALSE )
//STRIP001 		{
//STRIP001 			LeaveWait();
//STRIP001 			QueryBox aBox( this, OffResId( RID_SVXQB_DONTEXIST) );
//STRIP001 			if ( aBox.Execute() == RET_NO )
//STRIP001 				return;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			LeaveWait();
//STRIP001 	}
//STRIP001 
//STRIP001 	SvxHyperlinkItem aItem( SID_HYPERLINK_SETLINK );
//STRIP001 
//STRIP001 	if (aNameCB.GetText().Len())
//STRIP001 		aItem.SetName( aNameCB.GetText() );
//STRIP001 	else
//STRIP001 		aItem.SetName( sURL );
//STRIP001 
//STRIP001 	sOldName = aNameCB.GetText();
//STRIP001 
//STRIP001 	aItem.SetURL(sURL);
//STRIP001 	aItem.SetInsertMode( (SvxLinkInsertMode)nType );
//STRIP001 	aItem.SetTargetFrame( GetSelTarget() );
//STRIP001 
//STRIP001 	GetBindings().GetDispatcher()->Execute(
//STRIP001 		SID_HYPERLINK_SETLINK, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 
//STRIP001 	AddToHistory( aNameCB.GetText(), sURL );
//STRIP001 
//STRIP001 	if ( sURL != aUrlCB.GetText() )
//STRIP001 		aUrlCB.SetText( sURL );
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung: Selektierten Target Frame Eintrag im Popup ermitteln
 --------------------------------------------------------------------*/

//STRIP001 String SvxHyperlinkDlg::GetSelTarget()
//STRIP001 {
//STRIP001 	String sTarget;
//STRIP001 
//STRIP001 	if (pTargetMenu != NULL)
//STRIP001 	{
//STRIP001 		for (USHORT i = 1; i <= pTargetMenu->GetItemCount(); i++)
//STRIP001 		{
//STRIP001 			if (pTargetMenu->IsItemChecked(i))
//STRIP001 			{
//STRIP001 				sTarget = pTargetMenu->GetItemText(i);
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return sTarget;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung: URL in History der Leiste aufnehmen
 --------------------------------------------------------------------*/

//STRIP001 void SvxHyperlinkDlg::AddToHistory(const String& rName, const String& rURL)
//STRIP001 {
//STRIP001 	String sName(rName);
//STRIP001 
//STRIP001 	if (bHasOldName && sOldName.Len())
//STRIP001 	{
//STRIP001 		sName = sOldName;
//STRIP001 		bHasOldName = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!sName.Len())
//STRIP001 		sName = rURL;
//STRIP001 
//STRIP001 	if (rURL.Len())
//STRIP001 	{
//STRIP001 		USHORT nNamePos = aNameCB.GetEntryPos(sName);
//STRIP001 		USHORT nUrlPos = aUrlCB.GetEntryPos(rURL);
//STRIP001 		USHORT nPos = COMBOBOX_ENTRY_NOTFOUND;
//STRIP001 
//STRIP001 		if (nNamePos != COMBOBOX_ENTRY_NOTFOUND)
//STRIP001 			nPos = nNamePos;
//STRIP001 		else
//STRIP001 			nPos = nUrlPos;
//STRIP001 
//STRIP001 		// Alten Eintrag durch neuen Eintrag ersetzen
//STRIP001 		if (nPos != COMBOBOX_ENTRY_NOTFOUND)
//STRIP001 		{
//STRIP001 			aNameCB.RemoveEntry(nPos);
//STRIP001 			aUrlCB.RemoveEntry(nPos);
//STRIP001 			aNameCB.SetText(rName);
//STRIP001 			aUrlCB.SetText(rURL);
//STRIP001 		}
//STRIP001 
//STRIP001 		aNameCB.InsertEntry(sName, 0);
//STRIP001 		aUrlCB.InsertEntry(rURL, 0);
//STRIP001 	}
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung: Bookmark und Search-Button enablen/disablen
 --------------------------------------------------------------------*/

//STRIP001 IMPL_LINK( SvxHyperlinkDlg, ComboSelectHdl, ComboBox *, pCombo )
//STRIP001 {
//STRIP001 	USHORT nPos = pCombo->GetEntryPos(pCombo->GetText());
//STRIP001 
//STRIP001 	if (nPos != COMBOBOX_ENTRY_NOTFOUND)
//STRIP001 	{
//STRIP001 		aNameCB.SetText(aNameCB.GetEntry(nPos));
//STRIP001 		aUrlCB.SetText(aUrlCB.GetEntry(nPos));
//STRIP001 
//STRIP001 		EnableLink();
//STRIP001 		EnableItem(BTN_INSERT_BOOKMARK, TRUE);
//STRIP001 		EnableItem(BTN_INET_SEARCH, TRUE);
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 IMPL_LINK( SvxHyperlinkDlg, ComboModifyHdl, ComboBox *, pCombo )
//STRIP001 {
//STRIP001 	BOOL bEnable = TRUE;
//STRIP001 
//STRIP001 	if (!pCombo->GetText().Len())
//STRIP001 		bEnable = FALSE;
//STRIP001 
//STRIP001 	if (pCombo == &aNameCB)
//STRIP001 	{
//STRIP001 		if (IsItemEnabled(BTN_INET_SEARCH) != bEnable)
//STRIP001 			EnableItem(BTN_INET_SEARCH, bEnable);
//STRIP001 	}
//STRIP001 
//STRIP001 	EnableLink();
//STRIP001 
//STRIP001 	if (aUrlCB.GetText().Len())
//STRIP001 		bEnable = TRUE;
//STRIP001 	else
//STRIP001 		bEnable = FALSE;
//STRIP001 
//STRIP001 	if (IsItemEnabled(BTN_INSERT_BOOKMARK) != bEnable)
//STRIP001 		EnableItem(BTN_INSERT_BOOKMARK, bEnable);
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

// --------------------------------------------------------------------

//STRIP001 void SvxHyperlinkDlg::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	ToolBox::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE))
//STRIP001 	{
//STRIP001 		SetImages();
//STRIP001 	}
//STRIP001 }

// --------------------------------------------------------------------

//STRIP001 void SvxHyperlinkDlg::SetImages()
//STRIP001 {
//STRIP001 	bool bHighContrast = GetSettings().GetStyleSettings().GetHighContrastMode() != 0;
//STRIP001 
//STRIP001 	if( bHighContrast )
//STRIP001 		bHighContrast = GetDisplayBackground().GetColor().IsDark() != 0;
//STRIP001 
//STRIP001 	Color aMaskColor( 0xff, 0x00, 0xff );
//STRIP001 
//STRIP001 	SetItemImage( BTN_LINK, Image( mpManager->GetImage( BTN_LINK, bHighContrast ).GetBitmap(), aMaskColor ) );
//STRIP001 	SetItemImage( BTN_INSERT_BOOKMARK, Image( mpManager->GetImage( BTN_INSERT_BOOKMARK, bHighContrast  ).GetBitmap(), aMaskColor ) );
//STRIP001 	SetItemImage( BTN_INET_SEARCH, Image( mpManager->GetImage( BTN_INET_SEARCH, bHighContrast  ).GetBitmap(), aMaskColor ) );
//STRIP001 	SetItemImage( BTN_TARGET, Image( mpManager->GetImage( BTN_TARGET, bHighContrast  ).GetBitmap(), aMaskColor ) );
//STRIP001 	SetItemImage( BTN_OPENDIALOG, Image( mpManager->GetImage( BTN_OPENDIALOG, bHighContrast  ).GetBitmap(), aMaskColor ) );
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung: Comboboxen
 --------------------------------------------------------------------*/

//STRIP001 HyperCombo::HyperCombo( SvxHyperlinkDlg* pDialog, const ResId& rResId ) :
//STRIP001 		::com::boBox( (Window *)pDialog, rResId )
//STRIP001 {
//STRIP001 	pDlg = pDialog;
//STRIP001 
//STRIP001 	nMaxWidth = GetSizePixel().Width();
//STRIP001 	if (this == &pDlg->aUrlCB)
//STRIP001 		nMinWidth = GetTextWidth(String::CreateFromAscii("http://www.stardiv.dewww"));
//STRIP001 	else
//STRIP001 		nMinWidth = GetTextWidth(String::CreateFromAscii("StarDivision GmbHwww"));
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung: Comboboxen KeyInput
 --------------------------------------------------------------------*/

//STRIP001 long HyperCombo::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	long nHandled = 0;
//STRIP001 	static BOOL bLocked = FALSE;
//STRIP001 
//STRIP001 	if (bLocked)	// Keine weiteren RETURNs annehmen (nicht Reentrant!)
//STRIP001 		return nHandled;
//STRIP001 
//STRIP001 	bLocked = TRUE;
//STRIP001 
//STRIP001 	if ( rNEvt.GetType() == EVENT_KEYINPUT )
//STRIP001 	{
//STRIP001 		const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
//STRIP001 		const KeyCode aKeyCode = pKEvt->GetKeyCode();
//STRIP001 
//STRIP001 		if (aKeyCode.GetCode() == KEY_RETURN)
//STRIP001 		{
//STRIP001 			pDlg->SendToApp(HLINK_DEFAULT);
//STRIP001 			nHandled = 1;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if (this == &pDlg->aNameCB)
//STRIP001 		pDlg->sOldName = GetText();
//STRIP001 
//STRIP001 	if (!nHandled)
//STRIP001 		nHandled = ComboBox::Notify( rNEvt );
//STRIP001 
//STRIP001 	bLocked = FALSE;
//STRIP001 
//STRIP001 	return nHandled;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung: Drag&Drop vor dem Combo-Edit abfangen und weiterleiten
 --------------------------------------------------------------------*/

//STRIP001 long HyperCombo::PreNotify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	long nHandled = 0;
//STRIP001 
//STRIP001 	nHandled = ComboBox::PreNotify( rNEvt );
//STRIP001 
//STRIP001 	return nHandled;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 long HyperCombo::CalcResizeWidth( long nW )
//STRIP001 {
//STRIP001 	long nNewWidth = Max(nMaxWidth - nW * GetRatio() / 100L, nMinWidth);
//STRIP001 
//STRIP001 	if (nNewWidth > nMaxWidth)
//STRIP001 		nNewWidth = nMaxWidth;
//STRIP001 
//STRIP001 	if (nNewWidth != GetSizePixel().Width())
//STRIP001 		return nNewWidth;
//STRIP001 	else
//STRIP001 		return 0;	// Kein Resize notwendig
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 void HyperCombo::DoResize( long nNewWidth )
//STRIP001 {
//STRIP001 	SetSizePixel(Size(nNewWidth, GetSizePixel().Height()));
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung: FixedText
 --------------------------------------------------------------------*/

//STRIP001 HyperFixedText::HyperFixedText( SvxHyperlinkDlg* pDialog, const ResId& rResId ) :
//STRIP001 		FixedInfo( (Window *)pDialog, rResId )
//STRIP001 {
//STRIP001 	pDlg = pDialog;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung: Webseite der Search-Engine mit Suchergebnissen anzeigen
 --------------------------------------------------------------------*/
//STRIP001 void SvxHyperlinkDlg::OpenDoc( const String& rURL, SfxViewFrame* pViewFrame )
//STRIP001 {
//STRIP001 	SfxStringItem aName( SID_FILE_NAME, rURL );
//STRIP001 	SfxStringItem aReferer( SID_REFERER, String::CreateFromAscii(OFA_REFERER) );
//STRIP001     SfxBoolItem aNewView( SID_OPEN_NEW_VIEW, TRUE );
//STRIP001 	SfxBoolItem aSilent( SID_SILENT, TRUE );
//STRIP001 	SfxBoolItem aReadOnly( SID_DOC_READONLY, TRUE );
//STRIP001     SfxBoolItem aExternal( SID_BROWSE, TRUE );
//STRIP001     SfxDispatcher* pDisp = SfxViewFrame::Current() ? SfxViewFrame::Current()->GetDispatcher() : NULL;
//STRIP001 
//STRIP001 	if ( pViewFrame )
//STRIP001 	{
//STRIP001 		SfxFrameItem aView( SID_DOCFRAME, pViewFrame ? pViewFrame->GetFrame() : NULL );
//STRIP001 		if ( pDisp )
//STRIP001 			pDisp->Execute( SID_OPENDOC, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD,
//STRIP001                             &aName, &aView, &aNewView, &aSilent, &aReadOnly, &aReferer, &aExternal, 0L );
//STRIP001 	}
//STRIP001 	else if ( pDisp )
//STRIP001 		pDisp->Execute( SID_OPENDOC, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD,
//STRIP001 						&aName, &aNewView, &aSilent, &aReadOnly, &aReferer, 0L );
//STRIP001 }
// class SvxHyperlinkDialogWrapper ------------------------------------------

/*N*/ SFX_IMPL_CHILDWINDOW(SvxHyperlinkDlgWrapper, SID_HYPERLINK_INSERT)

/*--------------------------------------------------------------------
	Beschreibung: Wrapper fuer Hyperlinkleiste
 --------------------------------------------------------------------*/

/*N*/SvxHyperlinkDlgWrapper::SvxHyperlinkDlgWrapper( Window* pParent, USHORT nId,
/*N*/												SfxBindings* pBindings, SfxChildWinInfo* pInfo ) :
/*N*/
/*N*/	SfxChildWindow( pParent, nId )
/*N*/
/*N*/{ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/  	pWindow = new SvxHyperlinkDlg( pBindings, pParent );
//STRIP001 /*?*/  	eChildAlignment = SFX_ALIGN_TOP;
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

/*N*/SfxChildWinInfo SvxHyperlinkDlgWrapper::GetInfo() const
/*N*/{
/*N*/	SfxChildWinInfo aInfo = SfxChildWindow::GetInfo();
/*N*/	return aInfo;
/*N*/}

}
