/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_XclImpChartsApi.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:22:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------------

#ifndef SC_XCLIMPCHARTS_HXX
#include "XclImpCharts.hxx"
#endif

// beans
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XMULTIPROPERTYSET_HPP_
#include <com/sun/star/beans/XMultiPropertySet.hpp>
#endif

// chart
#ifndef _COM_SUN_STAR_CHART_CHARTAXISASSIGN_HPP_
#include <com/sun/star/chart/ChartAxisAssign.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART_CHARTAXISMARKS_HPP_
#include <com/sun/star/chart/ChartAxisMarks.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART_CHARTDATACAPTION_HPP_
#include <com/sun/star/chart/ChartDataCaption.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART_CHARTDATAROWSOURCE_HPP_
#include <com/sun/star/chart/ChartDataRowSource.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART_CHARTLEGENDPOSITION_HPP_
#include <com/sun/star/chart/ChartLegendPosition.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART_CHARTSOLIDTYPE_HPP_
#include <com/sun/star/chart/ChartSolidType.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART_CHARTSYMBOLTYPE_HPP_
#include <com/sun/star/chart/ChartSymbolType.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART_X3DDISPLAY_HPP_
#include <com/sun/star/chart/X3DDisplay.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART_XAXISXSUPPLIER_HPP_
#include <com/sun/star/chart/XAxisXSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART_XAXISZSUPPLIER_HPP_
#include <com/sun/star/chart/XAxisZSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART_XCHARTDOCUMENT_HPP_
#include <com/sun/star/chart/XChartDocument.hpp>
#endif
#ifndef __com_sun_star_chart_XStatisticDisplay_HPP__
#include <com/sun/star/chart/XStatisticDisplay.hpp>
#endif
#ifndef _COM_SUN_STAR_CHART_XTWOAXISYSUPPLIER_HPP_
#include <com/sun/star/chart/XTwoAxisYSupplier.hpp>
#endif

// drawing
#ifndef _COM_SUN_STAR_DRAWING_FILLSTYLE_HPP_
#include <com/sun/star/drawing/FillStyle.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_LINEDASH_HPP_
#include <com/sun/star/drawing/LineDash.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_LINESTYLE_HPP_
#include <com/sun/star/drawing/LineStyle.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSHAPE_HPP_
#include <com/sun/star/drawing/XShape.hpp>
#endif

// frame
#ifndef _COM_SUN_STAR_FRAME_XMODEL_HPP_
#include <com/sun/star/frame/XModel.hpp>
#endif

// lang
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

// util
#ifndef _COM_SUN_STAR_UTIL_DATE_HPP_
#include <com/sun/star/util/Date.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XNUMBERFORMATSSUPPLIER_HPP_
#include <com/sun/star/util/XNumberFormatsSupplier.hpp>
#endif

#ifndef _ZFORMAT_HXX
#include <svtools/zformat.hxx>
#endif

#ifndef _XCEPTION_HXX_ //autogen wg. TRY
#include <vos/xception.hxx>
#endif
#ifndef _VOS_NO_NAMESPACE
using namespace vos;
#endif

#ifndef SC_DOCUMENT_HXX
#include "document.hxx"
#endif

#ifndef SC_FPROGRESSBAR_HXX
#include "fprogressbar.hxx"
#endif
#ifndef SC_XLTOOLS_HXX
#include "xltools.hxx"
#endif
#ifndef SC_XISTYLE_HXX
#include "xistyle.hxx"
#endif
namespace binfilter {

using namespace ::rtl;
using namespace ::com::sun::star;

//___________________________________________________________________

#define SC_STDCHARTCOLORS       56

static BYTE aStdFillColor[SC_STDCHARTCOLORS] =
{ 16, 17, 18, 19, 20, 21, 22, 23,               // area colors in Excel charts
  24, 25, 26, 27, 28, 29, 30, 31,               // line colors in Excel charts
  32, 33, 34, 35, 36, 37, 38, 39,               // other colors
  40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55,
   0,  1,  2,  3,  4,  5,  6,  7,
   8,  9, 10, 11, 12, 13, 14, 15 };

static BYTE aStdLineColor[SC_STDCHARTCOLORS] =
{ 24, 25, 26, 27, 28, 29, 30, 31,               // line colors in Excel charts
  32, 33, 34, 35, 36, 37, 38, 39,               // other colors
  40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54,                   // 55 does not occur
   0,  1,  2,  3,  4,  5,  6,  7,
   8,  9, 10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23,               // area colors in Excel charts
  55 };                                         // color index 56 becomes hatching



//___________________________________________________________________
// FRAME group

/// Converts Excel line style to API line style.
void lcl_GetApiLineStyle(
        drawing::LineStyle& reApiStyle,
        drawing::LineDash& rApiDash,
        sal_Int32& rnApiWidth,
        sal_Int16& rnApiTrans,
        sal_uInt16 nXclPattern,
        sal_Int16 nXclWidth )
{
    switch( nXclWidth )
	{
        case EXC_CHART_LINEF_SINGLE:    rnApiWidth = 35;    break;
        case EXC_CHART_LINEF_DOUBLE:    rnApiWidth = 70;    break;
        case EXC_CHART_LINEF_TRIPLE:    rnApiWidth = 105;   break;
        default:                        rnApiWidth = 0;
    }

    rApiDash.Style = drawing::DashStyle_RECT;
    rApiDash.Dots = 0;
    rApiDash.Dashes = 0;
    rApiDash.Distance = rApiDash.DotLen = Min( static_cast< sal_Int32 >( nXclWidth + 105 ), 210L );
    rApiDash.DashLen = rApiDash.DotLen * 4;
    rnApiTrans = 0;

    switch( nXclPattern )
	{
		case EXC_CHART_LINEF_SOLID:
            reApiStyle = drawing::LineStyle_SOLID;
		break;
		case EXC_CHART_LINEF_DARKTRANS:
            reApiStyle = drawing::LineStyle_SOLID;
            rnApiTrans = 25;
		break;
		case EXC_CHART_LINEF_MEDTRANS:
            reApiStyle = drawing::LineStyle_SOLID;
            rnApiTrans = 50;
		break;
		case EXC_CHART_LINEF_LIGHTTRANS:
            reApiStyle = drawing::LineStyle_SOLID;
            rnApiTrans = 75;
		break;
		case EXC_CHART_LINEF_DASH:
            reApiStyle = drawing::LineStyle_DASH;
            rApiDash.Dashes = 1;
		break;
		case EXC_CHART_LINEF_DOT:
            reApiStyle = drawing::LineStyle_DASH;
            rApiDash.Dots = 1;
		break;
		case EXC_CHART_LINEF_DASHDOT:
            reApiStyle = drawing::LineStyle_DASH;
            rApiDash.Dashes = rApiDash.Dots = 1;
		break;
		case EXC_CHART_LINEF_DASHDOTDOT:
            reApiStyle = drawing::LineStyle_DASH;
            rApiDash.Dashes = 1;
            rApiDash.Dots = 2;
		break;
		default:
            reApiStyle = drawing::LineStyle_NONE;
	}
}



sal_Bool XclImpChart::SetLineFormat(
        const uno::Reference< beans::XMultiPropertySet >& xMultiPS,
        const uno::Reference< beans::XPropertySet >& xPropSet,
        const XclImpChart_Lineformat* pLineFormat )
{
    if( !pLineFormat || pLineFormat->bAuto )
        return sal_False;

    drawing::LineStyle eStyle;
    drawing::LineDash aDash;
    sal_Int32 nWidth;
    sal_Int16 nTransp;

    lcl_GetApiLineStyle( eStyle, aDash, nWidth, nTransp, pLineFormat->nPattern, pLineFormat->nWeight );
    aLineMultiPSHelper.setProperties( xMultiPS, xPropSet, eStyle, &aDash, nWidth, nTransp, pLineFormat->nLineColor );
    return sal_True;
}

sal_Bool XclImpChart::SetLineFormat(
        const uno::Reference< beans::XPropertySet >& xPropSet,
        const XclImpChart_Lineformat* pLineFormat )
{
    uno::Reference< beans::XMultiPropertySet > xMultiPS( xPropSet, uno::UNO_QUERY );
    return SetLineFormat( xMultiPS, xPropSet, pLineFormat );
}

void lcl_SetStandardLine(
        XclLineMultiPSHelper& rMultiPSHelper,
        const uno::Reference< beans::XMultiPropertySet >& xMultiPS,
        const uno::Reference< beans::XPropertySet >& xPropSet,
		UINT32 nRowNum,
        const XclImpPalette& rPalette,
        XclChartType eChartType,
		BOOL bIs3D )
{
    drawing::LineStyle eLineStyle = drawing::LineStyle_SOLID;
    sal_Int32 nColor = COL_BLACK;
	nRowNum %= SC_STDCHARTCOLORS;

    if( (eChartType == ctLine) || (eChartType == ctStock) || (eChartType == ctScatter) || (eChartType == ctNet) )
	{
        //! 2do change tables, omit index offset
        sal_uInt16 nIndex = rPalette.GetXclIndex( aStdLineColor[ nRowNum ] );
        nColor = rPalette.GetColorData( nIndex, COL_BLACK );
	}
    else if( bIs3D && ((eChartType == ctArea) || (eChartType == ctBar) ||
                        (eChartType == ctColumn) || (eChartType == ctPie) || (eChartType == ctUnknown)) )
        eLineStyle = drawing::LineStyle_NONE;

    rMultiPSHelper.setProperties( xMultiPS, xPropSet, eLineStyle, NULL, 0, 0, nColor );
}

sal_Bool XclImpChart::SetAreaFormat(
        const uno::Reference< beans::XMultiPropertySet >& xMultiPS,
        const uno::Reference< beans::XPropertySet >& xPropSet,
        const XclImpChart_Areaformat* pAreaFormat )
{
    if( !pAreaFormat || pAreaFormat->bAuto )
        return sal_False;

    if( pAreaFormat->pFillData )
    {
        const XclImpChart_FillData& rFillData = *pAreaFormat->pFillData;
        awt::Gradient aGradient;
        uno::Reference< awt::XBitmap > aXBitmap;
        if( rFillData.GetGradient( aGradient ) )
            aAreaMultiPSHelper.setProperties( xMultiPS, xPropSet, aGradient );
        else if( rFillData.GetBitmap( aXBitmap ) )
            aAreaMultiPSHelper.setProperties( xMultiPS, xPropSet, aXBitmap, rFillData.GetBitmapMode() );
    }
	else
	{
        drawing::FillStyle eStyle = drawing::FillStyle_NONE;
        ColorData nFillColor = COL_BLACK;

		if ( pAreaFormat->nPattern != EXC_CHART_AREAF_NONE )
		{
			eStyle = drawing::FillStyle_SOLID;
			if ( pAreaFormat->nPattern == EXC_CHART_AREAF_SOLID )
				nFillColor = pAreaFormat->nForeColor;
			else
				//!	create Svx-Pattern, if !=SOLID
				nFillColor = pAreaFormat->nBackColor;
		}
        aAreaMultiPSHelper.setProperties( xMultiPS, xPropSet, eStyle, nFillColor );
	}
    return sal_True;
}

sal_Bool XclImpChart::SetAreaFormat(
        const uno::Reference< beans::XPropertySet >& xPropSet,
        const XclImpChart_Areaformat* pAreaFormat )
{
    uno::Reference< beans::XMultiPropertySet > xMultiPS( xPropSet, uno::UNO_QUERY );
    return SetAreaFormat( xMultiPS, xPropSet, pAreaFormat );
}

void lcl_SetStandardFill(
        XclAreaMultiPSHelper& rMultiPSHelper,
        const uno::Reference< beans::XMultiPropertySet >& xMultiPS,
        const uno::Reference< beans::XPropertySet >& xPropSet,
        UINT32 nRowNum, const XclImpPalette& rPalette )
{
	//	Excel standard colors (solid style)
    sal_uInt16 nIndex = rPalette.GetXclIndex( aStdFillColor[ nRowNum % SC_STDCHARTCOLORS ] );
    Color aColor( rPalette.GetColor( nIndex, COL_BLACK ) );

    sal_uInt32 nCycle = nRowNum / SC_STDCHARTCOLORS;
    const sal_uInt16 pTransArray[] = { 0x0000, 0x4000, 0x2000, 0x6000, 0x7000 };
    sal_uInt16 nTrans = (nCycle < 5) ? pTransArray[ nCycle ] : 0;
    aColor = ScfTools::GetMixedColor( aColor, Color( COL_WHITE ), nTrans );

    rMultiPSHelper.setProperties( xMultiPS, xPropSet, drawing::FillStyle_SOLID,
        static_cast< sal_Int32 >( aColor.GetColor() ) );
}

void XclImpChart::SetFrameFormat(
        const uno::Reference< beans::XMultiPropertySet >& xMultiPS,
        const uno::Reference< beans::XPropertySet >& xPropSet,
        const XclImpChart_Lineformat* pLine,
        const XclImpChart_Areaformat* pArea )
{
    SetLineFormat( xMultiPS, xPropSet, pLine );
    SetAreaFormat( xMultiPS, xPropSet, pArea );
}

void XclImpChart::SetFrameFormat(
        const uno::Reference< beans::XPropertySet >& xPropSet,
        const XclImpChart_Lineformat* pLine,
        const XclImpChart_Areaformat* pArea )
{
    uno::Reference< beans::XMultiPropertySet > xMultiPS( xPropSet, uno::UNO_QUERY );
    SetFrameFormat( xMultiPS, xPropSet, pLine, pArea );
}


//___________________________________________________________________
// shape position

void lcl_SetPosition(
        const uno::Reference< drawing::XShape >& xShape, const XclImpChart_Pos& rPos,
        UINT16 nRot, const Size& rRealSize, BOOL bSetSize )
{
	if( !xShape.is() ) return;

	awt::Point	aPoint(	(rPos.nPosX * rRealSize.Width()) / 4000, (rPos.nPosY * rRealSize.Height()) / 4000 );
	awt::Size	aSize( (rPos.nWidth * rRealSize.Width()) / 4000, (rPos.nHeight * rRealSize.Height()) / 4000 );

	if( !bSetSize )
	{
		aPoint.X = Max( aPoint.X, (long) SC_CHART_MINDIST );
		aPoint.Y = Max( aPoint.Y, (long) SC_CHART_MINDIST );

        sal_Int32 nScRot = XclTools::GetScRotation( nRot );
		if( (nScRot > 13500) && (nScRot < 31500) )
			aPoint.X += aSize.Width;
		if( (nScRot > 4500) && (nScRot < 22500) )
			aPoint.Y += aSize.Height;

		aPoint.X = Min( aPoint.X, (long)(rRealSize.Width() - aSize.Width - SC_CHART_MINDIST) );
		aPoint.Y = Min( aPoint.Y, (long)(rRealSize.Height() - aSize.Height - SC_CHART_MINDIST) );
	}

	try
	{
		xShape->setPosition( aPoint );
		if( bSetSize )
			xShape->setSize( aSize );
	}
	catch( uno::Exception& )
	{
	}
}


//___________________________________________________________________
// TEXT group

void XclImpChart::SetTextData(
        const uno::Reference< beans::XPropertySet >& xPropSet,
        const XclImpChart_Text* pTextData, const XclImpChart_Text* pDefText )
{
    const XclImpChart_Text* pText = pTextData ? pTextData : pDefText;
    if( !xPropSet.is() ) return;
    if( pText )
	{
		if ( !pText->bAutoColor )
            ::setPropValue( xPropSet, PROPNAME( CHART_PROP_CHARCOLOR ), (sal_Int32) pText->nTextColor );

        uno::Reference< beans::XMultiPropertySet > xMultiPS( xPropSet, uno::UNO_QUERY );
        if( pText->pFont )
            aFontMultiPSHelper.setProperties( xMultiPS, xPropSet, pText->pFont->GetFontData() );
        ::setPropValue( xPropSet, PROPNAME( CHART_PROP_TEXTROTATION ), XclTools::GetScRotation( pText->nRot ) );

        SetFrameFormat( xMultiPS, xPropSet, pText->pLine, pText->pArea );
	}
}

void XclImpChart::SetTextData(
        const uno::Reference< drawing::XShape >& xTextShape,
        const XclImpChart_Text* pTextData, const XclImpChart_Text* pDefText, const Size& rRealSize )
{
    const XclImpChart_Text* pText = pTextData ? pTextData : pDefText;
    if( !pText ) return;

    uno::Reference< beans::XPropertySet > xPropSet( xTextShape, uno::UNO_QUERY );
    if( !xPropSet.is() ) return;

    SetTextData( xPropSet, pText, NULL );
    if( xPropSet.is() && pText->pString )
        ::setPropString( xPropSet, PROPNAME( CHART_PROP_STRING ), *pText->pString );
// #90643# diagram/legend/title positioning disabled
//    lcl_SetPosition( xTextShape, pText->aPos, pText->nRot, rRealSize, FALSE );
}


//___________________________________________________________________
// AXIS group

void lcl_AxisValueFormat(
        const uno::Reference< beans::XPropertySet >& xAxis,
        const XclImpChart_ValueRange* pValRange, BOOL bManualOrigin )
{
	if( !pValRange ) return;

	if( !(bManualOrigin && pValRange->bAutoCross && pValRange->bAutoMin && pValRange->bAutoMax) )
	{
		//	Bei Bar-Charts (bManualOrigin) Origin nicht auf automatisch stellen,
		//	bis die automatische Skalierung der von Excel aehnlicher wird.
		//	Bei manueller Skalierung muss aber auch der Origin uebernommen werden,
		//	damit die Skalierung ueberhaupt wirkt.

        ::setPropBool( xAxis, PROPNAME( CHART_PROP_AUTOORIG ), pValRange->bAutoCross );
		if( !pValRange->bAutoCross )
            ::setPropValue( xAxis, PROPNAME( CHART_PROP_ORIGIN ), pValRange->fCross );
	}

    if( pValRange->bLogScale )
        ::setPropBool( xAxis, PROPNAME( CHART_PROP_LOG ), sal_True );

    ::setPropBool( xAxis, PROPNAME( CHART_PROP_AUTOMIN ), pValRange->bAutoMin );
	if( !pValRange->bAutoMin )
        ::setPropValue( xAxis, PROPNAME( CHART_PROP_MIN ), pValRange->fMin );

    ::setPropBool( xAxis, PROPNAME( CHART_PROP_AUTOMAX ), pValRange->bAutoMax );
	if( !pValRange->bAutoMax )
        ::setPropValue( xAxis, PROPNAME( CHART_PROP_MAX ), pValRange->fMax );

    ::setPropBool( xAxis, PROPNAME( CHART_PROP_AUTOSTMAIN ), pValRange->bAutoMajor );
	if( !pValRange->bAutoMajor )
        ::setPropValue( xAxis, PROPNAME( CHART_PROP_STEPMAIN ), pValRange->fMajorInc );

    ::setPropBool( xAxis, PROPNAME( CHART_PROP_AUTOSTHELP ), pValRange->bAutoMinor );
	if( !pValRange->bAutoMinor )
        ::setPropValue( xAxis, PROPNAME( CHART_PROP_STEPHELP ), pValRange->fMinorInc );
}

sal_Int32 lcl_TickPosToAxisMarks( UINT8 nTick )
{
	sal_Int32 nRet = chart::ChartAxisMarks::NONE;
	if( nTick & EXC_CHART_TICK_INSIDE )
		nRet |= chart::ChartAxisMarks::INNER;
	if( nTick & EXC_CHART_TICK_OUTSIDE )
		nRet |= chart::ChartAxisMarks::OUTER;
	return nRet;
}

void lcl_AxisTickFormat( const uno::Reference< beans::XPropertySet >& xAxis, const XclImpChart_Tick* pTick )
{
	if( !pTick ) return;

	if( !pTick->bAutoColor )
        ::setPropValue( xAxis, PROPNAME( CHART_PROP_CHARCOLOR ), (sal_Int32) pTick->nTextColor );
    ::setPropValue( xAxis, PROPNAME( CHART_PROP_MARKS ), lcl_TickPosToAxisMarks( pTick->nMajor ) );
    ::setPropValue( xAxis, PROPNAME( CHART_PROP_HELPMARKS ), lcl_TickPosToAxisMarks( pTick->nMinor ) );
}


//___________________________________________________________________
// DATAFORMAT group

void XclImpChart::SetDataCaption(
        const uno::Reference< beans::XPropertySet >& xPropSet,
        const UINT16* pFlags,
        const XclImpChart_Text* pTextData,
        const XclImpChart_Text* pDefText0,
        const XclImpChart_Text* pDefText1 )
{
	UINT16	nFlags		= pFlags ? *pFlags : 0x0000;
    BOOL    bLabel      = (nFlags & (EXC_CHART_ATLAB_SHOWLABEL | EXC_CHART_ATLAB_SHOWLABELPERC)) != 0;
    BOOL    bValue      = (nFlags & EXC_CHART_ATLAB_SHOWVALUE) != 0;
    BOOL    bPercent    = (nFlags & (EXC_CHART_ATLAB_SHOWPERCENT | EXC_CHART_ATLAB_SHOWLABELPERC)) != 0;

	sal_Int32 nCaption = 0x00000000;

	if( bValue )
		nCaption |= chart::ChartDataCaption::VALUE;
	if( bPercent )
		nCaption |= chart::ChartDataCaption::PERCENT;
	if( bLabel )
		nCaption |= chart::ChartDataCaption::TEXT;
	if( pTextData && pTextData->bShowKey )
		nCaption |= chart::ChartDataCaption::SYMBOL;

    ::setPropValue( xPropSet, PROPNAME( CHART_PROP_DATACAPTION ), nCaption );
    SetTextData( xPropSet, pTextData, bLabel ? pDefText0 : pDefText1 );
}

BOOL lcl_SetMarkerFormat(
        const uno::Reference< beans::XPropertySet >& xPropSet,
        const XclImpChart_MarkerFormat* pMForm )
{
	if( !pMForm ) return FALSE;

	Color aForeColor( pMForm->nForeColor );
	Color aBackColor( pMForm->nBackColor );
	sal_Int32 nSymbolType;
	switch ( pMForm->nMarkerType )
	{
		case 0:		nSymbolType = chart::ChartSymbolType::NONE;		break;
		case 1:		nSymbolType = chart::ChartSymbolType::SYMBOL0;	break;
		case 2:		nSymbolType = chart::ChartSymbolType::SYMBOL1;	break;
		case 3:		nSymbolType = chart::ChartSymbolType::SYMBOL3;	break;
		case 4:		nSymbolType = chart::ChartSymbolType::SYMBOL2;	break;
		case 5:		nSymbolType = chart::ChartSymbolType::SYMBOL4;	break;
		case 6:		nSymbolType = chart::ChartSymbolType::AUTO;		break;
		case 7:		nSymbolType = chart::ChartSymbolType::SYMBOL5;	break;
		case 8:		nSymbolType = chart::ChartSymbolType::SYMBOL6;	break;
		case 9:		nSymbolType = chart::ChartSymbolType::SYMBOL7;	break;
		default:	nSymbolType = chart::ChartSymbolType::SYMBOL1;
	}
    ::setPropValue( xPropSet, PROPNAME( CHART_PROP_SYMBOLTYPE ), nSymbolType );
	return TRUE;
}

void lcl_SetStandardMarker(
        const uno::Reference< beans::XPropertySet >& xPropSet,
        UINT32 nRowNum, const XclImpPalette& rPalette )
{
//  if ( nRowNum < SC_STDCHARTCOLORS && xPropSet.is() && pColorBuf )
//	{
//	}
}

void lcl_SetPieDistance( const uno::Reference< beans::XPropertySet >& xPropSet, const UINT16* pDist )
{
	if( !pDist ) return;
	sal_Int32 nDist = (sal_Int32) Min( (UINT16)100, *pDist );
    ::setPropValue( xPropSet, PROPNAME( CHART_PROP_SEGMENTOFFSET ), nDist );
}

void lcl_Set3DDataFormat(
        const uno::Reference< beans::XPropertySet >& xPropSet,
        const XclImpChart_3DDataFormat* pFormat )
{
	if( !pFormat ) return;

	sal_Int32 nType;
	if( pFormat->nBase == EXC_CHART_DATAF_RECT )
		nType = (pFormat->nTop == EXC_CHART_DATAF_STRAIGHT) ?
			chart::ChartSolidType::RECTANGULAR_SOLID : chart::ChartSolidType::PYRAMID;
	else
		nType = (pFormat->nTop == EXC_CHART_DATAF_STRAIGHT) ?
			chart::ChartSolidType::CYLINDER : chart::ChartSolidType::CONE;

    ::setPropValue( xPropSet, PROPNAME( CHART_PROP_SOLIDTYPE ), nType );
}


//___________________________________________________________________
// diagram area position/size

// #90643# diagram/legend/title positioning disabled
#if 0
// #88701# re-enabled for all chart types with axes
//void lcl_SetDiagramPosition( const uno::Reference< chart::XDiagram >& xDiagram,
//                          XclImpChart_AxesSet* pPrimAS, const Size& rRealSize,
//                          XclImpChartType eChartType, UINT16 nMaxPieDist )
void lcl_SetDiagramPosition(
        const uno::Reference< chart::XDiagram >& xDiagram,
        const XclImpChart_AxesSet* pPrimAS, const XclImpChart_AxesSet* pSecAS,
        const Size& rRealSize, XclImpChartType eChartType )
{
    if( !pPrimAS ) return;

    XclImpChart_Pos aPos( pPrimAS->aPos );

    // add title size and axis caption size
    if( (eChartType != ctPie) && (eChartType != ctDonut) && (eChartType != ctNet) )
    {
        if( pPrimAS->pCatAxis )
        {
            XclImpChart_Axis& rAxis = *pPrimAS->pCatAxis;
            long nTitleW = rAxis.pTitle ? rAxis.pTitle->aPos.nWidth : 0;
            long nTitleH = rAxis.pTitle ? rAxis.pTitle->aPos.nHeight : 0;
            long nXDescr = rAxis.HasCaption() ? 120 : 0;
            if( eChartType == ctBar )
            {
                aPos.nPosX -= nTitleW + nXDescr;
                aPos.nWidth += nTitleW + nXDescr;
            }
            else
                aPos.nHeight += nTitleH + nXDescr;
        }

        if( pPrimAS->pValueAxis )
        {
            XclImpChart_Axis& rAxis = *pPrimAS->pValueAxis;
            long nTitleW = rAxis.pTitle ? rAxis.pTitle->aPos.nWidth : 0;
            long nTitleH = rAxis.pTitle ? rAxis.pTitle->aPos.nHeight : 0;
            long nYDescr = rAxis.HasCaption() ? 120 : 0;
            long nYDescr2 = (pSecAS && pSecAS->pValueAxis && pSecAS->pValueAxis->HasCaption()) ? 120 : 0;
            if( eChartType == ctBar )
            {
                aPos.nPosY -= nYDescr2;
                aPos.nHeight += nTitleH + nYDescr + nYDescr2;
            }
            else
            {
                aPos.nPosX -= nTitleW + nYDescr;
                aPos.nWidth += nTitleW + nYDescr + nYDescr2;
            }
        }
    }

//    // enlarge area of pie charts
//    nMaxPieDist = Min( nMaxPieDist, (UINT16)100 );
//    if( nMaxPieDist )
//    {
//        double fScale = (double) nMaxPieDist / 100.0;
//        UINT32 nAdd = (UINT32)((double) aPos.nWidth * fScale);
//        aPos.nPosX -= (nAdd >> 1);
//        aPos.nWidth += nAdd;
//        nAdd = (UINT32)((double) aPos.nHeight * fScale);
//        aPos.nPosY -= (nAdd >> 1);
//        aPos.nHeight += nAdd;
//    }

    uno::Reference< drawing::XShape > xDiaShape( xDiagram, uno::UNO_QUERY );
    if( xDiaShape.is() )
        lcl_SetPosition( xDiaShape, aPos, 0, rRealSize, TRUE );
}
#endif

//___________________________________________________________________
// apply chart

void XclImpChart::SetDataRowProperties( uno::Reference< chart::XDiagram > xDiagram, ScfProgressBar& rProgress )
{
	//!	die Abfrage kann raus, wenn getDataRow/getDataPoint
	//!	bei ungueltigen Werten NULL zurueckgibt

	if ( !xDiagram.is() || !pSourceData || !pSeries ) return;

	//	umschliessenden Range zusammensuchen
	ScRange aSourceRange;
	ScRangeListRef xRanges = pSourceData->GetRangeList();
	if ( xRanges.Is() && xRanges->Count() )
	{
		aSourceRange = *xRanges->GetObject( 0 );
		ULONG nCount = xRanges->Count();
		for( ULONG i = 1; i < nCount; i++ )
		{
			ScRange aRange = *xRanges->GetObject(i);
			if (aRange.aStart.Tab() == aSourceRange.aStart.Tab())
			{
				if (aRange.aStart.Col() < aSourceRange.aStart.Col())
					aSourceRange.aStart.SetCol(aRange.aStart.Col());
				if (aRange.aStart.Row() < aSourceRange.aStart.Row())
					aSourceRange.aStart.SetRow(aRange.aStart.Row());
				if (aRange.aEnd.Col() > aSourceRange.aEnd.Col())
					aSourceRange.aEnd.SetCol(aRange.aEnd.Col());
				if (aRange.aEnd.Row() > aSourceRange.aEnd.Row())
					aSourceRange.aEnd.SetRow(aRange.aEnd.Row());
			}
		}
	}
	USHORT nSourceColCount = aSourceRange.aEnd.Col() - aSourceRange.aStart.Col() + 1;
	USHORT nSourceRowCount = aSourceRange.aEnd.Row() - aSourceRange.aStart.Row() + 1;
	if( pSourceData->GetDir() )
	{
		USHORT nTemp = nSourceColCount;
		nSourceColCount = nSourceRowCount;
		nSourceRowCount = nTemp;
	}
	if( bHasSeriesNames )
		--nSourceColCount;					// ColCount = count of points per series
	if( bHasCategoryNames )
		--nSourceRowCount;					// RowCount = count of series (data rows)

	BOOL bPie = (eChartType == ctPie);
	BOOL bDonut = (eChartType == ctDonut);

    const XclImpChart_Point* pGlobal = pSeries->GetGlobalFormatPtr();
	for( UINT32 nSerNum = 0; (nSerNum + nRowOffset) < nSourceRowCount; nSerNum++ )
	{
        const XclImpChart_Series*  pSer = pSeries->FindBySerNum( nSerNum );
        XclImpChart_Point*         pRow = pSer ? pSer->pAll : NULL;

		if( pRow )
		{
			if( pGlobal )
				pRow->Update( *pGlobal );
			// attributes of data rows
			try
			{
				sal_Int32 nCount = (bPie || bDonut) ? nSourceColCount : 1;
				for( sal_Int32 nPoint = 0; nPoint < nCount; nPoint++ )
				{
					uno::Reference< beans::XPropertySet > xDataRow;
					if( bDonut )
                        // donut chart: index to data row/data point is exchanged
						xDataRow = xDiagram->getDataPointProperties( nSerNum + nRowOffset, nPoint );
					else if( bPie )
                        // pie chart: properties of each data point have to be set
						xDataRow = xDiagram->getDataPointProperties( nPoint, nSerNum + nRowOffset );
					else
						xDataRow = xDiagram->getDataRowProperties( nSerNum + nRowOffset );
                    uno::Reference< beans::XMultiPropertySet > xDataRowMPS( xDataRow, uno::UNO_QUERY );

                    if( xDataRow.is() || xDataRowMPS.is() )
					{
                        if( !SetLineFormat( xDataRowMPS, xDataRow, pRow->pLine ) )
                            lcl_SetStandardLine( aLineMultiPSHelper, xDataRowMPS, xDataRow, nSerNum, pExcRoot->pIR->GetPalette(), eChartType, p3D != NULL );
                        if( !SetAreaFormat( xDataRowMPS, xDataRow, pRow->pArea ) )
                            lcl_SetStandardFill( aAreaMultiPSHelper, xDataRowMPS, xDataRow, (bPie || bDonut) ? nPoint : nSerNum, pExcRoot->pIR->GetPalette() );
						if( !lcl_SetMarkerFormat( xDataRow, pRow->pMarker ) )
                            lcl_SetStandardMarker( xDataRow, nSerNum, pExcRoot->pIR->GetPalette() );
						lcl_Set3DDataFormat( xDataRow, pRow->p3DData );
                        SetDataCaption( xDataRow, pRow->pLabel, pRow->pText, pDefText0, pDefText1 );
                        if( bPie )
                            lcl_SetPieDistance( xDataRow, pRow->pPieDist );
					}
				}
			}
			catch( uno::Exception& )
			{
			}
            rProgress.Progress();
		}

		// attributes of single data points
        XclImpChart_PointList* pDataPoints = pSer ? pSer->pSpec : NULL;
		if( pDataPoints )
		{
            for( const XclImpChart_Point* pPoint = pDataPoints->First(); pPoint; pPoint = pDataPoints->Next() )
			{
				UINT32 nColNum = pPoint->nPointNum;
				if( nColNum < nSourceColCount )
				{
					try
					{
						uno::Reference< beans::XPropertySet > xDataPoint = bDonut ?
							xDiagram->getDataPointProperties( nSerNum + nRowOffset, nColNum ) :
							xDiagram->getDataPointProperties( nColNum, nSerNum + nRowOffset );
                        uno::Reference< beans::XMultiPropertySet > xDataPointMPS( xDataPoint, uno::UNO_QUERY );

                        if( xDataPoint.is() || xDataPointMPS.is() )
						{
                            SetFrameFormat( xDataPointMPS, xDataPoint, pPoint->pLine, pPoint->pArea );
							lcl_SetMarkerFormat( xDataPoint, pPoint->pMarker );
							lcl_Set3DDataFormat( xDataPoint, pPoint->p3DData );
                            SetDataCaption( xDataPoint, pPoint->pLabel, pPoint->pText, pDefText0, pDefText1 );
                            if( bPie )
                                lcl_SetPieDistance( xDataPoint, pPoint->pPieDist );
						}
					}
					catch( uno::Exception& )
					{
					}
				}
                rProgress.Progress();
			}
		}
	}
}

void XclImpChart::Apply( uno::Reference< lang::XComponent > xComponent, const Rectangle& rAnchor, ScfProgressBar& rProgress )
{
	if( !xComponent.is() ) return;

	Size aRealSize = rAnchor.GetSize();
	uno::Reference< frame::XModel > xModel( xComponent, uno::UNO_QUERY );

	xModel->lockControllers();		// don't redraw
	ApplyExt( xComponent );			// before getDiagram

	uno::Reference< chart::XChartDocument >	xChartDoc( xComponent, uno::UNO_QUERY );
	uno::Reference< beans::XPropertySet >	xDocProp( xChartDoc, uno::UNO_QUERY );
	if( !xModel.is() || !xChartDoc.is() || !xDocProp.is() ) return;

	uno::Reference< chart::XDiagram > xDiagram = xChartDoc->getDiagram();
	if( !xDiagram.is() ) return;

	uno::Reference< chart::XAxisXSupplier >	 	xDiaXSup( xDiagram, uno::UNO_QUERY );
	uno::Reference< chart::XTwoAxisYSupplier >	xDiaYSup( xDiagram, uno::UNO_QUERY );
	uno::Reference< chart::XAxisZSupplier >		xDiaZSup( xDiagram, uno::UNO_QUERY );
	uno::Reference< chart::X3DDisplay >			xDiagr3D( xDiagram, uno::UNO_QUERY );
	uno::Reference< beans::XPropertySet >		xDiaProp( xDiagram, uno::UNO_QUERY );
	if( !xDiaXSup.is() || !xDiaYSup.is() || !xDiaZSup.is() || !xDiagr3D.is() || !xDiaProp.is() )
		return;

    // *** GENERAL SETTINGS ***

    rProgress.ActivateSegment( nProgressSeg );

	if( pSourceData )
	{
		chart::ChartDataRowSource eSource = pSourceData->GetDir() ?
			chart::ChartDataRowSource_COLUMNS : chart::ChartDataRowSource_ROWS;
        ::setPropValue( xDiaProp, PROPNAME( CHART_PROP_ROWSOURCE ), eSource );
	}

	if( bSpline )
        ::setPropValue( xDiaProp, PROPNAME( CHART_PROP_SPLINETYPE ), (sal_Int32)1 );
    ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_DIM3D ), (p3D != NULL) );
	if( p3D )
        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_DEEP ), !p3D->bCluster );
    ::setPropValue( xDiaProp, PROPNAME( CHART_PROP_SYMBOLTYPE ), chart::ChartSymbolType::AUTO );

    SetFrameFormat( xChartDoc->getArea(), pLine, pArea );

    // *** CREATE TITLES AND LEGEND ***

    if( pPrimAS )
    {
        // chart title
        ::setPropBool( xDocProp, PROPNAME( CHART_PROP_HASMAINTIT ), (pChartTitle != NULL) );
        // X axis title
        if( pPrimAS->pCatAxis )
            ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASXAXISTIT ), (pPrimAS->pCatAxis->pTitle != NULL) );
        // Y axis title
        if( pPrimAS->pValueAxis )
            ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASYAXISTIT ), (pPrimAS->pValueAxis->pTitle != NULL) );
        // Z axis title
        if( pPrimAS->pSeriesAxis )
            ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASZAXISTIT ), (pPrimAS->pSeriesAxis->pTitle != NULL) );
        // legend
        ::setPropBool( xDocProp, PROPNAME( CHART_PROP_HASLEGEND ), (pLegend != NULL) );
    }

    xModel->unlockControllers();    // create objects to be able to set their properties
    xModel->lockControllers();

	// *** Y AXIS ***

	if( pPrimAS && pPrimAS->pValueAxis )
	{
        XclImpChart_Axis& rAxis = *pPrimAS->pValueAxis;

		if( p3D )
            SetFrameFormat( xDiagr3D->getFloor(), rAxis.pWallLine, rAxis.pWallArea );

        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASYAXIS ), sal_True );
        sal_Bool bHasCaption = rAxis.HasCaption();
        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASYAXISDESCR ), bHasCaption );

        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASYAXISGRID ), (rAxis.pMajorLine != NULL) );
        SetLineFormat( xDiaYSup->getYMainGrid(), rAxis.pMajorLine );
        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASYAXISHELPGRID ), (rAxis.pMinorLine != NULL) );
        SetLineFormat( xDiaYSup->getYHelpGrid(), rAxis.pMinorLine );

		uno::Reference< beans::XPropertySet > xYAxis = xDiaYSup->getYAxis();
		if( xYAxis.is() )
		{
			if( rAxis.nNumForm != EXC_CHART_IFMT_INVALID )
            {
                ::setPropBool( xYAxis, PROPNAME( CHART_PROP_LINKNUMFMT ), sal_False );
                ::setPropValue( xYAxis, PROPNAME( CHART_PROP_NUMFMT ), rAxis.nNumForm );
            }

			//	bei Saeulen/Balkendiagrammen kommt unser Chart nicht gut mit automatischem
			//	Origin zurecht -> dann nur hart gesetzte Werte uebernehmen
            BOOL bManualOrigin = (eChartType == ctBar) || (eChartType == ctColumn) || (eChartType == ctUnknown);
			lcl_AxisValueFormat( xYAxis, rAxis.pValueRange, bManualOrigin );
            SetLineFormat( xYAxis, rAxis.pAxisLine );
			lcl_AxisTickFormat( xYAxis, rAxis.pTick );
            ::setPropBool( xYAxis, PROPNAME( CHART_PROP_TEXTOVERLAP ), sal_False );
            ::setPropBool( xYAxis, PROPNAME( CHART_PROP_TEXTBREAK ), rAxis.bBreakText );
            if( bHasCaption )
            {
                SetTextData( xYAxis, rAxis.pCaptionText, pDefText2 );
                rProgress.Progress();
            }
		}
		if( rAxis.pTitle )
        {
            SetTextData( xDiaYSup->getYAxisTitle(), rAxis.pTitle, pDefText2, aRealSize );
            rProgress.Progress();
        }
	}
	else
	{
        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASYAXIS ), sal_False );
        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASYAXISDESCR ), sal_False );
	}

	// *** SECONDARY Y AXIS ***

	if( bSecondary && pSeries )
	{
        for( const XclImpChart_Series* pSer = pSeries->First(); pSer; pSer = pSeries->Next() )
		{
			if( pSer->bSecondary )
			{
				try
				{
					uno::Reference< beans::XPropertySet > xDataRow =
						xDiagram->getDataRowProperties( pSer->nSerInd + nRowOffset );
					if( xDataRow.is() )
                        ::setPropValue( xDataRow, PROPNAME( CHART_PROP_AXIS ), chart::ChartAxisAssign::SECONDARY_Y );
				}
				catch( uno::Exception& )
				{
				}
			}
		}

		if( pSecAS && pSecAS->pValueAxis )
		{
            XclImpChart_Axis& rAxis = *pSecAS->pValueAxis;

            ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASSECYAXIS ), sal_True );
            sal_Bool bHasCaption = rAxis.HasCaption();
            ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASSECYAXISDESCR ), bHasCaption );

			uno::Reference< beans::XPropertySet > xYAxis = xDiaYSup->getSecondaryYAxis();
			if( xYAxis.is() )
			{
				if( rAxis.nNumForm != EXC_CHART_IFMT_INVALID )
                {
                    ::setPropBool( xYAxis, PROPNAME( CHART_PROP_LINKNUMFMT ), sal_False );
                    ::setPropValue( xYAxis, PROPNAME( CHART_PROP_NUMFMT ), rAxis.nNumForm );
                }

				//	bei Saeulen/Balkendiagrammen kommt unser Chart nicht gut mit automatischem
				//	Origin zurecht -> dann nur hart gesetzte Werte uebernehmen
                BOOL bManualOrigin = (eChartType == ctBar) || (eChartType == ctColumn) || (eChartType == ctUnknown);
				lcl_AxisValueFormat( xYAxis, rAxis.pValueRange, bManualOrigin );
                SetLineFormat( xYAxis, rAxis.pAxisLine );
				lcl_AxisTickFormat( xYAxis, rAxis.pTick );
                ::setPropBool( xYAxis, PROPNAME( CHART_PROP_TEXTOVERLAP ), sal_False );
                ::setPropBool( xYAxis, PROPNAME( CHART_PROP_TEXTBREAK ), rAxis.bBreakText );
                if( bHasCaption )
                {
                    SetTextData( xYAxis, rAxis.pCaptionText, pDefText2 );
                    rProgress.Progress();
                }
			}
            if( rAxis.pTitle )      // not implemented in StarOffice chart
                rProgress.Progress();
		}
		else
		{
            ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASSECYAXIS ), sal_False );
            ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASSECYAXISDESCR ), sal_False );
		}
	}

	// *** X AXIS ***

	if( pPrimAS && pPrimAS->pCatAxis )
	{
        XclImpChart_Axis& rAxis = *pPrimAS->pCatAxis;

        SetFrameFormat( xDiagr3D->getWall(), p3D ? rAxis.pWallLine : pPlotLine, p3D ? rAxis.pWallArea : pPlotArea );

        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASXAXIS ), sal_True );
        sal_Bool bHasCaption = rAxis.HasCaption();
        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASXAXISDESCR ), bHasCaption );

        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASXAXISGRID ), (rAxis.pMajorLine != NULL) );
        SetLineFormat( xDiaXSup->getXMainGrid(), rAxis.pMajorLine );
        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASXAXISHELPGRID ), (rAxis.pMinorLine != NULL) );
        SetLineFormat( xDiaXSup->getXHelpGrid(), rAxis.pMinorLine );

		uno::Reference< beans::XPropertySet > xXAxis = xDiaXSup->getXAxis();
		if( xXAxis.is() )
		{
			// value range / number format for XY charts
			if( rAxis.nNumForm != EXC_CHART_IFMT_INVALID )
            {
                ::setPropBool( xXAxis, PROPNAME( CHART_PROP_LINKNUMFMT ), sal_False );
                ::setPropValue( xXAxis, PROPNAME( CHART_PROP_NUMFMT ), rAxis.nNumForm );
            }

			lcl_AxisValueFormat( xXAxis, rAxis.pValueRange, FALSE );
            SetLineFormat( xXAxis, rAxis.pAxisLine );
			lcl_AxisTickFormat( xXAxis, rAxis.pTick );
            ::setPropBool( xXAxis, PROPNAME( CHART_PROP_TEXTOVERLAP ), sal_False );
            ::setPropBool( xXAxis, PROPNAME( CHART_PROP_TEXTBREAK ), rAxis.bBreakText );
            if( bHasCaption )
            {
                SetTextData( xXAxis, rAxis.pCaptionText, pDefText2 );
                rProgress.Progress();
            }
		}
		if( rAxis.pTitle )
        {
            SetTextData( xDiaXSup->getXAxisTitle(), rAxis.pTitle, pDefText2, aRealSize );
            rProgress.Progress();
        }
	}
	else
	{
        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASXAXIS ), sal_False );
        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASXAXISDESCR ), sal_False );
	}

	// *** Z AXIS ***

	if( pPrimAS && pPrimAS->pSeriesAxis )
	{
        XclImpChart_Axis& rAxis = *pPrimAS->pSeriesAxis;

        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASZAXIS ), sal_True );
        sal_Bool bHasCaption = rAxis.HasCaption();
        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASZAXISDESCR ), bHasCaption );

        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASZAXISGRID ), (rAxis.pMajorLine != NULL) );
        SetLineFormat( xDiaZSup->getZMainGrid(), rAxis.pMajorLine );
        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASZAXISHELPGRID ), (rAxis.pMinorLine != NULL) );
        SetLineFormat( xDiaZSup->getZHelpGrid(), rAxis.pMinorLine );

		uno::Reference< beans::XPropertySet > xZAxis = xDiaZSup->getZAxis();
		if( xZAxis.is() )
		{
            ::setPropBool( xZAxis, PROPNAME( CHART_PROP_TEXTOVERLAP ), sal_False );
            ::setPropBool( xZAxis, PROPNAME( CHART_PROP_TEXTBREAK ), rAxis.bBreakText );
            SetLineFormat( xZAxis, rAxis.pAxisLine );
			lcl_AxisTickFormat( xZAxis, rAxis.pTick );
            if( bHasCaption )
            {
                SetTextData( xZAxis, rAxis.pCaptionText, pDefText2 );
                rProgress.Progress();
            }
		}
		if( rAxis.pTitle )
        {
            SetTextData( xDiaZSup->getZAxisTitle(), rAxis.pTitle, pDefText2, aRealSize );
            rProgress.Progress();
        }
	}
	else
	{
        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASZAXIS ), sal_False );
        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_HASZAXISDESCR ), sal_False );
	}

	// *** DATA ROW / POINT PROPERTIES ***

    SetDataRowProperties( xDiagram, rProgress );

	Date* pDate = pExcRoot->pDoc->GetFormatTable()->GetNullDate();
	if( pDate )
	{
		uno::Reference< util::XNumberFormatsSupplier > xNumFormSup( xDiaXSup->getXAxis(), uno::UNO_QUERY );
		if( xNumFormSup.is() )
		{
			util::Date aDate( pDate->GetDay(), pDate->GetMonth(), pDate->GetYear() );
            uno::Reference< beans::XPropertySet > xPropSet = xNumFormSup->getNumberFormatSettings();
            ::setPropValue( xPropSet, PROPNAME( CHART_PROP_NULLDATE ), aDate );
		}
	}

	ApplyExtPost( xComponent );

	// *** CHART TITLE ***

	if( pChartTitle )
    {
        SetTextData( xChartDoc->getTitle(), pChartTitle, pDefText2, aRealSize );
        rProgress.Progress();
    }

	// *** DIAGRAM POSITION ***

// #90643# diagram/legend/title positioning disabled
#if 0
    // #88701# re-enabled for all chart types with axes
    if( (eChartType != ctPie) && (eChartType != ctDonut) && (eChartType != ctNet) )
//        lcl_SetDiagramPosition( xDiagram, pPrimAS, aRealSize, eChartType, 0 );
        lcl_SetDiagramPosition( xDiagram, pPrimAS, pSecAS, aRealSize, eChartType );
#endif

	// *** LEGEND ***

	if( pLegend )
	{
		uno::Reference< drawing::XShape > xLegendShape = xChartDoc->getLegend();
		uno::Reference< beans::XPropertySet > xLegendProp( xLegendShape, uno::UNO_QUERY );
		if( xLegendShape.is() && xLegendProp.is() )
		{
            SetFrameFormat( xLegendProp, pLegend->pLine, pLegend->pArea );
            SetTextData( xLegendProp, pLegend->pText, pDefText2 );

            chart::ChartLegendPosition eLegendPos;
			switch ( pLegend->nType )
			{
                case EXC_CHART_LEGEND_BOTTOM:   eLegendPos = chart::ChartLegendPosition_BOTTOM; break;
                case EXC_CHART_LEGEND_TOP:      eLegendPos = chart::ChartLegendPosition_TOP;    break;
                case EXC_CHART_LEGEND_RIGHT:    eLegendPos = chart::ChartLegendPosition_RIGHT;  break;
                case EXC_CHART_LEGEND_LEFT:     eLegendPos = chart::ChartLegendPosition_LEFT;   break;
                default:                        eLegendPos = pLegend->bVert ?
                    chart::ChartLegendPosition_RIGHT : chart::ChartLegendPosition_BOTTOM;
			}

            ::setPropValue( xLegendProp, PROPNAME( CHART_PROP_ALIGNMENT ), eLegendPos );
// #90643# diagram/legend/title positioning disabled
#if 0
			lcl_SetPosition( xLegendShape, pLegend->aPos, 0, aRealSize, FALSE );

            // #88701# correct diagram area
            xModel->unlockControllers();
            xModel->lockControllers();
            uno::Reference< drawing::XShape > xDiaShape( xDiagram, uno::UNO_QUERY );
            if( xDiaShape.is() && pPrimAS )
            {
                awt::Point aAwtPt = xLegendShape->getPosition();
                awt::Size aAwtSz = xLegendShape->getSize();
                Point aLegTL( aAwtPt.X, aAwtPt.Y );
                Point aLegBR( aAwtPt.X + aAwtSz.Width, aAwtPt.Y + aAwtSz.Height );

                aAwtPt = xDiaShape->getPosition();
                aAwtSz = xDiaShape->getSize();
                Point aDiaTL( aAwtPt.X, aAwtPt.Y );
                Point aDiaBR( aAwtPt.X + aAwtSz.Width, aAwtPt.Y + aAwtSz.Height );

                const XclImpChart_Pos& rXlDia = pPrimAS->aPos;
                const XclImpChart_Pos& rXlLeg = pLegend->aPos;

                if( (aDiaTL.Y() <= aLegBR.Y()) && (aDiaBR.Y() >= aLegTL.Y()) )
                {
                    long nDist = aLegTL.X() - aDiaBR.X();
                    if( (nDist < 0) && (rXlLeg.nPosX >= (long)(rXlDia.nPosX + rXlDia.nWidth)) )
                        aAwtSz.Width += nDist - SC_CHART_MINDIST;
                    else
                    {
                        nDist = aDiaTL.X() - aLegBR.X();
                        if( (nDist < 0) && (rXlDia.nPosX >= (long)(rXlLeg.nPosX + rXlLeg.nWidth)) )
                        {
                            aAwtPt.X -= nDist - SC_CHART_MINDIST;
                            aAwtSz.Width += nDist - SC_CHART_MINDIST;
                        }
                    }
                }
                else if( (aDiaTL.X() <= aLegBR.X()) && (aDiaBR.X() >= aLegTL.X()) )
                {
                    long nDist = aLegTL.Y() - aDiaBR.Y();
                    if( (nDist < 0) && (rXlLeg.nPosY >= (long)(rXlDia.nPosY + rXlDia.nHeight)) )
                        aAwtSz.Height += nDist - SC_CHART_MINDIST;
                    else
                    {
                        nDist = aDiaTL.Y() - aLegBR.Y();
                        if( (nDist < 0) && (rXlDia.nPosY >= (long)(rXlLeg.nPosY + rXlLeg.nHeight)) )
                        {
                            aAwtPt.Y -= nDist - SC_CHART_MINDIST;
                            aAwtSz.Height += nDist - SC_CHART_MINDIST;
                        }
                    }
                }

                try
                {
                    xDiaShape->setPosition( aAwtPt );
                    xDiaShape->setSize( aAwtSz );
                }
                catch( uno::Exception& )
                {
                }
            }
#endif
            rProgress.Progress();
        }
	}

	xModel->unlockControllers();
}

//___________________________________________________________________
// chart types

void lcl_SetChartType( uno::Reference< lang::XComponent > xComponent, const OUString& rType )
{
	uno::Reference< chart::XChartDocument > xChartDoc( xComponent, uno::UNO_QUERY );
	uno::Reference< lang::XMultiServiceFactory > xFactory( xComponent, uno::UNO_QUERY );
	if( !xChartDoc.is() || !xFactory.is() ) return;
	uno::Reference< uno::XInterface > xInstance = xFactory->createInstance( rType );
	uno::Reference< chart::XDiagram > xNewDiagram( xInstance, uno::UNO_QUERY );
	if( !xNewDiagram.is() ) return;
	xChartDoc->setDiagram( xNewDiagram );
}


void XclImpChartLine::ApplyExt( uno::Reference< lang::XComponent > xComponent )
{
	if( !xComponent.is() ) return;

	if( eChartType == ctArea )
        lcl_SetChartType( xComponent, PROPNAME( CHART_STRING_AREA ) );
	else if( bStock )
        lcl_SetChartType( xComponent, PROPNAME( CHART_STRING_STOCK ) );
	else
        lcl_SetChartType( xComponent, PROPNAME( CHART_STRING_LINE ) );   // vor getDiagram

	uno::Reference< chart::XChartDocument > xChartDoc( xComponent, uno::UNO_QUERY );
	if( !xChartDoc.is() ) return;
	uno::Reference< chart::XDiagram > xDiagram = xChartDoc->getDiagram();
	uno::Reference< beans::XPropertySet > xDiaProp( xDiagram, uno::UNO_QUERY );
    if( !xDiaProp.is() ) return;

	// #86200# setting "Percent" to sal_False resets "Stacked" even if it was set
	if( bStacked )
        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_STACKED ), sal_True );
	if( bCatAsPercent )
        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_PERCENT ), sal_True );
}

void XclImpChartLine::ApplyExtPost( uno::Reference< lang::XComponent > xComponent )
{
	if( !xComponent.is() || (eChartType == ctArea) ) return;

	uno::Reference< chart::XChartDocument > xChartDoc( xComponent, uno::UNO_QUERY );
	if( !xChartDoc.is() ) return;
	uno::Reference< chart::XDiagram > xDiagram = xChartDoc->getDiagram();
	uno::Reference< beans::XPropertySet > xDiaProp( xDiagram, uno::UNO_QUERY );
	if( !xDiagram.is() || !xDiaProp.is() ) return;

	if( bStock )
	{
        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_UPDOWN ), (pUpBar || pDownBar) );
        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_VOLUME ), bSecondary );

		uno::Reference< chart::XStatisticDisplay > xStat( xDiagram, uno::UNO_QUERY );
		if( xStat.is() )
		{
            SetLineFormat( xStat->getMinMaxLine(), pHiLoLine );
			if( pUpBar )
                SetFrameFormat( xStat->getUpBar(), pUpBar->pLine, pUpBar->pArea );
			if( pDownBar )
                SetFrameFormat( xStat->getDownBar(), pDownBar->pLine, pDownBar->pArea );
		}
	}
}


void XclImpChartBar::ApplyExt( uno::Reference< lang::XComponent > xComponent )
{
	if( !xComponent.is() ) return;
    lcl_SetChartType( xComponent, PROPNAME( CHART_STRING_BAR ) );    // vor getDiagram

	uno::Reference< chart::XChartDocument > xChartDoc( xComponent, uno::UNO_QUERY );
	if( !xChartDoc.is() ) return;
	uno::Reference< chart::XDiagram > xDiagram = xChartDoc->getDiagram();
	uno::Reference< chart::XTwoAxisYSupplier > xDiaYSup( xDiagram, uno::UNO_QUERY );
	uno::Reference< beans::XPropertySet > xDiaProp( xDiagram, uno::UNO_QUERY );
	if( !xDiagram.is() || !xDiaYSup.is() || !xDiaProp.is() ) return;

    ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_VERTICAL ), bHorizontal );

	// #86200# setting "Percent" to sal_False resets "Stacked" even if it was set
	if( bStacked )
        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_STACKED ), sal_True );
	if( bCatAsPercent )
        ::setPropBool( xDiaProp, PROPNAME( CHART_PROP_PERCENT ), sal_True );

	//!	CHART_PROP_STACKCONN

	//	GapWidth / Overlap
	uno::Reference< beans::XPropertySet > xYAxis = xDiaYSup->getYAxis();
	if( xYAxis.is() )
	{
        ::setPropValue( xYAxis, PROPNAME( CHART_PROP_GAPWIDTH ), (sal_Int32) nSpaceBeetwCat );
        ::setPropValue( xYAxis, PROPNAME( CHART_PROP_OVERLAP ), (sal_Int32) nSpaceBeetwBar );
	}

	uno::Reference< beans::XPropertySet > xSecondary = xDiaYSup->getSecondaryYAxis();
	if( xSecondary.is() )
	{
		//	eigene Werte fuer 2. Y-Achse aus Excel lesen
        ::setPropValue( xSecondary, PROPNAME( CHART_PROP_GAPWIDTH ), (sal_Int32) nSpaceBeetwCat );
        ::setPropValue( xSecondary, PROPNAME( CHART_PROP_OVERLAP ), (sal_Int32) nSpaceBeetwBar );
	}
}


void XclImpChartPie::ApplyExt( uno::Reference< lang::XComponent > xComponent )
{
	if( !xComponent.is() ) return;

	if( nHoleSize == 0 )
        lcl_SetChartType( xComponent, PROPNAME( CHART_STRING_PIE ) );
	else
        lcl_SetChartType( xComponent, PROPNAME( CHART_STRING_DONUT ) );
}


void XclImpChartRadar::ApplyExt( uno::Reference< lang::XComponent > xComponent )
{
	if( !xComponent.is() ) return;
    lcl_SetChartType( xComponent, PROPNAME( CHART_STRING_NET ) );    // vor getDiagram
}


void XclImpChartSurface::ApplyExt( uno::Reference< lang::XComponent > )
{
	//	koenn' wa nich?
}

void XclImpChartScatter::ApplyExt( uno::Reference< lang::XComponent > xComponent )
{
	if( !xComponent.is() ) return;
    lcl_SetChartType( xComponent, PROPNAME( CHART_STRING_XY ) ); // vor getDiagram
}


}
