/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_inputhdl.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:46:14 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------

#include "scitems.hxx"
// auto strip #include <bf_svx/eeitem.hxx>
#define ITEMID_FIELD EE_FEATURE_FIELD

// auto strip #include <bf_svx/algitem.hxx>
// auto strip #include <bf_svx/adjitem.hxx>
// auto strip #include <bf_svx/brshitem.hxx>
// auto strip #include <svtools/colorcfg.hxx>
// auto strip #include <bf_svx/colritem.hxx>
#include <bf_svx/editobj.hxx>
#include <bf_svx/editstat.hxx>
// auto strip #include <bf_svx/editview.hxx>
#include <bf_svx/escpitem.hxx>
// auto strip #include <bf_svx/forbiddencharacterstable.hxx>
// auto strip #include <bf_svx/langitem.hxx>
#include <bf_svx/svxacorr.hxx>
// auto strip #include <bf_svx/unolingu.hxx>
// auto strip #include <bf_svx/wghtitem.hxx>
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #include <bf_sfx2/docfile.hxx>
#include <bf_sfx2/printer.hxx>
#include <bf_offmgr/app.hxx>
#include <svtools/zforlist.hxx>
// auto strip #include <vcl/sound.hxx>
// auto strip #ifndef _UNOTOOLS_LOCALEDATAWRAPPER_HXX
// auto strip #include <unotools/localedatawrapper.hxx>
// auto strip #endif

#ifndef _SV_HELP_HXX //autogen
#include <vcl/help.hxx>
#endif

// auto strip #ifndef _SV_CURSOR_HXX //autogen
// auto strip #include <vcl/cursor.hxx>
// auto strip #endif


#include "inputwin.hxx"
#include "tabvwsh.hxx"
#include "docsh.hxx"
//#include "appmain.hxx"
#include "scmod.hxx"
// auto strip #include "uiitems.hxx"
// auto strip #include "global.hxx"
#include "bf_sc.hrc"
#include "globstr.hrc"
#include "patattr.hxx"
// auto strip #include "viewdata.hxx"
// auto strip #include "document.hxx"
// auto strip #include "docpool.hxx"
#include "editutil.hxx"
// auto strip #include "collect.hxx"
// auto strip #include "appoptio.hxx"
// auto strip #include "docoptio.hxx"
// auto strip #include "validat.hxx"
#include "userlist.hxx"
#include "rfindlst.hxx"
#include "inputopt.hxx"
// auto strip #include "cell.hxx"				// fuer Formel-Preview
// auto strip #include "compiler.hxx"			// fuer Formel-Preview
// auto strip #include "editable.hxx"

#define _INPUTHDL_CXX
#include "inputhdl.hxx"
namespace binfilter {

//	max. Ranges im RangeFinder
#define RANGEFIND_MAX	32

// STATIC DATA -----------------------------------------------------------

BOOL ScInputHandler::bOptLoaded = FALSE;			// App-Optionen ausgewertet
BOOL ScInputHandler::bAutoComplete = FALSE;			// wird in KeyInput gesetzt

//	delimiters (in addition to ScEditUtil) needed for range finder:
//	only characters that are allowed in formulas next to references
//	and the quotation mark (so string constants can be skipped)

static const sal_Char __FAR_DATA pMinDelimiters[] = " !\"";

extern USHORT nEditAdjust;		//! Member an ViewData

//==================================================================

//STRIP001 void ScInputHandler::InitRangeFinder( const String& rFormula )
//STRIP001 {
//STRIP001 	DeleteRangeFinder();
//STRIP001 
//STRIP001 	if ( !pActiveViewSh || !SC_MOD()->GetInputOptions().GetRangeFinder() )
//STRIP001 		return;
//STRIP001 	ScDocShell* pDocSh = pActiveViewSh->GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 
//STRIP001 //	String aDelimiters = pEngine->GetWordDelimiters();
//STRIP001 	String aDelimiters = ScEditUtil::ModifyDelimiters(
//STRIP001 							String::CreateFromAscii( pMinDelimiters ) );
//STRIP001 
//STRIP001 	xub_StrLen nColon = aDelimiters.Search(':');
//STRIP001 	if ( nColon != STRING_NOTFOUND )
//STRIP001 		aDelimiters.Erase( nColon, 1 );				// Delimiter ohne Doppelpunkt
//STRIP001 	xub_StrLen nDot = aDelimiters.Search('.');
//STRIP001 	if ( nDot != STRING_NOTFOUND )
//STRIP001 		aDelimiters.Erase( nDot, 1 );				// Delimiter ohne Punkt
//STRIP001 
//STRIP001 	const sal_Unicode* pChar = rFormula.GetBuffer();
//STRIP001 	xub_StrLen nLen = rFormula.Len();
//STRIP001 	xub_StrLen nPos = 0;
//STRIP001 	xub_StrLen nStart = 0;
//STRIP001 	USHORT nCount = 0;
//STRIP001 	ScRange aRange;
//STRIP001 	while ( nPos < nLen && nCount < RANGEFIND_MAX )
//STRIP001 	{
//STRIP001 		//	Trenner ueberlesen
//STRIP001 		while ( nPos<nLen && ScGlobal::UnicodeStrChr( aDelimiters.GetBuffer(), pChar[nPos] ) )
//STRIP001 		{
//STRIP001 			if ( pChar[nPos] == '"' )						// String
//STRIP001 			{
//STRIP001 				++nPos;
//STRIP001 				while (nPos<nLen && pChar[nPos] != '"')		// bis zum Ende ueberlesen
//STRIP001 					++nPos;
//STRIP001 			}
//STRIP001 			++nPos;						// Trennzeichen oder schliessender Quote
//STRIP001 		}
//STRIP001 
//STRIP001 		//	Text zwischen Trennern
//STRIP001 		nStart = nPos;
//STRIP001 		while ( nPos<nLen && !ScGlobal::UnicodeStrChr( aDelimiters.GetBuffer(), pChar[nPos] ) )
//STRIP001 			++nPos;
//STRIP001 
//STRIP001 		if ( nPos > nStart )
//STRIP001 		{
//STRIP001 			String aTest = rFormula.Copy( nStart, nPos-nStart );
//STRIP001 			USHORT nFlags = aRange.ParseAny( aTest, pDoc );
//STRIP001 			if ( nFlags & SCA_VALID )
//STRIP001 			{
//STRIP001 				//	Tabelle setzen, wenn nicht angegeben
//STRIP001 				if ( (nFlags & SCA_TAB_3D) == 0 )
//STRIP001 					aRange.aStart.SetTab( pActiveViewSh->GetViewData()->GetTabNo() );
//STRIP001 				if ( (nFlags & SCA_TAB2_3D) == 0 )
//STRIP001 					aRange.aEnd.SetTab( aRange.aStart.Tab() );
//STRIP001 
//STRIP001 				if (!nCount)
//STRIP001 				{
//STRIP001 					pEngine->SetUpdateMode( FALSE );
//STRIP001 					pRangeFindList = new ScRangeFindList( pDocSh->GetTitle() );
//STRIP001 				}
//STRIP001 
//STRIP001 				ScRangeFindData* pNew = new ScRangeFindData( aRange, nFlags, nStart, nPos );
//STRIP001 				pRangeFindList->Insert( pNew );
//STRIP001 
//STRIP001 				ESelection aSel( 0, nStart, 0, nPos );
//STRIP001 				SfxItemSet aSet( pEngine->GetEmptyItemSet() );
//STRIP001 				aSet.Put( SvxColorItem( Color( ScRangeFindList::GetColorName( nCount ) ),
//STRIP001 							EE_CHAR_COLOR ) );
//STRIP001 				pEngine->QuickSetAttribs( aSet, aSel );
//STRIP001 				++nCount;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		//	letzten Trenner nicht ueberlesen, koennte ja ein Quote sein (?)
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nCount)
//STRIP001 	{
//STRIP001 		pEngine->SetUpdateMode( TRUE );
//STRIP001 
//STRIP001 		pDocSh->Broadcast( SfxSimpleHint( SC_HINT_SHOWRANGEFINDER ) );
//STRIP001 	}
//STRIP001 }

//STRIP001 void lcl_Replace( EditView* pView, const String& rNewStr, const ESelection& rOldSel )
//STRIP001 {
//STRIP001 	if ( pView )
//STRIP001 	{
//STRIP001 		ESelection aOldSel = pView->GetSelection();
//STRIP001 		if (aOldSel.HasRange())
//STRIP001 			pView->SetSelection( ESelection( aOldSel.nEndPara, aOldSel.nEndPos,
//STRIP001 											 aOldSel.nEndPara, aOldSel.nEndPos ) );
//STRIP001 
//STRIP001 		EditEngine* pEngine = pView->GetEditEngine();
//STRIP001 		pEngine->QuickInsertText( rNewStr, rOldSel );
//STRIP001 
//STRIP001 		//	Dummy-InsertText fuer Update und Paint
//STRIP001 		//	dafuer muss oben die Selektion aufgehoben werden (vor QuickInsertText)
//STRIP001 		pView->InsertText( EMPTY_STRING, FALSE );
//STRIP001 
//STRIP001 		xub_StrLen nLen = pEngine->GetTextLen(0);
//STRIP001 		ESelection aSel( 0, nLen, 0, nLen );
//STRIP001 		pView->SetSelection( aSel );				// Cursor ans Ende
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScInputHandler::UpdateRange( USHORT nIndex, const ScRange& rNew )
//STRIP001 {
//STRIP001 	ScTabViewShell* pDocView = pRefViewSh ? pRefViewSh : pActiveViewSh;
//STRIP001 	if ( pDocView && pRangeFindList && nIndex < pRangeFindList->Count() )
//STRIP001 	{
//STRIP001 		ScRangeFindData* pData = pRangeFindList->GetObject( nIndex );
//STRIP001 		xub_StrLen nOldStart = pData->nSelStart;
//STRIP001 		xub_StrLen nOldEnd = pData->nSelEnd;
//STRIP001 
//STRIP001 		ScRange aJustified = rNew;
//STRIP001 		aJustified.Justify();			// Ref in der Formel immer richtigherum anzeigen
//STRIP001 		String aNewStr;
//STRIP001 		aJustified.Format( aNewStr, pData->nFlags, pDocView->GetViewData()->GetDocument() );
//STRIP001 		ESelection aOldSel( 0, nOldStart, 0, nOldEnd );
//STRIP001 
//STRIP001 		DataChanging();
//STRIP001 
//STRIP001 		lcl_Replace( pTopView, aNewStr, aOldSel );
//STRIP001 		lcl_Replace( pTableView, aNewStr, aOldSel );
//STRIP001 
//STRIP001 		bInRangeUpdate = TRUE;
//STRIP001 		DataChanged();
//STRIP001 		bInRangeUpdate = FALSE;
//STRIP001 
//STRIP001 		long nDiff = aNewStr.Len() - (long)(nOldEnd-nOldStart);
//STRIP001 
//STRIP001 		pData->aRef = rNew;
//STRIP001 		pData->nSelEnd = (xub_StrLen)(pData->nSelEnd + nDiff);
//STRIP001 
//STRIP001 		USHORT nCount = (USHORT) pRangeFindList->Count();
//STRIP001 		for (USHORT i=nIndex+1; i<nCount; i++)
//STRIP001 		{
//STRIP001 			ScRangeFindData* pNext = pRangeFindList->GetObject( i );
//STRIP001 			pNext->nSelStart = (xub_StrLen)(pNext->nSelStart + nDiff);
//STRIP001 			pNext->nSelEnd   = (xub_StrLen)(pNext->nSelEnd   + nDiff);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		DBG_ERROR("UpdateRange: da fehlt was");
//STRIP001 }

/*N*/ void ScInputHandler::DeleteRangeFinder()
/*N*/ {
/*N*/ 	ScTabViewShell* pPaintView = pRefViewSh ? pRefViewSh : pActiveViewSh;
/*N*/ 	if ( pRangeFindList && pPaintView )
/*N*/ 	{
		DBG_BF_ASSERT(0, "STRIP"); //STRIP001  /*?*/ 		ScDocShell* pDocSh = pActiveViewSh->GetViewData()->GetDocShell();
//STRIP001 /*?*/ 		pRangeFindList->SetHidden(TRUE);
//STRIP001 /*?*/ 		pDocSh->Broadcast( SfxSimpleHint( SC_HINT_SHOWRANGEFINDER ) );	// wegnehmen
//STRIP001 /*?*/ 		DELETEZ(pRangeFindList);
/*N*/ 	}
/*N*/ }

//==================================================================

/*N*/ inline String GetEditText(EditEngine* pEng)
/*N*/ {
/*?*/ 	 return ScEditUtil::GetSpaceDelimitedString(*pEng);
/*N*/ }

/*N*/ void lcl_RemoveTabs(String& rStr)
/*N*/ {
/*N*/ 	xub_StrLen nPos;
/*N*/ 	while ( (nPos=rStr.Search('\t')) != STRING_NOTFOUND )
/*N*/ 		rStr.SetChar( nPos, ' ' );
/*N*/ }

//STRIP001 void lcl_RemoveLineEnd(String& rStr)
//STRIP001 {
//STRIP001 	rStr.ConvertLineEnd(LINEEND_LF);
//STRIP001 	xub_StrLen nPos;
//STRIP001 	while ( (nPos=rStr.Search('\n')) != STRING_NOTFOUND )
//STRIP001 		rStr.SetChar( nPos, ' ' );
//STRIP001 }

//==================================================================

/*N*/ ScInputHandler::ScInputHandler()
/*N*/ 	:	eMode( SC_INPUT_NONE ),
/*N*/ 		bModified( FALSE ),
/*N*/ 		bFormulaMode( FALSE ),
/*N*/ 		bSelIsRef( FALSE ),
/*N*/ 		bInRangeUpdate( FALSE ),
/*N*/ 		pInputWin( NULL ),
/*N*/ 		pRefViewSh( NULL ),
/*N*/ 		pLastPattern( NULL ),
/*N*/ 		pLastState( NULL ),
/*N*/ 		bLastIsSymbol( FALSE ),
/*N*/ 		bProtected( FALSE ),
/*N*/ 		bTextValid( TRUE ),
/*N*/ 		bCellHasPercentFormat( FALSE ),
/*N*/ 		nValidation( 0 ),
/*N*/ 		nAttrAdjust( SVX_HOR_JUSTIFY_STANDARD ),
/*N*/ 		aScaleX( 1,1 ),
/*N*/ 		aScaleY( 1,1 ),
/*N*/ 		pTopView( NULL ),
/*N*/ 		pTableView( NULL ),
/*N*/ 		pEngine( NULL ),
/*N*/ 		pEditDefaults( NULL ),
/*N*/ 		pDelayTimer( NULL ),
/*N*/ 		pColumnData( NULL ),
/*N*/ 		pFormulaData( NULL ),
/*N*/ 		nTipVisible( 0 ),
/*N*/ 		nAutoPos( SCPOS_INVALID ),
/*N*/ 		bUseTab( FALSE ),
/*N*/ 		nFormSelStart( 0 ),
/*N*/ 		nFormSelEnd( 0 ),
/*N*/ 		nAutoPar( 0 ),
/*N*/ 		pRangeFindList( NULL ),
/*N*/ 		bParenthesisShown( FALSE ),
/*N*/ 		bCreatingFuncView( FALSE ),
/*N*/ 		bInEnterHandler( FALSE ),
/*N*/ 		bCommandErrorShown( FALSE ),
/*N*/ 		bInOwnChange( FALSE )
/*N*/ {
/*N*/ 	//	The InputHandler is constructed with the view, so SfxViewShell::Current
/*N*/ 	//	doesn't have the right view yet. pActiveViewSh is updated in NotifyChange.
/*N*/ 	pActiveViewSh = NULL;
/*N*/ 
/*N*/ 	//	Bindings (nur noch fuer Invalidate benutzt) werden bei Bedarf aktuell geholt
/*N*/ }

/*N*/ __EXPORT ScInputHandler::~ScInputHandler()
/*N*/ {
/*N*/ 	//	Wenn dies der Applikations-InputHandler ist, wird der dtor erst nach SfxApplication::Main
/*N*/ 	//	gerufen, darf sich also auf keine Sfx-Funktionen mehr verlassen
/*N*/ 
/*N*/ 	if ( !SFX_APP()->IsDowning() )			// inplace
/*N*/ 		EnterHandler();						// Eingabe noch abschliessen
/*N*/ 
/*N*/ 	if (SC_MOD()->GetRefInputHdl()==this)
		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		SC_MOD()->SetRefInputHdl(NULL);
/*N*/ 
/*N*/ 	if ( pInputWin && pInputWin->GetInputHandler() == this )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pInputWin->SetInputHandler( NULL );

/*N*/ 	delete pRangeFindList;
/*N*/ 	delete pEditDefaults;
/*N*/ 	delete pEngine;
/*N*/ 	delete pLastState;
/*N*/ 	delete pDelayTimer;
/*N*/ 	delete pColumnData;
/*N*/ 	delete pFormulaData;
/*N*/ }

/*N*/ void ScInputHandler::SetRefScale( const Fraction& rX, const Fraction& rY )
/*N*/ {
/*N*/ 	if ( rX != aScaleX || rY != aScaleY )
/*N*/ 	{
/*?*/ 		aScaleX = rX;
/*?*/ 		aScaleY = rY;
/*?*/ 		if (pEngine)
/*?*/ 		{
/*?*/ 			MapMode aMode( MAP_100TH_MM, Point(), aScaleX, aScaleY );
/*?*/ 			pEngine->SetRefMapMode( aMode );
/*?*/ 		}
/*N*/ 	}
/*N*/ }

/*N*/ void ScInputHandler::UpdateRefDevice()
/*N*/ {
/*N*/ 	if (!pEngine)
/*?*/ 		return;
/*N*/ 
/*N*/ 	BOOL bTextWysiwyg = SC_MOD()->GetInputOptions().GetTextWysiwyg();
/*N*/ 	if ( bTextWysiwyg && pActiveViewSh )
/*?*/ 		pEngine->SetRefDevice( pActiveViewSh->GetViewData()->GetDocument()->GetPrinter() );
/*N*/ 	else
/*N*/ 		pEngine->SetRefDevice( NULL );
/*N*/ 
/*N*/ 	MapMode aMode( MAP_100TH_MM, Point(), aScaleX, aScaleY );
/*N*/ 	pEngine->SetRefMapMode( aMode );
/*N*/ 
/*N*/ 	//	SetRefDevice(NULL) uses VirtualDevice, SetRefMapMode forces creation of a local VDev,
/*N*/ 	//	so the DigitLanguage can be safely modified (might use an own VDev instead of NULL).
/*N*/ 	if ( !( bTextWysiwyg && pActiveViewSh ) )
/*N*/ 	{
/*?*/ 		pEngine->GetRefDevice()->SetDigitLanguage( SC_MOD()->GetOptDigitLanguage() );
/*N*/ 	}
/*N*/ }

/*N*/ void ScInputHandler::ImplCreateEditEngine()
/*N*/ {
/*N*/ 	if ( !pEngine )
/*N*/ 	{
/*N*/ 		if ( pActiveViewSh )
/*N*/ 		{
/*N*/ 			const ScDocument* pDoc = pActiveViewSh->GetViewData()->GetDocShell()->GetDocument();
/*N*/ 			pEngine = new ScFieldEditEngine( pDoc->GetEnginePool(), pDoc->GetEditPool() );
/*N*/ 		}
/*N*/ 		else
/*N*/ 			pEngine = new ScFieldEditEngine( EditEngine::CreatePool(), NULL, TRUE );
/*N*/ 		pEngine->SetWordDelimiters( ScEditUtil::ModifyDelimiters( pEngine->GetWordDelimiters() ) );
/*N*/ 		UpdateRefDevice();		// also sets MapMode
/*N*/ 		pEngine->SetPaperSize( Size( 1000000, 1000000 ) );
/*N*/ 		pEditDefaults = new SfxItemSet( pEngine->GetEmptyItemSet() );
/*N*/ 
/*N*/ 		pEngine->SetControlWord( pEngine->GetControlWord() | EE_CNTRL_AUTOCORRECT );
/*N*/         pEngine->SetModifyHdl( LINK( this, ScInputHandler, ModifyHdl ) );
/*N*/ 	}
/*N*/ }

//STRIP001 void ScInputHandler::UpdateAutoCorrFlag()
//STRIP001 {
//STRIP001 	ULONG nCntrl = pEngine->GetControlWord();
//STRIP001 	ULONG nOld = nCntrl;
//STRIP001 
//STRIP001 	//	don't use pLastPattern here (may be invalid because of AutoStyle)
//STRIP001 
//STRIP001 	BOOL bDisable = bLastIsSymbol || bFormulaMode;
//STRIP001 	if ( bDisable )
//STRIP001 		nCntrl &= ~EE_CNTRL_AUTOCORRECT;
//STRIP001 	else
//STRIP001 		nCntrl |= EE_CNTRL_AUTOCORRECT;
//STRIP001 
//STRIP001 	if ( nCntrl != nOld )
//STRIP001 		pEngine->SetControlWord(nCntrl);
//STRIP001 }

//STRIP001 void ScInputHandler::UpdateSpellSettings( BOOL bFromStartTab )
//STRIP001 {
//STRIP001 	if ( pActiveViewSh )
//STRIP001 	{
//STRIP001 		ScViewData* pViewData = pActiveViewSh->GetViewData();
//STRIP001 		BOOL bOnlineSpell = pViewData->GetDocument()->GetDocOptions().IsAutoSpell();
//STRIP001 		BOOL bHideSpell = pViewData->GetOptions().IsHideAutoSpell();
//STRIP001 
//STRIP001 		//	SetDefaultLanguage is independent of the language attributes,
//STRIP001 		//	ScGlobal::GetEditDefaultLanguage is always used.
//STRIP001 		//	It must be set every time in case the office language was changed.
//STRIP001 
//STRIP001 		pEngine->SetDefaultLanguage( ScGlobal::GetEditDefaultLanguage() );
//STRIP001 
//STRIP001 		//	if called for changed options, update flags only if already editing
//STRIP001 		//	if called from StartTable, always update flags
//STRIP001 
//STRIP001 		if ( bFromStartTab || eMode != SC_INPUT_NONE )
//STRIP001 		{
//STRIP001 			ULONG nCntrl = pEngine->GetControlWord();
//STRIP001 			ULONG nOld = nCntrl;
//STRIP001 			if( bHideSpell )
//STRIP001 				nCntrl |= EE_CNTRL_NOREDLINES;
//STRIP001 			else
//STRIP001 				nCntrl &= ~EE_CNTRL_NOREDLINES;
//STRIP001 			if( bOnlineSpell )
//STRIP001 				nCntrl |= EE_CNTRL_ONLINESPELLING;
//STRIP001 			else
//STRIP001 				nCntrl &= ~EE_CNTRL_ONLINESPELLING;
//STRIP001 			// kein AutoCorrect auf Symbol-Font (EditEngine wertet Default nicht aus)
//STRIP001 			if ( pLastPattern && pLastPattern->IsSymbolFont() )
//STRIP001 				nCntrl &= ~EE_CNTRL_AUTOCORRECT;
//STRIP001 			else
//STRIP001 				nCntrl |= EE_CNTRL_AUTOCORRECT;
//STRIP001 			if ( nCntrl != nOld )
//STRIP001 				pEngine->SetControlWord(nCntrl);
//STRIP001 
//STRIP001 			ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 			pEngine->SetForbiddenCharsTable( pDoc->GetForbiddenCharacters() );
//STRIP001 			pEngine->SetAsianCompressionMode( pDoc->GetAsianCompression() );
//STRIP001 			pEngine->SetKernAsianPunctuation( pDoc->GetAsianKerning() );
//STRIP001 			pEngine->SetDefaultHorizontalTextDirection(
//STRIP001 				(EEHorizontalTextDirection)pDoc->GetEditTextDirection( pViewData->GetTabNo() ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		//	language is set separately, so the speller is needed only if online
//STRIP001 		//	spelling is active
//STRIP001 
//STRIP001 		if ( bOnlineSpell ) {
//STRIP001             ::com::sun::star::uno::Reference< ::com::sun::star::linguistic2::XSpellChecker1> xXSpellChecker1( LinguMgr::GetSpellChecker() );
//STRIP001 			pEngine->SetSpeller( xXSpellChecker1 );
//STRIP001         }
//STRIP001 
//STRIP001 		BOOL bHyphen = pLastPattern && ((const SfxBoolItem&)pLastPattern->GetItem(ATTR_HYPHENATE)).GetValue();
//STRIP001 		if ( bHyphen ) {
//STRIP001             ::com::sun::star::uno::Reference< ::com::sun::star::linguistic2::XHyphenator> xXHyphenator( LinguMgr::GetHyphenator() );
//STRIP001 			pEngine->SetHyphenator( xXHyphenator );
//STRIP001         }
//STRIP001 	}
//STRIP001 }

//
//		Funktionen/Bereichsnamen etc. als Tip-Hilfe
//

#define SC_STRTYPE_FUNCTIONS	1
//	die anderen Typen sind in ScDocument::GetFormulaEntries festgelegt

//STRIP001 void ScInputHandler::GetFormulaData()
//STRIP001 {
//STRIP001 	if ( pActiveViewSh )
//STRIP001 	{
//STRIP001 		ScDocument* pDoc = pActiveViewSh->GetViewData()->GetDocShell()->GetDocument();
//STRIP001 
//STRIP001 		if ( pFormulaData )
//STRIP001 			pFormulaData->FreeAll();
//STRIP001 		else
//STRIP001 			pFormulaData = new TypedStrCollection;
//STRIP001 
//STRIP001 		//		MRU-Funktionen aus dem Funktions-Autopiloten
//STRIP001 		//		wie in ScPosWnd::FillFunctions (inputwin.cxx)
//STRIP001 
//STRIP001 		const ScAppOptions& rOpt = SC_MOD()->GetAppOptions();
//STRIP001 		USHORT nMRUCount = rOpt.GetLRUFuncListCount();
//STRIP001 		const USHORT* pMRUList = rOpt.GetLRUFuncList();
//STRIP001 		if (pMRUList)
//STRIP001 		{
//STRIP001 			const ScFunctionList* pFuncList = ScGlobal::GetStarCalcFunctionList();
//STRIP001 			ULONG nListCount = pFuncList->GetCount();
//STRIP001 			ScFunctionMgr* pFuncMgr = ScGlobal::GetStarCalcFunctionMgr();
//STRIP001 			for (USHORT i=0; i<nMRUCount; i++)
//STRIP001 			{
//STRIP001 				USHORT nId = pMRUList[i];
//STRIP001 				for (ULONG j=0; j<nListCount; j++)
//STRIP001 				{
//STRIP001 					const ScFuncDesc* pDesc = pFuncList->GetFunction( j );
//STRIP001 					if ( pDesc->nFIndex == nId && pDesc->pFuncName )
//STRIP001 					{
//STRIP001 						String aEntry = *pDesc->pFuncName;
//STRIP001 						aEntry.AppendAscii(RTL_CONSTASCII_STRINGPARAM( "()" ));
//STRIP001 						TypedStrData* pData = new TypedStrData( aEntry, 0.0, SC_STRTYPE_FUNCTIONS );
//STRIP001 						if (!pFormulaData->Insert(pData))
//STRIP001 							delete pData;
//STRIP001 						break;					// nicht weitersuchen
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		pDoc->GetFormulaEntries( *pFormulaData );
//STRIP001 	}
//STRIP001 }

/*N*/ void ScInputHandler::HideTip()
/*N*/ {
/*N*/ 	if ( nTipVisible )
/*N*/ 	{
/*?*/ 		Help::HideTip( nTipVisible );
/*?*/ 		nTipVisible = 0;
/*N*/ 	}
/*N*/ 	aManualTip.Erase();
/*N*/ }

//STRIP001 void ScInputHandler::ShowTip( const String& rText )
//STRIP001 {
//STRIP001 	//	aManualTip muss hinterher von aussen gesetzt werden
//STRIP001 	HideTip();
//STRIP001 
//STRIP001 	EditView* pActiveView = pTopView ? pTopView : pTableView;
//STRIP001 	if (pActiveView)
//STRIP001 	{
//STRIP001 		Point aPos;
//STRIP001 		Window* pWin = pActiveView->GetWindow();
//STRIP001 		Cursor* pCur = pActiveView->GetCursor();
//STRIP001 		if (pCur)
//STRIP001 			aPos = pWin->LogicToPixel( pCur->GetPos() );
//STRIP001 		aPos = pWin->OutputToScreenPixel( aPos );
//STRIP001 		Rectangle aRect( aPos, aPos );
//STRIP001 
//STRIP001 		USHORT nAlign = QUICKHELP_LEFT|QUICKHELP_BOTTOM;
//STRIP001 		nTipVisible = Help::ShowTip(pWin, aRect, rText, nAlign);
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScInputHandler::UseFormulaData()
//STRIP001 {
//STRIP001 	EditView* pActiveView = pTopView ? pTopView : pTableView;
//STRIP001 
//STRIP001 	//	Formeln duerfen nur 1 Absatz haben
//STRIP001 	if ( pActiveView && pFormulaData && pEngine->GetParagraphCount() == 1 )
//STRIP001 	{
//STRIP001 		String aTotal = pEngine->GetText( (USHORT) 0 );
//STRIP001 		ESelection aSel = pActiveView->GetSelection();
//STRIP001 		aSel.Adjust();
//STRIP001 
//STRIP001 		//	#59348# Durch Differenzen zwischen Tabelle und Eingabezeile
//STRIP001 		//	(z.B. Clipboard mit Zeilenumbruechen) kann es sein, dass die Selektion
//STRIP001 		//	nicht mehr zur EditEngine passt. Dann halt kommentarlos abbrechen:
//STRIP001 
//STRIP001 		if ( aSel.nEndPos > aTotal.Len() )
//STRIP001 			return;
//STRIP001 
//STRIP001 		//	steht der Cursor am Ende eines Wortes?
//STRIP001 
//STRIP001 		if ( aSel.nEndPos > 0 && (
//STRIP001 				aSel.nEndPos == aTotal.Len() ||
//STRIP001 				pEngine->GetWordDelimiters().Search( aTotal.GetChar(aSel.nEndPos) ) != STRING_NOTFOUND ) )
//STRIP001 		{
//STRIP001 			String aText = pEngine->GetWord( 0, aSel.nEndPos-1 );
//STRIP001 			if (aText.Len())
//STRIP001 			{
//STRIP001 				String aNew;
//STRIP001 				nAutoPos = SCPOS_INVALID;	// nix
//STRIP001 				if ( pFormulaData->FindText( aText, aNew, nAutoPos, FALSE ) )
//STRIP001 				{
//STRIP001 					ShowTip( aNew );		//	als QuickHelp anzeigen
//STRIP001 					aAutoSearch = aText;	// zum Weitersuchen - nAutoPos ist gesetzt
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScInputHandler::NextFormulaEntry( BOOL bBack )
//STRIP001 {
//STRIP001 	EditView* pActiveView = pTopView ? pTopView : pTableView;
//STRIP001 	if ( pActiveView && pFormulaData )
//STRIP001 	{
//STRIP001 		String aNew;
//STRIP001 		if ( pFormulaData->FindText( aAutoSearch, aNew, nAutoPos, bBack ) )
//STRIP001 			ShowTip( aNew );		//	als QuickHelp anzeigen
//STRIP001 	}
//STRIP001 
//STRIP001 	//	bei Tab wird vorher immer HideCursor gerufen
//STRIP001 
//STRIP001 	if (pActiveView)
//STRIP001 		pActiveView->ShowCursor();
//STRIP001 }

//STRIP001 void lcl_CompleteFunction( EditView* pView, const String& rInsert, BOOL& rParInserted )
//STRIP001 {
//STRIP001 	if (pView)
//STRIP001 	{
//STRIP001 		ESelection aSel = pView->GetSelection();
//STRIP001 		--aSel.nStartPos;
//STRIP001 		--aSel.nEndPos;
//STRIP001 		pView->SetSelection(aSel);
//STRIP001 		pView->SelectCurrentWord();
//STRIP001 
//STRIP001 		String aInsStr = rInsert;
//STRIP001 		xub_StrLen nInsLen = aInsStr.Len();
//STRIP001 		BOOL bDoParen = ( nInsLen > 1 && aInsStr.GetChar(nInsLen-2) == '('
//STRIP001 									  && aInsStr.GetChar(nInsLen-1) == ')' );
//STRIP001 		if ( bDoParen )
//STRIP001 		{
//STRIP001 			//	Klammern hinter Funktionsnamen nicht einfuegen, wenn direkt dahinter
//STRIP001 			//	schon eine Klammer steht (z.B. wenn der Funktionsname geaendert wurde,
//STRIP001 			//	#39393#).
//STRIP001 
//STRIP001 			ESelection aWordSel = pView->GetSelection();
//STRIP001 			String aOld = pView->GetEditEngine()->GetText((USHORT)0);
//STRIP001 			sal_Unicode cNext = aOld.GetChar(aWordSel.nEndPos);
//STRIP001 			if ( cNext == '(' )
//STRIP001 			{
//STRIP001 				bDoParen = FALSE;
//STRIP001 				aInsStr.Erase( nInsLen - 2 );	// Klammern weglassen
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		pView->InsertText( aInsStr, FALSE );
//STRIP001 
//STRIP001 		if ( bDoParen )							// Cursor zwischen die Klammern setzen
//STRIP001 		{
//STRIP001 			aSel = pView->GetSelection();
//STRIP001 			--aSel.nStartPos;
//STRIP001 			--aSel.nEndPos;
//STRIP001 			pView->SetSelection(aSel);
//STRIP001 
//STRIP001 			rParInserted = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScInputHandler::PasteFunctionData()
//STRIP001 {
//STRIP001 	if ( pFormulaData && nAutoPos != SCPOS_INVALID )
//STRIP001 	{
//STRIP001 		TypedStrData* pData = (*pFormulaData)[nAutoPos];
//STRIP001 		if (pData)
//STRIP001 		{
//STRIP001 			String aInsert = pData->GetString();
//STRIP001 			BOOL bParInserted = FALSE;
//STRIP001 
//STRIP001 			DataChanging(); 						// kann nicht neu sein
//STRIP001 			lcl_CompleteFunction( pTopView, aInsert, bParInserted );
//STRIP001 			lcl_CompleteFunction( pTableView, aInsert, bParInserted );
//STRIP001 			DataChanged();
//STRIP001 
//STRIP001 			if (bParInserted)
//STRIP001 				AutoParAdded();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	HideTip();
//STRIP001 
//STRIP001 	EditView* pActiveView = pTopView ? pTopView : pTableView;
//STRIP001 	if (pActiveView)
//STRIP001 		pActiveView->ShowCursor();
//STRIP001 }

//
//		Selektion berechnen und als Tip-Hilfe anzeigen
//

//STRIP001 String lcl_Calculate( const String& rFormula, ScDocument* pDoc, const ScAddress &rPos )
//STRIP001 {
//STRIP001 	//!		mit ScFormulaDlg::CalcValue zusammenfassen und ans Dokument verschieben !!!!
//STRIP001 	//!		(Anfuehrungszeichen bei Strings werden nur hier eingefuegt)
//STRIP001 
//STRIP001 	String aValue;
//STRIP001 
//STRIP001 	if (rFormula.Len())
//STRIP001 	{
//STRIP001 		ScFormulaCell* pCell = new ScFormulaCell( pDoc, rPos, rFormula );
//STRIP001 
//STRIP001 		// #35521# HACK! um bei ColRowNames kein #REF! zu bekommen,
//STRIP001 		// wenn ein Name eigentlich als Bereich in die Gesamt-Formel
//STRIP001 		// eingefuegt wird, bei der Einzeldarstellung aber als
//STRIP001 		// single-Zellbezug interpretiert wird
//STRIP001 		BOOL bColRowName = pCell->HasColRowName();
//STRIP001 		if ( bColRowName )
//STRIP001 		{
//STRIP001 			// ColRowName im RPN-Code?
//STRIP001 			if ( pCell->GetCode()->GetCodeLen() <= 1 )
//STRIP001 			{	// ==1: einzelner ist als Parameter immer Bereich
//STRIP001 				// ==0: es waere vielleicht einer, wenn..
//STRIP001 				String aBraced( '(' );
//STRIP001 				aBraced += rFormula;
//STRIP001 				aBraced += ')';
//STRIP001 				delete pCell;
//STRIP001 				pCell = new ScFormulaCell( pDoc, rPos, aBraced );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				bColRowName = FALSE;
//STRIP001 		}
//STRIP001 
//STRIP001 		USHORT nErrCode = pCell->GetErrCode();
//STRIP001 		if ( nErrCode == 0 )
//STRIP001 		{
//STRIP001 			SvNumberFormatter& aFormatter = *(pDoc->GetFormatTable());
//STRIP001 			Color* pColor;
//STRIP001 			if ( pCell->IsValue() )
//STRIP001 			{
//STRIP001 				double n = pCell->GetValue();
//STRIP001 				ULONG nFormat = aFormatter.GetStandardFormat( n, 0,
//STRIP001 								pCell->GetFormatType(), ScGlobal::eLnge );
//STRIP001 				aFormatter.GetInputLineString( n, nFormat, aValue );
//STRIP001 				//!	display OutputString but insert InputLineString
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				String aStr;
//STRIP001 
//STRIP001 				pCell->GetString( aStr );
//STRIP001 				ULONG nFormat = aFormatter.GetStandardFormat(
//STRIP001 								pCell->GetFormatType(), ScGlobal::eLnge);
//STRIP001 				aFormatter.GetOutputString( aStr, nFormat,
//STRIP001 											aValue, &pColor );
//STRIP001 
//STRIP001 				aValue.Insert('"',0);	// in Anfuehrungszeichen
//STRIP001 				aValue+='"';
//STRIP001 				//!	Anfuehrungszeichen im String escapen ????
//STRIP001 			}
//STRIP001 
//STRIP001 			ScRange aTestRange;
//STRIP001 			if ( bColRowName || (aTestRange.Parse(rFormula) & SCA_VALID) )
//STRIP001 				aValue.AppendAscii(RTL_CONSTASCII_STRINGPARAM( " ..." ));		// Bereich
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aValue = ScGlobal::GetErrorString(nErrCode);
//STRIP001 		delete pCell;
//STRIP001 	}
//STRIP001 
//STRIP001 	return aValue;
//STRIP001 }

//STRIP001 void ScInputHandler::FormulaPreview()
//STRIP001 {
//STRIP001 	String aValue;
//STRIP001 	EditView* pActiveView = pTopView ? pTopView : pTableView;
//STRIP001 	if ( pActiveView && pActiveViewSh )
//STRIP001 	{
//STRIP001 		String aPart = pActiveView->GetSelected();
//STRIP001 		if (!aPart.Len())
//STRIP001 			aPart = pEngine->GetText((USHORT)0);
//STRIP001 		ScDocument* pDoc = pActiveViewSh->GetViewData()->GetDocShell()->GetDocument();
//STRIP001 		aValue = lcl_Calculate( aPart, pDoc, aCursorPos );
//STRIP001 	}
//STRIP001 
//STRIP001 	if (aValue.Len())
//STRIP001 	{
//STRIP001 		ShowTip( aValue );			//	als QuickHelp anzeigen
//STRIP001 		aManualTip = aValue;		//	nach ShowTip setzen
//STRIP001 		nAutoPos = SCPOS_INVALID;	//	Formel-Autocomplete aufheben
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScInputHandler::PasteManualTip()
//STRIP001 {
//STRIP001 	//	drei Punkte am Ende -> Bereichsreferenz -> nicht einfuegen
//STRIP001 	//	(wenn wir mal Matrix-Konstanten haben, kann das geaendert werden)
//STRIP001 
//STRIP001 	xub_StrLen nTipLen = aManualTip.Len();
//STRIP001 	if ( nTipLen && ( nTipLen < 3 || !aManualTip.Copy( nTipLen-3 ).EqualsAscii("...") ) )
//STRIP001 	{
//STRIP001 		DataChanging(); 									// kann nicht neu sein
//STRIP001 
//STRIP001 		String aInsert = aManualTip;
//STRIP001 		EditView* pActiveView = pTopView ? pTopView : pTableView;
//STRIP001 		if (!pActiveView->HasSelection())
//STRIP001 		{
//STRIP001 			//	nichts selektiert -> alles selektieren
//STRIP001 			xub_StrLen nOldLen = pEngine->GetTextLen(0);
//STRIP001 			ESelection aAllSel( 0, 0, 0, nOldLen );
//STRIP001 			if ( pTopView )
//STRIP001 				pTopView->SetSelection( aAllSel );
//STRIP001 			if ( pTableView )
//STRIP001 				pTableView->SetSelection( aAllSel );
//STRIP001 		}
//STRIP001 
//STRIP001 		ESelection aSel = pActiveView->GetSelection();
//STRIP001 		aSel.Adjust();
//STRIP001 		DBG_ASSERT( !aSel.nStartPara && !aSel.nEndPara, "Zuviele Absaetze in Formel" );
//STRIP001 		if ( !aSel.nStartPos )	// Selektion ab Anfang?
//STRIP001 		{
//STRIP001 			if ( aSel.nEndPos == pEngine->GetTextLen(0) )
//STRIP001 			{
//STRIP001 				//	alles selektiert -> Anfuehrungszeichen weglassen
//STRIP001 				if ( aInsert.GetChar(0) == '"' )
//STRIP001 					aInsert.Erase(0,1);
//STRIP001 				xub_StrLen nInsLen = aInsert.Len();
//STRIP001 				if ( nInsLen && aInsert.GetChar(nInsLen-1) == '"' )
//STRIP001 					aInsert.Erase( nInsLen-1 );
//STRIP001 			}
//STRIP001 			else if ( aSel.nEndPos )
//STRIP001 			{
//STRIP001 				//	nicht alles selektiert -> Gleichheitszeichen nicht ueberschreiben
//STRIP001 				//!	doppelte Gleichheitszeichen auch ???
//STRIP001 
//STRIP001 				aSel.nStartPos = 1;
//STRIP001 				if ( pTopView )
//STRIP001 					pTopView->SetSelection( aSel );
//STRIP001 				if ( pTableView )
//STRIP001 					pTableView->SetSelection( aSel );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if ( pTopView )
//STRIP001 			pTopView->InsertText( aInsert, TRUE );
//STRIP001 		if ( pTableView )
//STRIP001 			pTableView->InsertText( aInsert, TRUE );
//STRIP001 
//STRIP001 		DataChanged();
//STRIP001 	}
//STRIP001 
//STRIP001 	HideTip();
//STRIP001 }

/*N*/ void ScInputHandler::ResetAutoPar()
/*N*/ {
/*N*/ 	nAutoPar = 0;
/*N*/ }

//STRIP001 void ScInputHandler::AutoParAdded()
//STRIP001 {
//STRIP001 	++nAutoPar;		//	closing parenthesis can be overwritten
//STRIP001 }

//STRIP001 BOOL ScInputHandler::CursorAtClosingPar()
//STRIP001 {
//STRIP001 	//	test if the cursor is before a closing parenthesis
//STRIP001 
//STRIP001 	//	selection from SetReference has been removed before
//STRIP001 	EditView* pActiveView = pTopView ? pTopView : pTableView;
//STRIP001 	if ( pActiveView && !pActiveView->HasSelection() && bFormulaMode )
//STRIP001 	{
//STRIP001 		ESelection aSel = pActiveView->GetSelection();
//STRIP001 		xub_StrLen nPos = aSel.nStartPos;
//STRIP001 		String aFormula = pEngine->GetText((USHORT)0);
//STRIP001 		if ( nPos < aFormula.Len() && aFormula.GetChar(nPos) == ')' )
//STRIP001 			return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 void ScInputHandler::SkipClosingPar()
//STRIP001 {
//STRIP001 	//	this is called when a ')' is typed and the cursor is before a ')'
//STRIP001 	//	that can be overwritten -> just set the cursor behind the ')'
//STRIP001 
//STRIP001 	EditView* pActiveView = pTopView ? pTopView : pTableView;
//STRIP001 	if (pActiveView)
//STRIP001 	{
//STRIP001 		ESelection aSel = pActiveView->GetSelection();
//STRIP001 		++aSel.nStartPos;
//STRIP001 		++aSel.nEndPos;
//STRIP001 
//STRIP001 		//	this is in a formula (only one paragraph), so the selection
//STRIP001 		//	can be used directly for the TopView
//STRIP001 
//STRIP001 		if ( pTopView )
//STRIP001 			pTopView->SetSelection( aSel );
//STRIP001 		if ( pTableView )
//STRIP001 			pTableView->SetSelection( aSel );
//STRIP001 	}
//STRIP001 
//STRIP001 	DBG_ASSERT(nAutoPar, "SkipClosingPar: count is wrong");
//STRIP001 	--nAutoPar;
//STRIP001 }

//
//		Auto-Eingabe
//

//STRIP001 void ScInputHandler::GetColData()
//STRIP001 {
//STRIP001 	if ( pActiveViewSh )
//STRIP001 	{
//STRIP001 		ScDocument* pDoc = pActiveViewSh->GetViewData()->GetDocShell()->GetDocument();
//STRIP001 
//STRIP001 		if ( pColumnData )
//STRIP001 			pColumnData->FreeAll();
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pColumnData = new TypedStrCollection;
//STRIP001 			pColumnData->SetCaseSensitive( TRUE );		// equal strings are handled in FindText
//STRIP001 		}
//STRIP001 
//STRIP001 		pDoc->GetDataEntries( aCursorPos.Col(), aCursorPos.Row(), aCursorPos.Tab(),
//STRIP001 								*pColumnData, TRUE );
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScInputHandler::UseColData()			// beim Tippen
//STRIP001 {
//STRIP001 	EditView* pActiveView = pTopView ? pTopView : pTableView;
//STRIP001 	if ( pActiveView && pColumnData )
//STRIP001 	{
//STRIP001 		//	nur anpassen, wenn Cursor am Ende steht
//STRIP001 
//STRIP001 		ESelection aSel = pActiveView->GetSelection();
//STRIP001 		aSel.Adjust();
//STRIP001 
//STRIP001 		USHORT nParCnt = pEngine->GetParagraphCount();
//STRIP001 		if ( aSel.nEndPara+1 == nParCnt )
//STRIP001 		{
//STRIP001 			xub_StrLen nParLen = pEngine->GetTextLen( aSel.nEndPara );
//STRIP001 			if ( aSel.nEndPos == nParLen )
//STRIP001 			{
//STRIP001 				String aText = GetEditText(pEngine);
//STRIP001 				if (aText.Len())
//STRIP001 				{
//STRIP001 					String aNew;
//STRIP001 					nAutoPos = SCPOS_INVALID;	// nix
//STRIP001 					if ( pColumnData->FindText( aText, aNew, nAutoPos, FALSE ) )
//STRIP001 					{
//STRIP001 						//	#45434# durch dBase Import etc. koennen Umbrueche im String sein,
//STRIP001 						//	das wuerde hier mehrere Absaetze ergeben -> nicht gut
//STRIP001 						//!	GetExactMatch funktioniert dann auch nicht
//STRIP001 						lcl_RemoveLineEnd( aNew );
//STRIP001 
//STRIP001 						//	Absaetze beibehalten, nur den Rest anfgen
//STRIP001 						//!	genaue Ersetzung im EnterHandler !!!
//STRIP001 
//STRIP001 						// ein Space zwischen Absaetzen:
//STRIP001 						ULONG nEdLen = pEngine->GetTextLen() + nParCnt - 1;
//STRIP001 						String aIns = aNew.Copy( (xub_StrLen)nEdLen );
//STRIP001 
//STRIP001 						//	selection must be "backwards", so the cursor stays behind the last
//STRIP001 						//	typed character
//STRIP001 						ESelection aSelection( aSel.nEndPara, aSel.nEndPos + aIns.Len(),
//STRIP001 											   aSel.nEndPara, aSel.nEndPos );
//STRIP001 
//STRIP001 						//	when editing in input line, apply to both edit views
//STRIP001 						if ( pTableView )
//STRIP001 						{
//STRIP001 							pTableView->InsertText( aIns, FALSE );
//STRIP001 							pTableView->SetSelection( aSelection );
//STRIP001 						}
//STRIP001 						if ( pTopView )
//STRIP001 						{
//STRIP001 							pTopView->InsertText( aIns, FALSE );
//STRIP001 							pTopView->SetSelection( aSelection );
//STRIP001 						}
//STRIP001 
//STRIP001 						aAutoSearch = aText;	// zum Weitersuchen - nAutoPos ist gesetzt
//STRIP001 
//STRIP001 						if ( aText.Len() == aNew.Len() )
//STRIP001 						{
//STRIP001 							//	Wenn der eingegebene Text gefunden wurde, TAB nur dann
//STRIP001 							//	verschlucken, wenn noch etwas kommt
//STRIP001 
//STRIP001 							String aDummy;
//STRIP001 							USHORT nNextPos = nAutoPos;
//STRIP001 							bUseTab = pColumnData->FindText( aText, aDummy, nNextPos, FALSE );
//STRIP001 						}
//STRIP001 						else
//STRIP001 							bUseTab = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScInputHandler::NextAutoEntry( BOOL bBack )
//STRIP001 {
//STRIP001 	EditView* pActiveView = pTopView ? pTopView : pTableView;
//STRIP001 	if ( pActiveView && pColumnData )
//STRIP001 	{
//STRIP001 		if ( nAutoPos != SCPOS_INVALID && aAutoSearch.Len() )
//STRIP001 		{
//STRIP001 			//	stimmt die Selektion noch? (kann per Maus geaendert sein)
//STRIP001 
//STRIP001 			ESelection aSel = pActiveView->GetSelection();
//STRIP001 			aSel.Adjust();
//STRIP001 			USHORT nParCnt = pEngine->GetParagraphCount();
//STRIP001 			if ( aSel.nEndPara+1 == nParCnt && aSel.nStartPara == aSel.nEndPara )
//STRIP001 			{
//STRIP001 				String aText = GetEditText(pEngine);
//STRIP001 				xub_StrLen nSelLen = aSel.nEndPos - aSel.nStartPos;
//STRIP001 				xub_StrLen nParLen = pEngine->GetTextLen( aSel.nEndPara );
//STRIP001 				if ( aSel.nEndPos == nParLen && aText.Len() == aAutoSearch.Len() + nSelLen )
//STRIP001 				{
//STRIP001 					String aNew;
//STRIP001 					if ( pColumnData->FindText( aAutoSearch, aNew, nAutoPos, bBack ) )
//STRIP001 					{
//STRIP001 						bInOwnChange = TRUE;		// disable ModifyHdl (reset below)
//STRIP001 
//STRIP001 						lcl_RemoveLineEnd( aNew );
//STRIP001 						String aIns = aNew.Copy( aAutoSearch.Len() );
//STRIP001 
//STRIP001 						//	when editing in input line, apply to both edit views
//STRIP001 						if ( pTableView )
//STRIP001 						{
//STRIP001 							pTableView->DeleteSelected();
//STRIP001 							pTableView->InsertText( aIns, FALSE );
//STRIP001 							pTableView->SetSelection( ESelection(
//STRIP001 														aSel.nEndPara, aSel.nStartPos + aIns.Len(),
//STRIP001 														aSel.nEndPara, aSel.nStartPos ) );
//STRIP001 						}
//STRIP001 						if ( pTopView )
//STRIP001 						{
//STRIP001 							pTopView->DeleteSelected();
//STRIP001 							pTopView->InsertText( aIns, FALSE );
//STRIP001 							pTopView->SetSelection( ESelection(
//STRIP001 														aSel.nEndPara, aSel.nStartPos + aIns.Len(),
//STRIP001 														aSel.nEndPara, aSel.nStartPos ) );
//STRIP001 						}
//STRIP001 
//STRIP001 						bInOwnChange = FALSE;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						// mehr gibts nicht
//STRIP001 
//STRIP001 						Sound::Beep();
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//	bei Tab wird vorher immer HideCursor gerufen
//STRIP001 
//STRIP001 	if (pActiveView)
//STRIP001 		pActiveView->ShowCursor();
//STRIP001 }

//
//		Klammern hervorheben
//

//STRIP001 xub_StrLen lcl_MatchParenthesis( const String& rStr, xub_StrLen nPos )
//STRIP001 {
//STRIP001 	int nDir;
//STRIP001 	sal_Unicode c1, c2;
//STRIP001 	c1 = rStr.GetChar( nPos );
//STRIP001 	switch ( c1 )
//STRIP001 	{
//STRIP001 		case '(' :
//STRIP001 			c2 = ')';
//STRIP001 			nDir = 1;
//STRIP001 		break;
//STRIP001 		case ')' :
//STRIP001 			c2 = '(';
//STRIP001 			nDir = -1;
//STRIP001 		break;
//STRIP001 		case '<' :
//STRIP001 			c2 = '>';
//STRIP001 			nDir = 1;
//STRIP001 		break;
//STRIP001 		case '>' :
//STRIP001 			c2 = '<';
//STRIP001 			nDir = -1;
//STRIP001 		break;
//STRIP001 		case '{' :
//STRIP001 			c2 = '}';
//STRIP001 			nDir = 1;
//STRIP001 		break;
//STRIP001 		case '}' :
//STRIP001 			c2 = '{';
//STRIP001 			nDir = -1;
//STRIP001 		break;
//STRIP001 		case '[' :
//STRIP001 			c2 = ']';
//STRIP001 			nDir = 1;
//STRIP001 		break;
//STRIP001 		case ']' :
//STRIP001 			c2 = '[';
//STRIP001 			nDir = -1;
//STRIP001 		break;
//STRIP001 		default:
//STRIP001 			nDir = 0;
//STRIP001 	}
//STRIP001 	if ( !nDir )
//STRIP001 		return STRING_NOTFOUND;
//STRIP001 	xub_StrLen nLen = rStr.Len();
//STRIP001 	const sal_Unicode* p0 = rStr.GetBuffer();
//STRIP001 	register const sal_Unicode* p;
//STRIP001 	const sal_Unicode* p1;
//STRIP001 	USHORT nQuotes = 0;
//STRIP001 	if ( nPos < nLen / 2 )
//STRIP001 	{
//STRIP001 		p = p0;
//STRIP001 		p1 = p0 + nPos;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		p = p0 + nPos;
//STRIP001 		p1 = p0 + nLen;
//STRIP001 	}
//STRIP001 	while ( p < p1 )
//STRIP001 	{
//STRIP001 		if ( *p++ == '\"' )
//STRIP001 			nQuotes++;
//STRIP001 	}
//STRIP001 	// ungerade Anzahl Quotes: wir befinden uns in einem String
//STRIP001 	BOOL bLookInString = ((nQuotes % 2) != 0);
//STRIP001 	BOOL bInString = bLookInString;
//STRIP001 	p = p0 + nPos;
//STRIP001 	p1 = (nDir < 0 ? p0 : p0 + nLen) ;
//STRIP001 	USHORT nLevel = 1;
//STRIP001 	while ( p != p1 && nLevel )
//STRIP001 	{
//STRIP001 		p += nDir;
//STRIP001 		if ( *p == '\"' )
//STRIP001 		{
//STRIP001 			bInString = !bInString;
//STRIP001 			if ( bLookInString && !bInString )
//STRIP001 				p = p1;		// das war's dann
//STRIP001 		}
//STRIP001 		else if ( bInString == bLookInString )
//STRIP001 		{
//STRIP001 			if ( *p == c1 )
//STRIP001 				nLevel++;
//STRIP001 			else if ( *p == c2 )
//STRIP001 				nLevel--;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if ( nLevel )
//STRIP001 		return STRING_NOTFOUND;
//STRIP001 	return (xub_StrLen) (p - p0);
//STRIP001 }

//STRIP001 void ScInputHandler::UpdateParenthesis()
//STRIP001 {
//STRIP001 	//	Klammern suchen
//STRIP001 
//STRIP001 	//!	Klammer-Hervorhebung einzeln abschaltbar ????
//STRIP001 
//STRIP001 	BOOL bFound = FALSE;
//STRIP001 	if ( bFormulaMode && eMode != SC_INPUT_TOP )
//STRIP001 	{
//STRIP001 		if ( pTableView && !pTableView->HasSelection() )		// Selektion ist immer unten
//STRIP001 		{
//STRIP001 			ESelection aSel = pTableView->GetSelection();
//STRIP001 			if (aSel.nStartPos)
//STRIP001 			{
//STRIP001 				//	Das Zeichen links vom Cursor wird angeschaut
//STRIP001 
//STRIP001 				xub_StrLen nPos = aSel.nStartPos - 1;
//STRIP001 				String aFormula = pEngine->GetText((USHORT)0);
//STRIP001 				sal_Unicode c = aFormula.GetChar(nPos);
//STRIP001 				if ( c == '(' || c == ')' )
//STRIP001 				{
//STRIP001 					xub_StrLen nOther = lcl_MatchParenthesis( aFormula, nPos );
//STRIP001 					if ( nOther != STRING_NOTFOUND )
//STRIP001 					{
//STRIP001 						SfxItemSet aSet( pEngine->GetEmptyItemSet() );
//STRIP001 						aSet.Put( SvxWeightItem( WEIGHT_BOLD, EE_CHAR_WEIGHT ) );
//STRIP001 						//!	Unterscheidung, wenn die Zelle schon fett ist !!!!
//STRIP001 
//STRIP001 						if (bParenthesisShown)
//STRIP001 						{
//STRIP001 							//	alte Hervorhebung wegnehmen
//STRIP001 							USHORT nCount = pEngine->GetParagraphCount();
//STRIP001 							for (USHORT i=0; i<nCount; i++)
//STRIP001 								pEngine->QuickRemoveCharAttribs( i, EE_CHAR_WEIGHT );
//STRIP001 						}
//STRIP001 
//STRIP001 						ESelection aSelThis( 0,nPos, 0,nPos+1 );
//STRIP001 						pEngine->QuickSetAttribs( aSet, aSelThis );
//STRIP001 						ESelection aSelOther( 0,nOther, 0,nOther+1 );
//STRIP001 						pEngine->QuickSetAttribs( aSet, aSelOther );
//STRIP001 
//STRIP001 						//	Dummy-InsertText fuer Update und Paint (Selektion ist leer)
//STRIP001 						pTableView->InsertText( EMPTY_STRING, FALSE );
//STRIP001 
//STRIP001 						bFound = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			//	mark parenthesis right of cursor if it will be overwritten (nAutoPar)
//STRIP001 			//	with different color (COL_LIGHTBLUE) ??
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//	alte Hervorhebung wegnehmen, wenn keine neue gesetzt
//STRIP001 
//STRIP001 	if ( bParenthesisShown && !bFound && pTableView )
//STRIP001 	{
//STRIP001 		USHORT nCount = pEngine->GetParagraphCount();
//STRIP001 		for (USHORT i=0; i<nCount; i++)
//STRIP001 			pTableView->RemoveCharAttribs( i, EE_CHAR_WEIGHT );
//STRIP001 	}
//STRIP001 
//STRIP001 	bParenthesisShown = bFound;
//STRIP001 }

//STRIP001 void ScInputHandler::ViewShellGone(ScTabViewShell* pViewSh) 	// wird synchron aufgerufen!
//STRIP001 {
//STRIP001 	if ( pViewSh == pActiveViewSh )
//STRIP001 	{
//STRIP001 		delete pLastState;
//STRIP001 		pLastState = NULL;
//STRIP001 		pLastPattern = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pViewSh == pRefViewSh )
//STRIP001 	{
//STRIP001 		//! Die Eingabe kommt aus dem EnterHandler nicht mehr an
//STRIP001 		//	Trotzdem wird immerhin der Editmodus beendet
//STRIP001 
//STRIP001 		EnterHandler();
//STRIP001 		bFormulaMode = FALSE;
//STRIP001 		pRefViewSh = NULL;
//STRIP001 		SFX_APP()->Broadcast( SfxSimpleHint( FID_REFMODECHANGED ) );
//STRIP001 		SC_MOD()->SetRefInputHdl(NULL);
//STRIP001 		if (pInputWin)
//STRIP001 			pInputWin->SetFormulaMode(FALSE);
//STRIP001 		UpdateAutoCorrFlag();
//STRIP001 	}
//STRIP001 
//STRIP001 	pActiveViewSh = PTR_CAST( ScTabViewShell, SfxViewShell::Current() );
//STRIP001 
//STRIP001 	if ( pActiveViewSh && pActiveViewSh == pViewSh )
//STRIP001 	{
//STRIP001 		DBG_ERROR("pActiveViewSh weg");
//STRIP001 		pActiveViewSh = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( SC_MOD()->GetInputOptions().GetTextWysiwyg() )
//STRIP001 		UpdateRefDevice();		// don't keep old document's printer as RefDevice
//STRIP001 }

//STRIP001 void ScInputHandler::UpdateActiveView()
//STRIP001 {
//STRIP001 	ImplCreateEditEngine();
//STRIP001 	Window* pShellWin = pActiveViewSh ? pActiveViewSh->GetActiveWin() : NULL;
//STRIP001 
//STRIP001 	USHORT nCount = pEngine->GetViewCount();
//STRIP001 	if (nCount > 0)
//STRIP001 	{
//STRIP001 		pTableView = pEngine->GetView(0);
//STRIP001 		for (USHORT i=1; i<nCount; i++)
//STRIP001 		{
//STRIP001 			EditView* pThis = pEngine->GetView(i);
//STRIP001 			Window* pWin = pThis->GetWindow();
//STRIP001 			if ( pWin==pShellWin || pWin->HasFocus() )
//STRIP001 				pTableView = pThis;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pTableView = NULL;
//STRIP001 
//STRIP001 	if (pInputWin)
//STRIP001 		pTopView = pInputWin->GetEditView();
//STRIP001 	else
//STRIP001 		pTopView = NULL;
//STRIP001 }

/*N*/ void ScInputHandler::StopInputWinEngine( BOOL bAll )
/*N*/ {
/*N*/ 	if (pInputWin)
		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		pInputWin->StopEditEngine( bAll );
/*N*/ 
/*N*/ 	pTopView = NULL;		// invalid now
/*N*/ }

//STRIP001 void ScInputHandler::ActivateInputWindow( const String&     rText,
//STRIP001 										  const ESelection& rSel )
//STRIP001 {
//STRIP001 	if ( pInputWin )
//STRIP001 		if ( !pInputWin->IsActive() )
//STRIP001 			pTopView = pInputWin->ActivateEdit( rText, rSel );
//STRIP001 }

//STRIP001 EditView* ScInputHandler::GetActiveView()
//STRIP001 {
//STRIP001 	UpdateActiveView();
//STRIP001 	return pTopView ? pTopView : pTableView;
//STRIP001 }

//STRIP001 void ScInputHandler::ForgetLastPattern()
//STRIP001 {
//STRIP001 	pLastPattern = NULL;
//STRIP001 	if ( !pLastState && pActiveViewSh )
//STRIP001 		pActiveViewSh->UpdateInputHandler( TRUE );		// Status neu holen
//STRIP001 	else
//STRIP001 		NotifyChange( pLastState, TRUE );
//STRIP001 }

//STRIP001 void ScInputHandler::UpdateAdjust( sal_Unicode cTyped )
//STRIP001 {
//STRIP001 	SvxAdjust eSvxAdjust;
//STRIP001 	switch (nAttrAdjust)
//STRIP001 	{
//STRIP001 		case SVX_HOR_JUSTIFY_STANDARD:
//STRIP001 			{
//STRIP001 				BOOL bNumber = FALSE;
//STRIP001 				if (cTyped)										// neu angefangen
//STRIP001 					bNumber = (cTyped>='0' && cTyped<='9');		// nur Ziffern sind Zahlen
//STRIP001 				else if ( pActiveViewSh )
//STRIP001 				{
//STRIP001 					ScDocument* pDoc = pActiveViewSh->GetViewData()->GetDocShell()->GetDocument();
//STRIP001 					bNumber = ( pDoc->GetCellType( aCursorPos ) == CELLTYPE_VALUE );
//STRIP001 				}
//STRIP001 				eSvxAdjust = bNumber ? SVX_ADJUST_RIGHT : SVX_ADJUST_LEFT;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case SVX_HOR_JUSTIFY_BLOCK:
//STRIP001 			eSvxAdjust = SVX_ADJUST_BLOCK;
//STRIP001 			break;
//STRIP001 		case SVX_HOR_JUSTIFY_CENTER:
//STRIP001 			eSvxAdjust = SVX_ADJUST_CENTER;
//STRIP001 			break;
//STRIP001 		case SVX_HOR_JUSTIFY_RIGHT:
//STRIP001 			eSvxAdjust = SVX_ADJUST_RIGHT;
//STRIP001 			break;
//STRIP001 		default:	// SVX_HOR_JUSTIFY_LEFT
//STRIP001 			eSvxAdjust = SVX_ADJUST_LEFT;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bAsianVertical = pLastPattern &&
//STRIP001 		(SvxCellOrientation)((const SvxOrientationItem&)
//STRIP001 			pLastPattern->GetItem(ATTR_ORIENTATION)).GetValue() == SVX_ORIENTATION_STACKED &&
//STRIP001 		((const SfxBoolItem&)pLastPattern->GetItem( ATTR_VERTICAL_ASIAN )).GetValue();
//STRIP001 	if ( bAsianVertical )
//STRIP001 	{
//STRIP001 		//	always edit at top of cell -> LEFT when editing vertically
//STRIP001 		eSvxAdjust = SVX_ADJUST_LEFT;
//STRIP001 	}
//STRIP001 
//STRIP001 	pEditDefaults->Put( SvxAdjustItem( eSvxAdjust, EE_PARA_JUST ) );
//STRIP001 	pEngine->SetDefaults( *pEditDefaults );
//STRIP001 
//STRIP001 	nEditAdjust = eSvxAdjust;		//! an ViewData setzen oder beim PostEditView
//STRIP001 
//STRIP001 	pEngine->SetVertical( bAsianVertical );
//STRIP001 }

//STRIP001 void ScInputHandler::RemoveAdjust()
//STRIP001 {
//STRIP001 	//	harte Ausrichtungs-Attribute loeschen
//STRIP001 
//STRIP001 	BOOL bUndo = pEngine->IsUndoEnabled();
//STRIP001 	if ( bUndo )
//STRIP001 		pEngine->EnableUndo( FALSE );
//STRIP001 
//STRIP001 	//	RemoveParaAttribs removes all paragraph attributes, including EE_PARA_JUST
//STRIP001 #if 0
//STRIP001 	BOOL bChange = FALSE;
//STRIP001 	USHORT nCount = pEngine->GetParagraphCount();
//STRIP001 	for (USHORT i=0; i<nCount; i++)
//STRIP001 	{
//STRIP001 		const SfxItemSet& rOld = pEngine->GetParaAttribs( i );
//STRIP001 		if ( rOld.GetItemState( EE_PARA_JUST ) == SFX_ITEM_SET )
//STRIP001 		{
//STRIP001 			SfxItemSet aNew( rOld );
//STRIP001 			aNew.ClearItem( EE_PARA_JUST );
//STRIP001 			pEngine->SetParaAttribs( i, aNew );
//STRIP001 			bChange = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 #endif
//STRIP001 
//STRIP001 	//	#89403# non-default paragraph attributes (e.g. from clipboard)
//STRIP001 	//	must be turned into character attributes
//STRIP001 	pEngine->RemoveParaAttribs();
//STRIP001 
//STRIP001 	if ( bUndo )
//STRIP001 		pEngine->EnableUndo( TRUE );
//STRIP001 
//STRIP001 	// ER 31.08.00  Only called in EnterHandler, don't change view anymore.
//STRIP001 #if 0
//STRIP001 	if (bChange)
//STRIP001 	{
//STRIP001 		EditView* pActiveView = pTopView ? pTopView : pTableView;
//STRIP001 		pActiveView->ShowCursor( FALSE, TRUE );
//STRIP001 	}
//STRIP001 #endif
//STRIP001 }

//STRIP001 void ScInputHandler::RemoveRangeFinder()
//STRIP001 {
//STRIP001 	//	pRangeFindList und Farben loeschen
//STRIP001 
//STRIP001 	pEngine->SetUpdateMode(FALSE);
//STRIP001 	USHORT nCount = pEngine->GetParagraphCount();	// koennte gerade neu eingefuegt worden sein
//STRIP001 	for (USHORT i=0; i<nCount; i++)
//STRIP001 		pEngine->QuickRemoveCharAttribs( i, EE_CHAR_COLOR );
//STRIP001 	pEngine->SetUpdateMode(TRUE);
//STRIP001 
//STRIP001 	EditView* pActiveView = pTopView ? pTopView : pTableView;
//STRIP001 	pActiveView->ShowCursor( FALSE, TRUE );
//STRIP001 
//STRIP001 	DeleteRangeFinder();		// loescht die Liste und die Markierungen auf der Tabelle
//STRIP001 }

//STRIP001 BOOL ScInputHandler::StartTable( sal_Unicode cTyped, BOOL bFromCommand )
//STRIP001 {
//STRIP001 	// returns TRUE if a new edit mode was started
//STRIP001 
//STRIP001 	BOOL bNewTable = FALSE;
//STRIP001 
//STRIP001 	if (!bModified && aCursorPos.Col()<=MAXCOL)
//STRIP001 	{
//STRIP001 		if (pActiveViewSh)
//STRIP001 		{
//STRIP001 			ImplCreateEditEngine();
//STRIP001 			UpdateActiveView();
//STRIP001 			SyncViews();
//STRIP001 
//STRIP001 			ScDocument* pDoc = pActiveViewSh->GetViewData()->GetDocShell()->GetDocument();
//STRIP001 
//STRIP001 			const ScMarkData& rMark = pActiveViewSh->GetViewData()->GetMarkData();
//STRIP001 			ScEditableTester aTester;
//STRIP001 			if ( rMark.IsMarked() || rMark.IsMultiMarked() )
//STRIP001 				aTester.TestSelection( pDoc, rMark );
//STRIP001 			else
//STRIP001 				aTester.TestSelectedBlock( pDoc, aCursorPos.Col(),aCursorPos.Row(),
//STRIP001 												 aCursorPos.Col(),aCursorPos.Row(), rMark );
//STRIP001 			if ( aTester.IsEditable() )
//STRIP001 			{
//STRIP001 				// UpdateMode is enabled again in ScViewData::SetEditEngine (and not needed otherwise)
//STRIP001 				pEngine->SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 				//	Attribute in EditEngine uebernehmen
//STRIP001 
//STRIP001 				const ScPatternAttr* pPattern = pDoc->GetPattern( aCursorPos.Col(),
//STRIP001 																  aCursorPos.Row(),
//STRIP001 																  aCursorPos.Tab() );
//STRIP001 				if (pPattern != pLastPattern)
//STRIP001 				{
//STRIP001 					//	Prozent-Format?
//STRIP001 
//STRIP001 					const SfxItemSet& rAttrSet = pPattern->GetItemSet();
//STRIP001 					const SfxPoolItem* pItem;
//STRIP001 
//STRIP001 					if ( SFX_ITEM_SET == rAttrSet.GetItemState( ATTR_VALUE_FORMAT, TRUE, &pItem ) )
//STRIP001 					{
//STRIP001 						ULONG nFormat = ((const SfxUInt32Item*)pItem)->GetValue();
//STRIP001 						bCellHasPercentFormat = ( NUMBERFORMAT_PERCENT ==
//STRIP001 												  pDoc->GetFormatTable()->GetType( nFormat ) );
//STRIP001 					}
//STRIP001 					else
//STRIP001 						bCellHasPercentFormat = FALSE; // Default: kein Prozent
//STRIP001 
//STRIP001 					//	Gueltigkeit angegeben?
//STRIP001 
//STRIP001 					if ( SFX_ITEM_SET == rAttrSet.GetItemState( ATTR_VALIDDATA, TRUE, &pItem ) )
//STRIP001 						nValidation = ((const SfxUInt32Item*)pItem)->GetValue();
//STRIP001 					else
//STRIP001 						nValidation = 0;
//STRIP001 
//STRIP001 					// 	EditEngine Defaults
//STRIP001 
//STRIP001 					//	Hier auf keinen Fall SetParaAttribs, weil die EditEngine evtl.
//STRIP001 					//	schon gefuellt ist (bei Edit-Zellen).
//STRIP001 					//	SetParaAttribs wuerde dann den Inhalt aendern
//STRIP001 
//STRIP001 					//! ER 30.08.00  The SetDefaults is now (since MUST/src602
//STRIP001 					//! EditEngine changes) implemented as a SetParaAttribs.
//STRIP001 					//! Any problems?
//STRIP001 
//STRIP001 					pPattern->FillEditItemSet( pEditDefaults );
//STRIP001 					pEngine->SetDefaults( *pEditDefaults );
//STRIP001 					pLastPattern = pPattern;
//STRIP001 					bLastIsSymbol = pPattern->IsSymbolFont();
//STRIP001 
//STRIP001 					//	Background color must be known for automatic font color.
//STRIP001 					//	For transparent cell background, the document background color must be used.
//STRIP001 
//STRIP001 					Color aBackCol = ((const SvxBrushItem&)
//STRIP001 									pPattern->GetItem( ATTR_BACKGROUND )).GetColor();
//STRIP001 					ScModule* pScMod = SC_MOD();
//STRIP001 					//	#105733# SvtAccessibilityOptions::GetIsForBorders is no longer used (always assumed TRUE)
//STRIP001 					if ( aBackCol.GetTransparency() > 0 ||
//STRIP001 							Application::GetSettings().GetStyleSettings().GetHighContrastMode() )
//STRIP001                         aBackCol.SetColor( pScMod->GetColorConfig().GetColorValue(svtools::DOCCOLOR).nColor );
//STRIP001 					pEngine->SetBackgroundColor( aBackCol );
//STRIP001 
//STRIP001 					//	Ausrichtung
//STRIP001 
//STRIP001 					nAttrAdjust = ((const SvxHorJustifyItem&)pPattern->
//STRIP001 									GetItem(ATTR_HOR_JUSTIFY)).GetValue();
//STRIP001 				}
//STRIP001 
//STRIP001 				//	UpdateSpellSettings enables online spelling if needed
//STRIP001 				//	-> also call if attributes are unchanged
//STRIP001 
//STRIP001 				UpdateSpellSettings( TRUE );	// uses pLastPattern
//STRIP001 
//STRIP001 				//	Edit-Engine fuellen
//STRIP001 
//STRIP001 				String aStr;
//STRIP001 				if (bTextValid)
//STRIP001 				{
//STRIP001 					pEngine->SetText(aCurrentText);
//STRIP001 					aStr = aCurrentText;
//STRIP001 					bTextValid = FALSE;
//STRIP001 					aCurrentText.Erase();
//STRIP001 				}
//STRIP001 				else
//STRIP001 					aStr = GetEditText(pEngine);
//STRIP001 
//STRIP001 				if (aStr.Len() > 3 && 					// Matrix-Formel ?
//STRIP001 					aStr.GetChar(0) == '{' &&
//STRIP001 					aStr.GetChar(1) == '=' &&
//STRIP001 					aStr.GetChar(aStr.Len()-1) == '}')
//STRIP001 				{
//STRIP001 					aStr.Erase(0,1);
//STRIP001 					aStr.Erase(aStr.Len()-1,1);
//STRIP001 					pEngine->SetText(aStr);
//STRIP001 					if ( pInputWin )
//STRIP001 						pInputWin->SetTextString(aStr);
//STRIP001 				}
//STRIP001 
//STRIP001 				UpdateAdjust( cTyped );
//STRIP001 
//STRIP001 				if ( bAutoComplete )
//STRIP001 					GetColData();
//STRIP001 
//STRIP001 				if ( aStr.GetChar(0) == '=' && !cTyped && !bCreatingFuncView )
//STRIP001 					InitRangeFinder(aStr);				// Formel wird editiert -> RangeFinder
//STRIP001 
//STRIP001 				bNewTable = TRUE;		//	-> PostEditView-Aufruf
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				bProtected = TRUE;
//STRIP001 				eMode = SC_INPUT_NONE;
//STRIP001 				StopInputWinEngine( TRUE );
//STRIP001 				UpdateFormulaMode();
//STRIP001 				if ( pActiveViewSh && ( !bFromCommand || !bCommandErrorShown ) )
//STRIP001 				{
//STRIP001 					//	#97673# Prevent repeated error messages for the same cell from command events
//STRIP001 					//	(for keyboard events, multiple messages are wanted).
//STRIP001 					//	Set the flag before showing the error message because the command handler
//STRIP001 					//	for the next IME command may be called when showing the dialog.
//STRIP001 					if ( bFromCommand )
//STRIP001 						bCommandErrorShown = TRUE;
//STRIP001 
//STRIP001 					pActiveViewSh->GetActiveWin()->GrabFocus();
//STRIP001 					pActiveViewSh->ErrorMessage(aTester.GetMessageId());
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if (!bProtected && pInputWin)
//STRIP001 			pInputWin->SetOkCancelMode();
//STRIP001 	}
//STRIP001 
//STRIP001 	return bNewTable;
//STRIP001 }

//STRIP001 void lcl_SetTopSelection( EditView* pEditView, ESelection& rSel )
//STRIP001 {
//STRIP001 	DBG_ASSERT( rSel.nStartPara==0 && rSel.nEndPara==0, "SetTopSelection: Para != 0" );
//STRIP001 
//STRIP001 	EditEngine* pEngine = pEditView->GetEditEngine();
//STRIP001 	USHORT nCount = pEngine->GetParagraphCount();
//STRIP001 	if (nCount > 1)
//STRIP001 	{
//STRIP001 		xub_StrLen nParLen = pEngine->GetTextLen(rSel.nStartPara);
//STRIP001 		while (rSel.nStartPos > nParLen && rSel.nStartPara+1 < nCount)
//STRIP001 		{
//STRIP001 			rSel.nStartPos -= nParLen + 1;			// incl. Leerzeichen vom Umbruch
//STRIP001 			nParLen = pEngine->GetTextLen(++rSel.nStartPara);
//STRIP001 		}
//STRIP001 
//STRIP001 		nParLen = pEngine->GetTextLen(rSel.nEndPara);
//STRIP001 		while (rSel.nEndPos > nParLen && rSel.nEndPara+1 < nCount)
//STRIP001 		{
//STRIP001 			rSel.nEndPos -= nParLen + 1;			// incl. Leerzeichen vom Umbruch
//STRIP001 			nParLen = pEngine->GetTextLen(++rSel.nEndPara);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	ESelection aSel = pEditView->GetSelection();
//STRIP001 
//STRIP001 	if (   rSel.nStartPara != aSel.nStartPara || rSel.nEndPara != aSel.nEndPara
//STRIP001 		|| rSel.nStartPos  != aSel.nStartPos  || rSel.nEndPos  != aSel.nEndPos )
//STRIP001 		pEditView->SetSelection( rSel );
//STRIP001 }

//STRIP001 void ScInputHandler::SyncViews( EditView* pSourceView )
//STRIP001 {
//STRIP001 	ESelection aSel;
//STRIP001 
//STRIP001 	if (pSourceView)
//STRIP001 	{
//STRIP001 		aSel = pSourceView->GetSelection();
//STRIP001 		if (pTopView && pTopView != pSourceView)
//STRIP001 			pTopView->SetSelection( aSel );
//STRIP001 		if (pTableView && pTableView != pSourceView)
//STRIP001 			lcl_SetTopSelection( pTableView, aSel );
//STRIP001 	}
//STRIP001 	else if (pTopView && pTableView)
//STRIP001 	{
//STRIP001 		aSel = pTopView->GetSelection();
//STRIP001 		lcl_SetTopSelection( pTableView, aSel );
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScInputHandler::SetAllUpdateMode( BOOL bUpdate )
//STRIP001 {
//STRIP001 	ImplCreateEditEngine();
//STRIP001 	pEngine->SetUpdateMode( bUpdate );
//STRIP001 }

/*N*/ IMPL_LINK( ScInputHandler, ModifyHdl, void *, EMPTYARG )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( !bInOwnChange && ( eMode==SC_INPUT_TYPE || eMode==SC_INPUT_TABLE ) &&
//STRIP001 		 pEngine && pEngine->GetUpdateMode() && pInputWin )
//STRIP001 	{
//STRIP001 		//	#102745# update input line from ModifyHdl for changes that are not
//STRIP001 		//	wrapped by DataChanging/DataChanged calls (like Drag&Drop)
//STRIP001 
//STRIP001 		String aText = GetEditText(pEngine);
//STRIP001 		lcl_RemoveTabs(aText);
//STRIP001 		pInputWin->SetTextString(aText);
//STRIP001 	}
/*N*/ 	return 0;
/*N*/ }

//STRIP001 BOOL ScInputHandler::DataChanging( sal_Unicode cTyped, BOOL bFromCommand )		// return TRUE = new view created
//STRIP001 {
//STRIP001 	bInOwnChange = TRUE;				// disable ModifyHdl (reset in DataChanged)
//STRIP001 
//STRIP001 	if ( eMode == SC_INPUT_NONE )
//STRIP001 		return StartTable( cTyped, bFromCommand );
//STRIP001 	else
//STRIP001 		return FALSE;
//STRIP001 }

//STRIP001 void ScInputHandler::DataChanged()
//STRIP001 {
//STRIP001 	ImplCreateEditEngine();
//STRIP001 
//STRIP001 	if (eMode==SC_INPUT_NONE)
//STRIP001 		eMode = SC_INPUT_TYPE;
//STRIP001 
//STRIP001 	if ( eMode == SC_INPUT_TOP && pTopView )
//STRIP001 	{
//STRIP001 		//	table EditEngine is formatted below, input line needs formatting after paste
//STRIP001 		pTopView->GetEditEngine()->QuickFormatDoc( TRUE );
//STRIP001 	}
//STRIP001 
//STRIP001 	bModified = TRUE;
//STRIP001 	bSelIsRef = FALSE;
//STRIP001 
//STRIP001 	if ( pRangeFindList && !bInRangeUpdate )
//STRIP001 		RemoveRangeFinder();					// Attribute und Markierung loeschen
//STRIP001 
//STRIP001 	UpdateParenthesis();	//	Hervorhebung der Klammern neu
//STRIP001 
//STRIP001 	// ER 31.08.00  New SetDefaults sets ParaAttribs, don't clear them away ...
//STRIP001 //	RemoveAdjust();		//	#40255# harte Ausrichtungs-Attribute loeschen
//STRIP001 
//STRIP001 	if (eMode==SC_INPUT_TYPE || eMode==SC_INPUT_TABLE)
//STRIP001 	{
//STRIP001 		String aText = GetEditText(pEngine);
//STRIP001 		lcl_RemoveTabs(aText);
//STRIP001 
//STRIP001 		if ( pInputWin )
//STRIP001 			pInputWin->SetTextString(aText);
//STRIP001 	}
//STRIP001 
//STRIP001 		//	wenn der Cursor vor dem Absatzende steht, werden Teile rechts rausgeschoben
//STRIP001 		//	(unabhaengig von eMode)		-> View anpassen!
//STRIP001 		//	wenn der Cursor am Ende steht, reicht der Status-Handler an der ViewData
//STRIP001 
//STRIP001 	//	#93767# first make sure the status handler is called now if the cursor
//STRIP001 	//	is outside the visible area
//STRIP001 	pEngine->QuickFormatDoc();
//STRIP001 
//STRIP001 	EditView* pActiveView = pTopView ? pTopView : pTableView;
//STRIP001 	if (pActiveView && pActiveViewSh)
//STRIP001 	{
//STRIP001 		BOOL bNeedGrow = ( nEditAdjust != SVX_ADJUST_LEFT );		// rechtsbuendig immer
//STRIP001 		if (!bNeedGrow)
//STRIP001 		{
//STRIP001 				//	Cursor vor dem Ende?
//STRIP001 			ESelection aSel = pActiveView->GetSelection();
//STRIP001 			aSel.Adjust();
//STRIP001 			bNeedGrow = ( aSel.nEndPos != pEngine->GetTextLen(aSel.nEndPara) );
//STRIP001 		}
//STRIP001 		if (bNeedGrow)
//STRIP001 		{
//STRIP001 								// Inplace-View anpassen
//STRIP001 			pActiveViewSh->GetViewData()->EditGrowY();
//STRIP001 			pActiveViewSh->GetViewData()->EditGrowX();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	UpdateFormulaMode();
//STRIP001 	bTextValid = FALSE;			// Aenderungen sind nur in der Edit-Engine
//STRIP001 	bInOwnChange = FALSE;
//STRIP001 }

//STRIP001 void ScInputHandler::UpdateFormulaMode()
//STRIP001 {
//STRIP001 	SfxApplication* pSfxApp = SFX_APP();
//STRIP001 
//STRIP001 	if ( pEngine->GetParagraphCount()==1 && pEngine->GetText((USHORT)0).GetChar(0) == '='
//STRIP001 		&& !bProtected )
//STRIP001 	{
//STRIP001 		if (!bFormulaMode)
//STRIP001 		{
//STRIP001 			bFormulaMode = TRUE;
//STRIP001 			pRefViewSh = pActiveViewSh;
//STRIP001 			pSfxApp->Broadcast( SfxSimpleHint( FID_REFMODECHANGED ) );
//STRIP001 			SC_MOD()->SetRefInputHdl(this);
//STRIP001 			if (pInputWin)
//STRIP001 				pInputWin->SetFormulaMode(TRUE);
//STRIP001 
//STRIP001 			if ( bAutoComplete )
//STRIP001 				GetFormulaData();
//STRIP001 
//STRIP001 			UpdateParenthesis();
//STRIP001 			UpdateAutoCorrFlag();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else		// ausschalten
//STRIP001 	{
//STRIP001 		if (bFormulaMode)
//STRIP001 		{
//STRIP001 			ShowRefFrame();
//STRIP001 			bFormulaMode = FALSE;
//STRIP001 			pRefViewSh = NULL;
//STRIP001 			pSfxApp->Broadcast( SfxSimpleHint( FID_REFMODECHANGED ) );
//STRIP001 			SC_MOD()->SetRefInputHdl(NULL);
//STRIP001 			if (pInputWin)
//STRIP001 				pInputWin->SetFormulaMode(FALSE);
//STRIP001 			UpdateAutoCorrFlag();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScInputHandler::ShowRefFrame()
//STRIP001 {
//STRIP001 	pActiveViewSh = PTR_CAST( ScTabViewShell, SfxViewShell::Current() );
//STRIP001 	if ( pRefViewSh && pRefViewSh != pActiveViewSh )
//STRIP001 	{
//STRIP001 		BOOL bFound = FALSE;
//STRIP001 		SfxViewFrame* pRefFrame = pRefViewSh->GetViewFrame();
//STRIP001 		SfxViewFrame* pOneFrame = SfxViewFrame::GetFirst();
//STRIP001 		while ( pOneFrame && !bFound )
//STRIP001 		{
//STRIP001 			if ( pOneFrame == pRefFrame )
//STRIP001 				bFound = TRUE;
//STRIP001 			pOneFrame = SfxViewFrame::GetNext( *pOneFrame );
//STRIP001 		}
//STRIP001 
//STRIP001 		if (bFound)
//STRIP001 		{
//STRIP001 			//	Hier wird sich darauf verlassen, dass Activate synchron funktioniert
//STRIP001 			//	(dabei wird pActiveViewSh umgesetzt)
//STRIP001 
//STRIP001 			pRefViewSh->SetActive();	// Appear und SetViewFrame
//STRIP001 
//STRIP001 			//	pLastState wird im NotifyChange aus dem Activate richtig gesetzt
//STRIP001 		}
//STRIP001 		else
//STRIP001 			DBG_ERROR("ViewFrame fuer Referenzeingabe ist nicht mehr da");
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScInputHandler::RemoveSelection()
//STRIP001 {
//STRIP001 	EditView* pActiveView = pTopView ? pTopView : pTableView;
//STRIP001 	if (!pActiveView)
//STRIP001 		return;
//STRIP001 
//STRIP001 	ESelection aSel = pActiveView->GetSelection();
//STRIP001 	aSel.nStartPara = aSel.nEndPara;
//STRIP001 	aSel.nStartPos  = aSel.nEndPos;
//STRIP001 	if (pTableView)
//STRIP001 		pTableView->SetSelection( aSel );
//STRIP001 	if (pTopView)
//STRIP001 		pTopView->SetSelection( aSel );
//STRIP001 }

//STRIP001 void ScInputHandler::InvalidateAttribs()
//STRIP001 {
//STRIP001 	SfxViewFrame* pViewFrm = SfxViewFrame::Current();
//STRIP001 	if (pViewFrm)
//STRIP001 	{
//STRIP001 		SfxBindings& rBindings = pViewFrm->GetBindings();
//STRIP001 
//STRIP001 		rBindings.Invalidate( SID_ATTR_CHAR_FONT );
//STRIP001 		rBindings.Invalidate( SID_ATTR_CHAR_FONTHEIGHT );
//STRIP001 		rBindings.Invalidate( SID_ATTR_CHAR_COLOR );
//STRIP001 
//STRIP001 		rBindings.Invalidate( SID_ATTR_CHAR_WEIGHT );
//STRIP001 		rBindings.Invalidate( SID_ATTR_CHAR_POSTURE );
//STRIP001 		rBindings.Invalidate( SID_ATTR_CHAR_UNDERLINE );
//STRIP001 		rBindings.Invalidate( SID_ULINE_VAL_NONE );
//STRIP001 		rBindings.Invalidate( SID_ULINE_VAL_SINGLE );
//STRIP001 		rBindings.Invalidate( SID_ULINE_VAL_DOUBLE );
//STRIP001 		rBindings.Invalidate( SID_ULINE_VAL_DOTTED );
//STRIP001 
//STRIP001 		rBindings.Invalidate( SID_HYPERLINK_GETLINK );
//STRIP001 	}
//STRIP001 }


//
//		--------------- public Methoden --------------------------------------------
//

//STRIP001 void ScInputHandler::SetMode( ScInputMode eNewMode )
//STRIP001 {
//STRIP001 	if ( eMode == eNewMode )
//STRIP001 		return;
//STRIP001 
//STRIP001 	ImplCreateEditEngine();
//STRIP001 
//STRIP001 	if (bProtected)
//STRIP001 	{
//STRIP001 		eMode = SC_INPUT_NONE;
//STRIP001 		StopInputWinEngine( TRUE );
//STRIP001 		if (pActiveViewSh)
//STRIP001 			pActiveViewSh->GetActiveWin()->GrabFocus();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	bInOwnChange = TRUE;				// disable ModifyHdl (reset below)
//STRIP001 
//STRIP001 	ScInputMode eOldMode = eMode;
//STRIP001 	eMode = eNewMode;
//STRIP001 	if (eOldMode == SC_INPUT_TOP && eNewMode != eOldMode)
//STRIP001 		StopInputWinEngine( FALSE );
//STRIP001 
//STRIP001 	if (eMode==SC_INPUT_TOP || eMode==SC_INPUT_TABLE)
//STRIP001 	{
//STRIP001 		if (eOldMode == SC_INPUT_NONE)		// not when switching between modes
//STRIP001 		{
//STRIP001 			if (StartTable(0, FALSE))		// 0 = look at existing document content for text or number
//STRIP001 			{
//STRIP001 				if (pActiveViewSh)
//STRIP001 					pActiveViewSh->GetViewData()->GetDocShell()->PostEditView( pEngine, aCursorPos );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		USHORT nPara    = pEngine->GetParagraphCount()-1;
//STRIP001 		xub_StrLen nLen = pEngine->GetText(nPara).Len();
//STRIP001 		USHORT nCount   = pEngine->GetViewCount();
//STRIP001 
//STRIP001 		for (USHORT i=0; i<nCount; i++)
//STRIP001 		{
//STRIP001 			if ( eMode == SC_INPUT_TABLE && eOldMode == SC_INPUT_TOP )
//STRIP001 			{
//STRIP001 				//	Selektion bleibt
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pEngine->GetView(i)->
//STRIP001 					SetSelection( ESelection( nPara, nLen, nPara, nLen ) );
//STRIP001 			}
//STRIP001 			pEngine->GetView(i)->ShowCursor(FALSE);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	UpdateActiveView();
//STRIP001 	if (eMode==SC_INPUT_TABLE || eMode==SC_INPUT_TYPE)
//STRIP001 	{
//STRIP001 		if (pTableView)
//STRIP001 			pTableView->SetEditEngineUpdateMode(TRUE);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if (pTopView)
//STRIP001 			pTopView->SetEditEngineUpdateMode(TRUE);
//STRIP001 	}
//STRIP001 
//STRIP001 	if (eNewMode != eOldMode)
//STRIP001 		UpdateFormulaMode();
//STRIP001 
//STRIP001 	bInOwnChange = FALSE;
//STRIP001 }

//----------------------------------------------------------------------------------------

//	lcl_IsNumber - TRUE, wenn nur Ziffern (dann keine Autokorrektur)

BOOL lcl_IsNumber(const String& rString)
{
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 xub_StrLen nLen = rString.Len();
//STRIP001 	for (xub_StrLen i=0; i<nLen; i++)
//STRIP001 	{
//STRIP001 		sal_Unicode c = rString.GetChar(i);
//STRIP001 		if ( c < '0' || c > '9' )
//STRIP001 			return FALSE;
//STRIP001 	}
	return TRUE;
}

/*N*/ void ScInputHandler::EnterHandler( BYTE nBlockMode )
/*N*/ {
/*N*/ 	//	#62806# Bei Makro-Aufrufen fuer Gueltigkeit kann Tod und Teufel passieren,
/*N*/ 	//	darum dafuer sorgen, dass EnterHandler nicht verschachtelt gerufen wird:
/*N*/ 
/*N*/ 	if (bInEnterHandler) return;
/*N*/ 	bInEnterHandler = TRUE;
/*N*/ 	bInOwnChange = TRUE;				// disable ModifyHdl (reset below)
/*N*/ 
/*N*/ 	ImplCreateEditEngine();
/*N*/ 
/*N*/ 	BOOL bMatrix = ( nBlockMode == SC_ENTER_MATRIX );
/*N*/ 
/*N*/ 	SfxApplication*	pSfxApp		= SFX_APP();
/*N*/ 	EditTextObject* pObject		= NULL;
/*N*/ 	ScPatternAttr*	pCellAttrs	= NULL;
/*N*/ 	BOOL			bAttrib		= FALSE;	// Formatierung vorhanden ?
/*N*/ 	BOOL			bForget		= FALSE;	// wegen Gueltigkeit streichen ?
/*N*/ 
/*N*/ 	String aString = GetEditText(pEngine);
/*N*/ 	EditView* pActiveView = pTopView ? pTopView : pTableView;
/*N*/ 	if (bModified && pActiveView && aString.Len() && !lcl_IsNumber(aString))
/*N*/ 	{
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	if (pTopView)
//STRIP001 /*?*/ 			pTopView->CompleteAutoCorrect();	// #59759# CompleteAutoCorrect fuer beide Views
//STRIP001 /*?*/ 		if (pTableView)
//STRIP001 /*?*/ 			pTableView->CompleteAutoCorrect();
//STRIP001 /*?*/ 		aString = GetEditText(pEngine);
/*N*/ 	}
/*N*/ 	lcl_RemoveTabs(aString);
/*N*/ 
/*N*/ 	//	Test, ob zulaessig (immer mit einfachem String)
/*N*/ 
/*N*/ 	if ( bModified && nValidation && pActiveViewSh )
/*N*/ 	{
		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		ScDocument* pDoc = pActiveViewSh->GetViewData()->GetDocument();
//STRIP001 /*?*/ 		const ScValidationData*	pData = pDoc->GetValidationEntry( nValidation );
//STRIP001 /*?*/ 		if (pData && pData->HasErrMsg())
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			const ScPatternAttr* pPattern = pLastPattern;
//STRIP001 /*?*/ 			if (!pPattern)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				DBG_ERROR("kein Pattern !??!");
//STRIP001 /*?*/ 				pPattern = pDoc->GetPattern( aCursorPos.Col(), aCursorPos.Row(),
//STRIP001 /*?*/ 											  aCursorPos.Tab() );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			BOOL bOk = pData->IsDataValid( aString, *pPattern, aCursorPos );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if (!bOk)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				if ( pActiveViewSh )				// falls aus MouseButtonDown gekommen
//STRIP001 /*?*/ 					pActiveViewSh->StopMarking();	// (die InfoBox verschluckt das MouseButtonUp)
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					//!	es gibt noch Probleme, wenn die Eingabe durch Aktivieren einer
//STRIP001 /*?*/ 					//!	anderen View ausgeloest wurde
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				Window* pParent = Application::GetDefDialogParent();
//STRIP001 /*?*/ 				if ( pData->DoError( pParent, aString, aCursorPos ) )
//STRIP001 /*?*/ 					bForget = TRUE;					// Eingabe nicht uebernehmen
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	pEngine->CompleteOnlineSpelling();
/*N*/ 	BOOL bSpellErrors = !bFormulaMode && pEngine->HasOnlineSpellErrors();
/*N*/ 	if ( bSpellErrors )
/*N*/ 	{
/*?*/ 		//	#i3820# If the spell checker flags numerical input as error,
/*?*/ 		//	it still has to be treated as number, not EditEngine object.
/*?*/ 
/*?*/ 		if ( pLastPattern && pActiveViewSh )
/*?*/ 		{
/*?*/ 			ScDocument* pDoc = pActiveViewSh->GetViewData()->GetDocument();
/*?*/ 			SvNumberFormatter* pFormatter = pDoc->GetFormatTable();
/*?*/ 			// without conditional format, as in ScColumn::SetString
/*?*/ 			ULONG nFormat = pLastPattern->GetNumberFormat( pFormatter );
/*?*/ 			double nVal;
/*?*/ 			if ( pFormatter->IsNumberFormat( aString, nFormat, nVal ) )
/*?*/ 			{
/*?*/ 				bSpellErrors = FALSE;		// ignore the spelling errors
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	//	After RemoveAdjust, the EditView must not be repainted (has wrong font size etc).
/*N*/ 	//	SetUpdateMode must come after CompleteOnlineSpelling.
/*N*/ 	//	The view is hidden in any case below (Broadcast).
/*N*/ 	pEngine->SetUpdateMode( FALSE );
/*N*/ 
/*N*/ 	if ( bModified && !bForget )			// was wird eingeben (Text/Objekt) ?
/*N*/ 	{
		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		USHORT nParCnt = pEngine->GetParagraphCount();
//STRIP001 /*?*/ 		if ( nParCnt == 0 )
//STRIP001 /*?*/ 			nParCnt = 1;
//STRIP001 /*?*/ 		ESelection aSel( 0, 0, nParCnt-1, pEngine->GetTextLen(nParCnt-1) );
//STRIP001 /*?*/ 		SfxItemSet aOldAttribs = pEngine->GetAttribs( aSel );
//STRIP001 /*?*/ 		const SfxPoolItem* pItem = NULL;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		//	find common (cell) attributes before RemoveAdjust
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if ( pActiveViewSh )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			SfxItemSet* pCommonAttrs = NULL;
//STRIP001 /*?*/ 			for (USHORT nId = EE_CHAR_START; nId <= EE_CHAR_END; nId++)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				SfxItemState eState = aOldAttribs.GetItemState( nId, FALSE, &pItem );
//STRIP001 /*?*/ 				if ( eState == SFX_ITEM_SET &&
//STRIP001 /*?*/ 						nId != EE_CHAR_ESCAPEMENT && nId != EE_CHAR_PAIRKERNING &&
//STRIP001 /*?*/ 						nId != EE_CHAR_KERNING && nId != EE_CHAR_XMLATTRIBS &&
//STRIP001 /*?*/ 							*pItem != pEditDefaults->Get(nId) )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					if ( !pCommonAttrs )
//STRIP001 /*?*/ 						pCommonAttrs = new SfxItemSet( pEngine->GetEmptyItemSet() );
//STRIP001 /*?*/ 					pCommonAttrs->Put( *pItem );
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if ( pCommonAttrs )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				ScDocument* pDoc = pActiveViewSh->GetViewData()->GetDocument();
//STRIP001 /*?*/ 				pCellAttrs = new ScPatternAttr( pDoc->GetPool() );
//STRIP001 /*?*/ 				pCellAttrs->GetFromEditItemSet( pCommonAttrs );
//STRIP001 /*?*/ 				delete pCommonAttrs;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		//	clear ParaAttribs (including adjustment)
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		RemoveAdjust();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		//	check if EditObject is needed
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if ( bSpellErrors || nParCnt > 1 )
//STRIP001 /*?*/ 			bAttrib = TRUE;
//STRIP001 /*?*/ 		else
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			for (USHORT nId = EE_CHAR_START; nId <= EE_CHAR_END && !bAttrib; nId++)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				SfxItemState eState = aOldAttribs.GetItemState( nId, FALSE, &pItem );
//STRIP001 /*?*/ 				if (eState == SFX_ITEM_DONTCARE)
//STRIP001 /*?*/ 					bAttrib = TRUE;
//STRIP001 /*?*/ 				else if (eState == SFX_ITEM_SET)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					//	keep same items in EditEngine as in ScEditAttrTester
//STRIP001 /*?*/ 					if ( nId == EE_CHAR_ESCAPEMENT || nId == EE_CHAR_PAIRKERNING ||
//STRIP001 /*?*/ 						 nId == EE_CHAR_KERNING || nId == EE_CHAR_XMLATTRIBS )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						if ( *pItem != pEditDefaults->Get(nId) )
//STRIP001 /*?*/ 							bAttrib = TRUE;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			//	Feldbefehle enthalten?
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			SfxItemState eFieldState = aOldAttribs.GetItemState( EE_FEATURE_FIELD, FALSE );
//STRIP001 /*?*/ 			if ( eFieldState == SFX_ITEM_DONTCARE || eFieldState == SFX_ITEM_SET )
//STRIP001 /*?*/ 				bAttrib = TRUE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			//	not converted characters?
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			SfxItemState eConvState = aOldAttribs.GetItemState( EE_FEATURE_NOTCONV, FALSE );
//STRIP001 /*?*/ 			if ( eConvState == SFX_ITEM_DONTCARE || eConvState == SFX_ITEM_SET )
//STRIP001 /*?*/ 				bAttrib = TRUE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			//	Formeln immer als Formeln erkennen (#38309#)
//STRIP001 /*?*/ 			//	(der Test vorher ist trotzdem noetig wegen Zell-Attributen)
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if ( bAttrib && bFormulaMode )
//STRIP001 /*?*/ 				bAttrib = FALSE;
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if (bMatrix)
//STRIP001 /*?*/ 			bAttrib = FALSE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if (bAttrib)
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			ULONG nCtrl = pEngine->GetControlWord();
//STRIP001 /*?*/ 			ULONG nWantBig = bSpellErrors ? EE_CNTRL_ALLOWBIGOBJS : 0;
//STRIP001 /*?*/ 			if ( ( nCtrl & EE_CNTRL_ALLOWBIGOBJS ) != nWantBig )
//STRIP001 /*?*/ 				pEngine->SetControlWord( (nCtrl & ~EE_CNTRL_ALLOWBIGOBJS) | nWantBig );
//STRIP001 /*?*/ 			pObject = pEngine->CreateTextObject();
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		else if (bAutoComplete)			// Gross-/Kleinschreibung anpassen
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if (pColumnData)
//STRIP001 /*?*/ 				pColumnData->GetExactMatch( aString );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			//!	effizienter in der Liste suchen (ScUserList, nur einmal ToUpper)
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			USHORT nIndex;
//STRIP001 /*?*/ 			ScUserListData* pData = ScGlobal::GetUserList()->GetData(aString);
//STRIP001 /*?*/ 			if ( pData && pData->GetSubIndex( aString, nIndex ) )
//STRIP001 /*?*/ 				aString = pData->GetSubStr( nIndex );
//STRIP001 /*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	//	don't rely on ShowRefFrame switching the active view synchronously
/*N*/ 	//	execute the function directly on the correct view's bindings instead
/*N*/ 	//	pRefViewSh is reset in ShowRefFrame - get pointer before ShowRefFrame call
/*N*/ 	ScTabViewShell* pExecuteSh = pRefViewSh ? pRefViewSh : pActiveViewSh;
/*N*/ 
/*N*/ 	if (bFormulaMode)
/*N*/ 	{
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		ShowRefFrame();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if (pExecuteSh)
//STRIP001 /*?*/ 			pExecuteSh->SetTabNo(aCursorPos.Tab());
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		bFormulaMode = FALSE;
//STRIP001 /*?*/ 		pSfxApp->Broadcast( SfxSimpleHint( FID_REFMODECHANGED ) );
//STRIP001 /*?*/ 		SC_MOD()->SetRefInputHdl(NULL);
//STRIP001 /*?*/ 		if (pInputWin)
//STRIP001 /*?*/ 			pInputWin->SetFormulaMode(FALSE);
//STRIP001 /*?*/ 		UpdateAutoCorrFlag();
/*N*/ 	}
/*N*/ 	pRefViewSh = NULL;			// auch ohne FormulaMode wegen Funktions-AP
/*N*/ 	DeleteRangeFinder();
/*N*/ 	ResetAutoPar();
/*N*/ 
/*N*/ 	BOOL bOldMod = bModified;
/*N*/ 
/*N*/ 	bModified = FALSE;
/*N*/ 	bSelIsRef = FALSE;
/*N*/ 	eMode 	  = SC_INPUT_NONE;
/*N*/ 	StopInputWinEngine( TRUE );
/*N*/ 
/*N*/ 	if (bOldMod && !bProtected && !bForget)
/*N*/ 	{
/*?*/ 		//	keine typographische Anfuehrungszeichen in Formeln
/*?*/ 
/*?*/ 		if ( aString.GetChar(0) == '=' )
/*?*/ 		{
/*?*/ 			SvxAutoCorrect* pAuto = OFF_APP()->GetAutoCorrect();
/*?*/ 			if ( pAuto )
/*?*/ 			{
/*?*/ 				sal_Unicode cReplace = pAuto->GetStartDoubleQuote();
/*?*/ 				if( !cReplace )
/*?*/                     cReplace = ScGlobal::pLocaleData->getDoubleQuotationMarkStart().GetChar(0);
/*?*/ 				if ( cReplace != '"' )
/*?*/ 					aString.SearchAndReplaceAll( cReplace, '"' );
/*?*/ 
/*?*/ 				cReplace = pAuto->GetEndDoubleQuote();
/*?*/ 				if( !cReplace )
/*?*/                     cReplace = ScGlobal::pLocaleData->getDoubleQuotationMarkEnd().GetChar(0);
/*?*/ 				if ( cReplace != '"' )
/*?*/ 					aString.SearchAndReplaceAll( cReplace, '"' );
/*?*/ 
/*?*/ 				cReplace = pAuto->GetStartSingleQuote();
/*?*/ 				if( !cReplace )
/*?*/                     cReplace = ScGlobal::pLocaleData->getQuotationMarkStart().GetChar(0);
/*?*/ 				if ( cReplace != '\'' )
/*?*/ 					aString.SearchAndReplaceAll( cReplace, '\'' );
/*?*/ 
/*?*/ 				cReplace = pAuto->GetEndSingleQuote();
/*?*/ 				if( !cReplace )
/*?*/                     cReplace = ScGlobal::pLocaleData->getQuotationMarkEnd().GetChar(0);
/*?*/ 				if ( cReplace != '\'' )
/*?*/ 					aString.SearchAndReplaceAll( cReplace, '\'' );
/*?*/ 			}
/*?*/ 		}
/*?*/ 
/*?*/ 		pSfxApp->Broadcast( SfxSimpleHint( FID_KILLEDITVIEW_NOPAINT ) );
/*?*/ 
/*?*/ 		if ( pExecuteSh )
/*?*/ 		{
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			SfxBindings& rBindings = pExecuteSh->GetViewFrame()->GetBindings();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			USHORT nId = FID_INPUTLINE_ENTER;
//STRIP001 /*?*/ 			if ( nBlockMode == SC_ENTER_BLOCK )
//STRIP001 /*?*/ 				nId = FID_INPUTLINE_BLOCK;
//STRIP001 /*?*/ 			else if ( nBlockMode == SC_ENTER_MATRIX )
//STRIP001 /*?*/ 				nId = FID_INPUTLINE_MATRIX;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			ScInputStatusItem aItem( FID_INPUTLINE_STATUS,
//STRIP001 /*?*/ 									 aCursorPos, aCursorPos, aCursorPos,
//STRIP001 /*?*/ 									 aString, pObject );
//STRIP001 /*?*/ 			const SfxPoolItem* aArgs[2];
//STRIP001 /*?*/ 			aArgs[0] = &aItem;
//STRIP001 /*?*/ 			aArgs[1] = NULL;
//STRIP001 /*?*/ 			rBindings.Execute( nId, aArgs );
/*?*/ 		}
/*?*/ 
/*?*/ 		delete pLastState;		// pLastState enthaelt noch den alten Text
/*?*/ 		pLastState = NULL;
/*N*/ 	}
/*N*/ 	else
/*N*/ 		pSfxApp->Broadcast( SfxSimpleHint( FID_KILLEDITVIEW ) );
/*N*/ 
/*N*/ 	if ( bOldMod && pExecuteSh && pCellAttrs && !bForget )
/*N*/ 	{
/*?*/ 		//	mit Eingabe zusammenfassen ?
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pExecuteSh->ApplySelectionPattern( *pCellAttrs, TRUE, TRUE );
//STRIP001 /*?*/ 		pExecuteSh->AdjustBlockHeight();
/*N*/ 	}
/*N*/ 
/*N*/ 	delete pCellAttrs;
/*N*/ 	delete pObject;
/*N*/ 
/*N*/ 	HideTip();
/*N*/ 
/*N*/ 	nFormSelStart = nFormSelEnd = 0;
/*N*/ 	aFormText.Erase();
/*N*/ 
/*N*/ 	bInOwnChange = FALSE;
/*N*/ 	bInEnterHandler = FALSE;
/*N*/ }

//STRIP001 void ScInputHandler::CancelHandler()
//STRIP001 {
//STRIP001 	bInOwnChange = TRUE;				// disable ModifyHdl (reset below)
//STRIP001 
//STRIP001 	ImplCreateEditEngine();
//STRIP001 
//STRIP001 	bModified = FALSE;
//STRIP001 
//STRIP001 	//	don't rely on ShowRefFrame switching the active view synchronously
//STRIP001 	//	execute the function directly on the correct view's bindings instead
//STRIP001 	//	pRefViewSh is reset in ShowRefFrame - get pointer before ShowRefFrame call
//STRIP001 	ScTabViewShell* pExecuteSh = pRefViewSh ? pRefViewSh : pActiveViewSh;
//STRIP001 
//STRIP001 	if (bFormulaMode)
//STRIP001 	{
//STRIP001 		ShowRefFrame();
//STRIP001 		if (pExecuteSh)
//STRIP001 			pExecuteSh->SetTabNo(aCursorPos.Tab());
//STRIP001 		bFormulaMode = FALSE;
//STRIP001 		SFX_APP()->Broadcast( SfxSimpleHint( FID_REFMODECHANGED ) );
//STRIP001 		SC_MOD()->SetRefInputHdl(NULL);
//STRIP001 		if (pInputWin)
//STRIP001 			pInputWin->SetFormulaMode(FALSE);
//STRIP001 		UpdateAutoCorrFlag();
//STRIP001 	}
//STRIP001 	pRefViewSh = NULL;			// auch ohne FormulaMode wegen Funktions-AP
//STRIP001 	DeleteRangeFinder();
//STRIP001 	ResetAutoPar();
//STRIP001 
//STRIP001 	eMode = SC_INPUT_NONE;
//STRIP001 	StopInputWinEngine( TRUE );
//STRIP001 	if (pExecuteSh)
//STRIP001 		pExecuteSh->StopEditShell();
//STRIP001 
//STRIP001 	aCursorPos.Set(MAXCOL+1,0,0);		// Flag, dass ungueltig
//STRIP001 	pEngine->SetText(String());
//STRIP001 
//STRIP001 	if ( !pLastState && pExecuteSh )
//STRIP001 		pExecuteSh->UpdateInputHandler( TRUE );		// Status neu holen
//STRIP001 	else
//STRIP001 		NotifyChange( pLastState, TRUE );
//STRIP001 
//STRIP001 	nFormSelStart = nFormSelEnd = 0;
//STRIP001 	aFormText.Erase();
//STRIP001 
//STRIP001 	bInOwnChange = FALSE;
//STRIP001 }

//STRIP001 BOOL ScInputHandler::IsModalMode( SfxObjectShell* pDocSh )
//STRIP001 {
//STRIP001 	//	Referenzen auf unbenanntes Dokument gehen nicht
//STRIP001 
//STRIP001 	return bFormulaMode && pRefViewSh
//STRIP001 			&& pRefViewSh->GetViewData()->GetDocument()->GetDocumentShell() != pDocSh
//STRIP001 			&& !pDocSh->HasName();
//STRIP001 }

//STRIP001 void ScInputHandler::AddRefEntry()
//STRIP001 {
//STRIP001 	UpdateActiveView();
//STRIP001 	if (!pTableView && !pTopView)
//STRIP001 		return; 							// z.B. FillMode
//STRIP001 
//STRIP001 	DataChanging(); 						// kann nicht neu sein
//STRIP001 
//STRIP001 	RemoveSelection();
//STRIP001 	if (pTableView)
//STRIP001 		pTableView->InsertText( ';', FALSE );
//STRIP001 	if (pTopView)
//STRIP001 		pTopView->InsertText( ';', FALSE );
//STRIP001 
//STRIP001 	DataChanged();
//STRIP001 }

//STRIP001 void ScInputHandler::SetReference( const ScRange& rRef, ScDocument* pDoc )
//STRIP001 {
//STRIP001 	HideTip();
//STRIP001 
//STRIP001 	BOOL bOtherDoc = ( pRefViewSh &&
//STRIP001 						pRefViewSh->GetViewData()->GetDocument() != pDoc );
//STRIP001 	if (bOtherDoc)
//STRIP001 		if (!pDoc->GetDocumentShell()->HasName())
//STRIP001 		{
//STRIP001 			//	Referenzen auf unbenanntes Dokument gehen nicht
//STRIP001 			//	(SetReference sollte dann auch nicht gerufen werden)
//STRIP001 
//STRIP001 			return;
//STRIP001 		}
//STRIP001 
//STRIP001 	UpdateActiveView();
//STRIP001 	if (!pTableView && !pTopView)
//STRIP001 		return; 							// z.B. FillMode
//STRIP001 
//STRIP001 	//	nie das "=" ueberschreiben!
//STRIP001 	EditView* pActiveView = pTopView ? pTopView : pTableView;
//STRIP001 	ESelection aSel = pActiveView->GetSelection();
//STRIP001 	aSel.Adjust();
//STRIP001 	if ( aSel.nStartPara == 0 && aSel.nStartPos == 0 )
//STRIP001 		return;
//STRIP001 
//STRIP001 	DataChanging(); 						// kann nicht neu sein
//STRIP001 
//STRIP001 			//	Selektion umdrehen, falls rueckwaerts (noetig ???)
//STRIP001 
//STRIP001 	if (pTableView)
//STRIP001 	{
//STRIP001 		ESelection aSel = pTableView->GetSelection();
//STRIP001 		if (aSel.nStartPos > aSel.nEndPos && aSel.nStartPara == aSel.nEndPara)
//STRIP001 		{
//STRIP001 			aSel.Adjust();
//STRIP001 			pTableView->SetSelection(aSel);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if (pTopView)
//STRIP001 	{
//STRIP001 		ESelection aSel = pTopView->GetSelection();
//STRIP001 		if (aSel.nStartPos > aSel.nEndPos && aSel.nStartPara == aSel.nEndPara)
//STRIP001 		{
//STRIP001 			aSel.Adjust();
//STRIP001 			pTopView->SetSelection(aSel);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//	String aus Referenz erzeugen
//STRIP001 
//STRIP001 	String aRefStr;
//STRIP001 	if (bOtherDoc)
//STRIP001 	{
//STRIP001 		//	Referenz auf anderes Dokument
//STRIP001 
//STRIP001 		DBG_ASSERT(rRef.aStart.Tab()==rRef.aEnd.Tab(), "nStartTab!=nEndTab");
//STRIP001 
//STRIP001 		String aTmp;
//STRIP001 		rRef.Format( aTmp, SCA_VALID|SCA_TAB_3D, pDoc );		// immer 3d
//STRIP001 
//STRIP001 		SfxObjectShell* pObjSh = pDoc->GetDocumentShell();
//STRIP001 		String aFileName = pObjSh->GetMedium()->GetName();
//STRIP001 
//STRIP001 		aRefStr = '\'';
//STRIP001 		aRefStr += aFileName;
//STRIP001 		aRefStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM( "'#" ));
//STRIP001 		aRefStr += aTmp;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( ( rRef.aStart.Tab() != aCursorPos.Tab() ||
//STRIP001 				rRef.aStart.Tab() != rRef.aEnd.Tab() ) && pDoc )
//STRIP001 			rRef.Format( aRefStr, SCA_VALID|SCA_TAB_3D, pDoc );
//STRIP001 		else
//STRIP001 			rRef.Format( aRefStr, SCA_VALID );
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pTableView || pTopView)
//STRIP001 	{
//STRIP001 		if (pTableView)
//STRIP001 			pTableView->InsertText( aRefStr, TRUE );
//STRIP001 		if (pTopView)
//STRIP001 			pTopView->InsertText( aRefStr, TRUE );
//STRIP001 
//STRIP001 		DataChanged();
//STRIP001 	}
//STRIP001 
//STRIP001 	bSelIsRef = TRUE;
//STRIP001 }

//STRIP001 void ScInputHandler::InsertFunction( const String& rFuncName, BOOL bAddPar )
//STRIP001 {
//STRIP001 	if ( eMode == SC_INPUT_NONE )
//STRIP001 	{
//STRIP001 		DBG_ERROR("InsertFunction, nicht im Eingabemodus");
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	UpdateActiveView();
//STRIP001 	if (!pTableView && !pTopView)
//STRIP001 		return; 							// z.B. FillMode
//STRIP001 
//STRIP001 	DataChanging(); 						// kann nicht neu sein
//STRIP001 
//STRIP001 	String aText = rFuncName;
//STRIP001 	if (bAddPar)
//STRIP001 		aText.AppendAscii(RTL_CONSTASCII_STRINGPARAM( "()" ));
//STRIP001 
//STRIP001 	if (pTableView)
//STRIP001 	{
//STRIP001 		pTableView->InsertText( aText, FALSE );
//STRIP001 		if (bAddPar)
//STRIP001 		{
//STRIP001 			ESelection aSel = pTableView->GetSelection();
//STRIP001 			--aSel.nStartPos;
//STRIP001 			--aSel.nEndPos;
//STRIP001 			pTableView->SetSelection(aSel);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if (pTopView)
//STRIP001 	{
//STRIP001 		pTopView->InsertText( aText, FALSE );
//STRIP001 		if (bAddPar)
//STRIP001 		{
//STRIP001 			ESelection aSel = pTopView->GetSelection();
//STRIP001 			--aSel.nStartPos;
//STRIP001 			--aSel.nEndPos;
//STRIP001 			pTopView->SetSelection(aSel);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	DataChanged();
//STRIP001 
//STRIP001 	if (bAddPar)
//STRIP001 		AutoParAdded();
//STRIP001 }

//STRIP001 void ScInputHandler::ClearText()
//STRIP001 {
//STRIP001 	if ( eMode == SC_INPUT_NONE )
//STRIP001 	{
//STRIP001 		DBG_ERROR("ClearText, nicht im Eingabemodus");
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	UpdateActiveView();
//STRIP001 	if (!pTableView && !pTopView)
//STRIP001 		return; 							// z.B. FillMode
//STRIP001 
//STRIP001 	DataChanging(); 						// darf nicht neu sein
//STRIP001 
//STRIP001 	String aEmpty;
//STRIP001 	if (pTableView)
//STRIP001 	{
//STRIP001 		pTableView->GetEditEngine()->SetText( aEmpty );
//STRIP001 		pTableView->SetSelection( ESelection(0,0, 0,0) );
//STRIP001 	}
//STRIP001 	if (pTopView)
//STRIP001 	{
//STRIP001 		pTopView->GetEditEngine()->SetText( aEmpty );
//STRIP001 		pTopView->SetSelection( ESelection(0,0, 0,0) );
//STRIP001 	}
//STRIP001 
//STRIP001 	DataChanged();
//STRIP001 }

//STRIP001 BOOL ScInputHandler::KeyInput( const KeyEvent& rKEvt, BOOL bStartEdit /* = FALSE */ )
//STRIP001 {
//STRIP001 	if (!bOptLoaded)
//STRIP001 	{
//STRIP001 		bAutoComplete = SC_MOD()->GetAppOptions().GetAutoComplete();
//STRIP001 		bOptLoaded = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	KeyCode aCode = rKEvt.GetKeyCode();
//STRIP001 	USHORT nModi  = aCode.GetModifier();
//STRIP001 	BOOL bShift   = aCode.IsShift();
//STRIP001 	BOOL bControl = aCode.IsMod1();
//STRIP001 	BOOL bAlt	  = aCode.IsMod2();
//STRIP001 	USHORT nCode  = aCode.GetCode();
//STRIP001 	sal_Unicode nChar = rKEvt.GetCharCode();
//STRIP001 
//STRIP001 	//	Alt-Return wird gebraucht, alle anderen Alt's und Ctrl-Tab nicht:
//STRIP001 #ifndef MAC
//STRIP001 	if (( bAlt && !bControl && nCode != KEY_RETURN ) ||
//STRIP001 			( bControl && aCode.GetCode() == KEY_TAB ))
//STRIP001 		return FALSE;
//STRIP001 #endif
//STRIP001 	//	auf'm Mac nicht, sonst werden druckbare Zeichen unterdrueckt
//STRIP001 
//STRIP001 	BOOL bInputLine = ( eMode==SC_INPUT_TOP );
//STRIP001 
//STRIP001 	BOOL bUsed = FALSE;
//STRIP001 	BOOL bSkip = FALSE;
//STRIP001 	BOOL bDoEnter = FALSE;
//STRIP001 
//STRIP001 	switch ( nCode )
//STRIP001 	{
//STRIP001 		case KEY_RETURN:
//STRIP001 			if (bControl && !bShift && !bInputLine)
//STRIP001 				bDoEnter = TRUE;
//STRIP001 			else if ( nModi == 0 && nTipVisible && pFormulaData && nAutoPos != SCPOS_INVALID )
//STRIP001 			{
//STRIP001 				PasteFunctionData();
//STRIP001 				bUsed = TRUE;
//STRIP001 			}
//STRIP001 			else if ( nModi == 0 && nTipVisible && aManualTip.Len() )
//STRIP001 			{
//STRIP001 				PasteManualTip();
//STRIP001 				bUsed = TRUE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				BYTE nMode = SC_ENTER_NORMAL;
//STRIP001 				if ( bShift && bControl )
//STRIP001 					nMode = SC_ENTER_MATRIX;
//STRIP001 				else if ( bAlt )
//STRIP001 					nMode = SC_ENTER_BLOCK;
//STRIP001 				EnterHandler( nMode );
//STRIP001 
//STRIP001 				if (pActiveViewSh)
//STRIP001 					pActiveViewSh->MoveCursorEnter( bShift && !bControl );
//STRIP001 
//STRIP001 				bUsed = TRUE;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case KEY_TAB:
//STRIP001 			if (!bControl && !bAlt)
//STRIP001 			{
//STRIP001 				if ( pFormulaData && nTipVisible && nAutoPos != SCPOS_INVALID )
//STRIP001 				{
//STRIP001 					//	blaettern
//STRIP001 
//STRIP001 					NextFormulaEntry( bShift );
//STRIP001 				}
//STRIP001 				else if ( pColumnData && bUseTab && nAutoPos != SCPOS_INVALID )
//STRIP001 				{
//STRIP001 					//	in den Eintraegen der AutoEingabe blaettern
//STRIP001 
//STRIP001 					NextAutoEntry( bShift );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					EnterHandler();
//STRIP001 
//STRIP001 					//	TabKeyInput gibt auf manchen Rechnern unter W95 Stackueberlaeufe,
//STRIP001 					//	darum direkter Aufruf:
//STRIP001 					if (pActiveViewSh)
//STRIP001 						pActiveViewSh->FindNextUnprot( bShift );
//STRIP001 				}
//STRIP001 				bUsed = TRUE;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case KEY_ESCAPE:
//STRIP001 			if ( nTipVisible )
//STRIP001 			{
//STRIP001 				HideTip();
//STRIP001 				bUsed = TRUE;
//STRIP001 			}
//STRIP001 			else if (eMode != SC_INPUT_NONE)
//STRIP001 			{
//STRIP001 				CancelHandler();
//STRIP001 				bUsed = TRUE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				bSkip = TRUE;
//STRIP001 			break;
//STRIP001 		case KEY_F2:
//STRIP001 			if ( !bShift && !bControl && !bAlt && eMode == SC_INPUT_TABLE )
//STRIP001 			{
//STRIP001 				eMode = SC_INPUT_TYPE;
//STRIP001 				bUsed = TRUE;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Cursortasten nur ausfuehren, wenn schon im Edit-Modus
//STRIP001 	//	z.B. wegen Shift-Ctrl-PageDn (ist nicht als Accelerator definiert)
//STRIP001 
//STRIP001 	BOOL bCursorKey = EditEngine::DoesKeyMoveCursor(rKEvt);
//STRIP001 	BOOL bInsKey = ( nCode == KEY_INSERT && !nModi );	// Insert wie Cursortasten behandeln
//STRIP001 	if ( !bUsed && !bSkip && ( bDoEnter || EditEngine::DoesKeyChangeText(rKEvt) ||
//STRIP001 					( eMode != SC_INPUT_NONE && ( bCursorKey || bInsKey ) ) ) )
//STRIP001 	{
//STRIP001 		HideTip();
//STRIP001 
//STRIP001 		if (bSelIsRef)
//STRIP001 		{
//STRIP001 			RemoveSelection();
//STRIP001 			bSelIsRef = FALSE;
//STRIP001 		}
//STRIP001 
//STRIP001 		UpdateActiveView();
//STRIP001 		BOOL bNewView = DataChanging( nChar );
//STRIP001 
//STRIP001 		if (bProtected)								// Zelle geschuetzt?
//STRIP001 			bUsed = TRUE;							// Key-Event nicht weiterleiten
//STRIP001 		else										// Aenderungen erlaubt
//STRIP001 		{
//STRIP001 			if (bNewView )							// neu anlegen
//STRIP001 			{
//STRIP001 				if (pActiveViewSh)
//STRIP001 					pActiveViewSh->GetViewData()->GetDocShell()->PostEditView( pEngine, aCursorPos );
//STRIP001 				UpdateActiveView();
//STRIP001 				if (eMode==SC_INPUT_NONE)
//STRIP001 					if (pTableView || pTopView)
//STRIP001 					{
//STRIP001 						String aStrLoP;
//STRIP001 
//STRIP001 						if ( bStartEdit && bCellHasPercentFormat && ((nChar >= '0' && nChar <= '9') || nChar == '-') )
//STRIP001 							aStrLoP = '%';
//STRIP001 
//STRIP001 						if (pTableView)
//STRIP001 						{
//STRIP001 							pTableView->GetEditEngine()->SetText( aStrLoP );
//STRIP001 							if ( aStrLoP.Len() )
//STRIP001 								pTableView->SetSelection( ESelection(0,0, 0,0) );	// before the '%'
//STRIP001 
//STRIP001 							// don't call SetSelection if the string is empty anyway,
//STRIP001 							// to avoid breaking the bInitial handling in ScViewData::EditGrowY
//STRIP001 						}
//STRIP001 						if (pTopView)
//STRIP001 						{
//STRIP001 							pTopView->GetEditEngine()->SetText( aStrLoP );
//STRIP001 							if ( aStrLoP.Len() )
//STRIP001 								pTopView->SetSelection( ESelection(0,0, 0,0) );		// before the '%'
//STRIP001 						}
//STRIP001 					}
//STRIP001 				SyncViews();
//STRIP001 			}
//STRIP001 
//STRIP001 			if (pTableView || pTopView)
//STRIP001 			{
//STRIP001 //				pActiveView->SetEditEngineUpdateMode(TRUE); 		//! gibt Muell !!!!
//STRIP001 
//STRIP001 				if (bDoEnter)
//STRIP001 				{
//STRIP001 					if (pTableView)
//STRIP001 						if( pTableView->PostKeyEvent( KeyEvent( CHAR_CR, KeyCode(KEY_RETURN) ) ) )
//STRIP001 							bUsed = TRUE;
//STRIP001 					if (pTopView)
//STRIP001 						if( pTopView->PostKeyEvent( KeyEvent( CHAR_CR, KeyCode(KEY_RETURN) ) ) )
//STRIP001 							bUsed = TRUE;
//STRIP001 				}
//STRIP001 				else if ( nAutoPar && nChar == ')' && CursorAtClosingPar() )
//STRIP001 				{
//STRIP001 					SkipClosingPar();
//STRIP001 					bUsed = TRUE;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if (pTableView)
//STRIP001 						if ( pTableView->PostKeyEvent( rKEvt ) )
//STRIP001 							bUsed = TRUE;
//STRIP001 					if (pTopView)
//STRIP001 						if ( pTopView->PostKeyEvent( rKEvt ) )
//STRIP001 							bUsed = TRUE;
//STRIP001 				}
//STRIP001 
//STRIP001 				//	Auto-Eingabe:
//STRIP001 
//STRIP001 				if ( bUsed && bAutoComplete )
//STRIP001 				{
//STRIP001 					bUseTab = FALSE;
//STRIP001 					nAutoPos = SCPOS_INVALID;						// nicht weitersuchen
//STRIP001 					if ( nChar && nChar != 8 && nChar != 127 )		// nicht BS und Delete
//STRIP001 					{
//STRIP001 						if (bFormulaMode)
//STRIP001 							UseFormulaData();
//STRIP001 						else
//STRIP001 							UseColData();
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				//	when the selection is changed manually or an opening parenthesis
//STRIP001 				//	is typed, stop overwriting parentheses
//STRIP001 				if ( bUsed && ( nChar == '(' || bCursorKey ) )
//STRIP001 					ResetAutoPar();
//STRIP001 
//STRIP001 				if ( KEY_INSERT == nCode )
//STRIP001 				{
//STRIP001 					SfxViewFrame* pViewFrm = SfxViewFrame::Current();
//STRIP001 					if (pViewFrm)
//STRIP001 						pViewFrm->GetBindings().Invalidate( SID_ATTR_INSERT );
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			DataChanged();				//	ruft auch UpdateParenthesis()
//STRIP001 			InvalidateAttribs();		//! in DataChanged ?
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pTopView && eMode != SC_INPUT_NONE)
//STRIP001 		SyncViews();
//STRIP001 
//STRIP001 	return bUsed;
//STRIP001 }

//STRIP001 BOOL ScInputHandler::InputCommand( const CommandEvent& rCEvt, BOOL bForce )
//STRIP001 {
//STRIP001 	BOOL bUsed = FALSE;
//STRIP001 
//STRIP001 	if ( rCEvt.GetCommand() == COMMAND_CURSORPOS )
//STRIP001 	{
//STRIP001 		//	#90346# for COMMAND_CURSORPOS, do as little as possible, because
//STRIP001 		//	with remote VCL, even a ShowCursor will generate another event.
//STRIP001 		if ( eMode != SC_INPUT_NONE )
//STRIP001 		{
//STRIP001 			UpdateActiveView();
//STRIP001 			if (pTableView || pTopView)
//STRIP001 			{
//STRIP001 				if (pTableView)
//STRIP001 					pTableView->Command( rCEvt );
//STRIP001 				else if (pTopView)						// call only once
//STRIP001 					pTopView->Command( rCEvt );
//STRIP001 				bUsed = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{	
//STRIP001 		if ( bForce || eMode != SC_INPUT_NONE )
//STRIP001 		{
//STRIP001 			if (!bOptLoaded)
//STRIP001 			{
//STRIP001 				bAutoComplete = SC_MOD()->GetAppOptions().GetAutoComplete();
//STRIP001 				bOptLoaded = TRUE;
//STRIP001 			}
//STRIP001 
//STRIP001 			HideTip();
//STRIP001 
//STRIP001 			if ( bSelIsRef )
//STRIP001 			{
//STRIP001 				RemoveSelection();
//STRIP001 				bSelIsRef = FALSE;
//STRIP001 			}
//STRIP001 
//STRIP001 			UpdateActiveView();
//STRIP001 			BOOL bNewView = DataChanging( 0, TRUE );
//STRIP001 
//STRIP001 			if (bProtected)								// cell protected
//STRIP001 				bUsed = TRUE;							// event is used
//STRIP001 			else										// changes allowed
//STRIP001 			{
//STRIP001 				if (bNewView)							// create new edit view
//STRIP001 				{
//STRIP001 					if (pActiveViewSh)
//STRIP001 						pActiveViewSh->GetViewData()->GetDocShell()->PostEditView( pEngine, aCursorPos );
//STRIP001 					UpdateActiveView();
//STRIP001 					if (eMode==SC_INPUT_NONE)
//STRIP001 						if (pTableView || pTopView)
//STRIP001 						{
//STRIP001 							String aStrLoP;
//STRIP001 							if (pTableView)
//STRIP001 							{
//STRIP001 								pTableView->GetEditEngine()->SetText( aStrLoP );
//STRIP001 								pTableView->SetSelection( ESelection(0,0, 0,0) );
//STRIP001 							}
//STRIP001 							if (pTopView)
//STRIP001 							{
//STRIP001 								pTopView->GetEditEngine()->SetText( aStrLoP );
//STRIP001 								pTopView->SetSelection( ESelection(0,0, 0,0) );
//STRIP001 							}
//STRIP001 						}
//STRIP001 					SyncViews();
//STRIP001 				}
//STRIP001 
//STRIP001 				if (pTableView || pTopView)
//STRIP001 				{
//STRIP001 					if (pTableView)
//STRIP001 						pTableView->Command( rCEvt );
//STRIP001 					if (pTopView)
//STRIP001 						pTopView->Command( rCEvt );
//STRIP001 
//STRIP001 					bUsed = TRUE;
//STRIP001 
//STRIP001 					if ( rCEvt.GetCommand() == COMMAND_ENDEXTTEXTINPUT )
//STRIP001 					{
//STRIP001 						//	AutoInput after ext text input
//STRIP001 
//STRIP001 						nAutoPos = SCPOS_INVALID;
//STRIP001 						if (bFormulaMode)
//STRIP001 							UseFormulaData();
//STRIP001 						else
//STRIP001 							UseColData();
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				DataChanged();				//	calls UpdateParenthesis()
//STRIP001 				InvalidateAttribs();		//! in DataChanged ?
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if (pTopView && eMode != SC_INPUT_NONE)
//STRIP001 			SyncViews();
//STRIP001 	}
//STRIP001 
//STRIP001 	return bUsed;
//STRIP001 }

/*N*/ void ScInputHandler::NotifyChange( const ScInputHdlState* pState,
/*N*/ 								   BOOL bForce, ScTabViewShell* pSourceSh,
/*N*/                                    BOOL bStopEditing)
/*N*/ {
/*N*/ 	//	#62806# Wenn der Aufruf aus einem Makro-Aufruf im EnterHandler kommt,
/*N*/ 	//	gleich abbrechen und nicht den Status durcheinander bringen
/*N*/ 	if (bInEnterHandler)
/*N*/ 		return;
/*N*/ 
/*N*/ 	BOOL bRepeat = (pState == pLastState);
/*N*/ 	if (!bRepeat && pState && pLastState)
/*?*/ 	{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	bRepeat = (*pState == *pLastState);
/*N*/ 	if (bRepeat && !bForce)
/*N*/ 		return;
/*N*/ 
/*N*/ 	bInOwnChange = TRUE;				// disable ModifyHdl (reset below)
/*N*/ 
/*N*/ 	if ( pState && !pLastState )		// wieder enablen
/*N*/ 		bForce = TRUE;
/*N*/ 
/*N*/ 	BOOL bHadObject = pLastState && pLastState->GetEditData();
/*N*/ 
/*N*/ 	//! Before EditEngine gets eventually created (so it gets the right pools)
/*N*/ 	if ( pSourceSh )
/*N*/ 		pActiveViewSh = pSourceSh;
/*N*/ 	else
/*?*/ 		pActiveViewSh = PTR_CAST(ScTabViewShell, SfxViewShell::Current());
/*N*/ 
/*N*/ 	ImplCreateEditEngine();
/*N*/ 
/*N*/ 	if ( pState != pLastState )
/*N*/ 	{
/*N*/ 		delete pLastState;
/*N*/ 		pLastState = pState ? new ScInputHdlState( *pState ) : NULL;
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( pState && pActiveViewSh )
/*N*/ 	{
/*N*/ 		ScModule* pScMod = SC_MOD();
/*N*/ 
/*N*/ 		if ( pState )
/*N*/ 		{
/*N*/ 			BOOL bIgnore = FALSE;
/*N*/ 
/*N*/ 			//	hier auch fremde Referenzeingabe beruecksichtigen (z.B. Funktions-AP),
/*N*/ 			//	FormEditData falls gerade von der Hilfe auf Calc umgeschaltet wird:
/*N*/ 
/*N*/ 			if ( !bFormulaMode && !pScMod->IsFormulaMode() && !pScMod->GetFormEditData() )
/*N*/ 			{
/*N*/ 				if ( bModified )
/*N*/ 				{
/*?*/ 					if (pState->GetPos() != aCursorPos)
/*?*/ 					{
/*?*/ 						if (!bProtected)
/*?*/ 							EnterHandler();
/*?*/ 					}
/*?*/ 					else
/*?*/ 						bIgnore = TRUE;
/*N*/ 				}
/*N*/ 
/*N*/ 				if ( !bIgnore /* || bRepeat */ )
/*N*/ 				{
/*N*/ 					const ScAddress& 		rSPos	= pState->GetStartPos();
/*N*/ 					const ScAddress& 		rEPos	= pState->GetEndPos();
/*N*/ 					const EditTextObject*	pData	= pState->GetEditData();
/*N*/ 					String					aString = pState->GetString();
/*N*/ 					BOOL					bTxtMod = FALSE;
/*N*/ 
/*N*/ 					aCursorPos	= pState->GetPos();
/*N*/ 
/*N*/ 					if ( pData /* || bRepeat */ )
/*?*/ 						bTxtMod = TRUE;
/*N*/ 					else if ( bHadObject )
/*?*/ 						bTxtMod = TRUE;
/*N*/ 					else if ( bTextValid )
/*N*/ 						bTxtMod = ( aString != aCurrentText );
/*N*/ 					else
/*?*/ 						bTxtMod = ( aString != GetEditText(pEngine) );
/*N*/ 
/*N*/ 					if ( bTxtMod || bForce )
/*N*/ 					{
/*N*/ 						if (pData)
/*N*/ 						{
/*?*/ 							pEngine->SetText( *pData );
/*?*/ 							aString = GetEditText(pEngine);
/*?*/ 							lcl_RemoveTabs(aString);
/*?*/ 							bTextValid = FALSE;
/*?*/ 							aCurrentText.Erase();
/*N*/ 						}
/*N*/ 						else
/*N*/ 						{
/*N*/ 							aCurrentText = aString;
/*N*/ 							bTextValid = TRUE;				//! erst nur als String merken
/*N*/ 						}
/*N*/ 
/*N*/ 						if ( pInputWin )
/*?*/ 						{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	pInputWin->SetTextString(aString);
/*N*/ 					}
/*N*/ 
/*N*/ 					if ( pInputWin )						// Bereichsanzeige
/*N*/ 					{
/*?*/ 						DBG_BF_ASSERT(0, "STRIP"); //STRIP001 String aPosStr;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						//	Ist der Bereich ein Name?
//STRIP001 /*?*/ 						//!	per Timer suchen ???
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if ( pActiveViewSh )
//STRIP001 /*?*/ 							pActiveViewSh->GetViewData()->GetDocument()->
//STRIP001 /*?*/ 								GetRangeAtBlock( ScRange( rSPos, rEPos ), &aPosStr );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if ( !aPosStr.Len() )			// kein Name -> formatieren
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							if ( rSPos != rEPos )
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								String aStr;
//STRIP001 /*?*/ 								rSPos.Format( aPosStr, SCA_VALID );
//STRIP001 /*?*/ 								aPosStr += ':';
//STRIP001 /*?*/ 								rEPos.Format( aStr, SCA_VALID );
//STRIP001 /*?*/ 								aPosStr += aStr;
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 							else
//STRIP001 /*?*/ 								aCursorPos.Format( aPosStr, SCA_VALID );
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						pInputWin->SetPosString(aPosStr);
//STRIP001 /*?*/ 						pInputWin->SetSumAssignMode();
/*N*/ 					}
/*N*/ 
/*N*/                     if (bStopEditing)
/*N*/ 					    SFX_APP()->Broadcast( SfxSimpleHint( FID_KILLEDITVIEW ) );
/*N*/ 
/*N*/ 					//	As long as the content is not edited, turn off online spelling.
/*N*/ 					//	Online spelling is turned back on in StartTable, after setting
/*N*/ 					//	the right language from cell attributes.
/*N*/ 
/*N*/ 					ULONG nCntrl = pEngine->GetControlWord();
/*N*/ 					if ( nCntrl & EE_CNTRL_ONLINESPELLING )
/*?*/ 						pEngine->SetControlWord( nCntrl & ~EE_CNTRL_ONLINESPELLING );
/*N*/ 
/*N*/ 					bModified = FALSE;
/*N*/ 					bSelIsRef = FALSE;
/*N*/ 					bProtected = FALSE;
/*M*/ 					bCommandErrorShown = FALSE;
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ //		bProtected = FALSE;
/*N*/ 
/*N*/ 		if ( pInputWin)
/*N*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if(!pScMod->IsFormulaMode()&& !pScMod->IsRefDialogOpen())	//BugID 54702
//STRIP001 /*?*/ 			{															//Wenn RefDialog offen, dann nicht enablen
//STRIP001 /*?*/ 				if ( !pInputWin->IsEnabled())
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					pInputWin->Enable();
//STRIP001 /*?*/ 					if(pDelayTimer )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						DELETEZ( pDelayTimer );
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else if(pScMod->IsRefDialogOpen())
//STRIP001 /*?*/ 			{									// Da jedes Dokument eigenes InputWin hat, sollte
//STRIP001 /*?*/ 				if ( !pDelayTimer )				// nochmals Timer gestartet werden, da sonst Ein-
//STRIP001 /*?*/ 				{								// gabezeile evt. noch aktiv ist.
//STRIP001 /*?*/ 					pDelayTimer = new Timer;
//STRIP001 /*?*/ 					pDelayTimer->SetTimeout( 500 ); // 100ms Verzoegerung
//STRIP001 /*?*/ 					pDelayTimer->SetTimeoutHdl( LINK( this, ScInputHandler, DelayTimer ) );
//STRIP001 /*?*/ 					pDelayTimer->Start();
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 	else // !pState || !pActiveViewSh
/*N*/ 	{
/*?*/ 		if ( !pDelayTimer )
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDelayTimer = new Timer;
//STRIP001 /*?*/ 			pDelayTimer->SetTimeout( 500 ); // 100ms Verzoegerung
//STRIP001 /*?*/ 			pDelayTimer->SetTimeoutHdl( LINK( this, ScInputHandler, DelayTimer ) );
//STRIP001 /*?*/ 			pDelayTimer->Start();
/*?*/ 		}
/*?*/ 	}
/*N*/ 
/*N*/ 	HideTip();
/*N*/ 	bInOwnChange = FALSE;
/*N*/ }

//STRIP001 void ScInputHandler::ResetDelayTimer()
//STRIP001 {
//STRIP001 	if(pDelayTimer!=NULL)
//STRIP001 	{
//STRIP001 		DELETEZ( pDelayTimer );
//STRIP001 
//STRIP001 		if ( pInputWin)
//STRIP001 		{
//STRIP001 			pInputWin->Enable();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 IMPL_LINK( ScInputHandler, DelayTimer, Timer*, pTimer )
//STRIP001 {
//STRIP001 	if ( pTimer == pDelayTimer )
//STRIP001 	{
//STRIP001 		DELETEZ( pDelayTimer );
//STRIP001 
//STRIP001 		if ( NULL == pLastState || SC_MOD()->IsFormulaMode() || SC_MOD()->IsRefDialogOpen())
//STRIP001 		{
//STRIP001 			//!	new method at ScModule to query if function autopilot is open
//STRIP001 
//STRIP001 			SfxViewFrame* pViewFrm = SfxViewFrame::Current();
//STRIP001 			if ( pViewFrm && pViewFrm->GetChildWindow( SID_OPENDLG_FUNCTION ) )
//STRIP001 			{
//STRIP001 				if ( pInputWin)
//STRIP001 				{
//STRIP001 					pInputWin->EnableButtons( FALSE );
//STRIP001 					pInputWin->Disable();
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else if ( !bFormulaMode )	// #39210# Formel auch z.B. bei Hilfe behalten
//STRIP001 			{
//STRIP001 				bInOwnChange = TRUE;	// disable ModifyHdl (reset below)
//STRIP001 
//STRIP001 				pActiveViewSh = NULL;
//STRIP001 				pEngine->SetText( EMPTY_STRING );
//STRIP001 				if ( pInputWin )
//STRIP001 				{
//STRIP001 					pInputWin->SetPosString( EMPTY_STRING );
//STRIP001 					pInputWin->SetTextString( EMPTY_STRING );
//STRIP001 					pInputWin->Disable();
//STRIP001 				}
//STRIP001 
//STRIP001 				bInOwnChange = FALSE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 void ScInputHandler::InputSelection( EditView* pView )
//STRIP001 {
//STRIP001 	SyncViews( pView );
//STRIP001 
//STRIP001 	UpdateParenthesis();	//	Selektion geaendert -> Klammer-Hervorhebung neu
//STRIP001 
//STRIP001 	//	when the selection is changed manually, stop overwriting parentheses
//STRIP001 	ResetAutoPar();
//STRIP001 }

//STRIP001 void ScInputHandler::InputChanged( EditView* pView )
//STRIP001 {
//STRIP001 	ESelection aSelection = pView->GetSelection();
//STRIP001 
//STRIP001 	UpdateActiveView();
//STRIP001 
//STRIP001 	BOOL bNewView = DataChanging();						//!	kann das hier ueberhaupt sein?
//STRIP001 	aCurrentText = pView->GetEditEngine()->GetText();	// auch den String merken
//STRIP001 	pEngine->SetText( aCurrentText );
//STRIP001 	DataChanged();
//STRIP001 	bTextValid = TRUE;		// wird in DataChanged auf FALSE gesetzt
//STRIP001 
//STRIP001 	if ( pActiveViewSh )
//STRIP001 	{
//STRIP001 		ScViewData* pViewData = pActiveViewSh->GetViewData();
//STRIP001 		if ( bNewView )
//STRIP001 			pViewData->GetDocShell()->PostEditView( pEngine, aCursorPos );
//STRIP001 
//STRIP001 		pViewData->EditGrowY();
//STRIP001 		pViewData->EditGrowX();
//STRIP001 	}
//STRIP001 
//STRIP001 	SyncViews( pView );
//STRIP001 }

//STRIP001 const String& ScInputHandler::GetEditString()
//STRIP001 {
//STRIP001 	if (pEngine)
//STRIP001 	{
//STRIP001 		aCurrentText = pEngine->GetText();		// immer neu aus Engine
//STRIP001 		bTextValid = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return aCurrentText;
//STRIP001 }

//STRIP001 Size ScInputHandler::GetTextSize()
//STRIP001 {
//STRIP001 	Size aSize;
//STRIP001 	if ( pEngine )
//STRIP001 		aSize = Size( pEngine->CalcTextWidth(), pEngine->GetTextHeight() );
//STRIP001 
//STRIP001 	return aSize;
//STRIP001 }

//STRIP001 BOOL ScInputHandler::GetTextAndFields( ScEditEngineDefaulter& rDestEngine )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	if (pEngine)
//STRIP001 	{
//STRIP001 		//	Feldbefehle enthalten?
//STRIP001 
//STRIP001 		USHORT nParCnt = pEngine->GetParagraphCount();
//STRIP001 		SfxItemSet aSet = pEngine->GetAttribs( ESelection(0,0,nParCnt,0) );
//STRIP001 		SfxItemState eFieldState = aSet.GetItemState( EE_FEATURE_FIELD, FALSE );
//STRIP001 		if ( eFieldState == SFX_ITEM_DONTCARE || eFieldState == SFX_ITEM_SET )
//STRIP001 		{
//STRIP001 			//	Inhalt kopieren
//STRIP001 
//STRIP001 			EditTextObject* pObj = pEngine->CreateTextObject();
//STRIP001 			rDestEngine.SetText(*pObj);
//STRIP001 			delete pObj;
//STRIP001 
//STRIP001 			//	Attribute loeschen
//STRIP001 
//STRIP001 			for (USHORT i=0; i<nParCnt; i++)
//STRIP001 				rDestEngine.QuickRemoveCharAttribs( i );
//STRIP001 
//STRIP001 			//	Absaetze zusammenfassen
//STRIP001 
//STRIP001 			while ( nParCnt > 1 )
//STRIP001 			{
//STRIP001 				xub_StrLen nLen = rDestEngine.GetTextLen( (USHORT)0 );
//STRIP001 				ESelection aSel( 0,nLen, 1,0 );
//STRIP001 				rDestEngine.QuickInsertText( ' ', aSel );		// Umbruch durch Space ersetzen
//STRIP001 				--nParCnt;
//STRIP001 			}
//STRIP001 
//STRIP001 			bRet = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }


//------------------------------------------------------------------------
// Methoden fuer FunktionsAutopiloten:
// InputGetSelection, InputSetSelection, InputReplaceSelection, InputGetFormulaStr
//------------------------------------------------------------------------

//STRIP001 void ScInputHandler::InputGetSelection( xub_StrLen& rStart, xub_StrLen& rEnd )
//STRIP001 {
//STRIP001 	rStart = nFormSelStart;
//STRIP001 	rEnd = nFormSelEnd;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 EditView* ScInputHandler::GetFuncEditView()
//STRIP001 {
//STRIP001 	UpdateActiveView();		// wegen pTableView
//STRIP001 
//STRIP001 	EditView* pView = NULL;
//STRIP001 	if ( pInputWin )
//STRIP001 	{
//STRIP001 		pInputWin->MakeDialogEditView();
//STRIP001 		pView = pInputWin->GetEditView();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( eMode != SC_INPUT_TABLE )
//STRIP001 		{
//STRIP001 			bCreatingFuncView = TRUE;		// RangeFinder nicht anzeigen
//STRIP001 			SetMode( SC_INPUT_TABLE );
//STRIP001 			bCreatingFuncView = FALSE;
//STRIP001 			if ( pTableView )
//STRIP001 				pTableView->GetEditEngine()->SetText( EMPTY_STRING );
//STRIP001 		}
//STRIP001 		pView = pTableView;
//STRIP001 	}
//STRIP001 
//STRIP001 	return pView;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScInputHandler::InputSetSelection( xub_StrLen nStart, xub_StrLen nEnd )
//STRIP001 {
//STRIP001 	if ( nStart <= nEnd )
//STRIP001 	{
//STRIP001 		nFormSelStart = nStart;
//STRIP001 		nFormSelEnd = nEnd;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nFormSelEnd = nStart;
//STRIP001 		nFormSelStart = nEnd;
//STRIP001 	}
//STRIP001 
//STRIP001 	EditView* pView = GetFuncEditView();
//STRIP001 	if (pView)
//STRIP001 		pView->SetSelection( ESelection(0,nStart, 0,nEnd) );
//STRIP001 
//STRIP001 	bModified = TRUE;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScInputHandler::InputReplaceSelection( const String& rStr )
//STRIP001 {
//STRIP001 	if (!pRefViewSh)
//STRIP001 		pRefViewSh = pActiveViewSh;
//STRIP001 
//STRIP001 	DBG_ASSERT(nFormSelEnd>=nFormSelStart,"Selektion kaputt...");
//STRIP001 
//STRIP001 	xub_StrLen nOldLen = nFormSelEnd-nFormSelStart;
//STRIP001 	xub_StrLen nNewLen = rStr.Len();
//STRIP001 	if (nOldLen)
//STRIP001 		aFormText.Erase( nFormSelStart, nOldLen );
//STRIP001 	if (nNewLen)
//STRIP001 		aFormText.Insert( rStr, nFormSelStart );
//STRIP001 	nFormSelEnd = nFormSelStart + nNewLen;
//STRIP001 
//STRIP001 	EditView* pView = GetFuncEditView();
//STRIP001 	if (pView)
//STRIP001 	{
//STRIP001 		pView->SetEditEngineUpdateMode( FALSE );
//STRIP001 //		pView->InsertText( rStr, TRUE );
//STRIP001 		pView->GetEditEngine()->SetText( aFormText );
//STRIP001 		pView->SetSelection( ESelection(0,nFormSelStart, 0,nFormSelEnd) );
//STRIP001 		pView->SetEditEngineUpdateMode( TRUE );
//STRIP001 	}
//STRIP001 	bModified = TRUE;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 String ScInputHandler::InputGetFormulaStr()
//STRIP001 {
//STRIP001 	return aFormText;	//!	eigene Membervariable?
//STRIP001 }

//========================================================================
//	ScInputHdlState
//========================================================================

/*N*/ ScInputHdlState::ScInputHdlState( const ScAddress& rCurPos,
/*N*/ 								  const ScAddress& rStartPos,
/*N*/ 								  const ScAddress& rEndPos,
/*N*/ 								  const String& rString,
/*N*/ 								  const EditTextObject* pData )
/*N*/ 	:   aCursorPos	( rCurPos ),
/*N*/ 		aStartPos	( rStartPos ),
/*N*/ 		aEndPos		( rEndPos ),
/*N*/ 		aString		( rString ),
/*N*/ 		pEditData	( pData ? pData->Clone() : NULL )
/*N*/ {
/*N*/ }

//------------------------------------------------------------------------

/*N*/ ScInputHdlState::ScInputHdlState( const ScInputHdlState& rCpy )
/*N*/ 	:	pEditData	( NULL )
/*N*/ {
/*N*/ 	*this = rCpy;
/*N*/ }
/*N*/ 
/*N*/ //------------------------------------------------------------------------
/*N*/ 
/*N*/ ScInputHdlState::~ScInputHdlState()
/*N*/ {
/*N*/ 	delete pEditData;
/*N*/ }
/*N*/ 
/*N*/ //------------------------------------------------------------------------
//STRIP001 
//STRIP001 int ScInputHdlState::operator==( const ScInputHdlState& r ) const
//STRIP001 {
//STRIP001 	return (    (aStartPos 	== r.aStartPos)
//STRIP001 			 &&	(aEndPos   	== r.aEndPos)
//STRIP001 			 &&	(aCursorPos == r.aCursorPos)
//STRIP001 			 && (aString   	== r.aString)
//STRIP001 			 && ScGlobal::EETextObjEqual( pEditData, r.pEditData ) );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
/*N*/ ScInputHdlState& ScInputHdlState::operator=( const ScInputHdlState& r )
/*N*/ {
/*N*/ 	delete pEditData;
/*N*/ 
/*N*/ 	aCursorPos	= r.aCursorPos;
/*N*/ 	aStartPos	= r.aStartPos;
/*N*/ 	aEndPos		= r.aEndPos;
/*N*/ 	aString		= r.aString;
/*N*/ 	pEditData	= r.pEditData ? r.pEditData->Clone() : NULL;
/*N*/ 
/*N*/ 	return *this;
/*N*/ }




}
