/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_sfiltdlg.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:02:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// System - Includes ---------------------------------------------------------

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE -------------------------------------------------------------------

// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif

// auto strip #include "uiitems.hxx"
// auto strip #include "rangenam.hxx"
// auto strip #include "dbcolect.hxx"
// auto strip #include "reffact.hxx"
// auto strip #include "viewdata.hxx"
// auto strip #include "document.hxx"
// auto strip #include "scresid.hxx"

// auto strip #include "foptmgr.hxx"

#include "globstr.hrc"
#include "filter.hrc"

#define _SFILTDLG_CXX
// auto strip #include "filtdlg.hxx"
#undef _SFILTDLG_CXX

// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
namespace binfilter {

// DEFINE --------------------------------------------------------------------

#define ERRORBOX(rid) ErrorBox( this, WinBits( WB_OK|WB_DEF_OK),\
				 	   			ScGlobal::GetRscString(rid) ).Execute()


//============================================================================
//	class ScSpecialFilterDialog

//----------------------------------------------------------------------------

//STRIP001 ScSpecialFilterDlg::ScSpecialFilterDlg( SfxBindings* pB, SfxChildWindow* pCW, Window* pParent,
//STRIP001 										const SfxItemSet&	rArgSet )
//STRIP001 
//STRIP001 	:	ScAnyRefDlg	( pB, pCW, pParent, RID_SCDLG_SPEC_FILTER ),
//STRIP001 		//
//STRIP001 		_INIT_COMMON_FILTER_RSCOBJS
//STRIP001 		//
//STRIP001 		aLbFilterArea	( this, ScResId( LB_CRITERIA_AREA ) ),
//STRIP001 		aFtFilterArea	( this, ScResId( FT_CRITERIA_AREA ) ),
//STRIP001 		aEdFilterArea	( this, ScResId( ED_CRITERIA_AREA ) ),
//STRIP001 		aRbFilterArea	( this, ScResId( RB_CRITERIA_AREA ), &aEdFilterArea ),
//STRIP001 		//
//STRIP001 		nWhichQuery		( rArgSet.GetPool()->GetWhich( SID_QUERY ) ),
//STRIP001 		theQueryData	( ((const ScQueryItem&)
//STRIP001 						   rArgSet.Get( nWhichQuery )).GetQueryData() ),
//STRIP001 		pOutItem		( NULL ),
//STRIP001 		pOptionsMgr		( NULL ),
//STRIP001 		pViewData		( NULL ),
//STRIP001 		pDoc			( NULL ),
//STRIP001 		pRefInputEdit	( NULL ),
//STRIP001 		bRefInputMode	( FALSE ),
//STRIP001 		pTimer			( NULL )
//STRIP001 {
//STRIP001 	Init( rArgSet );
//STRIP001 	aEdFilterArea.GrabFocus();
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// Hack: RefInput-Kontrolle
//STRIP001 	pTimer = new Timer;
//STRIP001 	pTimer->SetTimeout( 50 ); // 50ms warten
//STRIP001 	pTimer->SetTimeoutHdl( LINK( this, ScSpecialFilterDlg, TimeOutHdl ) );
//STRIP001 	pTimer->Start();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 __EXPORT ScSpecialFilterDlg::~ScSpecialFilterDlg()
//STRIP001 {
//STRIP001 	USHORT nEntries = aLbFilterArea.GetEntryCount();
//STRIP001 	USHORT i;
//STRIP001 
//STRIP001 	for ( i=1; i<nEntries; i++ )
//STRIP001 		delete (String*)aLbFilterArea.GetEntryData( i );
//STRIP001 
//STRIP001 	delete pOptionsMgr;
//STRIP001 
//STRIP001 	if ( pOutItem )
//STRIP001 		delete pOutItem;
//STRIP001 
//STRIP001 	// Hack: RefInput-Kontrolle
//STRIP001 	pTimer->Stop();
//STRIP001 	delete pTimer;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScSpecialFilterDlg::Init( const SfxItemSet& rArgSet )
//STRIP001 {
//STRIP001 	const ScQueryItem& rQueryItem = (const ScQueryItem&)
//STRIP001 									rArgSet.Get( nWhichQuery );
//STRIP001 
//STRIP001 	aBtnOk.SetClickHdl			( LINK( this, ScSpecialFilterDlg, EndDlgHdl ) );
//STRIP001 	aBtnCancel.SetClickHdl		( LINK( this, ScSpecialFilterDlg, EndDlgHdl ) );
//STRIP001 	aLbFilterArea.SetSelectHdl	( LINK( this, ScSpecialFilterDlg, FilterAreaSelHdl ) );
//STRIP001 	aEdFilterArea.SetModifyHdl	( LINK( this, ScSpecialFilterDlg, FilterAreaModHdl ) );
//STRIP001 
//STRIP001 	pViewData 	= rQueryItem.GetViewData();
//STRIP001 	pDoc	  	= pViewData ? pViewData->GetDocument()  : NULL;
//STRIP001 
//STRIP001 	aEdFilterArea.SetText( EMPTY_STRING );		// may be overwritten below
//STRIP001 
//STRIP001 	if ( pViewData && pDoc )
//STRIP001 	{
//STRIP001 		if(pDoc->GetChangeTrack()!=NULL) aBtnCopyResult.Disable();
//STRIP001 
//STRIP001 		ScRangeName*	pRangeNames	= pDoc->GetRangeName();
//STRIP001 		const USHORT	nCount 		= pRangeNames ? pRangeNames->GetCount() : 0;
//STRIP001 
//STRIP001 		/*
//STRIP001 		 * Aus den RangeNames des Dokumentes werden nun die
//STRIP001 		 * gemerkt, bei denen es sich um Filter-Bereiche handelt
//STRIP001 		 */
//STRIP001 
//STRIP001 		aLbFilterArea.Clear();
//STRIP001 		aLbFilterArea.InsertEntry( aStrUndefined, 0 );
//STRIP001 
//STRIP001 		if ( nCount > 0 )
//STRIP001 		{
//STRIP001 			String		 aString;
//STRIP001 			ScRangeData* pData = NULL;
//STRIP001 			USHORT		 nInsert = 0;
//STRIP001 
//STRIP001 			for ( USHORT i=0; i<nCount; i++ )
//STRIP001 			{
//STRIP001 				pData = (ScRangeData*)(pRangeNames->At( i ));
//STRIP001 				if ( pData )
//STRIP001 				{
//STRIP001 					if ( pData->HasType( RT_CRITERIA ) )
//STRIP001 					{
//STRIP001 						pData->GetName( aString );
//STRIP001 						nInsert = aLbFilterArea.InsertEntry( aString );
//STRIP001 						pData->GetSymbol( aString );
//STRIP001 						aLbFilterArea.SetEntryData( nInsert,
//STRIP001 													new String( aString ) );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		//	is there a stored source range?
//STRIP001 
//STRIP001 		ScRange aAdvSource;
//STRIP001 		if (rQueryItem.GetAdvancedQuerySource(aAdvSource))
//STRIP001 		{
//STRIP001 			String aRefStr;
//STRIP001 			aAdvSource.Format( aRefStr, SCR_ABS_3D, pDoc );
//STRIP001 			aEdFilterArea.SetRefString( aRefStr );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	aLbFilterArea.SelectEntryPos( 0 );
//STRIP001 
//STRIP001 	// Optionen initialisieren lassen:
//STRIP001 
//STRIP001 	pOptionsMgr	 = new ScFilterOptionsMgr(
//STRIP001 							this,
//STRIP001 							pViewData,
//STRIP001 							theQueryData,
//STRIP001 							aBtnMore,
//STRIP001 							aBtnCase,
//STRIP001 							aBtnRegExp,
//STRIP001 							aBtnHeader,
//STRIP001 							aBtnUnique,
//STRIP001 							aBtnCopyResult,
//STRIP001 							aBtnDestPers,
//STRIP001 							aLbCopyArea,
//STRIP001 							aEdCopyArea,
//STRIP001 							aRbCopyArea,
//STRIP001 							aFtDbAreaLabel,
//STRIP001 							aFtDbArea,
//STRIP001                             aFlOptions,
//STRIP001 							aStrNoName,
//STRIP001 							aStrUndefined );
//STRIP001 
//STRIP001 	//	#35206# Spezialfilter braucht immer Spaltenkoepfe
//STRIP001 	aBtnHeader.Check(TRUE);
//STRIP001 	aBtnHeader.Disable();
//STRIP001 
//STRIP001 	// Modal-Modus einschalten
//STRIP001 //	SetDispatcherLock( TRUE );
//STRIP001 	//@BugID 54702 Enablen/Disablen nur noch in Basisklasse
//STRIP001 	//SFX_APPWINDOW->Disable(FALSE);		//! allgemeine Methode im ScAnyRefDlg
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL __EXPORT ScSpecialFilterDlg::Close()
//STRIP001 {
//STRIP001 	return DoClose( ScSpecialFilterDlgWrapper::GetChildWindowId() );
//STRIP001 }


//----------------------------------------------------------------------------
// Uebergabe eines mit der Maus selektierten Tabellenbereiches, der dann als
// neue Selektion im Referenz-Edit angezeigt wird.

//STRIP001 void ScSpecialFilterDlg::SetReference( const ScRange& rRef, ScDocument* pDoc )
//STRIP001 {
//STRIP001 	if ( bRefInputMode && pRefInputEdit )		// Nur moeglich, wenn im Referenz-Editmodus
//STRIP001 	{
//STRIP001 		if ( rRef.aStart != rRef.aEnd )
//STRIP001 			RefInputStart( pRefInputEdit );
//STRIP001 
//STRIP001 		String aRefStr;
//STRIP001 
//STRIP001 		if ( pRefInputEdit == &aEdCopyArea)
//STRIP001 			rRef.aStart.Format( aRefStr, SCA_ABS_3D, pDoc );
//STRIP001 		else if ( pRefInputEdit == &aEdFilterArea)
//STRIP001 			rRef.Format( aRefStr, SCR_ABS_3D, pDoc );
//STRIP001 
//STRIP001 		pRefInputEdit->SetRefString( aRefStr );
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScSpecialFilterDlg::SetActive()
//STRIP001 {
//STRIP001 	if ( bRefInputMode )
//STRIP001 	{
//STRIP001 		if ( pRefInputEdit == &aEdCopyArea )
//STRIP001 		{
//STRIP001 			aEdCopyArea.GrabFocus();
//STRIP001 			if ( aEdCopyArea.GetModifyHdl().IsSet() )
//STRIP001 				((Link&)aEdCopyArea.GetModifyHdl()).Call( &aEdCopyArea );
//STRIP001 		}
//STRIP001 		else if ( pRefInputEdit == &aEdFilterArea )
//STRIP001 		{
//STRIP001 			aEdFilterArea.GrabFocus();
//STRIP001 			FilterAreaModHdl( &aEdFilterArea );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		GrabFocus();
//STRIP001 
//STRIP001 	RefInputDone();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 ScQueryItem* ScSpecialFilterDlg::GetOutputItem( const ScQueryParam& rParam,
//STRIP001 												const ScRange& rSource )
//STRIP001 {
//STRIP001 	if ( pOutItem ) DELETEZ( pOutItem );
//STRIP001 	pOutItem = new ScQueryItem( nWhichQuery, &rParam );
//STRIP001 	pOutItem->SetAdvancedQuerySource( &rSource );
//STRIP001 
//STRIP001 	return pOutItem;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL ScSpecialFilterDlg::IsRefInputMode() const
//STRIP001 {
//STRIP001 	return bRefInputMode;
//STRIP001 }


//----------------------------------------------------------------------------
// Handler:
// ========

//STRIP001 IMPL_LINK( ScSpecialFilterDlg, EndDlgHdl, Button*, pBtn )
//STRIP001 {
//STRIP001 	DBG_ASSERT( pDoc && pViewData, "Document or ViewData not found. :-/" );
//STRIP001 
//STRIP001 	if ( (pBtn == &aBtnOk) && pDoc && pViewData )
//STRIP001 	{
//STRIP001 		String			theCopyStr( aEdCopyArea.GetText() );
//STRIP001 		String			theAreaStr( aEdFilterArea.GetText() );
//STRIP001 		ScQueryParam	theOutParam( theQueryData );
//STRIP001 		ScAddress		theAdrCopy;
//STRIP001 		BOOL			bEditInputOk	= TRUE;
//STRIP001 		BOOL			bQueryOk		= FALSE;
//STRIP001 		USHORT			nCurTab			= pViewData->GetTabNo();
//STRIP001 		ScRange			theFilterArea;
//STRIP001 
//STRIP001 		if ( aBtnCopyResult.IsChecked() )
//STRIP001 		{
//STRIP001 			xub_StrLen nColonPos = theCopyStr.Search( ':' );
//STRIP001 
//STRIP001 			if ( STRING_NOTFOUND != nColonPos )
//STRIP001 				theCopyStr.Erase( nColonPos );
//STRIP001 
//STRIP001 			USHORT nResult = theAdrCopy.Parse( theCopyStr, pDoc );
//STRIP001 
//STRIP001 			if ( SCA_VALID != (nResult & SCA_VALID) )
//STRIP001 			{
//STRIP001 				if ( !aBtnMore.GetState() )
//STRIP001 					aBtnMore.SetState( TRUE );
//STRIP001 
//STRIP001 				ERRORBOX( STR_INVALID_TABREF );
//STRIP001 				aEdCopyArea.GrabFocus();
//STRIP001 				bEditInputOk = FALSE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bEditInputOk )
//STRIP001 		{
//STRIP001 			USHORT nResult = ScRange().Parse( theAreaStr, pDoc );
//STRIP001 
//STRIP001 			if ( SCA_VALID != (nResult & SCA_VALID) )
//STRIP001 			{
//STRIP001 				ERRORBOX( STR_INVALID_TABREF );
//STRIP001 				aEdFilterArea.GrabFocus();
//STRIP001 				bEditInputOk = FALSE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bEditInputOk )
//STRIP001 		{
//STRIP001 			/*
//STRIP001 			 * Alle Edit-Felder enthalten gueltige Bereiche.
//STRIP001 			 * Nun wird versucht aus dem Filterbereich
//STRIP001 			 * ein ScQueryParam zu erzeugen:
//STRIP001 			 */
//STRIP001 
//STRIP001 			USHORT	nResult = theFilterArea.Parse( theAreaStr, pDoc );
//STRIP001 
//STRIP001 			if ( SCA_VALID == (nResult & SCA_VALID) )
//STRIP001 			{
//STRIP001 				ScAddress& rStart = theFilterArea.aStart;
//STRIP001 				ScAddress& rEnd   = theFilterArea.aEnd;
//STRIP001 
//STRIP001 				if ( aBtnCopyResult.IsChecked() )
//STRIP001 				{
//STRIP001 					theOutParam.bInplace	= FALSE;
//STRIP001 					theOutParam.nDestTab	= theAdrCopy.Tab();
//STRIP001 					theOutParam.nDestCol	= theAdrCopy.Col();
//STRIP001 					theOutParam.nDestRow	= theAdrCopy.Row();
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					theOutParam.bInplace	= TRUE;
//STRIP001 					theOutParam.nDestTab	=
//STRIP001 					theOutParam.nDestCol	=
//STRIP001 					theOutParam.nDestRow	= 0;
//STRIP001 				}
//STRIP001 
//STRIP001 				theOutParam.bHasHeader = aBtnHeader.IsChecked();
//STRIP001 				theOutParam.bByRow	   = TRUE;
//STRIP001 				theOutParam.bCaseSens  = aBtnCase.IsChecked();
//STRIP001 				theOutParam.bRegExp	   = aBtnRegExp.IsChecked();
//STRIP001 				theOutParam.bDuplicate = !aBtnUnique.IsChecked();
//STRIP001 				theOutParam.bDestPers  = aBtnDestPers.IsChecked();
//STRIP001 
//STRIP001 				bQueryOk =
//STRIP001 					pDoc->CreateQueryParam( rStart.Col(),
//STRIP001 											rStart.Row(),
//STRIP001 											rEnd.Col(),
//STRIP001 											rEnd.Row(),
//STRIP001 											rStart.Tab(),
//STRIP001 											theOutParam );
//STRIP001 
//STRIP001 				//	an der DB-Collection koennen nur MAXQUERY Filter-Eintraege
//STRIP001 				//	gespeichert werden
//STRIP001 
//STRIP001 				if ( bQueryOk && theOutParam.GetEntryCount() > MAXQUERY &&
//STRIP001 					 theOutParam.GetEntry(MAXQUERY).bDoQuery )
//STRIP001 				{
//STRIP001 					bQueryOk = FALSE;		// zu viele
//STRIP001 											//!	andere Fehlermeldung ??
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bQueryOk )
//STRIP001 		{
//STRIP001 			SetDispatcherLock( FALSE );
//STRIP001 			SwitchToDocument();
//STRIP001 			GetBindings().GetDispatcher()->Execute( FID_FILTER_OK,
//STRIP001 									  SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD,
//STRIP001 									  GetOutputItem( theOutParam, theFilterArea ), 0L, 0L );
//STRIP001 			Close();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			ERRORBOX( STR_INVALID_QUERYAREA );
//STRIP001 			aEdFilterArea.GrabFocus();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( pBtn == &aBtnCancel )
//STRIP001 	{
//STRIP001 		Close();
//STRIP001 	}
//STRIP001 
//STRIP001 	return NULL;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScSpecialFilterDlg, TimeOutHdl, Timer*, _pTimer )
//STRIP001 {
//STRIP001     // alle 50ms nachschauen, ob RefInputMode noch stimmt
//STRIP001 
//STRIP001     if( (_pTimer == pTimer) && IsActive() )
//STRIP001     {
//STRIP001         if( aEdCopyArea.HasFocus() || aRbCopyArea.HasFocus() )
//STRIP001         {
//STRIP001             pRefInputEdit = &aEdCopyArea;
//STRIP001             bRefInputMode = TRUE;
//STRIP001         }
//STRIP001         else if( aEdFilterArea.HasFocus() || aRbFilterArea.HasFocus() )
//STRIP001         {
//STRIP001             pRefInputEdit = &aEdFilterArea;
//STRIP001             bRefInputMode = TRUE;
//STRIP001         }
//STRIP001         else if( bRefInputMode )
//STRIP001         {
//STRIP001             pRefInputEdit = NULL;
//STRIP001             bRefInputMode = FALSE;
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     pTimer->Start();
//STRIP001 
//STRIP001     return NULL;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScSpecialFilterDlg, FilterAreaSelHdl, ListBox*, pLb )
//STRIP001 {
//STRIP001 	if ( pLb == &aLbFilterArea )
//STRIP001 	{
//STRIP001 		String	aString;
//STRIP001 		USHORT	nSelPos = aLbFilterArea.GetSelectEntryPos();
//STRIP001 
//STRIP001 		if ( nSelPos > 0 )
//STRIP001 			aString = *(String*)aLbFilterArea.GetEntryData( nSelPos );
//STRIP001 
//STRIP001 		aEdFilterArea.SetText( aString );
//STRIP001 	}
//STRIP001 
//STRIP001 	return NULL;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScSpecialFilterDlg, FilterAreaModHdl, ScRefEdit*, pEd )
//STRIP001 {
//STRIP001 	if ( pEd == &aEdFilterArea )
//STRIP001 	{
//STRIP001 		if ( pDoc && pViewData )
//STRIP001 		{
//STRIP001 			String	theCurAreaStr = pEd->GetText();
//STRIP001 			USHORT	nResult	= ScRange().Parse( theCurAreaStr, pDoc );
//STRIP001 
//STRIP001 			if ( SCA_VALID == (nResult & SCA_VALID) )
//STRIP001 			{
//STRIP001 				String*	pStr	= NULL;
//STRIP001 				BOOL	bFound	= FALSE;
//STRIP001 				USHORT	i		= 0;
//STRIP001 				USHORT	nCount	= aLbFilterArea.GetEntryCount();
//STRIP001 
//STRIP001 				for ( i=1; i<nCount && !bFound; i++ )
//STRIP001 				{
//STRIP001 					pStr = (String*)aLbFilterArea.GetEntryData( i );
//STRIP001 					bFound = (theCurAreaStr == *pStr);
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( bFound )
//STRIP001 					aLbFilterArea.SelectEntryPos( --i );
//STRIP001 				else
//STRIP001 					aLbFilterArea.SelectEntryPos( 0 );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aLbFilterArea.SelectEntryPos( 0 );
//STRIP001 	}
//STRIP001 
//STRIP001 	return NULL;
//STRIP001 }


}
