/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_navipi.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 20:42:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------

// auto strip #ifndef SC_RANGELST_HXX
// auto strip #include <rangelst.hxx>
// auto strip #endif

// auto strip #include <bf_sfx2/bindings.hxx>
#include <bf_sfx2/dispatch.hxx>
// auto strip #include <bf_sfx2/event.hxx>
// auto strip #include <bf_sfx2/imgmgr.hxx>
// auto strip #include <bf_sfx2/navigat.hxx>
// auto strip #include <svtools/stritem.hxx>
// auto strip #include <svtools/urlbmk.hxx>
// auto strip #include <vcl/sound.hxx>
// auto strip #include <unotools/charclass.hxx>
#include <stdlib.h>

// auto strip #include "viewdata.hxx"
#include "tabvwsh.hxx"
// auto strip #include "docsh.hxx"
// auto strip #include "document.hxx"
// auto strip #include "dbcolect.hxx"
// auto strip #include "rangenam.hxx"
// auto strip #include "rangeutl.hxx"
// auto strip #include "popmenu.hxx"
// auto strip #include "scresid.hxx"
// auto strip #include "scmod.hxx"
// auto strip #include "navicfg.hxx"
// auto strip #include "navcitem.hxx"
#include "navipi.hrc"
#include "navipi.hxx"

#ifndef SC_NAVSETT_HXX
#include "navsett.hxx"
#endif
namespace binfilter {


//	Timeout, um Notizen zu suchen
//STRIP001 #define SC_CONTENT_TIMEOUT	1000

//	Toleranz, wieviel ueber der eingeklappten Groesse noch klein ist
//STRIP001 #define SCNAV_MINTOL		5

//  maximum values for UI
//STRIP001 #define SCNAV_MAXCOL        (MAXCOL+1)
//STRIP001 #define SCNAV_COLDIGITS     3           // 1...256
//STRIP001 #define SCNAV_COLLETTERS    2           // A...IV

//STRIP001 #define SCNAV_MAXROW        (MAXROW+1)

//------------------------------------------------------------------------

//	static
//STRIP001 void ScNavigatorDlg::ReleaseFocus()
//STRIP001 {
//STRIP001 	SfxViewShell* pCurSh = SfxViewShell::Current();
//STRIP001 
//STRIP001 	if ( pCurSh )
//STRIP001 	{
//STRIP001 		Window* pShellWnd = pCurSh->GetWindow();
//STRIP001 		if ( pShellWnd )
//STRIP001 			pShellWnd->GrabFocus();
//STRIP001 	}
//STRIP001 }

//==================================================================
//	class ColumnEdit
//==================================================================

//STRIP001 ColumnEdit::ColumnEdit( ScNavigatorDlg* pParent, const ResId& rResId )
//STRIP001 	:	SpinField	( pParent, rResId ),
//STRIP001 		rDlg		( *pParent ),
//STRIP001 		nKeyGroup	( KEYGROUP_ALPHA ),
//STRIP001 		nCol		( 0 )
//STRIP001 {
//STRIP001     SetMaxTextLen( SCNAV_COLDIGITS );   // 1...255 or A...IV
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 __EXPORT ColumnEdit::~ColumnEdit()
//STRIP001 {
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 long __EXPORT ColumnEdit::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	long nHandled = SpinField::Notify( rNEvt );
//STRIP001 
//STRIP001 	USHORT nType = rNEvt.GetType();
//STRIP001 	if ( nType == EVENT_KEYINPUT )
//STRIP001 	{
//STRIP001 		const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
//STRIP001 		KeyCode aCode = pKEvt->GetKeyCode();
//STRIP001 
//STRIP001 		if ( !aCode.IsMod1() && !aCode.IsMod2() )
//STRIP001 		{
//STRIP001 			//!	Eingabeueberpruefung (nur Zahlen oder nur Buchstaben, max 2 bzw 3 Stellen)
//STRIP001 			//!	war vor VCL per nicht weitergeleitetem KeyInput
//STRIP001 			//!	dafuer was neues ausdenken!!!
//STRIP001 
//STRIP001 			if ( aCode.GetCode() == KEY_RETURN )
//STRIP001 			{
//STRIP001 				ScNavigatorDlg::ReleaseFocus();
//STRIP001 				ExecuteCol();
//STRIP001 				nHandled = 1;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( nType == EVENT_LOSEFOCUS )	// LoseFocus wird bei VCL nicht gerufen
//STRIP001 		EvalText();							// nCol setzen
//STRIP001 
//STRIP001 	return nHandled;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void __EXPORT ColumnEdit::LoseFocus()
//STRIP001 {
//STRIP001 	EvalText();
//STRIP001 }


//------------------------------------------------------------------------

//STRIP001 void __EXPORT ColumnEdit::Up()
//STRIP001 {
//STRIP001     nCol++;
//STRIP001 
//STRIP001 #ifdef OS2
//STRIP001     if ( nCol > SCNAV_MAXCOL )
//STRIP001 		nCol = 1;
//STRIP001 #endif
//STRIP001 
//STRIP001     if ( nCol <= SCNAV_MAXCOL )
//STRIP001 		SetCol( nCol );
//STRIP001 	else
//STRIP001         nCol--;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void __EXPORT ColumnEdit::Down()
//STRIP001 {
//STRIP001 	if ( nCol>1 )
//STRIP001 		SetCol( nCol-1 );
//STRIP001 #ifdef OS2
//STRIP001 	else
//STRIP001         SetCol( SCNAV_MAXCOL );
//STRIP001 #endif
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void __EXPORT ColumnEdit::First()
//STRIP001 {
//STRIP001     nCol = 1;
//STRIP001 	SetText( 'A' );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void __EXPORT ColumnEdit::Last()
//STRIP001 {
//STRIP001     String aStr;
//STRIP001     nCol = NumToAlpha( SCNAV_MAXCOL, aStr );
//STRIP001     SetText( aStr );
//STRIP001 }


//------------------------------------------------------------------------

//STRIP001 void ColumnEdit::EvalText()
//STRIP001 {
//STRIP001 	String aStrCol = GetText();
//STRIP001 
//STRIP001 	if ( aStrCol.Len() > 0 )
//STRIP001 	{
//STRIP001 		//	nKeyGroup wird bei VCL mangels KeyInput nicht mehr gesetzt
//STRIP001 
//STRIP001 		if ( CharClass::isAsciiNumeric(aStrCol) )
//STRIP001 			nCol = NumStrToAlpha( aStrCol );
//STRIP001 		else
//STRIP001 			nCol = AlphaToNum( aStrCol );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nCol = 0;
//STRIP001 
//STRIP001 	SetText( aStrCol );
//STRIP001 	nKeyGroup = KEYGROUP_ALPHA;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ColumnEdit::ExecuteCol()
//STRIP001 {
//STRIP001 	USHORT nRow = rDlg.aEdRow.GetRow();
//STRIP001 
//STRIP001 	EvalText(); // setzt nCol
//STRIP001 
//STRIP001 	if ( (nCol > 0) && (nRow > 0) )
//STRIP001 		rDlg.SetCurrentCell( nCol-1, nRow-1 );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ColumnEdit::SetCol( USHORT nColNo )
//STRIP001 {
//STRIP001 	String aStr;
//STRIP001 
//STRIP001 	if ( nColNo == 0 )
//STRIP001 	{
//STRIP001 		nCol = 0;
//STRIP001 		SetText( aStr );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nColNo = NumToAlpha( nColNo, aStr );
//STRIP001 		nCol = nColNo;
//STRIP001 		SetText( aStr );
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 USHORT ColumnEdit::AlphaToNum( String& rStr )
//STRIP001 {
//STRIP001 	USHORT  nColumn = 0;
//STRIP001 
//STRIP001 	ByteString aByteStr( rStr, RTL_TEXTENCODING_ASCII_US );
//STRIP001 	if ( aByteStr.IsAlphaAscii() )
//STRIP001 	{
//STRIP001 		rStr.ToUpperAscii();
//STRIP001 		aByteStr.ToUpperAscii();
//STRIP001 
//STRIP001         if ( aByteStr.Len() <= SCNAV_COLLETTERS )
//STRIP001         {
//STRIP001             for ( USHORT nIndex = 0; nIndex < aByteStr.Len(); ++nIndex )
//STRIP001                 (nColumn *= 26) += (aByteStr.GetChar( nIndex ) - 'A' + 1);
//STRIP001         }
//STRIP001 
//STRIP001         if ( (aByteStr.Len() > SCNAV_COLLETTERS) || (nColumn > SCNAV_MAXCOL) )
//STRIP001         {
//STRIP001             nColumn = SCNAV_MAXCOL;
//STRIP001             NumToAlpha( nColumn, rStr );
//STRIP001         }
//STRIP001 	}
//STRIP001     else
//STRIP001         rStr.Erase();
//STRIP001 
//STRIP001 	return nColumn;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 USHORT ColumnEdit::NumStrToAlpha( String& rStr )
//STRIP001 {
//STRIP001 	USHORT  nColumn = 0;
//STRIP001 
//STRIP001 	if ( CharClass::isAsciiNumeric(rStr) )
//STRIP001 		nColumn = NumToAlpha( (USHORT)rStr.ToInt32(), rStr );
//STRIP001 	else
//STRIP001 		rStr.Erase();
//STRIP001 
//STRIP001 	return nColumn;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 USHORT ColumnEdit::NumToAlpha( USHORT nColNo, String& rStr )
//STRIP001 {
//STRIP001     if ( nColNo > SCNAV_MAXCOL )
//STRIP001         nColNo = SCNAV_MAXCOL;
//STRIP001     else if ( nColNo < 1 )
//STRIP001 		nColNo = 1;
//STRIP001 
//STRIP001     ScAddress aAddr( nColNo - 1, 0, 0 );
//STRIP001     aAddr.Format( rStr, SCA_VALID_COL, NULL );
//STRIP001 
//STRIP001     return nColNo;
//STRIP001 }

//==================================================================
//	class RowEdit
//==================================================================

//STRIP001 RowEdit::RowEdit( ScNavigatorDlg* pParent, const ResId& rResId )
//STRIP001 	:	NumericField( pParent, rResId ),
//STRIP001 		rDlg		( *pParent )
//STRIP001 {
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 __EXPORT RowEdit::~RowEdit()
//STRIP001 {
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 long __EXPORT RowEdit::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	long nHandled = NumericField::Notify( rNEvt );
//STRIP001 
//STRIP001 	if ( rNEvt.GetType() == EVENT_KEYINPUT )
//STRIP001 	{
//STRIP001 		const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
//STRIP001 		KeyCode aCode = pKEvt->GetKeyCode();
//STRIP001 		if ( aCode.GetCode() == KEY_RETURN && !aCode.IsMod1() && !aCode.IsMod2() )
//STRIP001 		{
//STRIP001 			ScNavigatorDlg::ReleaseFocus();
//STRIP001 			ExecuteRow();
//STRIP001 			nHandled = 1;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return nHandled;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void __EXPORT RowEdit::LoseFocus()
//STRIP001 {
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void RowEdit::ExecuteRow()
//STRIP001 {
//STRIP001 	USHORT nCol = rDlg.aEdCol.GetCol();
//STRIP001 	USHORT nRow = (USHORT)GetValue();
//STRIP001 
//STRIP001 	if ( (nCol > 0) && (nRow > 0) )
//STRIP001 		rDlg.SetCurrentCell( nCol-1, nRow-1 );
//STRIP001 }

//==================================================================
//	class ScDocListBox
//==================================================================

//STRIP001 ScDocListBox::ScDocListBox( ScNavigatorDlg* pParent, const ResId& rResId )
//STRIP001 	:	ListBox	( pParent, rResId ),
//STRIP001 		rDlg	( *pParent )
//STRIP001 {
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 __EXPORT ScDocListBox::~ScDocListBox()
//STRIP001 {
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void __EXPORT ScDocListBox::Select()
//STRIP001 {
//STRIP001 	ScNavigatorDlg::ReleaseFocus();
//STRIP001 
//STRIP001 	String aDocName = GetSelectEntry();
//STRIP001 	rDlg.aLbEntries.SelectDoc( aDocName );
//STRIP001 }

//==================================================================
//	class CommandToolBox
//==================================================================

//STRIP001 CommandToolBox::CommandToolBox( ScNavigatorDlg* pParent, const ResId& rResId )
//STRIP001 	:	ToolBox	( pParent, rResId ),
//STRIP001 		rDlg	( *pParent )
//STRIP001 {
//STRIP001 	//	#52973# grosse Images haben wir nicht, darum nur fuer CHANGEOUTSTYLE anmelden
//STRIP001     rDlg.GetBindings().GetImageManager()->RegisterToolBox( this, SFX_TOOLBOX_CHANGEOUTSTYLE );
//STRIP001 
//STRIP001 	InitImageList();	// ImageList members of ScNavigatorDlg must be initialized before!
//STRIP001 
//STRIP001 	SetSizePixel( CalcWindowSizePixel() );
//STRIP001 //	EnableItem( IID_UP, FALSE );
//STRIP001 //	EnableItem( IID_DOWN, FALSE );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 __EXPORT CommandToolBox::~CommandToolBox()
//STRIP001 {
//STRIP001     rDlg.GetBindings().GetImageManager()->ReleaseToolBox( this );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void CommandToolBox::Select( USHORT nSelId )
//STRIP001 {
//STRIP001 	//	Modus umschalten ?
//STRIP001 
//STRIP001 	if ( nSelId == IID_ZOOMOUT || nSelId == IID_SCENARIOS )
//STRIP001 	{
//STRIP001 		NavListMode eOldMode = rDlg.eListMode;
//STRIP001 		NavListMode eNewMode = eOldMode;
//STRIP001 
//STRIP001 		if ( nSelId == IID_SCENARIOS )					// auf Szenario
//STRIP001 		{
//STRIP001 			if ( eOldMode == NAV_LMODE_SCENARIOS )
//STRIP001 				eNewMode = NAV_LMODE_AREAS;
//STRIP001 			else
//STRIP001 				eNewMode = NAV_LMODE_SCENARIOS;
//STRIP001 		}
//STRIP001 		else											// ein/aus
//STRIP001 		{
//STRIP001 			if ( eOldMode == NAV_LMODE_NONE )
//STRIP001 				eNewMode = NAV_LMODE_AREAS;
//STRIP001 			else
//STRIP001 				eNewMode = NAV_LMODE_NONE;
//STRIP001 		}
//STRIP001 		rDlg.SetListMode( eNewMode );
//STRIP001 		UpdateButtons();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		switch ( nSelId )
//STRIP001 		{
//STRIP001 			case IID_DATA:
//STRIP001 				rDlg.MarkDataArea();
//STRIP001 				break;
//STRIP001 			case IID_UP:
//STRIP001 				rDlg.StartOfDataArea();
//STRIP001 				break;
//STRIP001 			case IID_DOWN:
//STRIP001 				rDlg.EndOfDataArea();
//STRIP001 				break;
//STRIP001 			// IID_DROPMODE ist in Click
//STRIP001 			case IID_CHANGEROOT:
//STRIP001 				rDlg.aLbEntries.ToggleRoot();
//STRIP001 				UpdateButtons();
//STRIP001 				break;
//STRIP001 		}
//STRIP001 }

//STRIP001 void __EXPORT CommandToolBox::Select()
//STRIP001 {
//STRIP001 	Select( GetCurItemId() );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void __EXPORT CommandToolBox::Click()
//STRIP001 {
//STRIP001 	//	Das Popupmenue fuer den Dropmodus muss im Click (Button Down)
//STRIP001 	//	statt im Select (Button Up) aufgerufen werden.
//STRIP001 
//STRIP001 	if ( GetCurItemId() == IID_DROPMODE )
//STRIP001 	{
//STRIP001 		Point aMenuPos = GetItemRect(IID_DROPMODE).BottomLeft();
//STRIP001 
//STRIP001 		ScPopupMenu aPop( ScResId( RID_POPUP_DROPMODE ) );
//STRIP001 		aPop.CheckItem( RID_DROPMODE_URL + rDlg.GetDropMode() );
//STRIP001 		aPop.Execute( this, aMenuPos );
//STRIP001 		USHORT nId = aPop.GetSelected();
//STRIP001 
//STRIP001 		EndSelection();		// vor SetDropMode (SetDropMode ruft SetItemImage)
//STRIP001 
//STRIP001 		if ( nId >= RID_DROPMODE_URL && nId <= RID_DROPMODE_COPY )
//STRIP001 			rDlg.SetDropMode( nId - RID_DROPMODE_URL );
//STRIP001 
//STRIP001 		//	#49956# den gehighlighteten Button aufheben
//STRIP001 		Point aPoint;
//STRIP001 		MouseEvent aLeave( aPoint, 0, MOUSE_LEAVEWINDOW | MOUSE_SYNTHETIC );
//STRIP001 		MouseMove( aLeave );
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void CommandToolBox::UpdateButtons()
//STRIP001 {
//STRIP001 	NavListMode eMode = rDlg.eListMode;
//STRIP001 	CheckItem( IID_SCENARIOS,	eMode == NAV_LMODE_SCENARIOS );
//STRIP001 	CheckItem( IID_ZOOMOUT,		eMode != NAV_LMODE_NONE );
//STRIP001 
//STRIP001 	//	Umschalten-Button:
//STRIP001 	if ( eMode == NAV_LMODE_SCENARIOS || eMode == NAV_LMODE_NONE )
//STRIP001 	{
//STRIP001 		EnableItem( IID_CHANGEROOT,	FALSE );
//STRIP001 		CheckItem( IID_CHANGEROOT, FALSE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		EnableItem( IID_CHANGEROOT,	TRUE );
//STRIP001 		BOOL bRootSet = rDlg.aLbEntries.GetRootType() != SC_CONTENT_ROOT;
//STRIP001 		CheckItem( IID_CHANGEROOT, bRootSet );
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bDark = GetDisplayBackground().GetColor().IsDark();
//STRIP001 
//STRIP001 	USHORT nImageId = 0;
//STRIP001 	switch ( rDlg.nDropMode )
//STRIP001 	{
//STRIP001 		case SC_DROPMODE_URL:	nImageId = bDark ? RID_IMG_H_DROP_URL  : RID_IMG_DROP_URL;  break;
//STRIP001 		case SC_DROPMODE_LINK:	nImageId = bDark ? RID_IMG_H_DROP_LINK : RID_IMG_DROP_LINK; break;
//STRIP001 		case SC_DROPMODE_COPY:	nImageId = bDark ? RID_IMG_H_DROP_COPY : RID_IMG_DROP_COPY; break;
//STRIP001 	}
//STRIP001 	SetItemImage( IID_DROPMODE, Image(ScResId(nImageId)) );
//STRIP001 }

//STRIP001 void CommandToolBox::InitImageList()
//STRIP001 {
//STRIP001 	BOOL bDark = GetDisplayBackground().GetColor().IsDark();
//STRIP001 
//STRIP001     ImageList& rImgLst = bDark ? rDlg.aCmdImageListH : rDlg.aCmdImageList;
//STRIP001 
//STRIP001 	USHORT nCount = GetItemCount();
//STRIP001     for (USHORT i = 0; i < nCount; i++)
//STRIP001     {
//STRIP001     	USHORT nId = GetItemId(i);
//STRIP001 		SetItemImage( nId, rImgLst.GetImage( nId ) );
//STRIP001     }
//STRIP001 }

//STRIP001 void CommandToolBox::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( rDCEvt.GetType() == DATACHANGED_SETTINGS && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001 	{
//STRIP001 		//	update item images
//STRIP001 
//STRIP001 		InitImageList();
//STRIP001 		UpdateButtons();	// drop mode
//STRIP001 	}
//STRIP001 
//STRIP001     ToolBox::DataChanged( rDCEvt );
//STRIP001 }

//==================================================================
//  class ScNavigatorSettings
//==================================================================

/*N*/  ScNavigatorSettings::ScNavigatorSettings() :
/*N*/     maExpandedVec( SC_CONTENT_COUNT, FALSE ),
/*N*/     mnRootSelected( SC_CONTENT_ROOT ),
/*N*/     mnChildSelected( SC_CONTENT_NOCHILD )
/*N*/ {
/*N*/ }

//==================================================================
//	class ScNavigatorDlgWrapper
//==================================================================

/*N*/ SFX_IMPL_CHILDWINDOW_CONTEXT( ScNavigatorDialogWrapper, SID_NAVIGATOR, ScTabViewShell )

//STRIP001 #define IS_MODE(bit)(((nFlags)&(bit))==(bit))

//STRIP001 ScNavigatorDialogWrapper::ScNavigatorDialogWrapper(
//STRIP001 									Window*			 pParent,
//STRIP001 									USHORT			 nId,
//STRIP001 									SfxBindings*	 pBind,
//STRIP001 									SfxChildWinInfo* pInfo ) :
//STRIP001 		SfxChildWindowContext( nId )
//STRIP001 {
//STRIP001 	pNavigator = new ScNavigatorDlg( pBind, this, pParent );
//STRIP001 	SetWindow( pNavigator );
//STRIP001 
//STRIP001 	//	Einstellungen muessen anderswo gemerkt werden,
//STRIP001 	//	pInfo geht uns (ausser der Groesse) nichts mehr an
//STRIP001 
//STRIP001 	Size aInfoSize = pParent->GetOutputSizePixel();		// von aussen vorgegebene Groesse
//STRIP001 	Size aNavSize = pNavigator->GetOutputSizePixel();	// Default-Groesse
//STRIP001 
//STRIP001 	aNavSize.Width()  = Max( aInfoSize.Width(),  aNavSize.Width() );
//STRIP001 	aNavSize.Height() = Max( aInfoSize.Height(), aNavSize.Height() );
//STRIP001 	pNavigator->nListModeHeight = Max( aNavSize.Height(), pNavigator->nListModeHeight );
//STRIP001 
//STRIP001 	//	Die Groesse kann in einem anderen Modul geaendert worden sein,
//STRIP001 	//	deshalb muessen in Abhaengigkeit von der momentanen Groesse die
//STRIP001 	//	Inhalte eingeblendet werden oder nicht
//STRIP001 
//STRIP001 	BOOL bSmall = ( aInfoSize.Height() <= pNavigator->aInitSize.Height() + SCNAV_MINTOL );
//STRIP001 	NavListMode eNavMode = NAV_LMODE_NONE;
//STRIP001 	if (!bSmall)
//STRIP001 	{
//STRIP001 		//	wenn Szenario aktiv war, wieder einschalten
//STRIP001 
//STRIP001 		ScNavipiCfg& rCfg = SC_MOD()->GetNavipiCfg();
//STRIP001 		NavListMode eLastMode = (NavListMode) rCfg.GetListMode();
//STRIP001 		if ( eLastMode == NAV_LMODE_SCENARIOS )
//STRIP001 			eNavMode = NAV_LMODE_SCENARIOS;
//STRIP001 		else
//STRIP001 			eNavMode = NAV_LMODE_AREAS;
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Die Groesse des Floats nicht neu setzen (FALSE bei SetListMode), damit der
//STRIP001 	//	Navigator nicht aufgeklappt wird, wenn er minimiert war (#38872#).
//STRIP001 
//STRIP001 	pNavigator->SetListMode( eNavMode, FALSE );		// FALSE: Groesse des Float nicht setzen
//STRIP001 
//STRIP001 	USHORT nCmdId = 0;
//STRIP001 	switch (eNavMode)
//STRIP001 	{
//STRIP001 		case NAV_LMODE_DOCS:		nCmdId = IID_DOCS; 		break;
//STRIP001 		case NAV_LMODE_AREAS:		nCmdId = IID_AREAS; 	break;
//STRIP001 		case NAV_LMODE_DBAREAS:		nCmdId = IID_DBAREAS; 	break;
//STRIP001 		case NAV_LMODE_SCENARIOS:	nCmdId = IID_SCENARIOS; break;
//STRIP001 	}
//STRIP001 	if (nCmdId)
//STRIP001 	{
//STRIP001 		pNavigator->aTbxCmd.CheckItem( nCmdId );
//STRIP001 		pNavigator->DoResize();
//STRIP001 	}
//STRIP001 
//STRIP001 	pNavigator->bFirstBig = ( nCmdId == 0 );	// dann spaeter
//STRIP001 
//STRIP001 /*???
//STRIP001 	FloatingWindow* pFloat = GetFloatingWindow();
//STRIP001 	if ( pFloat )
//STRIP001 		pFloat->SetMinOutputSizePixel( pNavigator->GetMinOutputSizePixel() );
//STRIP001 */
//STRIP001 
//STRIP001 //!?	pNavigator->Show();
//STRIP001 }

//STRIP001 void __EXPORT ScNavigatorDialogWrapper::Resizing( Size& rSize )
//STRIP001 {
//STRIP001 	((ScNavigatorDlg*)GetWindow())->Resizing(rSize);
//STRIP001 }

//========================================================================
// class ScNavigatorPI
//========================================================================

//STRIP001 #define CTRL_ITEMS 4

//STRIP001 #define REGISTER_SLOT(i,id) \
//STRIP001 	ppBoundItems[i]=new ScNavigatorControllerItem(id,*this,rBindings);

//STRIP001 ScNavigatorDlg::ScNavigatorDlg( SfxBindings* pB, SfxChildWindowContext* pCW, Window* pParent ) :
//STRIP001 		Window( pParent, ScResId(RID_SCDLG_NAVIGATOR) ),
//STRIP001 		rBindings	( *pB ),								// is used in CommandToolBox ctor
//STRIP001 		aCmdImageList( ScResId( IL_CMD ) ),
//STRIP001     	aCmdImageListH( ScResId( ILH_CMD ) ),
//STRIP001 		aFtCol		( this, ScResId( FT_COL ) ),
//STRIP001 		aEdCol		( this, ScResId( ED_COL ) ),
//STRIP001 		aFtRow		( this, ScResId( FT_ROW ) ),
//STRIP001 		aEdRow		( this, ScResId( ED_ROW ) ),
//STRIP001 		aTbxCmd		( this, ScResId( TBX_CMD ) ),
//STRIP001 		aLbEntries	( this, ScResId( LB_ENTRIES ) ),
//STRIP001 		aLbDocuments( this, ScResId( LB_DOCUMENTS ) ),
//STRIP001 		aWndScenarios( this,ScResId( STR_QHLP_SCEN_LISTBOX), ScResId(STR_QHLP_SCEN_COMMENT)),
//STRIP001 		aStrDragMode ( ScResId( STR_DRAGMODE ) ),
//STRIP001 		aStrDisplay  ( ScResId( STR_DISPLAY ) ),
//STRIP001 		aStrActiveWin( ScResId( STR_ACTIVEWIN ) ),
//STRIP001 		pContextWin	( pCW ),
//STRIP001 		eListMode	( NAV_LMODE_NONE ),
//STRIP001 		nDropMode	( SC_DROPMODE_URL ),
//STRIP001 		nListModeHeight( 0 ),
//STRIP001 		nInitListHeight( 0 ),
//STRIP001 		pViewData	( NULL ),
//STRIP001 		pMarkArea	( NULL ),
//STRIP001 		nCurCol		( 0 ),
//STRIP001 		nCurRow		( 0 ),
//STRIP001 		nCurTab		( 0 ),
//STRIP001 		bFirstBig	( FALSE )
//STRIP001 {
//STRIP001 	ScNavipiCfg& rCfg = SC_MOD()->GetNavipiCfg();
//STRIP001 	nDropMode = rCfg.GetDragMode();
//STRIP001 	//	eListMode wird von aussen gesetzt, Root weiter unten
//STRIP001 
//STRIP001 	aLbDocuments.SetDropDownLineCount(9);
//STRIP001 	String aOpen = String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM( " (" ));
//STRIP001 	aStrActive = aOpen;
//STRIP001 	aStrActive += String( ScResId( STR_ACTIVE ) );
//STRIP001 	aStrActive += ')';										// " (aktiv)"
//STRIP001 	aStrNotActive = aOpen;
//STRIP001 	aStrNotActive += String( ScResId( STR_NOTACTIVE ) );
//STRIP001 	aStrNotActive += ')';									// " (inaktiv)"
//STRIP001 	aStrHidden = aOpen;
//STRIP001 	aStrHidden += String( ScResId( STR_HIDDEN ) );
//STRIP001 	aStrHidden += ')';										// " (versteckt)"
//STRIP001 
//STRIP001 	aTitleBase = GetText();
//STRIP001 
//STRIP001 	Size aSize( GetOutputSizePixel() );
//STRIP001 
//STRIP001 	nBorderOffset = aLbEntries.GetPosPixel().X();
//STRIP001 
//STRIP001 	aInitSize.Width()  =  aTbxCmd.GetPosPixel().X()
//STRIP001 						+ aTbxCmd.GetSizePixel().Width()
//STRIP001 						+ nBorderOffset;
//STRIP001 	aInitSize.Height() = aLbEntries.GetPosPixel().Y();
//STRIP001 
//STRIP001 	nInitListHeight	= aLbEntries.GetSizePixel().Height();
//STRIP001 	nListModeHeight	=  aInitSize.Height()
//STRIP001 					 + nInitListHeight;
//STRIP001 
//STRIP001 	//	kein Resize, eh der ganze Kontext-Kram initialisiert ist!
//STRIP001 //	SetOutputSizePixel( aInitSize );		//???
//STRIP001 /*!	FloatingWindow* pFloat = pContextWin->GetFloatingWindow();
//STRIP001 	if ( pFloat)
//STRIP001 		pFloat->SetMinOutputSizePixel( aInitSize );
//STRIP001 */
//STRIP001 	ppBoundItems = new ScNavigatorControllerItem* [CTRL_ITEMS];
//STRIP001 
//STRIP001 	rBindings.ENTERREGISTRATIONS();
//STRIP001 	//-----------------------------
//STRIP001 	REGISTER_SLOT( 0, SID_CURRENTCELL		);
//STRIP001 	REGISTER_SLOT( 1, SID_CURRENTTAB		);
//STRIP001 	REGISTER_SLOT( 2, SID_CURRENTDOC		);
//STRIP001 	REGISTER_SLOT( 3, SID_SELECT_SCENARIO	);
//STRIP001 	//-----------------------------
//STRIP001 	rBindings.LEAVEREGISTRATIONS();
//STRIP001 
//STRIP001 	StartListening( *(SFX_APP()) );
//STRIP001 	StartListening( rBindings );
//STRIP001 
//STRIP001 	aLbDocuments.Hide();		// bei NAV_LMODE_NONE gibts die nicht
//STRIP001 
//STRIP001 	aLbEntries.InitWindowBits(TRUE);
//STRIP001 
//STRIP001 	aLbEntries.SetSpaceBetweenEntries(0);
//STRIP001 	aLbEntries.SetSelectionMode( SINGLE_SELECTION );
//STRIP001 	aLbEntries.SetDragDropMode( 	SV_DRAGDROP_CTRL_MOVE |
//STRIP001 									SV_DRAGDROP_CTRL_COPY |
//STRIP001 									SV_DRAGDROP_ENABLE_TOP );
//STRIP001 
//STRIP001 	//	war eine Kategorie als Root ausgewaehlt?
//STRIP001 	USHORT nLastRoot = rCfg.GetRootType();
//STRIP001 	if ( nLastRoot )
//STRIP001 		aLbEntries.SetRootType( nLastRoot );
//STRIP001 
//STRIP001 	aLbEntries.Refresh();
//STRIP001 	GetDocNames();
//STRIP001 
//STRIP001 	aTbxCmd.UpdateButtons();
//STRIP001 
//STRIP001 	UpdateColumn();
//STRIP001 	UpdateRow();
//STRIP001 	UpdateTable();
//STRIP001 	aLbEntries.Hide();
//STRIP001 	aWndScenarios.Hide();
//STRIP001 	aWndScenarios.SetPosPixel( aLbEntries.GetPosPixel() );
//STRIP001 
//STRIP001 	aContentTimer.SetTimeoutHdl( LINK( this, ScNavigatorDlg, TimeHdl ) );
//STRIP001 	aContentTimer.SetTimeout( SC_CONTENT_TIMEOUT );
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 __EXPORT ScNavigatorDlg::~ScNavigatorDlg()
//STRIP001 {
//STRIP001 	aContentTimer.Stop();
//STRIP001 
//STRIP001 	USHORT i;
//STRIP001 	for ( i=0; i<CTRL_ITEMS; i++ )
//STRIP001 		delete ppBoundItems[i];
//STRIP001 
//STRIP001 	delete [] ppBoundItems;
//STRIP001 	delete pMarkArea;
//STRIP001 
//STRIP001 	EndListening( *(SFX_APP()) );
//STRIP001 	EndListening( rBindings );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void __EXPORT ScNavigatorDlg::Resizing( Size& rNewSize )  // Size = Outputsize?
//STRIP001 {
//STRIP001 	FloatingWindow* pFloat = pContextWin->GetFloatingWindow();
//STRIP001 	if ( pFloat )
//STRIP001 	{
//STRIP001 		Size aMinOut = pFloat->GetMinOutputSizePixel();
//STRIP001 
//STRIP001 		if ( rNewSize.Width() < aMinOut.Width() )
//STRIP001 			rNewSize.Width() = aMinOut.Width();
//STRIP001 
//STRIP001 		if ( eListMode == NAV_LMODE_NONE )
//STRIP001 			rNewSize.Height() = aInitSize.Height();
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if ( rNewSize.Height() < aMinOut.Height() )
//STRIP001 				rNewSize.Height() = aMinOut.Height();
//STRIP001 		}
//STRIP001 	}
//STRIP001 //	else
//STRIP001 //		SfxDockingWindow::Resizing(rNewSize);
//STRIP001 }



//STRIP001 void ScNavigatorDlg::Paint( const Rectangle& rRec )
//STRIP001 {
//STRIP001 	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
//STRIP001 	Color aBgColor = rStyleSettings.GetFaceColor();
//STRIP001 	Wallpaper aBack( aBgColor );
//STRIP001 
//STRIP001 	SetBackground( aBack );
//STRIP001 	aFtCol.SetBackground( aBack );
//STRIP001 	aFtRow.SetBackground( aBack );
//STRIP001 
//STRIP001 	Window::Paint( rRec );
//STRIP001 }

//STRIP001 void ScNavigatorDlg::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( rDCEvt.GetType() == DATACHANGED_SETTINGS && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001 	{
//STRIP001 		//	toolbox images are exchanged in CommandToolBox::DataChanged
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 
//STRIP001     Window::DataChanged( rDCEvt );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void __EXPORT ScNavigatorDlg::Resize()
//STRIP001 {
//STRIP001 	DoResize();
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScNavigatorDlg::DoResize()
//STRIP001 {
//STRIP001 	Size aNewSize = GetOutputSizePixel();
//STRIP001 	long nTotalHeight = aNewSize.Height();
//STRIP001 
//STRIP001 	//	#41403# bei angedocktem Navigator wird das Fenster evtl. erst klein erzeugt,
//STRIP001 	//	dann kommt ein Resize auf die wirkliche Groesse -> dann Inhalte einschalten
//STRIP001 
//STRIP001 	BOOL bSmall = ( nTotalHeight <= aInitSize.Height() + SCNAV_MINTOL );
//STRIP001 	if ( !bSmall && bFirstBig )
//STRIP001 	{
//STRIP001 		//	Inhalte laut Config wieder einschalten
//STRIP001 
//STRIP001 		bFirstBig = FALSE;
//STRIP001 		NavListMode eNavMode = NAV_LMODE_AREAS;
//STRIP001 		ScNavipiCfg& rCfg = SC_MOD()->GetNavipiCfg();
//STRIP001 		NavListMode eLastMode = (NavListMode) rCfg.GetListMode();
//STRIP001 		if ( eLastMode == NAV_LMODE_SCENARIOS )
//STRIP001 			eNavMode = NAV_LMODE_SCENARIOS;
//STRIP001 		SetListMode( eNavMode, FALSE );			// FALSE: Groesse des Float nicht setzen
//STRIP001 	}
//STRIP001 
//STRIP001 	//	auch wenn die Inhalte nicht sichtbar sind, die Groessen anpassen,
//STRIP001 	//	damit die Breite stimmt
//STRIP001 
//STRIP001 	//@@ 03.11.97 changes begin
//STRIP001 	Point aEntryPos = aLbEntries.GetPosPixel();
//STRIP001 	Point aListPos = aLbDocuments.GetPosPixel();
//STRIP001 	aNewSize.Width() -= 2*nBorderOffset;
//STRIP001 	Size aDocSize = aLbDocuments.GetSizePixel();
//STRIP001 	aDocSize.Width() = aNewSize.Width();
//STRIP001 
//STRIP001 	if(!bSmall)
//STRIP001 	{
//STRIP001 
//STRIP001 		long nListHeight = aLbDocuments.GetSizePixel().Height();
//STRIP001 		aNewSize.Height() -= ( aEntryPos.Y() + nListHeight + 2*nBorderOffset );
//STRIP001 		if(aNewSize.Height()<0)	aNewSize.Height()=0;
//STRIP001 
//STRIP001 		aListPos.Y() = aEntryPos.Y() + aNewSize.Height() + nBorderOffset;
//STRIP001 
//STRIP001 		if(aListPos.Y() > aLbEntries.GetPosPixel().Y())
//STRIP001 							aLbDocuments.SetPosPixel( aListPos );
//STRIP001 
//STRIP001 	}
//STRIP001 	aLbEntries.SetSizePixel( aNewSize );
//STRIP001 	aWndScenarios.SetSizePixel( aNewSize );
//STRIP001 	aLbDocuments.SetSizePixel( aDocSize );
//STRIP001 
//STRIP001 	//@@ 03.11.97 end
//STRIP001 
//STRIP001 	BOOL bListMode = (eListMode != NAV_LMODE_NONE);
//STRIP001 	FloatingWindow* pFloat = pContextWin->GetFloatingWindow();
//STRIP001 	if ( pFloat && bListMode )
//STRIP001 		nListModeHeight = nTotalHeight;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void __EXPORT ScNavigatorDlg::SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
//STRIP001 									  const SfxHint& rHint, const TypeId& rHintType )
//STRIP001 {
//STRIP001 	if ( rHint.ISA(SfxSimpleHint) )
//STRIP001 	{
//STRIP001 		ULONG nHintId = ((SfxSimpleHint&)rHint).GetId();
//STRIP001 
//STRIP001 		if ( nHintId == SC_HINT_DOCNAME_CHANGED )
//STRIP001 		{
//STRIP001 			aLbEntries.ActiveDocChanged();
//STRIP001 		}
//STRIP001 		else if ( NAV_LMODE_NONE == eListMode )
//STRIP001 		{
//STRIP001 			//	Tabellen hier nicht mehr
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			switch ( nHintId )
//STRIP001 			{
//STRIP001 				case SC_HINT_TABLES_CHANGED:
//STRIP001 					aLbEntries.Refresh( SC_CONTENT_TABLE );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case SC_HINT_DBAREAS_CHANGED:
//STRIP001 					aLbEntries.Refresh( SC_CONTENT_DBAREA );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case SC_HINT_AREAS_CHANGED:
//STRIP001 					aLbEntries.Refresh( SC_CONTENT_RANGENAME );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case SC_HINT_DRAW_CHANGED:
//STRIP001 					aLbEntries.Refresh( SC_CONTENT_GRAPHIC );
//STRIP001 					aLbEntries.Refresh( SC_CONTENT_OLEOBJECT );
//STRIP001 					aLbEntries.Refresh( SC_CONTENT_DRAWING );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case SC_HINT_AREALINKS_CHANGED:
//STRIP001 					aLbEntries.Refresh( SC_CONTENT_AREALINK );
//STRIP001 					break;
//STRIP001 
//STRIP001 				//	SFX_HINT_DOCCHANGED kommt nicht nur bei Dokument-Wechsel
//STRIP001 
//STRIP001 				case SC_HINT_NAVIGATOR_UPDATEALL:
//STRIP001 					UpdateAll();
//STRIP001 					break;
//STRIP001 
//STRIP001 				case FID_DATACHANGED:
//STRIP001 				case FID_ANYDATACHANGED:
//STRIP001 					aContentTimer.Start();		// Notizen nicht sofort suchen
//STRIP001 					break;
//STRIP001 
//STRIP001 				default:
//STRIP001 					break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( rHint.ISA(SfxEventHint) )
//STRIP001 	{
//STRIP001 		ULONG nEventId = ((SfxEventHint&)rHint).GetEventId();
//STRIP001 		if ( nEventId == SFX_EVENT_ACTIVATEDOC )
//STRIP001 		{
//STRIP001 			aLbEntries.ActiveDocChanged();
//STRIP001 			UpdateAll();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScNavigatorDlg, TimeHdl, Timer*, pTimer )
//STRIP001 {
//STRIP001 	if ( pTimer != &aContentTimer )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	aLbEntries.Refresh( SC_CONTENT_NOTE );
//STRIP001 	return 0;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScNavigatorDlg::SetDropMode(USHORT nNew)
//STRIP001 {
//STRIP001 	nDropMode = nNew;
//STRIP001 	aTbxCmd.UpdateButtons();
//STRIP001 
//STRIP001 	ScNavipiCfg& rCfg = SC_MOD()->GetNavipiCfg();
//STRIP001 	rCfg.SetDragMode(nDropMode);
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScNavigatorDlg::CursorPosChanged()
//STRIP001 {
//STRIP001 	//!	Eintraege selektieren ???
//STRIP001 
//STRIP001 //	if ( GetDBAtCursor( aStrDbName ) )
//STRIP001 //	if ( GetAreaAtCursor( aStrAreaName ) )
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 BOOL ScNavigatorDlg::GetDBAtCursor( String& rStrName )
//STRIP001 {
//STRIP001 	BOOL bFound = FALSE;
//STRIP001 
//STRIP001 	if ( GetViewData() )
//STRIP001 	{
//STRIP001 		USHORT nCol = aEdCol.GetCol();
//STRIP001 		USHORT nRow = aEdRow.GetRow();
//STRIP001 
//STRIP001 		if ( nCol > 0 && nRow > 0 )
//STRIP001 		{
//STRIP001 			ScDocument* pDoc  = pViewData->GetDocument();
//STRIP001 			ScDBData* 	pData = pDoc->GetDBAtCursor( nCol-1, nRow-1, pViewData->GetTabNo() );
//STRIP001 
//STRIP001 			bFound = ( pData != NULL );
//STRIP001 			if ( bFound )
//STRIP001 				pData->GetName( rStrName );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bFound;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 BOOL ScNavigatorDlg::GetAreaAtCursor( String& rStrName )
//STRIP001 {
//STRIP001 	BOOL bFound = FALSE;
//STRIP001 
//STRIP001 	if ( GetViewData() )
//STRIP001 	{
//STRIP001 		USHORT nCol = aEdCol.GetCol();
//STRIP001 		USHORT nRow = aEdRow.GetRow();
//STRIP001 
//STRIP001 		if ( nCol > 0 && nRow > 0 )
//STRIP001 		{
//STRIP001 			ScDocument*	 pDoc  = pViewData->GetDocument();
//STRIP001 			ScRangeData* pData = pDoc->GetRangeAtCursor( nCol-1, nRow-1, pViewData->GetTabNo() );
//STRIP001 
//STRIP001 			bFound = ( pData != NULL );
//STRIP001 			if ( bFound )
//STRIP001 				pData->GetName( rStrName );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bFound;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScNavigatorDlg::SetCurrentCell( USHORT nColNo, USHORT nRowNo )
//STRIP001 {
//STRIP001 	if ( (nColNo+1 != nCurCol) || (nRowNo+1 != nCurRow) )
//STRIP001 	{
//STRIP001 		// SID_CURRENTCELL == Item #0 Cache leeren, damit das Setzen der
//STRIP001 		// aktuellen Zelle auch in zusammengefassten Bereichen funktioniert.
//STRIP001 		ppBoundItems[0]->ClearCache();
//STRIP001 
//STRIP001 		ScAddress aScAddress( nColNo, nRowNo, 0 );
//STRIP001 		String	aAddr;
//STRIP001 		aScAddress.Format( aAddr, SCA_ABS );
//STRIP001 
//STRIP001 		BOOL bUnmark = FALSE;
//STRIP001 		if ( GetViewData() )
//STRIP001 			bUnmark = !pViewData->GetMarkData().IsCellMarked( nColNo, nRowNo );
//STRIP001 
//STRIP001 		SfxStringItem	aPosItem( SID_CURRENTCELL, aAddr );
//STRIP001 		SfxBoolItem		aUnmarkItem( FN_PARAM_1, bUnmark );		// ggf. Selektion aufheben
//STRIP001 
//STRIP001 		rBindings.GetDispatcher()->Execute( SID_CURRENTCELL,
//STRIP001 								  SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD,
//STRIP001 								  &aPosItem, &aUnmarkItem, 0L );
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScNavigatorDlg::SetCurrentCellStr( const String rName )
//STRIP001 {
//STRIP001 	ppBoundItems[0]->ClearCache();
//STRIP001 	SfxStringItem	aNameItem( SID_CURRENTCELL, rName );
//STRIP001 
//STRIP001 	rBindings.GetDispatcher()->Execute( SID_CURRENTCELL,
//STRIP001 							  SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD,
//STRIP001 							  &aNameItem, 0L );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScNavigatorDlg::SetCurrentTable( USHORT nTabNo )
//STRIP001 {
//STRIP001 	if ( nTabNo != nCurTab )
//STRIP001 	{
//STRIP001 		//	Tabelle fuer Basic ist 1-basiert
//STRIP001 		SfxUInt16Item aTabItem( SID_CURRENTTAB, nTabNo + 1 );
//STRIP001 		rBindings.GetDispatcher()->Execute( SID_CURRENTTAB,
//STRIP001 								  SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD,
//STRIP001 								  &aTabItem, 0L );
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScNavigatorDlg::SetCurrentTableStr( const String rName )
//STRIP001 {
//STRIP001 	if (!GetViewData()) return;
//STRIP001 
//STRIP001 	ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 	USHORT nCount	 = pDoc->GetTableCount();
//STRIP001 	String aTabName;
//STRIP001 
//STRIP001 	for ( USHORT i=0; i<nCount; i++ )
//STRIP001 	{
//STRIP001 		pDoc->GetName( i, aTabName );
//STRIP001 		if ( aTabName == rName )
//STRIP001 		{
//STRIP001 			SetCurrentTable( i );
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	Sound::Beep();					// Tabelle nicht gefunden
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScNavigatorDlg::SetCurrentObject( const String rName )
//STRIP001 {
//STRIP001 	SfxStringItem aNameItem( SID_CURRENTOBJECT, rName );
//STRIP001 	rBindings.GetDispatcher()->Execute( SID_CURRENTOBJECT,
//STRIP001 							  SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD,
//STRIP001 							  &aNameItem, 0L );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScNavigatorDlg::SetCurrentDoc( const String& rDocName )		// aktivieren
//STRIP001 {
//STRIP001 	SfxStringItem aDocItem( SID_CURRENTDOC, rDocName );
//STRIP001 	rBindings.GetDispatcher()->Execute( SID_CURRENTDOC,
//STRIP001 							  SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD,
//STRIP001 							  &aDocItem, 0L );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 ScTabViewShell* ScNavigatorDlg::GetTabViewShell() const
//STRIP001 {
//STRIP001     return PTR_CAST( ScTabViewShell, SfxViewShell::Current() );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 ScNavigatorSettings* ScNavigatorDlg::GetSettings()
//STRIP001 {
//STRIP001     //  #95791# Don't store the settings pointer here, because the settings belong to
//STRIP001     //  the view, and the view may be closed while the navigator is open (reload).
//STRIP001     //  If the pointer is cached here again later for performance reasons, it has to
//STRIP001     //  be forgotten when the view is closed.
//STRIP001 
//STRIP001     ScTabViewShell* pViewSh = GetTabViewShell();
//STRIP001     return pViewSh ? pViewSh->GetNavigatorSettings() : NULL;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 BOOL ScNavigatorDlg::GetViewData()
//STRIP001 {
//STRIP001     ScTabViewShell* pViewSh = GetTabViewShell();
//STRIP001 	pViewData = pViewSh ? pViewSh->GetViewData() : NULL;
//STRIP001 
//STRIP001 	return ( pViewData != NULL );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScNavigatorDlg::UpdateColumn( const USHORT* pCol )
//STRIP001 {
//STRIP001 	if ( pCol )
//STRIP001 		nCurCol = *pCol;
//STRIP001 	else if ( GetViewData() )
//STRIP001 		nCurCol = pViewData->GetCurX() + 1;
//STRIP001 
//STRIP001 	aEdCol.SetCol( nCurCol );
//STRIP001 	CheckDataArea();
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScNavigatorDlg::UpdateRow( const USHORT* pRow )
//STRIP001 {
//STRIP001 	if ( pRow )
//STRIP001 		nCurRow = *pRow;
//STRIP001 	else if ( GetViewData() )
//STRIP001 		nCurRow = pViewData->GetCurY() + 1;
//STRIP001 
//STRIP001 	aEdRow.SetRow( nCurRow );
//STRIP001 	CheckDataArea();
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScNavigatorDlg::UpdateTable( const USHORT* pTab )
//STRIP001 {
//STRIP001 	if ( pTab )
//STRIP001 		nCurTab = *pTab;
//STRIP001 	else if ( GetViewData() )
//STRIP001 		nCurTab = pViewData->GetTabNo();
//STRIP001 
//STRIP001 //	aLbTables.SetTab( nCurTab );
//STRIP001 	CheckDataArea();
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScNavigatorDlg::UpdateAll()
//STRIP001 {
//STRIP001 	switch ( eListMode )
//STRIP001 	{
//STRIP001 		case NAV_LMODE_DOCS:
//STRIP001 		case NAV_LMODE_DBAREAS:
//STRIP001 		case NAV_LMODE_AREAS:
//STRIP001             aLbEntries.Refresh();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case NAV_LMODE_NONE:
//STRIP001 			//!	???
//STRIP001 			break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	aContentTimer.Stop();		// dann nicht nochmal
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScNavigatorDlg::SetListMode( NavListMode eMode, BOOL bSetSize )
//STRIP001 {
//STRIP001 	if ( eMode != eListMode )
//STRIP001 	{
//STRIP001 		if ( eMode != NAV_LMODE_NONE )
//STRIP001 			bFirstBig = FALSE;				// nicht mehr automatisch umschalten
//STRIP001 
//STRIP001 		eListMode = eMode;
//STRIP001 
//STRIP001 		switch ( eMode )
//STRIP001 		{
//STRIP001 			case NAV_LMODE_NONE:
//STRIP001 				ShowList( FALSE, bSetSize );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case NAV_LMODE_AREAS:
//STRIP001 			case NAV_LMODE_DBAREAS:
//STRIP001 			case NAV_LMODE_DOCS:
//STRIP001 				aLbEntries.Refresh();
//STRIP001 				ShowList( TRUE, bSetSize );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case NAV_LMODE_SCENARIOS:
//STRIP001 				ShowScenarios( TRUE, bSetSize );
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001 		aTbxCmd.UpdateButtons();
//STRIP001 
//STRIP001 		if ( eMode != NAV_LMODE_NONE )
//STRIP001 		{
//STRIP001 			ScNavipiCfg& rCfg = SC_MOD()->GetNavipiCfg();
//STRIP001 			rCfg.SetListMode( (USHORT) eMode );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pMarkArea )
//STRIP001 		UnmarkDataArea();
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScNavigatorDlg::ShowList( BOOL bShow, BOOL bSetSize )
//STRIP001 {
//STRIP001 	FloatingWindow* pFloat = pContextWin->GetFloatingWindow();
//STRIP001 	Size aSize = GetParent()->GetOutputSizePixel();
//STRIP001 
//STRIP001 	if ( bShow )
//STRIP001 	{
//STRIP001 		Size aMinSize = aInitSize;
//STRIP001 
//STRIP001 		aMinSize.Height() += nInitListHeight;
//STRIP001 		if ( pFloat )
//STRIP001 			pFloat->SetMinOutputSizePixel( aMinSize );
//STRIP001 		aSize.Height() = nListModeHeight;
//STRIP001 		aLbEntries.Show();
//STRIP001 		aLbDocuments.Show();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( pFloat )
//STRIP001 		{
//STRIP001 			pFloat->SetMinOutputSizePixel( aInitSize );
//STRIP001 			nListModeHeight = aSize.Height();
//STRIP001 		}
//STRIP001 		aSize.Height() = aInitSize.Height();
//STRIP001 		aLbEntries.Hide();
//STRIP001 		aLbDocuments.Hide();
//STRIP001 	}
//STRIP001 	aWndScenarios.Hide();
//STRIP001 
//STRIP001 	if ( pFloat )
//STRIP001 	{
//STRIP001 		if ( bSetSize )
//STRIP001 			pFloat->SetOutputSizePixel( aSize );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SfxNavigator* pNav = (SfxNavigator*)GetParent();
//STRIP001 		Size aFloating = pNav->GetFloatingSize();
//STRIP001 		aFloating.Height() = aSize.Height();
//STRIP001 		pNav->SetFloatingSize( aFloating );
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScNavigatorDlg::ShowScenarios( BOOL bShow, BOOL bSetSize )
//STRIP001 {
//STRIP001 	FloatingWindow* pFloat = pContextWin->GetFloatingWindow();
//STRIP001 	Size aSize = GetParent()->GetOutputSizePixel();
//STRIP001 
//STRIP001 	if ( bShow )
//STRIP001 	{
//STRIP001 		Size aMinSize = aInitSize;
//STRIP001 		aMinSize.Height() += nInitListHeight;
//STRIP001 		if ( pFloat )
//STRIP001 			pFloat->SetMinOutputSizePixel( aMinSize );
//STRIP001 		aSize.Height() = nListModeHeight;
//STRIP001 
//STRIP001 		rBindings.Invalidate( SID_SELECT_SCENARIO );
//STRIP001 		rBindings.Update( SID_SELECT_SCENARIO );
//STRIP001 
//STRIP001 		aWndScenarios.Show();
//STRIP001 		aLbDocuments.Show();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( pFloat )
//STRIP001 		{
//STRIP001 			pFloat->SetMinOutputSizePixel( aInitSize );
//STRIP001 			nListModeHeight = aSize.Height();
//STRIP001 		}
//STRIP001 		aSize.Height() = aInitSize.Height();
//STRIP001 		aWndScenarios.Hide();
//STRIP001 		aLbDocuments.Hide();
//STRIP001 	}
//STRIP001 	aLbEntries.Hide();
//STRIP001 
//STRIP001 	if ( pFloat )
//STRIP001 	{
//STRIP001 		if ( bSetSize )
//STRIP001 			pFloat->SetOutputSizePixel( aSize );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SfxNavigator* pNav = (SfxNavigator*)GetParent();
//STRIP001 		Size aFloating = pNav->GetFloatingSize();
//STRIP001 		aFloating.Height() = aSize.Height();
//STRIP001 		pNav->SetFloatingSize( aFloating );
//STRIP001 	}
//STRIP001 }


//------------------------------------------------------------------------
//
//		Dokumente fuer Dropdown-Listbox
//
//------------------------------------------------------------------------

//STRIP001 void ScNavigatorDlg::GetDocNames( const String* pManualSel )
//STRIP001 {
//STRIP001 	aLbDocuments.Clear();
//STRIP001 	aLbDocuments.SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 	ScDocShell* pCurrentSh = PTR_CAST( ScDocShell, SfxObjectShell::Current() );
//STRIP001 
//STRIP001 	String aSelEntry;
//STRIP001 	SfxObjectShell* pSh = SfxObjectShell::GetFirst();
//STRIP001 	while ( pSh )
//STRIP001 	{
//STRIP001 		if ( pSh->ISA(ScDocShell) )
//STRIP001 		{
//STRIP001 			String aName = pSh->GetTitle();
//STRIP001 			String aEntry = aName;
//STRIP001 			if (pSh == pCurrentSh)
//STRIP001 				aEntry += aStrActive;
//STRIP001 			else
//STRIP001 				aEntry += aStrNotActive;
//STRIP001 			aLbDocuments.InsertEntry( aEntry );
//STRIP001 
//STRIP001 			if ( pManualSel ? ( aName == *pManualSel )
//STRIP001 							: ( pSh == pCurrentSh ) )
//STRIP001 				aSelEntry = aEntry;						// kompletter Eintrag zum Selektieren
//STRIP001 		}
//STRIP001 
//STRIP001 		pSh = SfxObjectShell::GetNext( *pSh );
//STRIP001 	}
//STRIP001 
//STRIP001 	aLbDocuments.InsertEntry( aStrActiveWin );
//STRIP001 
//STRIP001 	String aHidden =  aLbEntries.GetHiddenTitle();
//STRIP001 	if (aHidden.Len())
//STRIP001 	{
//STRIP001 		String aEntry = aHidden;
//STRIP001 		aEntry += aStrHidden;
//STRIP001 		aLbDocuments.InsertEntry( aEntry );
//STRIP001 
//STRIP001 		if ( pManualSel && aHidden == *pManualSel )
//STRIP001 			aSelEntry = aEntry;
//STRIP001 	}
//STRIP001 
//STRIP001 	aLbDocuments.SetUpdateMode( TRUE );
//STRIP001 
//STRIP001 	aLbDocuments.SelectEntry( aSelEntry );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScNavigatorDlg::MarkDataArea()
//STRIP001 {
//STRIP001     ScTabViewShell* pViewSh = GetTabViewShell();
//STRIP001 
//STRIP001 	if ( pViewSh )
//STRIP001 	{
//STRIP001 		ScDocument* pDoc = (pViewData = pViewSh->GetViewData())->GetDocument();
//STRIP001 
//STRIP001 		if ( !pMarkArea )
//STRIP001 			pMarkArea = new	ScArea;
//STRIP001 
//STRIP001 		pViewSh->MarkDataArea();
//STRIP001 		ScRange aMarkRange;
//STRIP001 		pViewSh->GetViewData()->GetMarkData().GetMarkArea(aMarkRange);
//STRIP001 		pMarkArea->nColStart = aMarkRange.aStart.Col();
//STRIP001 		pMarkArea->nRowStart = aMarkRange.aStart.Row();
//STRIP001 		pMarkArea->nColEnd = aMarkRange.aEnd.Col();
//STRIP001 		pMarkArea->nRowEnd = aMarkRange.aEnd.Row();
//STRIP001 		pMarkArea->nTab = aMarkRange.aStart.Tab();
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScNavigatorDlg::UnmarkDataArea()
//STRIP001 {
//STRIP001     ScTabViewShell* pViewSh = GetTabViewShell();
//STRIP001 
//STRIP001 	if ( pViewSh )
//STRIP001 	{
//STRIP001 		pViewSh->Unmark();
//STRIP001 		DELETEZ( pMarkArea );
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScNavigatorDlg::CheckDataArea()
//STRIP001 {
//STRIP001 	if ( aTbxCmd.IsItemChecked( IID_DATA ) && pMarkArea )
//STRIP001 	{
//STRIP001 		if (   nCurTab   != pMarkArea->nTab
//STRIP001 			|| nCurCol <  pMarkArea->nColStart+1
//STRIP001 			|| nCurCol >  pMarkArea->nColEnd+1
//STRIP001 			|| nCurRow <  pMarkArea->nRowStart+1
//STRIP001 			|| nCurRow >  pMarkArea->nRowEnd+1 )
//STRIP001 		{
//STRIP001 			aTbxCmd.SetItemState( IID_DATA, TriState(STATE_CHECK) );
//STRIP001 			aTbxCmd.Select( IID_DATA );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScNavigatorDlg::StartOfDataArea()
//STRIP001 {
//STRIP001 	//	pMarkArea auswerten ???
//STRIP001 
//STRIP001 	if ( GetViewData() )
//STRIP001 	{
//STRIP001 		ScMarkData& rMark = pViewData->GetMarkData();
//STRIP001 		ScRange aMarkRange;
//STRIP001 		rMark.GetMarkArea( aMarkRange );
//STRIP001 
//STRIP001 		USHORT nCol = aMarkRange.aStart.Col();
//STRIP001 		USHORT nRow = aMarkRange.aStart.Row();
//STRIP001 
//STRIP001 		if ( (nCol+1 != aEdCol.GetCol()) || (nRow+1 != aEdRow.GetRow()) )
//STRIP001 			SetCurrentCell( nCol, nRow );
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScNavigatorDlg::EndOfDataArea()
//STRIP001 {
//STRIP001 	//	pMarkArea auswerten ???
//STRIP001 
//STRIP001 	if ( GetViewData() )
//STRIP001 	{
//STRIP001 		ScMarkData& rMark = pViewData->GetMarkData();
//STRIP001 		ScRange aMarkRange;
//STRIP001 		rMark.GetMarkArea( aMarkRange );
//STRIP001 
//STRIP001 		USHORT nCol = aMarkRange.aEnd.Col();
//STRIP001 		USHORT nRow = aMarkRange.aEnd.Row();
//STRIP001 
//STRIP001 		if ( (nCol+1 != aEdCol.GetCol()) || (nRow+1 != aEdRow.GetRow()) )
//STRIP001 			SetCurrentCell( nCol, nRow );
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 SfxChildAlignment __EXPORT ScNavigatorDlg::CheckAlignment(
//STRIP001 							SfxChildAlignment eActAlign, SfxChildAlignment eAlign )
//STRIP001 {
//STRIP001 	SfxChildAlignment eRetAlign;
//STRIP001 
//STRIP001 	//!	kein Andocken, wenn Listbox nicht da ???
//STRIP001 
//STRIP001 	switch (eAlign)
//STRIP001 	{
//STRIP001 		case SFX_ALIGN_TOP:
//STRIP001 		case SFX_ALIGN_HIGHESTTOP:
//STRIP001 		case SFX_ALIGN_LOWESTTOP:
//STRIP001 		case SFX_ALIGN_BOTTOM:
//STRIP001 		case SFX_ALIGN_LOWESTBOTTOM:
//STRIP001 		case SFX_ALIGN_HIGHESTBOTTOM:
//STRIP001 			eRetAlign = eActAlign;				// nicht erlaubt
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SFX_ALIGN_LEFT:
//STRIP001 		case SFX_ALIGN_RIGHT:
//STRIP001 		case SFX_ALIGN_FIRSTLEFT:
//STRIP001 		case SFX_ALIGN_LASTLEFT:
//STRIP001 		case SFX_ALIGN_FIRSTRIGHT:
//STRIP001 		case SFX_ALIGN_LASTRIGHT:
//STRIP001 			eRetAlign = eAlign;					// erlaubt
//STRIP001 			break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			eRetAlign = eAlign;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	return eRetAlign;
//STRIP001 }

//------------------------------------------------------------------------
//
//	Drop auf den Navigator - andere Datei laden (File oder Bookmark)
//
//------------------------------------------------------------------------

//STRIP001 #if 0
//STRIP001 BOOL __EXPORT ScNavigatorDlg::Drop( const DropEvent& rEvt )
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 	if ( !aLbEntries.IsInDrag() )		// kein Verschieben innerhalb der TreeListBox
//STRIP001 	{
//STRIP001 		String aFileName;
//STRIP001 
//STRIP001 		SvDataObjectRef pObject = SvDataObject::PasteDragServer(rEvt);
//STRIP001 
//STRIP001 		ULONG nFormat = INetBookmark::HasFormat(*pObject);
//STRIP001 		INetBookmark aBookmark;
//STRIP001 		if (aBookmark.Paste(*pObject,nFormat))
//STRIP001 			aFileName = aBookmark.GetURL();
//STRIP001 		else
//STRIP001 		{
//STRIP001 			//	FORMAT_FILE direkt aus DragServer
//STRIP001 
//STRIP001 			USHORT nCount = DragServer::GetItemCount();
//STRIP001 			for ( USHORT i = 0; i < nCount && !aFileName.Len(); ++i )
//STRIP001 				if (DragServer::HasFormat( i, FORMAT_FILE ))
//STRIP001 					aFileName = DragServer::PasteFile( i );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( aFileName.Len() )
//STRIP001 			bReturn = aLbEntries.LoadFile( aFileName );
//STRIP001 	}
//STRIP001 	return bReturn;
//STRIP001 }

//STRIP001 BOOL __EXPORT ScNavigatorDlg::QueryDrop( DropEvent& rEvt )
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 	if ( !aLbEntries.IsInDrag() )		// kein Verschieben innerhalb der TreeListBox
//STRIP001 	{
//STRIP001 		SvDataObjectRef pObject = SvDataObject::PasteDragServer(rEvt);
//STRIP001 		if ( pObject->HasFormat(FORMAT_FILE)
//STRIP001 			|| INetBookmark::HasFormat(*pObject) )
//STRIP001 		{
//STRIP001 			rEvt.SetAction(DROP_COPY);		// Kopier-Cursor anzeigen
//STRIP001 			bReturn = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bReturn;
//STRIP001 }
//STRIP001 #endif



}
