/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_colrowba.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:22:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

// auto strip #include <bf_svx/svdtrans.hxx>

// auto strip #ifndef _UNOTOOLS_LOCALEDATAWRAPPER_HXX
// auto strip #include <unotools/localedatawrapper.hxx>
// auto strip #endif

#include "colrowba.hxx"
// auto strip #include "document.hxx"
// auto strip #include "scmod.hxx"
#include "tabvwsh.hxx"
#include "docsh.hxx"
// auto strip #include "appoptio.hxx"
#include "globstr.hrc"
namespace binfilter {

// STATIC DATA -----------------------------------------------------------

//==================================================================

//STRIP001 String lcl_MetricString( long nTwips, const String& rText )
//STRIP001 {
//STRIP001 	if ( nTwips <= 0 )
//STRIP001 		return ScGlobal::GetRscString(STR_TIP_HIDE);
//STRIP001 	else
//STRIP001 	{
//STRIP001 		FieldUnit eUserMet = SC_MOD()->GetAppOptions().GetAppMetric();
//STRIP001 
//STRIP001 		long nUserVal = MetricField::ConvertValue( nTwips*100, 1, 2, FUNIT_TWIP, eUserMet );
//STRIP001 
//STRIP001 		String aStr = rText;
//STRIP001 		aStr += ' ';
//STRIP001         aStr += ScGlobal::pLocaleData->getNum( nUserVal, 2 );
//STRIP001 		aStr += ' ';
//STRIP001 		aStr += SdrFormatter::GetUnitStr(eUserMet);
//STRIP001 
//STRIP001 		return aStr;
//STRIP001 	}
//STRIP001 }

//==================================================================

/*N*/ ScColBar::ScColBar( Window* pParent, ScViewData* pData, ScHSplitPos eWhichPos,
/*N*/ 					ScHeaderFunctionSet* pFunc, ScHeaderSelectionEngine* pEng ) :
/*N*/ 			ScHeaderControl( pParent, pEng, MAXCOL+1, HDR_HORIZONTAL ),
/*N*/ 			pViewData( pData ),
/*N*/ 			eWhich( eWhichPos ),
/*N*/ 			pFuncSet( pFunc ),
/*N*/ 			pSelEngine( pEng )
/*N*/ {
/*N*/ 	Show();
/*N*/ }

/*N*/ ScColBar::~ScColBar()
/*N*/ {
/*N*/ }

/*N*/ USHORT ScColBar::GetPos()
/*N*/ {
/*N*/ 	return pViewData->GetPosX(eWhich);
/*N*/ }

/*N*/ USHORT ScColBar::GetEntrySize( USHORT nEntryNo )
/*N*/ {
/*N*/ 	ScDocument* pDoc = pViewData->GetDocument();
/*N*/ 	USHORT nTab = pViewData->GetTabNo();
/*N*/ 	if ( pDoc->GetColFlags( nEntryNo, nTab ) & CR_HIDDEN )
/*N*/ 		return 0;
/*N*/ 	else
/*N*/ 		return (USHORT) ScViewData::ToPixel( pDoc->GetColWidth( nEntryNo, nTab ), pViewData->GetPPTX() );
/*N*/ }

//STRIP001 String ScColBar::GetEntryText( USHORT nEntryNo )
//STRIP001 {
//STRIP001 	return ColToAlpha( nEntryNo );
//STRIP001 }

//STRIP001 void ScColBar::SetEntrySize( USHORT nPos, USHORT nNewSize )
//STRIP001 {
//STRIP001 	USHORT nSizeTwips;
//STRIP001 	ScSizeMode eMode = SC_SIZE_DIRECT;
//STRIP001 	if (nNewSize>0 && nNewSize<10) nNewSize=10;				// (Pixel)
//STRIP001 
//STRIP001 	if ( nNewSize == HDR_SIZE_OPTIMUM )
//STRIP001 	{
//STRIP001 		nSizeTwips = STD_EXTRA_WIDTH;
//STRIP001 		eMode = SC_SIZE_OPTIMAL;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nSizeTwips = (USHORT) ( nNewSize / pViewData->GetPPTX() );
//STRIP001 
//STRIP001 	ScMarkData& rMark = pViewData->GetMarkData();
//STRIP001 //	USHORT nTab = pViewData->GetTabNo();
//STRIP001 
//STRIP001 	USHORT* pRanges = new USHORT[MAXCOL+1];
//STRIP001 	USHORT nRangeCnt = 0;
//STRIP001 	if ( rMark.IsColumnMarked( nPos ) )
//STRIP001 	{
//STRIP001 		USHORT nStart = 0;
//STRIP001 		while (nStart<=MAXCOL)
//STRIP001 		{
//STRIP001 			while (nStart<MAXCOL && !rMark.IsColumnMarked(nStart))
//STRIP001 				++nStart;
//STRIP001 			if (rMark.IsColumnMarked(nStart))
//STRIP001 			{
//STRIP001 				USHORT nEnd = nStart;
//STRIP001 				while (nEnd<MAXCOL && rMark.IsColumnMarked(nEnd))
//STRIP001 					++nEnd;
//STRIP001 				if (!rMark.IsColumnMarked(nEnd))
//STRIP001 					--nEnd;
//STRIP001 				pRanges[2*nRangeCnt  ] = nStart;
//STRIP001 				pRanges[2*nRangeCnt+1] = nEnd;
//STRIP001 				++nRangeCnt;
//STRIP001 				nStart = nEnd+1;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nStart = MAXCOL+1;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pRanges[0] = nPos;
//STRIP001 		pRanges[1] = nPos;
//STRIP001 		nRangeCnt = 1;
//STRIP001 	}
//STRIP001 
//STRIP001 	pViewData->GetView()->SetWidthOrHeight( TRUE, nRangeCnt, pRanges, eMode, nSizeTwips );
//STRIP001 	delete[] pRanges;
//STRIP001 }

//STRIP001 void ScColBar::HideEntries( USHORT nStart, USHORT nEnd )
//STRIP001 {
//STRIP001 	USHORT nRange[2];
//STRIP001 	nRange[0] = nStart;
//STRIP001 	nRange[1] = nEnd;
//STRIP001 	pViewData->GetView()->SetWidthOrHeight( TRUE, 1, nRange, SC_SIZE_DIRECT, 0 );
//STRIP001 }

/*M*/ void ScColBar::SetMarking( BOOL bSet )
/*M*/ {
/*M*/ 	pViewData->GetMarkData().SetMarking( bSet );
/*M*/ 	if (!bSet)
/*M*/ 	{
/*M*/ 		pViewData->GetView()->UpdateAutoFillMark();
/*M*/ 	}
/*M*/ }

//STRIP001 void ScColBar::SelectWindow()
//STRIP001 {
//STRIP001 	ScTabViewShell* pViewSh = pViewData->GetViewShell();
//STRIP001 
//STRIP001 	pViewSh->SetActive();			// Appear und SetViewFrame
//STRIP001 	pViewSh->DrawDeselectAll();
//STRIP001 
//STRIP001 	ScSplitPos eActive = pViewData->GetActivePart();
//STRIP001 	if (eWhich==SC_SPLIT_LEFT)
//STRIP001 	{
//STRIP001 		if (eActive==SC_SPLIT_TOPRIGHT)		eActive=SC_SPLIT_TOPLEFT;
//STRIP001 		if (eActive==SC_SPLIT_BOTTOMRIGHT)	eActive=SC_SPLIT_BOTTOMLEFT;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if (eActive==SC_SPLIT_TOPLEFT)		eActive=SC_SPLIT_TOPRIGHT;
//STRIP001 		if (eActive==SC_SPLIT_BOTTOMLEFT)	eActive=SC_SPLIT_BOTTOMRIGHT;
//STRIP001 	}
//STRIP001 	pViewSh->ActivatePart( eActive );
//STRIP001 
//STRIP001 	pFuncSet->SetColumn( TRUE );
//STRIP001 	pFuncSet->SetWhich( eActive );
//STRIP001 
//STRIP001 	pViewSh->ActiveGrabFocus();
//STRIP001 }

//STRIP001 BOOL ScColBar::IsDisabled()
//STRIP001 {
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	return pScMod->IsFormulaMode() || pScMod->IsModalMode();
//STRIP001 }

//STRIP001 BOOL ScColBar::ResizeAllowed()
//STRIP001 {
//STRIP001 	return !pViewData->HasEditView( pViewData->GetActivePart() ) &&
//STRIP001 			!pViewData->GetDocShell()->IsReadOnly();
//STRIP001 }

//STRIP001 void ScColBar::DrawInvert( long nDragPos )
//STRIP001 {
//STRIP001 	Rectangle aRect( nDragPos,0, nDragPos+HDR_SLIDERSIZE-1,GetOutputSizePixel().Width()-1 );
//STRIP001 	Update();
//STRIP001 	Invert(aRect);
//STRIP001 
//STRIP001 	pViewData->GetView()->InvertVertical(eWhich,nDragPos);
//STRIP001 }

//STRIP001 String ScColBar::GetDragHelp( long nVal )
//STRIP001 {
//STRIP001 	long nTwips = (long) ( nVal / pViewData->GetPPTX() );
//STRIP001 	return lcl_MetricString( nTwips, ScGlobal::GetRscString(STR_TIP_WIDTH) );
//STRIP001 }

//==================================================================

/*N*/ ScRowBar::ScRowBar( Window* pParent, ScViewData* pData, ScVSplitPos eWhichPos,
/*N*/ 					ScHeaderFunctionSet* pFunc, ScHeaderSelectionEngine* pEng ) :
/*N*/ 			ScHeaderControl( pParent, pEng, MAXROW+1, HDR_VERTICAL ),
/*N*/ 			pViewData( pData ),
/*N*/ 			eWhich( eWhichPos ),
/*N*/ 			pFuncSet( pFunc ),
/*N*/ 			pSelEngine( pEng )
/*N*/ {
/*N*/ 	Show();
/*N*/ }

/*N*/ ScRowBar::~ScRowBar()
/*N*/ {
/*N*/ }

/*N*/ USHORT ScRowBar::GetPos()
/*N*/ {
/*N*/ 	return pViewData->GetPosY(eWhich);
/*N*/ }

/*N*/ USHORT ScRowBar::GetEntrySize( USHORT nEntryNo )
/*N*/ {
/*N*/ 	ScDocument* pDoc = pViewData->GetDocument();
/*N*/ 	USHORT nTab = pViewData->GetTabNo();
/*N*/ 	if ( pDoc->GetRowFlags( nEntryNo, nTab ) & CR_HIDDEN )
/*N*/ 		return 0;
/*N*/ 	else
/*N*/ 		return (USHORT) ScViewData::ToPixel( pDoc->GetRowHeight( nEntryNo, nTab ), pViewData->GetPPTY() );
/*N*/ }

//STRIP001 String ScRowBar::GetEntryText( USHORT nEntryNo )
//STRIP001 {
//STRIP001 	return String::CreateFromInt32( nEntryNo + 1 );
//STRIP001 }

//STRIP001 void ScRowBar::SetEntrySize( USHORT nPos, USHORT nNewSize )
//STRIP001 {
//STRIP001 	USHORT nSizeTwips;
//STRIP001 	ScSizeMode eMode = SC_SIZE_DIRECT;
//STRIP001 	if (nNewSize>0 && nNewSize<10) nNewSize=10;				// (Pixel)
//STRIP001 
//STRIP001 	if ( nNewSize == HDR_SIZE_OPTIMUM )
//STRIP001 	{
//STRIP001 		nSizeTwips = 0;
//STRIP001 		eMode = SC_SIZE_OPTIMAL;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nSizeTwips = (USHORT) ( nNewSize / pViewData->GetPPTY() );
//STRIP001 
//STRIP001 	ScMarkData& rMark = pViewData->GetMarkData();
//STRIP001 //	USHORT nTab = pViewData->GetTabNo();
//STRIP001 
//STRIP001 	USHORT* pRanges = new USHORT[MAXROW+1];
//STRIP001 	USHORT nRangeCnt = 0;
//STRIP001 	if ( rMark.IsRowMarked( nPos ) )
//STRIP001 	{
//STRIP001 		USHORT nStart = 0;
//STRIP001 		while (nStart<=MAXROW)
//STRIP001 		{
//STRIP001 			while (nStart<MAXROW && !rMark.IsRowMarked(nStart))
//STRIP001 				++nStart;
//STRIP001 			if (rMark.IsRowMarked(nStart))
//STRIP001 			{
//STRIP001 				USHORT nEnd = nStart;
//STRIP001 				while (nEnd<MAXROW && rMark.IsRowMarked(nEnd))
//STRIP001 					++nEnd;
//STRIP001 				if (!rMark.IsRowMarked(nEnd))
//STRIP001 					--nEnd;
//STRIP001 				pRanges[2*nRangeCnt  ] = nStart;
//STRIP001 				pRanges[2*nRangeCnt+1] = nEnd;
//STRIP001 				++nRangeCnt;
//STRIP001 				nStart = nEnd+1;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nStart = MAXROW+1;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pRanges[0] = nPos;
//STRIP001 		pRanges[1] = nPos;
//STRIP001 		nRangeCnt = 1;
//STRIP001 	}
//STRIP001 
//STRIP001 	pViewData->GetView()->SetWidthOrHeight( FALSE, nRangeCnt, pRanges, eMode, nSizeTwips );
//STRIP001 	delete[] pRanges;
//STRIP001 }

//STRIP001 void ScRowBar::HideEntries( USHORT nStart, USHORT nEnd )
//STRIP001 {
//STRIP001 	USHORT nRange[2];
//STRIP001 	nRange[0] = nStart;
//STRIP001 	nRange[1] = nEnd;
//STRIP001 	pViewData->GetView()->SetWidthOrHeight( FALSE, 1, nRange, SC_SIZE_DIRECT, 0 );
//STRIP001 }

/*M*/ void ScRowBar::SetMarking( BOOL bSet )
/*M*/ {
/*M*/ 	pViewData->GetMarkData().SetMarking( bSet );
/*M*/ 	if (!bSet)
/*M*/ 	{
/*M*/ 		pViewData->GetView()->UpdateAutoFillMark();
/*M*/ 	}
/*M*/ }

//STRIP001 void ScRowBar::SelectWindow()
//STRIP001 {
//STRIP001 	ScTabViewShell* pViewSh = pViewData->GetViewShell();
//STRIP001 
//STRIP001 	pViewSh->SetActive();			// Appear und SetViewFrame
//STRIP001 	pViewSh->DrawDeselectAll();
//STRIP001 
//STRIP001 	ScSplitPos eActive = pViewData->GetActivePart();
//STRIP001 	if (eWhich==SC_SPLIT_TOP)
//STRIP001 	{
//STRIP001 		if (eActive==SC_SPLIT_BOTTOMLEFT)	eActive=SC_SPLIT_TOPLEFT;
//STRIP001 		if (eActive==SC_SPLIT_BOTTOMRIGHT)	eActive=SC_SPLIT_TOPRIGHT;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if (eActive==SC_SPLIT_TOPLEFT)		eActive=SC_SPLIT_BOTTOMLEFT;
//STRIP001 		if (eActive==SC_SPLIT_TOPRIGHT)		eActive=SC_SPLIT_BOTTOMRIGHT;
//STRIP001 	}
//STRIP001 	pViewSh->ActivatePart( eActive );
//STRIP001 
//STRIP001 	pFuncSet->SetColumn( FALSE );
//STRIP001 	pFuncSet->SetWhich( eActive );
//STRIP001 
//STRIP001 	pViewSh->ActiveGrabFocus();
//STRIP001 }

//STRIP001 BOOL ScRowBar::IsDisabled()
//STRIP001 {
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	return pScMod->IsFormulaMode() || pScMod->IsModalMode();
//STRIP001 }

//STRIP001 BOOL ScRowBar::ResizeAllowed()
//STRIP001 {
//STRIP001 	return !pViewData->HasEditView( pViewData->GetActivePart() ) &&
//STRIP001 			!pViewData->GetDocShell()->IsReadOnly();
//STRIP001 }

//STRIP001 void ScRowBar::DrawInvert( long nDragPos )
//STRIP001 {
//STRIP001 	Rectangle aRect( 0,nDragPos, GetOutputSizePixel().Width()-1,nDragPos+HDR_SLIDERSIZE-1 );
//STRIP001 	Update();
//STRIP001 	Invert(aRect);
//STRIP001 
//STRIP001 	pViewData->GetView()->InvertHorizontal(eWhich,nDragPos);
//STRIP001 }

//STRIP001 String ScRowBar::GetDragHelp( long nVal )
//STRIP001 {
//STRIP001 	long nTwips = (long) ( nVal / pViewData->GetPPTY() );
//STRIP001 	return lcl_MetricString( nTwips, ScGlobal::GetRscString(STR_TIP_HEIGHT) );
//STRIP001 }

//	GetHiddenCount ist nur fuer Zeilen ueberladen

//STRIP001 USHORT ScRowBar::GetHiddenCount( USHORT nEntryNo )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 	USHORT nTab = pViewData->GetTabNo();
//STRIP001 	return pDoc->GetHiddenRowCount( nEntryNo, nTab );
//STRIP001 }



}
