/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_editsh.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:25:46 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------

#include "scitems.hxx"
#include <bf_svx/eeitem.hxx>
#define ITEMID_FIELD EE_FEATURE_FIELD

// auto strip #include <bf_svx/clipfmtitem.hxx>
// auto strip #include <bf_svx/cntritem.hxx>
// auto strip #include <bf_svx/chardlg.hxx>
// auto strip #include <bf_svx/crsditem.hxx>
// auto strip #include <bf_svx/editeng.hxx>
// auto strip #include <bf_svx/editview.hxx>
// auto strip #include <bf_svx/escpitem.hxx>

// auto strip #ifndef _PSTM_HXX
// auto strip #include <tools/pstm.hxx>
// auto strip #endif

#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif

#ifndef _SVX_ITEMDATA_HXX
#include <bf_svx/itemdata.hxx>
#endif

#ifndef _DATE_HXX
#include <tools/date.hxx>
#endif

#ifndef _TOOLS_TIME_HXX
#include <tools/time.hxx>
#endif

// auto strip #include <bf_svx/flditem.hxx>
// auto strip #include <bf_svx/fontitem.hxx>
// auto strip #include <bf_svx/hlnkitem.hxx>
// auto strip #include <bf_svx/postitem.hxx>
// auto strip #include <bf_svx/scripttypeitem.hxx>
// auto strip #include <bf_svx/shdditem.hxx>
// auto strip #include <bf_svx/srchitem.hxx>
// auto strip #include <bf_svx/udlnitem.hxx>
// auto strip #include <bf_svx/wghtitem.hxx>
// auto strip #include <bf_sfx2/basedlgs.hxx>
#include <bf_sfx2/bindings.hxx>
// auto strip #include <bf_sfx2/msg.hxx>
#include <bf_sfx2/objface.hxx>
// auto strip #include <bf_sfx2/objsh.hxx>
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #include <so3/pastedlg.hxx>
// auto strip #include <sot/exchange.hxx>
// auto strip #include <svtools/cjkoptions.hxx>
// auto strip #include <svtools/cliplistener.hxx>
// auto strip #include <svtools/whiter.hxx>
// auto strip #include <vcl/msgbox.hxx>
// auto strip #include <vcl/sound.hxx>


#define _EDITSH_CXX
#include "editsh.hxx"

#include "scresid.hxx"
// auto strip #include "global.hxx"
#include "bf_sc.hrc"
// auto strip #include "scmod.hxx"
// auto strip #include "inputhdl.hxx"
// auto strip #include "viewutil.hxx"
// auto strip #include "viewdata.hxx"
// auto strip #include "document.hxx"
// auto strip #include "namepast.hxx"
// auto strip #include "reffind.hxx"
// auto strip #include "tabvwsh.hxx"
// auto strip #include "textdlgs.hxx"
// auto strip #include "editutil.hxx"
#include "globstr.hrc"
namespace binfilter {

#define ScEditShell
#include "scslots.hxx"


//STRIP001 TYPEINIT1( ScEditShell, SfxShell );

/*N*/ SFX_IMPL_INTERFACE(ScEditShell, SfxShell, ScResId(SCSTR_EDITSHELL))
/*N*/ {
/*N*/ 	SFX_POPUPMENU_REGISTRATION( ScResId(RID_POPUP_EDIT) );
/*N*/ 	SFX_OBJECTMENU_REGISTRATION( SID_OBJECTMENU0, ScResId(RID_OBJECTMENU_EDIT) );
/*N*/ }


//STRIP001 ScEditShell::ScEditShell(EditView* pView, ScViewData* pData) :
//STRIP001 	pEditView		(pView),
//STRIP001 	pViewData		(pData),
//STRIP001 	pClipEvtLstnr	(NULL),
//STRIP001 	bPastePossible	(FALSE),
//STRIP001 	bIsInsertMode	(TRUE)
//STRIP001 {
//STRIP001 	SetPool( pEditView->GetEditEngine()->GetEmptyItemSet().GetPool() );
//STRIP001 	SetUndoManager( &pEditView->GetEditEngine()->GetUndoManager() );
//STRIP001 	SetName(String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("EditCell")));
//STRIP001 }
//STRIP001 
//STRIP001 ScEditShell::~ScEditShell()
//STRIP001 {
//STRIP001 	if ( pClipEvtLstnr )
//STRIP001 	{
//STRIP001 		pClipEvtLstnr->AddRemoveListener( pViewData->GetActiveWin(), FALSE );
//STRIP001 		pClipEvtLstnr->release();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 ScInputHandler* ScEditShell::GetMyInputHdl()
//STRIP001 {
//STRIP001 	return SC_MOD()->GetInputHdl( pViewData->GetViewShell() );
//STRIP001 }
//STRIP001 
//STRIP001 void ScEditShell::SetEditView(EditView* pView)
//STRIP001 {
//STRIP001 	pEditView = pView;
//STRIP001 	pEditView->SetInsertMode( bIsInsertMode );
//STRIP001 	SetPool( pEditView->GetEditEngine()->GetEmptyItemSet().GetPool() );
//STRIP001 	SetUndoManager( &pEditView->GetEditEngine()->GetUndoManager() );
//STRIP001 }
//STRIP001 
//STRIP001 void lcl_RemoveAttribs( EditView& rEditView )
//STRIP001 {
//STRIP001 	ScEditEngineDefaulter* pEngine = static_cast<ScEditEngineDefaulter*>(rEditView.GetEditEngine());
//STRIP001 
//STRIP001 	BOOL bOld = pEngine->GetUpdateMode();
//STRIP001 	pEngine->SetUpdateMode(FALSE);
//STRIP001 
//STRIP001 	String aName = ScGlobal::GetRscString( STR_UNDO_DELETECONTENTS );
//STRIP001 	pEngine->GetUndoManager().EnterListAction( aName, aName );
//STRIP001 
//STRIP001 	rEditView.RemoveAttribs(TRUE);
//STRIP001 	pEngine->RepeatDefaults();		// #97226# paragraph attributes from cell formats must be preserved
//STRIP001 
//STRIP001 	pEngine->GetUndoManager().LeaveListAction();
//STRIP001 
//STRIP001 	pEngine->SetUpdateMode(bOld);
//STRIP001 }

//STRIP001 void ScEditShell::Execute( SfxRequest& rReq )
//STRIP001 {
//STRIP001 	const SfxItemSet*	pReqArgs	= rReq.GetArgs();
//STRIP001 	USHORT				nSlot		= rReq.GetSlot();
//STRIP001 	SfxBindings&		rBindings	= pViewData->GetBindings();
//STRIP001 
//STRIP001 	ScInputHandler* pHdl = GetMyInputHdl();
//STRIP001 	DBG_ASSERT(pHdl,"kein ScInputHandler");
//STRIP001 
//STRIP001 	EditView* pTopView	 = pHdl->GetTopView();		// hat Eingabezeile den Focus?
//STRIP001 	EditView* pTableView = pHdl->GetTableView();
//STRIP001 
//STRIP001 	DBG_ASSERT(pTableView,"keine EditView :-(");
//STRIP001 
//STRIP001 	EditEngine* pEngine = pTableView->GetEditEngine();
//STRIP001 
//STRIP001 	pHdl->DataChanging();
//STRIP001 	BOOL bSetSelIsRef = FALSE;
//STRIP001 
//STRIP001 	switch ( nSlot )
//STRIP001 	{
//STRIP001 		case FID_INS_CELL_CONTENTS: // Insert-Taste, weil als Acc definiert
//STRIP001 			bIsInsertMode = !pTableView->IsInsertMode();
//STRIP001 			pTableView->SetInsertMode( bIsInsertMode );
//STRIP001 			if (pTopView)
//STRIP001 				pTopView->SetInsertMode( bIsInsertMode );
//STRIP001 			rBindings.Invalidate( SID_ATTR_INSERT );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_ATTR_INSERT:
//STRIP001 			if ( pReqArgs )
//STRIP001 			{
//STRIP001 				bIsInsertMode = ((const SfxBoolItem&)pReqArgs->Get(nSlot)).GetValue();
//STRIP001 				pTableView->SetInsertMode( bIsInsertMode );
//STRIP001 				if (pTopView)
//STRIP001 					pTopView->SetInsertMode( bIsInsertMode );
//STRIP001 				rBindings.Invalidate( SID_ATTR_INSERT );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_COPY:
//STRIP001 			pTableView->Copy();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_CUT:
//STRIP001 			pTableView->Cut();
//STRIP001 			if (pTopView)
//STRIP001 				pTopView->DeleteSelected();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_PASTE:
//STRIP001 			pTableView->PasteSpecial();
//STRIP001 			if (pTopView)
//STRIP001 				pTopView->Paste();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_DELETE:
//STRIP001 			pTableView->DeleteSelected();
//STRIP001 			if (pTopView)
//STRIP001 				pTopView->DeleteSelected();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_CELL_FORMAT_RESET:					// "Standard"
//STRIP001 			lcl_RemoveAttribs( *pTableView );
//STRIP001 			if ( pTopView )
//STRIP001 				lcl_RemoveAttribs( *pTopView );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_CLIPBOARD_FORMAT_ITEMS:
//STRIP001 			{
//STRIP001 				ULONG nFormat = 0;
//STRIP001 				const SfxPoolItem* pItem;
//STRIP001 				if ( pReqArgs &&
//STRIP001 					 pReqArgs->GetItemState(nSlot, TRUE, &pItem) == SFX_ITEM_SET &&
//STRIP001 					 pItem->ISA(SfxUInt32Item) )
//STRIP001 				{
//STRIP001 					nFormat = ((const SfxUInt32Item*)pItem)->GetValue();
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( nFormat )
//STRIP001 				{
//STRIP001 					if (SOT_FORMAT_STRING == nFormat)
//STRIP001 						pTableView->Paste();
//STRIP001 					else
//STRIP001 						pTableView->PasteSpecial();
//STRIP001 
//STRIP001 					if (pTopView)
//STRIP001 						pTopView->Paste();
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case FID_PASTE_CONTENTS:
//STRIP001 			{
//STRIP001 				SvPasteObjectDialog* pDlg = new SvPasteObjectDialog;
//STRIP001 				pDlg->Insert( SOT_FORMAT_STRING, EMPTY_STRING );
//STRIP001 				pDlg->Insert( SOT_FORMAT_RTF,	 EMPTY_STRING );
//STRIP001 
//STRIP001 				TransferableDataHelper aDataHelper(
//STRIP001 					TransferableDataHelper::CreateFromSystemClipboard( pViewData->GetActiveWin() ) );
//STRIP001 
//STRIP001 				ULONG nFormat = pDlg->Execute( pViewData->GetDialogParent(), aDataHelper.GetTransferable() );
//STRIP001 				DELETEZ(pDlg);
//STRIP001 
//STRIP001 				// while the dialog was open, edit mode may have been stopped
//STRIP001 				if (!SC_MOD()->IsInputMode())
//STRIP001 				{
//STRIP001 					Sound::Beep();
//STRIP001 					return;
//STRIP001 				}
//STRIP001 
//STRIP001 				if (nFormat > 0)
//STRIP001 				{
//STRIP001 					if (SOT_FORMAT_STRING == nFormat)
//STRIP001 						pTableView->Paste();
//STRIP001 					else
//STRIP001 						pTableView->PasteSpecial();
//STRIP001 
//STRIP001 					if (pTopView)
//STRIP001 						pTopView->Paste();
//STRIP001 				}
//STRIP001 
//STRIP001 				if (pTopView)
//STRIP001 					pTopView->GetWindow()->GrabFocus();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_SELECTALL:
//STRIP001 			{
//STRIP001 				USHORT nPar = pEngine->GetParagraphCount();
//STRIP001 				if (nPar)
//STRIP001 				{
//STRIP001 					xub_StrLen nLen = pEngine->GetTextLen(nPar-1);
//STRIP001 					pTableView->SetSelection(ESelection(0,0,nPar-1,nLen));
//STRIP001 					if (pTopView)
//STRIP001 						pTopView->SetSelection(ESelection(0,0,nPar-1,nLen));
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_CHARMAP:
//STRIP001 			{
//STRIP001 				USHORT nScript = pTableView->GetSelectedScriptType();
//STRIP001 				USHORT nFontWhich = ( nScript == SCRIPTTYPE_ASIAN ) ? EE_CHAR_FONTINFO_CJK :
//STRIP001 								( ( nScript == SCRIPTTYPE_COMPLEX ) ? EE_CHAR_FONTINFO_CTL :
//STRIP001 																		EE_CHAR_FONTINFO );
//STRIP001 				const SvxFontItem& rItem = (const SvxFontItem&)
//STRIP001 							pTableView->GetAttribs().Get(nFontWhich);
//STRIP001 
//STRIP001 				String aString;
//STRIP001 				SvxFontItem aNewItem( EE_CHAR_FONTINFO );
//STRIP001 
//STRIP001 				BOOL bOk = ScViewUtil::ExecuteCharMap( rItem, aNewItem, aString );
//STRIP001 
//STRIP001 				// while the dialog was open, edit mode may have been stopped
//STRIP001 				if (!SC_MOD()->IsInputMode())
//STRIP001 				{
//STRIP001 					Sound::Beep();
//STRIP001 					return;
//STRIP001 				}
//STRIP001 
//STRIP001 				if (bOk)
//STRIP001 				{
//STRIP001 					//	if string contains WEAK characters, set all fonts
//STRIP001 					BYTE nScript;
//STRIP001 					ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 					if ( pDoc->HasStringWeakCharacters( aString ) )
//STRIP001 						nScript = SCRIPTTYPE_LATIN | SCRIPTTYPE_ASIAN | SCRIPTTYPE_COMPLEX;
//STRIP001 					else
//STRIP001 						nScript = pDoc->GetStringScriptType( aString );
//STRIP001 
//STRIP001 					SfxItemSet aSet( pTableView->GetEmptyItemSet() );
//STRIP001 					SvxScriptSetItem aSetItem( SID_ATTR_CHAR_FONT, GetPool() );
//STRIP001 					aSetItem.PutItemForScriptType( nScript, aNewItem );
//STRIP001 					aSet.Put( aSetItem.GetItemSet(), FALSE );
//STRIP001 
//STRIP001 					//	SetAttribs an der View selektiert ein Wort, wenn nichts selektiert ist
//STRIP001 					pTableView->GetEditEngine()->QuickSetAttribs( aSet, pTableView->GetSelection() );
//STRIP001 					pTableView->InsertText(aString);
//STRIP001 					if (pTopView)
//STRIP001 						pTopView->InsertText(aString);
//STRIP001 				}
//STRIP001 
//STRIP001 				if (pTopView)
//STRIP001 					pTopView->GetWindow()->GrabFocus();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case FID_INSERT_NAME:
//STRIP001 			{
//STRIP001 				ScDocument*		pDoc = pViewData->GetDocument();
//STRIP001 				ScNamePasteDlg* pDlg = new ScNamePasteDlg( pViewData->GetDialogParent(),
//STRIP001 												pDoc->GetRangeName(), FALSE );
//STRIP001 												// "Liste" disablen
//STRIP001 
//STRIP001 				short nRet = pDlg->Execute();
//STRIP001 				// pDlg is needed below
//STRIP001 
//STRIP001 				// while the dialog was open, edit mode may have been stopped
//STRIP001 				if (!SC_MOD()->IsInputMode())
//STRIP001 				{
//STRIP001 					Sound::Beep();
//STRIP001 					delete pDlg;
//STRIP001 					return;
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( nRet == BTN_PASTE_NAME )
//STRIP001 				{
//STRIP001 					String aName = pDlg->GetSelectedName();
//STRIP001 					pTableView->InsertText(aName);
//STRIP001 					if (pTopView)
//STRIP001 						pTopView->InsertText(aName);
//STRIP001 				}
//STRIP001 				delete pDlg;
//STRIP001 
//STRIP001 				if (pTopView)
//STRIP001 					pTopView->GetWindow()->GrabFocus();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_CHAR_DLG:
//STRIP001 			{
//STRIP001 				SfxItemSet aAttrs( pTableView->GetAttribs() );
//STRIP001 
//STRIP001 				SfxObjectShell* pObjSh = pViewData->GetSfxDocShell();
//STRIP001 
//STRIP001 				ScCharDlg* pDlg = new ScCharDlg( pViewData->GetDialogParent(), &aAttrs, pObjSh );
//STRIP001 				short nRet = pDlg->Execute();
//STRIP001 				// pDlg is needed below
//STRIP001 
//STRIP001 				// while the dialog was open, edit mode may have been stopped
//STRIP001 				if (!SC_MOD()->IsInputMode())
//STRIP001 				{
//STRIP001 					Sound::Beep();
//STRIP001 					delete pDlg;
//STRIP001 					return;
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( nRet == RET_OK )
//STRIP001 				{
//STRIP001 					const SfxItemSet* pOut = pDlg->GetOutputItemSet();
//STRIP001 					pTableView->SetAttribs( *pOut );
//STRIP001 				}
//STRIP001 				delete pDlg;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_TOGGLE_REL:
//STRIP001 			{
//STRIP001 				BOOL bOk = FALSE;
//STRIP001 				if (pEngine->GetParagraphCount() == 1)
//STRIP001 				{
//STRIP001 					String aText = pEngine->GetText();
//STRIP001 					ESelection aSel = pEditView->GetSelection();	// aktuelle View
//STRIP001 
//STRIP001 					ScRefFinder aFinder( aText, pViewData->GetDocument() );
//STRIP001 					aFinder.ToggleRel( aSel.nStartPos, aSel.nEndPos );
//STRIP001 					if (aFinder.GetFound())
//STRIP001 					{
//STRIP001 						String aNew = aFinder.GetText();
//STRIP001 						ESelection aSel( 0,aFinder.GetSelStart(), 0,aFinder.GetSelEnd() );
//STRIP001 						pEngine->SetText( aNew );
//STRIP001 						pTableView->SetSelection( aSel );
//STRIP001 						if ( pTopView )
//STRIP001 						{
//STRIP001 							pTopView->GetEditEngine()->SetText( aNew );
//STRIP001 							pTopView->SetSelection( aSel );
//STRIP001 						}
//STRIP001 						bOk = TRUE;
//STRIP001 
//STRIP001 						//	Referenz wird selektiert -> beim Tippen nicht ueberschreiben
//STRIP001 						bSetSelIsRef = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				if (!bOk)
//STRIP001 					Sound::Beep();				// keine Referenzen oder mehrere Abstze
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_HYPERLINK_SETLINK:
//STRIP001 			if( pReqArgs )
//STRIP001 			{
//STRIP001 				const SfxPoolItem* pItem;
//STRIP001 				if ( pReqArgs->GetItemState( SID_HYPERLINK_SETLINK, TRUE, &pItem ) == SFX_ITEM_SET )
//STRIP001 				{
//STRIP001 					const SvxHyperlinkItem* pHyper = (const SvxHyperlinkItem*) pItem;
//STRIP001 					const String& rName		= pHyper->GetName();
//STRIP001 					const String& rURL		= pHyper->GetURL();
//STRIP001 					const String& rTarget	= pHyper->GetTargetFrame();
//STRIP001 					SvxLinkInsertMode eMode = pHyper->GetInsertMode();
//STRIP001 
//STRIP001 					BOOL bDone = FALSE;
//STRIP001 					if ( eMode == HLINK_DEFAULT || eMode == HLINK_FIELD )
//STRIP001 					{
//STRIP001 						const SvxURLField* pURLField = GetURLField();
//STRIP001 						if ( pURLField )
//STRIP001 						{
//STRIP001 							//	altes Feld selektieren
//STRIP001 
//STRIP001 							ESelection aSel = pTableView->GetSelection();
//STRIP001 							aSel.Adjust();
//STRIP001 							aSel.nEndPara = aSel.nStartPara;
//STRIP001 							aSel.nEndPos = aSel.nStartPos + 1;
//STRIP001 							pTableView->SetSelection( aSel );
//STRIP001 
//STRIP001 							//	neues Feld einfuegen
//STRIP001 
//STRIP001 							SvxURLField aURLField( rURL, rName, SVXURLFORMAT_REPR );
//STRIP001 							aURLField.SetTargetFrame( rTarget );
//STRIP001 							SvxFieldItem aURLItem( aURLField );
//STRIP001 							pTableView->InsertField( aURLItem );
//STRIP001 							pTableView->SetSelection( aSel );		// select inserted field
//STRIP001 
//STRIP001 							//	#57254# jetzt doch auch Felder in der Top-View
//STRIP001 
//STRIP001 							if ( pTopView )
//STRIP001 							{
//STRIP001 								aSel = pTopView->GetSelection();
//STRIP001 								aSel.nEndPara = aSel.nStartPara;
//STRIP001 								aSel.nEndPos = aSel.nStartPos + 1;
//STRIP001 								pTopView->SetSelection( aSel );
//STRIP001 								pTopView->InsertField( aURLItem );
//STRIP001 								pTopView->SetSelection( aSel );		// select inserted field
//STRIP001 							}
//STRIP001 
//STRIP001 							bDone = TRUE;
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					if (!bDone)
//STRIP001 					{
//STRIP001 						pViewData->GetViewShell()->
//STRIP001 							InsertURL( rName, rURL, rTarget, (USHORT) eMode );
//STRIP001 
//STRIP001 						//	InsertURL an der ViewShell schaltet bei "Button"
//STRIP001 						//	die EditShell ab, darum sofort return
//STRIP001 
//STRIP001 						return;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001             case SID_OPEN_HYPERLINK:
//STRIP001                 {
//STRIP001                     const SvxURLField* pURLField = GetURLField();
//STRIP001                     if ( pURLField )
//STRIP001                         ScGlobal::OpenURL( pURLField->GetURL(), pURLField->GetTargetFrame() );
//STRIP001                     return;
//STRIP001                 }
//STRIP001                 break;
//STRIP001 	}
//STRIP001 
//STRIP001 	pHdl->DataChanged();
//STRIP001 	if (bSetSelIsRef)
//STRIP001 		pHdl->SetSelIsRef(TRUE);
//STRIP001 }

//STRIP001 void __EXPORT ScEditShell::GetState( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	ScInputHandler*	pHdl = GetMyInputHdl();
//STRIP001 	EditView* pActiveView = pHdl ? pHdl->GetActiveView() : pEditView;
//STRIP001 
//STRIP001 	SfxWhichIter aIter( rSet );
//STRIP001 	USHORT nWhich = aIter.FirstWhich();
//STRIP001 	while (nWhich)
//STRIP001 	{
//STRIP001 		switch (nWhich)
//STRIP001 		{
//STRIP001 			case SID_ATTR_INSERT:	// Statuszeile
//STRIP001 				{
//STRIP001 					if ( pActiveView )
//STRIP001 						rSet.Put( SfxBoolItem( nWhich, pActiveView->IsInsertMode() ) );
//STRIP001 					else
//STRIP001 						rSet.Put( SfxBoolItem( nWhich, 42 ) );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SID_HYPERLINK_GETLINK:
//STRIP001 				{
//STRIP001 					SvxHyperlinkItem aHLinkItem;
//STRIP001 					const SvxURLField* pURLField = GetURLField();
//STRIP001 					if ( pURLField )
//STRIP001 					{
//STRIP001 						aHLinkItem.SetName( pURLField->GetRepresentation() );
//STRIP001 						aHLinkItem.SetURL( pURLField->GetURL() );
//STRIP001 						aHLinkItem.SetTargetFrame( pURLField->GetTargetFrame() );
//STRIP001 					}
//STRIP001 					else if ( pActiveView )
//STRIP001 					{
//STRIP001 						// use selected text as name for urls
//STRIP001 						String sReturn = pActiveView->GetSelected();
//STRIP001 						sReturn.Erase(255);
//STRIP001 						sReturn.EraseTrailingChars();
//STRIP001 						aHLinkItem.SetName(sReturn);
//STRIP001 					}
//STRIP001 					rSet.Put(aHLinkItem);
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001             case SID_OPEN_HYPERLINK:
//STRIP001                 {
//STRIP001                     if ( !GetURLField() )
//STRIP001                         rSet.DisableItem( nWhich );
//STRIP001                 }
//STRIP001                 break;
//STRIP001 
//STRIP001 			case SID_TRANSLITERATE_HALFWIDTH:
//STRIP001 			case SID_TRANSLITERATE_FULLWIDTH:
//STRIP001 			case SID_TRANSLITERATE_HIRAGANA:
//STRIP001 			case SID_TRANSLITERATE_KATAGANA:
//STRIP001 				{
//STRIP001 					// SvtCJKOptions is ref-counted - can be constructed every time
//STRIP001 		            SvtCJKOptions aCJKOptions;
//STRIP001 		            if (!aCJKOptions.IsChangeCaseMapEnabled())
//STRIP001 		            	rSet.DisableItem( nWhich );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 		}
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 const SvxURLField* ScEditShell::GetURLField()
//STRIP001 {
//STRIP001 	ScInputHandler*	pHdl = GetMyInputHdl();
//STRIP001 	EditView* pActiveView = pHdl ? pHdl->GetActiveView() : pEditView;
//STRIP001 	if ( pActiveView )
//STRIP001 	{
//STRIP001 		const SvxFieldItem*	pFieldItem = pActiveView->GetFieldAtSelection();
//STRIP001 		if (pFieldItem)
//STRIP001 		{
//STRIP001 			const SvxFieldData* pField = pFieldItem->GetField();
//STRIP001 			if ( pField && pField->ISA(SvxURLField) )
//STRIP001 				return (const SvxURLField*)pField;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return NULL;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( ScEditShell, ClipboardChanged, TransferableDataHelper*, pDataHelper )
//STRIP001 {
//STRIP001 	if ( pDataHelper )
//STRIP001 	{
//STRIP001 		bPastePossible = ( pDataHelper->HasFormat( SOT_FORMAT_STRING ) || pDataHelper->HasFormat( SOT_FORMAT_RTF ) );
//STRIP001 
//STRIP001 		SfxBindings& rBindings = pViewData->GetBindings();
//STRIP001 		rBindings.Invalidate( SID_PASTE );
//STRIP001 		rBindings.Invalidate( FID_PASTE_CONTENTS );
//STRIP001 		rBindings.Invalidate( SID_CLIPBOARD_FORMAT_ITEMS );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT ScEditShell::GetClipState( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	if ( !pClipEvtLstnr )
//STRIP001 	{
//STRIP001 		// create listener
//STRIP001 		pClipEvtLstnr = new TransferableClipboardListener( LINK( this, ScEditShell, ClipboardChanged ) );
//STRIP001 		pClipEvtLstnr->acquire();
//STRIP001 		Window* pWin = pViewData->GetActiveWin();
//STRIP001 		pClipEvtLstnr->AddRemoveListener( pWin, TRUE );
//STRIP001 
//STRIP001 		// get initial state
//STRIP001 		TransferableDataHelper aDataHelper( TransferableDataHelper::CreateFromSystemClipboard( pViewData->GetActiveWin() ) );
//STRIP001 		bPastePossible = ( aDataHelper.HasFormat( SOT_FORMAT_STRING ) || aDataHelper.HasFormat( SOT_FORMAT_RTF ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxWhichIter aIter( rSet );
//STRIP001 	USHORT nWhich = aIter.FirstWhich();
//STRIP001 	while (nWhich)
//STRIP001 	{
//STRIP001 		switch (nWhich)
//STRIP001 		{
//STRIP001 			case SID_PASTE:
//STRIP001 			case FID_PASTE_CONTENTS:
//STRIP001 				if( !bPastePossible )
//STRIP001 					rSet.DisableItem( nWhich );
//STRIP001 				break;
//STRIP001 			case SID_CLIPBOARD_FORMAT_ITEMS:
//STRIP001 				if( bPastePossible )
//STRIP001 				{
//STRIP001 					SvxClipboardFmtItem aFormats( SID_CLIPBOARD_FORMAT_ITEMS );
//STRIP001 					TransferableDataHelper aDataHelper(
//STRIP001 							TransferableDataHelper::CreateFromSystemClipboard( pViewData->GetActiveWin() ) );
//STRIP001 
//STRIP001 					if ( aDataHelper.HasFormat( SOT_FORMAT_STRING ) )
//STRIP001 						aFormats.AddClipbrdFormat( SOT_FORMAT_STRING );
//STRIP001 					if ( aDataHelper.HasFormat( SOT_FORMAT_RTF ) )
//STRIP001 						aFormats.AddClipbrdFormat( SOT_FORMAT_RTF );
//STRIP001 
//STRIP001 					rSet.Put( aFormats );
//STRIP001 				}
//STRIP001 				else
//STRIP001 					rSet.DisableItem( nWhich );
//STRIP001 				break;
//STRIP001 		}
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void lcl_InvalidateUnder( SfxBindings& rBindings )
//STRIP001 {
//STRIP001 	rBindings.Invalidate( SID_ATTR_CHAR_UNDERLINE );
//STRIP001 	rBindings.Invalidate( SID_ULINE_VAL_NONE );
//STRIP001 	rBindings.Invalidate( SID_ULINE_VAL_SINGLE );
//STRIP001 	rBindings.Invalidate( SID_ULINE_VAL_DOUBLE );
//STRIP001 	rBindings.Invalidate( SID_ULINE_VAL_DOTTED );
//STRIP001 }
//STRIP001 
//STRIP001 void ScEditShell::ExecuteAttr(SfxRequest& rReq)
//STRIP001 {
//STRIP001 	SfxItemSet			aSet( pEditView->GetEmptyItemSet() );
//STRIP001 	SfxBindings&		rBindings	= pViewData->GetBindings();
//STRIP001 	const SfxItemSet*	pArgs		= rReq.GetArgs();
//STRIP001 	USHORT				nSlot		= rReq.GetSlot();
//STRIP001 
//STRIP001 	switch ( nSlot )
//STRIP001 	{
//STRIP001 		case SID_ATTR_CHAR_FONTHEIGHT:
//STRIP001 		case SID_ATTR_CHAR_FONT:
//STRIP001 			{
//STRIP001 				if (pArgs)
//STRIP001 				{
//STRIP001 					USHORT nScript = pEditView->GetSelectedScriptType();
//STRIP001 					if (nScript == 0) nScript = ScGlobal::GetDefaultScriptType();
//STRIP001 
//STRIP001 					SfxItemPool& rPool = GetPool();
//STRIP001 					SvxScriptSetItem aSetItem( nSlot, rPool );
//STRIP001 					USHORT nWhich = rPool.GetWhich( nSlot );
//STRIP001 					aSetItem.PutItemForScriptType( nScript, pArgs->Get( nWhich ) );
//STRIP001 
//STRIP001 					aSet.Put( aSetItem.GetItemSet(), FALSE );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_ATTR_CHAR_COLOR:
//STRIP001 			{
//STRIP001 				if (pArgs)
//STRIP001 				{
//STRIP001 					aSet.Put( pArgs->Get( pArgs->GetPool()->GetWhich( nSlot ) ) );
//STRIP001 					rBindings.Invalidate( nSlot );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		//	Toggles
//STRIP001 
//STRIP001 		case SID_ATTR_CHAR_WEIGHT:
//STRIP001 			{
//STRIP001 				USHORT nScript = pEditView->GetSelectedScriptType();
//STRIP001 				if (nScript == 0) nScript = ScGlobal::GetDefaultScriptType();
//STRIP001 				SfxItemPool& rPool = GetPool();
//STRIP001 
//STRIP001 				BOOL bOld = FALSE;
//STRIP001 				SvxScriptSetItem aOldSetItem( nSlot, rPool );
//STRIP001 				aOldSetItem.GetItemSet().Put( pEditView->GetAttribs(), FALSE );
//STRIP001 				const SfxPoolItem* pCore = aOldSetItem.GetItemOfScript( nScript );
//STRIP001 				if ( pCore && ((const SvxWeightItem*)pCore)->GetWeight() > WEIGHT_NORMAL )
//STRIP001 					bOld = TRUE;
//STRIP001 
//STRIP001 				SvxScriptSetItem aSetItem( nSlot, rPool );
//STRIP001 				aSetItem.PutItemForScriptType( nScript,
//STRIP001 							SvxWeightItem( bOld ? WEIGHT_NORMAL : WEIGHT_BOLD, EE_CHAR_WEIGHT ) );
//STRIP001 				aSet.Put( aSetItem.GetItemSet(), FALSE );
//STRIP001 
//STRIP001 				rBindings.Invalidate( nSlot );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_ATTR_CHAR_POSTURE:
//STRIP001 			{
//STRIP001 				USHORT nScript = pEditView->GetSelectedScriptType();
//STRIP001 				if (nScript == 0) nScript = ScGlobal::GetDefaultScriptType();
//STRIP001 				SfxItemPool& rPool = GetPool();
//STRIP001 
//STRIP001 				BOOL bOld = FALSE;
//STRIP001 				SvxScriptSetItem aOldSetItem( nSlot, rPool );
//STRIP001 				aOldSetItem.GetItemSet().Put( pEditView->GetAttribs(), FALSE );
//STRIP001 				const SfxPoolItem* pCore = aOldSetItem.GetItemOfScript( nScript );
//STRIP001 				if ( pCore && ((const SvxPostureItem*)pCore)->GetValue() != ITALIC_NONE )
//STRIP001 					bOld = TRUE;
//STRIP001 
//STRIP001 				SvxScriptSetItem aSetItem( nSlot, rPool );
//STRIP001 				aSetItem.PutItemForScriptType( nScript,
//STRIP001 							SvxPostureItem( bOld ? ITALIC_NONE : ITALIC_NORMAL, EE_CHAR_ITALIC ) );
//STRIP001 				aSet.Put( aSetItem.GetItemSet(), FALSE );
//STRIP001 
//STRIP001 				rBindings.Invalidate( nSlot );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_ULINE_VAL_NONE:
//STRIP001 			aSet.Put( SvxUnderlineItem( UNDERLINE_NONE, EE_CHAR_UNDERLINE ) );
//STRIP001 			lcl_InvalidateUnder( rBindings );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_ATTR_CHAR_UNDERLINE:	// Toggles
//STRIP001 		case SID_ULINE_VAL_SINGLE:
//STRIP001 		case SID_ULINE_VAL_DOUBLE:
//STRIP001 		case SID_ULINE_VAL_DOTTED:
//STRIP001 			{
//STRIP001 				FontUnderline eOld = ((const SvxUnderlineItem&) pEditView->
//STRIP001 									GetAttribs().Get(EE_CHAR_UNDERLINE)).GetUnderline();
//STRIP001 				FontUnderline eNew = eOld;
//STRIP001 				switch (nSlot)
//STRIP001 				{
//STRIP001 					case SID_ATTR_CHAR_UNDERLINE:
//STRIP001 						eNew = ( eOld != UNDERLINE_NONE ) ? UNDERLINE_NONE : UNDERLINE_SINGLE;
//STRIP001 						break;
//STRIP001 					case SID_ULINE_VAL_SINGLE:
//STRIP001 						eNew = ( eOld == UNDERLINE_SINGLE ) ? UNDERLINE_NONE : UNDERLINE_SINGLE;
//STRIP001 						break;
//STRIP001 					case SID_ULINE_VAL_DOUBLE:
//STRIP001 						eNew = ( eOld == UNDERLINE_DOUBLE ) ? UNDERLINE_NONE : UNDERLINE_DOUBLE;
//STRIP001 						break;
//STRIP001 					case SID_ULINE_VAL_DOTTED:
//STRIP001 						eNew = ( eOld == UNDERLINE_DOTTED ) ? UNDERLINE_NONE : UNDERLINE_DOTTED;
//STRIP001 						break;
//STRIP001 				}
//STRIP001 				aSet.Put( SvxUnderlineItem( eNew, EE_CHAR_UNDERLINE ) );
//STRIP001 				lcl_InvalidateUnder( rBindings );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_ATTR_CHAR_STRIKEOUT:
//STRIP001 			{
//STRIP001 				BOOL bOld = ((const SvxCrossedOutItem&)pEditView->GetAttribs().
//STRIP001 								Get(EE_CHAR_STRIKEOUT)).GetValue() != STRIKEOUT_NONE;
//STRIP001 				aSet.Put( SvxCrossedOutItem( bOld ? STRIKEOUT_NONE : STRIKEOUT_SINGLE, EE_CHAR_STRIKEOUT ) );
//STRIP001 				rBindings.Invalidate( nSlot );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_ATTR_CHAR_SHADOWED:
//STRIP001 			{
//STRIP001 				BOOL bOld = ((const SvxShadowedItem&)pEditView->GetAttribs().
//STRIP001 								Get(EE_CHAR_SHADOW)).GetValue();
//STRIP001 				aSet.Put( SvxShadowedItem( !bOld, EE_CHAR_SHADOW ) );
//STRIP001 				rBindings.Invalidate( nSlot );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_ATTR_CHAR_CONTOUR:
//STRIP001 			{
//STRIP001 				BOOL bOld = ((const SvxContourItem&)pEditView->GetAttribs().
//STRIP001 								Get(EE_CHAR_OUTLINE)).GetValue();
//STRIP001 				aSet.Put( SvxContourItem( !bOld, EE_CHAR_OUTLINE ) );
//STRIP001 				rBindings.Invalidate( nSlot );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_SET_SUPER_SCRIPT:
//STRIP001 			{
//STRIP001 				SvxEscapement eOld = (SvxEscapement) ((const SvxEscapementItem&)
//STRIP001 						pEditView->GetAttribs().Get(EE_CHAR_ESCAPEMENT)).GetEnumValue();
//STRIP001 				SvxEscapement eNew = (eOld == SVX_ESCAPEMENT_SUPERSCRIPT) ?
//STRIP001 										SVX_ESCAPEMENT_OFF : SVX_ESCAPEMENT_SUPERSCRIPT;
//STRIP001 				aSet.Put( SvxEscapementItem( eNew, EE_CHAR_ESCAPEMENT ) );
//STRIP001 				rBindings.Invalidate( nSlot );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case SID_SET_SUB_SCRIPT:
//STRIP001 			{
//STRIP001 				SvxEscapement eOld = (SvxEscapement) ((const SvxEscapementItem&)
//STRIP001 						pEditView->GetAttribs().Get(EE_CHAR_ESCAPEMENT)).GetEnumValue();
//STRIP001 				SvxEscapement eNew = (eOld == SVX_ESCAPEMENT_SUBSCRIPT) ?
//STRIP001 										SVX_ESCAPEMENT_OFF : SVX_ESCAPEMENT_SUBSCRIPT;
//STRIP001 				aSet.Put( SvxEscapementItem( eNew, EE_CHAR_ESCAPEMENT ) );
//STRIP001 				rBindings.Invalidate( nSlot );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	//
//STRIP001 	//	anwenden
//STRIP001 	//
//STRIP001 
//STRIP001 	EditEngine* pEngine = pEditView->GetEditEngine();
//STRIP001 	BOOL bOld = pEngine->GetUpdateMode();
//STRIP001 	pEngine->SetUpdateMode(FALSE);
//STRIP001 
//STRIP001 	pEditView->SetAttribs( aSet );
//STRIP001 
//STRIP001 	pEngine->SetUpdateMode(bOld);
//STRIP001 	pEditView->Invalidate();
//STRIP001 
//STRIP001 	ScInputHandler* pHdl = GetMyInputHdl();
//STRIP001 	pHdl->SetModified();
//STRIP001 
//STRIP001 	rReq.Done();
//STRIP001 }
//STRIP001 
//STRIP001 void ScEditShell::GetAttrState(SfxItemSet &rSet)
//STRIP001 {
//STRIP001 	SfxItemSet aAttribs = pEditView->GetAttribs();
//STRIP001 	rSet.Put( aAttribs );
//STRIP001 
//STRIP001 	//	choose font info according to selection script type
//STRIP001 
//STRIP001 	USHORT nScript = pEditView->GetSelectedScriptType();
//STRIP001 	if (nScript == 0) nScript = ScGlobal::GetDefaultScriptType();
//STRIP001 
//STRIP001 	if ( rSet.GetItemState( EE_CHAR_FONTINFO ) != SFX_ITEM_UNKNOWN )
//STRIP001 		ScViewUtil::PutItemScript( rSet, aAttribs, EE_CHAR_FONTINFO, nScript );
//STRIP001 	if ( rSet.GetItemState( EE_CHAR_FONTHEIGHT ) != SFX_ITEM_UNKNOWN )
//STRIP001 		ScViewUtil::PutItemScript( rSet, aAttribs, EE_CHAR_FONTHEIGHT, nScript );
//STRIP001 	if ( rSet.GetItemState( EE_CHAR_WEIGHT ) != SFX_ITEM_UNKNOWN )
//STRIP001 		ScViewUtil::PutItemScript( rSet, aAttribs, EE_CHAR_WEIGHT, nScript );
//STRIP001 	if ( rSet.GetItemState( EE_CHAR_ITALIC ) != SFX_ITEM_UNKNOWN )
//STRIP001 		ScViewUtil::PutItemScript( rSet, aAttribs, EE_CHAR_ITALIC, nScript );
//STRIP001 
//STRIP001 	//	Unterstreichung
//STRIP001 
//STRIP001 	SfxItemState eState = aAttribs.GetItemState( EE_CHAR_UNDERLINE, TRUE );
//STRIP001 	if ( eState == SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		rSet.InvalidateItem( SID_ULINE_VAL_NONE );
//STRIP001 		rSet.InvalidateItem( SID_ULINE_VAL_SINGLE );
//STRIP001 		rSet.InvalidateItem( SID_ULINE_VAL_DOUBLE );
//STRIP001 		rSet.InvalidateItem( SID_ULINE_VAL_DOTTED );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		FontUnderline eUnderline = ((const SvxUnderlineItem&)
//STRIP001 					aAttribs.Get(EE_CHAR_UNDERLINE)).GetUnderline();
//STRIP001 		USHORT nId = SID_ULINE_VAL_NONE;
//STRIP001 		switch (eUnderline)
//STRIP001 		{
//STRIP001 			case UNDERLINE_SINGLE:	nId = SID_ULINE_VAL_SINGLE;	break;
//STRIP001 			case UNDERLINE_DOUBLE:	nId = SID_ULINE_VAL_DOUBLE;	break;
//STRIP001 			case UNDERLINE_DOTTED:	nId = SID_ULINE_VAL_DOTTED;	break;
//STRIP001 			default:
//STRIP001 				break;
//STRIP001 		}
//STRIP001 		rSet.Put( SfxBoolItem( nId, TRUE ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	//!	Testen, ob Klammer-Hervorhebung aktiv ist !!!!
//STRIP001 	ScInputHandler* pHdl = GetMyInputHdl();
//STRIP001 	if ( pHdl && pHdl->IsFormulaMode() )
//STRIP001 		rSet.ClearItem( EE_CHAR_WEIGHT );	// hervorgehobene Klammern hier nicht
//STRIP001 }
//STRIP001 
//STRIP001 String ScEditShell::GetSelectionText( BOOL bWholeWord )
//STRIP001 {
//STRIP001 	String aStrSelection;
//STRIP001 
//STRIP001 	if ( bWholeWord )
//STRIP001 	{
//STRIP001 		EditEngine* pEngine = pEditView->GetEditEngine();
//STRIP001 		ESelection  aSel = pEditView->GetSelection();
//STRIP001 		String 		aStrCurrentDelimiters = pEngine->GetWordDelimiters();
//STRIP001 
//STRIP001 		pEngine->SetWordDelimiters( String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM(" .,;\"'")) );
//STRIP001 		aStrSelection = pEngine->GetWord( aSel.nEndPara, aSel.nEndPos );
//STRIP001 		pEngine->SetWordDelimiters( aStrCurrentDelimiters );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aStrSelection = pEditView->GetSelected();
//STRIP001 	}
//STRIP001 
//STRIP001 	return aStrSelection;
//STRIP001 }

//STRIP001 void ScEditShell::ExecuteUndo(SfxRequest& rReq)
//STRIP001 {
//STRIP001 	//	#81733# Undo must be handled here because it's called for both EditViews
//STRIP001 
//STRIP001 	ScInputHandler* pHdl = GetMyInputHdl();
//STRIP001 	DBG_ASSERT(pHdl,"no ScInputHandler");
//STRIP001 	EditView* pTopView	 = pHdl->GetTopView();
//STRIP001 	EditView* pTableView = pHdl->GetTableView();
//STRIP001 	DBG_ASSERT(pTableView,"no EditView");
//STRIP001 
//STRIP001 	pHdl->DataChanging();
//STRIP001 
//STRIP001 	const SfxItemSet* pReqArgs = rReq.GetArgs();
//STRIP001 	USHORT nSlot = rReq.GetSlot();
//STRIP001 	switch ( nSlot )
//STRIP001 	{
//STRIP001 		case SID_UNDO:
//STRIP001 		case SID_REDO:
//STRIP001 			{
//STRIP001 				BOOL bIsUndo = ( nSlot == SID_UNDO );
//STRIP001 
//STRIP001 				USHORT nCount = 1;
//STRIP001 				const SfxPoolItem* pItem;
//STRIP001 				if ( pReqArgs && pReqArgs->GetItemState( nSlot, TRUE, &pItem ) == SFX_ITEM_SET )
//STRIP001 					nCount = ((const SfxUInt16Item*)pItem)->GetValue();
//STRIP001 
//STRIP001 				for (USHORT i=0; i<nCount; i++)
//STRIP001 				{
//STRIP001 					if ( bIsUndo )
//STRIP001 					{
//STRIP001 						pTableView->Undo();
//STRIP001 						if (pTopView)
//STRIP001 							pTopView->Undo();
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						pTableView->Redo();
//STRIP001 						if (pTopView)
//STRIP001 							pTopView->Redo();
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	pViewData->GetBindings().InvalidateAll(FALSE);
//STRIP001 
//STRIP001 	pHdl->DataChanged();
//STRIP001 }
//STRIP001 
//STRIP001 void ScEditShell::GetUndoState(SfxItemSet &rSet)
//STRIP001 {
//STRIP001 	//	Undo state is taken from normal ViewFrame state function
//STRIP001 
//STRIP001 	SfxViewFrame* pViewFrm = pViewData->GetViewShell()->GetViewFrame();
//STRIP001 	if ( pViewFrm && GetUndoManager() )
//STRIP001 	{
//STRIP001 		SfxWhichIter aIter(rSet);
//STRIP001 		USHORT nWhich = aIter.FirstWhich();
//STRIP001 		while( nWhich )
//STRIP001 		{
//STRIP001 			pViewFrm->GetSlotState( nWhich, NULL, &rSet );
//STRIP001 			nWhich = aIter.NextWhich();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//	disable if no action in input line EditView
//STRIP001 
//STRIP001 	ScInputHandler* pHdl = GetMyInputHdl();
//STRIP001 	DBG_ASSERT(pHdl,"no ScInputHandler");
//STRIP001 	EditView* pTopView = pHdl->GetTopView();
//STRIP001 	if (pTopView)
//STRIP001 	{
//STRIP001 		SfxUndoManager& rTopMgr = pTopView->GetEditEngine()->GetUndoManager();
//STRIP001 		if ( rTopMgr.GetUndoActionCount() == 0 )
//STRIP001 			rSet.DisableItem( SID_UNDO );
//STRIP001 		if ( rTopMgr.GetRedoActionCount() == 0 )
//STRIP001 			rSet.DisableItem( SID_REDO );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void ScEditShell::ExecuteTrans( SfxRequest& rReq )
//STRIP001 {
//STRIP001 	sal_Int32 nType = ScViewUtil::GetTransliterationType( rReq.GetSlot() );
//STRIP001 	if ( nType )
//STRIP001 	{
//STRIP001 		ScInputHandler* pHdl = GetMyInputHdl();
//STRIP001 		DBG_ASSERT( pHdl, "no ScInputHandler" );
//STRIP001 
//STRIP001 		EditView* pTopView	 = pHdl->GetTopView();
//STRIP001 		EditView* pTableView = pHdl->GetTableView();
//STRIP001 		DBG_ASSERT( pTableView, "no EditView" );
//STRIP001 
//STRIP001 		EditEngine* pEngine = pTableView->GetEditEngine();
//STRIP001 		pHdl->DataChanging();
//STRIP001 
//STRIP001 		pTableView->TransliterateText( nType );
//STRIP001 		if (pTopView)
//STRIP001 			pTopView->TransliterateText( nType );
//STRIP001 
//STRIP001 		pHdl->DataChanged();
//STRIP001 	}
//STRIP001 }

}
