/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_gridmerg.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:26:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

#include <vcl/outdev.hxx>

#include "gridmerg.hxx"
namespace binfilter {

//------------------------------------------------------------------

/*N*/ ScGridMerger::ScGridMerger( OutputDevice* pOutDev, long nOnePixelX, long nOnePixelY ) :
/*N*/ 	pDev( pOutDev ),
/*N*/ 	nOneX( nOnePixelX ),
/*N*/ 	nOneY( nOnePixelY ),
/*N*/ 	bVertical( FALSE ),
/*N*/ 	nCount( 0 )
/*N*/ {
/*N*/ 	//	optimize (DrawGrid) only for pixel MapMode,
/*N*/ 	//	to avoid rounding errors
/*N*/ 
/*N*/ 	bOptimize = ( pDev->GetMapMode().GetMapUnit() == MAP_PIXEL );
/*N*/ }

/*N*/ ScGridMerger::~ScGridMerger()
/*N*/ {
/*N*/ 	Flush();
/*N*/ }

//STRIP001 void ScGridMerger::AddLine( long nStart, long nEnd, long nPos )
//STRIP001 {
//STRIP001 	if ( nCount )
//STRIP001 	{
//STRIP001 		//	not first line - test fix position
//STRIP001 		//	more than one previous line - test distance
//STRIP001 
//STRIP001 		if ( nStart != nFixStart || nEnd != nFixEnd )
//STRIP001 		{
//STRIP001 			if ( nCount == 1 && nPos == nVarStart &&
//STRIP001 					( nStart == nFixEnd ||
//STRIP001 						nStart == nFixEnd + ( bVertical ? nOneY : nOneX ) ) )
//STRIP001 			{
//STRIP001 				//	additional optimization: extend connected lines
//STRIP001 				//	keep nCount at 1
//STRIP001 				nFixEnd = nEnd;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				Flush();
//STRIP001 		}
//STRIP001 		else if ( nCount == 1 )
//STRIP001 		{
//STRIP001 			nVarDiff = nPos - nVarStart;
//STRIP001 			++nCount;
//STRIP001 		}
//STRIP001 		else if ( nPos != nVarStart + nCount * nVarDiff )		//! keep VarEnd?
//STRIP001 			Flush();
//STRIP001 		else
//STRIP001 			++nCount;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !nCount )
//STRIP001 	{
//STRIP001 		//	first line (or flushed above) - just store
//STRIP001 
//STRIP001 		nFixStart = nStart;
//STRIP001 		nFixEnd   = nEnd;
//STRIP001 		nVarStart = nPos;
//STRIP001 		nVarDiff  = 0;
//STRIP001 		nCount    = 1;
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScGridMerger::AddHorLine( long nX1, long nX2, long nY )
//STRIP001 {
//STRIP001 	if ( bOptimize )
//STRIP001 	{
//STRIP001 		if ( bVertical )
//STRIP001 		{
//STRIP001 			Flush();
//STRIP001 			bVertical = FALSE;
//STRIP001 		}
//STRIP001 		AddLine( nX1, nX2, nY );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pDev->DrawLine( Point( nX1, nY ), Point( nX2, nY ) );
//STRIP001 }

//STRIP001 void ScGridMerger::AddVerLine( long nX, long nY1, long nY2 )
//STRIP001 {
//STRIP001 	if ( bOptimize )
//STRIP001 	{
//STRIP001 		if ( !bVertical )
//STRIP001 		{
//STRIP001 			Flush();
//STRIP001 			bVertical = TRUE;
//STRIP001 		}
//STRIP001 		AddLine( nY1, nY2, nX );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pDev->DrawLine( Point( nX, nY1 ), Point( nX, nY2 ) );
//STRIP001 }

/*N*/ void ScGridMerger::Flush()
/*N*/ {
/*N*/ 	if (nCount)
/*N*/ 	{
/*?*/ 		if (bVertical)
/*?*/ 		{
/*?*/ 			if ( nCount == 1 )
/*?*/ 				pDev->DrawLine( Point( nVarStart, nFixStart ), Point( nVarStart, nFixEnd ) );
/*?*/ 			else
/*?*/ 			{
/*?*/ 				long nVarEnd = nVarStart + ( nCount - 1 ) * nVarDiff;
/*?*/ 				pDev->DrawGrid( Rectangle( nVarStart, nFixStart, nVarEnd, nFixEnd ),
/*?*/ 								Size( nVarDiff, nFixEnd - nFixStart ),
/*?*/ 								GRID_VERTLINES );
/*?*/ 			}
/*?*/ 		}
/*?*/ 		else
/*?*/ 		{
/*?*/ 			if ( nCount == 1 )
/*?*/ 				pDev->DrawLine( Point( nFixStart, nVarStart ), Point( nFixEnd, nVarStart ) );
/*?*/ 			else
/*?*/ 			{
/*?*/ 				long nVarEnd = nVarStart + ( nCount - 1 ) * nVarDiff;
/*?*/ 				pDev->DrawGrid( Rectangle( nFixStart, nVarStart, nFixEnd, nVarEnd ),
/*?*/ 								Size( nFixEnd - nFixStart, nVarDiff ),
/*?*/ 								GRID_HORZLINES );
/*?*/ 			}
/*?*/ 		}
/*?*/ 		nCount = 0;
/*N*/ 	}
/*N*/ }



}
