/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_tabview3.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:35:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// System - Includes -----------------------------------------------------

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------
// auto strip #include <rangelst.hxx>
#include "scitems.hxx"
// auto strip #include <bf_svx/eeitem.hxx>
#define ITEMID_FIELD EE_FEATURE_FIELD

// auto strip #include <bf_svx/brshitem.hxx>
// auto strip #include <bf_svx/editview.hxx>
// auto strip #include <bf_svx/fmshell.hxx>
#include <bf_sfx2/bindings.hxx>
#include <vcl/cursor.hxx>
// auto strip #include <bf_sch/schdll.hxx>		// ChartSelectionInfo
// auto strip #include <bf_sch/memchrt.hxx>

// auto strip #include "tabview.hxx"
#include "tabvwsh.hxx"
#include "docsh.hxx"
#include "gridwin.hxx"
#include "olinewin.hxx"
#include "colrowba.hxx"
#include "tabcont.hxx"
#include "scmod.hxx"
// auto strip #include "uiitems.hxx"
#include "bf_sc.hrc"
// auto strip #include "viewutil.hxx"
// auto strip #include "editutil.hxx"
#include "inputhdl.hxx"
#include "inputwin.hxx"
#include "validat.hxx"
#include "hintwin.hxx"
// auto strip #include "inputopt.hxx"
// auto strip #include "rfindlst.hxx"
// auto strip #include "hiranges.hxx"
// auto strip #include "viewuno.hxx"
// auto strip #include "chartarr.hxx"
// auto strip #include "anyrefdg.hxx"
// auto strip #include "dpobject.hxx"
// auto strip #include "patattr.hxx"
// auto strip #include "dociter.hxx"
#include "seltrans.hxx"
// auto strip #include "AccessibilityHints.hxx"
namespace binfilter {
//!	hier und output2.cxx in irgendein Headerfile verschieben!
#define SC_CLIPMARK_SIZE	64

using namespace ::com::sun::star;

// -----------------------------------------------------------------------

//	helper class for DoChartSelection

#define SC_BGCOLLECT_FIRST		0
#define SC_BGCOLLECT_FOUND		1
#define SC_BGCOLLECT_AMBIGUOUS	2

//STRIP001 class ScBackgroundCollector
//STRIP001 {
//STRIP001 private:
//STRIP001 	ScDocument*	pDoc;
//STRIP001 	BOOL		bTransparent;
//STRIP001 	Color		aBackColor;
//STRIP001 	USHORT		nMode;
//STRIP001 public:
//STRIP001 			ScBackgroundCollector( ScDocument* pD );
//STRIP001 	void	AddRange( const ScRange& rRange );
//STRIP001 	Color	GetHighlightColor() const;
//STRIP001 };
//STRIP001 
//STRIP001 ScBackgroundCollector::ScBackgroundCollector( ScDocument* pD ) :
//STRIP001 	pDoc( pD ),
//STRIP001 	bTransparent( FALSE ),
//STRIP001 	nMode( SC_BGCOLLECT_FIRST )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 void ScBackgroundCollector::AddRange( const ScRange& rRange )
//STRIP001 {
//STRIP001 	if ( nMode == SC_BGCOLLECT_AMBIGUOUS )
//STRIP001 		return;									// nothing more to do
//STRIP001 
//STRIP001 	ScDocAttrIterator aIter( pDoc, rRange.aStart.Tab(),
//STRIP001 							rRange.aStart.Col(), rRange.aStart.Row(),
//STRIP001 							rRange.aEnd.Col(), rRange.aEnd.Row() );
//STRIP001 	USHORT nCol, nRow1, nRow2;
//STRIP001 	const ScPatternAttr* pPattern = aIter.GetNext( nCol, nRow1, nRow2 );
//STRIP001 	while ( pPattern )
//STRIP001 	{
//STRIP001 		//!	look at conditional formats?
//STRIP001 		const Color& rAttrColor = ((const SvxBrushItem&)pPattern->GetItem(ATTR_BACKGROUND)).GetColor();
//STRIP001 		BOOL bAttrTransp = ( rAttrColor.GetTransparency() != 0 );
//STRIP001 
//STRIP001 		if ( nMode == SC_BGCOLLECT_FIRST )
//STRIP001 		{
//STRIP001 			//	just copy first background
//STRIP001 			bTransparent = bAttrTransp;
//STRIP001 			aBackColor   = rAttrColor;
//STRIP001 			nMode = SC_BGCOLLECT_FOUND;
//STRIP001 		}
//STRIP001 		else if ( nMode == SC_BGCOLLECT_FOUND )
//STRIP001 		{
//STRIP001 			BOOL bEqual = ( bTransparent == bAttrTransp );
//STRIP001 			if ( bEqual && !bTransparent )
//STRIP001 				bEqual = ( aBackColor == rAttrColor );
//STRIP001 			if ( !bEqual )
//STRIP001 			{
//STRIP001 				nMode = SC_BGCOLLECT_AMBIGUOUS;		// different backgrounds found
//STRIP001 				return;								// dont need to continue
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		pPattern = aIter.GetNext( nCol, nRow1, nRow2 );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 Color ScBackgroundCollector::GetHighlightColor() const
//STRIP001 {
//STRIP001 	if ( nMode == SC_BGCOLLECT_FOUND && !bTransparent )
//STRIP001 	{
//STRIP001 		//	everything formatted with a single background color
//STRIP001 		//	-> use contrasting color (blue or yellow)
//STRIP001 
//STRIP001 		Color aBlue( COL_LIGHTBLUE );
//STRIP001 		Color aYellow( COL_YELLOW );
//STRIP001 
//STRIP001 		if ( aBackColor.GetColorError(aBlue) >= aBackColor.GetColorError(aYellow) )
//STRIP001 			return aBlue;
//STRIP001 		else
//STRIP001 			return aYellow;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return Color( COL_LIGHTBLUE );		// default for transparent or ambiguous background
//STRIP001 }

// -----------------------------------------------------------------------

//
// ---	Public-Funktionen
//

//STRIP001 void ScTabView::ClickCursor( USHORT nPosX, USHORT nPosY, BOOL bControl )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = aViewData.GetDocument();
//STRIP001 	USHORT nTab = aViewData.GetTabNo();
//STRIP001 	while (pDoc->IsHorOverlapped( nPosX, nPosY, nTab ))		//! ViewData !!!
//STRIP001 		--nPosX;
//STRIP001 	while (pDoc->IsVerOverlapped( nPosX, nPosY, nTab ))
//STRIP001 		--nPosY;
//STRIP001 
//STRIP001 	BOOL bRefMode = SC_MOD()->IsFormulaMode();
//STRIP001 
//STRIP001 	if ( bRefMode )
//STRIP001 	{
//STRIP001 		DoneRefMode( FALSE );
//STRIP001 
//STRIP001 		USHORT nTab = aViewData.GetTabNo();
//STRIP001 		ScDocument* pDoc = aViewData.GetDocument();
//STRIP001 		if (bControl)
//STRIP001 			SC_MOD()->AddRefEntry();
//STRIP001 
//STRIP001 		InitRefMode( nPosX, nPosY, nTab, SC_REFTYPE_REF );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DoneBlockMode( bControl );
//STRIP001 		aViewData.ResetOldCursor();
//STRIP001 		SetCursor( (USHORT) nPosX, (USHORT) nPosY );
//STRIP001 	}
//STRIP001 }

/*N*/ void ScTabView::UpdateAutoFillMark()
/*N*/ {
/*N*/ 	ScRange aMarkRange;
/*N*/ 	BOOL bMarked = aViewData.GetSimpleArea( aMarkRange );		// single selection or cursor
/*N*/ 
/*N*/ 	USHORT i;
/*N*/ 	for (i=0; i<4; i++)
/*N*/ 		if (pGridWin[i] && pGridWin[i]->IsVisible())
							pGridWin[i]->UpdateAutoFillMark( bMarked, aMarkRange );
/*N*/ 
/*N*/ 	for (i=0; i<2; i++)
/*N*/ 	{
/*N*/ 		if (pColBar[i] && pColBar[i]->IsVisible())
/*N*/ 			pColBar[i]->SetMark( bMarked, aMarkRange.aStart.Col(), aMarkRange.aEnd.Col() );
/*N*/ 		if (pRowBar[i] && pRowBar[i]->IsVisible())
/*N*/ 			pRowBar[i]->SetMark( bMarked, aMarkRange.aStart.Row(), aMarkRange.aEnd.Row() );
/*N*/ 	}
/*N*/ 
/*N*/ 	//	selection transfer object is checked together with AutoFill marks,
/*N*/ 	//	because it has the same requirement of a single continuous block.
/*N*/ 	CheckSelectionTransfer();	// update selection transfer object
/*N*/ }

//STRIP001 void ScTabView::FakeButtonUp( ScSplitPos eWhich )
//STRIP001 {
//STRIP001 	if (pGridWin[eWhich])
//STRIP001 		pGridWin[eWhich]->FakeButtonUp();
//STRIP001 }

//STRIP001 void ScTabView::HideAllCursors()
//STRIP001 {
//STRIP001 	for (USHORT i=0; i<4; i++)
//STRIP001 		if (pGridWin[i])
//STRIP001 			if (pGridWin[i]->IsVisible())
//STRIP001 			{
//STRIP001 				Cursor* pCur = pGridWin[i]->GetCursor();
//STRIP001 				if (pCur)
//STRIP001 					if (pCur->IsVisible())
//STRIP001 						pCur->Hide();
//STRIP001 				pGridWin[i]->HideCursor();
//STRIP001 			}
//STRIP001 }

//STRIP001 void ScTabView::ShowAllCursors()
//STRIP001 {
//STRIP001 	for (USHORT i=0; i<4; i++)
//STRIP001 		if (pGridWin[i])
//STRIP001 			if (pGridWin[i]->IsVisible())
//STRIP001 				pGridWin[i]->ShowCursor();
//STRIP001 }

//STRIP001 void ScTabView::HideCursor()
//STRIP001 {
//STRIP001 	pGridWin[aViewData.GetActivePart()]->HideCursor();
//STRIP001 }

//STRIP001 void ScTabView::ShowCursor()
//STRIP001 {
//STRIP001 	pGridWin[aViewData.GetActivePart()]->ShowCursor();
//STRIP001 }

//STRIP001 void ScTabView::InvalidateAttribs()
//STRIP001 {
//STRIP001 	SfxBindings& rBindings = aViewData.GetBindings();
//STRIP001 
//STRIP001 	rBindings.Invalidate( SID_STYLE_APPLY );
//STRIP001 	rBindings.Invalidate( SID_STYLE_FAMILY2 );
//STRIP001 	// StarCalc kennt nur Absatz- bzw. Zellformat-Vorlagen
//STRIP001 
//STRIP001 	rBindings.Invalidate( SID_ATTR_CHAR_FONT );
//STRIP001 	rBindings.Invalidate( SID_ATTR_CHAR_FONTHEIGHT );
//STRIP001 	rBindings.Invalidate( SID_ATTR_CHAR_COLOR );
//STRIP001 
//STRIP001 	rBindings.Invalidate( SID_ATTR_CHAR_WEIGHT );
//STRIP001 	rBindings.Invalidate( SID_ATTR_CHAR_POSTURE );
//STRIP001 	rBindings.Invalidate( SID_ATTR_CHAR_UNDERLINE );
//STRIP001 	rBindings.Invalidate( SID_ULINE_VAL_NONE );
//STRIP001 	rBindings.Invalidate( SID_ULINE_VAL_SINGLE );
//STRIP001 	rBindings.Invalidate( SID_ULINE_VAL_DOUBLE );
//STRIP001 	rBindings.Invalidate( SID_ULINE_VAL_DOTTED );
//STRIP001 
//STRIP001 	rBindings.Invalidate( SID_ALIGNLEFT );
//STRIP001 	rBindings.Invalidate( SID_ALIGNRIGHT );
//STRIP001 	rBindings.Invalidate( SID_ALIGNBLOCK );
//STRIP001 	rBindings.Invalidate( SID_ALIGNCENTERHOR );
//STRIP001 
//STRIP001 	rBindings.Invalidate( SID_ALIGNTOP );
//STRIP001 	rBindings.Invalidate( SID_ALIGNBOTTOM );
//STRIP001 	rBindings.Invalidate( SID_ALIGNCENTERVER );
//STRIP001 
//STRIP001 	rBindings.Invalidate( SID_BACKGROUND_COLOR );
//STRIP001 
//STRIP001 	rBindings.Invalidate( SID_ATTR_ALIGN_LINEBREAK );
//STRIP001 	rBindings.Invalidate( SID_NUMBER_FORMAT );
//STRIP001 
//STRIP001     rBindings.Invalidate( SID_TEXTDIRECTION_LEFT_TO_RIGHT );
//STRIP001     rBindings.Invalidate( SID_TEXTDIRECTION_TOP_TO_BOTTOM );
//STRIP001     rBindings.Invalidate( SID_ATTR_PARA_LEFT_TO_RIGHT );
//STRIP001     rBindings.Invalidate( SID_ATTR_PARA_RIGHT_TO_LEFT );
//STRIP001 
//STRIP001 //	rBindings.Invalidate( SID_RANGE_VALUE );
//STRIP001 //	rBindings.Invalidate( SID_RANGE_FORMULA );
//STRIP001 }

//		SetCursor - Cursor setzen, zeichnen, InputWin updaten
//					oder Referenz verschicken
//		ohne Optimierung wegen BugId 29307

/*N*/ #ifdef WNT
/*N*/ #pragma optimize ( "", off )
/*N*/ #endif

/*N*/ void ScTabView::SetCursor( USHORT nPosX, USHORT nPosY, BOOL bNew )
/*N*/ {
/*N*/ 	USHORT nOldX = aViewData.GetCurX();
/*N*/ 	USHORT nOldY = aViewData.GetCurY();
/*N*/ 
/*N*/ 	//	DeactivateIP nur noch bei MarkListHasChanged
/*N*/ 
/*N*/ 	if ( nPosX != nOldX || nPosY != nOldY || bNew )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*N*/ 		if ( aViewData.HasEditView(aViewData.GetActivePart()) &&
//STRIP001 /*N*/ 						!SC_MOD()->IsFormulaMode() )					// 23259 oder so
//STRIP001 /*N*/ 			UpdateInputLine();
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		HideAllCursors();
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		aViewData.SetCurX( nPosX );
//STRIP001 /*N*/ 		aViewData.SetCurY( nPosY );
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		ShowAllCursors();
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		CursorPosChanged();
/*N*/ 	}
/*N*/ }
/*N*/ 
/*N*/ #ifdef WNT
/*N*/ #pragma optimize ( "", on )
/*N*/ #endif

/*N*/ void ScTabView::CheckSelectionTransfer()
/*N*/ {
/*N*/ 	if ( aViewData.IsActive() )		// only for active view
/*N*/ 	{
/*N*/ 		ScModule* pScMod = SC_MOD();
/*N*/ 		ScSelectionTransferObj* pOld = pScMod->GetSelectionTransfer();
/*N*/ 		if ( pOld && pOld->GetView() == this && pOld->StillValid() )
/*N*/ 		{
/*N*/ 			// selection not changed - nothing to do
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			ScSelectionTransferObj* pNew = ScSelectionTransferObj::CreateFromView( this );
/*N*/ 			if ( pNew )
/*N*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //	create new selection
/*?*/ 
//STRIP001 /*?*/ 				if (pOld)
//STRIP001 /*?*/ 					pOld->ForgetView();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				uno::Reference<datatransfer::XTransferable> xRef( pNew );
//STRIP001 /*?*/ 				pScMod->SetSelectionTransfer( pNew );
//STRIP001 /*?*/ 				pNew->CopyToSelection( GetActiveWin() );					// may delete pOld
/*N*/ 			}
/*N*/ 			else if ( pOld && pOld->GetView() == this )
/*N*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //	remove own selection
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				pOld->ForgetView();
//STRIP001 /*?*/ 				pScMod->SetSelectionTransfer( NULL );
//STRIP001 /*?*/ 				TransferableHelper::ClearSelection( GetActiveWin() );		// may delete pOld
/*N*/ 			}
/*N*/ 			// else: selection from outside: leave unchanged
/*N*/ 		}
/*N*/ 	}
/*N*/ }

// Eingabezeile / Menues updaten
//	CursorPosChanged ruft SelectionChanged
//	SelectionChanged ruft CellContentChanged

//STRIP001 void ScTabView::CellContentChanged()
//STRIP001 {
//STRIP001 	SfxBindings& rBindings = aViewData.GetBindings();
//STRIP001 
//STRIP001 	rBindings.Invalidate( SID_ATTR_SIZE );		// -> Fehlermeldungen anzeigen
//STRIP001 	rBindings.Invalidate( SID_THESAURUS );
//STRIP001 	rBindings.Invalidate( SID_HYPERLINK_GETLINK );
//STRIP001 
//STRIP001 	InvalidateAttribs();					// Attribut-Updates
//STRIP001 	TestHintWindow();						// Eingabemeldung (Gueltigkeit)
//STRIP001 
//STRIP001 	aViewData.GetViewShell()->UpdateInputHandler();
//STRIP001 }

//STRIP001 void ScTabView::SelectionChanged()
//STRIP001 {
//STRIP001 	SfxViewFrame* pViewFrame = aViewData.GetViewShell()->GetViewFrame();
//STRIP001 	if (pViewFrame)
//STRIP001 	{
//STRIP001 		SfxFrame* pFrame = pViewFrame->GetFrame();
//STRIP001 		if (pFrame)
//STRIP001 		{
//STRIP001 			uno::Reference<frame::XController> xController = pFrame->GetController();
//STRIP001 			if (xController.is())
//STRIP001 			{
//STRIP001 				ScTabViewObj* pImp = ScTabViewObj::getImplementation( xController );
//STRIP001 				if (pImp)
//STRIP001 					pImp->SelectionChanged();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	UpdateAutoFillMark();	// also calls CheckSelectionTransfer
//STRIP001 
//STRIP001 	SfxBindings& rBindings = aViewData.GetBindings();
//STRIP001 
//STRIP001 	rBindings.Invalidate( SID_CURRENTCELL );	// -> Navigator
//STRIP001 	rBindings.Invalidate( SID_AUTO_FILTER );	// -> Menue
//STRIP001 	rBindings.Invalidate( FID_NOTE_VISIBLE );
//STRIP001 
//STRIP001 		//	Funktionen, die evtl disabled werden muessen
//STRIP001 
//STRIP001 	rBindings.Invalidate( FID_INS_ROWBRK );
//STRIP001 	rBindings.Invalidate( FID_INS_COLBRK );
//STRIP001 	rBindings.Invalidate( FID_DEL_ROWBRK );
//STRIP001 	rBindings.Invalidate( FID_DEL_COLBRK );
//STRIP001 	rBindings.Invalidate( FID_MERGE_ON );
//STRIP001 	rBindings.Invalidate( FID_MERGE_OFF );
//STRIP001 	rBindings.Invalidate( SID_AUTOFILTER_HIDE );
//STRIP001 	rBindings.Invalidate( SID_UNFILTER );
//STRIP001 //	rBindings.Invalidate( SID_IMPORT_DATA );		// jetzt wieder immer moeglich
//STRIP001 	rBindings.Invalidate( SID_REIMPORT_DATA );
//STRIP001 	rBindings.Invalidate( SID_REFRESH_DBAREA );
//STRIP001 	rBindings.Invalidate( SID_OUTLINE_SHOW );
//STRIP001 	rBindings.Invalidate( SID_OUTLINE_HIDE );
//STRIP001 	rBindings.Invalidate( SID_OUTLINE_REMOVE );
//STRIP001 	rBindings.Invalidate( FID_FILL_TO_BOTTOM );
//STRIP001 	rBindings.Invalidate( FID_FILL_TO_RIGHT );
//STRIP001 	rBindings.Invalidate( FID_FILL_TO_TOP );
//STRIP001 	rBindings.Invalidate( FID_FILL_TO_LEFT );
//STRIP001 	rBindings.Invalidate( FID_FILL_SERIES );
//STRIP001 	rBindings.Invalidate( SID_SCENARIOS );
//STRIP001 	rBindings.Invalidate( SID_AUTOFORMAT );
//STRIP001 	rBindings.Invalidate( SID_OPENDLG_TABOP );
//STRIP001 	rBindings.Invalidate( SID_DATA_SELECT );
//STRIP001 
//STRIP001 	rBindings.Invalidate( SID_CUT );
//STRIP001 	rBindings.Invalidate( SID_COPY );
//STRIP001 	rBindings.Invalidate( SID_PASTE );
//STRIP001 	rBindings.Invalidate( FID_PASTE_CONTENTS );
//STRIP001 
//STRIP001 	rBindings.Invalidate( FID_INS_ROW );
//STRIP001 	rBindings.Invalidate( FID_INS_COLUMN );
//STRIP001 	rBindings.Invalidate( FID_INS_CELL );
//STRIP001 	rBindings.Invalidate( FID_INS_CELLSDOWN	);
//STRIP001 	rBindings.Invalidate( FID_INS_CELLSRIGHT );
//STRIP001 
//STRIP001 	rBindings.Invalidate( FID_CHG_COMMENT );
//STRIP001 
//STRIP001 		//	nur wegen Zellschutz:
//STRIP001 
//STRIP001 	rBindings.Invalidate( SID_CELL_FORMAT_RESET );
//STRIP001 	rBindings.Invalidate( SID_DELETE );
//STRIP001 	rBindings.Invalidate( SID_DELETE_CONTENTS );
//STRIP001 	rBindings.Invalidate( FID_DELETE_CELL );
//STRIP001 	rBindings.Invalidate( FID_CELL_FORMAT );
//STRIP001 	rBindings.Invalidate( SID_ENABLE_HYPHENATION );
//STRIP001 	rBindings.Invalidate( SID_INSERT_POSTIT );
//STRIP001 	rBindings.Invalidate( SID_CHARMAP );
//STRIP001 	rBindings.Invalidate( SID_OPENDLG_FUNCTION );
//STRIP001 //	rBindings.Invalidate( FID_CONDITIONAL_FORMAT );
//STRIP001 	rBindings.Invalidate( SID_OPENDLG_CONDFRMT );
//STRIP001 	rBindings.Invalidate( FID_VALIDATION );
//STRIP001 	rBindings.Invalidate( SID_EXTERNAL_SOURCE );
//STRIP001 
//STRIP001 	if (aViewData.GetViewShell()->HasAccessibilityObjects())
//STRIP001 		aViewData.GetViewShell()->BroadcastAccessibility(SfxSimpleHint(SC_HINT_ACC_CURSORCHANGED));
//STRIP001 
//STRIP001 	CellContentChanged();
//STRIP001 }

//STRIP001 void ScTabView::CursorPosChanged()
//STRIP001 {
//STRIP001 	BOOL bRefMode = SC_MOD()->IsFormulaMode();
//STRIP001 	if ( !bRefMode ) // Abfrage, damit RefMode bei Tabellenwechsel funktioniert
//STRIP001 		aViewData.GetDocShell()->Broadcast( SfxSimpleHint( FID_KILLEDITVIEW ) );
//STRIP001 
//STRIP001 	//	Broadcast, damit andere Views des Dokuments auch umschalten
//STRIP001 
//STRIP001 	ScDocument* pDoc = aViewData.GetDocument();
//STRIP001 	BOOL bPivot = ( NULL != pDoc->GetPivotAtCursor( aViewData.GetCurX(),
//STRIP001 													aViewData.GetCurY(),
//STRIP001 													aViewData.GetTabNo() ) ||
//STRIP001 					NULL != pDoc->GetDPAtCursor( aViewData.GetCurX(),
//STRIP001 													aViewData.GetCurY(),
//STRIP001 													aViewData.GetTabNo() ) );
//STRIP001 	aViewData.GetViewShell()->SetPivotShell(bPivot);
//STRIP001 
//STRIP001 	//	UpdateInputHandler jetzt in CellContentChanged
//STRIP001 
//STRIP001 	SelectionChanged();
//STRIP001 
//STRIP001 	aViewData.SetTabStartCol( SC_TABSTART_NONE );
//STRIP001 }

/*N*/ void ScTabView::TestHintWindow()
/*N*/ {
/*N*/ 	//	Eingabemeldung (Gueltigkeit)
/*N*/ 	//!	per Timer / ControllerItem anzeigen ???
/*N*/ 
/*N*/ 	ScDocument* pDoc = aViewData.GetDocument();
/*N*/ 	const SfxUInt32Item* pItem = (const SfxUInt32Item*)
/*N*/ 										pDoc->GetAttr( aViewData.GetCurX(),
/*N*/ 													   aViewData.GetCurY(),
/*N*/ 													   aViewData.GetTabNo(),
/*N*/ 													   ATTR_VALIDDATA );
/*N*/ 	if ( pItem->GetValue() )
/*N*/ 	{
/*?*/ 		const ScValidationData*	pData = pDoc->GetValidationEntry( pItem->GetValue() );
/*?*/ 		DBG_ASSERT(pData,"ValidationData nicht gefunden");
/*?*/ 		String aTitle, aMessage;
/*?*/ 		if ( pData && pData->GetInput( aTitle, aMessage ) )
/*?*/ 		{
/*?*/ 			//!	Abfrage, ob an gleicher Stelle !!!!
/*?*/ 
/*?*/ 			DELETEZ(pInputHintWindow);
/*?*/ 
/*?*/ 			ScSplitPos eWhich = aViewData.GetActivePart();
/*?*/ 			Window* pWin = pGridWin[eWhich];
/*?*/ 			USHORT nCol = aViewData.GetCurX();
/*?*/ 			USHORT nRow = aViewData.GetCurY();
/*?*/ 			Point aPos = aViewData.GetScrPos( nCol, nRow, eWhich );
/*?*/ 			Size aWinSize = pWin->GetOutputSizePixel();
/*?*/ 			//	Cursor sichtbar?
/*?*/ 			if ( nCol >= aViewData.GetPosX(WhichH(eWhich)) &&
/*?*/ 				 nRow >= aViewData.GetPosY(WhichV(eWhich)) &&
/*?*/ 				 aPos.X() < aWinSize.Width() && aPos.Y() < aWinSize.Height() )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 				aPos += pWin->GetPosPixel();								// Position auf Frame
//STRIP001 /*?*/ 				long nSizeXPix;
//STRIP001 /*?*/ 				long nSizeYPix;
//STRIP001 /*?*/ 				aViewData.GetMergeSizePixel( nCol, nRow, nSizeXPix, nSizeYPix );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// HintWindow anlegen, bestimmt seine Groesse selbst
//STRIP001 /*?*/ 				pInputHintWindow = new ScHintWindow( pFrameWin, aTitle, aMessage );
//STRIP001 /*?*/ 				Size aHintSize = pInputHintWindow->GetSizePixel();
//STRIP001 /*?*/ 				Size aFrameSize = pFrameWin->GetOutputSizePixel();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// passende Position finden
//STRIP001 /*?*/ 				//	erster Versuch: unter dem Cursor
//STRIP001 /*?*/ 				Point aHintPos( aPos.X() + nSizeXPix / 2, aPos.Y() + nSizeYPix + 3 );
//STRIP001 /*?*/ 				if ( aHintPos.Y() + aHintSize.Height() > aFrameSize.Height() )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					// zweiter Versuch: rechts vom Cursor
//STRIP001 /*?*/ 					aHintPos = Point( aPos.X() + nSizeXPix + 3, aPos.Y() + nSizeYPix / 2 );
//STRIP001 /*?*/ 					if ( aHintPos.X() + aHintSize.Width() > aFrameSize.Width() )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						// dritter Versuch: ueber dem Cursor
//STRIP001 /*?*/ 						aHintPos = Point( aPos.X() + nSizeXPix / 2,
//STRIP001 /*?*/ 											aPos.Y() - aHintSize.Height() - 3 );
//STRIP001 /*?*/ 						if ( aHintPos.Y() < 0 )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							// oben und unten kein Platz - dann Default und abschneiden
//STRIP001 /*?*/ 							aHintPos = Point( aPos.X() + nSizeXPix / 2, aPos.Y() + nSizeYPix + 3 );
//STRIP001 /*?*/ 							aHintSize.Height() = aFrameSize.Height() - aHintPos.Y();
//STRIP001 /*?*/ 							pInputHintWindow->SetSizePixel( aHintSize );
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				//	X anpassen
//STRIP001 /*?*/ 				if ( aHintPos.X() + aHintSize.Width() > aFrameSize.Width() )
//STRIP001 /*?*/ 					aHintPos.X() = aFrameSize.Width() - aHintSize.Width();
//STRIP001 /*?*/ 				//	Y anpassen
//STRIP001 /*?*/ 				if ( aHintPos.Y() + aHintSize.Height() > aFrameSize.Height() )
//STRIP001 /*?*/ 					aHintPos.Y() = aFrameSize.Height() - aHintSize.Height();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				pInputHintWindow->SetPosPixel( aHintPos );
//STRIP001 /*?*/ 				pInputHintWindow->ToTop();
//STRIP001 /*?*/ 				pInputHintWindow->Show();
/*?*/ 			}
/*?*/ 		}
/*?*/ 		else
/*?*/ 			DELETEZ(pInputHintWindow);
/*N*/ 	}
/*N*/ 	else
/*N*/ 		DELETEZ(pInputHintWindow);
/*N*/ }

//STRIP001 void ScTabView::RemoveHintWindow()
//STRIP001 {
//STRIP001 	DELETEZ(pInputHintWindow);
//STRIP001 }


// find window that should not be over the cursor
//STRIP001 Window* lcl_GetCareWin(SfxViewFrame* pViewFrm)
//STRIP001 {
//STRIP001 	//!	auch Spelling ??? (dann beim Aufruf Membervariable setzen)
//STRIP001 
//STRIP001 	//	Suchen & Ersetzen
//STRIP001 	if ( pViewFrm->HasChildWindow(SID_SEARCH_DLG) )
//STRIP001 	{
//STRIP001 		SfxChildWindow* pChild = pViewFrm->GetChildWindow(SID_SEARCH_DLG);
//STRIP001 		if (pChild)
//STRIP001 		{
//STRIP001 			Window* pWin = pChild->GetWindow();
//STRIP001 			if (pWin && pWin->IsVisible())
//STRIP001 				return pWin;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Aenderungen uebernehmen
//STRIP001 	if ( pViewFrm->HasChildWindow(FID_CHG_ACCEPT) )
//STRIP001 	{
//STRIP001 		SfxChildWindow* pChild = pViewFrm->GetChildWindow(FID_CHG_ACCEPT);
//STRIP001 		if (pChild)
//STRIP001 		{
//STRIP001 			Window* pWin = pChild->GetWindow();
//STRIP001 			if (pWin && pWin->IsVisible())
//STRIP001 				return pWin;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return NULL;
//STRIP001 }

	//
	//	Bildschirm an Cursorposition anpassen
	//

/*N*/ void ScTabView::AlignToCursor( short nCurX, short nCurY, ScFollowMode eMode,
/*N*/ 								const ScSplitPos* pWhich )
/*N*/ {
/*N*/ 	//
/*N*/ 	//	aktiven Teil umschalten jetzt hier
/*N*/ 	//
/*N*/ 
/*N*/ 	ScSplitPos eActive = aViewData.GetActivePart();
/*N*/ 	ScHSplitPos eActiveX = WhichH(eActive);
/*N*/ 	ScVSplitPos eActiveY = WhichV(eActive);
/*N*/ 	BOOL bHFix = (aViewData.GetHSplitMode() == SC_SPLIT_FIX);
/*N*/ 	BOOL bVFix = (aViewData.GetVSplitMode() == SC_SPLIT_FIX);
/*N*/ 	if (bHFix)
/*N*/ 		if (eActiveX == SC_SPLIT_LEFT && nCurX >= (short)aViewData.GetFixPosX())
/*N*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*N*/ 			ActivatePart( (eActiveY==SC_SPLIT_TOP) ? SC_SPLIT_TOPRIGHT : SC_SPLIT_BOTTOMRIGHT );
//STRIP001 /*N*/ 			eActiveX = SC_SPLIT_RIGHT;
/*N*/ 		}
/*N*/ 	if (bVFix)
/*N*/ 		if (eActiveY == SC_SPLIT_TOP && nCurY >= (short)aViewData.GetFixPosY())
/*N*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*N*/ 			ActivatePart( (eActiveX==SC_SPLIT_LEFT) ? SC_SPLIT_BOTTOMLEFT : SC_SPLIT_BOTTOMRIGHT );
//STRIP001 /*N*/ 			eActiveY = SC_SPLIT_BOTTOM;
/*N*/ 		}
/*N*/ 
/*N*/ 	//
/*N*/ 	//	eigentliches Align
/*N*/ 	//
/*N*/ 
/*N*/ 	if ( eMode != SC_FOLLOW_NONE )
/*N*/ 	{
/*N*/ 		ScSplitPos eAlign;
/*N*/ 		if (pWhich)
/*N*/ 			eAlign = *pWhich;
/*N*/ 		else
/*N*/ 			eAlign = aViewData.GetActivePart();
/*N*/ 		ScHSplitPos eAlignX = WhichH(eAlign);
/*N*/ 		ScVSplitPos eAlignY = WhichV(eAlign);
/*N*/ 
/*N*/ 		short nDeltaX = (short) aViewData.GetPosX(eAlignX);
/*N*/ 		short nDeltaY = (short) aViewData.GetPosY(eAlignY);
/*N*/ 		short nSizeX = (short) aViewData.VisibleCellsX(eAlignX);
/*N*/ 		short nSizeY = (short) aViewData.VisibleCellsY(eAlignY);
/*N*/ 
/*N*/ 		long nCellSizeX;
/*N*/ 		long nCellSizeY;
/*N*/ 		if ( nCurX >= 0 && nCurY >= 0 )
/*N*/ 			aViewData.GetMergeSizePixel( (USHORT)nCurX, (USHORT)nCurY, nCellSizeX, nCellSizeY );
/*N*/ 		else
/*N*/ 			nCellSizeX = nCellSizeY = 0;
/*N*/ 		Size aScrSize = aViewData.GetScrSize();
/*N*/ 		long nSpaceX = ( aScrSize.Width()  - nCellSizeX ) / 2;
/*N*/ 		long nSpaceY = ( aScrSize.Height() - nCellSizeY ) / 2;
/*N*/ 		//	nSpaceY: desired start position of cell for FOLLOW_JUMP, modified if dialog interferes
/*N*/ 
/*N*/ 		BOOL bForceNew = FALSE;		// force new calculation of JUMP position (vertical only)
/*N*/ 
/*N*/ 		// VisibleCellsY == CellsAtY( GetPosY( eWhichY ), 1, eWhichY )
/*N*/ 
/*N*/ 		//-------------------------------------------------------------------------------
/*N*/ 		//	falls z.B. Suchen-Dialog offen ist, Cursor nicht hinter den Dialog stellen
/*N*/ 		//	wenn moeglich, die Zeile mit dem Cursor oberhalb oder unterhalb des Dialogs
/*N*/ 
/*N*/ 		//!	nicht, wenn schon komplett sichtbar
/*N*/ 
/*N*/ 		if ( eMode == SC_FOLLOW_JUMP )
/*N*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*N*/ 			Window* pCare = lcl_GetCareWin( aViewData.GetViewShell()->GetViewFrame() );
//STRIP001 /*N*/ 			if (pCare)
//STRIP001 /*N*/ 			{
//STRIP001 /*N*/ 				BOOL bLimit = FALSE;
//STRIP001 /*N*/ 				Rectangle aDlgPixel;
//STRIP001 /*N*/ 				Size aWinSize;
//STRIP001 /*N*/ 				Window* pWin = GetActiveWin();
//STRIP001 /*N*/ 				if (pWin)
//STRIP001 /*N*/ 				{
//STRIP001 /*N*/ 					aDlgPixel = pCare->GetWindowExtentsRelative( pWin );
//STRIP001 /*N*/ 					aWinSize = pWin->GetOutputSizePixel();
//STRIP001 /*N*/ 					//	ueberdeckt der Dialog das GridWin?
//STRIP001 /*N*/ 					if ( aDlgPixel.Right() >= 0 && aDlgPixel.Left() < aWinSize.Width() )
//STRIP001 /*N*/ 					{
//STRIP001 /*N*/ 						if ( nCurX < nDeltaX || nCurX >= nDeltaX+nSizeX ||
//STRIP001 /*N*/ 							 nCurY < nDeltaY || nCurY >= nDeltaY+nSizeY )
//STRIP001 /*N*/ 							bLimit = TRUE;			// es wird sowieso gescrollt
//STRIP001 /*N*/ 						else
//STRIP001 /*N*/ 						{
//STRIP001 /*N*/ 							//	Cursor ist auf dem Bildschirm
//STRIP001 /*N*/ 							Point aStart = aViewData.GetScrPos( nCurX, nCurY, eAlign );
//STRIP001 /*N*/ 							long nCSX, nCSY;
//STRIP001 /*N*/ 							aViewData.GetMergeSizePixel( nCurX, nCurY, nCSX, nCSY );
//STRIP001 /*N*/ 							Rectangle aCursor( aStart, Size( nCSX, nCSY ) );
//STRIP001 /*N*/ 							if ( aCursor.IsOver( aDlgPixel ) )
//STRIP001 /*N*/ 								bLimit = TRUE;		// Zelle vom Dialog ueberdeckt
//STRIP001 /*N*/ 						}
//STRIP001 /*N*/ 					}
//STRIP001 /*N*/ 				}
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 				if (bLimit)
//STRIP001 /*N*/ 				{
//STRIP001 /*N*/ 					BOOL bBottom = FALSE;
//STRIP001 /*N*/ 					long nTopSpace = aDlgPixel.Top();
//STRIP001 /*N*/ 					long nBotSpace = aWinSize.Height() - aDlgPixel.Bottom();
//STRIP001 /*N*/ 					if ( nBotSpace > 0 && nBotSpace > nTopSpace )
//STRIP001 /*N*/ 					{
//STRIP001 /*N*/ 						long nDlgBot = aDlgPixel.Bottom();
//STRIP001 /*N*/ 						short nWPosX, nWPosY;
//STRIP001 /*N*/ 						aViewData.GetPosFromPixel( 0,nDlgBot, eAlign, nWPosX, nWPosY );
//STRIP001 /*N*/ 						++nWPosY;	// unter der letzten betroffenen Zelle
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 						short nDiff = nWPosY - nDeltaY;
//STRIP001 /*N*/ 						if ( nCurY >= nDiff )			// Pos. kann nicht negativ werden
//STRIP001 /*N*/ 						{
//STRIP001 /*N*/ 							nSpaceY = nDlgBot + ( nBotSpace - nCellSizeY ) / 2;
//STRIP001 /*N*/ 							bBottom = TRUE;
//STRIP001 /*N*/ 							bForceNew = TRUE;
//STRIP001 /*N*/ 						}
//STRIP001 /*N*/ 					}
//STRIP001 /*N*/ 					if ( !bBottom && nTopSpace > 0 )
//STRIP001 /*N*/ 					{
//STRIP001 /*N*/ 						nSpaceY = ( nTopSpace - nCellSizeY ) / 2;
//STRIP001 /*N*/ 						bForceNew = TRUE;
//STRIP001 /*N*/ 					}
//STRIP001 /*N*/ 				}
//STRIP001 /*N*/ 			}
/*N*/ 		}
/*N*/ 		//-------------------------------------------------------------------------------
/*N*/ 
/*N*/ 		short nNewDeltaX = nDeltaX;
/*N*/ 		short nNewDeltaY = nDeltaY;
/*N*/ 		BOOL bDoLine = FALSE;
/*N*/ 
/*N*/ 		switch (eMode)
/*N*/ 		{
/*N*/ 			case SC_FOLLOW_JUMP:
/*N*/ 				if ( nCurX < nDeltaX || nCurX >= nDeltaX+nSizeX )
/*N*/ 				{
/*N*/ 					nNewDeltaX = nCurX - aViewData.CellsAtX( nCurX, -1, eAlignX, nSpaceX );
/*N*/ 					if (nNewDeltaX < 0) nNewDeltaX = 0;
/*N*/ 					nSizeX = (short) aViewData.CellsAtX( nNewDeltaX, 1, eAlignX );
/*N*/ 				}
/*N*/ 				if ( nCurY < nDeltaY || nCurY >= nDeltaY+nSizeY || bForceNew )
/*N*/ 				{
/*N*/ 					nNewDeltaY = nCurY - aViewData.CellsAtY( nCurY, -1, eAlignY, nSpaceY );
/*N*/ 					if (nNewDeltaY < 0) nNewDeltaY = 0;
/*N*/ 					nSizeY = (short) aViewData.CellsAtY( nNewDeltaY, 1, eAlignY );
/*N*/ 				}
/*N*/ 				bDoLine = TRUE;
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SC_FOLLOW_LINE:
/*N*/ 				bDoLine = TRUE;
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SC_FOLLOW_FIX:
/*N*/ 				if ( nCurX < nDeltaX || nCurX >= nDeltaX+nSizeX )
/*N*/ 				{
/*N*/ 					nNewDeltaX = nDeltaX + nCurX - aViewData.GetCurX();
/*N*/ 					nSizeX = (short) aViewData.CellsAtX( nNewDeltaX, 1, eAlignX );
/*N*/ 				}
/*N*/ 				if ( nCurY < nDeltaY || nCurY >= nDeltaY+nSizeY )
/*N*/ 				{
/*N*/ 					nNewDeltaY = nDeltaY + nCurY - aViewData.GetCurY();
/*N*/ 					nSizeY = (short) aViewData.CellsAtY( nNewDeltaY, 1, eAlignY );
/*N*/ 				}
/*N*/ 
/*N*/ 				//	like old version of SC_FOLLOW_JUMP:
/*N*/ 
/*N*/ 				if ( nCurX < nNewDeltaX || nCurX >= nNewDeltaX+nSizeX )
/*N*/ 				{
/*N*/ 					nNewDeltaX = nCurX - (nSizeX / 2);
/*N*/ 					if (nNewDeltaX < 0) nNewDeltaY = 0;
/*N*/ 					nSizeX = (short) aViewData.CellsAtX( nNewDeltaX, 1, eAlignX );
/*N*/ 				}
/*N*/ 				if ( nCurY < nNewDeltaY || nCurY >= nNewDeltaY+nSizeY )
/*N*/ 				{
/*N*/ 					nNewDeltaY = nCurY - (nSizeY / 2);
/*N*/ 					if (nNewDeltaY < 0) nNewDeltaY = 0;
/*N*/ 					nSizeY = (short) aViewData.CellsAtY( nNewDeltaY, 1, eAlignY );
/*N*/ 				}
/*N*/ 
/*N*/ 				bDoLine = TRUE;
/*N*/ 				break;
/*N*/ 
/*N*/ 			case SC_FOLLOW_NONE:
/*N*/ 				break;
/*N*/ 			default:
/*N*/ 				DBG_ERROR("Falscher Cursormodus");
/*N*/ 				break;
/*N*/ 		}
/*N*/ 
/*N*/ 		if (bDoLine)
/*N*/ 		{
/*N*/ 			while ( nCurX >= nNewDeltaX+nSizeX )
/*N*/ 			{
/*N*/ 				nNewDeltaX = nCurX-nSizeX+1;
/*N*/ 				ScDocument* pDoc = aViewData.GetDocument();
/*N*/ 				USHORT nTab = aViewData.GetTabNo();
/*N*/ 				while ( nNewDeltaX < MAXCOL && !pDoc->GetColWidth( nNewDeltaX, nTab ) )
/*N*/ 					++nNewDeltaX;
/*N*/ 				nSizeX = (short) aViewData.CellsAtX( nNewDeltaX, 1, eAlignX );
/*N*/ 			}
/*N*/ 			while ( nCurY >= nNewDeltaY+nSizeY )
/*N*/ 			{
/*N*/ 				nNewDeltaY = nCurY-nSizeY+1;
/*N*/ 				ScDocument* pDoc = aViewData.GetDocument();
/*N*/ 				USHORT nTab = aViewData.GetTabNo();
/*N*/ 				while ( nNewDeltaY < MAXROW && !pDoc->GetRowHeight( nNewDeltaY, nTab ) )
/*N*/ 					++nNewDeltaY;
/*N*/ 				nSizeY = (short) aViewData.CellsAtY( nNewDeltaY, 1, eAlignY );
/*N*/ 			}
/*N*/ 			if ( nCurX < nNewDeltaX ) nNewDeltaX = nCurX;
/*N*/ 			if ( nCurY < nNewDeltaY ) nNewDeltaY = nCurY;
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( nNewDeltaX != nDeltaX )
/*N*/ 			nSizeX = (short) aViewData.CellsAtX( nNewDeltaX, 1, eAlignX );
/*N*/ 		if (nNewDeltaX+nSizeX-1 > MAXCOL) nNewDeltaX = MAXCOL-nSizeX+1;
/*N*/ 		if (nNewDeltaX < 0) nNewDeltaX = 0;
/*N*/ 
/*N*/ 		if ( nNewDeltaY != nDeltaY )
/*N*/ 			nSizeY = (short) aViewData.CellsAtY( nNewDeltaY, 1, eAlignY );
/*N*/ 		if (nNewDeltaY+nSizeY-1 > MAXROW) nNewDeltaY = MAXROW-nSizeY+1;
/*N*/ 		if (nNewDeltaY < 0) nNewDeltaY = 0;
/*N*/ 
/*N*/ 		if ( nNewDeltaX != nDeltaX ) ScrollX( nNewDeltaX - nDeltaX, eAlignX );
/*N*/ 		if ( nNewDeltaY != nDeltaY ) ScrollY( nNewDeltaY - nDeltaY, eAlignY );
/*N*/ 	}
/*N*/ 
/*N*/ 	//
/*N*/ 	//	nochmal aktiven Teil umschalten
/*N*/ 	//
/*N*/ 
/*N*/ 	if (bHFix)
/*N*/ 		if (eActiveX == SC_SPLIT_RIGHT && nCurX < (short)aViewData.GetFixPosX())
/*N*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*N*/ 			ActivatePart( (eActiveY==SC_SPLIT_TOP) ? SC_SPLIT_TOPLEFT : SC_SPLIT_BOTTOMLEFT );
//STRIP001 /*N*/ 			eActiveX = SC_SPLIT_LEFT;
/*N*/ 		}
/*N*/ 	if (bVFix)
/*N*/ 		if (eActiveY == SC_SPLIT_BOTTOM && nCurY < (short)aViewData.GetFixPosY())
/*N*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*N*/ 			ActivatePart( (eActiveX==SC_SPLIT_LEFT) ? SC_SPLIT_TOPLEFT : SC_SPLIT_TOPRIGHT );
//STRIP001 /*N*/ 			eActiveY = SC_SPLIT_TOP;
/*N*/ 		}
/*N*/ }

//STRIP001 BOOL ScTabView::SelMouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	if ( pSelEngine )
//STRIP001 	{
//STRIP001 		bMoveIsShift = rMEvt.IsShift();
//STRIP001 		bRet = pSelEngine->SelMouseButtonDown( rMEvt );
//STRIP001 		bMoveIsShift = FALSE;
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }

	//
	//	MoveCursor - mit Anpassung des Bildausschnitts
	//

//STRIP001 void ScTabView::MoveCursorAbs( short nCurX, short nCurY, ScFollowMode eMode,
//STRIP001 								BOOL bShift, BOOL bControl, BOOL bKeepOld, BOOL bKeepSel )
//STRIP001 {
//STRIP001 	if (!bKeepOld)
//STRIP001 		aViewData.ResetOldCursor();
//STRIP001 
//STRIP001 	if (nCurX < 0) nCurX = 0;
//STRIP001 	if (nCurY < 0) nCurY = 0;
//STRIP001 	if (nCurX > MAXCOL) nCurX = MAXCOL;
//STRIP001 	if (nCurY > MAXROW) nCurY = MAXROW;
//STRIP001 
//STRIP001 	HideAllCursors();
//STRIP001 
//STRIP001 	if ( bShift && bNewStartIfMarking && IsBlockMode() )
//STRIP001 	{
//STRIP001 		//	used for ADD selection mode: start a new block from the cursor position
//STRIP001 		DoneBlockMode( TRUE );
//STRIP001 		InitBlockMode( aViewData.GetCurX(), aViewData.GetCurY(), aViewData.GetTabNo(), TRUE );
//STRIP001 	}
//STRIP001 
//STRIP001 		//	aktiven Teil umschalten jetzt in AlignToCursor
//STRIP001 
//STRIP001 	AlignToCursor( nCurX, nCurY, eMode );
//STRIP001 	//!		auf OS/2: SC_FOLLOW_JUMP statt SC_FOLLOW_LINE, um Nachlaufen zu verhindern ???
//STRIP001 
//STRIP001 	if (bKeepSel)
//STRIP001 		SetCursor( nCurX, nCurY );		// Markierung stehenlassen
//STRIP001 	else
//STRIP001 	{
//STRIP001 		BOOL bSame = ( nCurX == aViewData.GetCurX() && nCurY == aViewData.GetCurY() );
//STRIP001 		bMoveIsShift = bShift;
//STRIP001 		pSelEngine->CursorPosChanging( bShift, bControl );
//STRIP001 		bMoveIsShift = FALSE;
//STRIP001 		aFunctionSet.SetCursorAtCell( nCurX, nCurY, FALSE );
//STRIP001 
//STRIP001 		//	Wenn der Cursor nicht bewegt wurde, muss das SelectionChanged fuer das
//STRIP001 		//	Aufheben der Selektion hier einzeln passieren:
//STRIP001 		if (bSame)
//STRIP001 			SelectionChanged();
//STRIP001 	}
//STRIP001 
//STRIP001 	ShowAllCursors();
//STRIP001 }

//STRIP001 void ScTabView::MoveCursorRel( short nMovX, short nMovY, ScFollowMode eMode,
//STRIP001 									BOOL bShift, BOOL bKeepSel )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = aViewData.GetDocument();
//STRIP001 	USHORT nTab = aViewData.GetTabNo();
//STRIP001 
//STRIP001 	short nOldX;
//STRIP001 	short nOldY;
//STRIP001 	short nCurX;
//STRIP001 	short nCurY;
//STRIP001 	if ( aViewData.IsRefMode() )
//STRIP001 	{
//STRIP001 		nOldX = (short) aViewData.GetRefEndX();
//STRIP001 		nOldY = (short) aViewData.GetRefEndY();
//STRIP001 		nCurX = nOldX + nMovX;
//STRIP001 		nCurY = nOldY + nMovY;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nOldX = (short) aViewData.GetCurX();
//STRIP001 		nOldY = (short) aViewData.GetCurY();
//STRIP001 		nCurX = nMovX ? nOldX+nMovX : (short) aViewData.GetOldCurX();
//STRIP001 		nCurY = nMovY ? nOldY+nMovY : (short) aViewData.GetOldCurY();
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bHidden;
//STRIP001 	aViewData.ResetOldCursor();
//STRIP001 
//STRIP001 	if (nMovX && VALIDCOLROW(nCurX,nCurY))
//STRIP001 	{
//STRIP001 		BOOL bHFlip = FALSE;
//STRIP001 		do
//STRIP001 		{
//STRIP001 			BYTE nColFlags = pDoc->GetColFlags( nCurX, nTab );
//STRIP001 			bHidden = (nColFlags & CR_HIDDEN) || pDoc->IsHorOverlapped( nCurX, nCurY, nTab );
//STRIP001 			if (bHidden)
//STRIP001 			{
//STRIP001 				if ( nCurX<=0 || nCurX>=MAXCOL )
//STRIP001 				{
//STRIP001 					if (bHFlip)
//STRIP001 					{
//STRIP001 						nCurX = nOldX;
//STRIP001 						bHidden = FALSE;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						nMovX = -nMovX;
//STRIP001 						if (nMovX > 0) ++nCurX; else --nCurX;		// zuruecknehmen
//STRIP001 						bHFlip = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 					if (nMovX > 0) ++nCurX; else --nCurX;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		while (bHidden);
//STRIP001 		if (pDoc->IsVerOverlapped( nCurX, nCurY, nTab ))
//STRIP001 		{
//STRIP001 			aViewData.SetOldCursor( nCurX,nCurY );
//STRIP001 			while (pDoc->IsVerOverlapped( nCurX, nCurY, nTab ))
//STRIP001 				--nCurY;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nMovY && VALIDCOLROW(nCurX,nCurY))
//STRIP001 	{
//STRIP001 		BOOL bVFlip = FALSE;
//STRIP001 		do
//STRIP001 		{
//STRIP001 			BYTE nRowFlags = pDoc->GetRowFlags( nCurY, nTab );
//STRIP001 			bHidden = (nRowFlags & CR_HIDDEN) || pDoc->IsVerOverlapped( nCurX, nCurY, nTab );
//STRIP001 			if (bHidden)
//STRIP001 			{
//STRIP001 				if ( nCurY<=0 || nCurY>=MAXROW )
//STRIP001 				{
//STRIP001 					if (bVFlip)
//STRIP001 					{
//STRIP001 						nCurY = nOldY;
//STRIP001 						bHidden = FALSE;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						nMovY = -nMovY;
//STRIP001 						if (nMovY > 0) ++nCurY; else --nCurY;		// zuruecknehmen
//STRIP001 						bVFlip = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 					if (nMovY > 0) ++nCurY; else --nCurY;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		while (bHidden);
//STRIP001 		if (pDoc->IsHorOverlapped( nCurX, nCurY, nTab ))
//STRIP001 		{
//STRIP001 			aViewData.SetOldCursor( nCurX,nCurY );
//STRIP001 			while (pDoc->IsHorOverlapped( nCurX, nCurY, nTab ))
//STRIP001 				--nCurX;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	MoveCursorAbs( nCurX, nCurY, eMode, bShift, FALSE, TRUE, bKeepSel );
//STRIP001 }

//STRIP001 void ScTabView::MoveCursorPage( short nMovX, short nMovY, ScFollowMode eMode, BOOL bShift, BOOL bKeepSel )
//STRIP001 {
//STRIP001 	USHORT nCurX;
//STRIP001 	USHORT nCurY;
//STRIP001 	aViewData.GetMoveCursor( nCurX,nCurY );
//STRIP001 
//STRIP001 	ScSplitPos eWhich = aViewData.GetActivePart();
//STRIP001 	ScHSplitPos eWhichX = WhichH( eWhich );
//STRIP001 	ScVSplitPos eWhichY = WhichV( eWhich );
//STRIP001 
//STRIP001 	short nPageX;
//STRIP001 	short nPageY;
//STRIP001 	if (nMovX >= 0)
//STRIP001 		nPageX = ((short) aViewData.CellsAtX( nCurX, 1, eWhichX )) * nMovX;
//STRIP001 	else
//STRIP001 		nPageX = ((short) aViewData.CellsAtX( nCurX, -1, eWhichX )) * nMovX;
//STRIP001 
//STRIP001 	if (nMovY >= 0)
//STRIP001 		nPageY = ((short) aViewData.CellsAtY( nCurY, 1, eWhichY )) * nMovY;
//STRIP001 	else
//STRIP001 		nPageY = ((short) aViewData.CellsAtY( nCurY, -1, eWhichY )) * nMovY;
//STRIP001 
//STRIP001 	if (nMovX && !nPageX) nPageX = (nMovX>0) ? 1 : -1;
//STRIP001 	if (nMovY && !nPageY) nPageY = (nMovY>0) ? 1 : -1;
//STRIP001 
//STRIP001 	MoveCursorRel( nPageX, nPageY, eMode, bShift, bKeepSel );
//STRIP001 }

//STRIP001 void ScTabView::MoveCursorArea( short nMovX, short nMovY, ScFollowMode eMode, BOOL bShift, BOOL bKeepSel )
//STRIP001 {
//STRIP001 	USHORT nCurX;
//STRIP001 	USHORT nCurY;
//STRIP001 	aViewData.GetMoveCursor( nCurX,nCurY );
//STRIP001 	USHORT nNewX = nCurX;
//STRIP001 	USHORT nNewY = nCurY;
//STRIP001 
//STRIP001 	ScDocument* pDoc = aViewData.GetDocument();
//STRIP001 	USHORT nTab = aViewData.GetTabNo();
//STRIP001 
//STRIP001 	//	FindAreaPos kennt nur -1 oder 1 als Richtung
//STRIP001 
//STRIP001 	short i;
//STRIP001 	if ( nMovX > 0 )
//STRIP001 		for ( i=0; i<nMovX; i++ )
//STRIP001 			pDoc->FindAreaPos( nNewX, nNewY, nTab,  1,  0 );
//STRIP001 	if ( nMovX < 0 )
//STRIP001 		for ( i=0; i<-nMovX; i++ )
//STRIP001 			pDoc->FindAreaPos( nNewX, nNewY, nTab, -1,  0 );
//STRIP001 	if ( nMovY > 0 )
//STRIP001 		for ( i=0; i<nMovY; i++ )
//STRIP001 			pDoc->FindAreaPos( nNewX, nNewY, nTab,  0,  1 );
//STRIP001 	if ( nMovY < 0 )
//STRIP001 		for ( i=0; i<-nMovY; i++ )
//STRIP001 			pDoc->FindAreaPos( nNewX, nNewY, nTab,  0, -1 );
//STRIP001 
//STRIP001 	if (eMode==SC_FOLLOW_JUMP)					// unten/rechts nicht zuviel grau anzeigen
//STRIP001 	{
//STRIP001 		if (nMovX != 0 && nNewX == MAXCOL)
//STRIP001 			eMode = SC_FOLLOW_LINE;
//STRIP001 		if (nMovY != 0 && nNewY == MAXROW)
//STRIP001 			eMode = SC_FOLLOW_LINE;
//STRIP001 	}
//STRIP001 
//STRIP001 	MoveCursorRel( ((short)nNewX)-(short)nCurX, ((short)nNewY)-(short)nCurY, eMode, bShift, bKeepSel );
//STRIP001 }

//STRIP001 void ScTabView::MoveCursorEnd( short nMovX, short nMovY, ScFollowMode eMode, BOOL bShift, BOOL bKeepSel )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = aViewData.GetDocument();
//STRIP001 	USHORT nTab = aViewData.GetTabNo();
//STRIP001 
//STRIP001 	USHORT nCurX;
//STRIP001 	USHORT nCurY;
//STRIP001 	aViewData.GetMoveCursor( nCurX,nCurY );
//STRIP001 	USHORT nNewX = nCurX;
//STRIP001 	USHORT nNewY = nCurY;
//STRIP001 
//STRIP001 	USHORT nUsedX = 0;
//STRIP001 	USHORT nUsedY = 0;
//STRIP001 	if ( nMovX > 0 || nMovY > 0 )
//STRIP001 		pDoc->GetPrintArea( nTab, nUsedX, nUsedY );		// Ende holen
//STRIP001 
//STRIP001 	if (nMovX<0)
//STRIP001 		nNewX=0;
//STRIP001 	else if (nMovX>0)
//STRIP001 		nNewX=nUsedX;									// letzter benutzter Bereich
//STRIP001 
//STRIP001 	if (nMovY<0)
//STRIP001 		nNewY=0;
//STRIP001 	else if (nMovY>0)
//STRIP001 		nNewY=nUsedY;
//STRIP001 
//STRIP001 	aViewData.ResetOldCursor();
//STRIP001 	MoveCursorRel( ((short)nNewX)-(short)nCurX, ((short)nNewY)-(short)nCurY, eMode, bShift, bKeepSel );
//STRIP001 }

//STRIP001 void ScTabView::MoveCursorScreen( short nMovX, short nMovY, ScFollowMode eMode, BOOL bShift )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = aViewData.GetDocument();
//STRIP001 	USHORT nTab = aViewData.GetTabNo();
//STRIP001 
//STRIP001 	USHORT nCurX;
//STRIP001 	USHORT nCurY;
//STRIP001 	aViewData.GetMoveCursor( nCurX,nCurY );
//STRIP001 	USHORT nNewX = nCurX;
//STRIP001 	USHORT nNewY = nCurY;
//STRIP001 
//STRIP001 	ScSplitPos eWhich = aViewData.GetActivePart();
//STRIP001 	USHORT nPosX = aViewData.GetPosX( WhichH(eWhich) );
//STRIP001 	USHORT nPosY = aViewData.GetPosY( WhichV(eWhich) );
//STRIP001 
//STRIP001 	USHORT nAddX = aViewData.VisibleCellsX( WhichH(eWhich) );
//STRIP001 	if (nAddX)
//STRIP001 		--nAddX;
//STRIP001 	USHORT nAddY = aViewData.VisibleCellsY( WhichV(eWhich) );
//STRIP001 	if (nAddY)
//STRIP001 		--nAddY;
//STRIP001 
//STRIP001 	if (nMovX<0)
//STRIP001 		nNewX=nPosX;
//STRIP001 	else if (nMovX>0)
//STRIP001 		nNewX=nPosX+nAddX;
//STRIP001 
//STRIP001 	if (nMovY<0)
//STRIP001 		nNewY=nPosY;
//STRIP001 	else if (nMovY>0)
//STRIP001 		nNewY=nPosY+nAddY;
//STRIP001 
//STRIP001 //	aViewData.ResetOldCursor();
//STRIP001 	aViewData.SetOldCursor( nNewX,nNewY );
//STRIP001 
//STRIP001 	while (pDoc->IsHorOverlapped( nNewX, nNewY, nTab ))
//STRIP001 		--nNewX;
//STRIP001 	while (pDoc->IsVerOverlapped( nNewX, nNewY, nTab ))
//STRIP001 		--nNewY;
//STRIP001 
//STRIP001 	MoveCursorAbs( nNewX, nNewY, eMode, bShift, FALSE, TRUE );
//STRIP001 }

//STRIP001 void ScTabView::MoveCursorEnter( BOOL bShift )			// bShift -> hoch/runter
//STRIP001 {
//STRIP001 	const ScInputOptions& rOpt = SC_MOD()->GetInputOptions();
//STRIP001 	if (!rOpt.GetMoveSelection())
//STRIP001 	{
//STRIP001 		aViewData.UpdateInputHandler(TRUE);
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	short nMoveX = 0;
//STRIP001 	short nMoveY = 0;
//STRIP001 	switch ((ScDirection)rOpt.GetMoveDir())
//STRIP001 	{
//STRIP001 		case DIR_BOTTOM:
//STRIP001 			nMoveY = bShift ? -1 : 1;
//STRIP001 			break;
//STRIP001 		case DIR_RIGHT:
//STRIP001 			nMoveX = bShift ? -1 : 1;
//STRIP001 			break;
//STRIP001 		case DIR_TOP:
//STRIP001 			nMoveY = bShift ? 1 : -1;
//STRIP001 			break;
//STRIP001 		case DIR_LEFT:
//STRIP001 			nMoveX = bShift ? 1 : -1;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	ScMarkData& rMark = aViewData.GetMarkData();
//STRIP001 	if (rMark.IsMarked() || rMark.IsMultiMarked())
//STRIP001 	{
//STRIP001 		USHORT nCurX;
//STRIP001 		USHORT nCurY;
//STRIP001 		aViewData.GetMoveCursor( nCurX,nCurY );
//STRIP001 		USHORT nNewX = nCurX;
//STRIP001 		USHORT nNewY = nCurY;
//STRIP001 		USHORT nTab = aViewData.GetTabNo();
//STRIP001 
//STRIP001 		ScDocument* pDoc = aViewData.GetDocument();
//STRIP001 		pDoc->GetNextPos( nNewX,nNewY, nTab, nMoveX,nMoveY, TRUE,FALSE, rMark );
//STRIP001 
//STRIP001 		MoveCursorRel( ((short)nNewX)-(short)nCurX, ((short)nNewY)-(short)nCurY,
//STRIP001 							SC_FOLLOW_LINE, FALSE, TRUE );
//STRIP001 
//STRIP001 		//	update input line even if cursor was not moved
//STRIP001 		if ( nNewX == nCurX && nNewY == nCurY )
//STRIP001 			aViewData.UpdateInputHandler(TRUE);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( nMoveY && !nMoveX && rOpt.GetUseTabCol() )
//STRIP001 		{
//STRIP001 			//	nach Tab und Enter wieder zur Ausgangsspalte
//STRIP001 			USHORT nTabCol = aViewData.GetTabStartCol();
//STRIP001 			if (nTabCol != SC_TABSTART_NONE)
//STRIP001 			{
//STRIP001 				USHORT nCurX;
//STRIP001 				USHORT nCurY;
//STRIP001 				aViewData.GetMoveCursor( nCurX,nCurY );
//STRIP001 				nMoveX = ((short)nTabCol)-(short)nCurX;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		MoveCursorRel( nMoveX,nMoveY, SC_FOLLOW_LINE, FALSE );
//STRIP001 	}
//STRIP001 }


//STRIP001 BOOL ScTabView::MoveCursorKeyInput( const KeyEvent& rKeyEvent )
//STRIP001 {
//STRIP001     const KeyCode& rKCode = rKeyEvent.GetKeyCode();
//STRIP001 
//STRIP001     enum { MOD_NONE, MOD_CTRL, MOD_ALT, MOD_BOTH } eModifier =
//STRIP001         rKCode.IsMod1() ?
//STRIP001             (rKCode.IsMod2() ? MOD_BOTH : MOD_CTRL) :
//STRIP001             (rKCode.IsMod2() ? MOD_ALT : MOD_NONE);
//STRIP001 
//STRIP001     BOOL bSel = rKCode.IsShift();
//STRIP001     USHORT nCode = rKCode.GetCode();
//STRIP001 
//STRIP001     // CURSOR keys
//STRIP001     short nDX = 0;
//STRIP001     short nDY = 0;
//STRIP001     switch( nCode )
//STRIP001     {
//STRIP001         case KEY_LEFT:  nDX = -1;   break;
//STRIP001         case KEY_RIGHT: nDX = 1;    break;
//STRIP001         case KEY_UP:    nDY = -1;   break;
//STRIP001         case KEY_DOWN:  nDY = 1;    break;
//STRIP001     }
//STRIP001     if( nDX || nDY )
//STRIP001     {
//STRIP001         switch( eModifier )
//STRIP001         {
//STRIP001             case MOD_NONE:  MoveCursorRel( nDX, nDY, SC_FOLLOW_LINE, bSel );    break;
//STRIP001             case MOD_CTRL:  MoveCursorArea( nDX, nDY, SC_FOLLOW_JUMP, bSel );   break;
//STRIP001         }
//STRIP001         // always TRUE to suppress changes of col/row size (ALT+CURSOR)
//STRIP001         return TRUE;
//STRIP001     }
//STRIP001 
//STRIP001     // PAGEUP/PAGEDOWN
//STRIP001     if( (nCode == KEY_PAGEUP) || (nCode == KEY_PAGEDOWN) )
//STRIP001     {
//STRIP001         nDX = (nCode == KEY_PAGEUP) ? -1 : 1;
//STRIP001         switch( eModifier )
//STRIP001         {
//STRIP001             case MOD_NONE:  MoveCursorPage( 0, nDX, SC_FOLLOW_FIX, bSel );  break;
//STRIP001             case MOD_ALT:   MoveCursorPage( nDX, 0, SC_FOLLOW_FIX, bSel );  break;
//STRIP001             case MOD_CTRL:  SelectNextTab( nDX );                           break;
//STRIP001         }
//STRIP001         return TRUE;
//STRIP001     }
//STRIP001 
//STRIP001     // HOME/END
//STRIP001     if( (nCode == KEY_HOME) || (nCode == KEY_END) )
//STRIP001     {
//STRIP001         nDX = (nCode == KEY_HOME) ? -1 : 1;
//STRIP001         ScFollowMode eMode = (nCode == KEY_HOME) ? SC_FOLLOW_LINE : SC_FOLLOW_JUMP;
//STRIP001         switch( eModifier )
//STRIP001         {
//STRIP001             case MOD_NONE:  MoveCursorEnd( nDX, 0, eMode, bSel );   break;
//STRIP001             case MOD_CTRL:  MoveCursorEnd( nDX, nDX, eMode, bSel ); break;
//STRIP001         }
//STRIP001         return TRUE;
//STRIP001     }
//STRIP001 
//STRIP001     return FALSE;
//STRIP001 }


		// naechste/vorherige nicht geschuetzte Zelle
//STRIP001 void ScTabView::FindNextUnprot( BOOL bShift, BOOL bInSelection )
//STRIP001 {
//STRIP001 	short nMove = bShift ? -1 : 1;
//STRIP001 
//STRIP001 	ScMarkData& rMark = aViewData.GetMarkData();
//STRIP001 	BOOL bMarked = bInSelection && (rMark.IsMarked() || rMark.IsMultiMarked());
//STRIP001 
//STRIP001 	USHORT nCurX;
//STRIP001 	USHORT nCurY;
//STRIP001 	aViewData.GetMoveCursor( nCurX,nCurY );
//STRIP001 	USHORT nNewX = nCurX;
//STRIP001 	USHORT nNewY = nCurY;
//STRIP001 	USHORT nTab = aViewData.GetTabNo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = aViewData.GetDocument();
//STRIP001 	pDoc->GetNextPos( nNewX,nNewY, nTab, nMove,0, bMarked,TRUE, rMark );
//STRIP001 
//STRIP001 	USHORT nTabCol = aViewData.GetTabStartCol();
//STRIP001 	if ( nTabCol == SC_TABSTART_NONE )
//STRIP001 		nTabCol = nCurX;					// auf diese Spalte zurueck bei Enter
//STRIP001 
//STRIP001 	MoveCursorRel( ((short)nNewX)-(short)nCurX, ((short)nNewY)-(short)nCurY,
//STRIP001 						SC_FOLLOW_LINE, FALSE, TRUE );
//STRIP001 
//STRIP001 	//	in MoveCursorRel wird die TabCol zurueckgesetzt...
//STRIP001 	aViewData.SetTabStartCol( nTabCol );
//STRIP001 }

//STRIP001 void ScTabView::MarkColumns()
//STRIP001 {
//STRIP001 	USHORT nStartCol;
//STRIP001 	USHORT nEndCol;
//STRIP001 
//STRIP001 	ScMarkData& rMark = aViewData.GetMarkData();
//STRIP001 	if (rMark.IsMarked())
//STRIP001 	{
//STRIP001 		ScRange aMarkRange;
//STRIP001 		rMark.GetMarkArea( aMarkRange );
//STRIP001 		nStartCol = aMarkRange.aStart.Col();
//STRIP001 		nEndCol = aMarkRange.aEnd.Col();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		USHORT nDummy;
//STRIP001 		aViewData.GetMoveCursor( nStartCol, nDummy );
//STRIP001 		nEndCol=nStartCol;
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nTab = aViewData.GetTabNo();
//STRIP001 	DoneBlockMode();
//STRIP001 	InitBlockMode( nStartCol,0, nTab );
//STRIP001 	MarkCursor( nEndCol,MAXROW, nTab );
//STRIP001 	SelectionChanged();
//STRIP001 }

//STRIP001 void ScTabView::MarkRows()
//STRIP001 {
//STRIP001 	USHORT nStartRow;
//STRIP001 	USHORT nEndRow;
//STRIP001 
//STRIP001 	ScMarkData& rMark = aViewData.GetMarkData();
//STRIP001 	if (rMark.IsMarked())
//STRIP001 	{
//STRIP001 		ScRange aMarkRange;
//STRIP001 		rMark.GetMarkArea( aMarkRange );
//STRIP001 		nStartRow = aMarkRange.aStart.Row();
//STRIP001 		nEndRow = aMarkRange.aEnd.Row();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		USHORT nDummy;
//STRIP001 		aViewData.GetMoveCursor( nDummy, nStartRow );
//STRIP001 		nEndRow=nStartRow;
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nTab = aViewData.GetTabNo();
//STRIP001 	DoneBlockMode();
//STRIP001 	InitBlockMode( 0,nStartRow, nTab );
//STRIP001 	MarkCursor( MAXCOL,nEndRow, nTab );
//STRIP001 	SelectionChanged();
//STRIP001 }

//STRIP001 void ScTabView::MarkDataArea( BOOL bIncludeCursor )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = aViewData.GetDocument();
//STRIP001 	USHORT nTab = aViewData.GetTabNo();
//STRIP001 	USHORT nStartCol = aViewData.GetCurX();
//STRIP001 	USHORT nStartRow = aViewData.GetCurY();
//STRIP001 	USHORT nEndCol = nStartCol;
//STRIP001 	USHORT nEndRow = nStartRow;
//STRIP001 
//STRIP001 	pDoc->GetDataArea( nTab, nStartCol, nStartRow, nEndCol, nEndRow, bIncludeCursor );
//STRIP001 
//STRIP001 	HideAllCursors();
//STRIP001 	DoneBlockMode();
//STRIP001 	InitBlockMode( nStartCol, nStartRow, nTab );
//STRIP001 	MarkCursor( nEndCol, nEndRow, nTab );
//STRIP001 	ShowAllCursors();
//STRIP001 
//STRIP001 	SelectionChanged();
//STRIP001 }

//STRIP001 void ScTabView::MarkMatrixFormula()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = aViewData.GetDocument();
//STRIP001 	ScAddress aCursor( aViewData.GetCurX(), aViewData.GetCurY(), aViewData.GetTabNo() );
//STRIP001 	ScRange aMatrix;
//STRIP001 	if ( pDoc->GetMatrixFormulaRange( aCursor, aMatrix ) )
//STRIP001 	{
//STRIP001 		MarkRange( aMatrix, FALSE );		// cursor is already within the range
//STRIP001 	}
//STRIP001 }

/*N*/ void ScTabView::MarkRange( const ScRange& rRange, BOOL bSetCursor, BOOL bContinue )
/*N*/ {
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 USHORT nTab = rRange.aStart.Tab();
//STRIP001 /*?*/ 	SetTabNo( nTab );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	HideAllCursors();
//STRIP001 /*?*/     DoneBlockMode( bContinue ); // bContinue==TRUE -> clear old mark
//STRIP001 /*?*/     if (bSetCursor)             // Wenn Cursor gesetzt wird, immer auch alignen
//STRIP001 /*N*/ 	{
//STRIP001 /*N*/ 		USHORT nAlignX = rRange.aStart.Col();
//STRIP001 /*N*/ 		USHORT nAlignY = rRange.aStart.Row();
//STRIP001 /*N*/ 		if ( rRange.aStart.Col() == 0 && rRange.aEnd.Col() == MAXCOL )
//STRIP001 /*N*/ 			nAlignX = aViewData.GetPosX(WhichH(aViewData.GetActivePart()));
//STRIP001 /*N*/ 		if ( rRange.aStart.Row() == 0 && rRange.aEnd.Row() == MAXROW )
//STRIP001 /*N*/ 			nAlignY = aViewData.GetPosY(WhichV(aViewData.GetActivePart()));
//STRIP001 /*N*/ 		AlignToCursor( nAlignX, nAlignY, SC_FOLLOW_JUMP );
//STRIP001 /*N*/ 	}
//STRIP001 /*N*/ 	InitBlockMode( rRange.aStart.Col(), rRange.aStart.Row(), nTab );
//STRIP001 /*N*/ 	MarkCursor( rRange.aEnd.Col(), rRange.aEnd.Row(), nTab );
//STRIP001 /*N*/ 	if (bSetCursor)
//STRIP001 /*N*/ 	{
//STRIP001 /*N*/ 		USHORT nPosX = rRange.aStart.Col();
//STRIP001 /*N*/ 		USHORT nPosY = rRange.aStart.Row();
//STRIP001 /*N*/ 		ScDocument* pDoc = aViewData.GetDocument();
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		while (pDoc->IsHorOverlapped( nPosX, nPosY, nTab ))		//! ViewData !!!
//STRIP001 /*N*/ 			--nPosX;
//STRIP001 /*N*/ 		while (pDoc->IsVerOverlapped( nPosX, nPosY, nTab ))
//STRIP001 /*N*/ 			--nPosY;
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		aViewData.ResetOldCursor();
//STRIP001 /*N*/ 		SetCursor( nPosX, nPosY );
//STRIP001 /*N*/ 	}
//STRIP001 /*N*/ 	ShowAllCursors();
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 	SelectionChanged();
/*N*/ }

/*N*/ void ScTabView::Unmark()
/*N*/ {
/*N*/ 	ScMarkData& rMark = aViewData.GetMarkData();
/*N*/ 	if ( rMark.IsMarked() || rMark.IsMultiMarked() )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*N*/ 		USHORT nCurX;
//STRIP001 /*N*/ 		USHORT nCurY;
//STRIP001 /*N*/ 		aViewData.GetMoveCursor( nCurX,nCurY );
//STRIP001 /*N*/ 		MoveCursorAbs( nCurX, nCurY, SC_FOLLOW_NONE, FALSE, FALSE );
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 		SelectionChanged();
/*N*/ 	}
/*N*/ }

//STRIP001 void ScTabView::SelectNextTab( short nDir )
//STRIP001 {
//STRIP001 	if (!nDir) return;
//STRIP001 	DBG_ASSERT( nDir==-1 || nDir==1, "SelectNextTab: falscher Wert");
//STRIP001 
//STRIP001 	ScDocument* pDoc = aViewData.GetDocument();
//STRIP001 	USHORT nTab = aViewData.GetTabNo();
//STRIP001 	if (nDir<0)
//STRIP001 	{
//STRIP001 		if (!nTab) return;
//STRIP001 		--nTab;
//STRIP001 		while (!pDoc->IsVisible(nTab))
//STRIP001 		{
//STRIP001 			if (!nTab) return;
//STRIP001 			--nTab;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		USHORT nCount = pDoc->GetTableCount();
//STRIP001 		++nTab;
//STRIP001 		if (nTab >= nCount) return;
//STRIP001 		while (!pDoc->IsVisible(nTab))
//STRIP001 		{
//STRIP001 			++nTab;
//STRIP001 			if (nTab >= nCount) return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SetTabNo(nTab);
//STRIP001 	PaintExtras();
//STRIP001 }


//	SetTabNo	- angezeigte Tabelle

/*N*/ void ScTabView::SetTabNo( USHORT nTab, BOOL bNew )
/*N*/ {
/*N*/ 	if ( nTab > MAXTAB )
/*N*/ 	{
/*N*/ 		DBG_ERROR("SetTabNo: falsche Tabelle");
/*N*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( nTab != aViewData.GetTabNo() || bNew )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 		//	#57724# Die FormShell moechte vor dem Umschalten benachrichtigt werden
//STRIP001 /*?*/ 		FmFormShell* pFormSh = aViewData.GetViewShell()->GetFormShell();
//STRIP001 /*?*/ 		if (pFormSh)
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			BOOL bAllowed = pFormSh->PrepareClose( TRUE );
//STRIP001 /*?*/ 			if (!bAllowed)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				//!	Fehlermeldung? oder macht das die FormShell selber?
//STRIP001 /*?*/ 				//!	Fehler-Flag zurueckgeben und Aktionen abbrechen
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				return;		// Die FormShell sagt, es kann nicht umgeschaltet werden
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 										//	nicht InputEnterHandler wegen Referenzeingabe !
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		ScDocument* pDoc = aViewData.GetDocument();
//STRIP001 /*?*/ 		pDoc->MakeTable( nTab );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 /*?*/ 		USHORT nOldPos = nTab;
//STRIP001 /*?*/ 		while (!pDoc->IsVisible(nTab))				// naechste sichtbare suchen
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			BOOL bUp = (nTab>=nOldPos);
//STRIP001 /*?*/ 			if (bUp)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				++nTab;
//STRIP001 /*?*/ 				if (nTab>=nTabCount)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					nTab = nOldPos;
//STRIP001 /*?*/ 					bUp = FALSE;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if (!bUp)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				if (nTab)
//STRIP001 /*?*/ 					--nTab;
//STRIP001 /*?*/ 				else
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					DBG_ERROR("keine sichtbare Tabelle");
//STRIP001 /*?*/ 					pDoc->SetVisible( 0, TRUE );
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		BOOL bRefMode = SC_MOD()->IsFormulaMode();
//STRIP001 /*?*/ 		if ( !bRefMode ) // Abfrage, damit RefMode bei Tabellenwechsel funktioniert
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			DoneBlockMode();
//STRIP001 /*M*/ 			pSelEngine->Reset();				// reset all flags, including locked modifiers
//STRIP001 /*?*/ 			aViewData.SetRefTabNo( nTab );
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		aViewData.SetTabNo( nTab );
//STRIP001 /*?*/ 		//	UpdateShow noch vor SetCursor, damit UpdateAutoFillMark die richtigen
//STRIP001 /*?*/ 		//	Fenster findet (wird aus SetCursor gerufen)
//STRIP001 /*?*/ 		UpdateShow();
//STRIP001 /*?*/ 		aViewData.ResetOldCursor();
//STRIP001 /*?*/ 		SetCursor( aViewData.GetCurX(), aViewData.GetCurY(), TRUE );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if ( bRefMode )		// evtl. EditView verstecken (nach aViewData.SetTabNo !)
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			for ( USHORT i=0; i<4; i++ )
//STRIP001 /*?*/ 				if ( pGridWin[i] )
//STRIP001 /*?*/ 					if ( pGridWin[i]->IsVisible() )
//STRIP001 /*?*/ 						pGridWin[i]->UpdateEditViewPos();
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		SfxBindings& rBindings = aViewData.GetBindings();
//STRIP001 /*?*/ 		ScMarkData& rMark = aViewData.GetMarkData();
//STRIP001 /*?*/ 		if (!rMark.GetTableSelect(nTab))
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			rMark.SelectOneTable( nTab );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			rBindings.Invalidate( FID_FILL_TAB );
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		TabChanged();										// DrawView
//STRIP001 /*?*/ 		aViewData.GetViewShell()->WindowChanged();			// falls das aktive Fenster anders ist
//STRIP001 /*?*/ 		aViewData.GetViewShell()->DisconnectAllClients();	// wichtig fuer Floating Frames
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			//	Fixierungen
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		BOOL bResize = FALSE;
//STRIP001 /*?*/ 		if ( aViewData.GetHSplitMode() == SC_SPLIT_FIX )
//STRIP001 /*?*/ 			if (aViewData.UpdateFixX())
//STRIP001 /*?*/ 				bResize = TRUE;
//STRIP001 /*?*/ 		if ( aViewData.GetVSplitMode() == SC_SPLIT_FIX )
//STRIP001 /*?*/ 			if (aViewData.UpdateFixY())
//STRIP001 /*?*/ 				bResize = TRUE;
//STRIP001 /*?*/ 		if (bResize)
//STRIP001 /*?*/ 			RepeatResize();
//STRIP001 /*?*/ 		InvalidateSplit();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if ( aViewData.IsPagebreakMode() )
//STRIP001 /*?*/ 			UpdatePageBreakData();				//! asynchron ??
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		//	#53551# Form-Layer muss den sichtbaren Ausschnitt der neuen Tabelle kennen
//STRIP001 /*?*/ 		//	dafuer muss hier schon der MapMode stimmen
//STRIP001 /*?*/ 		for (USHORT i=0; i<4; i++)
//STRIP001 /*?*/ 			if (pGridWin[i])
//STRIP001 /*?*/ 				pGridWin[i]->SetMapMode( pGridWin[i]->GetDrawMapMode() );
//STRIP001 /*?*/ 		SetNewVisArea();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		PaintGrid();
//STRIP001 /*?*/ 		PaintTop();
//STRIP001 /*?*/ 		PaintLeft();
//STRIP001 /*?*/ 		PaintExtras();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		DoResize( aBorderPos, aFrameSize );
//STRIP001 /*?*/ 		rBindings.Invalidate( SID_DELETE_PRINTAREA );	// Menue
//STRIP001 /*?*/ 		rBindings.Invalidate( FID_DEL_MANUALBREAKS );
//STRIP001 /*?*/ 		rBindings.Invalidate( FID_RESET_PRINTZOOM );
//STRIP001 /*?*/ 		rBindings.Invalidate( SID_STATUS_DOCPOS );		// Statusbar
//STRIP001 /*?*/ 		rBindings.Invalidate( SID_STATUS_PAGESTYLE );	// Statusbar
//STRIP001 /*?*/ 		rBindings.Invalidate( SID_CURRENTTAB );			// Navigator
//STRIP001 /*?*/ 		rBindings.Invalidate( SID_STYLE_FAMILY2 );	// Gestalter
//STRIP001 /*?*/ 		rBindings.Invalidate( SID_STYLE_FAMILY4 );	// Gestalter
//STRIP001 /*?*/ 		rBindings.Invalidate( SID_TABLES_COUNT );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		ScModule* pScMod = SC_MOD();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if(pScMod->IsRefDialogOpen())
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			USHORT nCurRefDlgId=pScMod->GetCurRefDlgId();
//STRIP001 /*?*/ 			SfxViewFrame* pViewFrm = aViewData.GetViewShell()->GetViewFrame();
//STRIP001 /*?*/ 			SfxChildWindow* pChildWnd = pViewFrm->GetChildWindow( nCurRefDlgId );
//STRIP001 /*?*/ 			if ( pChildWnd )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				ScAnyRefDlg* pRefDlg = (ScAnyRefDlg*)pChildWnd->GetWindow();
//STRIP001 /*?*/ 				pRefDlg->ViewShellChanged(NULL);
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
/*N*/ 	}
/*N*/ }

//
//	Paint-Funktionen - nur fuer diese View
//

//STRIP001 void ScTabView::MakeEditView( ScEditEngineDefaulter* pEngine, USHORT nCol, USHORT nRow )
//STRIP001 {
//STRIP001 	DrawDeselectAll();
//STRIP001 
//STRIP001 	if (pDrawView)
//STRIP001 		DrawEnableAnim( FALSE );
//STRIP001 
//STRIP001 	for (USHORT i=0; i<4; i++)
//STRIP001 		if (pGridWin[i])
//STRIP001 			if ( pGridWin[i]->IsVisible() && !aViewData.HasEditView((ScSplitPos)i) )
//STRIP001 			{
//STRIP001 				ScHSplitPos eHWhich = WhichH( (ScSplitPos) i );
//STRIP001 				ScVSplitPos eVWhich = WhichV( (ScSplitPos) i );
//STRIP001 				USHORT nScrX = aViewData.GetPosX( eHWhich );
//STRIP001 				USHORT nScrY = aViewData.GetPosY( eVWhich );
//STRIP001 
//STRIP001 				BOOL bPosVisible =
//STRIP001 					 ( nCol >= nScrX && nCol <= nScrX + aViewData.VisibleCellsX(eHWhich) + 1 &&
//STRIP001 					   nRow >= nScrY && nRow <= nScrY + aViewData.VisibleCellsY(eVWhich) + 1 );
//STRIP001 
//STRIP001 				//	#102421# for the active part, create edit view even if outside the visible area,
//STRIP001 				//	so input isn't lost (and the edit view may be scrolled into the visible area)
//STRIP001 
//STRIP001 				if ( bPosVisible || aViewData.GetActivePart() == (ScSplitPos) i )
//STRIP001 				{
//STRIP001 					pGridWin[i]->HideCursor();
//STRIP001 
//STRIP001 					// MapMode must be set after HideCursor
//STRIP001 
//STRIP001 					pGridWin[i]->SetMapMode(aViewData.GetLogicMode());
//STRIP001 
//STRIP001 					aViewData.SetEditEngine( (ScSplitPos) i, pEngine, pGridWin[i], nCol, nRow );
//STRIP001 
//STRIP001 					if ( !bPosVisible )
//STRIP001 					{
//STRIP001 						//	move the edit view area to the real (possibly negative) position,
//STRIP001 						//	or hide if completely above or left of the window
//STRIP001 						pGridWin[i]->UpdateEditViewPos();
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 	if (aViewData.GetViewShell()->HasAccessibilityObjects())
//STRIP001 		aViewData.GetViewShell()->BroadcastAccessibility(SfxSimpleHint(SC_HINT_ACC_ENTEREDITMODE));
//STRIP001 }

//STRIP001 void ScTabView::UpdateEditView()
//STRIP001 {
//STRIP001 	ScSplitPos eActive = aViewData.GetActivePart();
//STRIP001 	for (USHORT i=0; i<4; i++)
//STRIP001 		if (aViewData.HasEditView( (ScSplitPos) i ))
//STRIP001 		{
//STRIP001 			EditView* pEditView = aViewData.GetEditView( (ScSplitPos) i );
//STRIP001 			aViewData.SetEditEngine( (ScSplitPos) i,
//STRIP001 				static_cast<ScEditEngineDefaulter*>(pEditView->GetEditEngine()),
//STRIP001 				pGridWin[i], GetViewData()->GetCurX(), GetViewData()->GetCurY() );
//STRIP001 			if ( (ScSplitPos)i == eActive )
//STRIP001 				pEditView->ShowCursor( FALSE );
//STRIP001 		}
//STRIP001 }

/*N*/ void ScTabView::KillEditView( BOOL bNoPaint )
/*N*/ {
/*N*/ 	USHORT i;
/*N*/ 	USHORT nCol1 = aViewData.GetEditViewCol();
/*N*/ 	USHORT nRow1 = aViewData.GetEditViewRow();
/*N*/ 	USHORT nCol2 = aViewData.GetEditEndCol();
/*N*/ 	USHORT nRow2 = aViewData.GetEditEndRow();
/*N*/ 	BOOL bPaint[4];
/*N*/     BOOL bNotifyAcc(false);
/*N*/ 
/*N*/ 	BOOL bExtended = nRow1 != nRow2;					// Col wird sowieso bis zum Ende gezeichnet
/*N*/ 	BOOL bAtCursor = nCol1 == aViewData.GetCurX() &&
/*N*/ 					 nRow1 == aViewData.GetCurY();
/*N*/ 	for (i=0; i<4; i++)
/*N*/     {
/*N*/ 		bPaint[i] = aViewData.HasEditView( (ScSplitPos) i );
/*N*/         if (bPaint[i])
/*N*/             bNotifyAcc = true;
/*N*/     }
/*N*/ 
/*N*/     // #108931#; notify accessibility before all things happen
/*N*/     if ((bNotifyAcc) && (aViewData.GetViewShell()->HasAccessibilityObjects()))
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 aViewData.GetViewShell()->BroadcastAccessibility(SfxSimpleHint(SC_HINT_ACC_LEAVEEDITMODE));
/*N*/ 
/*N*/ 	aViewData.ResetEditView();
/*N*/ 	for (i=0; i<4; i++)
/*N*/ 		if (pGridWin[i] && bPaint[i])
/*?*/ 			if (pGridWin[i]->IsVisible())
/*?*/ 			{
/*?*/ 				pGridWin[i]->ShowCursor();
/*?*/ 
/*?*/ 				if (bExtended || ( bAtCursor && !bNoPaint ))
/*?*/ 					pGridWin[i]->Draw( nCol1, nRow1, nCol2, nRow2 );
/*?*/ 				else
/*?*/ 					pGridWin[i]->SetMapMode(pGridWin[i]->GetDrawMapMode());
/*?*/ 			}
/*N*/ 
/*N*/ 	if (pDrawView)
/*N*/ 		DrawEnableAnim( TRUE );
/*N*/ 
/*N*/ 		//	GrabFocus immer dann, wenn diese View aktiv ist und
/*N*/ 		//	die Eingabezeile den Focus hat
/*N*/ 
/*N*/ 	BOOL bGrabFocus = FALSE;
/*N*/ 	if (aViewData.IsActive())
/*N*/ 	{
/*N*/ 		ScInputHandler*	pInputHdl = SC_MOD()->GetInputHdl();
/*N*/ 		if ( pInputHdl )
/*N*/ 		{
/*?*/ 			ScInputWindow* pInputWin = pInputHdl->GetInputWindow();
/*?*/ 			if (pInputWin && pInputWin->IsActive())
/*?*/ 				bGrabFocus = TRUE;
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bGrabFocus)
/*N*/ 	{
/*?*/ //		So soll es gemacht werden, damit der Sfx es mitbekommt, klappt aber nicht:
/*?*/ //!		aViewData.GetViewShell()->GetViewFrame()->GetWindow().GrabFocus();
/*?*/ //		deshalb erstmal so:
/*?*/ 		GetActiveWin()->GrabFocus();
/*N*/ 	}
/*N*/ 
/*N*/ 	//	Cursor-Abfrage erst nach GrabFocus
/*N*/ 
/*N*/ 	for (i=0; i<4; i++)
/*N*/ 		if (pGridWin[i] && pGridWin[i]->IsVisible())
/*N*/ 		{
/*N*/ 			Cursor* pCur = pGridWin[i]->GetCursor();
/*N*/ 			if (pCur && pCur->IsVisible())
/*?*/ 				pCur->Hide();
/*N*/ 		}
/*N*/ }

/*N*/ void ScTabView::UpdateFormulas()
/*N*/ {
/*N*/ 	if ( aViewData.GetDocument()->IsAutoCalcShellDisabled() )
/*N*/ 		return ;
/*N*/ 
/*N*/ 	USHORT i;
/*N*/ 	for (i=0; i<4; i++)
/*N*/ 		if (pGridWin[i])
/*N*/ 			if (pGridWin[i]->IsVisible())
/*N*/ 				pGridWin[i]->UpdateFormulas();
/*N*/ 
/*N*/ 	if ( aViewData.IsPagebreakMode() )
				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		UpdatePageBreakData();				//! asynchron
/*N*/ 
/*N*/ 	UpdateHeaderWidth();
/*N*/ 
/*N*/ 	//	if in edit mode, adjust edit view area because widths/heights may have changed
/*N*/ 	if ( aViewData.HasEditView( aViewData.GetActivePart() ) )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 UpdateEditView();
/*N*/ }

//	PaintCell - einzelne Zelle neu zeichnen

//STRIP001 void ScTabView::PaintCell( USHORT nCol, USHORT nRow, USHORT nTab )
//STRIP001 {
//STRIP001 	if ( aViewData.GetTabNo() == nTab )
//STRIP001 	{
//STRIP001 		USHORT i;
//STRIP001 		for (i=0; i<4; i++)
//STRIP001 			if (pGridWin[i])
//STRIP001 				if (pGridWin[i]->IsVisible())
//STRIP001 					pGridWin[i]->Draw( nCol, nRow, nCol, nRow );
//STRIP001 	}
//STRIP001 }

//	PaintArea -Block neu zeichnen

/*N*/ void ScTabView::PaintArea( USHORT nStartCol, USHORT nStartRow, USHORT nEndCol, USHORT nEndRow,
/*N*/ 							ScUpdateMode eMode )
/*N*/ {
/*N*/ 	USHORT i;
/*N*/ 	USHORT nCol1;
/*N*/ 	USHORT nRow1;
/*N*/ 	USHORT nCol2;
/*N*/ 	USHORT nRow2;
/*N*/ 
/*N*/ 	PutInOrder( nStartCol, nEndCol );
/*N*/ 	PutInOrder( nStartRow, nEndRow );
/*N*/ 
/*N*/ 	for (i=0; i<4; i++)
/*N*/ 		if (pGridWin[i])
/*N*/ 			if (pGridWin[i]->IsVisible())
/*N*/ 			{
/*N*/ 				ScHSplitPos eHWhich = WhichH( (ScSplitPos) i );
/*N*/ 				ScVSplitPos eVWhich = WhichV( (ScSplitPos) i );
/*N*/ 				BOOL bOut = FALSE;
/*N*/ 
/*N*/ 				nCol1 = nStartCol;
/*N*/ 				nRow1 = nStartRow;
/*N*/ 				nCol2 = nEndCol;
/*N*/ 				nRow2 = nEndRow;
/*N*/ 
/*N*/ 				USHORT nScrX = aViewData.GetPosX( eHWhich );
/*N*/ 				USHORT nScrY = aViewData.GetPosY( eVWhich );
/*N*/ 				if (nCol1 < nScrX) nCol1 = nScrX;
/*N*/ 				if (nCol2 < nScrX)
/*N*/ 				{
/*N*/ 					if ( eMode == SC_UPDATE_ALL )	// #91240# for UPDATE_ALL, paint anyway
/*N*/ 						nCol2 = nScrX;				// (because of extending strings to the right)
/*N*/ 					else
/*N*/ 						bOut = TRUE;				// completely outside the window
/*N*/ 				}
/*N*/ 				if (nRow1 < nScrY) nRow1 = nScrY;
/*N*/ 				if (nRow2 < nScrY) bOut = TRUE;
/*N*/ 
/*N*/ 				USHORT nLastX = nScrX + aViewData.VisibleCellsX( eHWhich ) + 1;
/*N*/ 				USHORT nLastY = nScrY + aViewData.VisibleCellsY( eVWhich ) + 1;
/*N*/ 				if (nCol1 > nLastX) bOut = TRUE;
/*N*/ 				if (nCol2 > nLastX) nCol2 = nLastX;
/*N*/ 				if (nRow1 > nLastY) bOut = TRUE;
/*N*/ 				if (nRow2 > nLastY) nRow2 = nLastY;
/*N*/ 
/*N*/ 				if (!bOut)
/*N*/ 				{
/*N*/ 					if ( eMode == SC_UPDATE_CHANGED )
/*?*/ 						pGridWin[i]->Draw( nCol1, nRow1, nCol2, nRow2, eMode );
/*N*/ 					else	// ALL oder MARKS
/*N*/ 					{
/*N*/ 						Point aStart = aViewData.GetScrPos( nCol1, nRow1, (ScSplitPos) i );
/*N*/ 						Point aEnd   = aViewData.GetScrPos( nCol2+1, nRow2+1, (ScSplitPos) i );
/*N*/ 						if ( eMode == SC_UPDATE_ALL )
/*N*/ 							aEnd.X() = pGridWin[i]->GetOutputSizePixel().Width();
/*N*/ 						aEnd.X() -= 1;
/*N*/ 						aEnd.Y() -= 1;
/*N*/ 
/*N*/ 						BOOL bShowChanges = TRUE;			//! ...
/*N*/ 						if (bShowChanges)
/*N*/ 						{
/*N*/ 							aStart.X() -= 1;	// auch Change-Markierung
/*N*/ 							aStart.Y() -= 1;
/*N*/ 						}
/*N*/ 
/*N*/ 						BOOL bMarkClipped = aViewData.GetOptions().GetOption( VOPT_CLIPMARKS );
/*N*/ 						if (bMarkClipped)
/*N*/ 						{
/*N*/ 							//	dazu muesste ScColumn::IsEmptyBlock optimiert werden
/*N*/ 							//	(auf Search() umstellen)
/*N*/ 							//!if ( nCol1 > 0 && !aViewData.GetDocument()->IsBlockEmpty(
/*N*/ 							//!						aViewData.GetTabNo(),
/*N*/ 							//!						0, nRow1, nCol1-1, nRow2 ) )
/*N*/ 							{
/*N*/ 								long nMarkPixel = (long)( SC_CLIPMARK_SIZE * aViewData.GetPPTX() );
/*N*/ 								aStart.X() -= nMarkPixel;
/*N*/ 								if (!bShowChanges)
/*N*/ 									aStart.X() -= 1;		// Zellgitter
/*N*/ 							}
/*N*/ 						}
/*N*/ 
/*N*/ 						pGridWin[i]->Invalidate( pGridWin[i]->PixelToLogic( Rectangle( aStart,aEnd ) ) );
/*N*/ 					}
/*N*/ 				}
/*N*/ 			}
/*N*/ }

//STRIP001 void ScTabView::PaintRangeFinder( long nNumber )
//STRIP001 {
//STRIP001 	ScInputHandler* pHdl = SC_MOD()->GetInputHdl( aViewData.GetViewShell() );
//STRIP001 	if (pHdl)
//STRIP001 	{
//STRIP001 		ScRangeFindList* pRangeFinder = pHdl->GetRangeFindList();
//STRIP001 		if ( pRangeFinder && pRangeFinder->GetDocName() == aViewData.GetDocShell()->GetTitle() )
//STRIP001 		{
//STRIP001 			BOOL bHide = pRangeFinder->IsHidden();
//STRIP001 
//STRIP001 			USHORT nTab = aViewData.GetTabNo();
//STRIP001 			USHORT nCount = (USHORT)pRangeFinder->Count();
//STRIP001 			for (USHORT i=0; i<nCount; i++)
//STRIP001 				if ( nNumber < 0 || nNumber == i )
//STRIP001 				{
//STRIP001 					ScRangeFindData* pData = pRangeFinder->GetObject(i);
//STRIP001 					if (pData)
//STRIP001 					{
//STRIP001 						ScRange aRef = pData->aRef;
//STRIP001 						aRef.Justify();					// Justify fuer die Abfragen unten
//STRIP001 
//STRIP001 						if ( aRef.aStart == aRef.aEnd )		//! Tab ignorieren?
//STRIP001 							aViewData.GetDocument()->ExtendMerge(aRef);
//STRIP001 
//STRIP001 						if ( aRef.aStart.Tab() >= nTab && aRef.aEnd.Tab() <= nTab )
//STRIP001 						{
//STRIP001 							USHORT nCol1 = aRef.aStart.Col();
//STRIP001 							USHORT nRow1 = aRef.aStart.Row();
//STRIP001 							USHORT nCol2 = aRef.aEnd.Col();
//STRIP001 							USHORT nRow2 = aRef.aEnd.Row();
//STRIP001 							if ( bHide )
//STRIP001 							{
//STRIP001 								//	wegnehmen -> Repaint
//STRIP001 								//	SC_UPDATE_MARKS: Invalidate, nicht bis zum Zeilenende
//STRIP001 
//STRIP001 								BOOL bHiddenEdge = FALSE;
//STRIP001 								ScDocument* pDoc = aViewData.GetDocument();
//STRIP001 								while ( nCol1 > 0 && ( pDoc->GetColFlags( nCol1, nTab ) & CR_HIDDEN ) )
//STRIP001 								{
//STRIP001 									--nCol1;
//STRIP001 									bHiddenEdge = TRUE;
//STRIP001 								}
//STRIP001 								while ( nCol2 < MAXCOL && ( pDoc->GetColFlags( nCol2, nTab ) & CR_HIDDEN ) )
//STRIP001 								{
//STRIP001 									++nCol2;
//STRIP001 									bHiddenEdge = TRUE;
//STRIP001 								}
//STRIP001 								while ( nRow1 > 0 && ( pDoc->GetRowFlags( nRow1, nTab ) & CR_HIDDEN ) )
//STRIP001 								{
//STRIP001 									--nRow1;
//STRIP001 									bHiddenEdge = TRUE;
//STRIP001 								}
//STRIP001 								while ( nRow2 < MAXROW && ( pDoc->GetRowFlags( nRow2, nTab ) & CR_HIDDEN ) )
//STRIP001 								{
//STRIP001 									++nRow2;
//STRIP001 									bHiddenEdge = TRUE;
//STRIP001 								}
//STRIP001 
//STRIP001 								if ( nCol2 - nCol1 > 1 && nRow2 - nRow1 > 1 && !bHiddenEdge )
//STRIP001 								{
//STRIP001 									//	nur an den Raendern entlang
//STRIP001 									PaintArea( nCol1, nRow1, nCol2, nRow1, SC_UPDATE_MARKS );
//STRIP001 									PaintArea( nCol1, nRow1+1, nCol1, nRow2-1, SC_UPDATE_MARKS );
//STRIP001 									PaintArea( nCol2, nRow1+1, nCol2, nRow2-1, SC_UPDATE_MARKS );
//STRIP001 									PaintArea( nCol1, nRow2, nCol2, nRow2, SC_UPDATE_MARKS );
//STRIP001 								}
//STRIP001 								else	// alles am Stueck
//STRIP001 									PaintArea( nCol1, nRow1, nCol2, nRow2, SC_UPDATE_MARKS );
//STRIP001 							}
//STRIP001 							else
//STRIP001 							{
//STRIP001 								//	neuen Rahmen zeichnen
//STRIP001 
//STRIP001 								for (USHORT nWin=0; nWin<4; nWin++)
//STRIP001 									if (pGridWin[nWin] && pGridWin[nWin]->IsVisible())
//STRIP001 										pGridWin[nWin]->DrawRefMark( nCol1, nRow1, nCol2, nRow2,
//STRIP001 															Color( ScRangeFindList::GetColorName( i ) ),
//STRIP001 															TRUE );
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//	fuer Chart-Daten-Markierung

//STRIP001 void ScTabView::AddHighlightRange( const ScRange& rRange, const Color& rColor )
//STRIP001 {
//STRIP001 	if (!pHighlightRanges)
//STRIP001 		pHighlightRanges = new ScHighlightRanges;
//STRIP001 	pHighlightRanges->Insert( new ScHighlightEntry( rRange, rColor ) );
//STRIP001 	//!	auf doppelte testen??
//STRIP001 
//STRIP001 	USHORT nTab = aViewData.GetTabNo();
//STRIP001 	if ( nTab >= rRange.aStart.Tab() && nTab <= rRange.aEnd.Tab() )
//STRIP001 		PaintArea( rRange.aStart.Col(), rRange.aStart.Row(),
//STRIP001 					rRange.aEnd.Col(), rRange.aEnd.Row(), SC_UPDATE_MARKS );
//STRIP001 }

//STRIP001 void ScTabView::ClearHighlightRanges()
//STRIP001 {
//STRIP001 	if (pHighlightRanges)
//STRIP001 	{
//STRIP001 		ScHighlightRanges* pTemp = pHighlightRanges;
//STRIP001 		pHighlightRanges = NULL;	// Repaint ohne Highlight
//STRIP001 
//STRIP001 		USHORT nTab = aViewData.GetTabNo();
//STRIP001 		ULONG nCount = pTemp->Count();
//STRIP001 		for (ULONG i=0; i<nCount; i++)
//STRIP001 		{
//STRIP001 			ScHighlightEntry* pEntry = pTemp->GetObject( i );
//STRIP001 			if (pEntry)
//STRIP001 			{
//STRIP001 				ScRange aRange = pEntry->aRef;
//STRIP001 				if ( nTab >= aRange.aStart.Tab() && nTab <= aRange.aEnd.Tab() )
//STRIP001 					PaintArea( aRange.aStart.Col(), aRange.aStart.Row(),
//STRIP001 							   aRange.aEnd.Col(), aRange.aEnd.Row(), SC_UPDATE_MARKS );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		delete pTemp;
//STRIP001 	}
//STRIP001 }

//STRIP001 long ScTabView::DoChartSelection( ChartSelectionInfo &rInfo, const SchMemChart& rMemChart )
//STRIP001 {
//STRIP001 	long nFlags = rInfo.nSelection;
//STRIP001 	if ( nFlags & CHART_SEL_QUERYSUPPORT )
//STRIP001 		return nFlags & ( CHART_SEL_NONE | CHART_SEL_ALL   | CHART_SEL_COL |
//STRIP001 						  CHART_SEL_ROW  | CHART_SEL_POINT | CHART_SEL_COLOR );
//STRIP001 
//STRIP001 	long nRet = 0;
//STRIP001 	ScChartArray aArr( aViewData.GetDocument(), rMemChart );
//STRIP001 	if (aArr.IsValid())
//STRIP001 	{
//STRIP001 		if ( nFlags & CHART_SEL_NONE )
//STRIP001 		{
//STRIP001 			ClearHighlightRanges();
//STRIP001 			nRet |= CHART_SEL_NONE;
//STRIP001 		}
//STRIP001 
//STRIP001 		Color aSelColor( COL_LIGHTBLUE );	// Default
//STRIP001 		BOOL bManualColor = ( ( nFlags & CHART_SEL_COLOR ) != 0 );
//STRIP001 		bManualColor = FALSE;						//! Test !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//STRIP001 		if ( bManualColor )
//STRIP001 		{
//STRIP001 			aSelColor = rInfo.aSelectionColor;
//STRIP001 			nRet |= CHART_SEL_COLOR;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( nFlags & CHART_SEL_ALL )
//STRIP001 		{
//STRIP001 			ScRangeListRef xRanges = aArr.GetRangeList();
//STRIP001 			if (xRanges.Is())
//STRIP001 			{
//STRIP001 				USHORT nCount = xRanges->Count();
//STRIP001 				USHORT i;
//STRIP001 				if (!bManualColor)
//STRIP001 				{
//STRIP001 					ScBackgroundCollector aColl( aViewData.GetDocument() );
//STRIP001 					for (i=0; i<nCount; i++)
//STRIP001 						aColl.AddRange( *xRanges->GetObject(i) );
//STRIP001 					aSelColor = aColl.GetHighlightColor();
//STRIP001 				}
//STRIP001 				for (i=0; i<nCount; i++)
//STRIP001 					AddHighlightRange( *xRanges->GetObject(i), aSelColor );
//STRIP001 				nRet |= CHART_SEL_ALL;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( nFlags & ( CHART_SEL_COL | CHART_SEL_ROW | CHART_SEL_POINT ) )
//STRIP001 		{
//STRIP001 			//	irgendwelche Teile selektieren -> PositionMap holen
//STRIP001 			const ScChartPositionMap* pPosMap = aArr.GetPositionMap();
//STRIP001 			if (pPosMap)
//STRIP001 			{
//STRIP001 				if ( nFlags & CHART_SEL_COL )
//STRIP001 				{
//STRIP001 					ScRangeListRef xRanges = ((ScChartPositionMap*)pPosMap)->GetColRanges( rInfo.nCol );
//STRIP001 					if (xRanges.Is())
//STRIP001 					{
//STRIP001 						USHORT nCount = xRanges->Count();
//STRIP001 						USHORT i;
//STRIP001 						if (!bManualColor)
//STRIP001 						{
//STRIP001 							ScBackgroundCollector aColl( aViewData.GetDocument() );
//STRIP001 							for (i=0; i<nCount; i++)
//STRIP001 								aColl.AddRange( *xRanges->GetObject(i) );
//STRIP001 							aSelColor = aColl.GetHighlightColor();
//STRIP001 						}
//STRIP001 						for (i=0; i<nCount; i++)
//STRIP001 							AddHighlightRange( *xRanges->GetObject(i), aSelColor );
//STRIP001 						nRet |= CHART_SEL_COL;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				if ( nFlags & CHART_SEL_ROW )
//STRIP001 				{
//STRIP001 					ScRangeListRef xRanges = ((ScChartPositionMap*)pPosMap)->GetRowRanges( rInfo.nRow );
//STRIP001 					if (xRanges.Is())
//STRIP001 					{
//STRIP001 						USHORT nCount = xRanges->Count();
//STRIP001 						USHORT i;
//STRIP001 						if (!bManualColor)
//STRIP001 						{
//STRIP001 							ScBackgroundCollector aColl( aViewData.GetDocument() );
//STRIP001 							for (i=0; i<nCount; i++)
//STRIP001 								aColl.AddRange( *xRanges->GetObject(i) );
//STRIP001 							aSelColor = aColl.GetHighlightColor();
//STRIP001 						}
//STRIP001 						for (i=0; i<nCount; i++)
//STRIP001 							AddHighlightRange( *xRanges->GetObject(i), aSelColor );
//STRIP001 						nRet |= CHART_SEL_ROW;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				if ( nFlags & CHART_SEL_POINT )
//STRIP001 				{
//STRIP001 					const ScAddress* pPos = pPosMap->GetPosition( rInfo.nCol, rInfo.nRow );
//STRIP001 					if (pPos)
//STRIP001 					{
//STRIP001 						if (!bManualColor)
//STRIP001 						{
//STRIP001 							ScBackgroundCollector aColl( aViewData.GetDocument() );
//STRIP001 							aColl.AddRange( ScRange(*pPos) );
//STRIP001 							aSelColor = aColl.GetHighlightColor();
//STRIP001 						}
//STRIP001 						AddHighlightRange( ScRange(*pPos), aSelColor );
//STRIP001 						nRet |= CHART_SEL_POINT;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

//	DrawDragRect - Drag&Drop-Rechteck zeichnen (XOR)

//STRIP001 void ScTabView::DrawDragRect( USHORT nStartX, USHORT nStartY, USHORT nEndX, USHORT nEndY,
//STRIP001 								ScSplitPos ePos )
//STRIP001 {
//STRIP001 	if ( aViewData.GetHSplitMode() == SC_SPLIT_FIX || aViewData.GetVSplitMode() == SC_SPLIT_FIX )
//STRIP001 	{
//STRIP001 		for (USHORT  i=0; i<4; i++)
//STRIP001 			if (pGridWin[i])
//STRIP001 				if (pGridWin[i]->IsVisible())
//STRIP001 					pGridWin[i]->DrawDragRect( nStartX, nStartY, nEndX, nEndY );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pGridWin[ePos]->DrawDragRect( nStartX, nStartY, nEndX, nEndY );
//STRIP001 }

//	PaintGrid - Datenbereiche neu zeichnen

/*N*/ void ScTabView::PaintGrid()
/*N*/ {
/*N*/ 	USHORT i;
/*N*/ 	for (i=0; i<4; i++)
/*N*/ 		if (pGridWin[i])
/*N*/ 			if (pGridWin[i]->IsVisible())
/*N*/ 				pGridWin[i]->Invalidate();
/*N*/ }

//	PaintTop - obere Kontrollelemente neu zeichnen

/*N*/ void ScTabView::PaintTop()
/*N*/ {
/*N*/ 	USHORT i;
/*N*/ 	for (i=0; i<2; i++)
/*N*/ 	{
/*N*/ 		if (pColBar[i])
/*N*/ 			pColBar[i]->Invalidate();
/*N*/ 		if (pColOutline[i])
/*N*/ 			pColOutline[i]->Invalidate();
/*N*/ 	}
/*N*/ }

//STRIP001 void ScTabView::CreateAnchorHandles(SdrHdlList& rHdl, const ScAddress& rAddress)
//STRIP001 {
//STRIP001 	UINT16 i;
//STRIP001 
//STRIP001 	for(i=0; i<4; i++)
//STRIP001 	{
//STRIP001 		if(pGridWin[i])
//STRIP001 		{
//STRIP001 			if(pGridWin[i]->IsVisible())
//STRIP001 			{
//STRIP001 				pGridWin[i]->CreateAnchorHandle(rHdl, rAddress);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*N*/ void ScTabView::PaintTopCol( USHORT nCol )
/*N*/ {
/*N*/ 	PaintTopArea( nCol, nCol );
/*N*/ }

/*N*/ void ScTabView::PaintTopArea( USHORT nStartCol, USHORT nEndCol )
/*N*/ {
/*N*/ 		//	Pixel-Position der linken Kante
/*N*/ 
/*N*/ 	if ( nStartCol < aViewData.GetPosX(SC_SPLIT_LEFT) ||
/*N*/ 		 nStartCol < aViewData.GetPosX(SC_SPLIT_RIGHT) )
/*?*/ 		aViewData.RecalcPixPos();
/*N*/ 
/*N*/ 		//	Fixierung anpassen (UpdateFixX setzt HSplitPos neu)
/*N*/ 
/*N*/ 	if ( aViewData.GetHSplitMode() == SC_SPLIT_FIX && nStartCol < aViewData.GetFixPosX() )
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		if (aViewData.UpdateFixX())
//STRIP001 /*?*/ 			RepeatResize();
/*N*/ 
/*N*/ 		//	zeichnen
/*N*/ 
/*N*/ 	if (nStartCol>0)
/*N*/ 		--nStartCol;				//! allgemeiner ?
/*N*/ 
/*N*/ 	for (USHORT i=0; i<2; i++)
/*N*/ 	{
/*N*/ 		ScHSplitPos eWhich = (ScHSplitPos) i;
/*N*/ 		if (pColBar[eWhich])
/*N*/ 		{
/*N*/ 			Size aWinSize = pColBar[eWhich]->GetSizePixel();
/*N*/ 			long nStartX = aViewData.GetScrPos( nStartCol, 0, eWhich ).X();
/*N*/ 			long nEndX;
/*N*/ 			if (nEndCol >= MAXCOL)
/*N*/ 				nEndX = aWinSize.Width()-1;
/*N*/ 			else
/*?*/ 				nEndX = aViewData.GetScrPos( nEndCol+1, 0, eWhich ).X() - 1;
/*N*/ 			pColBar[eWhich]->Invalidate(
/*N*/ 					Rectangle( nStartX, 0, nEndX, aWinSize.Height()-1 ) );
/*N*/ 		}
/*N*/ 		if (pColOutline[eWhich])
/*?*/ 			pColOutline[eWhich]->Invalidate();
/*N*/ 	}
/*N*/ }


//	PaintLeft - linke Kontrollelemente neu zeichnen

/*N*/ void ScTabView::PaintLeft()
/*N*/ {
/*N*/ 	USHORT i;
/*N*/ 	for (i=0; i<2; i++)
/*N*/ 	{
/*N*/ 		if (pRowBar[i])
/*N*/ 			pRowBar[i]->Invalidate();
/*N*/ 		if (pRowOutline[i])
/*N*/ 			pRowOutline[i]->Invalidate();
/*N*/ 	}
/*N*/ }

//STRIP001 void ScTabView::PaintLeftRow( USHORT nRow )
//STRIP001 {
//STRIP001 	PaintLeftArea( nRow, nRow );
//STRIP001 }

/*N*/ void ScTabView::PaintLeftArea( USHORT nStartRow, USHORT nEndRow )
/*N*/ {
/*N*/ 		//	Pixel-Position der oberen Kante
/*N*/ 
/*N*/ 	if ( nStartRow < aViewData.GetPosY(SC_SPLIT_TOP) ||
/*N*/ 		 nStartRow < aViewData.GetPosY(SC_SPLIT_BOTTOM) )
/*?*/ 		aViewData.RecalcPixPos();
/*N*/ 
/*N*/ 		//	Fixierung anpassen (UpdateFixY setzt VSplitPos neu)
/*N*/ 
/*N*/ 	if ( aViewData.GetVSplitMode() == SC_SPLIT_FIX && nStartRow < aViewData.GetFixPosY() )
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		if (aViewData.UpdateFixY())
//STRIP001 /*?*/ 			RepeatResize();
/*N*/ 
/*N*/ 		//	zeichnen
/*N*/ 
/*N*/ 	if (nStartRow>0)
/*N*/ 		--nStartRow;
/*N*/ 
/*N*/ 	for (USHORT i=0; i<2; i++)
/*N*/ 	{
/*N*/ 		ScVSplitPos eWhich = (ScVSplitPos) i;
/*N*/ 		if (pRowBar[eWhich])
/*N*/ 		{
/*N*/ 			Size aWinSize = pRowBar[eWhich]->GetSizePixel();
/*N*/ 			long nStartY = aViewData.GetScrPos( 0, nStartRow, eWhich ).Y();
/*N*/ 			long nEndY;
/*N*/ 			if (nEndRow >= MAXROW)
/*?*/ 				nEndY = aWinSize.Height()-1;
/*?*/ 			else
/*?*/ 				nEndY = aViewData.GetScrPos( 0, nEndRow+1, eWhich ).Y() - 1;
/*?*/ 			pRowBar[eWhich]->Invalidate(
/*?*/ 					Rectangle( 0, nStartY, aWinSize.Width()-1, nEndY ) );
/*N*/ 		}
/*N*/ 		if (pRowOutline[eWhich])
/*?*/ 			pRowOutline[eWhich]->Invalidate();
/*N*/ 	}
/*N*/ }

//	InvertBlockMark - Block invertieren

//STRIP001 void ScTabView::InvertBlockMark(USHORT nBlockStartX, USHORT nBlockStartY,
//STRIP001 								USHORT nBlockEndX, USHORT nBlockEndY)
//STRIP001 {
//STRIP001 	if ( !aViewData.IsActive() )
//STRIP001 		return;									// invertiert wird nur auf aktiver View
//STRIP001 
//STRIP001 	PutInOrder( nBlockStartX, nBlockEndX );
//STRIP001 	PutInOrder( nBlockStartY, nBlockEndY );
//STRIP001 
//STRIP001 	ScMarkData& rMark = aViewData.GetMarkData();
//STRIP001 	ScDocShell* pDocSh = aViewData.GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	USHORT nTab = aViewData.GetTabNo();
//STRIP001 
//STRIP001 	if ( pDocSh->GetLockCount() )
//STRIP001 	{
//STRIP001 		//	if paint is locked, avoid repeated inverting
//STRIP001 		//	add repaint areas to paint lock data instead
//STRIP001 		pDocSh->PostPaint( nBlockStartX,nBlockStartY,nTab, nBlockEndX,nBlockEndY,nTab, PAINT_GRID );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 #ifdef MAC
//STRIP001 	BOOL bSingle = TRUE;
//STRIP001 #else
//STRIP001 	BOOL bSingle = rMark.IsMultiMarked();
//STRIP001 #endif
//STRIP001 
//STRIP001 	BOOL bMerge = pDoc->HasAttrib( nBlockStartX, nBlockStartY, nTab, nBlockEndX, nBlockEndY, nTab,
//STRIP001 									HASATTR_MERGED | HASATTR_OVERLAPPED );
//STRIP001 
//STRIP001 	USHORT i;
//STRIP001 	if ( bMerge || bSingle )
//STRIP001 	{
//STRIP001 		for (i=0; i<4; i++)
//STRIP001 			if (pGridWin[i])
//STRIP001 				if (pGridWin[i]->IsVisible())
//STRIP001 					pGridWin[i]->InvertSimple( nBlockStartX, nBlockStartY, nBlockEndX, nBlockEndY,
//STRIP001 												bMerge, bBlockNeg );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		for (i=0; i<4; i++)
//STRIP001 			if (pGridWin[i])
//STRIP001 				if (pGridWin[i]->IsVisible())
//STRIP001 				{
//STRIP001 					ScSplitPos ePos = (ScSplitPos) i;
//STRIP001 					Point aStartPoint = aViewData.GetScrPos( nBlockStartX, nBlockStartY, ePos );
//STRIP001 					Point aEndPoint = aViewData.GetScrPos( nBlockEndX+1, nBlockEndY+1, ePos );
//STRIP001 					aEndPoint.X() -= 1;
//STRIP001 					aEndPoint.Y() -= 1;
//STRIP001 					if ( aEndPoint.X() >= aStartPoint.X() && aEndPoint.Y() >= aStartPoint.Y() )
//STRIP001 					{
//STRIP001 						MapMode aOld = pGridWin[ePos]->GetMapMode();
//STRIP001 						pGridWin[ePos]->SetMapMode(MAP_PIXEL);
//STRIP001 						pGridWin[ePos]->Invert( Rectangle(aStartPoint,aEndPoint), INVERT_HIGHLIGHT );
//STRIP001 						pGridWin[ePos]->SetMapMode(aOld);
//STRIP001 						pGridWin[ePos]->CheckInverted();
//STRIP001 					}
//STRIP001 				}
//STRIP001 	}
//STRIP001 
//STRIP001 		//
//STRIP001 		//	wenn Controls betroffen, neu malen
//STRIP001 		//
//STRIP001 
//STRIP001 	BOOL bHide = TRUE;					// wird Teil der Markierung aufgehoben ?
//STRIP001 	if (rMark.IsMarked())
//STRIP001 	{
//STRIP001 		ScRange aMarkRange;
//STRIP001 		rMark.GetMarkArea( aMarkRange );
//STRIP001 		if ( aMarkRange.aStart.Col() <= nBlockStartX && aMarkRange.aEnd.Col() >= nBlockEndX &&
//STRIP001 			 aMarkRange.aStart.Row() <= nBlockStartY && aMarkRange.aEnd.Row() >= nBlockEndY )
//STRIP001 		{
//STRIP001 			bHide = FALSE;				// der ganze Bereich ist markiert
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	Rectangle aMMRect = pDoc->GetMMRect(nBlockStartX,nBlockStartY,nBlockEndX,nBlockEndY, nTab);
//STRIP001 	BOOL bPaint = bHide && pDoc->HasControl( nTab, aMMRect );
//STRIP001 
//STRIP001 	if (bPaint)
//STRIP001 	{
//STRIP001 		for (i=0; i<4; i++)
//STRIP001 			if (pGridWin[i])
//STRIP001 				if (pGridWin[i]->IsVisible())
//STRIP001 				{
//STRIP001 					//	MapMode muss logischer (1/100mm) sein !!!
//STRIP001 					pDoc->InvalidateControls( pGridWin[i], nTab, aMMRect );
//STRIP001 					pGridWin[i]->Update();
//STRIP001 				}
//STRIP001 	}
//STRIP001 }

/*N*/ BOOL ScTabView::PaintExtras()
/*N*/ {
/*N*/ 	BOOL bRet = FALSE;
/*N*/ 	ScDocument* pDoc = aViewData.GetDocument();
/*N*/ 	USHORT nTab = aViewData.GetTabNo();
/*N*/ 	if (!pDoc->HasTable(nTab))					// Tabelle geloescht ?
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 USHORT nCount = pDoc->GetTableCount();
//STRIP001 /*?*/ 		aViewData.SetTabNo(nCount-1);
//STRIP001 /*?*/ 		bRet = TRUE;
/*N*/ 	}
/*N*/ 	pTabControl->UpdateStatus();						// TRUE = active
/*N*/ 	return bRet;
/*N*/ }

//STRIP001 void ScTabView::RecalcPPT()
//STRIP001 {
//STRIP001 	//	called after changes that require the PPT values to be recalculated
//STRIP001 	//	(currently from detective operations)
//STRIP001 
//STRIP001 	double nOldX = aViewData.GetPPTX();
//STRIP001 	double nOldY = aViewData.GetPPTY();
//STRIP001 
//STRIP001 	Fraction aZoomX = aViewData.GetZoomX();
//STRIP001 	Fraction aZoomY = aViewData.GetZoomY();
//STRIP001 	aViewData.SetZoom( aZoomX, aZoomY );			// pre-calculate new PPT values
//STRIP001 
//STRIP001 	BOOL bChangedX = ( aViewData.GetPPTX() != nOldX );
//STRIP001 	BOOL bChangedY = ( aViewData.GetPPTY() != nOldY );
//STRIP001 	if ( bChangedX || bChangedY )
//STRIP001 	{
//STRIP001 		//	call view SetZoom (including draw scale, split update etc)
//STRIP001 		//	and paint only if values changed
//STRIP001 
//STRIP001 		SetZoom( aZoomX, aZoomY );
//STRIP001 
//STRIP001 		PaintGrid();
//STRIP001 		if (bChangedX)
//STRIP001 			PaintTop();
//STRIP001 		if (bChangedY)
//STRIP001 			PaintLeft();
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScTabView::ActivateView( BOOL bActivate, BOOL bFirst )
//STRIP001 {
//STRIP001 	if ( bActivate == aViewData.IsActive() && !bFirst )
//STRIP001 	{
//STRIP001 		//	keine Assertion mehr - kommt vor, wenn vorher im Drag&Drop
//STRIP001 		//	auf ein anderes Dokument umgeschaltet wurde
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	// wird nur bei MDI-(De)Activate gerufen
//STRIP001 	// aViewData.Activate hinten wegen Cursor-Show bei KillEditView
//STRIP001 	//	Markierung nicht mehr loeschen - wenn an der ViewData Activate(FALSE) gesetzt ist,
//STRIP001 	//	wird die Markierung nicht ausgegeben
//STRIP001 
//STRIP001 	if (!bActivate)
//STRIP001 	{
//STRIP001 		ScModule* pScMod = SC_MOD();
//STRIP001 		BOOL bRefMode = pScMod->IsFormulaMode();
//STRIP001 
//STRIP001 			//	Referenzeingabe nicht abbrechen, um Referenzen auf
//STRIP001 			//	andere Dokumente zuzulassen
//STRIP001 
//STRIP001 		if (!bRefMode)
//STRIP001 		{
//STRIP001 			//pScMod->InputEnterHandler();
//STRIP001 
//STRIP001 			//	#80843# pass view to GetInputHdl, this view may not be current anymore
//STRIP001 			ScInputHandler* pHdl = SC_MOD()->GetInputHdl(aViewData.GetViewShell());
//STRIP001 			if (pHdl)
//STRIP001 				pHdl->EnterHandler();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	pTabControl->ActivateView(bActivate);
//STRIP001 	PaintExtras();
//STRIP001 
//STRIP001 	aViewData.Activate(bActivate);
//STRIP001 
//STRIP001 	PaintBlock(FALSE);					// Repaint, Markierung je nach Active-Status
//STRIP001 
//STRIP001 	if (!bActivate)
//STRIP001 		HideAllCursors();				// Cursor
//STRIP001 	else if (!bFirst)
//STRIP001 		ShowAllCursors();
//STRIP001 
//STRIP001 	if (pDrawView)
//STRIP001 		DrawShowMarkHdl(bActivate);		// Drawing-Markierung
//STRIP001 
//STRIP001 	if (bActivate)
//STRIP001 	{
//STRIP001 		if ( bFirst )
//STRIP001 		{
//STRIP001 			ScSplitPos eWin = aViewData.GetActivePart();
//STRIP001 			DBG_ASSERT( pGridWin[eWin], "rottes Dokument, nicht alle SplitPos in GridWin" );
//STRIP001 			if ( !pGridWin[eWin] )
//STRIP001 			{
//STRIP001 				eWin = SC_SPLIT_BOTTOMLEFT;
//STRIP001 				if ( !pGridWin[eWin] )
//STRIP001 				{
//STRIP001 					short i;
//STRIP001 					for ( i=0; i<4; i++ )
//STRIP001 					{
//STRIP001 						if ( pGridWin[i] )
//STRIP001 						{
//STRIP001 							eWin = (ScSplitPos) i;
//STRIP001 							break;	// for
//STRIP001 						}
//STRIP001 					}
//STRIP001 					DBG_ASSERT( i<4, "und BUMM" );
//STRIP001 				}
//STRIP001 				aViewData.SetActivePart( eWin );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		//	hier nicht mehr selber GrabFocus rufen!
//STRIP001 		//	Wenn das Doc bearbeitet wird, ruft der Sfx selber GrabFocus am Fenster der Shell.
//STRIP001 		//	Wenn es z.B. ein Mailbody ist, darf es den Focus nicht bekommen (Bug #43638#)
//STRIP001 
//STRIP001 		UpdateInputContext();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pGridWin[aViewData.GetActivePart()]->ClickExtern();
//STRIP001 }

//STRIP001 void ScTabView::ActivatePart( ScSplitPos eWhich )
//STRIP001 {
//STRIP001 	ScSplitPos eOld = aViewData.GetActivePart();
//STRIP001 	if ( eOld != eWhich )
//STRIP001 	{
//STRIP001 		bInActivatePart = TRUE;
//STRIP001 
//STRIP001 		BOOL bRefMode = SC_MOD()->IsFormulaMode();
//STRIP001 
//STRIP001 		//	#40565# the HasEditView call during SetCursor would fail otherwise
//STRIP001 		if ( aViewData.HasEditView(eOld) && !bRefMode )
//STRIP001 			UpdateInputLine();
//STRIP001 
//STRIP001 		ScHSplitPos eOldH = WhichH(eOld);
//STRIP001 		ScVSplitPos eOldV = WhichV(eOld);
//STRIP001 		ScHSplitPos eNewH = WhichH(eWhich);
//STRIP001 		ScVSplitPos eNewV = WhichV(eWhich);
//STRIP001 		BOOL bTopCap  = pColBar[eOldH] && pColBar[eOldH]->IsMouseCaptured();
//STRIP001 		BOOL bLeftCap = pRowBar[eOldV] && pRowBar[eOldV]->IsMouseCaptured();
//STRIP001 
//STRIP001 		BOOL bFocus = pGridWin[eOld]->HasFocus();
//STRIP001 		BOOL bCapture = pGridWin[eOld]->IsMouseCaptured();
//STRIP001 		if (bCapture)
//STRIP001 			pGridWin[eOld]->ReleaseMouse();
//STRIP001 		pGridWin[eOld]->ClickExtern();
//STRIP001 		pGridWin[eOld]->HideCursor();
//STRIP001 		pGridWin[eWhich]->HideCursor();
//STRIP001 		aViewData.SetActivePart( eWhich );
//STRIP001 
//STRIP001 		ScTabViewShell* pShell = aViewData.GetViewShell();
//STRIP001 		pShell->WindowChanged();
//STRIP001 
//STRIP001 		pSelEngine->SetWindow(pGridWin[eWhich]);
//STRIP001 		pSelEngine->SetWhich(eWhich);
//STRIP001 		pSelEngine->SetVisibleArea( Rectangle(Point(), pGridWin[eWhich]->GetOutputSizePixel()) );
//STRIP001 
//STRIP001 		pGridWin[eOld]->MoveMouseStatus(*pGridWin[eWhich]);
//STRIP001 
//STRIP001 		if ( bCapture || pGridWin[eWhich]->IsMouseCaptured() )
//STRIP001 		{
//STRIP001 			//	Tracking statt CaptureMouse, damit sauber abgebrochen werden kann
//STRIP001 			//	(SelectionEngine ruft CaptureMouse beim SetWindow)
//STRIP001 			//!	Irgendwann sollte die SelectionEngine selber StartTracking rufen!?!
//STRIP001 			pGridWin[eWhich]->ReleaseMouse();
//STRIP001 			pGridWin[eWhich]->StartTracking();
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bTopCap && pColBar[eNewH] )
//STRIP001 		{
//STRIP001 			pColBar[eOldH]->SetIgnoreMove(TRUE);
//STRIP001 			pColBar[eNewH]->SetIgnoreMove(FALSE);
//STRIP001 			pHdrSelEng->SetWindow( pColBar[eNewH] );
//STRIP001 			long nWidth = pColBar[eNewH]->GetOutputSizePixel().Width();
//STRIP001 			pHdrSelEng->SetVisibleArea( Rectangle( 0, LONG_MIN, nWidth-1, LONG_MAX ) );
//STRIP001 			pColBar[eNewH]->CaptureMouse();
//STRIP001 		}
//STRIP001 		if ( bLeftCap && pRowBar[eNewV] )
//STRIP001 		{
//STRIP001 			pRowBar[eOldV]->SetIgnoreMove(TRUE);
//STRIP001 			pRowBar[eNewV]->SetIgnoreMove(FALSE);
//STRIP001 			pHdrSelEng->SetWindow( pRowBar[eNewV] );
//STRIP001 			long nHeight = pRowBar[eNewV]->GetOutputSizePixel().Height();
//STRIP001 			pHdrSelEng->SetVisibleArea( Rectangle( LONG_MIN, 0, LONG_MAX, nHeight-1 ) );
//STRIP001 			pRowBar[eNewV]->CaptureMouse();
//STRIP001 		}
//STRIP001 		aHdrFunc.SetWhich(eWhich);
//STRIP001 
//STRIP001 		pGridWin[eOld]->ShowCursor();
//STRIP001 		pGridWin[eWhich]->ShowCursor();
//STRIP001 
//STRIP001 		//	#103823# don't switch ViewShell's active window during RefInput, because the focus
//STRIP001 		//	might change, and subsequent SetReference calls wouldn't find the right EditView
//STRIP001 		if ( !bRefMode )
//STRIP001 			aViewData.GetViewShell()->SetWindow( pGridWin[eWhich] );
//STRIP001 
//STRIP001 		if ( bFocus && !aViewData.IsAnyFillMode() && !bRefMode )
//STRIP001 		{
//STRIP001 			//	GrabFocus nur, wenn vorher das andere GridWindow den Focus hatte
//STRIP001 			//	(z.B. wegen Suchen & Ersetzen)
//STRIP001 //!			aViewData.GetViewShell()->GetViewFrame()->GetWindow().GrabFocus();
//STRIP001 			pGridWin[eWhich]->GrabFocus();
//STRIP001 		}
//STRIP001 
//STRIP001 		bInActivatePart = FALSE;
//STRIP001 	}
//STRIP001 }

/*N*/ void ScTabView::HideListBox()
/*N*/ {
/*N*/ 	for (USHORT i=0; i<4; i++)
/*N*/ 		if (pGridWin[i])
/*N*/ 			pGridWin[i]->ClickExtern();
/*N*/ }

//STRIP001 void ScTabView::UpdateInputContext()
//STRIP001 {
//STRIP001 	ScGridWindow* pWin = pGridWin[aViewData.GetActivePart()];
//STRIP001 	if (pWin)
//STRIP001 		pWin->UpdateInputContext();
//STRIP001 }

//	GetGridWidth - Breite eines Ausgabebereichs (fuer ViewData)

/*N*/ long ScTabView::GetGridWidth( ScHSplitPos eWhich )
/*N*/ {
/*N*/ 	ScSplitPos eGridWhich = ( eWhich == SC_SPLIT_LEFT ) ? SC_SPLIT_BOTTOMLEFT : SC_SPLIT_BOTTOMRIGHT;
/*N*/ 	if (pGridWin[eGridWhich])
/*N*/ 		return pGridWin[eGridWhich]->GetSizePixel().Width();
/*N*/ 	else
/*N*/ 		return 0;
/*N*/ }

//	GetGridHeight - Hoehe eines Ausgabebereichs (fuer ViewData)

/*N*/ long ScTabView::GetGridHeight( ScVSplitPos eWhich )
/*N*/ {
/*N*/ 	ScSplitPos eGridWhich = ( eWhich == SC_SPLIT_TOP ) ? SC_SPLIT_TOPLEFT : SC_SPLIT_BOTTOMLEFT;
/*N*/ 	if (pGridWin[eGridWhich])
/*N*/ 		return pGridWin[eGridWhich]->GetSizePixel().Height();
/*N*/ 	else
/*N*/ 		return 0;
/*N*/ }

/*N*/ void ScTabView::UpdateInputLine()
/*N*/ {
/*N*/ 	SC_MOD()->InputEnterHandler();
/*N*/ }

/*N*/ void ScTabView::ZoomChanged()
/*N*/ {
/*N*/ 	ScInputHandler* pHdl = SC_MOD()->GetInputHdl(aViewData.GetViewShell());
/*N*/ 	if (pHdl)
/*N*/ 		pHdl->SetRefScale( aViewData.GetZoomX(), aViewData.GetZoomY() );
/*N*/ 
/*N*/ 	UpdateFixPos();
/*N*/ 
/*N*/ 	UpdateScrollBars();
/*N*/ 
/*N*/ 	//	VisArea...
/*N*/ 	ScGridWindow* pWin = pGridWin[aViewData.GetActivePart()];
/*N*/ 	if (pWin)
/*N*/ 	{
/*N*/ 		pWin->SetMapMode( pWin->GetDrawMapMode() );	// mit neuem Zoom
/*N*/ 		SetNewVisArea();							// benutzt den gesetzten MapMode
/*N*/ 	}
/*N*/ 
/*N*/ 	InterpretVisible();		// #69343# have everything calculated before painting
/*N*/ 
/*N*/ 	SfxBindings& rBindings = aViewData.GetBindings();
/*N*/ 	rBindings.Invalidate( SID_ATTR_ZOOM );
/*N*/ 
/*N*/ 	HideNoteMarker();
/*N*/ 
/*N*/ 	if ( pWin && aViewData.HasEditView( aViewData.GetActivePart() ) )
/*N*/ 	{
/*?*/ 		//	#93650# make sure the EditView's position and size are updated
/*?*/ 		//	with the right (logic, not drawing) MapMode
/*?*/ 
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pWin->SetMapMode( aViewData.GetLogicMode() );
//STRIP001 /*?*/ 		UpdateEditView();
/*N*/ 	}
/*N*/ }

//STRIP001 void ScTabView::CheckNeedsRepaint()
//STRIP001 {
//STRIP001 	USHORT i;
//STRIP001 	for (i=0; i<4; i++)
//STRIP001 		if ( pGridWin[i] && pGridWin[i]->IsVisible() )
//STRIP001 			pGridWin[i]->CheckNeedsRepaint();
//STRIP001 }





}
