/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_tabvwsh4.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:37:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

// auto strip #include <bf_sfx2/topfrm.hxx>
#include "scitems.hxx"
// auto strip #include <bf_svx/eeitem.hxx>
#define ITEMID_FIELD EE_FEATURE_FIELD

// auto strip #include <bf_svx/boxitem.hxx>
#include <bf_svx/fmshell.hxx>
// auto strip #include <bf_svx/sizeitem.hxx>
#include <bf_svx/boxitem.hxx>
// auto strip #include <bf_svx/prtqry.hxx>
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #include <bf_sfx2/printer.hxx>
#include <bf_sfx2/dispatch.hxx>
// auto strip #include <svtools/printdlg.hxx>
// auto strip #include <svtools/whiter.hxx>
#include <svtools/moduleoptions.hxx>
#include <rtl/logfile.hxx>

// auto strip #ifndef _URLOBJ_HXX //autogen
// auto strip #include <tools/urlobj.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDOCFILE_HXX //autogen
// auto strip #include <bf_sfx2/docfile.hxx>
// auto strip #endif

#include "tabvwsh.hxx"
#include "bf_sc.hrc"
#include "globstr.hrc"
// auto strip #include "stlpool.hxx"
// auto strip #include "stlsheet.hxx"
#include "docsh.hxx"
#include "scmod.hxx"
#include "appoptio.hxx"
#include "rangeutl.hxx"
// auto strip #include "printfun.hxx"
// auto strip #include "drawsh.hxx"
#include "drformsh.hxx"
#include "editsh.hxx"
#include "pivotsh.hxx"
#include "auditsh.hxx"
#include "drtxtob.hxx"
#include "inputhdl.hxx"
// auto strip #include "editutil.hxx"
// auto strip #include "inputopt.hxx"
// auto strip #include "inputwin.hxx"
// auto strip #include "scresid.hxx"
#include "dbcolect.hxx"		// fuer ReImport
#include "reffact.hxx"
#include "viewuno.hxx"
#include "dispuno.hxx"
#include "anyrefdg.hxx"
// auto strip #include "chgtrack.hxx"
#include "cellsh.hxx"
#include "oleobjsh.hxx"
#include "chartsh.hxx"
#include "graphsh.hxx"
#include "pgbrksh.hxx"
#include "dpobject.hxx"
#include "prevwsh.hxx"
// auto strip #include "tpprint.hxx"
// auto strip #include "scextopt.hxx"
// auto strip #include "printopt.hxx"

#ifndef SC_NAVSETT_HXX
#include "navsett.hxx"
#endif
namespace binfilter {

void ActivateOlk( ScViewData* pViewData );
void DeActivateOlk( ScViewData* pViewData );

extern SfxViewShell* pScActiveViewShell;			// global.cxx

using namespace ::com::sun::star;

// STATIC DATA -----------------------------------------------------------

USHORT ScTabViewShell::nInsertCtrlState = SID_INSERT_GRAPHIC;
USHORT ScTabViewShell::nInsCellsCtrlState = 0;
USHORT ScTabViewShell::nInsObjCtrlState = SID_DRAW_CHART;

// -----------------------------------------------------------------------

//STRIP001 void __EXPORT ScTabViewShell::Activate(BOOL bMDI)
//STRIP001 {
//STRIP001 	SfxViewShell::Activate(bMDI);
//STRIP001 
//STRIP001 	//	hier kein GrabFocus, sonst gibt's Probleme wenn etwas inplace editiert wird!
//STRIP001 
//STRIP001 	if ( bMDI )
//STRIP001 	{
//STRIP001 		//	fuer Eingabezeile (ClearCache)
//STRIP001 		ScModule* pScMod = SC_MOD();
//STRIP001 		pScMod->ViewShellChanged();
//STRIP001 
//STRIP001 		ActivateView( TRUE, bFirstActivate );
//STRIP001 		ActivateOlk( GetViewData() );
//STRIP001 
//STRIP001 		//	#56870# AutoCorrect umsetzen, falls der Writer seins neu angelegt hat
//STRIP001 		UpdateDrawTextOutliner();
//STRIP001 
//STRIP001 		//	RegisterNewTargetNames gibts nicht mehr
//STRIP001 
//STRIP001 		SfxViewFrame* pThisFrame  = GetViewFrame();
//STRIP001 		if ( pInputHandler && pThisFrame->HasChildWindow(FID_INPUTLINE_STATUS) )
//STRIP001 		{
//STRIP001 			//	eigentlich nur beim Reload (letzte Version) noetig:
//STRIP001 			//	Das InputWindow bleibt stehen, aber die View mitsamt InputHandler wird
//STRIP001 			//	neu angelegt, darum muss der InputHandler am InputWindow gesetzt werden.
//STRIP001 			SfxChildWindow* pChild = pThisFrame->GetChildWindow(FID_INPUTLINE_STATUS);
//STRIP001 			if (pChild)
//STRIP001 			{
//STRIP001 				ScInputWindow* pWin = (ScInputWindow*)pChild->GetWindow();
//STRIP001 				if (pWin && pWin->IsVisible())
//STRIP001 				{
//STRIP001 
//STRIP001 					ScInputHandler* pOldHdl=pWin->GetInputHandler();
//STRIP001 
//STRIP001 					TypeId aScType = TYPE(ScTabViewShell);
//STRIP001 
//STRIP001 					SfxViewShell* pSh = SfxViewShell::GetFirst( &aScType );
//STRIP001 					while ( pSh!=NULL && pOldHdl!=NULL)
//STRIP001 					{
//STRIP001 						if (((ScTabViewShell*)pSh)->GetInputHandler() == pOldHdl)
//STRIP001 						{
//STRIP001 							pOldHdl->ResetDelayTimer();
//STRIP001 							break;
//STRIP001 						}
//STRIP001 						pSh = SfxViewShell::GetNext( *pSh, &aScType );
//STRIP001 					}
//STRIP001 
//STRIP001 					pWin->SetInputHandler( pInputHandler );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		UpdateInputHandler( TRUE );
//STRIP001 
//STRIP001 		if ( bFirstActivate )
//STRIP001 		{
//STRIP001 			SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_NAVIGATOR_UPDATEALL ) );
//STRIP001 			bFirstActivate = FALSE;
//STRIP001 
//STRIP001 			if ( aPendingUserData.Len() )
//STRIP001 			{
//STRIP001 				//	#89897# read user data from print preview now, after ctor
//STRIP001 				DoReadUserData( aPendingUserData );
//STRIP001 				aPendingUserData.Erase();
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		pScActiveViewShell = this;
//STRIP001 
//STRIP001 		ScInputHandler* pHdl = pScMod->GetInputHdl(this);
//STRIP001 		if (pHdl)
//STRIP001 		{
//STRIP001 			pHdl->SetRefScale( GetViewData()->GetZoomX(), GetViewData()->GetZoomY() );
//STRIP001 		}
//STRIP001 
//STRIP001 		//	Aenderungs-Dialog aktualisieren
//STRIP001 
//STRIP001 		if ( pThisFrame->HasChildWindow(FID_CHG_ACCEPT) )
//STRIP001 		{
//STRIP001 			SfxChildWindow* pChild = pThisFrame->GetChildWindow(FID_CHG_ACCEPT);
//STRIP001 			if (pChild)
//STRIP001 			{
//STRIP001 				((ScAcceptChgDlgWrapper*)pChild)->ReInitDlg();
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if(pScMod->IsRefDialogOpen())
//STRIP001 		{
//STRIP001 			USHORT nCurRefDlgId=pScMod->GetCurRefDlgId();
//STRIP001 			SfxChildWindow* pChildWnd = pThisFrame->GetChildWindow( nCurRefDlgId );
//STRIP001 			if ( pChildWnd )
//STRIP001 			{
//STRIP001 				ScAnyRefDlg* pRefDlg = (ScAnyRefDlg*)pChildWnd->GetWindow();
//STRIP001 				pRefDlg->ViewShellChanged(this);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//	don't call CheckSelectionTransfer here - activating a view should not change the
//STRIP001 	//	primary selection (may be happening just because the mouse was moved over the window)
//STRIP001 
//STRIP001 	//	Wenn Referenzeingabe-Tip-Hilfe hier wieder angezeigt werden soll (ShowRefTip),
//STRIP001 	//	muss sie beim Verschieben der View angepasst werden (gibt sonst Probleme unter OS/2
//STRIP001 	//	beim Umschalten zwischen Dokumenten)
//STRIP001 }

//STRIP001 void __EXPORT ScTabViewShell::Deactivate(BOOL bMDI)
//STRIP001 {
//STRIP001 	HideTip();
//STRIP001 
//STRIP001 	ScDocument*	pDoc=GetViewData()->GetDocument();
//STRIP001 
//STRIP001 	ScChangeTrack* pChanges=pDoc->GetChangeTrack();
//STRIP001 
//STRIP001 	if(pChanges!=NULL)
//STRIP001 	{
//STRIP001 		Link aLink;
//STRIP001 		pChanges->SetModifiedLink(aLink);
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxViewShell::Deactivate(bMDI);
//STRIP001 
//STRIP001 	ScInputHandler* pHdl = SC_MOD()->GetInputHdl(this);
//STRIP001 
//STRIP001 	if( bMDI )
//STRIP001 	{
//STRIP001 		//	#85421# during shell deactivation, shells must not be switched, or the loop
//STRIP001 		//	through the shell stack (in SfxDispatcher::DoDeactivate_Impl) will not work
//STRIP001 		BOOL bOldDontSwitch = bDontSwitch;
//STRIP001 		bDontSwitch = TRUE;
//STRIP001 
//STRIP001 		DeActivateOlk( GetViewData() );
//STRIP001 		ActivateView( FALSE, FALSE );
//STRIP001 
//STRIP001 		if ( GetViewFrame()->ISA(SfxInPlaceFrame) )							// inplace
//STRIP001 			GetViewData()->GetDocShell()->UpdateOle(GetViewData(),TRUE);
//STRIP001 
//STRIP001 		if ( pHdl )
//STRIP001 			pHdl->NotifyChange( NULL, TRUE ); // Timer-verzoegert wg. Dokumentwechsel
//STRIP001 
//STRIP001 		if (pScActiveViewShell == this)
//STRIP001 			pScActiveViewShell = NULL;
//STRIP001 
//STRIP001 		bDontSwitch = bOldDontSwitch;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		HideNoteMarker();			// Notiz-Anzeige
//STRIP001 
//STRIP001 		if ( pHdl )
//STRIP001 			pHdl->HideTip();		// Formel-AutoEingabe-Tip abschalten
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScTabViewShell::SetActive()
//STRIP001 {
//STRIP001 	// Die Sfx-View moechte sich gerne selbst aktivieren, weil dabei noch
//STRIP001 	// magische Dinge geschehen (z.B. stuerzt sonst evtl. der Gestalter ab)
//STRIP001 	ActiveGrabFocus();
//STRIP001 
//STRIP001 #if 0
//STRIP001 	SfxViewFrame* pFrame = GetViewFrame();
//STRIP001 	if ( pFrame->ISA(SfxTopViewFrame) )
//STRIP001 		pFrame->GetFrame()->Appear();
//STRIP001 
//STRIP001 	SFX_APP()->SetViewFrame( pFrame );			// immer erst Appear, dann SetViewFrame (#29290#)
//STRIP001 #endif
//STRIP001 }

/*N*/ USHORT __EXPORT ScTabViewShell::PrepareClose(BOOL bUI, BOOL bForBrowsing)
/*N*/ {
/*N*/     // #110797#
/*N*/     if ( GetDrawView() )
/*?*/         GetDrawView()->EndTextEdit();

/*N*/ 	if ( pFormShell )
/*N*/ 	{
/*N*/ 		USHORT nRet = pFormShell->PrepareClose(bUI, bForBrowsing);
/*N*/ 		if (nRet!=TRUE)
/*N*/ 			return nRet;
/*N*/ 	}
/*N*/ 	return SfxViewShell::PrepareClose(bUI,bForBrowsing);
/*N*/ }

//------------------------------------------------------------------

//STRIP001 Size __EXPORT ScTabViewShell::GetOptimalSizePixel() const
//STRIP001 {
//STRIP001 	Size aOptSize;
//STRIP001 
//STRIP001 	USHORT				nCurTab		= GetViewData()->GetTabNo();
//STRIP001 	ScDocument*			pDoc		= GetViewData()->GetDocument();
//STRIP001 	ScStyleSheetPool*	pStylePool  = pDoc->GetStyleSheetPool();
//STRIP001 	SfxStyleSheetBase*	pStyleSheet = pStylePool->Find(
//STRIP001 										pDoc->GetPageStyle( nCurTab ),
//STRIP001 										SFX_STYLE_FAMILY_PAGE );
//STRIP001 
//STRIP001 	DBG_ASSERT( pStyleSheet, "PageStyle not found :-/" );
//STRIP001 
//STRIP001 	if ( pStyleSheet )
//STRIP001 	{
//STRIP001 		const SfxItemSet&  rSet 	 = pStyleSheet->GetItemSet();
//STRIP001 		const SvxSizeItem& rItem	 = (const SvxSizeItem&)rSet.Get( ATTR_PAGE_SIZE );
//STRIP001 		const Size&		   rPageSize = rItem.GetSize();
//STRIP001 
//STRIP001 		aOptSize.Width()  = (long) (rPageSize.Width()  * GetViewData()->GetPPTX());
//STRIP001 		aOptSize.Height() = (long) (rPageSize.Height() * GetViewData()->GetPPTY());
//STRIP001 	}
//STRIP001 
//STRIP001 	return aOptSize;
//STRIP001 }

//------------------------------------------------------------------

//	Zoom fuer In-Place berechnen
//	aus Verhaeltnis von VisArea und Fenstergroesse des GridWin

//STRIP001 void ScTabViewShell::UpdateOleZoom()
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	if ( pDocSh->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED )
//STRIP001 	{
//STRIP001 		Size aObjSize = ((SfxInPlaceObject*)pDocSh)->GetVisArea().GetSize();
//STRIP001 		if ( aObjSize.Width() > 0 && aObjSize.Height() > 0 )
//STRIP001 		{
//STRIP001 			Window* pWin = GetActiveWin();
//STRIP001 			Size aWinHMM = pWin->PixelToLogic( pWin->GetOutputSizePixel(), MAP_100TH_MM );
//STRIP001 			SetZoomFactor( Fraction( aWinHMM.Width(),aObjSize.Width() ),
//STRIP001 							Fraction( aWinHMM.Height(),aObjSize.Height() ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void __EXPORT ScTabViewShell::AdjustPosSizePixel( const Point &rPos, const Size &rSize )
//STRIP001 {
//STRIP001 	OuterResizePixel( rPos, rSize );
//STRIP001 }

//STRIP001 void __EXPORT ScTabViewShell::InnerResizePixel( const Point &rOfs, const Size &rSize )
//STRIP001 {
//STRIP001 	SvBorder aBorder;
//STRIP001 	GetBorderSize( aBorder, rSize );
//STRIP001 	SetBorderPixel( aBorder );
//STRIP001 
//STRIP001 	Size aNewSize( rSize );
//STRIP001 	aNewSize.Width()  += aBorder.Left() + aBorder.Right();
//STRIP001 	aNewSize.Height() += aBorder.Top() + aBorder.Bottom();
//STRIP001 
//STRIP001 	DoResize( rOfs, aNewSize, TRUE );					// rSize = Groesse von gridwin
//STRIP001 
//STRIP001 	UpdateOleZoom();									//	Zoom fuer In-Place berechnen
//STRIP001 
//STRIP001 //	GetViewData()->GetDocShell()->UpdateOle( GetViewData() );
//STRIP001 	GetViewData()->GetDocShell()->SetDocumentModified();
//STRIP001 }

/*N*/ void __EXPORT ScTabViewShell::OuterResizePixel( const Point &rOfs, const Size &rSize )
/*N*/ {
/*N*/ 	SvBorder aBorder;
/*N*/ 	GetBorderSize( aBorder, rSize );
/*N*/ 	SetBorderPixel( aBorder );
/*N*/ 
/*N*/ 	DoResize( rOfs, rSize );					// Position und Groesse von tabview wie uebergeben
/*N*/ 
/*N*/ 	// ForceMove als Ersatz fuer den Sfx-Move-Mechanismus
/*N*/ 	// (aWinPos muss aktuell gehalten werden, damit ForceMove beim Ole-Deaktivieren klappt)
/*N*/ 
/*N*/ 	ForceMove();
/*N*/ }

//STRIP001 void __EXPORT ScTabViewShell::SetZoomFactor( const Fraction &rZoomX, const Fraction &rZoomY )
//STRIP001 {
//STRIP001 	//	fuer OLE...
//STRIP001 
//STRIP001 	Fraction aFrac20( 1,5 );
//STRIP001 	Fraction aFrac400( 4,1 );
//STRIP001 
//STRIP001 	Fraction aNewX( rZoomX );
//STRIP001 	if ( aNewX < aFrac20 )
//STRIP001 		aNewX = aFrac20;
//STRIP001 	if ( aNewX > aFrac400 )
//STRIP001 		aNewX = aFrac400;
//STRIP001 	Fraction aNewY( rZoomY );
//STRIP001 	if ( aNewY < aFrac20 )
//STRIP001 		aNewY = aFrac20;
//STRIP001 	if ( aNewY > aFrac400 )
//STRIP001 		aNewY = aFrac400;
//STRIP001 
//STRIP001 	GetViewData()->UpdateScreenZoom( aNewX, aNewY );
//STRIP001 	SetZoom( aNewX, aNewY );
//STRIP001 
//STRIP001 	PaintGrid();
//STRIP001 	PaintTop();
//STRIP001 	PaintLeft();
//STRIP001 
//STRIP001 	SfxViewShell::SetZoomFactor( rZoomX, rZoomY );
//STRIP001 }

//STRIP001 void __EXPORT ScTabViewShell::QueryObjAreaPixel( Rectangle& rRect ) const
//STRIP001 {
//STRIP001 	//	auf ganze Zellen anpassen (in 1/100 mm)
//STRIP001 
//STRIP001 	Size aPixelSize = rRect.GetSize();
//STRIP001 	Window* pWin = ((ScTabViewShell*)this)->GetActiveWin();
//STRIP001 	Size aLogicSize = pWin->PixelToLogic( aPixelSize );
//STRIP001 
//STRIP001 	const ScViewData* pViewData = GetViewData();
//STRIP001 	ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 	ScSplitPos ePos = pViewData->GetActivePart();
//STRIP001 	USHORT nCol = pViewData->GetPosX(WhichH(ePos));
//STRIP001 	USHORT nRow = pViewData->GetPosY(WhichV(ePos));
//STRIP001 	USHORT nTab = pViewData->GetTabNo();
//STRIP001 	Rectangle aLogicRect = pDoc->GetMMRect( nCol, nRow, nCol, nRow, nTab );
//STRIP001 	aLogicRect.SetSize( aLogicSize );
//STRIP001 
//STRIP001 	pDoc->SnapVisArea( aLogicRect );
//STRIP001 
//STRIP001 	rRect.SetSize( pWin->LogicToPixel( aLogicRect.GetSize() ) );
//STRIP001 
//STRIP001 #if 0
//STRIP001 	//	auf ganze Zellen anpassen (in Pixeln)
//STRIP001 
//STRIP001 	ScViewData* pViewData = ((ScTabViewShell*)this)->GetViewData();
//STRIP001 	Size aSize = rRect.GetSize();
//STRIP001 
//STRIP001 	ScSplitPos ePos = pViewData->GetActivePart();
//STRIP001 	Window* pWin = ((ScTabViewShell*)this)->GetActiveWin();
//STRIP001 
//STRIP001 	Point aTest( aSize.Width(), aSize.Height() );
//STRIP001 	short nPosX;
//STRIP001 	short nPosY;
//STRIP001 	pViewData->GetPosFromPixel( aTest.X(), aTest.Y(), ePos, nPosX, nPosY );
//STRIP001 	BOOL bLeft;
//STRIP001 	BOOL bTop;
//STRIP001 	pViewData->GetMouseQuadrant( aTest, ePos, nPosX, nPosY, bLeft, bTop );
//STRIP001 	if (!bLeft)
//STRIP001 		++nPosX;
//STRIP001 	if (!bTop)
//STRIP001 		++nPosY;
//STRIP001 	aTest = pViewData->GetScrPos( (USHORT)nPosX, (USHORT)nPosY, ePos, TRUE );
//STRIP001 
//STRIP001 	rRect.SetSize(Size(aTest.X(),aTest.Y()));
//STRIP001 #endif
//STRIP001 }

//------------------------------------------------------------------

/*N*/ void __EXPORT ScTabViewShell::Move()
/*N*/ {
/*N*/ 	Point aNewPos = GetViewFrame()->GetWindow().OutputToScreenPixel(Point());
/*N*/ 
/*N*/ 	if (aNewPos != aWinPos)
/*N*/ 	{
/*N*/ 		StopMarking();
/*N*/ 		aWinPos = aNewPos;
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------

/*N*/ void __EXPORT ScTabViewShell::ShowCursor(FASTBOOL bOn)
/*N*/ {
/*!!!	ShowCursor wird nicht paarweise wie im gridwin gerufen.
		Der CursorLockCount am Gridwin muss hier direkt auf 0 gesetzt werden

	if (bOn)
		ShowAllCursors();
	else
		HideAllCursors();
*/
/*N*/ }

//------------------------------------------------------------------

/*N*/ void __EXPORT ScTabViewShell::WriteUserData(String& rData, BOOL bBrowse)
/*N*/ {
/*N*/ 	GetViewData()->WriteUserData(rData);
/*N*/ }

/*N*/ void ScTabViewShell::WriteUserDataSequence (uno::Sequence < beans::PropertyValue >& rSettings, sal_Bool bBrowse )
/*N*/ {
/*N*/ 	GetViewData()->WriteUserDataSequence (rSettings);
/*N*/ }

//STRIP001 void __EXPORT ScTabViewShell::ReadUserData(const String& rData, BOOL bBrowse)
//STRIP001 {
//STRIP001 	if ( !GetViewData()->GetDocShell()->IsPreview() )
//STRIP001 		DoReadUserData( rData );
//STRIP001 }

//STRIP001 void ScTabViewShell::ReadUserDataSequence (const uno::Sequence < beans::PropertyValue >& rSettings, sal_Bool bBrowse )
//STRIP001 {
//STRIP001     if ( GetViewData()->GetDocShell()->IsPreview() )
//STRIP001         return;
//STRIP001 
//STRIP001 	Window* pOldWin = GetActiveWin();
//STRIP001 	BOOL bFocus = pOldWin && pOldWin->HasFocus();
//STRIP001 
//STRIP001 	GetViewData()->ReadUserDataSequence(rSettings);
//STRIP001 	SetTabNo( GetViewData()->GetTabNo(), TRUE );
//STRIP001 
//STRIP001 	if ( GetViewData()->IsPagebreakMode() )
//STRIP001 		SetCurSubShell( GetCurObjectSelectionType(), TRUE );
//STRIP001 
//STRIP001 	Window* pNewWin = GetActiveWin();
//STRIP001 	if (pNewWin && pNewWin != pOldWin)
//STRIP001 	{
//STRIP001 		SetWindow( pNewWin );		//! ist diese ViewShell immer aktiv???
//STRIP001 		if (bFocus)
//STRIP001 			pNewWin->GrabFocus();
//STRIP001 		WindowChanged();			// Drawing-Layer (z.B. #56771#)
//STRIP001 	}
//STRIP001 
//STRIP001 	if (GetViewData()->GetHSplitMode() == SC_SPLIT_FIX ||
//STRIP001 		GetViewData()->GetVSplitMode() == SC_SPLIT_FIX)
//STRIP001 	{
//STRIP001 		InvalidateSplit();
//STRIP001 	}
//STRIP001 
//STRIP001 	ZoomChanged();
//STRIP001 
//STRIP001 	TestHintWindow();
//STRIP001 
//STRIP001 	//!	if ViewData has more tables than document, remove tables in ViewData
//STRIP001 }

// DoReadUserData is also called from ctor when switching from print preview

//STRIP001 void ScTabViewShell::DoReadUserData( const String& rData )
//STRIP001 {
//STRIP001 	Window* pOldWin = GetActiveWin();
//STRIP001 	BOOL bFocus = pOldWin && pOldWin->HasFocus();
//STRIP001 
//STRIP001 	GetViewData()->ReadUserData(rData);
//STRIP001 	SetTabNo( GetViewData()->GetTabNo(), TRUE );
//STRIP001 
//STRIP001 	if ( GetViewData()->IsPagebreakMode() )
//STRIP001 		SetCurSubShell( GetCurObjectSelectionType(), TRUE );
//STRIP001 
//STRIP001 	Window* pNewWin = GetActiveWin();
//STRIP001 	if (pNewWin && pNewWin != pOldWin)
//STRIP001 	{
//STRIP001 		SetWindow( pNewWin );		//! ist diese ViewShell immer aktiv???
//STRIP001 		if (bFocus)
//STRIP001 			pNewWin->GrabFocus();
//STRIP001 		WindowChanged();			// Drawing-Layer (z.B. #56771#)
//STRIP001 	}
//STRIP001 
//STRIP001 	if (GetViewData()->GetHSplitMode() == SC_SPLIT_FIX ||
//STRIP001 		GetViewData()->GetVSplitMode() == SC_SPLIT_FIX)
//STRIP001 	{
//STRIP001 		InvalidateSplit();
//STRIP001 	}
//STRIP001 
//STRIP001 	ZoomChanged();
//STRIP001 
//STRIP001 	TestHintWindow();
//STRIP001 
//STRIP001 	//!	if ViewData has more tables than document, remove tables in ViewData
//STRIP001 }


//------------------------------------------------------------------

//STRIP001 void ScTabViewShell::TestFunction( USHORT nPar )
//STRIP001 {
/*	switch (nPar)
	{
	}
*/
//STRIP001 }

//------------------------------------------------------------------

//STRIP001 void ScTabViewShell::ExecuteShowNIY( SfxRequest& rReq )
//STRIP001 {
//STRIP001 	ErrorMessage(STR_BOX_YNI);
//STRIP001 }

//------------------------------------------------------------------

//STRIP001 void ScTabViewShell::StateDisabled( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	SfxWhichIter aIter( rSet );
//STRIP001 	USHORT		 nWhich = aIter.FirstWhich();
//STRIP001 
//STRIP001 	while ( nWhich )
//STRIP001 	{
//STRIP001 		rSet.DisableItem( nWhich );
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScTabViewShell::SetDrawShellOrSub()
//STRIP001 {
//STRIP001 	bActiveDrawSh = TRUE;
//STRIP001 
//STRIP001 	if(bActiveDrawFormSh)
//STRIP001 	{
//STRIP001 		SetCurSubShell(OST_DrawForm);
//STRIP001 	}
//STRIP001 	else if(bActiveGraphicSh)
//STRIP001 	{
//STRIP001 		SetCurSubShell(OST_Graphic);
//STRIP001 	}
//STRIP001 	else if(bActiveChartSh)
//STRIP001 	{
//STRIP001 		SetCurSubShell(OST_Chart);
//STRIP001 	}
//STRIP001 	else if(bActiveOleObjectSh)
//STRIP001 	{
//STRIP001 		SetCurSubShell(OST_OleObject);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SetCurSubShell(OST_Drawing);
//STRIP001 	}
//STRIP001 }

/*N*/ void ScTabViewShell::SetDrawShell( BOOL bActive )
/*N*/ {
/*N*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if(bActive)
//STRIP001 	{
//STRIP001 		SetCurSubShell(OST_Drawing);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if(bActiveDrawFormSh || bActiveDrawSh ||
//STRIP001 			bActiveGraphicSh  || bActiveOleObjectSh||
//STRIP001 			bActiveChartSh || bActiveDrawTextSh)
//STRIP001 		{
//STRIP001 			SetCurSubShell(OST_Cell);
//STRIP001 		}
//STRIP001 		bActiveDrawFormSh=FALSE;
//STRIP001 		bActiveGraphicSh=FALSE;
//STRIP001 		bActiveOleObjectSh=FALSE;
//STRIP001 		bActiveChartSh=FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bWasDraw = bActiveDrawSh || bActiveDrawTextSh;
//STRIP001 
//STRIP001 	bActiveDrawSh = bActive;
//STRIP001 	bActiveDrawTextSh = FALSE;
//STRIP001 
//STRIP001 	if ( !bActive )
//STRIP001 	{
//STRIP001 		ResetDrawDragMode();		//	Mirror / Rotate aus
//STRIP001 
//STRIP001 		if (bWasDraw && (GetViewData()->GetHSplitMode() == SC_SPLIT_FIX ||
//STRIP001 						 GetViewData()->GetVSplitMode() == SC_SPLIT_FIX))
//STRIP001 		{
//STRIP001 			//	Aktiven Teil an Cursor anpassen, etc.
//STRIP001 			MoveCursorAbs( GetViewData()->GetCurX(), GetViewData()->GetCurY(),
//STRIP001 							SC_FOLLOW_NONE, FALSE, FALSE, TRUE );
//STRIP001 		}
//STRIP001 	}
/*N*/ }

//STRIP001 void ScTabViewShell::SetDrawTextShell( BOOL bActive )
//STRIP001 {
//STRIP001 	bActiveDrawTextSh = bActive;
//STRIP001 	if ( bActive )
//STRIP001 	{
//STRIP001 		bActiveDrawFormSh=FALSE;
//STRIP001 		bActiveGraphicSh=FALSE;
//STRIP001 		bActiveOleObjectSh=FALSE;
//STRIP001 		bActiveChartSh=FALSE;
//STRIP001 		bActiveDrawSh = FALSE;
//STRIP001 		SetCurSubShell(OST_DrawText);
//STRIP001 	}
//STRIP001 	else
//STRIP001 		SetCurSubShell(OST_Cell);
//STRIP001 
//STRIP001 }

//STRIP001 void ScTabViewShell::SetPivotShell( BOOL bActive )
//STRIP001 {
//STRIP001 	bActivePivotSh = bActive;
//STRIP001 
//STRIP001 	//	#68771# #76198# SetPivotShell is called from CursorPosChanged every time
//STRIP001 	//	-> don't change anything except switching between cell and pivot shell
//STRIP001 
//STRIP001 	if ( eCurOST == OST_Pivot || eCurOST == OST_Cell )
//STRIP001 	{
//STRIP001 		if ( bActive )
//STRIP001 		{
//STRIP001 			bActiveDrawTextSh = bActiveDrawSh = FALSE;
//STRIP001 			bActiveDrawFormSh=FALSE;
//STRIP001 			bActiveGraphicSh=FALSE;
//STRIP001 			bActiveOleObjectSh=FALSE;
//STRIP001 			bActiveChartSh=FALSE;
//STRIP001 			SetCurSubShell(OST_Pivot);
//STRIP001 		}
//STRIP001 		else
//STRIP001 			SetCurSubShell(OST_Cell);
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScTabViewShell::SetAuditShell( BOOL bActive )
//STRIP001 {
//STRIP001 	bActiveAuditingSh = bActive;
//STRIP001 	if ( bActive )
//STRIP001 	{
//STRIP001 		bActiveDrawTextSh = bActiveDrawSh = FALSE;
//STRIP001 		bActiveDrawFormSh=FALSE;
//STRIP001 		bActiveGraphicSh=FALSE;
//STRIP001 		bActiveOleObjectSh=FALSE;
//STRIP001 		bActiveChartSh=FALSE;
//STRIP001 		SetCurSubShell(OST_Auditing);
//STRIP001 	}
//STRIP001 	else
//STRIP001 		SetCurSubShell(OST_Cell);
//STRIP001 }

//STRIP001 void ScTabViewShell::SetDrawFormShell( BOOL bActive )
//STRIP001 {
//STRIP001 	bActiveDrawFormSh = bActive;
//STRIP001 
//STRIP001 	if(bActiveDrawFormSh)
//STRIP001 		SetCurSubShell(OST_DrawForm);
//STRIP001 }
//STRIP001 void ScTabViewShell::SetChartShell( BOOL bActive )
//STRIP001 {
//STRIP001 	bActiveChartSh = bActive;
//STRIP001 
//STRIP001 	if(bActiveChartSh)
//STRIP001 		SetCurSubShell(OST_Chart);
//STRIP001 }

//STRIP001 void ScTabViewShell::SetGraphicShell( BOOL bActive )
//STRIP001 {
//STRIP001 	bActiveGraphicSh = bActive;
//STRIP001 
//STRIP001 	if(bActiveGraphicSh)
//STRIP001 		SetCurSubShell(OST_Graphic);
//STRIP001 }

//STRIP001 void ScTabViewShell::SetOleObjectShell( BOOL bActive )
//STRIP001 {
//STRIP001 	bActiveOleObjectSh = bActive;
//STRIP001 
//STRIP001 	if(bActiveOleObjectSh)
//STRIP001 		SetCurSubShell(OST_OleObject);
//STRIP001 	else
//STRIP001 		SetCurSubShell(OST_Cell);
//STRIP001 }

//STRIP001 void ScTabViewShell::SetEditShell(EditView* pView, BOOL bActive )
//STRIP001 {
//STRIP001 	if(bActive)
//STRIP001 	{
//STRIP001 		if (pEditShell)
//STRIP001 			pEditShell->SetEditView( pView );
//STRIP001 		else
//STRIP001 			pEditShell = new ScEditShell( pView, GetViewData() );
//STRIP001 
//STRIP001 		SetCurSubShell(OST_Editing);
//STRIP001 	}
//STRIP001 	else if(bActiveEditSh)
//STRIP001 	{
//STRIP001 		SetCurSubShell(OST_Cell);
//STRIP001 	}
//STRIP001 	bActiveEditSh = bActive;
//STRIP001 }

/*N*/ void ScTabViewShell::SetCurSubShell(ObjectSelectionType	eOST, BOOL bForce)
/*N*/ {
/*N*/ 	ScViewData* pViewData	= GetViewData();
/*N*/ 	ScDocShell* pDocSh		= pViewData->GetDocShell();
/*N*/ 	SfxShell*	pCurSubSh	= NULL;
/*N*/ 
/*N*/ 	if(bDontSwitch) return;
/*N*/ 
/*N*/ 	if(!pCellShell) //Wird eh immer gebraucht.
/*N*/ 	{
/*N*/ 		pCellShell = new ScCellShell( GetViewData() );
/*N*/ 		pCellShell->SetRepeatTarget( &aTarget );
/*N*/ 	}
/*N*/ 
/*N*/ 	BOOL bPgBrk=pViewData->IsPagebreakMode();
/*N*/ 
/*N*/ 	if(bPgBrk && !pPageBreakShell)
/*N*/ 	{
/*?*/ 		pPageBreakShell = new ScPageBreakShell( this );
/*?*/ 		pPageBreakShell->SetRepeatTarget( &aTarget );
/*N*/ 	}
/*N*/ 
/*N*/ 
/*N*/ 	if ( eOST!=eCurOST || bForce )
/*N*/ 	{
/*N*/ 		if(eCurOST!=OST_NONE) RemoveSubShell();
/*N*/ 
/*N*/ 		if(pFormShell) AddSubShell(*pFormShell);
/*N*/ 
/*N*/ 
/*N*/ 		switch(eOST)
/*N*/ 		{
/*N*/ 			case	OST_Cell:
/*N*/ 					{
/*N*/ 						AddSubShell(*pCellShell);
/*N*/ 						if(bPgBrk) AddSubShell(*pPageBreakShell);
/*N*/ 					}
/*N*/ 					break;
/*?*/ 			case	OST_Editing:
/*?*/ 					{
/*?*/ 						AddSubShell(*pCellShell);
/*?*/ 						if(bPgBrk) AddSubShell(*pPageBreakShell);
/*?*/ 
/*?*/ 						if(pEditShell)
/*?*/ 						{
/*?*/ 							AddSubShell(*pEditShell);
/*?*/ 						}
/*?*/ 					}
/*?*/ 					break;
/*?*/ 			case	OST_DrawText:
/*?*/ 					{
/*?*/ 						if ( !pDrawTextShell )
/*?*/ 						{
/*?*/ 							pDocSh->MakeDrawLayer();
/*?*/ 							pDrawTextShell = new ScDrawTextObjectBar( GetViewData() );
/*?*/ 						}
/*?*/ 						AddSubShell(*pDrawTextShell);
/*?*/ 					}
/*?*/ 					break;
/*?*/ 			case	OST_Drawing:
/*?*/ 					{
/*?*/ 						if ( !pDrawShell )
/*?*/ 						{
/*?*/ 							pDocSh->MakeDrawLayer();
/*?*/ 							pDrawShell = new ScDrawShell( GetViewData() );
/*?*/ 							pDrawShell->SetRepeatTarget( &aTarget );
/*?*/ 						}
/*?*/ 						AddSubShell(*pDrawShell);
/*?*/ 					}
/*?*/ 					break;
/*?*/ 
/*?*/ 			case	OST_DrawForm:
/*?*/ 					{
/*?*/ 						if ( !pDrawFormShell )
/*?*/ 						{
/*?*/ 							pDocSh->MakeDrawLayer();
/*?*/ 							pDrawFormShell = new ScDrawFormShell( GetViewData() );
/*?*/ 							pDrawFormShell->SetRepeatTarget( &aTarget );
/*?*/ 						}
/*?*/ 						AddSubShell(*pDrawFormShell);
/*?*/ 					}
/*?*/ 					break;
/*?*/ 
/*?*/ 			case	OST_Chart:
/*?*/ 					{
/*?*/ 						if ( !pChartShell )
/*?*/ 						{
/*?*/ 							pDocSh->MakeDrawLayer();
/*?*/ 							pChartShell = new ScChartShell( GetViewData() );
/*?*/ 							pChartShell->SetRepeatTarget( &aTarget );
/*?*/ 						}
/*?*/ 						AddSubShell(*pChartShell);
/*?*/ 					}
/*?*/ 					break;
/*?*/ 
/*?*/ 			case	OST_OleObject:
/*?*/ 					{
/*?*/ 						if ( !pOleObjectShell )
/*?*/ 						{
/*?*/ 							pDocSh->MakeDrawLayer();
/*?*/ 							pOleObjectShell = new ScOleObjectShell( GetViewData() );
/*?*/ 							pOleObjectShell->SetRepeatTarget( &aTarget );
/*?*/ 						}
/*?*/ 						AddSubShell(*pOleObjectShell);
/*?*/ 					}
/*?*/ 					break;
/*?*/ 
/*?*/ 			case	OST_Graphic:
/*?*/ 					{
/*?*/ 						if ( !pGraphicShell)
/*?*/ 						{
/*?*/ 							pDocSh->MakeDrawLayer();
/*?*/ 							pGraphicShell = new ScGraphicShell( GetViewData() );
/*?*/ 							pGraphicShell->SetRepeatTarget( &aTarget );
/*?*/ 						}
/*?*/ 						AddSubShell(*pGraphicShell);
/*?*/ 					}
/*?*/ 					break;
/*?*/ 
/*?*/ 			case	OST_Pivot:
/*?*/ 					{
/*?*/ 						AddSubShell(*pCellShell);
/*?*/ 						if(bPgBrk) AddSubShell(*pPageBreakShell);
/*?*/ 
/*?*/ 						if ( !pPivotShell )
/*?*/ 						{
/*?*/ 							pPivotShell = new ScPivotShell( this );
/*?*/ 							pPivotShell->SetRepeatTarget( &aTarget );
/*?*/ 						}
/*?*/ 						AddSubShell(*pPivotShell);
/*?*/ 					}
/*?*/ 					break;
/*?*/ 			case	OST_Auditing:
/*?*/ 					{
/*?*/ 						AddSubShell(*pCellShell);
/*?*/ 						if(bPgBrk) AddSubShell(*pPageBreakShell);
/*?*/ 
/*?*/ 						if ( !pAuditingShell )
/*?*/ 						{
/*?*/ 							pDocSh->MakeDrawLayer();	// die Wartezeit lieber jetzt als beim Klick
/*?*/ 
/*?*/ 							pAuditingShell = new ScAuditingShell( GetViewData() );
/*?*/ 							pAuditingShell->SetRepeatTarget( &aTarget );
/*?*/ 						}
/*?*/ 						AddSubShell(*pAuditingShell);
/*?*/ 					}
/*?*/ 					break;
/*N*/ 			default:
/*N*/ 					DBG_ERROR("Falsche Shell angefordert");
/*N*/ 					break;
/*N*/ 		}
/*N*/ 		eCurOST=eOST;
/*N*/ 	}
/*N*/ }

//STRIP001 ObjectSelectionType ScTabViewShell::GetCurObjectSelectionType()
//STRIP001 {
//STRIP001 	return eCurOST;
//STRIP001 }

//	GetMySubShell / SetMySubShell: altes Verhalten simulieren,
//	dass es nur eine SubShell gibt (nur innerhalb der 5 eignenen SubShells)

//STRIP001 SfxShell* ScTabViewShell::GetMySubShell() const
//STRIP001 {
//STRIP001 	//	GetSubShell() war frueher const, und GetSubShell(USHORT) sollte es auch sein...
//STRIP001 
//STRIP001 	USHORT nPos = 0;
//STRIP001 	SfxShell* pSub = ((ScTabViewShell*)this)->GetSubShell(nPos);
//STRIP001 	while (pSub)
//STRIP001 	{
//STRIP001 		if ( pSub == pDrawShell  || pSub == pDrawTextShell || pSub == pEditShell ||
//STRIP001 			 pSub == pPivotShell || pSub == pAuditingShell || pSub == pDrawFormShell ||
//STRIP001 			 pSub == pCellShell	 || pSub == pOleObjectShell|| pSub == pChartShell ||
//STRIP001 			 pSub == pGraphicShell || pSub == pPageBreakShell)
//STRIP001 			return pSub;	// gefunden
//STRIP001 
//STRIP001 		pSub = ((ScTabViewShell*)this)->GetSubShell(++nPos);
//STRIP001 	}
//STRIP001 	return NULL;		// keine von meinen dabei
//STRIP001 }

//STRIP001 void ScTabViewShell::SetMySubShell( SfxShell* pShell )
//STRIP001 {
//STRIP001 	SfxShell* pOld = GetMySubShell();
//STRIP001 	if ( pOld != pShell )
//STRIP001 	{
//STRIP001 		if (pOld)
//STRIP001 			RemoveSubShell(pOld);	// alte SubShell entfernen
//STRIP001 		if (pShell)
//STRIP001 			AddSubShell(*pShell);	// neue setzen
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL ScTabViewShell::IsDrawTextShell() const
//STRIP001 {
//STRIP001 	return ( pDrawTextShell && ( GetMySubShell() == pDrawTextShell ) );
//STRIP001 }

//STRIP001 BOOL ScTabViewShell::IsAuditShell() const
//STRIP001 {
//STRIP001 	return ( pAuditingShell && ( GetMySubShell() == pAuditingShell ) );
//STRIP001 }

//STRIP001 void ScTabViewShell::SetDrawTextUndo( SfxUndoManager* pUndoMgr )
//STRIP001 {
//STRIP001 	// Default: Undo-Manager der DocShell
//STRIP001 	if (!pUndoMgr)
//STRIP001 		pUndoMgr = GetViewData()->GetDocShell()->GetUndoManager();
//STRIP001 
//STRIP001 	if (pDrawTextShell)
//STRIP001 		pDrawTextShell->SetUndoManager(pUndoMgr);
//STRIP001 	else
//STRIP001 		DBG_ERROR("SetDrawTextUndo ohne DrawTextShell");
//STRIP001 }

//------------------------------------------------------------------

/*N*/ ScTabViewShell* ScTabViewShell::GetActiveViewShell()
/*N*/ {
/*N*/ 	return PTR_CAST(ScTabViewShell,Current());
/*N*/ }

//------------------------------------------------------------------

/*N*/ SfxPrinter* __EXPORT ScTabViewShell::GetPrinter( BOOL bCreate )
/*N*/ {
/*N*/ 	//	Drucker ist immer da (wird fuer die FontListe schon beim Starten angelegt)
/*N*/ 	return GetViewData()->GetDocShell()->GetPrinter();
/*N*/ }

//STRIP001 USHORT __EXPORT ScTabViewShell::SetPrinter( SfxPrinter *pNewPrinter, USHORT nDiffFlags )
//STRIP001 {
//STRIP001 	return GetViewData()->GetDocShell()->SetPrinter( pNewPrinter, nDiffFlags );
//STRIP001 }

//STRIP001 PrintDialog* __EXPORT ScTabViewShell::CreatePrintDialog( Window *pParent )
//STRIP001 {
//STRIP001 	ScDocShell*	pDocShell	= GetViewData()->GetDocShell();
//STRIP001 	ScDocument*	pDoc		= pDocShell->GetDocument();
//STRIP001 
//STRIP001 	pDoc->SetPrintOptions();				// Optionen aus OFA am Printer setzen
//STRIP001 	SfxPrinter* pPrinter = GetPrinter();
//STRIP001 
//STRIP001 	String			aStrRange;
//STRIP001 	PrintDialog*	pDlg 		= new PrintDialog( pParent);
//STRIP001 	USHORT			i;
//STRIP001 	USHORT			nTabCount	= pDoc->GetTableCount();
//STRIP001 	long			nDocPageMax = 0;
//STRIP001 
//STRIP001 	for ( i=0; i<nTabCount; i++ )
//STRIP001 	{
//STRIP001 		ScPrintFunc aPrintFunc( pDocShell, pPrinter, i );
//STRIP001 		nDocPageMax += aPrintFunc.GetTotalPages();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nDocPageMax > 0 )
//STRIP001 	{
//STRIP001 		aStrRange = '1';
//STRIP001 		if ( nDocPageMax > 1 )
//STRIP001 		{
//STRIP001 			aStrRange += '-';
//STRIP001 			aStrRange += String::CreateFromInt32( nDocPageMax );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	pDlg->SetRangeText	( aStrRange );
//STRIP001 	pDlg->EnableRange	( PRINTDIALOG_ALL );
//STRIP001 	pDlg->EnableRange	( PRINTDIALOG_SELECTION );
//STRIP001 	pDlg->EnableRange	( PRINTDIALOG_RANGE );
//STRIP001 	pDlg->SetFirstPage	( 1 );
//STRIP001 	pDlg->SetMinPage	( 1 );
//STRIP001 	pDlg->SetLastPage	( (USHORT)nDocPageMax );
//STRIP001 	pDlg->SetMaxPage	( (USHORT)nDocPageMax );
//STRIP001 	pDlg->EnableCollate	();
//STRIP001 
//STRIP001 	return pDlg;
//STRIP001 }

//STRIP001 SfxTabPage* ScTabViewShell::CreatePrintOptionsPage( Window *pParent, const SfxItemSet &rOptions )
//STRIP001 {
//STRIP001 	return ScTpPrintOptions::Create( pParent, rOptions );
//STRIP001 }

//STRIP001 void __EXPORT ScTabViewShell::PreparePrint( PrintDialog* pPrintDialog )
//STRIP001 {
//STRIP001 	ScDocShell* pDocShell = GetViewData()->GetDocShell();
//STRIP001 
//STRIP001 	SfxViewShell::PreparePrint( pPrintDialog );
//STRIP001 	pDocShell->PreparePrint( pPrintDialog, &GetViewData()->GetMarkData() );
//STRIP001 }

//STRIP001 ErrCode ScTabViewShell::DoPrint( SfxPrinter *pPrinter,
//STRIP001 								 PrintDialog *pPrintDialog, BOOL bSilent )
//STRIP001 {
//STRIP001 	//	#72527# if SID_PRINTDOCDIRECT is executed and there's a selection,
//STRIP001 	//	ask if only the selection should be printed
//STRIP001 
//STRIP001 	const ScMarkData& rMarkData = GetViewData()->GetMarkData();
//STRIP001 	if ( !pPrintDialog && !bSilent && ( rMarkData.IsMarked() || rMarkData.IsMultiMarked() ) )
//STRIP001 	{
//STRIP001 		SvxPrtQryBox aQuery( GetDialogParent() );
//STRIP001 		short nBtn = aQuery.Execute();
//STRIP001 
//STRIP001 		if ( nBtn == RET_CANCEL )
//STRIP001 			return ERRCODE_IO_ABORT;
//STRIP001 
//STRIP001 		if ( nBtn == RET_OK )
//STRIP001 			bPrintSelected = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	//	SfxViewShell::DoPrint calls Print (after StartJob etc.)
//STRIP001 	ErrCode nRet = SfxViewShell::DoPrint( pPrinter, pPrintDialog, bSilent );
//STRIP001 
//STRIP001 	bPrintSelected = FALSE;
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

//STRIP001 USHORT __EXPORT ScTabViewShell::Print( SfxProgress& rProgress,
//STRIP001 									   PrintDialog* pPrintDialog )
//STRIP001 {
//STRIP001 	ScDocShell* pDocShell = GetViewData()->GetDocShell();
//STRIP001 	pDocShell->GetDocument()->SetPrintOptions();	// Optionen aus OFA am Printer setzen
//STRIP001 
//STRIP001 	//	get the list of affected sheets (using the "only selected sheets" option) before SfxViewShell::Print
//STRIP001 	ScPrintOptions aOptions;
//STRIP001 	const SfxItemSet& rOptionSet = pDocShell->GetPrinter()->GetOptions();
//STRIP001 	const SfxPoolItem* pItem;
//STRIP001 	BOOL bHasOptions = ( rOptionSet.GetItemState(SID_SCPRINTOPTIONS, FALSE, &pItem) == SFX_ITEM_SET );
//STRIP001 	if (bHasOptions)
//STRIP001 		aOptions = ((const ScTpPrintItem*)pItem)->GetPrintOptions();
//STRIP001 	else
//STRIP001 		aOptions = SC_MOD()->GetPrintOptions();		// use configuration
//STRIP001 	BOOL bAllTabs = aOptions.GetAllSheets();
//STRIP001 
//STRIP001 	uno::Sequence<sal_Int32> aSheets;
//STRIP001 	USHORT nTabCount = pDocShell->GetDocument()->GetTableCount();
//STRIP001 	USHORT nPrinted = 0;
//STRIP001 	const ScMarkData& rMarkData = GetViewData()->GetMarkData();
//STRIP001 	for ( USHORT nTab=0; nTab<nTabCount; nTab++ )
//STRIP001 		if ( bAllTabs || rMarkData.GetTableSelect(nTab) )
//STRIP001 		{
//STRIP001 			aSheets.realloc( nPrinted + 1 );
//STRIP001 			aSheets[nPrinted] = nTab;
//STRIP001 			++nPrinted;
//STRIP001 		}
//STRIP001 
//STRIP001 	uno::Sequence < beans::PropertyValue > aProps(1);
//STRIP001 	aProps[0].Name=::rtl::OUString::createFromAscii("PrintSheets");
//STRIP001 	aProps[0].Value <<= aSheets;
//STRIP001 	SetAdditionalPrintOptions( aProps );
//STRIP001 
//STRIP001 	//	... use aSheets here ...
//STRIP001 
//STRIP001 	SfxViewShell::Print( rProgress, pPrintDialog );
//STRIP001 	pDocShell->Print( rProgress, pPrintDialog, &GetViewData()->GetMarkData(),
//STRIP001 						GetDialogParent(), bPrintSelected );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

/*N*/ void ScTabViewShell::StopEditShell()
/*N*/ {
/*N*/ 	if ( pEditShell != NULL && !bDontSwitch )
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		SetEditShell(NULL, FALSE );
/*N*/ }

//------------------------------------------------------------------

// close handler to ensure function of dialog:

//STRIP001 IMPL_LINK( ScTabViewShell, SimpleRefClose, String*, pResult )
//STRIP001 {
//STRIP001 	ScSimpleRefDlgWrapper::SetAutoReOpen( TRUE );
//STRIP001 	return 0;
//STRIP001 }

// handlers to call UNO listeners:

//STRIP001 ScTabViewObj* lcl_GetViewObj( ScTabViewShell& rShell )
//STRIP001 {
//STRIP001 	ScTabViewObj* pRet = NULL;
//STRIP001 	SfxViewFrame* pViewFrame = rShell.GetViewFrame();
//STRIP001 	if (pViewFrame)
//STRIP001 	{
//STRIP001 		SfxFrame* pFrame = pViewFrame->GetFrame();
//STRIP001 		if (pFrame)
//STRIP001 		{
//STRIP001 			uno::Reference<frame::XController> xController = pFrame->GetController();
//STRIP001 			if (xController.is())
//STRIP001 				pRet = ScTabViewObj::getImplementation( xController );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return pRet;
//STRIP001 }

//STRIP001 IMPL_LINK( ScTabViewShell, SimpleRefDone, String*, pResult )
//STRIP001 {
//STRIP001 	ScTabViewObj* pImp = lcl_GetViewObj( *this );
//STRIP001 	if ( pImp && pResult )
//STRIP001 		pImp->RangeSelDone( *pResult );
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 IMPL_LINK( ScTabViewShell, SimpleRefAborted, String*, pResult )
//STRIP001 {
//STRIP001 	ScTabViewObj* pImp = lcl_GetViewObj( *this );
//STRIP001 	if ( pImp && pResult )
//STRIP001 		pImp->RangeSelAborted( *pResult );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( ScTabViewShell, SimpleRefChange, String*, pResult )
//STRIP001 {
//STRIP001 	ScTabViewObj* pImp = lcl_GetViewObj( *this );
//STRIP001 	if ( pImp && pResult )
//STRIP001 		pImp->RangeSelChanged( *pResult );
//STRIP001 	return 0;
//STRIP001 }

/*N*/ void ScTabViewShell::StartSimpleRefDialog(
/*N*/ 			const String& rTitle, const String& rInitVal, BOOL bCloseOnButtonUp )
/*N*/ {
		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 	SfxViewFrame* pViewFrm = GetViewFrame();
//STRIP001 /*?*/ 	USHORT nId = ScSimpleRefDlgWrapper::GetChildWindowId();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	SC_MOD()->SetRefDialog( nId, TRUE, pViewFrm );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	ScSimpleRefDlgWrapper* pWnd = (ScSimpleRefDlgWrapper*)pViewFrm->GetChildWindow( nId );
//STRIP001 /*?*/ 	if (pWnd)
//STRIP001 /*?*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 		pWnd->SetCloseHdl( LINK( this, ScTabViewShell, SimpleRefClose ) );
//STRIP001 /*?*/ 		pWnd->SetUnoLinks( LINK( this, ScTabViewShell, SimpleRefDone ),
//STRIP001 /*?*/ 						   LINK( this, ScTabViewShell, SimpleRefAborted ),
//STRIP001 /*?*/ 						   LINK( this, ScTabViewShell, SimpleRefChange ) );
//STRIP001 /*?*/ 		pWnd->SetRefString( rInitVal );
//STRIP001 /*?*/ 		pWnd->SetFlags( bCloseOnButtonUp );
//STRIP001 /*?*/ 		pWnd->SetAutoReOpen( FALSE );
//STRIP001 /*?*/ 		Window* pWin = pWnd->GetWindow();
//STRIP001 /*?*/ 		pWin->SetText( rTitle );
//STRIP001 /*?*/ 		pWnd->StartRefInput();
//STRIP001 /*?*/ 	}
/*N*/ }

/*N*/ void ScTabViewShell::StopSimpleRefDialog()
/*N*/ {
/*N*/ 	SfxViewFrame* pViewFrm = GetViewFrame();
/*N*/ 	USHORT nId = ScSimpleRefDlgWrapper::GetChildWindowId();
/*N*/ 
/*N*/ 	ScSimpleRefDlgWrapper* pWnd = (ScSimpleRefDlgWrapper*)pViewFrm->GetChildWindow( nId );
/*N*/ 	if (pWnd)
/*N*/ 	{
/*N*/ 		Window* pWin = pWnd->GetWindow();
/*N*/ 		if (pWin && pWin->IsSystemWindow())
/*N*/ 			((SystemWindow*)pWin)->Close();		// calls abort handler
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------

//STRIP001 BOOL ScTabViewShell::TabKeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 
//STRIP001 	SfxViewFrame* pThisFrame = GetViewFrame();
//STRIP001 	if ( pThisFrame->GetChildWindow( SID_OPENDLG_FUNCTION ) )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	KeyCode aCode   = rKEvt.GetKeyCode();
//STRIP001 	BOOL bShift     = aCode.IsShift();
//STRIP001 	BOOL bControl   = aCode.IsMod1();
//STRIP001 	BOOL bAlt	    = aCode.IsMod2();
//STRIP001 	USHORT nCode	= aCode.GetCode();
//STRIP001 	BOOL bUsed	    = FALSE;
//STRIP001 	BOOL bInPlace   = pScMod->IsEditMode(); 	// Editengine bekommt alles
//STRIP001 	BOOL bAnyEdit   = pScMod->IsInputMode();	// nur Zeichen & Backspace
//STRIP001 	BOOL bDraw		= IsDrawTextEdit();
//STRIP001 
//STRIP001 	HideNoteMarker();	// Notiz-Anzeige
//STRIP001 
//STRIP001 	BOOL bHideCursor = ( nCode == KEY_RETURN && bInPlace ) ||
//STRIP001 							nCode == KEY_TAB;
//STRIP001 
//STRIP001 	if (bHideCursor)
//STRIP001 		HideAllCursors();
//STRIP001 
//STRIP001 	ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 	if ( pDoc )
//STRIP001 		pDoc->KeyInput( rKEvt );	// TimerDelays etc.
//STRIP001 
//STRIP001 	if( bInPlace )
//STRIP001 	{
//STRIP001 		bUsed = pScMod->InputKeyEvent( rKEvt );			// Eingabe
//STRIP001 		if( !bUsed )
//STRIP001 			bUsed = SfxViewShell::KeyInput( rKEvt );	// Acceleratoren
//STRIP001 	}
//STRIP001 	else if( bAnyEdit )
//STRIP001 	{
//STRIP001 		BOOL bIsType = FALSE;
//STRIP001 		USHORT nModi = aCode.GetModifier();
//STRIP001 		USHORT nGroup = aCode.GetGroup();
//STRIP001 
//STRIP001 		if ( nGroup == KEYGROUP_NUM || nGroup == KEYGROUP_ALPHA || nGroup == 0 )
//STRIP001 			if ( !bControl && !bAlt )
//STRIP001 				bIsType = TRUE;
//STRIP001 
//STRIP001 		if ( nGroup == KEYGROUP_MISC )
//STRIP001 			switch ( nCode )
//STRIP001 			{
//STRIP001 				case KEY_RETURN:
//STRIP001 					bIsType = bControl && !bAlt;		// Control, Shift-Control-Return
//STRIP001 					if ( !bIsType && nModi == 0 )
//STRIP001 					{
//STRIP001 						//	Will der InputHandler auch ein einfaches Return?
//STRIP001 
//STRIP001 						ScInputHandler* pHdl = pScMod->GetInputHdl(this);
//STRIP001 						bIsType = pHdl && pHdl->TakesReturn();
//STRIP001 					}
//STRIP001 					break;
//STRIP001 				case KEY_SPACE:
//STRIP001 					bIsType = !bControl && !bAlt;		// ohne Modifier oder Shift-Space
//STRIP001 					break;
//STRIP001 				case KEY_ESCAPE:
//STRIP001 				case KEY_BACKSPACE:
//STRIP001 					bIsType = (nModi == 0);	// nur ohne Modifier
//STRIP001 					break;
//STRIP001 				default:
//STRIP001 					bIsType = TRUE;
//STRIP001 			}
//STRIP001 
//STRIP001 		if( bIsType )
//STRIP001 			bUsed = pScMod->InputKeyEvent( rKEvt );		// Eingabe
//STRIP001 
//STRIP001 		if( !bUsed )
//STRIP001 			bUsed = SfxViewShell::KeyInput( rKEvt );	// Acceleratoren
//STRIP001 
//STRIP001 		if ( !bUsed && !bIsType && nCode != KEY_RETURN )	// Eingabe nochmal hinterher
//STRIP001 			bUsed = pScMod->InputKeyEvent( rKEvt );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		//	#51889# Spezialfall: Copy/Cut bei Mehrfachselektion -> Fehlermeldung
//STRIP001 		//	(Slot ist disabled, SfxViewShell::KeyInput wuerde also kommentarlos verschluckt)
//STRIP001 		KeyFuncType eFunc = aCode.GetFunction();
//STRIP001 		if ( eFunc == KEYFUNC_COPY || eFunc == KEYFUNC_CUT )
//STRIP001 		{
//STRIP001 			ScRange aDummy;
//STRIP001 			if ( !GetViewData()->GetSimpleArea( aDummy ) )
//STRIP001 			{
//STRIP001 				ErrorMessage(STR_NOMULTISELECT);
//STRIP001 				bUsed = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if (!bUsed)
//STRIP001 			bUsed = SfxViewShell::KeyInput( rKEvt );			// Acceleratoren
//STRIP001 
//STRIP001 		//	#74696# during inplace editing, some slots are handled by the
//STRIP001 		//	container app and are executed during Window::KeyInput.
//STRIP001 		//	-> don't pass keys to input handler that would be used there
//STRIP001 		//	but should call slots instead.
//STRIP001 		BOOL bParent = ( GetViewFrame()->ISA(SfxInPlaceFrame) && eFunc != KEYFUNC_DONTKNOW );
//STRIP001 
//STRIP001 		if( !bUsed && !bDraw && nCode != KEY_RETURN && !bParent )
//STRIP001 			bUsed = pScMod->InputKeyEvent( rKEvt, TRUE );		// Eingabe
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!bInPlace && !bUsed && !bDraw)
//STRIP001 	{
//STRIP001 		switch (nCode)
//STRIP001 		{
//STRIP001 			case KEY_RETURN:
//STRIP001 				{
//STRIP001 					BOOL bNormal = !bControl && !bAlt;
//STRIP001 					if ( !bAnyEdit && bNormal )
//STRIP001 					{
//STRIP001 						//	je nach Optionen mit Enter in den Edit-Modus schalten
//STRIP001 
//STRIP001 						const ScInputOptions& rOpt = pScMod->GetInputOptions();
//STRIP001 						if ( rOpt.GetEnterEdit() )
//STRIP001 						{
//STRIP001 							pScMod->SetInputMode( SC_INPUT_TABLE );
//STRIP001 							bUsed = TRUE;
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					BOOL bEditReturn = bControl && !bShift; 		// An Edit-Engine weiter
//STRIP001 					if ( !bUsed && !bEditReturn )
//STRIP001 					{
//STRIP001 						HideAllCursors();
//STRIP001 
//STRIP001 						BYTE nMode = SC_ENTER_NORMAL;
//STRIP001 						if ( bShift && bControl )
//STRIP001 							nMode = SC_ENTER_MATRIX;
//STRIP001 						else if ( bAlt )
//STRIP001 							nMode = SC_ENTER_BLOCK;
//STRIP001 						pScMod->InputEnterHandler(nMode);
//STRIP001 
//STRIP001 						if (nMode == SC_ENTER_NORMAL)
//STRIP001 						{
//STRIP001 							if( bShift )
//STRIP001 								GetViewData()->GetDispatcher().Execute( SID_CURSORENTERUP,
//STRIP001 											SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD );
//STRIP001 							else
//STRIP001 								GetViewData()->GetDispatcher().Execute( SID_CURSORENTERDOWN,
//STRIP001 											SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD );
//STRIP001 						}
//STRIP001 						else
//STRIP001 							UpdateInputHandler(TRUE);
//STRIP001 
//STRIP001 						ShowAllCursors();
//STRIP001 
//STRIP001 						//	hier kein UpdateInputHandler, weil bei Referenzeingabe auf ein
//STRIP001 						//	anderes Dokument diese ViewShell nicht die ist, auf der eingegeben
//STRIP001 						//	wird!
//STRIP001 
//STRIP001 						bUsed = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Alt-Cursortasten hart codiert, weil Alt nicht konfigurierbar ist
//STRIP001 
//STRIP001 	if ( !bUsed && bAlt && !bControl )
//STRIP001 	{
//STRIP001 		USHORT nSlotId = 0;
//STRIP001 		switch (nCode)
//STRIP001 		{
//STRIP001 			case KEY_UP:
//STRIP001 				ModifyCellSize( DIR_TOP, bShift );
//STRIP001 				bUsed = TRUE;
//STRIP001 				break;
//STRIP001 			case KEY_DOWN:
//STRIP001 				ModifyCellSize( DIR_BOTTOM, bShift );
//STRIP001 				bUsed = TRUE;
//STRIP001 				break;
//STRIP001 			case KEY_LEFT:
//STRIP001 				ModifyCellSize( DIR_LEFT, bShift );
//STRIP001 				bUsed = TRUE;
//STRIP001 				break;
//STRIP001 			case KEY_RIGHT:
//STRIP001 				ModifyCellSize( DIR_RIGHT, bShift );
//STRIP001 				bUsed = TRUE;
//STRIP001 				break;
//STRIP001 			case KEY_PAGEUP:
//STRIP001 				nSlotId = bShift ? SID_CURSORPAGELEFT_SEL : SID_CURSORPAGELEFT_;
//STRIP001 				break;
//STRIP001 			case KEY_PAGEDOWN:
//STRIP001 				nSlotId = bShift ? SID_CURSORPAGERIGHT_SEL : SID_CURSORPAGERIGHT_;
//STRIP001 				break;
//STRIP001 		}
//STRIP001 		if ( nSlotId )
//STRIP001 		{
//STRIP001 			GetViewData()->GetDispatcher().Execute( nSlotId, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD );
//STRIP001 			bUsed = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bHideCursor)
//STRIP001 		ShowAllCursors();
//STRIP001 
//STRIP001 	return bUsed;
//STRIP001 }

//STRIP001 BOOL ScTabViewShell::SfxKeyInput(const KeyEvent& rKeyEvent)
//STRIP001 {
//STRIP001 	return SfxViewShell::KeyInput( rKeyEvent );
//STRIP001 }

//STRIP001 FASTBOOL __EXPORT ScTabViewShell::KeyInput( const KeyEvent &rKeyEvent )
//STRIP001 {
//STRIP001 //	return SfxViewShell::KeyInput( rKeyEvent );
//STRIP001 	return TabKeyInput( rKeyEvent );
//STRIP001 }

//------------------------------------------------------------------

//	SfxViewShell( pViewFrame, SFX_VIEW_MAXIMIZE_FIRST | SFX_VIEW_DISABLE_ACCELS ),

#define __INIT_ScTabViewShell \
	SfxViewShell( pViewFrame, SFX_VIEW_MAXIMIZE_FIRST | SFX_VIEW_CAN_PRINT | SFX_VIEW_HAS_PRINTOPTIONS ), \
	nDrawSfxId(0),				\
	nCtrlSfxId(USHRT_MAX),		\
	eCurOST(OST_NONE),			\
	nFormSfxId(USHRT_MAX),		\
	pCellShell(NULL),			\
	pPageBreakShell(NULL),		\
	pDrawShell(NULL),			\
	pDrawFormShell(NULL),		\
	pOleObjectShell(NULL),		\
	pChartShell(NULL),			\
	pGraphicShell(NULL),		\
	pDrawTextShell(NULL),		\
	pEditShell(NULL),			\
	pPivotShell(NULL),			\
	pAuditingShell(NULL),		\
	pFormShell(NULL),			\
	pInputHandler(NULL),		\
	pCurFrameLine(NULL),		\
	bActiveChartSh(FALSE),		\
	bActiveDrawSh(FALSE),		\
	bActiveDrawTextSh(FALSE),	\
	bActiveGraphicSh(FALSE),	\
	bActivePivotSh(FALSE),		\
	bActiveAuditingSh(FALSE),	\
	bActiveDrawFormSh(FALSE),	\
	bActiveOleObjectSh(FALSE),	\
	bDontSwitch(FALSE),			\
	bInFormatDialog(FALSE),		\
	bPrintSelected(FALSE),		\
	bReadOnly(FALSE),			\
	pScSbxObject(NULL),			\
	bChartAreaValid(FALSE),		\
	bChartDlgIsEdit(FALSE),		\
	pDialogDPObject(NULL),		\
    nCurRefDlgId(0),            \
    pNavSettings(NULL),         \
	aTarget( this ),			\
	pAccessibilityBroadcaster(NULL)


//------------------------------------------------------------------

/*N*/ void ScTabViewShell::Construct( BYTE nForceDesignMode )
/*N*/ {
/*N*/ 	SfxApplication* pSfxApp  = SFX_APP();
/*N*/ 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
/*N*/ 	ScDocument* pDoc = pDocSh->GetDocument();
/*N*/ 
/*N*/ 	bReadOnly = pDocSh->IsReadOnly();
/*N*/ 
/*N*/ 	SetName( String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("View")) );	// fuer SBX
/*N*/ 	Color aColBlack( COL_BLACK );
/*N*/ //	SetPool( &pSfxApp->GetPool() );
/*N*/ 	SetPool( &SC_MOD()->GetPool() );
/*N*/ 	SetWindow( GetActiveWin() );
/*N*/ 
/*N*/ 	pCurFrameLine	= new SvxBorderLine( &aColBlack, 20, 0, 0 );
/*N*/ 	pPivotSource	= new ScArea;
/*N*/ 	StartListening(*GetViewData()->GetDocShell());
/*N*/ 	StartListening(*GetViewFrame());
/*N*/ 	StartListening(*pSfxApp,TRUE);		// SfxViewShell hoert da schon zu?
/*N*/ 
/*N*/ 	SfxViewFrame* pFirst = SfxViewFrame::GetFirst(pDocSh);
/*N*/ 	BOOL bFirstView = !pFirst
/*N*/ 		  || (pFirst == GetViewFrame() && !SfxViewFrame::GetNext(*pFirst,pDocSh));
/*N*/ 
/*N*/ 	if ( pDocSh->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 		Rectangle aVisArea = ((SfxInPlaceObject*)pDocSh)->GetVisArea();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		USHORT nVisTab = pDoc->GetVisibleTab();
//STRIP001 /*?*/ 		if (!pDoc->HasTable(nVisTab))
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			nVisTab = 0;
//STRIP001 /*?*/ 			pDoc->SetVisibleTab(nVisTab);
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		SetTabNo( nVisTab );
//STRIP001 /*?*/ 		GetViewData()->SetScreenPos( aVisArea.TopLeft() );		// richtige Stelle zeigen
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if ( GetViewFrame()->ISA(SfxInPlaceFrame) )				// inplace
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			pDocSh->SetInplace( TRUE );				// schon so initialisiert
//STRIP001 /*?*/ 			if (pDoc->IsEmbedded())
//STRIP001 /*?*/ 				pDoc->ResetEmbedded();				// keine blaue Markierung
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		else if ( bFirstView )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			pDocSh->SetInplace( FALSE );
//STRIP001 /*?*/ 			GetViewData()->SetZoom(								// PPT neu berechnen
//STRIP001 /*?*/ 							GetViewData()->GetZoomX(),
//STRIP001 /*?*/ 							GetViewData()->GetZoomY());
//STRIP001 /*?*/ 			if (!pDoc->IsEmbedded())
//STRIP001 /*?*/ 				pDoc->SetEmbedded( aVisArea );					// VisArea markieren
//STRIP001 /*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	// ViewInputHandler
/*N*/ 	//	#48721# jeder Task hat neuerdings sein eigenes InputWindow,
/*N*/ 	//	darum muesste eigentlich entweder jeder Task seinen InputHandler bekommen,
/*N*/ 	//	oder das InputWindow muesste sich beim App-InputHandler anmelden, wenn der
/*N*/ 	//	Task aktiv wird, oder das InputWindow muesste sich den InputHandler selbst
/*N*/ 	//	anlegen (dann immer ueber das InputWindow suchen, und nur wenn das nicht da
/*N*/ 	//	ist, den InputHandler von der App nehmen).
/*N*/ 	//	Als Sofortloesung bekommt erstmal jede View ihren Inputhandler, das gibt
/*N*/ 	//	nur noch Probleme, wenn zwei Views in einem Task-Fenster sind.
/*N*/ 
/*N*/ 	pInputHandler = new ScInputHandler;
/*N*/ 
/*N*/ 	// Alte Version:
/*N*/ 	//	if ( !GetViewFrame()->ISA(SfxTopViewFrame) )		// OLE oder Plug-In
/*N*/ 	//		pInputHandler = new ScInputHandler;
/*N*/ 
/*N*/ 			//	FormShell vor MakeDrawView anlegen, damit die DrawView auf jeden Fall
/*N*/ 			//	an der FormShell angemeldet werden kann
/*N*/ 			//	Gepusht wird die FormShell im ersten Activate
/*N*/ 	pFormShell = new FmFormShell(this);
/*N*/ 
/*N*/ 			//	DrawView darf nicht im TabView - ctor angelegt werden,
/*N*/ 			//	wenn die ViewShell noch nicht kostruiert ist...
/*N*/ 	if (pDoc->GetDrawLayer())
/*N*/ 		MakeDrawView( nForceDesignMode );
/*N*/ 	ViewOptionsHasChanged(FALSE);	// legt auch evtl. DrawView an
/*N*/ 
/*N*/ 	SetUndoManager( pDocSh->GetUndoManager() );
/*N*/ 	pFormShell->SetUndoManager( pDocSh->GetUndoManager() );
/*N*/ 	SetRepeatTarget( &aTarget );
/*N*/ 	pFormShell->SetRepeatTarget( &aTarget );
/*N*/ 	SetHelpId( HID_SCSHELL_TABVWSH );
/*N*/ 
/*N*/ 	if ( bFirstView )
/*N*/ 	{	// erste View?
/*N*/ 
/*N*/ 		//	Tabellen anhaengen? (nicht bei OLE)
/*N*/ 		if ( pDocSh->IsEmpty() &&
/*N*/ 				pDocSh->GetCreateMode() != SFX_CREATE_MODE_EMBEDDED )
/*N*/ 		{
/*N*/ 			USHORT nInitTabCount = 3;							//!	konfigurierbar !!!
/*N*/ 			for (USHORT i=1; i<nInitTabCount; i++)
/*N*/ 				pDoc->MakeTable(i);
/*N*/ 
/*N*/ 			pDocSh->ResetEmpty();			// #i6232# make sure this is done only once
/*N*/ 		}
/*N*/ 
//STRIP001 /*?*/        ScExtDocOptions* pExtOpt = pDoc->GetExtDocOptions();
//STRIP001 /*?*/ 		if (pExtOpt)
//STRIP001 /*?*/ 		{ 
//STRIP001 /*?*/ 			GetViewData()->ReadExtOptions(*pExtOpt);		//	Excel-View Optionen
//STRIP001 /*?*/ 			SetTabNo( GetViewData()->GetTabNo(), TRUE );
//STRIP001 /*?*/             pExtOpt->SetChanged( FALSE );
//STRIP001 /*?*/ 			//!	alles von ReadUserData auch hier
//STRIP001 /*?*/ 		}
/*N*/ 
/*N*/ 		//	Link-Update nicht verschachteln
/*N*/ 		if ( pDocSh->GetCreateMode() != SFX_CREATE_MODE_INTERNAL &&
/*N*/              pDocSh->IsUpdateEnabled() )  // #105575#; update only in the first creation of the ViewShell
/*N*/ 		{
/*N*/ 			BOOL bLink = FALSE;									// Links updaten
/*N*/ 			USHORT nTabCount = pDoc->GetTableCount();
/*N*/ 			for (USHORT i=0; i<nTabCount && !bLink; i++)
/*N*/ 				if (pDoc->IsLinked(i))
/*N*/ 					bLink = TRUE;
/*N*/ 			if (!bLink)
/*N*/ 				if (pDoc->HasDdeLinks() || pDoc->HasAreaLinks())
/*N*/ 					bLink = TRUE;
/*N*/ 			if (bLink)
/*N*/ 			{
/*N*/ 				if ( !pFirst )
/*N*/ 					pFirst = GetViewFrame();
/*N*/ 
/*N*/ 				if(SC_MOD()->GetCurRefDlgId()==0)
/*N*/ 				{
/*N*/ 						pFirst->GetDispatcher()->Execute( SID_UPDATETABLINKS,
/*N*/ 											SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
/*N*/ 				}
/*N*/ 			}
/*N*/ 
/*N*/ 			BOOL bReImport = FALSE;								// importierte Daten aktualisieren
/*N*/ 			ScDBCollection* pDBColl = pDoc->GetDBCollection();
/*N*/ 			if ( pDBColl )
/*N*/ 			{
/*N*/ 				USHORT nCount = pDBColl->GetCount();
/*N*/ 				for (USHORT i=0; i<nCount && !bReImport; i++)
/*N*/ 				{
/*N*/ 					ScDBData* pData = (*pDBColl)[i];
/*N*/ 					if ( pData->IsStripData() &&
/*N*/ 							pData->HasImportParam() && !pData->HasImportSelection() )
/*N*/ 						bReImport = TRUE;
/*N*/ 				}
/*N*/ 			}
/*N*/ 			if (bReImport)
/*N*/ 			{
/*?*/ 				if ( !pFirst )
/*?*/ 					pFirst = GetViewFrame();
/*?*/ 				if(SC_MOD()->GetCurRefDlgId()==0)
/*?*/ 				{
/*?*/ 					pFirst->GetDispatcher()->Execute( SID_REIMPORT_AFTER_LOAD,
/*?*/ 											SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
/*?*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	UpdateAutoFillMark();
/*N*/ 
/*N*/ 	// ScDispatchProviderInterceptor registers itself in ctor
/*N*/ 	xDisProvInterceptor = new ScDispatchProviderInterceptor( this );
/*N*/ 
/*N*/ 	bFirstActivate = TRUE; // NavigatorUpdate aufschieben bis Activate()
/*N*/ 
/*N*/     // #105575#; update only in the first creation of the ViewShell
/*N*/     pDocSh->SetUpdateEnabled(FALSE);
/*N*/ }

//------------------------------------------------------------------

//STRIP001 ScTabViewShell::ScTabViewShell( SfxViewFrame* pViewFrame,
//STRIP001 								const ScTabViewShell& rWin ) :
//STRIP001 	__INIT_ScTabViewShell,
//STRIP001 	ScDBFunc( &pViewFrame->GetWindow(), rWin, this )
//STRIP001 {
//STRIP001 	RTL_LOGFILE_CONTEXT_AUTHOR ( aLog, "sc", "nn93723", "ScTabViewShell::ScTabViewShell" );
//STRIP001 
//STRIP001 	Construct();
//STRIP001 
//STRIP001 	UpdatePageBreakData();
//STRIP001 
//STRIP001 	uno::Reference<frame::XFrame> xFrame = pViewFrame->GetFrame()->GetFrameInterface();
//STRIP001 	if (xFrame.is())
//STRIP001 		xFrame->setComponent( uno::Reference<awt::XWindow>(), new ScTabViewObj( this ) );
//STRIP001 
//STRIP001 	SetCurSubShell(OST_Cell);
//STRIP001 }

//------------------------------------------------------------------

/*N*/ ScTabViewShell::ScTabViewShell( SfxViewFrame* pViewFrame,
/*N*/ 								SfxViewShell* pOldSh ) :
/*N*/ 	__INIT_ScTabViewShell,
/*N*/ 	ScDBFunc( &pViewFrame->GetWindow(), (ScDocShell&)*pViewFrame->GetObjectShell(), this )
/*N*/ {
/*N*/ 	RTL_LOGFILE_CONTEXT_AUTHOR ( aLog, "sc", "nn93723", "ScTabViewShell::ScTabViewShell" );
/*N*/ 
/*N*/ 	const ScAppOptions&	rAppOpt = SC_MOD()->GetAppOptions();
/*N*/ 
/*N*/ 	//	if switching back from print preview,
/*N*/ 	//	restore the view settings that were active when creating the preview
/*N*/ 	//	#89897# ReadUserData must not happen from ctor, because the view's edit window
/*N*/ 	//	has to be shown by the sfx. ReadUserData is deferred until the first Activate call.
/*N*/ 	//	#106334# old DesignMode state from form layer must be restored, too
/*N*/ 
/*N*/ 	BYTE nForceDesignMode = SC_FORCEMODE_NONE;
/*N*/ 	if ( pOldSh && pOldSh->ISA( ScPreviewShell ) )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 ScPreviewShell* pPreviewShell = ((ScPreviewShell*)pOldSh);
//STRIP001 /*?*/ 		aPendingUserData = pPreviewShell->GetSourceData();		// used in Activate
//STRIP001 /*?*/ 		nForceDesignMode = pPreviewShell->GetSourceDesignMode();
/*N*/ 	}
/*N*/ 
/*N*/ 	Construct( nForceDesignMode );
/*N*/ 
/*N*/ 	if ( GetViewData()->GetDocShell()->IsPreview() )
/*N*/ 	{
/*?*/ 		//	preview for template dialog: always show whole page
/*?*/ 		SetZoomType( SVX_ZOOM_WHOLEPAGE );		// zoom value is recalculated at next Resize
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		Fraction aFract( rAppOpt.GetZoom(), 100 );
/*N*/ 		SetZoom( aFract, aFract );
/*N*/ 		SetZoomType( rAppOpt.GetZoomType() );
/*N*/ 	}
/*N*/ 
/*N*/ 	uno::Reference<frame::XFrame> xFrame = pViewFrame->GetFrame()->GetFrameInterface();
/*N*/ 	if (xFrame.is())
/*N*/ 		xFrame->setComponent( uno::Reference<awt::XWindow>(), new ScTabViewObj( this ) );
/*N*/ 
/*N*/ 	SetCurSubShell(OST_Cell);
/*N*/ }

#undef __INIT_ScTabViewShell

//------------------------------------------------------------------

/*N*/ __EXPORT ScTabViewShell::~ScTabViewShell()
/*N*/ {
/*N*/ 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
/*N*/ 	EndListening(*pDocSh);
/*N*/ 	EndListening(*GetViewFrame());
/*N*/ 
/*N*/ 	SC_MOD()->ViewShellGone(this);
/*N*/ 
/*N*/ 	RemoveSubShell();			// alle
/*N*/ 	SetWindow(0);
/*N*/ 
/*N*/ 	//	#54104# alles auf NULL, falls aus dem TabView-dtor noch darauf zugegriffen wird
/*N*/ 	//!	(soll eigentlich nicht !??!?!)
/*N*/ 
/*N*/ 	DELETEZ(pCellShell);
/*N*/ 	DELETEZ(pPageBreakShell);
/*N*/ 	DELETEZ(pDrawShell);
/*N*/ 	DELETEZ(pDrawFormShell);
/*N*/ 	DELETEZ(pOleObjectShell);
/*N*/ 	DELETEZ(pChartShell);
/*N*/ 	DELETEZ(pGraphicShell);
/*N*/ 	DELETEZ(pDrawTextShell);
/*N*/ 	DELETEZ(pEditShell);
/*N*/ 	DELETEZ(pPivotShell);
/*N*/ 	DELETEZ(pAuditingShell);
/*N*/ 	DELETEZ(pCurFrameLine);
/*N*/ 	DELETEZ(pInputHandler);
/*N*/ 	DELETEZ(pPivotSource);
/*N*/ 	DELETEZ(pDialogDPObject);
/*N*/     DELETEZ(pNavSettings);
/*N*/ 
/*N*/ 	DELETEZ(pFormShell);
/*N*/ 	DELETEZ(pAccessibilityBroadcaster);
/*N*/ }

//------------------------------------------------------------------

//STRIP001 void ScTabViewShell::SetDialogDPObject( const ScDPObject* pObj )
//STRIP001 {
//STRIP001 	delete pDialogDPObject;
//STRIP001 	if (pObj)
//STRIP001 		pDialogDPObject = new ScDPObject( *pObj );
//STRIP001 	else
//STRIP001 		pDialogDPObject = NULL;
//STRIP001 }

//------------------------------------------------------------------

//STRIP001 void ScTabViewShell::FillFieldData( ScHeaderFieldData& rData )
//STRIP001 {
//STRIP001 	ScDocShell* pDocShell = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	pDoc->GetName( nTab, rData.aTabName );
//STRIP001 
//STRIP001 	rData.aTitle		= pDocShell->GetTitle();
//STRIP001 	const INetURLObject& rURLObj = pDocShell->GetMedium()->GetURLObject();
//STRIP001 	rData.aLongDocName	= rURLObj.GetMainURL( INetURLObject::DECODE_UNAMBIGUOUS );
//STRIP001 	if ( rData.aLongDocName.Len() )
//STRIP001 		rData.aShortDocName = rURLObj.GetName( INetURLObject::DECODE_UNAMBIGUOUS );
//STRIP001 	else
//STRIP001 		rData.aShortDocName = rData.aLongDocName = rData.aTitle;
//STRIP001 	rData.nPageNo		= 1;
//STRIP001 	rData.nTotalPages	= 99;
//STRIP001 
//STRIP001 	//	eNumType kennt der Dialog selber
//STRIP001 }

//------------------------------------------------------------------

//STRIP001 void ScTabViewShell::SetChartArea( const ScRangeListRef& rSource, const Rectangle& rDest )
//STRIP001 {
//STRIP001 	bChartAreaValid	= TRUE;
//STRIP001 	aChartSource	= rSource;
//STRIP001 	aChartPos		= rDest;
//STRIP001 	nChartDestTab	= GetViewData()->GetTabNo();
//STRIP001 }

//STRIP001 void ScTabViewShell::ResetChartArea()
//STRIP001 {
//STRIP001 	bChartAreaValid = FALSE;
//STRIP001 }

//STRIP001 BOOL ScTabViewShell::GetChartArea( ScRangeListRef& rSource, Rectangle& rDest, USHORT& rTab ) const
//STRIP001 {
//STRIP001 	rSource	= aChartSource;
//STRIP001 	rDest	= aChartPos;
//STRIP001 	rTab	= nChartDestTab;
//STRIP001 	return bChartAreaValid;
//STRIP001 }

//STRIP001 BOOL ScTabViewShell::IsChartDlgEdit() const
//STRIP001 {
//STRIP001 	return bChartDlgIsEdit;
//STRIP001 }

//STRIP001 const String& ScTabViewShell::GetEditChartName() const
//STRIP001 {
//STRIP001 	return aEditChartName;
//STRIP001 }

//STRIP001 ScNavigatorSettings* ScTabViewShell::GetNavigatorSettings()
//STRIP001 {
//STRIP001     if( !pNavSettings )
//STRIP001         pNavSettings = new ScNavigatorSettings;
//STRIP001     return pNavSettings;
//STRIP001 }


//------------------------------------------------------------------

//STRIP001 void ScTabViewShell::ExecTbx( SfxRequest& rReq )
//STRIP001 {
//STRIP001 	const SfxItemSet* pReqArgs = rReq.GetArgs();
//STRIP001 	USHORT nSlot = rReq.GetSlot();
//STRIP001 	const SfxPoolItem* pItem = NULL;
//STRIP001 	if ( pReqArgs )
//STRIP001 		pReqArgs->GetItemState( nSlot, TRUE, &pItem );
//STRIP001 
//STRIP001 	switch ( nSlot )
//STRIP001 	{
//STRIP001 		case SID_TBXCTL_INSERT:
//STRIP001 			if ( pItem )
//STRIP001 				nInsertCtrlState = ((const SfxUInt16Item*)pItem)->GetValue();
//STRIP001 			break;
//STRIP001 		case SID_TBXCTL_INSCELLS:
//STRIP001 			if ( pItem )
//STRIP001 				nInsCellsCtrlState = ((const SfxUInt16Item*)pItem)->GetValue();
//STRIP001 			break;
//STRIP001 		case SID_TBXCTL_INSOBJ:
//STRIP001 			if ( pItem )
//STRIP001 				nInsObjCtrlState = ((const SfxUInt16Item*)pItem)->GetValue();
//STRIP001 			break;
//STRIP001 		default:
//STRIP001 			DBG_ERROR("Slot im Wald");
//STRIP001 	}
//STRIP001 	GetViewFrame()->GetBindings().Invalidate( nSlot );
//STRIP001 }

/*N*/ void ScTabViewShell::GetTbxState( SfxItemSet& rSet )
/*N*/ {
/*N*/ 	rSet.Put( SfxUInt16Item( SID_TBXCTL_INSERT,   nInsertCtrlState ) );
/*N*/ 	rSet.Put( SfxUInt16Item( SID_TBXCTL_INSCELLS, nInsCellsCtrlState ) );
/*N*/ 
/*N*/ 	//	ohne installiertes Chart darf Chart nicht Default sein...
/*N*/ 	if ( nInsObjCtrlState == SID_DRAW_CHART && !SvtModuleOptions().IsChart() )
/*N*/ 		nInsObjCtrlState = SID_INSERT_OBJECT;
/*N*/ 
/*N*/ 	rSet.Put( SfxUInt16Item( SID_TBXCTL_INSOBJ,   nInsObjCtrlState ) );
/*N*/ }





}
