/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_viewfun2.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:40:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#include "scitems.hxx"
// auto strip #include <bf_svx/eeitem.hxx>
#define ITEMID_FIELD EE_FEATURE_FIELD

#define _SVSTDARR_STRINGS
// auto strip #include <bf_svx/boxitem.hxx>
// auto strip #include <bf_svx/fontitem.hxx>
// auto strip #include <bf_svx/scripttypeitem.hxx>
// auto strip #include <bf_svx/srchitem.hxx>
// auto strip #include <bf_svx/linkmgr.hxx>
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #include <bf_sfx2/docfilt.hxx>
// auto strip #include <bf_sfx2/docfile.hxx>
// auto strip #include <bf_sfx2/objitem.hxx>
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #include <svtools/stritem.hxx>
// auto strip #include <svtools/zforlist.hxx>
// auto strip #include <svtools/svstdarr.hxx>
// auto strip #include <vcl/msgbox.hxx>
// auto strip #include <vcl/sound.hxx>
// auto strip #include <vcl/waitobj.hxx>

// auto strip #include "viewfunc.hxx"

#include "bf_sc.hrc"
#include "globstr.hrc"

// auto strip #include "arealink.hxx"
// auto strip #include "attrib.hxx"
// auto strip #include "autoform.hxx"
// auto strip #include "cell.hxx"					// EnterAutoSum
// auto strip #include "compiler.hxx"
// auto strip #include "docfunc.hxx"
// auto strip #include "docpool.hxx"
#include "docsh.hxx"
// auto strip #include "global.hxx"
// auto strip #include "patattr.hxx"
// auto strip #include "printfun.hxx"
// auto strip #include "rangenam.hxx"
// auto strip #include "rangeutl.hxx"
// auto strip #include "refundo.hxx"
// auto strip #include "tablink.hxx"
#include "tabvwsh.hxx"
// auto strip #include "uiitems.hxx"
// auto strip #include "undoblk.hxx"
// auto strip #include "undocell.hxx"
// auto strip #include "undotab.hxx"
// auto strip #include "sizedev.hxx"
// auto strip #include "editable.hxx"
namespace binfilter {


// STATIC DATA ---------------------------------------------------------------


//----------------------------------------------------------------------------

//STRIP001 BOOL ScViewFunc::AdjustBlockHeight( BOOL bPaint, ScMarkData* pMarkData )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	if (!pMarkData)
//STRIP001 		pMarkData = &GetViewData()->GetMarkData();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	USHORT* pRanges = new USHORT[MAXROW+1];
//STRIP001 	USHORT nRangeCnt = pMarkData->GetMarkRowRanges( pRanges );
//STRIP001 	if (!nRangeCnt)
//STRIP001 	{
//STRIP001 		pRanges[0] = pRanges[1] = GetViewData()->GetCurY();
//STRIP001 		nRangeCnt = 1;
//STRIP001 	}
//STRIP001 
//STRIP001 	double nPPTX = GetViewData()->GetPPTX();
//STRIP001 	double nPPTY = GetViewData()->GetPPTY();
//STRIP001 	Fraction aZoomX = GetViewData()->GetZoomX();
//STRIP001 	Fraction aZoomY = GetViewData()->GetZoomY();
//STRIP001 
//STRIP001 	ScSizeDeviceProvider aProv(pDocSh);
//STRIP001 	if (aProv.IsPrinter())
//STRIP001 	{
//STRIP001 		nPPTX = aProv.GetPPTX();
//STRIP001 		nPPTY = aProv.GetPPTY();
//STRIP001 		aZoomX = aZoomY = Fraction( 1, 1 );
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bAnyChanged = FALSE;
//STRIP001 	USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 	for (USHORT nTab=0; nTab<nTabCount; nTab++)
//STRIP001 	{
//STRIP001 		if (pMarkData->GetTableSelect(nTab))
//STRIP001 		{
//STRIP001 			USHORT* pOneRange = pRanges;
//STRIP001 			BOOL bChanged = FALSE;
//STRIP001 			USHORT nPaintY;
//STRIP001 			for (USHORT nRangeNo=0; nRangeNo<nRangeCnt; nRangeNo++)
//STRIP001 			{
//STRIP001 				USHORT nStartNo = *(pOneRange++);
//STRIP001 				USHORT nEndNo = *(pOneRange++);
//STRIP001 				if (pDoc->SetOptimalHeight( nStartNo, nEndNo, nTab, 0, aProv.GetDevice(),
//STRIP001 											nPPTX, nPPTY, aZoomX, aZoomY, FALSE ))
//STRIP001 				{
//STRIP001 					if (!bChanged)
//STRIP001 						nPaintY = nStartNo;
//STRIP001 					bAnyChanged = bChanged = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if ( bPaint && bChanged )
//STRIP001 				pDocSh->PostPaint( 0, nPaintY, nTab, MAXCOL, MAXROW, nTab,
//STRIP001 													PAINT_GRID | PAINT_LEFT );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	delete[] pRanges;
//STRIP001 
//STRIP001 	if ( bPaint && bAnyChanged )
//STRIP001 		pDocSh->UpdateOle(GetViewData());
//STRIP001 
//STRIP001 	return bAnyChanged;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL ScViewFunc::AdjustRowHeight( USHORT nStartRow, USHORT nEndRow, BOOL bPaint )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	double nPPTX = GetViewData()->GetPPTX();
//STRIP001 	double nPPTY = GetViewData()->GetPPTY();
//STRIP001 	Fraction aZoomX = GetViewData()->GetZoomX();
//STRIP001 	Fraction aZoomY = GetViewData()->GetZoomY();
//STRIP001 	USHORT nOldPixel;
//STRIP001 	if (nStartRow == nEndRow)
//STRIP001 		nOldPixel = (USHORT) (pDoc->GetRowHeight(nStartRow,nTab) * nPPTY);
//STRIP001 
//STRIP001 	ScSizeDeviceProvider aProv(pDocSh);
//STRIP001 	if (aProv.IsPrinter())
//STRIP001 	{
//STRIP001 		nPPTX = aProv.GetPPTX();
//STRIP001 		nPPTY = aProv.GetPPTY();
//STRIP001 		aZoomX = aZoomY = Fraction( 1, 1 );
//STRIP001 	}
//STRIP001 	BOOL bChanged = pDoc->SetOptimalHeight( nStartRow, nEndRow, nTab, 0, aProv.GetDevice(),
//STRIP001 											nPPTX, nPPTY, aZoomX, aZoomY, FALSE );
//STRIP001 
//STRIP001 	if (bChanged && ( nStartRow == nEndRow ))
//STRIP001 	{
//STRIP001 		USHORT nNewPixel = (USHORT) (pDoc->GetRowHeight(nStartRow,nTab) * nPPTY);
//STRIP001 		if ( nNewPixel == nOldPixel )
//STRIP001 			bChanged = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bPaint && bChanged )
//STRIP001 		pDocSh->PostPaint( 0, nStartRow, nTab, MAXCOL, MAXROW, nTab,
//STRIP001 											PAINT_GRID | PAINT_LEFT );
//STRIP001 
//STRIP001 	return bChanged;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 enum ScAutoSum
//STRIP001 {
//STRIP001 	ScAutoSumNone = 0,
//STRIP001 	ScAutoSumData,
//STRIP001 	ScAutoSumSum
//STRIP001 };


//STRIP001 ScAutoSum lcl_IsAutoSumData( ScDocument* pDoc, USHORT nCol, USHORT nRow,
//STRIP001 		USHORT nTab, ScDirection eDir, USHORT& nExtend )
//STRIP001 {
//STRIP001 	ScBaseCell* pCell;
//STRIP001 	pDoc->GetCell( nCol, nRow, nTab, pCell );
//STRIP001 	if ( pCell && pCell->HasValueData() )
//STRIP001 	{
//STRIP001 		if ( pCell->GetCellType() == CELLTYPE_FORMULA )
//STRIP001 		{
//STRIP001 			ScTokenArray* pCode = ((ScFormulaCell*)pCell)->GetCode();
//STRIP001 			if ( pCode && pCode->GetOuterFuncOpCode() == ocSum )
//STRIP001 			{
//STRIP001 				if ( pCode->GetAdjacentExtendOfOuterFuncRefs( nExtend,
//STRIP001 						ScAddress( nCol, nRow, nTab ), eDir ) )
//STRIP001 					return ScAutoSumSum;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		return ScAutoSumData;
//STRIP001 	}
//STRIP001 	return ScAutoSumNone;
//STRIP001 }


//----------------------------------------------------------------------------

#define SC_AUTOSUM_MAXCOUNT		20

//STRIP001 ScAutoSum lcl_SeekAutoSumData( ScDocument* pDoc, USHORT& nCol, USHORT& nRow,
//STRIP001 		USHORT nTab, ScDirection eDir, USHORT& nExtend )
//STRIP001 {
//STRIP001 	USHORT nCount = 0;
//STRIP001 	while (nCount < SC_AUTOSUM_MAXCOUNT)
//STRIP001 	{
//STRIP001 		if ( eDir == DIR_TOP )
//STRIP001 		{
//STRIP001 			if (nRow)
//STRIP001 				--nRow;
//STRIP001 			else
//STRIP001 				return ScAutoSumNone;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if (nCol)
//STRIP001 				--nCol;
//STRIP001 			else
//STRIP001 				return ScAutoSumNone;
//STRIP001 		}
//STRIP001 		ScAutoSum eSum;
//STRIP001 		if ( (eSum = lcl_IsAutoSumData(
//STRIP001 				pDoc, nCol, nRow, nTab, eDir, nExtend )) != ScAutoSumNone )
//STRIP001 			return eSum;
//STRIP001 		++nCount;
//STRIP001 	}
//STRIP001 	return ScAutoSumNone;
//STRIP001 }

#undef SC_AUTOSUM_MAXCOUNT


//----------------------------------------------------------------------------

//STRIP001 BOOL ScViewFunc::GetAutoSumArea( ScRangeList& rRangeList )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 
//STRIP001 	USHORT nCol = GetViewData()->GetCurX();
//STRIP001 	USHORT nRow = GetViewData()->GetCurY();
//STRIP001 
//STRIP001 	USHORT nStartCol = nCol;
//STRIP001 	USHORT nStartRow = nRow;
//STRIP001 	USHORT nEndCol	 = nCol;
//STRIP001 	USHORT nEndRow	 = nRow;
//STRIP001 	USHORT nSeekCol	 = nCol;
//STRIP001 	USHORT nSeekRow	 = nRow;
//STRIP001 	USHORT nExtend;		// wird per Reference gueltig bei ScAutoSumSum
//STRIP001 
//STRIP001 	BOOL bCol = FALSE;
//STRIP001 	BOOL bRow = FALSE;
//STRIP001 
//STRIP001 	ScAutoSum eSum;
//STRIP001 	if ( nRow
//STRIP001 			&& ((eSum = lcl_IsAutoSumData( pDoc, nCol, nRow-1, nTab,
//STRIP001 				DIR_TOP, nExtend )) == ScAutoSumData )
//STRIP001 			&& ((eSum = lcl_IsAutoSumData( pDoc, nCol, nRow-1, nTab,
//STRIP001 				DIR_LEFT, nExtend )) == ScAutoSumData )
//STRIP001 		)
//STRIP001 	{
//STRIP001 		bRow = TRUE;
//STRIP001 		nSeekRow = nRow - 1;
//STRIP001 	}
//STRIP001 	else if ( nCol && (eSum = lcl_IsAutoSumData( pDoc, nCol-1, nRow, nTab,
//STRIP001 			DIR_LEFT, nExtend )) == ScAutoSumData )
//STRIP001 	{
//STRIP001 		bCol = TRUE;
//STRIP001 		nSeekCol = nCol - 1;
//STRIP001 	}
//STRIP001 	else if (eSum = lcl_SeekAutoSumData( pDoc, nCol, nSeekRow, nTab, DIR_TOP, nExtend ))
//STRIP001 		bRow = TRUE;
//STRIP001 	else if (eSum = lcl_SeekAutoSumData( pDoc, nSeekCol, nRow, nTab, DIR_LEFT, nExtend ))
//STRIP001 		bCol = TRUE;
//STRIP001 
//STRIP001 	if ( bCol || bRow )
//STRIP001 	{
//STRIP001 		if ( bRow )
//STRIP001 		{
//STRIP001 			nStartRow = nSeekRow;		// nSeekRow evtl. per Reference angepasst
//STRIP001 			if ( eSum == ScAutoSumSum )
//STRIP001 				nEndRow = nStartRow;		// nur Summen summieren
//STRIP001 			else
//STRIP001 				nEndRow = nRow - 1;		// Datenbereich evtl. nach unten erweitern
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nStartCol = nSeekCol;		// nSeekCol evtl. per Reference angepasst
//STRIP001 			if ( eSum == ScAutoSumSum )
//STRIP001 				nEndCol = nStartCol;		// nur Summen summieren
//STRIP001 			else
//STRIP001 				nEndCol = nCol - 1;		// Datenbereich evtl. nach rechts erweitern
//STRIP001 		}
//STRIP001 		BOOL bContinue = FALSE;
//STRIP001 		do
//STRIP001 		{
//STRIP001 			if ( eSum == ScAutoSumData )
//STRIP001 			{
//STRIP001 				if ( bRow )
//STRIP001 				{
//STRIP001 					while ( nStartRow && lcl_IsAutoSumData(	pDoc, nCol,
//STRIP001 							nStartRow-1, nTab, DIR_TOP, nExtend ) == eSum )
//STRIP001 						--nStartRow;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					while ( nStartCol && lcl_IsAutoSumData( pDoc, nStartCol-1,
//STRIP001 							nRow, nTab, DIR_LEFT, nExtend ) == eSum )
//STRIP001 						--nStartCol;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			rRangeList.Append(
//STRIP001 				ScRange( nStartCol, nStartRow, nTab, nEndCol, nEndRow, nTab ) );
//STRIP001 			if ( eSum == ScAutoSumSum )
//STRIP001 			{
//STRIP001 				if ( bRow )
//STRIP001 				{
//STRIP001 					USHORT nTmp = nEndRow = nExtend;
//STRIP001 					ScAutoSum eSkip;
//STRIP001 					while ( (eSkip = lcl_IsAutoSumData( pDoc, nCol,
//STRIP001 							nEndRow, nTab, DIR_TOP, nExtend )) == ScAutoSumData
//STRIP001 							&& nEndRow )
//STRIP001 						--nEndRow;
//STRIP001 					if ( eSkip == ScAutoSumSum && nEndRow < nTmp )
//STRIP001 					{
//STRIP001 						bContinue = TRUE;
//STRIP001 						nStartRow = nEndRow;
//STRIP001 					}
//STRIP001 					else
//STRIP001 						bContinue = FALSE;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					USHORT nTmp = nEndCol = nExtend;
//STRIP001 					ScAutoSum eSkip;
//STRIP001 					while ( (eSkip = lcl_IsAutoSumData( pDoc, nEndCol,
//STRIP001 							nRow, nTab, DIR_LEFT, nExtend )) == ScAutoSumData
//STRIP001 							&& nEndCol )
//STRIP001 						--nEndCol;
//STRIP001 					if ( eSkip == ScAutoSumSum && nEndCol < nTmp )
//STRIP001 					{
//STRIP001 						bContinue = TRUE;
//STRIP001 						nStartCol = nEndCol;
//STRIP001 					}
//STRIP001 					else
//STRIP001 						bContinue = FALSE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		} while ( bContinue );
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::EnterAutoSum(const ScRangeList& rRangeList, sal_Bool bSubTotal)		// Block mit Summen fuellen
//STRIP001 {
//STRIP001 	ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 	String aRef;
//STRIP001 	rRangeList.Format( aRef, SCA_VALID, pDoc );
//STRIP001 
//STRIP001 	String aFormula = '=';
//STRIP001 	ScFunctionMgr* pFuncMgr = ScGlobal::GetStarCalcFunctionMgr();
//STRIP001     ScFuncDesc* pDesc = NULL;
//STRIP001     if (!bSubTotal)
//STRIP001         pDesc = pFuncMgr->Get( SC_OPCODE_SUM );
//STRIP001     else
//STRIP001         pDesc = pFuncMgr->Get( SC_OPCODE_SUB_TOTAL );
//STRIP001 	if ( pDesc && pDesc->pFuncName )
//STRIP001 	{
//STRIP001 		aFormula += *pDesc->pFuncName;
//STRIP001         if (bSubTotal)
//STRIP001             aFormula.AppendAscii(RTL_CONSTASCII_STRINGPARAM( "(9;" ));
//STRIP001         else
//STRIP001             aFormula += '(';
//STRIP001 		aFormula += aRef;
//STRIP001 		aFormula += ')';
//STRIP001 	}
//STRIP001 
//STRIP001 	EnterBlock( aFormula, NULL );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::EnterBlock( const String& rString, const EditTextObject* pData )
//STRIP001 {
//STRIP001 	//	Mehrfachselektion vorher abfragen...
//STRIP001 
//STRIP001 	USHORT nCol = GetViewData()->GetCurX();
//STRIP001 	USHORT nRow = GetViewData()->GetCurY();
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 	if ( rMark.IsMultiMarked() )
//STRIP001 	{
//STRIP001 		rMark.MarkToSimple();
//STRIP001 		if ( rMark.IsMultiMarked() )
//STRIP001 		{		// "Einfuegen auf Mehrfachselektion nicht moeglich"
//STRIP001 			ErrorMessage(STR_MSSG_PASTEFROMCLIP_0);
//STRIP001 
//STRIP001 			//	insert into single cell
//STRIP001 			if ( pData )
//STRIP001 				EnterData( nCol, nRow, nTab, pData );
//STRIP001 			else
//STRIP001 				EnterData( nCol, nRow, nTab, rString );
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 	String aNewStr = rString;
//STRIP001 	if ( pData )
//STRIP001 	{
//STRIP001 		const ScPatternAttr* pOldPattern = pDoc->GetPattern( nCol, nRow, nTab );
//STRIP001 		ScTabEditEngine aEngine( *pOldPattern, pDoc->GetEnginePool() );
//STRIP001 		aEngine.SetText(*pData);
//STRIP001 
//STRIP001 		ScEditAttrTester aTester( &aEngine );
//STRIP001 		if (!aTester.NeedsObject())
//STRIP001 		{
//STRIP001 			aNewStr = aEngine.GetText();
//STRIP001 			pData = NULL;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Einfuegen per PasteFromClip
//STRIP001 
//STRIP001 	WaitObject aWait( GetFrameWin() );
//STRIP001 
//STRIP001 	ScAddress aPos( nCol, nRow, nTab );
//STRIP001 
//STRIP001 	ScDocument* pInsDoc = new ScDocument( SCDOCMODE_CLIP );
//STRIP001 	pInsDoc->ResetClip( pDoc, nTab );
//STRIP001 
//STRIP001 	if (aNewStr.GetChar(0) == '=')						// Formel ?
//STRIP001 	{
//STRIP001 		//	SetString geht nicht, weil in Clipboard-Dokumenten nicht kompiliert wird!
//STRIP001 		ScFormulaCell* pFCell = new ScFormulaCell( pDoc, aPos, aNewStr );
//STRIP001 		pInsDoc->PutCell( nCol, nRow, nTab, pFCell );
//STRIP001 	}
//STRIP001 	else if ( pData )
//STRIP001 		pInsDoc->PutCell( nCol, nRow, nTab, new ScEditCell( pData, pDoc, NULL ) );
//STRIP001 	else
//STRIP001 		pInsDoc->SetString( nCol, nRow, nTab, aNewStr );
//STRIP001 
//STRIP001 	pInsDoc->SetClipArea( ScRange(aPos) );
//STRIP001 	// auf Block einfuegen, mit Undo etc.
//STRIP001 	if ( PasteFromClip( IDF_CONTENTS, pInsDoc, PASTE_NOFUNC, FALSE, FALSE,
//STRIP001 			FALSE, INS_NONE, IDF_ATTRIB ) )
//STRIP001 	{
//STRIP001 		const SfxUInt32Item* pItem = (SfxUInt32Item*) pInsDoc->GetAttr(
//STRIP001 			nCol, nRow, nTab, ATTR_VALUE_FORMAT );
//STRIP001 		if ( pItem )
//STRIP001 		{	// Numberformat setzen wenn inkompatibel
//STRIP001 			// MarkData wurde bereits in PasteFromClip MarkToSimple'ed
//STRIP001 			ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 			ScRange aRange;
//STRIP001 			rMark.GetMarkArea( aRange );
//STRIP001 			ScPatternAttr* pPattern = new ScPatternAttr( pDoc->GetPool() );
//STRIP001 			pPattern->GetItemSet().Put( *pItem );
//STRIP001 			short nNewType = pDoc->GetFormatTable()->GetType( pItem->GetValue() );
//STRIP001 			pDoc->ApplyPatternIfNumberformatIncompatible( aRange, rMark,
//STRIP001 				*pPattern, nNewType );
//STRIP001 			delete pPattern;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pInsDoc;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::PaintWidthHeight( BOOL bColumns, USHORT nStart, USHORT nEnd )
//STRIP001 {
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 
//STRIP001 	USHORT nParts = PAINT_GRID;
//STRIP001 	USHORT nStartCol = 0;
//STRIP001 	USHORT nStartRow = 0;
//STRIP001 	USHORT nEndCol = MAXCOL;			// fuer Test auf Merge
//STRIP001 	USHORT nEndRow = MAXROW;
//STRIP001 	if ( bColumns )
//STRIP001 	{
//STRIP001 		nParts |= PAINT_TOP;
//STRIP001 		nStartCol = nStart;
//STRIP001 		nEndCol = nEnd;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nParts |= PAINT_LEFT;
//STRIP001 		nStartRow = nStart;
//STRIP001 		nEndRow = nEnd;
//STRIP001 	}
//STRIP001 	if (pDoc->HasAttrib( nStartCol,nStartRow,nTab, nEndCol,nEndRow,nTab,
//STRIP001 							HASATTR_MERGED | HASATTR_OVERLAPPED ))
//STRIP001 	{
//STRIP001 		nStartCol = 0;
//STRIP001 		nStartRow = 0;
//STRIP001 	}
//STRIP001 	GetViewData()->GetDocShell()->PostPaint( nStartCol,nStartRow,nTab, MAXCOL,MAXROW,nTab, nParts );
//STRIP001 }


//----------------------------------------------------------------------------
//	manueller Seitenumbruch

//STRIP001 void ScViewFunc::InsertPageBreak( BOOL bColumn, BOOL bRecord, const ScAddress* pPos,
//STRIP001 									BOOL bSetModified )
//STRIP001 {
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	ScAddress aCursor;
//STRIP001 	if (pPos)
//STRIP001 		aCursor = *pPos;
//STRIP001 	else
//STRIP001 		aCursor = ScAddress( GetViewData()->GetCurX(), GetViewData()->GetCurY(), nTab );
//STRIP001 
//STRIP001 	BOOL bSuccess = GetViewData()->GetDocShell()->GetDocFunc().
//STRIP001 						InsertPageBreak( bColumn, aCursor, bRecord, bSetModified, FALSE );
//STRIP001 
//STRIP001 	if ( bSuccess && bSetModified )
//STRIP001 		UpdatePageBreakData( TRUE );	// fuer PageBreak-Modus
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::DeletePageBreak( BOOL bColumn, BOOL bRecord, const ScAddress* pPos,
//STRIP001 									BOOL bSetModified )
//STRIP001 {
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	ScAddress aCursor;
//STRIP001 	if (pPos)
//STRIP001 		aCursor = *pPos;
//STRIP001 	else
//STRIP001 		aCursor = ScAddress( GetViewData()->GetCurX(), GetViewData()->GetCurY(), nTab );
//STRIP001 
//STRIP001 	BOOL bSuccess = GetViewData()->GetDocShell()->GetDocFunc().
//STRIP001 						RemovePageBreak( bColumn, aCursor, bRecord, bSetModified, FALSE );
//STRIP001 
//STRIP001 	if ( bSuccess && bSetModified )
//STRIP001 		UpdatePageBreakData( TRUE );	// fuer PageBreak-Modus
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::RemoveManualBreaks()
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	BOOL bUndo(pDoc->IsUndoEnabled());
//STRIP001 
//STRIP001 	if (bUndo)
//STRIP001 	{
//STRIP001 		ScDocument* pUndoDoc = new ScDocument( SCDOCMODE_UNDO );
//STRIP001 		pUndoDoc->InitUndo( pDoc, nTab, nTab, TRUE, TRUE );
//STRIP001 		pDoc->CopyToDocument( 0,0,nTab, MAXCOL,MAXROW,nTab, IDF_NONE, FALSE, pUndoDoc );
//STRIP001 		pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 								new ScUndoRemoveBreaks( pDocSh, nTab, pUndoDoc ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	pDoc->RemoveManualBreaks(nTab);
//STRIP001 	pDoc->UpdatePageBreaks(nTab);
//STRIP001 
//STRIP001 	UpdatePageBreakData( TRUE );
//STRIP001 	pDocSh->SetDocumentModified();
//STRIP001 	pDocSh->PostPaint( 0,0,nTab, MAXCOL,MAXROW,nTab, PAINT_GRID );
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::SetPrintZoom(USHORT nScale, USHORT nPages)
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	pDocSh->SetPrintZoom( nTab, nScale, nPages );
//STRIP001 }

//STRIP001 void ScViewFunc::AdjustPrintZoom()
//STRIP001 {
//STRIP001 	ScRange aRange;
//STRIP001 	if ( !GetViewData()->GetSimpleArea( aRange ) )
//STRIP001 		GetViewData()->GetMarkData().GetMultiMarkArea( aRange );
//STRIP001 	GetViewData()->GetDocShell()->AdjustPrintZoom( aRange );
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::SetPrintRanges( const String* pPrint,
//STRIP001 								const String* pRepCol, const String* pRepRow,
//STRIP001 								BOOL bAddPrint )
//STRIP001 {
//STRIP001 	//	on all selected tables
//STRIP001 
//STRIP001 	ScDocShell* pDocSh	= GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc	= pDocSh->GetDocument();
//STRIP001 	USHORT nTabCount	= pDoc->GetTableCount();
//STRIP001 	ScMarkData& rMark	= GetViewData()->GetMarkData();
//STRIP001 	USHORT nTab;
//STRIP001 	BOOL bUndo (pDoc->IsUndoEnabled());
//STRIP001 
//STRIP001 	ScPrintRangeSaver* pOldRanges = pDoc->CreatePrintRangeSaver();
//STRIP001 
//STRIP001 	for (nTab=0; nTab<nTabCount; nTab++)
//STRIP001 		if (rMark.GetTableSelect(nTab))
//STRIP001 		{
//STRIP001 			ScRange aRange( 0,0,nTab );
//STRIP001 
//STRIP001 			USHORT nAdd = 0;
//STRIP001 			if ( bAddPrint )
//STRIP001 				nAdd = pDoc->GetPrintRangeCount( nTab );
//STRIP001 
//STRIP001 			//	print ranges
//STRIP001 
//STRIP001 			if ( pPrint )
//STRIP001 			{
//STRIP001 				if ( !pPrint->Len() )
//STRIP001 					pDoc->SetPrintRangeCount( nTab, nAdd );		// remove / leave unchanged
//STRIP001 				else
//STRIP001 				{
//STRIP001 					USHORT nTCount = pPrint->GetTokenCount();
//STRIP001 					pDoc->SetPrintRangeCount( nTab, nTCount + nAdd );
//STRIP001 					for (USHORT i=0; i<nTCount; i++)
//STRIP001 					{
//STRIP001 						String aToken = pPrint->GetToken(i);
//STRIP001 						if ( aRange.ParseAny( aToken, pDoc ) & SCA_VALID )
//STRIP001 							pDoc->SetPrintRange( nTab, i + nAdd, aRange );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else		//	use selection (print range is always set)
//STRIP001 			{
//STRIP001 				if ( GetViewData()->GetSimpleArea( aRange ) )
//STRIP001 				{
//STRIP001 					pDoc->SetPrintRangeCount( nTab, nAdd + 1 );
//STRIP001 					pDoc->SetPrintRange( nTab, nAdd, aRange );
//STRIP001 				}
//STRIP001 				else if ( rMark.IsMultiMarked() )
//STRIP001 				{
//STRIP001 					rMark.MarkToMulti();
//STRIP001 					ScRangeListRef aList( new ScRangeList );
//STRIP001 					rMark.FillRangeListWithMarks( aList, FALSE );
//STRIP001 					USHORT nCnt = (USHORT) aList->Count();
//STRIP001 					if ( nCnt )
//STRIP001 					{
//STRIP001 						pDoc->SetPrintRangeCount( nTab, nCnt + nAdd );
//STRIP001 						ScRangePtr pR;
//STRIP001 						USHORT i;
//STRIP001 						for ( pR = aList->First(), i=0; i < nCnt;
//STRIP001 							  pR = aList->Next(), i++ )
//STRIP001 						{
//STRIP001 							pDoc->SetPrintRange( nTab, i + nAdd, *pR );
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			//	repeat columns
//STRIP001 
//STRIP001 			if ( pRepCol )
//STRIP001 			{
//STRIP001 				if ( !pRepCol->Len() )
//STRIP001 					pDoc->SetRepeatColRange( nTab, NULL );
//STRIP001 				else
//STRIP001 					if ( aRange.ParseAny( *pRepCol, pDoc ) & SCA_VALID )
//STRIP001 						pDoc->SetRepeatColRange( nTab, &aRange );
//STRIP001 			}
//STRIP001 
//STRIP001 			//	repeat rows
//STRIP001 
//STRIP001 			if ( pRepRow )
//STRIP001 			{
//STRIP001 				if ( !pRepRow->Len() )
//STRIP001 					pDoc->SetRepeatRowRange( nTab, NULL );
//STRIP001 				else
//STRIP001 					if ( aRange.ParseAny( *pRepRow, pDoc ) & SCA_VALID )
//STRIP001 						pDoc->SetRepeatRowRange( nTab, &aRange );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 	//	undo (for all tables)
//STRIP001 	if (bUndo)
//STRIP001 	{
//STRIP001 		USHORT nCurTab = GetViewData()->GetTabNo();
//STRIP001 		ScPrintRangeSaver* pNewRanges = pDoc->CreatePrintRangeSaver();
//STRIP001 		pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 					new ScUndoPrintRange( pDocSh, nCurTab, pOldRanges, pNewRanges ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	//	update page breaks
//STRIP001 
//STRIP001 	for (nTab=0; nTab<nTabCount; nTab++)
//STRIP001 		if (rMark.GetTableSelect(nTab))
//STRIP001 			ScPrintFunc( pDocSh, pDocSh->GetPrinter(), nTab ).UpdatePages();
//STRIP001 
//STRIP001 	SfxBindings& rBindings = GetViewData()->GetBindings();
//STRIP001 	rBindings.Invalidate( SID_DELETE_PRINTAREA );
//STRIP001 
//STRIP001 	pDocSh->SetDocumentModified();
//STRIP001 }

//----------------------------------------------------------------------------
//	Zellen zusammenfassen

/*M*/ BOOL ScViewFunc::TestMergeCells()			// Vorab-Test (fuer Menue)
/*M*/ {
/*M*/ 	//	simple test: TRUE if there's a selection but no multi selection
/*M*/ 
/*M*/ 	const ScMarkData& rMark = GetViewData()->GetMarkData();
/*M*/ 	if ( rMark.IsMultiMarked() )
/*M*/ 	{
/*M*/ 		ScMarkData aNewMark( rMark );	// use local copy for MarkToSimple
/*M*/ 		aNewMark.MarkToSimple();
/*M*/ 		return aNewMark.IsMarked() && !aNewMark.IsMultiMarked();
/*M*/ 	}
/*M*/ 	else
/*M*/ 		return rMark.IsMarked();
/*M*/ }


//----------------------------------------------------------------------------

//STRIP001 BOOL ScViewFunc::MergeCells( BOOL bApi, BOOL& rDoContents, BOOL bRecord )
//STRIP001 {
//STRIP001 	//	Editable- und Verschachtelungs-Abfrage muss vorneweg sein (auch in DocFunc),
//STRIP001 	//	damit dann nicht die Inhalte-QueryBox kommt
//STRIP001 	ScEditableTester aTester( this );
//STRIP001 	if (!aTester.IsEditable())
//STRIP001 	{
//STRIP001 		ErrorMessage(aTester.GetMessageId());
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 	rMark.MarkToSimple();
//STRIP001 	if (!rMark.IsMarked())
//STRIP001 	{
//STRIP001 		ErrorMessage(STR_NOMULTISELECT);
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 
//STRIP001 	ScRange aMarkRange;
//STRIP001 	rMark.GetMarkArea( aMarkRange );
//STRIP001 	USHORT nStartCol = aMarkRange.aStart.Col();
//STRIP001 	USHORT nStartRow = aMarkRange.aStart.Row();
//STRIP001 	USHORT nStartTab = aMarkRange.aStart.Tab();
//STRIP001 	USHORT nEndCol = aMarkRange.aEnd.Col();
//STRIP001 	USHORT nEndRow = aMarkRange.aEnd.Row();
//STRIP001 	USHORT nEndTab = aMarkRange.aEnd.Tab();
//STRIP001 	if ( nStartCol == nEndCol && nStartRow == nEndRow )
//STRIP001 	{
//STRIP001 		// nichts zu tun
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pDoc->HasAttrib( nStartCol, nStartRow, nStartTab, nEndCol, nEndRow, nEndTab,
//STRIP001 							HASATTR_MERGED | HASATTR_OVERLAPPED ) )
//STRIP001 	{		// "Zusammenfassen nicht verschachteln !"
//STRIP001 		ErrorMessage(STR_MSSG_MERGECELLS_0);
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bOk = TRUE;
//STRIP001 	BOOL bNeedContents = FALSE;
//STRIP001 
//STRIP001 	if ( !pDoc->IsBlockEmpty( nStartTab, nStartCol,nStartRow+1, nStartCol,nEndRow ) ||
//STRIP001 		 !pDoc->IsBlockEmpty( nStartTab, nStartCol+1,nStartRow, nEndCol,nEndRow ) )
//STRIP001 	{
//STRIP001 		bNeedContents = TRUE;
//STRIP001 		if (!bApi)
//STRIP001 		{
//STRIP001 			MessBox aBox( GetViewData()->GetDialogParent(),
//STRIP001 							WinBits(WB_YES_NO_CANCEL | WB_DEF_NO),
//STRIP001 							ScGlobal::GetRscString( STR_MSSG_DOSUBTOTALS_0 ),
//STRIP001 							ScGlobal::GetRscString( STR_MERGE_NOTEMPTY ) );
//STRIP001 			USHORT nRetVal = aBox.Execute();
//STRIP001 
//STRIP001 			if ( nRetVal == RET_YES )
//STRIP001 				rDoContents = TRUE;
//STRIP001 			else if ( nRetVal == RET_CANCEL )
//STRIP001 				bOk = FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bOk)
//STRIP001 	{
//STRIP001 		HideCursor();
//STRIP001 		bOk = pDocSh->GetDocFunc().MergeCells( aMarkRange, rDoContents, bRecord, bApi );
//STRIP001 		ShowCursor();
//STRIP001 
//STRIP001 		if (bOk)
//STRIP001 		{
//STRIP001 			SetCursor( nStartCol, nStartRow );
//STRIP001 			//DoneBlockMode( FALSE);
//STRIP001 			Unmark();
//STRIP001 
//STRIP001 			pDocSh->UpdateOle(GetViewData());
//STRIP001 			UpdateInputLine();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bOk;
//STRIP001 }


//----------------------------------------------------------------------------

/*N*/ BOOL ScViewFunc::TestRemoveMerge()
/*N*/ {
/*N*/ 	BOOL bMerged = FALSE;
/*N*/ 	ScRange aRange;
/*N*/ 	if (GetViewData()->GetSimpleArea( aRange ))
/*N*/ 	{
/*N*/ 		ScDocument* pDoc = GetViewData()->GetDocument();
/*N*/ 		if ( pDoc->HasAttrib( aRange, HASATTR_MERGED ) )
/*N*/ 			bMerged = TRUE;
/*N*/ 	}
/*N*/ 	return bMerged;
/*N*/ }


//----------------------------------------------------------------------------

//STRIP001 BOOL ScViewFunc::RemoveMerge( BOOL bRecord )
//STRIP001 {
//STRIP001 	ScRange aRange;
//STRIP001 	if (GetViewData()->GetSimpleArea( aRange ))
//STRIP001 	{
//STRIP001 		ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 		HideCursor();
//STRIP001 		BOOL bOk = pDocSh->GetDocFunc().UnmergeCells( aRange, bRecord, FALSE );
//STRIP001 		ShowCursor();
//STRIP001 		if (bOk)
//STRIP001 			pDocSh->UpdateOle(GetViewData());
//STRIP001 	}
//STRIP001 	return TRUE;		//! bOk ??
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::FillSimple( FillDir eDir, BOOL bRecord )
//STRIP001 {
//STRIP001 	ScRange aRange;
//STRIP001 	if (GetViewData()->GetSimpleArea(aRange))
//STRIP001 	{
//STRIP001 		ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 		const ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 		BOOL bSuccess = pDocSh->GetDocFunc().FillSimple( aRange, &rMark, eDir, bRecord, FALSE );
//STRIP001 		if (bSuccess)
//STRIP001 		{
//STRIP001 			pDocSh->UpdateOle(GetViewData());
//STRIP001 			UpdateScrollBars();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		ErrorMessage(STR_NOMULTISELECT);
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::FillSeries( FillDir eDir, FillCmd eCmd, FillDateCmd eDateCmd,
//STRIP001 							 double fStart, double fStep, double fMax, BOOL bRecord )
//STRIP001 {
//STRIP001 	ScRange aRange;
//STRIP001 	if (GetViewData()->GetSimpleArea(aRange))
//STRIP001 	{
//STRIP001 		ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 		const ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 		BOOL bSuccess = pDocSh->GetDocFunc().
//STRIP001 						FillSeries( aRange, &rMark, eDir, eCmd, eDateCmd,
//STRIP001 									fStart, fStep, fMax, bRecord, FALSE );
//STRIP001 		if (bSuccess)
//STRIP001 		{
//STRIP001 			pDocSh->UpdateOle(GetViewData());
//STRIP001 			UpdateScrollBars();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		ErrorMessage(STR_NOMULTISELECT);
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::FillAuto( FillDir eDir, USHORT nStartCol, USHORT nStartRow,
//STRIP001 							USHORT nEndCol, USHORT nEndRow, USHORT nCount, BOOL bRecord )
//STRIP001 {
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	ScRange aRange( nStartCol,nStartRow,nTab, nEndCol,nEndRow,nTab );
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	const ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 	BOOL bSuccess = pDocSh->GetDocFunc().
//STRIP001 					FillAuto( aRange, &rMark, eDir, nCount, bRecord, FALSE );
//STRIP001 	if (bSuccess)
//STRIP001 	{
//STRIP001 		MarkRange( aRange, FALSE );			// aRange ist in FillAuto veraendert worden
//STRIP001 		pDocSh->UpdateOle(GetViewData());
//STRIP001 		UpdateScrollBars();
//STRIP001 	}
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::FillTab( USHORT nFlags, USHORT nFunction, BOOL bSkipEmpty, BOOL bAsLink )
//STRIP001 {
//STRIP001 	//! allow source sheet to be protected
//STRIP001 	ScEditableTester aTester( this );
//STRIP001 	if (!aTester.IsEditable())
//STRIP001 	{
//STRIP001 		ErrorMessage(aTester.GetMessageId());
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	BOOL bUndo(pDoc->IsUndoEnabled());
//STRIP001 
//STRIP001 	ScRange aMarkRange;
//STRIP001 	rMark.MarkToSimple();
//STRIP001 	BOOL bMulti = rMark.IsMultiMarked();
//STRIP001 	if (bMulti)
//STRIP001 		rMark.GetMultiMarkArea( aMarkRange );
//STRIP001 	else if (rMark.IsMarked())
//STRIP001 		rMark.GetMarkArea( aMarkRange );
//STRIP001 	else
//STRIP001 		aMarkRange = ScRange( GetViewData()->GetCurX(), GetViewData()->GetCurY(), nTab );
//STRIP001 
//STRIP001 	ScDocument* pUndoDoc = NULL;
//STRIP001 //	if ( bRecord )
//STRIP001 	if (bUndo)
//STRIP001 	{
//STRIP001 		pUndoDoc = new ScDocument( SCDOCMODE_UNDO );
//STRIP001 		pUndoDoc->InitUndo( pDoc, nTab, nTab );
//STRIP001 //		pUndoDoc->SelectTable( nTab, TRUE );		// nur fuer Markierung
//STRIP001 
//STRIP001 		USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 		for (USHORT i=0; i<nTabCount; i++)
//STRIP001 			if (i != nTab && rMark.GetTableSelect(i))
//STRIP001 			{
//STRIP001 				pUndoDoc->AddUndoTab( i, i );
//STRIP001 				aMarkRange.aStart.SetTab( i );
//STRIP001 				aMarkRange.aEnd.SetTab( i );
//STRIP001 				pDoc->CopyToDocument( aMarkRange, IDF_ALL, bMulti, pUndoDoc );
//STRIP001 //				pUndoDoc->SelectTable( i, TRUE );
//STRIP001 			}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bMulti)
//STRIP001 		pDoc->FillTabMarked( nTab, rMark, nFlags, nFunction, bSkipEmpty, bAsLink );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aMarkRange.aStart.SetTab( nTab );
//STRIP001 		aMarkRange.aEnd.SetTab( nTab );
//STRIP001 		pDoc->FillTab( aMarkRange, rMark, nFlags, nFunction, bSkipEmpty, bAsLink );
//STRIP001 	}
//STRIP001 
//STRIP001 //	if ( bRecord )
//STRIP001 	if (bUndo)
//STRIP001 	{	//! fuer ChangeTrack erst zum Schluss
//STRIP001 		pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 			new ScUndoFillTable( pDocSh, rMark,
//STRIP001 								aMarkRange.aStart.Col(), aMarkRange.aStart.Row(), nTab,
//STRIP001 								aMarkRange.aEnd.Col(), aMarkRange.aEnd.Row(), nTab,
//STRIP001 								pUndoDoc, bMulti, nTab, nFlags, nFunction, bSkipEmpty, bAsLink ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	pDocSh->PostPaintGridAll();
//STRIP001 	pDocSh->PostDataChanged();
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::TransliterateText( sal_Int32 nType )
//STRIP001 {
//STRIP001 	ScMarkData aFuncMark = GetViewData()->GetMarkData();
//STRIP001 	if ( !aFuncMark.IsMarked() && !aFuncMark.IsMultiMarked() )
//STRIP001 	{
//STRIP001 		//	no selection -> use cursor position
//STRIP001 
//STRIP001 		ScAddress aCursor( GetViewData()->GetCurX(), GetViewData()->GetCurY(), GetViewData()->GetTabNo() );
//STRIP001 		aFuncMark.SetMarkArea( ScRange( aCursor ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bSuccess = GetViewData()->GetDocShell()->GetDocFunc().
//STRIP001 						TransliterateText( aFuncMark, nType, TRUE, FALSE );
//STRIP001 	if (bSuccess)
//STRIP001 	{
//STRIP001 		GetViewData()->GetViewShell()->UpdateInputHandler();
//STRIP001 	}
//STRIP001 }

//----------------------------------------------------------------------------
//	AutoFormat

//STRIP001 ScAutoFormatData* ScViewFunc::CreateAutoFormatData()
//STRIP001 {
//STRIP001 	ScAutoFormatData* pData = NULL;
//STRIP001 	USHORT nStartCol;
//STRIP001 	USHORT nStartRow;
//STRIP001 	USHORT nStartTab;
//STRIP001 	USHORT nEndCol;
//STRIP001 	USHORT nEndRow;
//STRIP001 	USHORT nEndTab;
//STRIP001 	if (GetViewData()->GetSimpleArea(nStartCol,nStartRow,nStartTab,nEndCol,nEndRow,nEndTab))
//STRIP001 	{
//STRIP001 		if ( nEndCol-nStartCol >= 3 && nEndRow-nStartRow >= 3 )
//STRIP001 		{
//STRIP001 			ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 			pData = new ScAutoFormatData;
//STRIP001 			pDoc->GetAutoFormatData( nStartTab, nStartCol,nStartRow,nEndCol,nEndRow, *pData );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return pData;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::AutoFormat( USHORT nFormatNo, BOOL bRecord )
//STRIP001 {
//STRIP001 #if 1
//STRIP001 
//STRIP001 	ScRange aRange;
//STRIP001 	if (GetViewData()->GetSimpleArea(aRange))
//STRIP001 	{
//STRIP001 		ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 		ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 
//STRIP001 		BOOL bSuccess = pDocSh->GetDocFunc().AutoFormat( aRange, &rMark, nFormatNo, bRecord, FALSE );
//STRIP001 		if (bSuccess)
//STRIP001 			pDocSh->UpdateOle(GetViewData());
//STRIP001 	}
//STRIP001 	else
//STRIP001 		ErrorMessage(STR_NOMULTISELECT);
//STRIP001 
//STRIP001 #else
//STRIP001 
//STRIP001 	// nur wegen Matrix nicht editierbar? Attribute trotzdem ok
//STRIP001 	BOOL bOnlyNotBecauseOfMatrix;
//STRIP001 	if ( !SelectionEditable( &bOnlyNotBecauseOfMatrix ) && !bOnlyNotBecauseOfMatrix )
//STRIP001 	{
//STRIP001 		ErrorMessage(STR_PROTECTIONERR);
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nStartCol;
//STRIP001 	USHORT nStartRow;
//STRIP001 	USHORT nStartTab;
//STRIP001 	USHORT nEndCol;
//STRIP001 	USHORT nEndRow;
//STRIP001 	USHORT nEndTab;
//STRIP001 
//STRIP001 	if (GetViewData()->GetSimpleArea(nStartCol,nStartRow,nStartTab,nEndCol,nEndRow,nEndTab))
//STRIP001 	{
//STRIP001 		ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 		ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 		ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 		BOOL bSize = (*ScGlobal::GetAutoFormat())[nFormatNo]->GetIncludeWidthHeight();
//STRIP001 		if (bRecord && !pDoc->IsUndoEnabled())
//STRIP001 			bRecord = FALSE;
//STRIP001 
//STRIP001 		ScDocument* pUndoDoc = NULL;
//STRIP001 		if ( bRecord )
//STRIP001 		{
//STRIP001 			pUndoDoc = new ScDocument( SCDOCMODE_UNDO );
//STRIP001 			pUndoDoc->InitUndo( pDoc, nStartTab, nEndTab, bSize, bSize );
//STRIP001 			pDoc->CopyToDocument( nStartCol, nStartRow, nStartTab, nEndCol, nEndRow, nEndTab,
//STRIP001 									IDF_ATTRIB, FALSE, pUndoDoc );
//STRIP001 			if (bSize)
//STRIP001 			{
//STRIP001 				pDoc->CopyToDocument( nStartCol,0,nStartTab, nEndCol,MAXROW,nEndTab,
//STRIP001 															IDF_NONE, FALSE, pUndoDoc );
//STRIP001 				pDoc->CopyToDocument( 0,nStartRow,nStartTab, MAXCOL,nEndRow,nEndTab,
//STRIP001 															IDF_NONE, FALSE, pUndoDoc );
//STRIP001 			}
//STRIP001 			pDoc->BeginDrawUndo();
//STRIP001 		}
//STRIP001 
//STRIP001 		GetFrameWin()->EnterWait();
//STRIP001 		pDoc->AutoFormat( nStartCol, nStartRow, nEndCol, nEndRow, nFormatNo, rMark );
//STRIP001 		GetFrameWin()->LeaveWait();
//STRIP001 
//STRIP001 		if (bSize)
//STRIP001 		{
//STRIP001 			SetMarkedWidthOrHeight( TRUE, SC_SIZE_VISOPT, STD_EXTRA_WIDTH, FALSE, FALSE );
//STRIP001 			SetMarkedWidthOrHeight( FALSE, SC_SIZE_VISOPT, 0, FALSE, FALSE );
//STRIP001 			pDocSh->PostPaint( 0,0,nStartTab, MAXCOL,MAXROW,nStartTab,
//STRIP001 									PAINT_GRID | PAINT_LEFT | PAINT_TOP );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			BOOL bAdj = AdjustBlockHeight( FALSE );
//STRIP001 			if (bAdj)
//STRIP001 				pDocSh->PostPaint( 0,nStartRow,nStartTab, MAXCOL,MAXROW,nStartTab,
//STRIP001 									PAINT_GRID | PAINT_LEFT );
//STRIP001 			else
//STRIP001 				pDocSh->PostPaint( nStartCol, nStartRow, nStartTab,
//STRIP001 									nEndCol, nEndRow, nEndTab, PAINT_GRID );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bRecord )		// Draw-Undo erst jetzt verfuegbar
//STRIP001 		{
//STRIP001 			pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 				new ScUndoAutoFormat( pDocSh,
//STRIP001 						ScRange(nStartCol,nStartRow,nStartTab, nEndCol,nEndRow,nEndTab),
//STRIP001 						pUndoDoc, rMark, bSize, nFormatNo ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		pDocSh->UpdateOle(GetViewData());
//STRIP001 		pDocSh->SetDocumentModified();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		ErrorMessage(STR_NOMULTISELECT);
//STRIP001 
//STRIP001 #endif
//STRIP001 }


//----------------------------------------------------------------------------
//	Suchen & Ersetzen

//STRIP001 void ScViewFunc::SearchAndReplace( const SvxSearchItem* pSearchItem,
//STRIP001 										BOOL bAddUndo, BOOL bIsApi )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 	if (bAddUndo && !pDoc->IsUndoEnabled())
//STRIP001 		bAddUndo = FALSE;
//STRIP001 
//STRIP001 	USHORT nCol = GetViewData()->GetCurX();
//STRIP001 	USHORT nRow = GetViewData()->GetCurY();
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	BOOL bAttrib = pSearchItem->GetPattern();
//STRIP001 	USHORT nCommand = pSearchItem->GetCommand();
//STRIP001 	BOOL bAllTables = pSearchItem->IsAllTables();
//STRIP001 	BOOL* pOldSelectedTables = NULL;
//STRIP001 	USHORT nOldSelectedCount = 0;
//STRIP001 	USHORT nOldTab = nTab;
//STRIP001 	USHORT nLastTab = pDoc->GetTableCount() - 1;
//STRIP001 	USHORT nStartTab, nEndTab;
//STRIP001 	if ( bAllTables )
//STRIP001 	{
//STRIP001 		nStartTab = 0;
//STRIP001 		nEndTab = nLastTab;
//STRIP001 		pOldSelectedTables = new BOOL [ nEndTab + 1 ];
//STRIP001 		for ( USHORT j = 0; j <= nEndTab; j++ )
//STRIP001 		{
//STRIP001 			pOldSelectedTables[j] = rMark.GetTableSelect( j );
//STRIP001 			if ( pOldSelectedTables[j] )
//STRIP001 				++nOldSelectedCount;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{	//! mindestens eine ist immer selektiert
//STRIP001 		nStartTab = nEndTab = rMark.GetFirstSelected();
//STRIP001 		for ( USHORT j = nStartTab + 1; j <= nLastTab; j++ )
//STRIP001 		{
//STRIP001 			if ( rMark.GetTableSelect( j ) )
//STRIP001 				nEndTab = j;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (   nCommand == SVX_SEARCHCMD_REPLACE
//STRIP001 		|| nCommand == SVX_SEARCHCMD_REPLACE_ALL )
//STRIP001 	{
//STRIP001 		for ( USHORT j = nStartTab; j <= nEndTab; j++ )
//STRIP001 		{
//STRIP001 			if ( (bAllTables || rMark.GetTableSelect( j )) &&
//STRIP001 					pDoc->IsTabProtected( j ) )
//STRIP001 			{
//STRIP001 				if ( pOldSelectedTables )
//STRIP001 					delete [] pOldSelectedTables;
//STRIP001 				ErrorMessage(STR_PROTECTIONERR);
//STRIP001 				return;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (   nCommand == SVX_SEARCHCMD_FIND
//STRIP001 		|| nCommand == SVX_SEARCHCMD_FIND_ALL)
//STRIP001 		bAddUndo = FALSE;
//STRIP001 
//STRIP001 	//!		bAttrib bei Undo beruecksichtigen !!!
//STRIP001 
//STRIP001 	ScDocument* pUndoDoc = NULL;
//STRIP001 	ScMarkData* pUndoMark = NULL;
//STRIP001 	String aUndoStr;
//STRIP001 	if (bAddUndo)
//STRIP001 	{
//STRIP001 		pUndoMark = new ScMarkData( rMark );				// Markierung wird veraendert
//STRIP001 		if ( nCommand == SVX_SEARCHCMD_REPLACE_ALL )
//STRIP001 		{
//STRIP001 			pUndoDoc = new ScDocument( SCDOCMODE_UNDO );
//STRIP001 			pUndoDoc->InitUndo( pDoc, nStartTab, nEndTab );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bAllTables )
//STRIP001 	{	//! alles selektieren, erst nachdem pUndoMark erzeugt wurde
//STRIP001 		for ( USHORT j = nStartTab; j <= nEndTab; j++ )
//STRIP001 		{
//STRIP001 			rMark.SelectTable( j, TRUE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	DoneBlockMode(TRUE);				// Markierung nicht loeschen!
//STRIP001 	InitOwnBlockMode();
//STRIP001 
//STRIP001 	//	wenn vom Anfang an gesucht wird, nicht nochmal fragen ob vom Anfang gesucht werden soll
//STRIP001 	BOOL bFirst = TRUE;
//STRIP001 	if ( nCol == 0 && nRow == 0 && nTab == nStartTab && !pSearchItem->GetBackward()  )
//STRIP001 		bFirst = FALSE;
//STRIP001 
//STRIP001 	BOOL bFound = FALSE;
//STRIP001 	while (TRUE)
//STRIP001 	{
//STRIP001 		GetFrameWin()->EnterWait();
//STRIP001 		if (pDoc->SearchAndReplace( *pSearchItem, nCol, nRow, nTab, rMark, aUndoStr, pUndoDoc ) )
//STRIP001 		{
//STRIP001 			bFound = TRUE;
//STRIP001 			bFirst = TRUE;
//STRIP001 			if (bAddUndo)
//STRIP001 			{
//STRIP001 				GetViewData()->GetDocShell()->GetUndoManager()->AddUndoAction(
//STRIP001 					new ScUndoReplace( GetViewData()->GetDocShell(), *pUndoMark,
//STRIP001 										nCol, nRow, nTab,
//STRIP001 										aUndoStr, pUndoDoc, pSearchItem ) );
//STRIP001 				pUndoDoc = NULL;
//STRIP001 			}
//STRIP001 
//STRIP001 			break;					// Abbruch while True
//STRIP001 		}
//STRIP001 		else if ( bFirst && (nCommand == SVX_SEARCHCMD_FIND ||
//STRIP001 				nCommand == SVX_SEARCHCMD_REPLACE) )
//STRIP001 		{
//STRIP001 			bFirst = FALSE;
//STRIP001 			USHORT nRetVal;
//STRIP001 			GetFrameWin()->LeaveWait();
//STRIP001 			if ( bIsApi )
//STRIP001 				nRetVal = RET_NO;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				//	Suchen-Dialog als Parent, wenn vorhanden
//STRIP001 				Window* pParent = GetParentOrChild(SID_SEARCH_DLG);
//STRIP001 				USHORT nStrId;
//STRIP001 				if ( pSearchItem->GetBackward() )
//STRIP001 				{
//STRIP001 					if ( nStartTab == nEndTab )
//STRIP001 						nStrId = STR_MSSG_SEARCHANDREPLACE_1;
//STRIP001 					else
//STRIP001 						nStrId = STR_MSSG_SEARCHANDREPLACE_4;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if ( nStartTab == nEndTab )
//STRIP001 						nStrId = STR_MSSG_SEARCHANDREPLACE_2;
//STRIP001 					else
//STRIP001 						nStrId = STR_MSSG_SEARCHANDREPLACE_5;
//STRIP001 				}
//STRIP001 				MessBox aBox( pParent, WinBits(WB_YES_NO | WB_DEF_YES),
//STRIP001 								ScGlobal::GetRscString( STR_MSSG_SEARCHANDREPLACE_3 ),
//STRIP001 								ScGlobal::GetRscString( nStrId ) );
//STRIP001 				nRetVal = aBox.Execute();
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( nRetVal == RET_YES )
//STRIP001 			{
//STRIP001 				ScDocument::GetSearchAndReplaceStart( *pSearchItem, nCol, nRow );
//STRIP001 				if (pSearchItem->GetBackward())
//STRIP001 					nTab = nEndTab;
//STRIP001 				else
//STRIP001 					nTab = nStartTab;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				break;					// Abbruch while True
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else							// nichts gefunden
//STRIP001 		{
//STRIP001 			if ( nCommand == SVX_SEARCHCMD_FIND_ALL || nCommand == SVX_SEARCHCMD_REPLACE_ALL )
//STRIP001 			{
//STRIP001 				pDocSh->PostPaintGridAll();								// Markierung
//STRIP001 			}
//STRIP001 
//STRIP001 			GetFrameWin()->LeaveWait();
//STRIP001 			if (!bIsApi)
//STRIP001 			{
//STRIP001 				//	Suchen-Dialog als Parent, wenn vorhanden
//STRIP001 				Window* pParent = GetParentOrChild(SID_SEARCH_DLG);
//STRIP001 				// "nichts gefunden"
//STRIP001 				InfoBox aBox( pParent, ScGlobal::GetRscString( STR_MSSG_SEARCHANDREPLACE_0 ) );
//STRIP001 				aBox.Execute();
//STRIP001 			}
//STRIP001 
//STRIP001 			break;						// Abbruch while True
//STRIP001 		}
//STRIP001 	}								// of while TRUE
//STRIP001 
//STRIP001 	if ( pOldSelectedTables )
//STRIP001 	{	// urspruenglich selektierte Tabellen wiederherstellen
//STRIP001 		for ( USHORT j = nStartTab; j <= nEndTab; j++ )
//STRIP001 		{
//STRIP001 			rMark.SelectTable( j, pOldSelectedTables[j] );
//STRIP001 		}
//STRIP001 		if ( bFound )
//STRIP001 		{	// durch Fundstelle neu selektierte Tabelle bleibt
//STRIP001 			rMark.SelectTable( nTab, TRUE );
//STRIP001 			// wenn vorher nur eine selektiert war, ist es ein Tausch
//STRIP001 			//! wenn nicht, ist jetzt evtl. eine mehr selektiert
//STRIP001 			if ( nOldSelectedCount == 1 && nTab != nOldTab )
//STRIP001 				rMark.SelectTable( nOldTab, FALSE );
//STRIP001 		}
//STRIP001 		delete [] pOldSelectedTables;
//STRIP001 	}
//STRIP001 	if ( bFound )
//STRIP001 	{
//STRIP001 		if ( nTab != GetViewData()->GetTabNo() )
//STRIP001 			SetTabNo( nTab );
//STRIP001 
//STRIP001 		//	wenn nichts markiert ist, DoneBlockMode, damit von hier aus
//STRIP001 		//	direkt per Shift-Cursor markiert werden kann:
//STRIP001 		if (!rMark.IsMarked() && !rMark.IsMultiMarked())
//STRIP001 			DoneBlockMode(TRUE);
//STRIP001 
//STRIP001 		AlignToCursor( nCol, nRow, SC_FOLLOW_JUMP );
//STRIP001 		SetCursor( nCol, nRow, TRUE );
//STRIP001 
//STRIP001 		if (   nCommand == SVX_SEARCHCMD_REPLACE
//STRIP001 			|| nCommand == SVX_SEARCHCMD_REPLACE_ALL )
//STRIP001 		{
//STRIP001 			if ( nCommand == SVX_SEARCHCMD_REPLACE )
//STRIP001 				pDocSh->PostPaint( nCol,nRow,nTab, nCol,nRow,nTab, PAINT_GRID );
//STRIP001 			else
//STRIP001 				pDocSh->PostPaintGridAll();
//STRIP001 			pDocSh->SetDocumentModified();
//STRIP001 		}
//STRIP001 		else if ( nCommand == SVX_SEARCHCMD_FIND_ALL )
//STRIP001 			pDocSh->PostPaintGridAll();								// Markierung
//STRIP001 		GetFrameWin()->LeaveWait();
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pUndoDoc;			// loeschen wenn nicht benutzt
//STRIP001 	delete pUndoMark;			// kann immer geloescht werden
//STRIP001 }


//----------------------------------------------------------------------------
//	Zielwertsuche

//STRIP001 void ScViewFunc::Solve( const ScSolveParam& rParam )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 
//STRIP001 	USHORT nDestCol = rParam.aRefVariableCell.Col();
//STRIP001 	USHORT nDestRow = rParam.aRefVariableCell.Row();
//STRIP001 	USHORT nDestTab = rParam.aRefVariableCell.Tab();
//STRIP001 
//STRIP001 	ScEditableTester aTester( pDoc, nDestTab, nDestCol,nDestRow, nDestCol,nDestRow );
//STRIP001 	if (!aTester.IsEditable())
//STRIP001 	{
//STRIP001 		ErrorMessage(aTester.GetMessageId());
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pDoc )
//STRIP001 	{
//STRIP001 		String  aTargetValStr;
//STRIP001 		if ( rParam.pStrTargetVal != NULL )
//STRIP001 			aTargetValStr = *(rParam.pStrTargetVal);
//STRIP001 
//STRIP001 		String  aMsgStr;
//STRIP001 		String	aResStr;
//STRIP001 		double	nSolveResult;
//STRIP001 
//STRIP001 		GetFrameWin()->EnterWait();
//STRIP001 
//STRIP001 		BOOL  	bExact =
//STRIP001 					pDoc->Solver(
//STRIP001 						rParam.aRefFormulaCell.Col(),
//STRIP001 						rParam.aRefFormulaCell.Row(),
//STRIP001 						rParam.aRefFormulaCell.Tab(),
//STRIP001 						nDestCol, nDestRow, nDestTab,
//STRIP001 						aTargetValStr,
//STRIP001 						nSolveResult );
//STRIP001 
//STRIP001 		GetFrameWin()->LeaveWait();
//STRIP001 
//STRIP001 		SvNumberFormatter* pFormatter = pDoc->GetFormatTable();
//STRIP001 		ULONG nFormat = 0;
//STRIP001 		const ScPatternAttr* pPattern = pDoc->GetPattern( nDestCol, nDestRow, nDestTab );
//STRIP001 		if ( pPattern )
//STRIP001 			nFormat = pPattern->GetNumberFormat( pFormatter );
//STRIP001 		Color* p;
//STRIP001 		pFormatter->GetOutputString( nSolveResult, nFormat, aResStr, &p );
//STRIP001 
//STRIP001 		if ( bExact )
//STRIP001 		{
//STRIP001 			aMsgStr  = ScGlobal::GetRscString( STR_MSSG_SOLVE_0 );
//STRIP001 			aMsgStr += ScGlobal::GetRscString( STR_MSSG_SOLVE_1 );
//STRIP001 			aMsgStr += String( aResStr );
//STRIP001 			aMsgStr += ScGlobal::GetRscString( STR_MSSG_SOLVE_2 );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aMsgStr  = ScGlobal::GetRscString( STR_MSSG_SOLVE_3 );
//STRIP001 			aMsgStr += ScGlobal::GetRscString( STR_MSSG_SOLVE_4 );
//STRIP001 			aMsgStr += ScGlobal::GetRscString( STR_MSSG_SOLVE_5 );
//STRIP001 			aMsgStr += String( aResStr );
//STRIP001 			aMsgStr += ScGlobal::GetRscString( STR_MSSG_SOLVE_6 );
//STRIP001 		}
//STRIP001 
//STRIP001 		MessBox aBox( GetViewData()->GetDialogParent(),
//STRIP001 						WinBits(WB_YES_NO | WB_DEF_NO),
//STRIP001 						ScGlobal::GetRscString( STR_MSSG_DOSUBTOTALS_0 ), aMsgStr );
//STRIP001 		USHORT nRetVal = aBox.Execute();
//STRIP001 
//STRIP001 		if ( RET_YES == nRetVal )
//STRIP001 			EnterData( nDestCol, nDestRow, nDestTab, nSolveResult );
//STRIP001 
//STRIP001 		GetViewData()->GetViewShell()->UpdateInputHandler( TRUE );
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------
//	Mehrfachoperation

//STRIP001 void ScViewFunc::TabOp( const ScTabOpParam& rParam, BOOL bRecord )
//STRIP001 {
//STRIP001 	ScRange aRange;
//STRIP001 	if (GetViewData()->GetSimpleArea(aRange))
//STRIP001 	{
//STRIP001 		ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 		ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 		pDocSh->GetDocFunc().TabOp( aRange, &rMark, rParam, bRecord, FALSE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		ErrorMessage(STR_NOMULTISELECT);
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::MakeScenario( const String& rName, const String& rComment,
//STRIP001 									const Color& rColor, USHORT nFlags )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh	= GetViewData()->GetDocShell();
//STRIP001 	ScMarkData&	rMark	= GetViewData()->GetMarkData();
//STRIP001 	USHORT		nTab	= GetViewData()->GetTabNo();
//STRIP001 
//STRIP001 	USHORT nNewTab = pDocSh->MakeScenario( nTab, rName, rComment, rColor, nFlags, rMark );
//STRIP001 	if (nFlags & SC_SCENARIO_COPYALL)
//STRIP001 		SetTabNo( nNewTab, TRUE );			// SC_SCENARIO_COPYALL -> sichtbar
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SfxBindings& rBindings = GetViewData()->GetBindings();
//STRIP001 		rBindings.Invalidate( SID_STATUS_DOCPOS );		// Statusbar
//STRIP001 		rBindings.Invalidate( SID_TABLES_COUNT );
//STRIP001 		rBindings.Invalidate( SID_SELECT_SCENARIO );
//STRIP001 		rBindings.Invalidate( FID_TABLE_SHOW );
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::ExtendScenario()
//STRIP001 {
//STRIP001 	ScEditableTester aTester( this );
//STRIP001 	if (!aTester.IsEditable())
//STRIP001 	{
//STRIP001 		ErrorMessage(aTester.GetMessageId());
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 		//	Undo: Attribute anwenden
//STRIP001 
//STRIP001 	ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 	ScPatternAttr aPattern( pDoc->GetPool() );
//STRIP001 	aPattern.GetItemSet().Put( ScMergeFlagAttr( SC_MF_SCENARIO ) );
//STRIP001 	aPattern.GetItemSet().Put( ScProtectionAttr( TRUE ) );
//STRIP001 	ApplySelectionPattern(aPattern);
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::UseScenario( const String& rName )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh	= GetViewData()->GetDocShell();
//STRIP001 	USHORT		nTab	= GetViewData()->GetTabNo();
//STRIP001 
//STRIP001 	DoneBlockMode();
//STRIP001 	InitOwnBlockMode();
//STRIP001 	pDocSh->UseScenario( nTab, rName );
//STRIP001 }


//----------------------------------------------------------------------------
//	Tabelle einfuegen

//STRIP001 BOOL ScViewFunc::InsertTable( const String& rName, USHORT nTab, BOOL bRecord )
//STRIP001 {
//STRIP001 	//	Reihenfolge Tabelle/Name ist bei DocFunc umgekehrt
//STRIP001 	BOOL bSuccess = GetViewData()->GetDocShell()->GetDocFunc().
//STRIP001 						InsertTable( nTab, rName, bRecord, FALSE );
//STRIP001 	if (bSuccess)
//STRIP001 		SetTabNo( nTab, TRUE );
//STRIP001 
//STRIP001 	return bSuccess;
//STRIP001 }

//----------------------------------------------------------------------------
//	Tabellen einfuegen

//STRIP001 BOOL ScViewFunc::InsertTables(SvStrings *pNames, USHORT nTab,
//STRIP001 											USHORT nCount, BOOL bRecord )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh	= GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc 	= pDocSh->GetDocument();
//STRIP001 	if (bRecord && !pDoc->IsUndoEnabled())
//STRIP001 		bRecord = FALSE;
//STRIP001 
//STRIP001 	SvStrings *pNameList= NULL;
//STRIP001 
//STRIP001 	WaitObject aWait( GetFrameWin() );
//STRIP001 
//STRIP001 	if (bRecord)
//STRIP001 	{
//STRIP001 		pNameList= new SvStrings;
//STRIP001 		pDoc->BeginDrawUndo();							//	InsertTab erzeugt ein SdrUndoNewPage
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bFlag=FALSE;
//STRIP001 
//STRIP001 	String aValTabName;
//STRIP001 	String *pStr;
//STRIP001 
//STRIP001 	for(int i=0;i<nCount;i++)
//STRIP001 	{
//STRIP001 		if(pNames!=NULL)
//STRIP001 		{
//STRIP001 			pStr=pNames->GetObject(i);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aValTabName.Erase();
//STRIP001 			pDoc->CreateValidTabName( aValTabName);
//STRIP001 			pStr=&aValTabName;
//STRIP001 		}
//STRIP001 
//STRIP001 		if(pDoc->InsertTab( nTab+i,*pStr))
//STRIP001 		{
//STRIP001 			bFlag=TRUE;
//STRIP001 			pDocSh->Broadcast( ScTablesHint( SC_TAB_INSERTED, nTab+i ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		if(pNameList!=NULL)
//STRIP001 			pNameList->Insert(new String(*pStr),pNameList->Count());
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bFlag)
//STRIP001 	{
//STRIP001 		if (bRecord)
//STRIP001 			pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 						new ScUndoInsertTables( pDocSh, nTab, FALSE, pNameList));
//STRIP001 
//STRIP001 		//	Views updaten:
//STRIP001 
//STRIP001 		SetTabNo( nTab, TRUE );
//STRIP001 		pDocSh->PostPaintExtras();
//STRIP001 		pDocSh->SetDocumentModified();
//STRIP001 		SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_TABLES_CHANGED ) );
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL ScViewFunc::AppendTable( const String& rName, BOOL bRecord )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc   = pDocSh->GetDocument();
//STRIP001 	if (bRecord && !pDoc->IsUndoEnabled())
//STRIP001 		bRecord = FALSE;
//STRIP001 
//STRIP001 	WaitObject aWait( GetFrameWin() );
//STRIP001 
//STRIP001 	if (bRecord)
//STRIP001 		pDoc->BeginDrawUndo();							//	InsertTab erzeugt ein SdrUndoNewPage
//STRIP001 
//STRIP001 	if (pDoc->InsertTab( SC_TAB_APPEND, rName ))
//STRIP001 	{
//STRIP001 		USHORT nTab = pDoc->GetTableCount()-1;
//STRIP001 		if (bRecord)
//STRIP001 			pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 						new ScUndoInsertTab( pDocSh, nTab, TRUE, rName));
//STRIP001 		GetViewData()->InsertTab( nTab );
//STRIP001 		SetTabNo( nTab, TRUE );
//STRIP001 		pDocSh->PostPaintExtras();
//STRIP001 		pDocSh->SetDocumentModified();
//STRIP001 		SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_TABLES_CHANGED ) );
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL ScViewFunc::DeleteTable( USHORT nTab, BOOL bRecord )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh	= GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc 	= pDocSh->GetDocument();
//STRIP001 
//STRIP001 	BOOL bSuccess = pDocSh->GetDocFunc().DeleteTable( nTab, bRecord, FALSE );
//STRIP001 	if (bSuccess)
//STRIP001 	{
//STRIP001 		USHORT nNewTab = nTab;
//STRIP001 		if ( nNewTab >= pDoc->GetTableCount() )
//STRIP001 			--nNewTab;
//STRIP001 		SetTabNo( nNewTab, TRUE );
//STRIP001 	}
//STRIP001 	return bSuccess;
//STRIP001 }

//STRIP001 BOOL ScViewFunc::DeleteTables(const SvUShorts &TheTabs, BOOL bRecord )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh	= GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc 	= pDocSh->GetDocument();
//STRIP001 	USHORT		nNewTab = TheTabs[0];
//STRIP001 	int			i;
//STRIP001 	WaitObject aWait( GetFrameWin() );
//STRIP001 	if (bRecord && !pDoc->IsUndoEnabled())
//STRIP001 		bRecord = FALSE;
//STRIP001 
//STRIP001 	while ( nNewTab > 0 && !pDoc->IsVisible( nNewTab ) )
//STRIP001 		--nNewTab;
//STRIP001 
//STRIP001 	BOOL bWasLinked = FALSE;
//STRIP001 	ScDocument* pUndoDoc = NULL;
//STRIP001 	ScRefUndoData* pUndoData = NULL;
//STRIP001 	if (bRecord)
//STRIP001 	{
//STRIP001 		pUndoDoc = new ScDocument( SCDOCMODE_UNDO );
//STRIP001 //		pUndoDoc->InitDrawLayer( pDocSh );
//STRIP001 		USHORT nCount = pDoc->GetTableCount();
//STRIP001 
//STRIP001 //		pUndoDoc->InitUndo( pDoc, 0, nCount-1 );		// incl. Ref.
//STRIP001 
//STRIP001 		String aOldName;
//STRIP001 		for(i=0;i<TheTabs.Count();i++)
//STRIP001 		{
//STRIP001 			USHORT nTab = TheTabs[i];
//STRIP001 			if (i==0)
//STRIP001 				pUndoDoc->InitUndo( pDoc, nTab,nTab, TRUE,TRUE );	// incl. Spalten/Zeilenflags
//STRIP001 			else
//STRIP001 				pUndoDoc->AddUndoTab( nTab,nTab, TRUE,TRUE );		// incl. Spalten/Zeilenflags
//STRIP001 
//STRIP001 			pDoc->CopyToDocument(0,0,nTab, MAXCOL,MAXROW,nTab, IDF_ALL,FALSE, pUndoDoc );
//STRIP001 			pDoc->GetName( nTab, aOldName );
//STRIP001 			pUndoDoc->RenameTab( nTab, aOldName, FALSE );
//STRIP001 			if (pDoc->IsLinked(nTab))
//STRIP001 			{
//STRIP001 				bWasLinked = TRUE;
//STRIP001 				pUndoDoc->SetLink( nTab, pDoc->GetLinkMode(nTab), pDoc->GetLinkDoc(nTab),
//STRIP001 									pDoc->GetLinkFlt(nTab), pDoc->GetLinkOpt(nTab),
//STRIP001 									pDoc->GetLinkTab(nTab),
//STRIP001 									pDoc->GetLinkRefreshDelay(nTab) );
//STRIP001 			}
//STRIP001 			if ( pDoc->IsScenario(nTab) )
//STRIP001 			{
//STRIP001 				pUndoDoc->SetScenario( nTab, TRUE );
//STRIP001 				String aComment;
//STRIP001 				Color  aColor;
//STRIP001 				USHORT nScenFlags;
//STRIP001 				pDoc->GetScenarioData( nTab, aComment, aColor, nScenFlags );
//STRIP001 				pUndoDoc->SetScenarioData( nTab, aComment, aColor, nScenFlags );
//STRIP001 				BOOL bActive = pDoc->IsActiveScenario( nTab );
//STRIP001 				pUndoDoc->SetActiveScenario( nTab, bActive );
//STRIP001 			}
//STRIP001 			pUndoDoc->SetVisible( nTab, pDoc->IsVisible( nTab ) );
//STRIP001 
//STRIP001 			if ( pDoc->IsTabProtected( nTab ) )
//STRIP001 				pUndoDoc->SetTabProtection( nTab, TRUE, pDoc->GetTabPassword( nTab ) );
//STRIP001 
//STRIP001 			//	Drawing-Layer muss sein Undo selbst in der Hand behalten !!!
//STRIP001 			//		pUndoDoc->TransferDrawPage(pDoc, nTab,nTab);
//STRIP001 		}
//STRIP001 
//STRIP001 		pUndoDoc->AddUndoTab( 0, nCount-1 );			//	alle Tabs fuer Referenzen
//STRIP001 
//STRIP001 		pDoc->BeginDrawUndo();							//	DeleteTab erzeugt ein SdrUndoDelPage
//STRIP001 
//STRIP001 		pUndoData = new ScRefUndoData( pDoc );
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bDelDone = FALSE;
//STRIP001 
//STRIP001 	for(i=TheTabs.Count()-1;i>=0;i--)
//STRIP001 	{
//STRIP001 		if (pDoc->DeleteTab( TheTabs[i], pUndoDoc ))
//STRIP001 		{
//STRIP001 			bDelDone = TRUE;
//STRIP001 			pDocSh->Broadcast( ScTablesHint( SC_TAB_DELETED, TheTabs[i] ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if (bRecord)
//STRIP001 	{
//STRIP001 		pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 					new ScUndoDeleteTab( GetViewData()->GetDocShell(), TheTabs,
//STRIP001 											pUndoDoc, pUndoData ));
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	if (bDelDone)
//STRIP001 	{
//STRIP001 		if ( nNewTab >= pDoc->GetTableCount() )
//STRIP001 			nNewTab = pDoc->GetTableCount() - 1;
//STRIP001 
//STRIP001 		SetTabNo( nNewTab, TRUE );
//STRIP001 
//STRIP001 		if (bWasLinked)
//STRIP001 		{
//STRIP001 			pDocSh->UpdateLinks();				// Link-Manager updaten
//STRIP001 			GetViewData()->GetBindings().Invalidate(SID_LINKS);
//STRIP001 		}
//STRIP001 
//STRIP001 		pDocSh->PostPaintExtras();
//STRIP001 		pDocSh->SetDocumentModified();
//STRIP001 		SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_TABLES_CHANGED ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		delete pUndoDoc;
//STRIP001 		delete pUndoData;
//STRIP001 	}
//STRIP001 	return bDelDone;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL ScViewFunc::RenameTable( const String& rName, USHORT nTab )
//STRIP001 {
//STRIP001 	//	Reihenfolge Tabelle/Name ist bei DocFunc umgekehrt
//STRIP001 	BOOL bSuccess = GetViewData()->GetDocShell()->GetDocFunc().
//STRIP001 						RenameTable( nTab, rName, TRUE, FALSE );
//STRIP001 	if (bSuccess)
//STRIP001 	{
//STRIP001 		//	Der Tabellenname koennte in einer Formel vorkommen...
//STRIP001 		GetViewData()->GetViewShell()->UpdateInputHandler();
//STRIP001 	}
//STRIP001 	return bSuccess;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::InsertAreaLink( const String& rFile,
//STRIP001 									const String& rFilter, const String& rOptions,
//STRIP001 									const String& rSource, ULONG nRefresh )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	USHORT nPosX = GetViewData()->GetCurX();
//STRIP001 	USHORT nPosY = GetViewData()->GetCurY();
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	ScAddress aPos( nPosX, nPosY, nTab );
//STRIP001 	BOOL bUndo (pDoc->IsUndoEnabled());
//STRIP001 
//STRIP001 	String aFilterName = rFilter;
//STRIP001 	String aNewOptions = rOptions;
//STRIP001 	if (!aFilterName.Len())
//STRIP001 		ScDocumentLoader::GetFilterName( rFile, aFilterName, aNewOptions );
//STRIP001 
//STRIP001 	SvxLinkManager* pLinkManager = pDoc->GetLinkManager();
//STRIP001 
//STRIP001 	ScAreaLink* pLink = new ScAreaLink( pDocSh, rFile, aFilterName, aNewOptions, rSource, aPos, nRefresh );
//STRIP001 	pLinkManager->InsertFileLink( *pLink, OBJECT_CLIENT_FILE, rFile, &aFilterName, &rSource );
//STRIP001 
//STRIP001 	//	Undo fuer den leeren Link
//STRIP001 
//STRIP001 	if (bUndo)
//STRIP001 	{
//STRIP001 		pDocSh->GetUndoManager()->AddUndoAction( new ScUndoInsertAreaLink( pDocSh,
//STRIP001 													rFile, aFilterName, aNewOptions,
//STRIP001 													rSource, ScRange(aPos), nRefresh ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Update hat sein eigenes Undo
//STRIP001 
//STRIP001 	pLink->SetDoInsert(FALSE);	// beim ersten Update nichts einfuegen
//STRIP001 	pLink->Update();			// kein SetInCreate -> Update ausfuehren
//STRIP001 	pLink->SetDoInsert(TRUE);	// Default = TRUE
//STRIP001 
//STRIP001 	SfxBindings& rBindings = GetViewData()->GetBindings();
//STRIP001 	rBindings.Invalidate( SID_LINKS );
//STRIP001 
//STRIP001 	SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_AREALINKS_CHANGED ) );		// Navigator
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::InsertTableLink( const String& rFile,
//STRIP001 									const String& rFilter, const String& rOptions,
//STRIP001 									const String& rTabName )
//STRIP001 {
//STRIP001 	String aFilterName = rFilter;
//STRIP001 	String aOpt = rOptions;
//STRIP001 	ScDocumentLoader aLoader( rFile, aFilterName, aOpt );
//STRIP001 	if (!aLoader.IsError())
//STRIP001 	{
//STRIP001 		ScDocShell* pSrcSh = aLoader.GetDocShell();
//STRIP001 		ScDocument* pSrcDoc = pSrcSh->GetDocument();
//STRIP001 		USHORT nTab = MAXTAB+1;
//STRIP001 		if (!rTabName.Len())				// kein Name angegeben -> erste Tabelle
//STRIP001 			nTab = 0;
//STRIP001 		else
//STRIP001 		{
//STRIP001 			String aTemp;
//STRIP001 			USHORT nCount = pSrcDoc->GetTableCount();
//STRIP001 			for (USHORT i=0; i<nCount; i++)
//STRIP001 			{
//STRIP001 				pSrcDoc->GetName( i, aTemp );
//STRIP001 				if ( aTemp == rTabName )
//STRIP001 					nTab = i;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( nTab <= MAXTAB )
//STRIP001 			ImportTables( pSrcSh, 1, &nTab, TRUE,
//STRIP001 						GetViewData()->GetTabNo() );
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------
//	Tabellen aus anderem Dokument kopieren / linken

//STRIP001 void ScViewFunc::ImportTables( ScDocShell* pSrcShell,
//STRIP001 								USHORT nCount, const USHORT* pSrcTabs, BOOL bLink,USHORT nTab )
//STRIP001 {
//STRIP001 	ScDocument* pSrcDoc = pSrcShell->GetDocument();
//STRIP001 
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	BOOL bUndo(pDoc->IsUndoEnabled());
//STRIP001 	//USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 
//STRIP001 	BOOL bError = FALSE;
//STRIP001 	BOOL bRefs = FALSE;
//STRIP001 	BOOL bName = FALSE;
//STRIP001 
//STRIP001 	if (pSrcDoc->GetDrawLayer())
//STRIP001 		pDocSh->MakeDrawLayer();
//STRIP001 
//STRIP001 	if (bUndo)
//STRIP001 		pDoc->BeginDrawUndo();			// drawing layer must do its own undo actions
//STRIP001 
//STRIP001 	USHORT nInsCount = 0;
//STRIP001 	USHORT i;
//STRIP001 	for( i=0; i<nCount; i++ )
//STRIP001 	{	// #63304# insert sheets first and update all references
//STRIP001 		String aName;
//STRIP001 		pSrcDoc->GetName( pSrcTabs[i], aName );
//STRIP001 		pDoc->CreateValidTabName( aName );
//STRIP001 		if ( !pDoc->InsertTab( nTab+i, aName ) )
//STRIP001 		{
//STRIP001 			bError = TRUE;		// total error
//STRIP001 			break;	// for
//STRIP001 		}
//STRIP001 		++nInsCount;
//STRIP001 	}
//STRIP001 	for (i=0; i<nCount && !bError; i++)
//STRIP001 	{
//STRIP001 		USHORT nSrcTab = pSrcTabs[i];
//STRIP001 		USHORT nDestTab1=nTab+i;
//STRIP001 		ULONG nErrVal = pDoc->TransferTab( pSrcDoc, nSrcTab, nDestTab1,
//STRIP001 			FALSE );		// no insert
//STRIP001 
//STRIP001 		switch (nErrVal)
//STRIP001 		{
//STRIP001 			case 0:						// interner Fehler oder voll Fehler
//STRIP001 				bError = TRUE;
//STRIP001 				break;
//STRIP001 			case 2:
//STRIP001 				bRefs = TRUE;
//STRIP001 				break;
//STRIP001 			case 3:
//STRIP001 				bName = TRUE;
//STRIP001 				break;
//STRIP001 			case 4:
//STRIP001 				bRefs = bName = TRUE;
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001 		// TransferTab doesn't copy drawing objects with bInsertNew=FALSE
//STRIP001 		if ( !bError )
//STRIP001 			pDoc->TransferDrawPage( pSrcDoc, nSrcTab, nDestTab1 );
//STRIP001 
//STRIP001 		if(!bError &&pSrcDoc->IsScenario(nSrcTab))
//STRIP001 		{
//STRIP001 			String aComment;
//STRIP001 			Color  aColor;
//STRIP001 			USHORT nFlags;
//STRIP001 
//STRIP001 			pSrcDoc->GetScenarioData(nSrcTab, aComment,aColor, nFlags);
//STRIP001 			pDoc->SetScenario( nDestTab1,TRUE);
//STRIP001 			pDoc->SetScenarioData( nTab+i,aComment,aColor,nFlags);
//STRIP001 			BOOL bActive = pSrcDoc->IsActiveScenario(nSrcTab );
//STRIP001 			pDoc->SetActiveScenario( nDestTab1, bActive );
//STRIP001 			BOOL bVisible=pSrcDoc->IsVisible(nSrcTab);
//STRIP001 			pDoc->SetVisible(nDestTab1,bVisible );
//STRIP001 
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bLink)
//STRIP001 	{
//STRIP001 		SvxLinkManager* pLinkManager = pDoc->GetLinkManager();
//STRIP001 
//STRIP001 		SfxMedium* pMed = pSrcShell->GetMedium();
//STRIP001 		String aFileName = pMed->GetName();
//STRIP001 		String aFilterName;
//STRIP001 		if (pMed->GetFilter())
//STRIP001 			aFilterName = pMed->GetFilter()->GetFilterName();
//STRIP001 		String aOptions = ScDocumentLoader::GetOptions(*pMed);
//STRIP001 
//STRIP001 		BOOL bWasThere = pDoc->HasLink( aFileName, aFilterName, aOptions );
//STRIP001 
//STRIP001 		ULONG nRefresh = 0;
//STRIP001 		String aTabStr;
//STRIP001 		for (i=0; i<nInsCount; i++)
//STRIP001 		{
//STRIP001 			pSrcDoc->GetName( pSrcTabs[i], aTabStr );
//STRIP001 			pDoc->SetLink( nTab+i, SC_LINK_NORMAL,
//STRIP001 						aFileName, aFilterName, aOptions, aTabStr, nRefresh );
//STRIP001 		}
//STRIP001 
//STRIP001 		if (!bWasThere)			// Link pro Quelldokument nur einmal eintragen
//STRIP001 		{
//STRIP001 			ScTableLink* pLink = new ScTableLink( pDocSh, aFileName, aFilterName, aOptions, nRefresh );
//STRIP001 			pLink->SetInCreate( TRUE );
//STRIP001 			pLinkManager->InsertFileLink( *pLink, OBJECT_CLIENT_FILE, aFileName, &aFilterName );
//STRIP001 			pLink->Update();
//STRIP001 			pLink->SetInCreate( FALSE );
//STRIP001 
//STRIP001 			SfxBindings& rBindings = GetViewData()->GetBindings();
//STRIP001 			rBindings.Invalidate( SID_LINKS );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	if (bUndo)
//STRIP001 	{
//STRIP001 		pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 				new ScUndoImportTab( pDocSh, nTab, nCount, bLink ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	for (i=0; i<nInsCount; i++)
//STRIP001 		GetViewData()->InsertTab(nTab);
//STRIP001 	SetTabNo(nTab,TRUE);
//STRIP001 	pDocSh->PostPaint( 0,0,0, MAXCOL,MAXROW,MAXTAB,
//STRIP001 								PAINT_GRID | PAINT_TOP | PAINT_LEFT | PAINT_EXTRAS );
//STRIP001 
//STRIP001 	SfxApplication* pSfxApp = SFX_APP();
//STRIP001 	pSfxApp->Broadcast( SfxSimpleHint( SC_HINT_TABLES_CHANGED ) );
//STRIP001 	pSfxApp->Broadcast( SfxSimpleHint( SC_HINT_AREAS_CHANGED ) );
//STRIP001 
//STRIP001 	pDocSh->PostPaintExtras();
//STRIP001 	pDocSh->PostPaintGridAll();
//STRIP001 	pDocSh->SetDocumentModified();
//STRIP001 
//STRIP001 	if (bRefs)
//STRIP001 		ErrorMessage(STR_ABSREFLOST);
//STRIP001 	if (bName)
//STRIP001 		ErrorMessage(STR_NAMECONFLICT);
//STRIP001 }


//----------------------------------------------------------------------------
//	Tabelle in anderes Dokument verschieben / kopieren

//STRIP001 void ScViewFunc::MoveTable( USHORT nDestDocNo, USHORT nDestTab, BOOL bCopy )
//STRIP001 {
//STRIP001 	ScDocument* pDoc	   = GetViewData()->GetDocument();
//STRIP001 	ScDocShell* pDocShell  = GetViewData()->GetDocShell();
//STRIP001 	ScDocument*	pDestDoc   = NULL;
//STRIP001 	ScDocShell* pDestShell = NULL;
//STRIP001 	ScTabViewShell* pDestViewSh = NULL;
//STRIP001 	BOOL bUndo (pDoc->IsUndoEnabled());
//STRIP001 
//STRIP001 	BOOL bNewDoc = ( nDestDocNo == SC_DOC_NEW );
//STRIP001 	if ( bNewDoc )
//STRIP001 	{
//STRIP001 		nDestTab = 0;			// als erstes einfgen
//STRIP001 
//STRIP001 		//	ohne SFX_CALLMODE_RECORD ausfuehren, weil schon im Move-Befehl enthalten:
//STRIP001 
//STRIP001 		String aUrl = String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("private:factory/"));
//STRIP001 		aUrl.AppendAscii(RTL_CONSTASCII_STRINGPARAM( STRING_SCAPP ));				// "scalc"
//STRIP001 		SfxStringItem aItem( SID_FILE_NAME, aUrl );
//STRIP001 		SfxStringItem aTarget( SID_TARGETNAME, String::CreateFromAscii("_blank") );
//STRIP001 
//STRIP001 		const SfxPoolItem* pRetItem = GetViewData()->GetDispatcher().Execute(
//STRIP001 					SID_OPENDOC, SFX_CALLMODE_API|SFX_CALLMODE_SYNCHRON, &aItem, &aTarget, 0L );
//STRIP001 		if ( pRetItem )
//STRIP001 		{
//STRIP001 			if ( pRetItem->ISA( SfxObjectItem ) )
//STRIP001 				pDestShell = PTR_CAST( ScDocShell, ((const SfxObjectItem*)pRetItem)->GetShell() );
//STRIP001 			else if ( pRetItem->ISA( SfxViewFrameItem ) )
//STRIP001 			{
//STRIP001 				SfxViewFrame* pFrm = ((const SfxViewFrameItem*)pRetItem)->GetFrame();
//STRIP001 				if (pFrm)
//STRIP001 					pDestShell = PTR_CAST( ScDocShell, pFrm->GetObjectShell() );
//STRIP001 			}
//STRIP001 			if (pDestShell)
//STRIP001 				pDestViewSh = pDestShell->GetBestViewShell();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pDestShell = ScDocShell::GetShellByNum( nDestDocNo );
//STRIP001 
//STRIP001 	if (!pDestShell)
//STRIP001 	{
//STRIP001 		DBG_ERROR("Dest-Doc nicht gefunden !!!");
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	pDestDoc = pDestShell->GetDocument();
//STRIP001 
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 
//STRIP001 	if (pDestDoc != pDoc)
//STRIP001 	{
//STRIP001 		if (bNewDoc)
//STRIP001 		{
//STRIP001 			while (pDestDoc->GetTableCount() > 1)
//STRIP001 				pDestDoc->DeleteTab(0);
//STRIP001 			pDestDoc->RenameTab( 0,
//STRIP001 						String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("______42_____")),
//STRIP001 						FALSE );
//STRIP001 		}
//STRIP001 
//STRIP001 		ScMarkData& rMark		= GetViewData()->GetMarkData();
//STRIP001 		USHORT		nTabCount	= pDoc->GetTableCount();
//STRIP001 		USHORT		nTabSelCount = rMark.GetSelectCount();
//STRIP001 
//STRIP001 		SvUShorts	TheTabs;
//STRIP001 
//STRIP001 		int i;
//STRIP001 		for(i=0;i<nTabCount;i++)
//STRIP001 		{
//STRIP001 			if(rMark.GetTableSelect(i))
//STRIP001 			{
//STRIP001 				String aTabName;
//STRIP001 				pDoc->GetName( i, aTabName);
//STRIP001 				TheTabs.Insert(i,TheTabs.Count());
//STRIP001 				for(USHORT j=i+1;j<nTabCount;j++)
//STRIP001 				{
//STRIP001 					if((!pDoc->IsVisible(j))&&(pDoc->IsScenario(j)))
//STRIP001 					{
//STRIP001 						pDoc->GetName( j, aTabName);
//STRIP001 						TheTabs.Insert(j,TheTabs.Count());
//STRIP001 						i=j;
//STRIP001 					}
//STRIP001 					else break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		GetFrameWin()->EnterWait();
//STRIP001 
//STRIP001 		if (pDoc->GetDrawLayer())
//STRIP001 			pDestShell->MakeDrawLayer();
//STRIP001 
//STRIP001 		if (!bNewDoc && bUndo)
//STRIP001 			pDestDoc->BeginDrawUndo();		// drawing layer must do its own undo actions
//STRIP001 
//STRIP001 		ULONG nErrVal =1;
//STRIP001 		if(nDestTab==0xFFFF) nDestTab=pDestDoc->GetTableCount();
//STRIP001 		USHORT nDestTab1=nDestTab;
//STRIP001 		for( i=0; i<TheTabs.Count(); i++, nDestTab1++ )
//STRIP001 		{	// #63304# insert sheets first and update all references
//STRIP001 			String aName;
//STRIP001 			pDoc->GetName( TheTabs[i], aName );
//STRIP001 			pDestDoc->CreateValidTabName( aName );
//STRIP001 			if ( !pDestDoc->InsertTab( nDestTab1, aName ) )
//STRIP001 			{
//STRIP001 				nErrVal = 0;		// total error
//STRIP001 				break;	// for
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if ( nErrVal > 0 )
//STRIP001 		{
//STRIP001 			nDestTab1 = nDestTab;
//STRIP001 			for(i=0;i<TheTabs.Count();i++)
//STRIP001 			{
//STRIP001 				nErrVal = pDestDoc->TransferTab( pDoc, TheTabs[i], nDestTab1,
//STRIP001 					FALSE );		// no insert
//STRIP001 
//STRIP001 				// TransferTab doesn't copy drawing objects with bInsertNew=FALSE
//STRIP001 				if ( nErrVal > 0 )
//STRIP001 					pDestDoc->TransferDrawPage( pDoc, TheTabs[i], nDestTab1 );
//STRIP001 
//STRIP001 				if(nErrVal>0 && pDoc->IsScenario(TheTabs[i]))
//STRIP001 				{
//STRIP001 					String aComment;
//STRIP001 					Color  aColor;
//STRIP001 					USHORT nFlags;
//STRIP001 
//STRIP001 					pDoc->GetScenarioData(TheTabs[i], aComment,aColor, nFlags);
//STRIP001 					pDestDoc->SetScenario(nDestTab1,TRUE);
//STRIP001 					pDestDoc->SetScenarioData(nDestTab1,aComment,aColor,nFlags);
//STRIP001 					BOOL bActive = pDoc->IsActiveScenario(TheTabs[i]);
//STRIP001 					pDestDoc->SetActiveScenario(nDestTab1, bActive );
//STRIP001 
//STRIP001 					BOOL bVisible=pDoc->IsVisible(TheTabs[i]);
//STRIP001 					pDestDoc->SetVisible(nDestTab1,bVisible );
//STRIP001 
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( nErrVal > 0 && pDoc->IsTabProtected( TheTabs[i] ) )
//STRIP001 					pDestDoc->SetTabProtection( nDestTab1, TRUE, pDoc->GetTabPassword( TheTabs[i] ) );
//STRIP001 
//STRIP001 				nDestTab1++;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		String sName;
//STRIP001 		if (!bNewDoc && bUndo)
//STRIP001 		{
//STRIP001 			pDestDoc->GetName(nDestTab, sName);
//STRIP001 			pDestShell->GetUndoManager()->AddUndoAction(
//STRIP001 							new ScUndoImportTab( pDestShell, nDestTab, TheTabs.Count(), FALSE));
//STRIP001 
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pDestShell->GetUndoManager()->Clear();
//STRIP001 		}
//STRIP001 
//STRIP001 		GetFrameWin()->LeaveWait();
//STRIP001 		switch (nErrVal)
//STRIP001 		{
//STRIP001 			case 0:						// interner Fehler oder voll Fehler
//STRIP001 			{
//STRIP001 				ErrorMessage(STR_TABINSERT_ERROR);
//STRIP001 				return;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 			case 2:
//STRIP001 				ErrorMessage(STR_ABSREFLOST);
//STRIP001 			break;
//STRIP001 			case 3:
//STRIP001 				ErrorMessage(STR_NAMECONFLICT);
//STRIP001 			break;
//STRIP001 			case 4:
//STRIP001 			{
//STRIP001 				ErrorMessage(STR_ABSREFLOST);
//STRIP001 				ErrorMessage(STR_NAMECONFLICT);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 			default:
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		//pDestShell->GetUndoManager()->Clear();		//! Undo implementieren !!!
//STRIP001 /*
//STRIP001 		String sName;
//STRIP001 		pDestDoc->GetName(nDestTab, sName);
//STRIP001 		pDestShell->GetUndoManager()->AddUndoAction(
//STRIP001 						new ScUndoInsertTab( pDestShell, nDestTab, TRUE, sName ) );
//STRIP001 */
//STRIP001 		if (!bCopy)
//STRIP001 		{
//STRIP001 			if(nTabCount!=nTabSelCount)
//STRIP001 				DeleteTables(TheTabs);// incl. Paint & Undo
//STRIP001 			else
//STRIP001 				ErrorMessage(STR_TABREMOVE_ERROR);
//STRIP001 		}
//STRIP001 
//STRIP001 		if (bNewDoc)
//STRIP001 		{
//STRIP001 			//	ChartListenerCollection must be updated before DeleteTab
//STRIP001 			if ( pDestDoc->IsChartListenerCollectionNeedsUpdate() )
//STRIP001 				pDestDoc->UpdateChartListenerCollection();
//STRIP001 
//STRIP001 			pDestDoc->DeleteTab(TheTabs.Count());				// alte erste Tabelle
//STRIP001 //?			pDestDoc->SelectTable(0, TRUE);		// neue erste Tabelle selektieren
//STRIP001 			if (pDestViewSh)
//STRIP001 				pDestViewSh->TabChanged();		// Pages auf dem Drawing-Layer
//STRIP001 			pDestShell->PostPaint( 0,0,0, MAXCOL,MAXROW,MAXTAB,
//STRIP001 									PAINT_GRID | PAINT_TOP | PAINT_LEFT |
//STRIP001 									PAINT_EXTRAS | PAINT_SIZE );
//STRIP001 			//	PAINT_SIZE fuer Gliederung
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pDestShell->Broadcast( ScTablesHint( SC_TAB_INSERTED, nDestTab ) );
//STRIP001 			pDestShell->PostPaintExtras();
//STRIP001 			pDestShell->PostPaintGridAll();
//STRIP001 		}
//STRIP001 
//STRIP001 		TheTabs.Remove(0,TheTabs.Count());
//STRIP001 
//STRIP001 		pDestShell->SetDocumentModified();
//STRIP001 		SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_TABLES_CHANGED ) );
//STRIP001 	}
//STRIP001 	else					// innerhalb des Dokuments
//STRIP001 	{
//STRIP001 
//STRIP001 		ScMarkData& rMark		= GetViewData()->GetMarkData();
//STRIP001 		USHORT		nTabCount	= pDoc->GetTableCount();
//STRIP001 		USHORT		nTabSelCount = rMark.GetSelectCount();
//STRIP001 
//STRIP001 		SvUShorts	TheTabs;
//STRIP001 		SvUShorts	TheDestTabs;
//STRIP001 		SvStrings	TheTabNames;
//STRIP001 		String		aDestName;
//STRIP001 		String		*pString;
//STRIP001 
//STRIP001 		int i;
//STRIP001 		for(i=0;i<nTabCount;i++)
//STRIP001 		{
//STRIP001 			if(rMark.GetTableSelect(i))
//STRIP001 			{
//STRIP001 				String aTabName;
//STRIP001 				pDoc->GetName( i, aTabName);
//STRIP001 				TheTabNames.Insert(new String(aTabName),TheTabNames.Count());
//STRIP001 
//STRIP001 				for(USHORT j=i+1;j<nTabCount;j++)
//STRIP001 				{
//STRIP001 					if((!pDoc->IsVisible(j))&&(pDoc->IsScenario(j)))
//STRIP001 					{
//STRIP001 						pDoc->GetName( j, aTabName);
//STRIP001 						TheTabNames.Insert(new String(aTabName),TheTabNames.Count());
//STRIP001 						i=j;
//STRIP001 					}
//STRIP001 					else break;
//STRIP001 				}
//STRIP001 
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if (bCopy && bUndo)
//STRIP001 			pDoc->BeginDrawUndo();			// drawing layer must do its own undo actions
//STRIP001 
//STRIP001 		pDoc->GetName( nDestTab, aDestName);
//STRIP001 		USHORT nDestTab1=nDestTab;
//STRIP001 		USHORT nMovTab=0;
//STRIP001 		for(i=0;i<TheTabNames.Count();i++)
//STRIP001 		{
//STRIP001 			nTabCount	= pDoc->GetTableCount();
//STRIP001 			pString=TheTabNames[i];
//STRIP001 			if(!pDoc->GetTable(*pString,nMovTab))
//STRIP001 			{
//STRIP001 				nMovTab=nTabCount;
//STRIP001 			}
//STRIP001 			if(!pDoc->GetTable(aDestName,nDestTab1))
//STRIP001 			{
//STRIP001 				nDestTab1=nTabCount;
//STRIP001 			}
//STRIP001 			pDocShell->MoveTable( nMovTab, nDestTab1, bCopy, FALSE );	// Undo ist hier
//STRIP001 
//STRIP001 			if(bCopy && pDoc->IsScenario(nMovTab))
//STRIP001 			{
//STRIP001 				String aComment;
//STRIP001 				Color  aColor;
//STRIP001 				USHORT nFlags;
//STRIP001 
//STRIP001 				pDoc->GetScenarioData(nMovTab, aComment,aColor, nFlags);
//STRIP001 				pDoc->SetScenario(nDestTab1,TRUE);
//STRIP001 				pDoc->SetScenarioData(nDestTab1,aComment,aColor,nFlags);
//STRIP001 				BOOL bActive = pDoc->IsActiveScenario(nMovTab );
//STRIP001 				pDoc->SetActiveScenario( nDestTab1, bActive );
//STRIP001 				BOOL bVisible=pDoc->IsVisible(nMovTab);
//STRIP001 				pDoc->SetVisible(nDestTab1,bVisible );
//STRIP001 			}
//STRIP001 
//STRIP001 			TheTabs.Insert(nMovTab,TheTabs.Count());
//STRIP001 
//STRIP001 			if(!bCopy)
//STRIP001 			{
//STRIP001 				if(!pDoc->GetTable(*pString,nDestTab1))
//STRIP001 				{
//STRIP001 					nDestTab1=nTabCount;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			TheDestTabs.Insert(nDestTab1,TheDestTabs.Count());
//STRIP001 			delete pString;
//STRIP001 		}
//STRIP001 
//STRIP001 		nTab = GetViewData()->GetTabNo();
//STRIP001 
//STRIP001 		if (bUndo)
//STRIP001 		{
//STRIP001 			if (bCopy)
//STRIP001 			{
//STRIP001 				pDocShell->GetUndoManager()->AddUndoAction(
//STRIP001 						new ScUndoCopyTab( pDocShell, TheTabs, TheDestTabs));
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pDocShell->GetUndoManager()->AddUndoAction(
//STRIP001 						new ScUndoMoveTab( pDocShell, TheTabs, TheDestTabs));
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		USHORT nNewTab = nDestTab;
//STRIP001 		if (nNewTab == SC_TAB_APPEND)
//STRIP001 			nNewTab = pDoc->GetTableCount()-1;
//STRIP001 		else if (!bCopy && nTab<nDestTab)
//STRIP001 			nNewTab--;
//STRIP001 
//STRIP001 		SetTabNo( nNewTab, TRUE );
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::ShowTable( const String& rName )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	BOOL bUndo(pDoc->IsUndoEnabled());
//STRIP001 	BOOL bFound = FALSE;
//STRIP001 	USHORT nPos = 0;
//STRIP001 	String aTabName;
//STRIP001 	USHORT nCount = pDoc->GetTableCount();
//STRIP001 	for (USHORT i=0; i<nCount; i++)
//STRIP001 	{
//STRIP001 		pDoc->GetName( i, aTabName );
//STRIP001 		if ( aTabName == rName )
//STRIP001 		{
//STRIP001 			nPos = i;
//STRIP001 			bFound = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bFound)
//STRIP001 	{
//STRIP001 		pDoc->SetVisible( nPos, TRUE );
//STRIP001 		if (bUndo)
//STRIP001 		{
//STRIP001 			pDocSh->GetUndoManager()->AddUndoAction( new ScUndoShowHideTab( pDocSh, nPos, TRUE ) );
//STRIP001 		}
//STRIP001 		SetTabNo( nPos, TRUE );
//STRIP001 		SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_TABLES_CHANGED ) );
//STRIP001 		pDocSh->PostPaint(0,0,0,MAXCOL,MAXROW,MAXTAB, PAINT_EXTRAS);
//STRIP001 		pDocSh->SetDocumentModified();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		Sound::Beep();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::HideTable( USHORT nTab )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	BOOL bUndo(pDoc->IsUndoEnabled());
//STRIP001 	USHORT nVisible = 0;
//STRIP001 	USHORT nCount = pDoc->GetTableCount();
//STRIP001 	for (USHORT i=0; i<nCount; i++)
//STRIP001 	{
//STRIP001 		if (pDoc->IsVisible(i))
//STRIP001 			++nVisible;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nVisible > 1)
//STRIP001 	{
//STRIP001 		pDoc->SetVisible( nTab, FALSE );
//STRIP001 		if (bUndo)
//STRIP001 		{
//STRIP001 			pDocSh->GetUndoManager()->AddUndoAction( new ScUndoShowHideTab( pDocSh, nTab, FALSE ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		//	Views updaten:
//STRIP001 		pDocSh->Broadcast( ScTablesHint( SC_TAB_HIDDEN, nTab ) );
//STRIP001 
//STRIP001 		SetTabNo( nTab, TRUE );
//STRIP001 		SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_TABLES_CHANGED ) );
//STRIP001 		pDocSh->PostPaint(0,0,0,MAXCOL,MAXROW,MAXTAB, PAINT_EXTRAS);
//STRIP001 		pDocSh->SetDocumentModified();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		Sound::Beep();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::InsertSpecialChar( const String& rStr, const Font& rFont )
//STRIP001 {
//STRIP001 	ScEditableTester aTester( this );
//STRIP001 	if (!aTester.IsEditable())
//STRIP001 	{
//STRIP001 		ErrorMessage(aTester.GetMessageId());
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	const sal_Unicode* pChar	= rStr.GetBuffer();
//STRIP001 	ScTabViewShell* pViewShell	= GetViewData()->GetViewShell();
//STRIP001 	SvxFontItem		aFontItem( rFont.GetFamily(),
//STRIP001 							   rFont.GetName(),
//STRIP001 							   rFont.GetStyleName(),
//STRIP001 							   rFont.GetPitch(),
//STRIP001 							   rFont.GetCharSet(),
//STRIP001 							   ATTR_FONT );
//STRIP001 
//STRIP001 	//	if string contains WEAK characters, set all fonts
//STRIP001 	BYTE nScript;
//STRIP001 	ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 	if ( pDoc->HasStringWeakCharacters( rStr ) )
//STRIP001 		nScript = SCRIPTTYPE_LATIN | SCRIPTTYPE_ASIAN | SCRIPTTYPE_COMPLEX;
//STRIP001 	else
//STRIP001 		nScript = pDoc->GetStringScriptType( rStr );
//STRIP001 
//STRIP001 	SvxScriptSetItem aSetItem( SID_ATTR_CHAR_FONT, pViewShell->GetPool() );
//STRIP001 	aSetItem.PutItemForScriptType( nScript, aFontItem );
//STRIP001 	ApplyUserItemSet( aSetItem.GetItemSet() );
//STRIP001 
//STRIP001 	while ( *pChar )
//STRIP001 		pViewShell->TabKeyInput( KeyEvent( *(pChar++), KeyCode() ) );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::UpdateLineAttrs( SvxBorderLine&	   rLine,
//STRIP001 								  const SvxBorderLine* pDestLine,
//STRIP001 								  const SvxBorderLine* pSrcLine,
//STRIP001 								  BOOL 				   bColor )
//STRIP001 {
//STRIP001 	if ( pSrcLine && pDestLine )
//STRIP001 	{
//STRIP001 		if ( bColor )
//STRIP001 		{
//STRIP001 			rLine.SetColor		( pSrcLine->GetColor() );
//STRIP001 			rLine.SetOutWidth	( pDestLine->GetOutWidth() );
//STRIP001 			rLine.SetInWidth	( pDestLine->GetInWidth() );
//STRIP001 			rLine.SetDistance	( pDestLine->GetDistance() );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			rLine.SetColor		( pDestLine->GetColor() );
//STRIP001 			rLine.SetOutWidth	( pSrcLine->GetOutWidth() );
//STRIP001 			rLine.SetInWidth	( pSrcLine->GetInWidth() );
//STRIP001 			rLine.SetDistance	( pSrcLine->GetDistance() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


#define SET_LINE_ATTRIBUTES(LINE,BOXLINE) \
	pBoxLine = aBoxItem.Get##LINE();								\
	if ( pBoxLine )													\
	{																\
		if ( pLine )												\
		{															\
			UpdateLineAttrs( aLine, pBoxLine, pLine, bColorOnly );	\
			aBoxItem.SetLine( &aLine, BOXLINE );					\
		}															\
		else														\
			aBoxItem.SetLine( NULL, BOXLINE );						\
	}


//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::SetSelectionFrameLines( const SvxBorderLine* pLine,
//STRIP001 										 BOOL bColorOnly )
//STRIP001 {
//STRIP001 	// nur wegen Matrix nicht editierbar? Attribute trotzdem ok
//STRIP001 	BOOL bOnlyNotBecauseOfMatrix;
//STRIP001 	if ( !SelectionEditable( &bOnlyNotBecauseOfMatrix ) && !bOnlyNotBecauseOfMatrix )
//STRIP001 	{
//STRIP001 		ErrorMessage(STR_PROTECTIONERR);
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	ScDocument*				pDoc = GetViewData()->GetDocument();
//STRIP001 	ScMarkData&				rMark = GetViewData()->GetMarkData();
//STRIP001 	ScDocShell*				pDocSh = GetViewData()->GetDocShell();
//STRIP001 	const ScPatternAttr*	pSelAttrs = GetSelectionPattern();
//STRIP001 	const SfxPoolItem*		pBorderAttr	= NULL;
//STRIP001 	SfxItemState			eItemState =
//STRIP001 								pSelAttrs->GetItemSet().
//STRIP001 									GetItemState( ATTR_BORDER,
//STRIP001 												  TRUE,
//STRIP001 												  &pBorderAttr );
//STRIP001 
//STRIP001 	if ( eItemState != SFX_ITEM_DEFAULT )
//STRIP001 	{
//STRIP001 		if ( eItemState == SFX_ITEM_SET )
//STRIP001 		{
//STRIP001 			DBG_ASSERT( pBorderAttr, "Border-Attr not set!" );
//STRIP001 			SvxBoxItem		aBoxItem( *(const SvxBoxItem*)pBorderAttr );
//STRIP001 			SvxBoxInfoItem	aBoxInfoItem( ATTR_BORDER_INNER );
//STRIP001 			ScDocument*		pDoc = GetViewData()->GetDocument();
//STRIP001 			SfxItemSet*		pOldSet	= new SfxItemSet(
//STRIP001 											*(pDoc->GetPool()),
//STRIP001 											ATTR_PATTERN_START,
//STRIP001 											ATTR_PATTERN_END );
//STRIP001 			SfxItemSet*		pNewSet	= new SfxItemSet(
//STRIP001 											*(pDoc->GetPool()),
//STRIP001 											ATTR_PATTERN_START,
//STRIP001 											ATTR_PATTERN_END );
//STRIP001 
//STRIP001 			//------------------------------------------------------------
//STRIP001 			const SvxBorderLine*	pBoxLine = NULL;
//STRIP001 			SvxBorderLine			aLine;
//STRIP001 
//STRIP001 			// hier wird die pBoxLine benutzt:
//STRIP001 
//STRIP001 			SET_LINE_ATTRIBUTES(Top,BOX_LINE_TOP)
//STRIP001 			SET_LINE_ATTRIBUTES(Bottom,BOX_LINE_BOTTOM)
//STRIP001 			SET_LINE_ATTRIBUTES(Left,BOX_LINE_LEFT)
//STRIP001 			SET_LINE_ATTRIBUTES(Right,BOX_LINE_RIGHT)
//STRIP001 
//STRIP001 			aBoxInfoItem.SetLine( aBoxItem.GetTop(), BOXINFO_LINE_HORI );
//STRIP001 			aBoxInfoItem.SetLine( aBoxItem.GetLeft(), BOXINFO_LINE_VERT );
//STRIP001 			aBoxInfoItem.ResetFlags(); // Lines auf Valid setzen
//STRIP001 
//STRIP001 			pOldSet->Put( *pBorderAttr );
//STRIP001 			pNewSet->Put( aBoxItem );
//STRIP001 			pNewSet->Put( aBoxInfoItem );
//STRIP001 
//STRIP001 			ApplyAttributes( pNewSet, pOldSet );
//STRIP001 
//STRIP001 			delete pOldSet;
//STRIP001 			delete pNewSet;
//STRIP001 		}
//STRIP001 		else // if ( eItemState == SFX_ITEM_DONTCARE )
//STRIP001 		{
//STRIP001 			rMark.MarkToMulti();
//STRIP001 			pDoc->ApplySelectionLineStyle( rMark, pLine, bColorOnly );
//STRIP001 		}
//STRIP001 
//STRIP001 		ScRange aMarkRange;
//STRIP001 		rMark.GetMultiMarkArea( aMarkRange );
//STRIP001 		USHORT nStartCol = aMarkRange.aStart.Col();
//STRIP001 		USHORT nStartRow = aMarkRange.aStart.Row();
//STRIP001 		USHORT nStartTab = aMarkRange.aStart.Tab();
//STRIP001 		USHORT nEndCol = aMarkRange.aEnd.Col();
//STRIP001 		USHORT nEndRow = aMarkRange.aEnd.Row();
//STRIP001 		USHORT nEndTab = aMarkRange.aEnd.Tab();
//STRIP001 		pDocSh->PostPaint( nStartCol, nStartRow, nStartTab,
//STRIP001 						   nEndCol, nEndRow, nEndTab,
//STRIP001 						   PAINT_GRID, SC_PF_LINES | SC_PF_TESTMERGE );
//STRIP001 
//STRIP001 		pDocSh->UpdateOle( GetViewData() );
//STRIP001 		pDocSh->SetDocumentModified();
//STRIP001 	}
//STRIP001 }

#undef SET_LINE_ATTRIBUTES


//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::SetConditionalFormat( const ScConditionalFormat& rNew )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 	ULONG nIndex = pDoc->AddCondFormat(rNew);			// dafuer gibt's kein Undo
//STRIP001 	SfxUInt32Item aItem( ATTR_CONDITIONAL, nIndex );
//STRIP001 
//STRIP001 	ApplyAttr( aItem );			// mit Paint und Undo...
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScViewFunc::SetValidation( const ScValidationData& rNew )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 	ULONG nIndex = pDoc->AddValidationEntry(rNew);		// dafuer gibt's kein Undo
//STRIP001 	SfxUInt32Item aItem( ATTR_VALIDDATA, nIndex );
//STRIP001 
//STRIP001 	ApplyAttr( aItem );			// mit Paint und Undo...
//STRIP001 }


}
