/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_viewfunc.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:42:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------

#define _MACRODLG_HXX
#define _BIGINT_HXX
#define _SVDXOUT_HXX
#define _SVDATTR_HXX
#define _SVDSURO_HXX

// INCLUDE ---------------------------------------------------------------

#include "scitems.hxx"
// auto strip #include <bf_svx/eeitem.hxx>
#define ITEMID_FIELD EE_FEATURE_FIELD

// auto strip #include <bf_svx/algitem.hxx>
// auto strip #include <bf_svx/boxitem.hxx>
// auto strip #include <bf_svx/editobj.hxx>
// auto strip #include <bf_svx/editview.hxx>
// auto strip #include <bf_svx/langitem.hxx>
// auto strip #include <bf_svx/scripttypeitem.hxx>
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #include <svtools/zforlist.hxx>
// auto strip #include <svtools/zformat.hxx>
// auto strip #include <vcl/msgbox.hxx>
// auto strip #include <vcl/sound.hxx>
// auto strip #include <vcl/virdev.hxx>
// auto strip #include <vcl/waitobj.hxx>
// auto strip #include <vcl/wrkwin.hxx>
#include <stdlib.h>				// qsort

// auto strip #include "viewfunc.hxx"
#include "tabvwsh.hxx"
#include "docsh.hxx"
// auto strip #include "attrib.hxx"
// auto strip #include "patattr.hxx"
// auto strip #include "docpool.hxx"
// auto strip #include "uiitems.hxx"
#include "bf_sc.hrc"
// auto strip #include "undocell.hxx"
// auto strip #include "undoblk.hxx"
// auto strip #include "undotab.hxx"
// auto strip #include "refundo.hxx"
// auto strip #include "dbcolect.hxx"
// auto strip #include "olinetab.hxx"
// auto strip #include "rangeutl.hxx"
// auto strip #include "rangenam.hxx"
#include "globstr.hrc"
// auto strip #include "global.hxx"
#include "stlsheet.hxx"
// auto strip #include "editutil.hxx"
// auto strip #include "namecrea.hxx"			// wegen Flags
// auto strip #include "cell.hxx"
// auto strip #include "scresid.hxx"
// auto strip #include "inputhdl.hxx"
// auto strip #include "scmod.hxx"
// auto strip #include "inputopt.hxx"
// auto strip #include "compiler.hxx"
// auto strip #include "docfunc.hxx"
// auto strip #include "appoptio.hxx"
#include "dociter.hxx"
// auto strip #include "sizedev.hxx"
// auto strip #include "editable.hxx"
namespace binfilter {

//==================================================================

/*N*/ ScViewFunc::ScViewFunc( Window* pParent, ScDocShell& rDocSh, ScTabViewShell* pViewShell ) :
/*N*/ 	ScTabView( pParent, rDocSh, pViewShell ),
/*N*/ 	bFormatValid( FALSE )
/*N*/ {
/*N*/ }

/*N*/ ScViewFunc::ScViewFunc( Window* pParent, const ScViewFunc& rViewFunc, ScTabViewShell* pViewShell ) :
/*N*/ 	ScTabView( pParent, rViewFunc, pViewShell ),
/*N*/ 	bFormatValid( FALSE )
/*N*/ {
/*N*/ }

/*N*/ ScViewFunc::~ScViewFunc()
/*N*/ {
/*N*/ }

//------------------------------------------------------------------------------------

//STRIP001 void ScViewFunc::StartFormatArea()
//STRIP001 {
//STRIP001 	//	ueberhaupt aktiviert?
//STRIP001 	if ( !SC_MOD()->GetInputOptions().GetExtendFormat() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	//	start only with single cell (marked or cursor position)
//STRIP001 	ScRange aMarkRange;
//STRIP001 	BOOL bOk = GetViewData()->GetSimpleArea( aMarkRange );
//STRIP001 	if ( bOk && aMarkRange.aStart != aMarkRange.aEnd )
//STRIP001 		bOk = FALSE;
//STRIP001 
//STRIP001 	if (bOk)
//STRIP001 	{
//STRIP001 		bFormatValid = TRUE;
//STRIP001 		aFormatSource = aMarkRange.aStart;
//STRIP001 		aFormatArea = ScRange( aFormatSource );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		bFormatValid = FALSE;		// keinen alten Bereich behalten
//STRIP001 }

//STRIP001 BOOL ScViewFunc::TestFormatArea( USHORT nCol, USHORT nRow, USHORT nTab, BOOL bAttrChanged )
//STRIP001 {
//STRIP001 	//	ueberhaupt aktiviert?
//STRIP001 	if ( !SC_MOD()->GetInputOptions().GetExtendFormat() )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	//	Test: Eingabe mit Zahlformat (bAttrChanged) immer als neue Attributierung behandeln
//STRIP001 	//	(alte Area verwerfen). Wenn das nicht gewollt ist, den if-Teil weglassen:
//STRIP001 	if ( bAttrChanged )
//STRIP001 	{
//STRIP001 		StartFormatArea();
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	//!	Abfrage, ob Zelle leer war ???
//STRIP001 
//STRIP001 	BOOL bFound = FALSE;
//STRIP001 	ScRange aNewRange = aFormatArea;
//STRIP001 	if ( bFormatValid && nTab == aFormatSource.Tab() )
//STRIP001 	{
//STRIP001 		if ( nRow >= aFormatArea.aStart.Row() && nRow <= aFormatArea.aEnd.Row() )
//STRIP001 		{
//STRIP001 			//	innerhalb ?
//STRIP001 			if ( nCol >= aFormatArea.aStart.Col() && nCol <= aFormatArea.aEnd.Col() )
//STRIP001 			{
//STRIP001 				bFound = TRUE;			// Bereich nicht aendern
//STRIP001 			}
//STRIP001 			//	links ?
//STRIP001 			if ( nCol+1 == aFormatArea.aStart.Col() )
//STRIP001 			{
//STRIP001 				bFound = TRUE;
//STRIP001 				aNewRange.aStart.SetCol( nCol );
//STRIP001 			}
//STRIP001 			//	rechts ?
//STRIP001 			if ( nCol == aFormatArea.aEnd.Col()+1 )
//STRIP001 			{
//STRIP001 				bFound = TRUE;
//STRIP001 				aNewRange.aEnd.SetCol( nCol );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if ( nCol >= aFormatArea.aStart.Col() && nCol <= aFormatArea.aEnd.Col() )
//STRIP001 		{
//STRIP001 			//	oben ?
//STRIP001 			if ( nRow+1 == aFormatArea.aStart.Row() )
//STRIP001 			{
//STRIP001 				bFound = TRUE;
//STRIP001 				aNewRange.aStart.SetRow( nRow );
//STRIP001 			}
//STRIP001 			//	unten ?
//STRIP001 			if ( nRow == aFormatArea.aEnd.Row()+1 )
//STRIP001 			{
//STRIP001 				bFound = TRUE;
//STRIP001 				aNewRange.aEnd.SetRow( nRow );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bFound)
//STRIP001 		aFormatArea = aNewRange;	// erweitern
//STRIP001 	else
//STRIP001 	{
//STRIP001 		bFormatValid = FALSE;		// ausserhalb -> abbrechen
//STRIP001 		if ( bAttrChanged )			// Wert mit Zahlformat eingegeben?
//STRIP001 			StartFormatArea();		// dann ggf. neu starten
//STRIP001 	}
//STRIP001 
//STRIP001 	return bFound;
//STRIP001 }

//STRIP001 void ScViewFunc::DoAutoAttributes( USHORT nCol, USHORT nRow, USHORT nTab,
//STRIP001 									BOOL bAttrChanged, BOOL bAddUndo )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	if (bAddUndo && !pDoc->IsUndoEnabled())
//STRIP001 		bAddUndo = FALSE;
//STRIP001 
//STRIP001 	const ScPatternAttr* pSource = pDoc->GetPattern(
//STRIP001 							aFormatSource.Col(), aFormatSource.Row(), nTab );
//STRIP001 	if ( !((const ScMergeAttr&)pSource->GetItem(ATTR_MERGE)).IsMerged() )
//STRIP001 	{
//STRIP001 		const ScPatternAttr* pDocOld = pDoc->GetPattern( nCol, nRow, nTab );
//STRIP001 		//	pDocOld ist nur bis zum Apply... gueltig!
//STRIP001 
//STRIP001 		ScPatternAttr* pOldPattern = NULL;
//STRIP001 		if ( bAddUndo )
//STRIP001 			pOldPattern = new ScPatternAttr( *pDocOld );
//STRIP001 
//STRIP001 		const ScStyleSheet* pSrcStyle = pSource->GetStyleSheet();
//STRIP001 		if ( pSrcStyle && pSrcStyle != pDocOld->GetStyleSheet() )
//STRIP001 			pDoc->ApplyStyle( nCol, nRow, nTab, *pSrcStyle );
//STRIP001 		pDoc->ApplyPattern( nCol, nRow, nTab, *pSource );
//STRIP001 		AdjustRowHeight( nRow, nRow, TRUE );				//! nicht doppelt ?
//STRIP001 
//STRIP001 		if ( bAddUndo )
//STRIP001 		{
//STRIP001 			const ScPatternAttr* pNewPattern = pDoc->GetPattern( nCol, nRow, nTab );
//STRIP001 
//STRIP001 			pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 						new ScUndoCursorAttr( pDocSh, nCol, nRow, nTab,
//STRIP001 											  pOldPattern, pNewPattern, pSource,
//STRIP001 											  TRUE ) );
//STRIP001 
//STRIP001 			delete pOldPattern;		// wird im Undo kopiert (Pool)
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bAttrChanged )								// Wert mit Zahlformat eingegeben?
//STRIP001 		aFormatSource.Set( nCol, nRow, nTab );		// dann als neue Quelle
//STRIP001 }

//------------------------------------------------------------------------------------

//		Hilfsroutinen

//STRIP001 USHORT ScViewFunc::GetOptimalColWidth( USHORT nCol, USHORT nTab, BOOL bFormula )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 
//STRIP001 	double nPPTX = GetViewData()->GetPPTX();
//STRIP001 	double nPPTY = GetViewData()->GetPPTY();
//STRIP001 	Fraction aZoomX = GetViewData()->GetZoomX();
//STRIP001 	Fraction aZoomY = GetViewData()->GetZoomY();
//STRIP001 
//STRIP001 	ScSizeDeviceProvider aProv(pDocSh);
//STRIP001 	if (aProv.IsPrinter())
//STRIP001 	{
//STRIP001 		nPPTX = aProv.GetPPTX();
//STRIP001 		nPPTY = aProv.GetPPTY();
//STRIP001 		aZoomX = aZoomY = Fraction( 1, 1 );
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nTwips = pDoc->GetOptimalColWidth( nCol, nTab, aProv.GetDevice(),
//STRIP001 								nPPTX, nPPTY, aZoomX, aZoomY, bFormula, &rMark );
//STRIP001 	return nTwips;
//STRIP001 }

/*N*/ BOOL ScViewFunc::SelectionEditable( BOOL* pOnlyNotBecauseOfMatrix /* = NULL */ )
/*N*/ {
/*N*/ 	BOOL bRet;
/*N*/ 	ScDocument* pDoc = GetViewData()->GetDocument();
/*N*/ 	ScMarkData& rMark = GetViewData()->GetMarkData();
/*N*/ 	if (rMark.IsMarked() || rMark.IsMultiMarked())
/*?*/ 		bRet = pDoc->IsSelectionEditable( rMark, pOnlyNotBecauseOfMatrix );
/*N*/ 	else
/*N*/ 	{
/*N*/ 		USHORT nCol = GetViewData()->GetCurX();
/*N*/ 		USHORT nRow = GetViewData()->GetCurY();
/*N*/ 		USHORT nTab = GetViewData()->GetTabNo();
/*N*/ 		bRet = pDoc->IsBlockEditable( nTab, nCol, nRow, nCol, nRow,
/*N*/ 			pOnlyNotBecauseOfMatrix );
/*N*/ 	}
/*N*/ 	return bRet;
/*N*/ }

#ifndef	LRU_MAX
#define LRU_MAX 10
#endif

//STRIP001 BOOL lcl_FunctionKnown( USHORT nOpCode )
//STRIP001 {
//STRIP001 	const ScFunctionList* pFuncList = ScGlobal::GetStarCalcFunctionList();
//STRIP001 	if ( pFuncList )
//STRIP001 	{
//STRIP001 		ULONG nCount = pFuncList->GetCount();
//STRIP001 		for (ULONG i=0; i<nCount; i++)
//STRIP001 			if ( pFuncList->GetFunction(i)->nFIndex == nOpCode )
//STRIP001 				return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 BOOL lcl_AddFunction( ScAppOptions& rAppOpt, USHORT nOpCode )
//STRIP001 {
//STRIP001 	USHORT nOldCount = rAppOpt.GetLRUFuncListCount();
//STRIP001 	USHORT* pOldList = rAppOpt.GetLRUFuncList();
//STRIP001 	USHORT nPos;
//STRIP001 	for (nPos=0; nPos<nOldCount; nPos++)
//STRIP001 		if (pOldList[nPos] == nOpCode)			// is the function already in the list?
//STRIP001 		{
//STRIP001 			if ( nPos == 0 )
//STRIP001 				return FALSE;					// already at the top -> no change
//STRIP001 
//STRIP001 			//	count doesn't change, so the original array is modified
//STRIP001 
//STRIP001 			for (USHORT nCopy=nPos; nCopy>0; nCopy--)
//STRIP001 				pOldList[nCopy] = pOldList[nCopy-1];
//STRIP001 			pOldList[0] = nOpCode;
//STRIP001 
//STRIP001 			return TRUE;						// list has changed
//STRIP001 		}
//STRIP001 
//STRIP001 	if ( !lcl_FunctionKnown( nOpCode ) )
//STRIP001 		return FALSE;							// not in function list -> no change
//STRIP001 
//STRIP001 	USHORT nNewCount = Min( (USHORT)(nOldCount + 1), (USHORT)LRU_MAX );
//STRIP001 	USHORT nNewList[LRU_MAX];
//STRIP001 	nNewList[0] = nOpCode;
//STRIP001 	for (nPos=1; nPos<nNewCount; nPos++)
//STRIP001 		nNewList[nPos] = pOldList[nPos-1];
//STRIP001 	rAppOpt.SetLRUFuncList( nNewList, nNewCount );
//STRIP001 
//STRIP001 	return TRUE;								// list has changed
//STRIP001 }

//		eigentliche Funktionen

//	Eingabe - Undo OK

//STRIP001 void ScViewFunc::EnterData( USHORT nCol, USHORT nRow, USHORT nTab, const String& rString,
//STRIP001 							BOOL bRecord )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 	SvNumberFormatter& rFormatter = *pDoc->GetFormatTable();
//STRIP001 	ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 	USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 	USHORT nSelCount = rMark.GetSelectCount();
//STRIP001 	USHORT i;
//STRIP001 	if (bRecord && !pDoc->IsUndoEnabled())
//STRIP001 		bRecord = FALSE;
//STRIP001 
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocShellModificator aModificator( *pDocSh );
//STRIP001 
//STRIP001 	ScEditableTester aTester( pDoc, nCol,nRow, nCol,nRow, rMark );
//STRIP001 	if (aTester.IsEditable())
//STRIP001 	{
//STRIP001 		BOOL bEditDeleted = FALSE;
//STRIP001 		BYTE nOldScript = 0;
//STRIP001 
//STRIP001 		ScBaseCell** ppOldCells	= NULL;
//STRIP001 		BOOL* pHasFormat		= NULL;
//STRIP001 		ULONG* pOldFormats		= NULL;
//STRIP001 		USHORT* pTabs			= NULL;
//STRIP001 		USHORT nUndoPos = 0;
//STRIP001 		if ( bRecord )
//STRIP001 		{
//STRIP001 			ppOldCells		= new ScBaseCell*[nSelCount];
//STRIP001 			pHasFormat		= new BOOL[nSelCount];
//STRIP001 			pOldFormats		= new ULONG[nSelCount];
//STRIP001 			pTabs			= new USHORT[nSelCount];
//STRIP001 			nUndoPos = 0;
//STRIP001 
//STRIP001 			for (i=0; i<nTabCount; i++)
//STRIP001 				if (rMark.GetTableSelect(i))
//STRIP001 				{
//STRIP001 					pTabs[nUndoPos] = i;
//STRIP001 					ScBaseCell* pDocCell;
//STRIP001 					pDoc->GetCell( nCol, nRow, i, pDocCell );
//STRIP001 					if ( pDocCell )
//STRIP001 					{
//STRIP001 						ppOldCells[nUndoPos] = pDocCell->Clone(pDoc);
//STRIP001 						if ( pDocCell->GetCellType() == CELLTYPE_EDIT )
//STRIP001 							bEditDeleted = TRUE;
//STRIP001 
//STRIP001 						BYTE nDocScript = pDoc->GetScriptType( nCol, nRow, i, pDocCell );
//STRIP001 						if ( nOldScript == 0 )
//STRIP001 							nOldScript = nDocScript;
//STRIP001 						else if ( nDocScript != nOldScript )
//STRIP001 							bEditDeleted = TRUE;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						ppOldCells[nUndoPos] = NULL;
//STRIP001 					}
//STRIP001 
//STRIP001 					const SfxPoolItem* pItem;
//STRIP001 					const ScPatternAttr* pPattern = pDoc->GetPattern(nCol, nRow, i);
//STRIP001 					if ( SFX_ITEM_SET == pPattern->GetItemSet().GetItemState(
//STRIP001 											ATTR_VALUE_FORMAT,FALSE,&pItem) )
//STRIP001 					{
//STRIP001 						pHasFormat[nUndoPos] = TRUE;
//STRIP001 						pOldFormats[nUndoPos] = ((const SfxUInt32Item*)pItem)->GetValue();
//STRIP001 					}
//STRIP001 					else
//STRIP001 						pHasFormat[nUndoPos] = FALSE;
//STRIP001 
//STRIP001 					++nUndoPos;
//STRIP001 				}
//STRIP001 
//STRIP001 			DBG_ASSERT( nUndoPos==nSelCount, "nUndoPos!=nSelCount" );
//STRIP001 		}
//STRIP001 
//STRIP001 		BOOL bNumFmtChanged = FALSE;
//STRIP001 		// einzelnes '=' ist String (wird fuer Spezialfilter so gebraucht)
//STRIP001 		if ( rString.GetChar(0) == '=' && rString.Len() > 1 )
//STRIP001 		{	// Formel, compile mit AutoCorrection
//STRIP001 			for (i=0; i<nTabCount; i++)
//STRIP001 				if (rMark.GetTableSelect(i))
//STRIP001 					break;
//STRIP001 			ScAddress aPos( nCol, nRow, i );
//STRIP001 			ScCompiler aComp( pDoc, aPos );
//STRIP001 //2do: AutoCorrection via CalcOptions abschaltbar machen
//STRIP001 			aComp.SetAutoCorrection( TRUE );
//STRIP001 			String aFormula( rString );
//STRIP001 			ScTokenArray* pArr;
//STRIP001 			BOOL bAgain;
//STRIP001 			do
//STRIP001 			{
//STRIP001 				bAgain = FALSE;
//STRIP001 				BOOL bAddEqual = FALSE;
//STRIP001 				ScTokenArray* pArrFirst = pArr = aComp.CompileString( aFormula );
//STRIP001 				BOOL bCorrected = aComp.IsCorrected();
//STRIP001 				if ( bCorrected )
//STRIP001 				{	// probieren, mit erster Parser-Korrektur neu zu parsen
//STRIP001 					pArr = aComp.CompileString( aComp.GetCorrectedFormula() );
//STRIP001 				}
//STRIP001 				if ( !pArr->GetError() )
//STRIP001 				{
//STRIP001 					bAddEqual = TRUE;
//STRIP001 					aComp.CompileTokenArray();
//STRIP001 					bCorrected |= aComp.IsCorrected();
//STRIP001 				}
//STRIP001 				if ( bCorrected )
//STRIP001 				{
//STRIP001 					String aCorrectedFormula;
//STRIP001 					if ( bAddEqual )
//STRIP001 					{
//STRIP001 						aCorrectedFormula = '=';
//STRIP001 						aCorrectedFormula += aComp.GetCorrectedFormula();
//STRIP001 					}
//STRIP001 					else
//STRIP001 						aCorrectedFormula = aComp.GetCorrectedFormula();
//STRIP001 					short nResult;
//STRIP001 					if ( aCorrectedFormula.Len() == 1 )
//STRIP001 						nResult = RET_NO;	// leere Formel, nur '='
//STRIP001 					else
//STRIP001 					{
//STRIP001 						String aMessage( ScResId( SCSTR_FORMULA_AUTOCORRECTION ) );
//STRIP001 						aMessage += aCorrectedFormula;
//STRIP001 						nResult = QueryBox( GetViewData()->GetDialogParent(),
//STRIP001 												WinBits(WB_YES_NO | WB_DEF_YES),
//STRIP001 												aMessage ).Execute();
//STRIP001 					}
//STRIP001 					if ( nResult == RET_YES )
//STRIP001 					{
//STRIP001 						aFormula = aCorrectedFormula;
//STRIP001 						if ( pArr != pArrFirst )
//STRIP001 							delete pArrFirst;
//STRIP001 						bAgain = TRUE;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						if ( pArr != pArrFirst )
//STRIP001 						{
//STRIP001 							delete pArr;
//STRIP001 							pArr = pArrFirst;
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			} while ( bAgain );
//STRIP001 			// um in mehreren Tabellen eingesetzt zu werden, muss die Formel
//STRIP001 			// via ScFormulaCell copy-ctor evtl. wegen RangeNames neu kompiliert
//STRIP001 			// werden, gleiches Code-Array fuer alle Zellen geht nicht.
//STRIP001 			// Wenn das Array einen Fehler enthaelt, muss in den neu erzeugten
//STRIP001 			// Zellen RPN geloescht und der Fehler explizit gesetzt werden, da
//STRIP001 			// via FormulaCell copy-ctor und Interpreter das, wenn moeglich,
//STRIP001 			// wieder glattgebuegelt wird, zu intelligent.. z.B.: =1))
//STRIP001 			USHORT nError = pArr->GetError();
//STRIP001 			if ( !nError )
//STRIP001 			{
//STRIP001 				//	#68693# update list of recent functions with all functions that
//STRIP001 				//	are not within parentheses
//STRIP001 
//STRIP001 				ScModule* pScMod = SC_MOD();
//STRIP001 				ScAppOptions aAppOpt = pScMod->GetAppOptions();
//STRIP001 				BOOL bOptChanged = FALSE;
//STRIP001 
//STRIP001 				ScToken** ppToken = pArr->GetArray();
//STRIP001 				USHORT nTokens = pArr->GetLen();
//STRIP001 				USHORT nLevel = 0;
//STRIP001 				for (USHORT nTP=0; nTP<nTokens; nTP++)
//STRIP001 				{
//STRIP001 					ScToken* pTok = ppToken[nTP];
//STRIP001 					OpCode eOp = pTok->GetOpCode();
//STRIP001 					if ( eOp == ocOpen )
//STRIP001 						++nLevel;
//STRIP001 					else if ( eOp == ocClose && nLevel )
//STRIP001 						--nLevel;
//STRIP001 					if ( nLevel == 0 && pTok->IsFunction() && lcl_AddFunction( aAppOpt, eOp ) )
//STRIP001 						bOptChanged = TRUE;
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( bOptChanged )
//STRIP001 				{
//STRIP001 					pScMod->SetAppOptions(aAppOpt);
//STRIP001 					pScMod->RecentFunctionsChanged();
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			ScFormulaCell aCell( pDoc, aPos, pArr, 0 );
//STRIP001 			delete pArr;
//STRIP001 			BOOL bAutoCalc = pDoc->GetAutoCalc();
//STRIP001 			SvNumberFormatter* pFormatter = pDoc->GetFormatTable();
//STRIP001 			for ( ; i<nTabCount; i++)
//STRIP001 			{
//STRIP001 				if (rMark.GetTableSelect(i))
//STRIP001 				{
//STRIP001 					aPos.SetTab( i );
//STRIP001 					ULONG nIndex = (ULONG) ((SfxUInt32Item*) pDoc->GetAttr(
//STRIP001 						nCol, nRow, i, ATTR_VALUE_FORMAT ))->GetValue();
//STRIP001 					if ( pFormatter->GetType(nIndex) == NUMBERFORMAT_TEXT )
//STRIP001 					{
//STRIP001 						ScStringCell* pCell = new ScStringCell( aFormula );
//STRIP001 						pDoc->PutCell( aPos, pCell );
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						ScFormulaCell* pCell = new ScFormulaCell( pDoc, aPos, aCell );
//STRIP001 						if ( nError )
//STRIP001 						{
//STRIP001 							pCell->GetCode()->DelRPN();
//STRIP001 							pCell->SetErrCode( nError );
//STRIP001 						}
//STRIP001 						pDoc->PutCell( aPos, pCell );
//STRIP001 						if ( !bAutoCalc )
//STRIP001 						{	// einmal nur die Zelle berechnen und wieder dirty setzen
//STRIP001 							pCell->Interpret();
//STRIP001 							pCell->SetDirtyVar();
//STRIP001 							pDoc->PutInFormulaTree( pCell );
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			for (i=0; i<nTabCount; i++)
//STRIP001 				if (rMark.GetTableSelect(i))
//STRIP001 					if (pDoc->SetString( nCol, nRow, i, rString ))
//STRIP001 						bNumFmtChanged = TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001 		//	row height must be changed if new text has a different script type
//STRIP001 		for (i=0; i<nTabCount && !bEditDeleted; i++)
//STRIP001 			if (rMark.GetTableSelect(i))
//STRIP001 				if ( pDoc->GetScriptType( nCol, nRow, i ) != nOldScript )
//STRIP001 					bEditDeleted = TRUE;
//STRIP001 
//STRIP001 		HideAllCursors();
//STRIP001 
//STRIP001 		if (bEditDeleted || pDoc->HasAttrib( nCol, nRow, nTab, nCol, nRow, nTab, HASATTR_NEEDHEIGHT ))
//STRIP001 			AdjustRowHeight(nRow,nRow);
//STRIP001 
//STRIP001 		BOOL bAutoFormat = TestFormatArea(nCol, nRow, nTab, bNumFmtChanged);
//STRIP001 		if (bAutoFormat)
//STRIP001 			DoAutoAttributes(nCol, nRow, nTab, bNumFmtChanged, bRecord);
//STRIP001 
//STRIP001 		if ( bRecord )
//STRIP001 		{	// wg. ChangeTrack erst jetzt
//STRIP001 			pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 				new ScUndoEnterData( pDocSh, nCol, nRow, nTab, nUndoPos, pTabs,
//STRIP001 									 ppOldCells, pHasFormat, pOldFormats,
//STRIP001 									 rString, NULL ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		for (i=0; i<nTabCount; i++)
//STRIP001 			if (rMark.GetTableSelect(i))
//STRIP001 				pDocSh->PostPaintCell( nCol, nRow, i );
//STRIP001 
//STRIP001 		ShowAllCursors();
//STRIP001 
//STRIP001 		pDocSh->UpdateOle(GetViewData());
//STRIP001 		aModificator.SetDocumentModified();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		ErrorMessage(aTester.GetMessageId());
//STRIP001 		PaintArea( nCol, nRow, nCol, nRow );		// da steht evtl. noch die Edit-Engine
//STRIP001 	}
//STRIP001 }

//	Wert in einzele Zelle eintragen (nur auf nTab)
//!	umbenennen in EnterValue !!!!

//STRIP001 void ScViewFunc::EnterData( USHORT nCol, USHORT nRow, USHORT nTab, const double& rValue )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	BOOL bUndo (pDoc->IsUndoEnabled());
//STRIP001 
//STRIP001 	if ( pDoc && pDocSh )
//STRIP001 	{
//STRIP001 		ScDocShellModificator aModificator( *pDocSh );
//STRIP001 
//STRIP001 		ScEditableTester aTester( pDoc, nTab, nCol,nRow, nCol,nRow );
//STRIP001 		if (aTester.IsEditable())
//STRIP001 		{
//STRIP001 			ScBaseCell* pOldCell;
//STRIP001 			pDoc->GetCell( nCol, nRow, nTab, pOldCell );
//STRIP001 			BOOL bNeedHeight = ( pOldCell && pOldCell->GetCellType() == CELLTYPE_EDIT )
//STRIP001 								|| pDoc->HasAttrib(
//STRIP001 									nCol,nRow,nTab, nCol,nRow,nTab, HASATTR_NEEDHEIGHT );
//STRIP001 
//STRIP001 			//	Undo
//STRIP001 			ScBaseCell* pUndoCell = NULL;
//STRIP001 			if (bUndo)
//STRIP001 			{
//STRIP001 				pUndoCell = pOldCell ? pOldCell->Clone(pDoc) : NULL;
//STRIP001 			}
//STRIP001 
//STRIP001 			pDoc->SetValue( nCol, nRow, nTab, rValue );
//STRIP001 
//STRIP001 			// wg. ChangeTrack nach Aenderung im Dokument
//STRIP001 			if (bUndo)
//STRIP001 			{
//STRIP001 				pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 					new ScUndoEnterValue( pDocSh, ScAddress(nCol,nRow,nTab),
//STRIP001 											pUndoCell, rValue, bNeedHeight ) );
//STRIP001 			}
//STRIP001 
/*!				Zeilenhoehe anpassen? Dann auch bei Undo...
			if (bNeedHeight)
				AdjustRowHeight(nRow,nRow);
*/
//STRIP001 
//STRIP001 			pDocSh->PostPaintCell( nCol, nRow, nTab );
//STRIP001 			pDocSh->UpdateOle(GetViewData());
//STRIP001 			aModificator.SetDocumentModified();
//STRIP001 		}
//STRIP001 		else
//STRIP001 			ErrorMessage(aTester.GetMessageId());
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScViewFunc::EnterData( USHORT nCol, USHORT nRow, USHORT nTab, const EditTextObject* pData,
//STRIP001 							BOOL bRecord, BOOL bTestSimple )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	if (bRecord && !pDoc->IsUndoEnabled())
//STRIP001 		bRecord = FALSE;
//STRIP001 
//STRIP001 	ScDocShellModificator aModificator( *pDocSh );
//STRIP001 
//STRIP001 	ScEditableTester aTester( pDoc, nTab, nCol,nRow, nCol,nRow );
//STRIP001 	if (aTester.IsEditable())
//STRIP001 	{
//STRIP001 		//
//STRIP001 		// 		Test auf Attribute
//STRIP001 		//
//STRIP001 		BOOL bSimple = FALSE;
//STRIP001 		BOOL bCommon = FALSE;
//STRIP001 		ScPatternAttr* pCellAttrs = NULL;
//STRIP001 		EditTextObject* pNewData = NULL;
//STRIP001 		String aString;
//STRIP001 		if (bTestSimple)					// Testen, ob einfacher String ohne Attribute
//STRIP001 		{
//STRIP001 			const ScPatternAttr* pOldPattern = pDoc->GetPattern( nCol, nRow, nTab );
//STRIP001 			ScTabEditEngine aEngine( *pOldPattern, pDoc->GetEnginePool() );
//STRIP001 			aEngine.SetText(*pData);
//STRIP001 
//STRIP001 			ScEditAttrTester aTester( &aEngine );
//STRIP001 			bSimple = !aTester.NeedsObject();
//STRIP001 			bCommon = aTester.NeedsCellAttr();
//STRIP001 
//STRIP001 			// formulas have to be recognized even if they're formatted
//STRIP001 			// (but commmon attributes are still collected)
//STRIP001 
//STRIP001 			if ( !bSimple && aEngine.GetParagraphCount() == 1 )
//STRIP001 			{
//STRIP001 				String aParStr = aEngine.GetText( (USHORT) 0 );
//STRIP001 				if ( aParStr.GetChar(0) == '=' )
//STRIP001 					bSimple = TRUE;
//STRIP001 			}
//STRIP001 
//STRIP001 			if (bCommon)				// Attribute fuer Tabelle
//STRIP001 			{
//STRIP001 				pCellAttrs = new ScPatternAttr( *pOldPattern );
//STRIP001 				pCellAttrs->GetFromEditItemSet( &aTester.GetAttribs() );
//STRIP001 				//!	remove common attributes from EditEngine?
//STRIP001 			}
//STRIP001 
//STRIP001 			if (bSimple)
//STRIP001 				aString = aEngine.GetText();
//STRIP001 		}
//STRIP001 
//STRIP001 		//
//STRIP001 		// 		Undo
//STRIP001 		//
//STRIP001 
//STRIP001 		USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 		USHORT nSelCount = rMark.GetSelectCount();
//STRIP001 		USHORT i;
//STRIP001 		ScBaseCell** ppOldCells	= NULL;
//STRIP001 		USHORT* pTabs			= NULL;
//STRIP001 		USHORT nPos = 0;
//STRIP001 		EditTextObject* pUndoData = NULL;
//STRIP001 		if (bRecord && !bSimple)
//STRIP001 		{
//STRIP001 			ppOldCells	= new ScBaseCell*[nSelCount];
//STRIP001 			pTabs  		= new USHORT[nSelCount];
//STRIP001 			nPos = 0;
//STRIP001 
//STRIP001 			for (i=0; i<nTabCount; i++)
//STRIP001 				if (rMark.GetTableSelect(i))
//STRIP001 				{
//STRIP001 					pTabs[nPos] = i;
//STRIP001 					ScBaseCell* pDocCell;
//STRIP001 					pDoc->GetCell( nCol, nRow, i, pDocCell );
//STRIP001 					if ( pDocCell )
//STRIP001 						ppOldCells[nPos] = pDocCell->Clone( pDoc );
//STRIP001 					else
//STRIP001 						ppOldCells[nPos] = NULL;
//STRIP001 					++nPos;
//STRIP001 				}
//STRIP001 
//STRIP001 			DBG_ASSERT( nPos==nSelCount, "nPos!=nSelCount" );
//STRIP001 
//STRIP001 			pUndoData = pData->Clone();
//STRIP001 		}
//STRIP001 
//STRIP001 		//
//STRIP001 		//		Daten eintragen
//STRIP001 		//
//STRIP001 
//STRIP001 		if (bCommon)
//STRIP001 			pDoc->ApplyPattern(nCol,nRow,nTab,*pCellAttrs);			//! Undo
//STRIP001 
//STRIP001 		if (bSimple)
//STRIP001 		{
//STRIP001 			if (bCommon)
//STRIP001 				AdjustRowHeight(nRow,nRow);
//STRIP001 
//STRIP001 			EnterData(nCol,nRow,nTab,aString,bRecord);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			for (i=0; i<nTabCount; i++)
//STRIP001 				if (rMark.GetTableSelect(i))
//STRIP001 					pDoc->PutCell( nCol, nRow, i, new ScEditCell( pData, pDoc, NULL ) );
//STRIP001 
//STRIP001 			if ( bRecord )
//STRIP001 			{	// wg. ChangeTrack erst jetzt
//STRIP001 				pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 					new ScUndoEnterData( pDocSh, nCol, nRow, nTab, nPos, pTabs,
//STRIP001 										ppOldCells, NULL, NULL, String(),
//STRIP001 										pUndoData ) );
//STRIP001 			}
//STRIP001 
//STRIP001 			HideAllCursors();
//STRIP001 
//STRIP001 			AdjustRowHeight(nRow,nRow);
//STRIP001 
//STRIP001 			for (i=0; i<nTabCount; i++)
//STRIP001 				if (rMark.GetTableSelect(i))
//STRIP001 					pDocSh->PostPaintCell( nCol, nRow, i );
//STRIP001 
//STRIP001 			ShowAllCursors();
//STRIP001 
//STRIP001 			pDocSh->UpdateOle(GetViewData());
//STRIP001 			aModificator.SetDocumentModified();
//STRIP001 		}
//STRIP001 
//STRIP001 		delete pCellAttrs;
//STRIP001 		delete pNewData;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		ErrorMessage(aTester.GetMessageId());
//STRIP001 		PaintArea( nCol, nRow, nCol, nRow );		// da steht evtl. noch die Edit-Engine
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScViewFunc::EnterDataAtCursor( const String& rString )
//STRIP001 {
//STRIP001 	USHORT nPosX = GetViewData()->GetCurX();
//STRIP001 	USHORT nPosY = GetViewData()->GetCurY();
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 
//STRIP001 	EnterData( nPosX, nPosY, nTab, rString );
//STRIP001 }

//STRIP001 void ScViewFunc::EnterMatrix( const String& rString )
//STRIP001 {
//STRIP001 	ScViewData* pData = GetViewData();
//STRIP001 	const ScMarkData& rMark = pData->GetMarkData();
//STRIP001 	if ( !rMark.IsMarked() && !rMark.IsMultiMarked() )
//STRIP001 	{
//STRIP001 		//	nichts markiert -> automatisch Block mit Groesse des Ergebnisses
//STRIP001 		//	Formel temporaer berechnen, um an die Groesse heranzukommen
//STRIP001 
//STRIP001 		ScDocument* pDoc = pData->GetDocument();
//STRIP001 		USHORT nCol = pData->GetCurX();
//STRIP001 		USHORT nRow = pData->GetCurY();
//STRIP001 		USHORT nTab = pData->GetTabNo();
//STRIP001 		ScFormulaCell aFormCell( pDoc, ScAddress(nCol,nRow,nTab), rString, MM_FORMULA );
//STRIP001 
//STRIP001 		USHORT nSizeX, nSizeY;
//STRIP001 		aFormCell.GetResultDimensions( nSizeX, nSizeY );
//STRIP001 		if ( nSizeX && nSizeY && nCol+nSizeX-1 <= MAXCOL && nRow+nSizeY-1 <= MAXROW )
//STRIP001 		{
//STRIP001 			ScRange aResult( nCol, nRow, nTab, nCol+nSizeX-1, nRow+nSizeY-1, nTab );
//STRIP001 			MarkRange( aResult, FALSE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	ScRange aRange;
//STRIP001 	if (pData->GetSimpleArea(aRange))
//STRIP001 	{
//STRIP001 		ScDocShell* pDocSh = pData->GetDocShell();
//STRIP001 		BOOL bSuccess = pDocSh->GetDocFunc().EnterMatrix( aRange, &rMark, rString, FALSE, FALSE );
//STRIP001 		if (bSuccess)
//STRIP001 			pDocSh->UpdateOle(GetViewData());
//STRIP001 	}
//STRIP001 	else
//STRIP001 		ErrorMessage(STR_NOMULTISELECT);
//STRIP001 }

/*N*/ BYTE ScViewFunc::GetSelectionScriptType()
/*N*/ {
/*N*/ 	BYTE nScript = 0;
/*N*/ 
/*N*/ 	ScDocument* pDoc = GetViewData()->GetDocument();
/*N*/ 	const ScMarkData& rMark = GetViewData()->GetMarkData();
/*N*/ 	if ( !rMark.IsMarked() && !rMark.IsMultiMarked() )
/*N*/ 	{
/*N*/ 		// no selection -> cursor
/*N*/ 
/*N*/ 		nScript = pDoc->GetScriptType( GetViewData()->GetCurX(),
/*N*/ 							GetViewData()->GetCurY(), GetViewData()->GetTabNo() );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*?*/ 		ScRangeList aRanges;
/*?*/ 		rMark.FillRangeListWithMarks( &aRanges, FALSE );
/*?*/ 		ULONG nCount = aRanges.Count();
/*?*/ 		for (ULONG i=0; i<nCount; i++)
/*?*/ 		{
/*?*/ 			ScRange aRange = *aRanges.GetObject(i);
/*?*/ 			ScCellIterator aIter( pDoc, aRange );
/*?*/ 			ScBaseCell* pCell = aIter.GetFirst();
/*?*/ 			while ( pCell )
/*?*/ 			{
/*?*/ 				nScript |= pDoc->GetScriptType( aIter.GetCol(), aIter.GetRow(), aIter.GetTab(), pCell );
/*?*/ 				pCell = aIter.GetNext();
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if (nScript == 0)
/*N*/ 		nScript = ScGlobal::GetDefaultScriptType();
/*N*/ 
/*N*/ 	return nScript;
/*N*/ }

/*N*/ const ScPatternAttr* ScViewFunc::GetSelectionPattern()
/*N*/ {
/*N*/ 	const ScMarkData& rMark = GetViewData()->GetMarkData();
/*N*/ 	ScDocument* pDoc = GetViewData()->GetDocument();
/*N*/ 	if ( rMark.IsMarked() || rMark.IsMultiMarked() )
/*N*/ 	{
/*?*/ 		//	MarkToMulti ist fuer pDoc->GetSelectionPattern nicht mehr noetig
/*?*/ 		const ScPatternAttr* pAttr = pDoc->GetSelectionPattern( rMark );
/*?*/ 		return pAttr;
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		USHORT  nCol = GetViewData()->GetCurX();
/*N*/ 		USHORT  nRow = GetViewData()->GetCurY();
/*N*/ 		USHORT  nTab = GetViewData()->GetTabNo();
/*N*/ 
/*N*/ 		ScMarkData aTempMark( rMark );		// Tabellen kopieren
/*N*/ 		aTempMark.SetMarkArea( ScRange( nCol, nRow, nTab ) );
/*N*/ 		const ScPatternAttr* pAttr = pDoc->GetSelectionPattern( aTempMark );
/*N*/ 		return pAttr;
/*N*/ 	}
/*N*/ }

//STRIP001 void ScViewFunc::GetSelectionFrame( SvxBoxItem&		rLineOuter,
//STRIP001 									SvxBoxInfoItem&	rLineInner )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 	const ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 
//STRIP001 	if ( rMark.IsMarked() || rMark.IsMultiMarked() )
//STRIP001 	{
//STRIP001 		if ( rMark.IsMultiMarked() )
//STRIP001 		{
//STRIP001 			ScMarkData aNewMark( rMark );	// use local copy for MarkToSimple
//STRIP001 			aNewMark.MarkToSimple();		// simple block is needed for GetSelectionFrame
//STRIP001 			pDoc->GetSelectionFrame( aNewMark, rLineOuter, rLineInner );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pDoc->GetSelectionFrame( rMark, rLineOuter, rLineInner );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		const ScPatternAttr* pAttrs =
//STRIP001 					pDoc->GetPattern( GetViewData()->GetCurX(),
//STRIP001 									  GetViewData()->GetCurY(),
//STRIP001 									  GetViewData()->GetTabNo() );
//STRIP001 
//STRIP001 		rLineOuter = (const SvxBoxItem&)	(pAttrs->GetItem( ATTR_BORDER ));
//STRIP001 		rLineInner = (const SvxBoxInfoItem&)(pAttrs->GetItem( ATTR_BORDER_INNER ));
//STRIP001 		rLineInner.SetTable(FALSE);
//STRIP001 		rLineInner.SetDist((BOOL)FALSE);
//STRIP001 		rLineInner.SetMinDist(FALSE);
//STRIP001 	}
//STRIP001 }

//
//	Attribute anwenden - Undo OK
//
//	kompletter Set ( ATTR_STARTINDEX, ATTR_ENDINDEX )
//

//STRIP001 void ScViewFunc::ApplyAttributes( const SfxItemSet* pDialogSet,
//STRIP001 								  const SfxItemSet* pOldSet,
//STRIP001 								  BOOL				bRecord )
//STRIP001 {
//STRIP001 	// nur wegen Matrix nicht editierbar? Attribute trotzdem ok
//STRIP001 	BOOL bOnlyNotBecauseOfMatrix;
//STRIP001 	if ( !SelectionEditable( &bOnlyNotBecauseOfMatrix ) && !bOnlyNotBecauseOfMatrix )
//STRIP001 	{
//STRIP001 		ErrorMessage(STR_PROTECTIONERR);
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	ScPatternAttr aOldAttrs( new SfxItemSet(*pOldSet) );
//STRIP001 	ScPatternAttr aNewAttrs( new SfxItemSet(*pDialogSet) );
//STRIP001 	aNewAttrs.DeleteUnchanged( &aOldAttrs );
//STRIP001 
//STRIP001 	if ( pDialogSet->GetItemState( ATTR_VALUE_FORMAT ) == SFX_ITEM_SET )
//STRIP001 	{	// #82521# don't reset to default SYSTEM GENERAL if not intended
//STRIP001 		ULONG nOldFormat =
//STRIP001 			((const SfxUInt32Item&)pOldSet->Get( ATTR_VALUE_FORMAT )).GetValue();
//STRIP001 		ULONG nNewFormat =
//STRIP001 			((const SfxUInt32Item&)pDialogSet->Get( ATTR_VALUE_FORMAT )).GetValue();
//STRIP001 		if ( nNewFormat != nOldFormat )
//STRIP001 		{
//STRIP001 			SvNumberFormatter* pFormatter =
//STRIP001 				GetViewData()->GetDocument()->GetFormatTable();
//STRIP001 			const SvNumberformat* pOldEntry = pFormatter->GetEntry( nOldFormat );
//STRIP001 			LanguageType eOldLang =
//STRIP001 				pOldEntry ? pOldEntry->GetLanguage() : LANGUAGE_DONTKNOW;
//STRIP001 			const SvNumberformat* pNewEntry = pFormatter->GetEntry( nNewFormat );
//STRIP001 			LanguageType eNewLang =
//STRIP001 				pNewEntry ? pNewEntry->GetLanguage() : LANGUAGE_DONTKNOW;
//STRIP001 			if ( eNewLang != eOldLang )
//STRIP001 			{
//STRIP001 				aNewAttrs.GetItemSet().Put(
//STRIP001 					SvxLanguageItem( eNewLang, ATTR_LANGUAGE_FORMAT ) );
//STRIP001 
//STRIP001 				//	#40606# nur die Sprache geaendert -> Zahlformat-Attribut nicht anfassen
//STRIP001 				ULONG nNewMod = nNewFormat % SV_COUNTRY_LANGUAGE_OFFSET;
//STRIP001 				if ( nNewMod == ( nOldFormat % SV_COUNTRY_LANGUAGE_OFFSET ) &&
//STRIP001 				 	nNewMod <= SV_MAX_ANZ_STANDARD_FORMATE )
//STRIP001 					aNewAttrs.GetItemSet().ClearItem( ATTR_VALUE_FORMAT );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	const SvxBoxItem*	  pOldOuter = (const SvxBoxItem*) 	  &pOldSet->Get( ATTR_BORDER );
//STRIP001 	const SvxBoxItem* 	  pNewOuter = (const SvxBoxItem*)	  &pDialogSet->Get( ATTR_BORDER );
//STRIP001 	const SvxBoxInfoItem* pOldInner = (const SvxBoxInfoItem*) &pOldSet->Get( ATTR_BORDER_INNER );
//STRIP001 	const SvxBoxInfoItem* pNewInner = (const SvxBoxInfoItem*) &pDialogSet->Get( ATTR_BORDER_INNER );
//STRIP001 	SfxItemSet&			  rNewSet   = aNewAttrs.GetItemSet();
//STRIP001 	SfxItemPool*		  pNewPool  = rNewSet.GetPool();
//STRIP001 
//STRIP001 	pNewPool->Put( *pNewOuter );		// noch nicht loeschen
//STRIP001 	pNewPool->Put( *pNewInner );
//STRIP001 	rNewSet.ClearItem( ATTR_BORDER );
//STRIP001 	rNewSet.ClearItem( ATTR_BORDER_INNER );
//STRIP001 
//STRIP001 	/*
//STRIP001 	 * Feststellen, ob Rahmenattribute zu setzen sind:
//STRIP001 	 * 1. Neu != Alt
//STRIP001 	 * 2. Ist eine der Linien nicht-DontCare (seit 238.f: IsxxValid())
//STRIP001 	 *
//STRIP001 	 */
//STRIP001 
//STRIP001 	BOOL bFrame =    (pDialogSet->GetItemState( ATTR_BORDER ) != SFX_ITEM_DEFAULT)
//STRIP001 				  || (pDialogSet->GetItemState( ATTR_BORDER_INNER ) != SFX_ITEM_DEFAULT);
//STRIP001 
//STRIP001 	if ( pNewOuter==pOldOuter && pNewInner==pOldInner )
//STRIP001 		bFrame = FALSE;
//STRIP001 
//STRIP001 	//	das sollte doch der Pool abfangen: ?!??!??
//STRIP001 
//STRIP001 	if ( bFrame && pNewOuter && pNewInner )
//STRIP001 		if ( *pNewOuter == *pOldOuter && *pNewInner == *pOldInner )
//STRIP001 			bFrame = FALSE;
//STRIP001 
//STRIP001 	if ( pNewInner )
//STRIP001 	{
//STRIP001 		bFrame =   bFrame
//STRIP001 				&& (   pNewInner->IsValid(VALID_LEFT)
//STRIP001 					|| pNewInner->IsValid(VALID_RIGHT)
//STRIP001 					|| pNewInner->IsValid(VALID_TOP)
//STRIP001 					|| pNewInner->IsValid(VALID_BOTTOM)
//STRIP001 					|| pNewInner->IsValid(VALID_HORI)
//STRIP001 					|| pNewInner->IsValid(VALID_VERT) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		bFrame = FALSE;
//STRIP001 
//STRIP001 	if (!bFrame)
//STRIP001 		ApplySelectionPattern( aNewAttrs, bRecord );				// nur normale
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// wenn neue Items Default-Items sind, so muessen die
//STRIP001 		// alten Items geputtet werden:
//STRIP001 
//STRIP001 		BOOL bDefNewOuter = ( SFX_ITEMS_STATICDEFAULT == pNewOuter->GetKind() );
//STRIP001 		BOOL bDefNewInner = ( SFX_ITEMS_STATICDEFAULT == pNewInner->GetKind() );
//STRIP001 
//STRIP001 		ApplyPatternLines( aNewAttrs,
//STRIP001 						   bDefNewOuter ? pOldOuter : pNewOuter,
//STRIP001 						   bDefNewInner ? pOldInner : pNewInner,
//STRIP001 						   bRecord );
//STRIP001 	}
//STRIP001 
//STRIP001 	pNewPool->Remove( *pNewOuter );			// freigeben
//STRIP001 	pNewPool->Remove( *pNewInner );
//STRIP001 
//STRIP001 	//	Hoehen anpassen
//STRIP001 	AdjustBlockHeight();
//STRIP001 
//STRIP001 	// CellContentChanged wird von ApplySelectionPattern / ApplyPatternLines gerufen
//STRIP001 }

//STRIP001 void ScViewFunc::ApplyAttr( const SfxPoolItem& rAttrItem )
//STRIP001 {
//STRIP001 	// nur wegen Matrix nicht editierbar? Attribute trotzdem ok
//STRIP001 	BOOL bOnlyNotBecauseOfMatrix;
//STRIP001 	if ( !SelectionEditable( &bOnlyNotBecauseOfMatrix ) && !bOnlyNotBecauseOfMatrix )
//STRIP001 	{
//STRIP001 		ErrorMessage(STR_PROTECTIONERR);
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	ScPatternAttr aNewAttrs( new SfxItemSet( *GetViewData()->GetDocument()->GetPool(),
//STRIP001 											ATTR_PATTERN_START, ATTR_PATTERN_END ) );
//STRIP001 
//STRIP001 	aNewAttrs.GetItemSet().Put( rAttrItem );
//STRIP001 	//	Wenn Ausrichtung eingestellt wird (ueber Buttons), immer Einzug 0
//STRIP001 	if ( rAttrItem.Which() == ATTR_HOR_JUSTIFY )
//STRIP001 		aNewAttrs.GetItemSet().Put( SfxUInt16Item( ATTR_INDENT, 0 ) );
//STRIP001 	ApplySelectionPattern( aNewAttrs );
//STRIP001 
//STRIP001 	AdjustBlockHeight();
//STRIP001 
//STRIP001 	// CellContentChanged wird von ApplySelectionPattern gerufen
//STRIP001 }


//	Pattern und Rahmen

//STRIP001 void ScViewFunc::ApplyPatternLines( const ScPatternAttr& rAttr, const SvxBoxItem* pNewOuter,
//STRIP001 									const SvxBoxInfoItem* pNewInner, BOOL bRecord )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 	ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 	if (bRecord && !pDoc->IsUndoEnabled())
//STRIP001 		bRecord = FALSE;
//STRIP001 
//STRIP001 	USHORT nStartCol;
//STRIP001 	USHORT nStartRow;
//STRIP001 	USHORT nStartTab;
//STRIP001 	USHORT nEndCol;
//STRIP001 	USHORT nEndRow;
//STRIP001 	USHORT nEndTab;
//STRIP001 
//STRIP001 	if (GetViewData()->GetSimpleArea(nStartCol,nStartRow,nStartTab,nEndCol,nEndRow,nEndTab))
//STRIP001 	{
//STRIP001 		rMark.MarkToSimple();	// not done by GetSimpleArea anymore
//STRIP001 
//STRIP001 		ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 
//STRIP001 		ScDocShellModificator aModificator( *pDocSh );
//STRIP001 
//STRIP001 		if (!rMark.IsMarked())
//STRIP001 		{
//STRIP001 			DoneBlockMode();
//STRIP001 			InitOwnBlockMode();
//STRIP001 			rMark.SetMarkArea( ScRange( nStartCol, nStartRow, nStartTab, nEndCol, nEndRow, nEndTab ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		if (bRecord)
//STRIP001 		{
//STRIP001 			USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 			ScDocument* pUndoDoc = new ScDocument( SCDOCMODE_UNDO );
//STRIP001 			pUndoDoc->InitUndo( pDoc, nStartTab, nStartTab );
//STRIP001 			for (USHORT i=0; i<nTabCount; i++)
//STRIP001 				if (i != nStartTab && rMark.GetTableSelect(i))
//STRIP001 					pUndoDoc->AddUndoTab( i, i );
//STRIP001 			pDoc->CopyToDocument( nStartCol, nStartRow, 0, nEndCol, nEndRow, nTabCount-1,
//STRIP001 									IDF_ATTRIB, FALSE, pUndoDoc );
//STRIP001 
//STRIP001 			pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 				new ScUndoSelectionAttr( pDocSh, rMark,
//STRIP001 										 nStartCol, nStartRow, nStartTab,
//STRIP001 										 nEndCol,   nEndRow,   nEndTab,
//STRIP001 										 pUndoDoc, FALSE, &rAttr, pNewOuter, pNewInner ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		BOOL bOldLines = pDoc->HasAttrib( nStartCol, nStartRow, nStartTab,
//STRIP001 										  nEndCol,   nEndRow,   nEndTab,
//STRIP001 										  HASATTR_PAINTEXT );
//STRIP001 
//STRIP001 		pDoc->ApplySelectionFrame( rMark, pNewOuter, pNewInner );
//STRIP001 
//STRIP001 		BOOL bNewLines = pDoc->HasAttrib( nStartCol, nStartRow, nStartTab,
//STRIP001 										  nEndCol,   nEndRow,   nEndTab,
//STRIP001 										  HASATTR_PAINTEXT );
//STRIP001 
//STRIP001 		rMark.MarkToMulti();
//STRIP001 		pDoc->ApplySelectionPattern( rAttr, rMark );
//STRIP001 
//STRIP001 		USHORT nExt = SC_PF_TESTMERGE;
//STRIP001 		if (bOldLines || bNewLines) nExt |= SC_PF_LINES;
//STRIP001 		pDocSh->PostPaint( nStartCol, nStartRow, nStartTab,
//STRIP001 						   nEndCol,   nEndRow,   nEndTab,
//STRIP001 						   PAINT_GRID, nExt );
//STRIP001 		pDocSh->UpdateOle(GetViewData());
//STRIP001 		aModificator.SetDocumentModified();
//STRIP001 		CellContentChanged();
//STRIP001 		rMark.MarkToSimple();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{		// "Rahmen nicht auf Mehrfachselektion"
//STRIP001 		ErrorMessage(STR_MSSG_APPLYPATTLINES_0);
//STRIP001 	}
//STRIP001 
//STRIP001 	StartFormatArea();
//STRIP001 }

//	nur Pattern

//STRIP001 void ScViewFunc::ApplySelectionPattern( const ScPatternAttr& rAttr,
//STRIP001 											BOOL bRecord, BOOL bCursorOnly )
//STRIP001 {
//STRIP001 	ScViewData* pViewData	= GetViewData();
//STRIP001 	ScDocShell* pDocSh		= pViewData->GetDocShell();
//STRIP001 	ScDocument* pDoc		= pDocSh->GetDocument();
//STRIP001 	ScMarkData& rMark		= pViewData->GetMarkData();
//STRIP001 	if (bRecord && !pDoc->IsUndoEnabled())
//STRIP001 		bRecord = FALSE;
//STRIP001 
//STRIP001 	ScDocShellModificator aModificator( *pDocSh );
//STRIP001 
//STRIP001 	USHORT nStartCol;
//STRIP001 	USHORT nStartRow;
//STRIP001 	USHORT nStartTab;
//STRIP001 	USHORT nEndCol;
//STRIP001 	USHORT nEndRow;
//STRIP001 	USHORT nEndTab;
//STRIP001 
//STRIP001 	BOOL bMulti = rMark.IsMultiMarked();
//STRIP001 	rMark.MarkToMulti();
//STRIP001 	BOOL bOnlyTab = (!rMark.IsMultiMarked() && !bCursorOnly && rMark.GetSelectCount() > 1);
//STRIP001 	if (bOnlyTab)
//STRIP001 	{
//STRIP001 		USHORT nCol = pViewData->GetCurX();
//STRIP001 		USHORT nRow = pViewData->GetCurY();
//STRIP001 		USHORT nTab = pViewData->GetTabNo();
//STRIP001 		ScAddress aCursor(nCol,nRow,nTab);
//STRIP001 		rMark.SetMarkArea(ScRange(aCursor,aCursor));
//STRIP001 		rMark.MarkToMulti();
//STRIP001 	}
//STRIP001 
//STRIP001 	if (rMark.IsMultiMarked() && !bCursorOnly)
//STRIP001 	{
//STRIP001 		if (bRecord)
//STRIP001 		{
//STRIP001 			ScRange aMarkRange;
//STRIP001 			rMark.GetMultiMarkArea( aMarkRange );
//STRIP001 			nStartCol = aMarkRange.aStart.Col();
//STRIP001 			nStartRow = aMarkRange.aStart.Row();
//STRIP001 			nStartTab = aMarkRange.aStart.Tab();
//STRIP001 			nEndCol = aMarkRange.aEnd.Col();
//STRIP001 			nEndRow = aMarkRange.aEnd.Row();
//STRIP001 			nEndTab = aMarkRange.aEnd.Tab();
//STRIP001 
//STRIP001 			ScRange aCopyRange = aMarkRange;
//STRIP001 			USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 			aCopyRange.aStart.SetTab(0);
//STRIP001 			aCopyRange.aEnd.SetTab(nTabCount-1);
//STRIP001 
//STRIP001 			ScDocument* pUndoDoc = new ScDocument( SCDOCMODE_UNDO );
//STRIP001 			pUndoDoc->InitUndo( pDoc, nStartTab, nStartTab );
//STRIP001 			for (USHORT i=0; i<nTabCount; i++)
//STRIP001 				if (i != nStartTab && rMark.GetTableSelect(i))
//STRIP001 					pUndoDoc->AddUndoTab( i, i );
//STRIP001 			pDoc->CopyToDocument( aCopyRange, IDF_ATTRIB, bMulti, pUndoDoc, &rMark );
//STRIP001 
//STRIP001 			rMark.MarkToMulti();
//STRIP001 
//STRIP001 			pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 				new ScUndoSelectionAttr(
//STRIP001 							pDocSh, rMark,
//STRIP001 							nStartCol, nStartRow, nStartTab,
//STRIP001 							nEndCol, nEndRow, nEndTab,
//STRIP001 							pUndoDoc, bMulti, &rAttr ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		pDoc->ApplySelectionPattern( rAttr, rMark );
//STRIP001 
//STRIP001 		if (bOnlyTab)
//STRIP001 			rMark.ResetMark();
//STRIP001 		else
//STRIP001 			rMark.MarkToSimple();
//STRIP001 
//STRIP001 		pDocSh->PostPaint( nStartCol, nStartRow, nStartTab,
//STRIP001 						   nEndCol,   nEndRow,   nEndTab,
//STRIP001 						   PAINT_GRID, SC_PF_LINES | SC_PF_TESTMERGE );
//STRIP001 		pDocSh->UpdateOle(GetViewData());
//STRIP001 		aModificator.SetDocumentModified();
//STRIP001 		CellContentChanged();
//STRIP001 	}
//STRIP001 	else							// einzelne Zelle - Undo einfacher
//STRIP001 	{
//STRIP001 		USHORT nCol = pViewData->GetCurX();
//STRIP001 		USHORT nRow = pViewData->GetCurY();
//STRIP001 		USHORT nTab = pViewData->GetTabNo();
//STRIP001 		ScPatternAttr* pOldPat = new ScPatternAttr(*pDoc->GetPattern( nCol, nRow, nTab ));
//STRIP001 
//STRIP001 		const SfxItemSet& rOldSet = pOldPat->GetItemSet();
//STRIP001 		BOOL bOldLines = rOldSet.GetItemState( ATTR_BORDER, TRUE ) == SFX_ITEM_SET ||
//STRIP001 						 rOldSet.GetItemState( ATTR_SHADOW, TRUE ) == SFX_ITEM_SET;
//STRIP001 		const SfxItemSet& rNewSet = rAttr.GetItemSet();
//STRIP001 		BOOL bNewLines = rNewSet.GetItemState( ATTR_BORDER, TRUE ) == SFX_ITEM_SET ||
//STRIP001 						 rNewSet.GetItemState( ATTR_SHADOW, TRUE ) == SFX_ITEM_SET;
//STRIP001 
//STRIP001 		pDoc->ApplyPattern( nCol, nRow, nTab, rAttr );
//STRIP001 
//STRIP001 		const ScPatternAttr* pNewPat = pDoc->GetPattern( nCol, nRow, nTab );
//STRIP001 
//STRIP001 		if (bRecord)
//STRIP001 		{
//STRIP001 			pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 						new ScUndoCursorAttr( pDocSh,
//STRIP001 											  nCol, nRow, nTab,
//STRIP001 											  pOldPat, pNewPat, &rAttr,
//STRIP001 											  FALSE ) );	// FALSE = nicht automatisch
//STRIP001 		}
//STRIP001 		delete pOldPat;		// wird im Undo kopiert (Pool)
//STRIP001 
//STRIP001 		USHORT nFlags = 0;
//STRIP001 		if ( bOldLines || bNewLines )
//STRIP001 			nFlags |= SC_PF_LINES;
//STRIP001 
//STRIP001 		pDocSh->PostPaint( nCol,nRow,nTab, nCol,nRow,nTab, PAINT_GRID, SC_PF_LINES | SC_PF_TESTMERGE );
//STRIP001 		pDocSh->UpdateOle(GetViewData());
//STRIP001 		aModificator.SetDocumentModified();
//STRIP001 		CellContentChanged();
//STRIP001 	}
//STRIP001 
//STRIP001 	StartFormatArea();
//STRIP001 }

//STRIP001 void ScViewFunc::ApplyUserItemSet( const SfxItemSet& rItemSet )
//STRIP001 {
//STRIP001 	//	ItemSet from UI, may have different pool
//STRIP001 
//STRIP001 	BOOL bOnlyNotBecauseOfMatrix;
//STRIP001 	if ( !SelectionEditable( &bOnlyNotBecauseOfMatrix ) && !bOnlyNotBecauseOfMatrix )
//STRIP001 	{
//STRIP001 		ErrorMessage(STR_PROTECTIONERR);
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	ScPatternAttr aNewAttrs( GetViewData()->GetDocument()->GetPool() );
//STRIP001 	SfxItemSet& rNewSet = aNewAttrs.GetItemSet();
//STRIP001 	rNewSet.Put( rItemSet, FALSE );
//STRIP001 	ApplySelectionPattern( aNewAttrs );
//STRIP001 
//STRIP001 	AdjustBlockHeight();
//STRIP001 }

/*N*/ const SfxStyleSheet* ScViewFunc::GetStyleSheetFromMarked()
/*N*/ {
/*N*/ 	const ScStyleSheet*	pSheet		= NULL;
/*N*/ 	ScViewData*			pViewData	= GetViewData();
/*N*/ 	ScDocument*			pDoc		= pViewData->GetDocument();
/*N*/ 	ScMarkData&			rMark		= pViewData->GetMarkData();
/*N*/ 
/*N*/ 	if ( rMark.IsMarked() || rMark.IsMultiMarked() )
/*?*/ 		pSheet = pDoc->GetSelectionStyle( rMark );					// MarkToMulti nicht noetig !!
/*N*/ 	else
/*N*/ 		pSheet = pDoc->GetStyle( pViewData->GetCurX(),
/*N*/ 								 pViewData->GetCurY(),
/*N*/ 								 pViewData->GetTabNo() );
/*N*/ 
/*N*/ 	return pSheet;
/*N*/ }

//STRIP001 void ScViewFunc::SetStyleSheetToMarked( SfxStyleSheet* pStyleSheet, BOOL bRecord )
//STRIP001 {
//STRIP001 	// nur wegen Matrix nicht editierbar? Attribute trotzdem ok
//STRIP001 	BOOL bOnlyNotBecauseOfMatrix;
//STRIP001 	if ( !SelectionEditable( &bOnlyNotBecauseOfMatrix ) && !bOnlyNotBecauseOfMatrix )
//STRIP001 	{
//STRIP001 		ErrorMessage(STR_PROTECTIONERR);
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !pStyleSheet) return;
//STRIP001 	// -------------------------------------------------------------------
//STRIP001 
//STRIP001 	ScViewData* pViewData	= GetViewData();
//STRIP001 	ScDocShell* pDocSh		= pViewData->GetDocShell();
//STRIP001 	ScDocument* pDoc		= pDocSh->GetDocument();
//STRIP001 	ScMarkData& rMark		= pViewData->GetMarkData();
//STRIP001 	USHORT nTabCount		= pDoc->GetTableCount();
//STRIP001 	if (bRecord && !pDoc->IsUndoEnabled())
//STRIP001 		bRecord = FALSE;
//STRIP001 
//STRIP001 	ScDocShellModificator aModificator( *pDocSh );
//STRIP001 
//STRIP001 	if ( rMark.IsMarked() || rMark.IsMultiMarked() )
//STRIP001 	{
//STRIP001 		ScRange aMarkRange;
//STRIP001 		rMark.MarkToMulti();
//STRIP001 		rMark.GetMultiMarkArea( aMarkRange );
//STRIP001 
//STRIP001 		if ( bRecord )
//STRIP001 		{
//STRIP001 			USHORT nTab = pViewData->GetTabNo();
//STRIP001 			ScDocument* pUndoDoc = new ScDocument( SCDOCMODE_UNDO );
//STRIP001 			pUndoDoc->InitUndo( pDoc, nTab, nTab );
//STRIP001 			for (USHORT i=0; i<nTabCount; i++)
//STRIP001 				if (i != nTab && rMark.GetTableSelect(i))
//STRIP001 					pUndoDoc->AddUndoTab( i, i );
//STRIP001 
//STRIP001 			ScRange aCopyRange = aMarkRange;
//STRIP001 			aCopyRange.aStart.SetTab(0);
//STRIP001 			aCopyRange.aEnd.SetTab(nTabCount-1);
//STRIP001 			pDoc->CopyToDocument( aCopyRange, IDF_ATTRIB, TRUE, pUndoDoc, &rMark );
//STRIP001 			rMark.MarkToMulti();
//STRIP001 
//STRIP001 			String aName = pStyleSheet->GetName();
//STRIP001 			pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 				new ScUndoSelectionStyle( pDocSh, rMark, aMarkRange, aName, pUndoDoc ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		pDoc->ApplySelectionStyle( (ScStyleSheet&)*pStyleSheet, rMark );
//STRIP001 
//STRIP001 		if (!AdjustBlockHeight())
//STRIP001 			pViewData->GetDocShell()->PostPaint( aMarkRange, PAINT_GRID );
//STRIP001 
//STRIP001 		rMark.MarkToSimple();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		USHORT nCol = pViewData->GetCurX();
//STRIP001 		USHORT nRow = pViewData->GetCurY();
//STRIP001 		USHORT nTab = pViewData->GetTabNo();
//STRIP001 
//STRIP001 		if ( bRecord )
//STRIP001 		{
//STRIP001 			ScDocument* pUndoDoc = new ScDocument( SCDOCMODE_UNDO );
//STRIP001 			pUndoDoc->InitUndo( pDoc, nTab, nTab );
//STRIP001 			for (USHORT i=0; i<nTabCount; i++)
//STRIP001 				if (i != nTab && rMark.GetTableSelect(i))
//STRIP001 					pUndoDoc->AddUndoTab( i, i );
//STRIP001 
//STRIP001 			ScRange aCopyRange( nCol, nRow, 0, nCol, nRow, nTabCount-1 );
//STRIP001 			pDoc->CopyToDocument( aCopyRange, IDF_ATTRIB, FALSE, pUndoDoc );
//STRIP001 
//STRIP001 			ScRange aMarkRange ( nCol, nRow, nTab );
//STRIP001 			ScMarkData aUndoMark = rMark;
//STRIP001 			aUndoMark.SetMultiMarkArea( aMarkRange );
//STRIP001 
//STRIP001 			String aName = pStyleSheet->GetName();
//STRIP001 			pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 				new ScUndoSelectionStyle( pDocSh, aUndoMark, aMarkRange, aName, pUndoDoc ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		for (USHORT i=0; i<nTabCount; i++)
//STRIP001 			if (rMark.GetTableSelect(i))
//STRIP001 				pDoc->ApplyStyle( nCol, nRow, i, (ScStyleSheet&)*pStyleSheet );
//STRIP001 
//STRIP001 		if (!AdjustBlockHeight())
//STRIP001 			pViewData->GetDocShell()->PostPaintCell( nCol, nRow, nTab );
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	aModificator.SetDocumentModified();
//STRIP001 
//STRIP001 	StartFormatArea();
//STRIP001 }


//STRIP001 void ScViewFunc::RemoveStyleSheetInUse( SfxStyleSheet* pStyleSheet )
//STRIP001 {
//STRIP001 	if ( !pStyleSheet) return;
//STRIP001 	// -------------------------------------------------------------------
//STRIP001 
//STRIP001 	ScViewData* pViewData	= GetViewData();
//STRIP001 	ScDocument* pDoc		= pViewData->GetDocument();
//STRIP001 	ScDocShell* pDocSh		= pViewData->GetDocShell();
//STRIP001 
//STRIP001 	ScDocShellModificator aModificator( *pDocSh );
//STRIP001 
//STRIP001 	VirtualDevice aVirtDev;
//STRIP001 	aVirtDev.SetMapMode(MAP_PIXEL);
//STRIP001 	pDoc->StyleSheetChanged( pStyleSheet, TRUE, &aVirtDev,
//STRIP001 								pViewData->GetPPTX(),
//STRIP001 								pViewData->GetPPTY(),
//STRIP001 								pViewData->GetZoomX(),
//STRIP001 								pViewData->GetZoomY() );
//STRIP001 
//STRIP001 	pDocSh->PostPaint( 0,0,0, MAXCOL,MAXROW,MAXTAB, PAINT_GRID|PAINT_LEFT );
//STRIP001 	aModificator.SetDocumentModified();
//STRIP001 
//STRIP001 	ScInputHandler* pHdl = SC_MOD()->GetInputHdl();
//STRIP001 	if (pHdl)
//STRIP001 		pHdl->ForgetLastPattern();
//STRIP001 }

//STRIP001 void ScViewFunc::UpdateStyleSheetInUse( SfxStyleSheet* pStyleSheet )
//STRIP001 {
//STRIP001 	if ( !pStyleSheet) return;
//STRIP001 	// -------------------------------------------------------------------
//STRIP001 
//STRIP001 	ScViewData* pViewData	= GetViewData();
//STRIP001 	ScDocument* pDoc		= pViewData->GetDocument();
//STRIP001 	ScDocShell* pDocSh		= pViewData->GetDocShell();
//STRIP001 
//STRIP001 	ScDocShellModificator aModificator( *pDocSh );
//STRIP001 
//STRIP001 	VirtualDevice aVirtDev;
//STRIP001 	aVirtDev.SetMapMode(MAP_PIXEL);
//STRIP001 	pDoc->StyleSheetChanged( pStyleSheet, FALSE, &aVirtDev,
//STRIP001 								pViewData->GetPPTX(),
//STRIP001 								pViewData->GetPPTY(),
//STRIP001 								pViewData->GetZoomX(),
//STRIP001 								pViewData->GetZoomY() );
//STRIP001 
//STRIP001 	pDocSh->PostPaint( 0,0,0, MAXCOL,MAXROW,MAXTAB, PAINT_GRID|PAINT_LEFT );
//STRIP001 	aModificator.SetDocumentModified();
//STRIP001 
//STRIP001 	ScInputHandler* pHdl = SC_MOD()->GetInputHdl();
//STRIP001 	if (pHdl)
//STRIP001 		pHdl->ForgetLastPattern();
//STRIP001 }

//	Zellen einfuegen - Undo OK

//STRIP001 BOOL ScViewFunc::InsertCells( InsCellCmd eCmd, BOOL bRecord, BOOL bPartOfPaste )
//STRIP001 {
//STRIP001 	ScRange aRange;
//STRIP001 	if (GetViewData()->GetSimpleArea(aRange))
//STRIP001 	{
//STRIP001 		ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 		BOOL bSuccess = pDocSh->GetDocFunc().InsertCells( aRange, eCmd, bRecord, FALSE, bPartOfPaste );
//STRIP001 		if (bSuccess)
//STRIP001 		{
//STRIP001 			pDocSh->UpdateOle(GetViewData());
//STRIP001 			CellContentChanged();
//STRIP001 		}
//STRIP001 		return bSuccess;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		ErrorMessage(STR_NOMULTISELECT);
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 }

//	Zellen loeschen - Undo OK

//STRIP001 void ScViewFunc::DeleteCells( DelCellCmd eCmd, BOOL bRecord )
//STRIP001 {
//STRIP001 	ScRange aRange;
//STRIP001 	if (GetViewData()->GetSimpleArea(aRange))
//STRIP001 	{
//STRIP001 		ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 		pDocSh->GetDocFunc().DeleteCells( aRange, eCmd, bRecord, FALSE );
//STRIP001 
//STRIP001 		pDocSh->UpdateOle(GetViewData());
//STRIP001 		CellContentChanged();
//STRIP001 
//STRIP001 		//	#58106# Cursor direkt hinter den geloeschten Bereich setzen
//STRIP001 		USHORT nCurX = GetViewData()->GetCurX();
//STRIP001 		USHORT nCurY = GetViewData()->GetCurY();
//STRIP001 		if ( eCmd==DEL_CELLSLEFT || eCmd==DEL_DELCOLS )
//STRIP001 			nCurX = aRange.aStart.Col();
//STRIP001 		else
//STRIP001 			nCurY = aRange.aStart.Row();
//STRIP001 		SetCursor( nCurX, nCurY );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if (eCmd == DEL_DELCOLS)
//STRIP001 			DeleteMulti( FALSE, bRecord );
//STRIP001 		else if (eCmd == DEL_DELROWS)
//STRIP001 			DeleteMulti( TRUE, bRecord );
//STRIP001 		else
//STRIP001 			ErrorMessage(STR_NOMULTISELECT);
//STRIP001 	}
//STRIP001 
//STRIP001 	Unmark();
//STRIP001 }

//STRIP001 void ScViewFunc::DeleteMulti( BOOL bRows, BOOL bRecord )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocShellModificator aModificator( *pDocSh );
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	if (bRecord && !pDoc->IsUndoEnabled())
//STRIP001 		bRecord = FALSE;
//STRIP001 	USHORT* pRanges = new USHORT[MAXROW+1];
//STRIP001 	USHORT nRangeCnt = bRows ? rMark.GetMarkRowRanges( pRanges ) :
//STRIP001 								rMark.GetMarkColumnRanges( pRanges );
//STRIP001 	if (!nRangeCnt)
//STRIP001 	{
//STRIP001 		pRanges[0] = pRanges[1] = bRows ? GetViewData()->GetCurY() : GetViewData()->GetCurX();
//STRIP001 		nRangeCnt = 1;
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Test ob erlaubt
//STRIP001 
//STRIP001 	USHORT* pOneRange = pRanges;
//STRIP001 	BOOL bAllowed = TRUE;
//STRIP001 	USHORT nRangeNo;
//STRIP001 	for (nRangeNo=0; nRangeNo<nRangeCnt && bAllowed; nRangeNo++)
//STRIP001 	{
//STRIP001 		USHORT nStart = *(pOneRange++);
//STRIP001 		USHORT nEnd = *(pOneRange++);
//STRIP001 
//STRIP001 		//!	...
//STRIP001 	}
//STRIP001 
//STRIP001 	//	ausfuehren
//STRIP001 
//STRIP001 	WaitObject aWait( GetFrameWin() );		// wichtig wegen TrackFormulas bei UpdateReference
//STRIP001 
//STRIP001 	ScDocument* pUndoDoc = NULL;
//STRIP001 	ScRefUndoData* pUndoData = NULL;
//STRIP001 	if (bRecord)
//STRIP001 	{
//STRIP001 		pUndoDoc = new ScDocument( SCDOCMODE_UNDO );
//STRIP001 		pUndoDoc->InitUndo( pDoc, nTab, nTab, !bRows, bRows );		// Zeilenhoehen
//STRIP001 
//STRIP001 		pOneRange = pRanges;
//STRIP001 		for (nRangeNo=0; nRangeNo<nRangeCnt; nRangeNo++)
//STRIP001 		{
//STRIP001 			USHORT nStart = *(pOneRange++);
//STRIP001 			USHORT nEnd = *(pOneRange++);
//STRIP001 			if (bRows)
//STRIP001 				pDoc->CopyToDocument( 0,nStart,nTab, MAXCOL,nEnd,nTab, IDF_ALL,FALSE,pUndoDoc );
//STRIP001 			else
//STRIP001 				pDoc->CopyToDocument( nStart,0,nTab, nEnd,MAXROW,nTab, IDF_ALL,FALSE,pUndoDoc );
//STRIP001 		}
//STRIP001 
//STRIP001 				//	alle Formeln wegen Referenzen
//STRIP001 		USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 		pUndoDoc->AddUndoTab( 0, nTabCount-1, FALSE, FALSE );
//STRIP001 		pDoc->CopyToDocument( 0,0,0, MAXCOL,MAXROW,MAXTAB, IDF_FORMULA,FALSE,pUndoDoc );
//STRIP001 
//STRIP001 		pUndoData = new ScRefUndoData( pDoc );
//STRIP001 
//STRIP001 		pDoc->BeginDrawUndo();
//STRIP001 	}
//STRIP001 
//STRIP001 	pOneRange = &pRanges[2*nRangeCnt];		// rueckwaerts
//STRIP001 	for (nRangeNo=0; nRangeNo<nRangeCnt && bAllowed; nRangeNo++)
//STRIP001 	{
//STRIP001 		USHORT nEnd = *(--pOneRange);
//STRIP001 		USHORT nStart = *(--pOneRange);
//STRIP001 
//STRIP001 		if (bRows)
//STRIP001 			pDoc->DeleteRow( 0,nTab, MAXCOL,nTab, nStart, nEnd-nStart+1 );
//STRIP001 		else
//STRIP001 			pDoc->DeleteCol( 0,nTab, MAXROW,nTab, nStart, nEnd-nStart+1 );
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bRecord)
//STRIP001 	{
//STRIP001 		pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 			new ScUndoDeleteMulti( pDocSh, bRows, nTab, pRanges, nRangeCnt,
//STRIP001 									pUndoDoc, pUndoData ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!AdjustRowHeight(0, MAXROW))
//STRIP001 		if (bRows)
//STRIP001 			pDocSh->PostPaint( 0,pRanges[0],nTab, MAXCOL,MAXROW,nTab, PAINT_GRID | PAINT_LEFT );
//STRIP001 		else
//STRIP001 			pDocSh->PostPaint( pRanges[0],0,nTab, MAXCOL,MAXROW,nTab, PAINT_GRID | PAINT_TOP );
//STRIP001 	aModificator.SetDocumentModified();
//STRIP001 
//STRIP001 	CellContentChanged();
//STRIP001 
//STRIP001 	//	#58106# Cursor direkt hinter den ersten geloeschten Bereich setzen
//STRIP001 	USHORT nCurX = GetViewData()->GetCurX();
//STRIP001 	USHORT nCurY = GetViewData()->GetCurY();
//STRIP001 	if ( bRows )
//STRIP001 		nCurY = pRanges[0];
//STRIP001 	else
//STRIP001 		nCurX = pRanges[0];
//STRIP001 	SetCursor( nCurX, nCurY );
//STRIP001 
//STRIP001 	delete[] pRanges;
//STRIP001 }

//	Inhalte loeschen

//STRIP001 void ScViewFunc::DeleteContents( USHORT nFlags, BOOL bRecord )
//STRIP001 {
//STRIP001 	// nur wegen Matrix nicht editierbar? Attribute trotzdem ok
//STRIP001 	BOOL bOnlyNotBecauseOfMatrix;
//STRIP001 	BOOL bEditable = SelectionEditable( &bOnlyNotBecauseOfMatrix );
//STRIP001 	if ( !bEditable )
//STRIP001 	{
//STRIP001 		if ( !(bOnlyNotBecauseOfMatrix &&
//STRIP001 				((nFlags & (IDF_ATTRIB | IDF_EDITATTR)) == nFlags)) )
//STRIP001 		{
//STRIP001 			ErrorMessage(bOnlyNotBecauseOfMatrix ? STR_MATRIXFRAGMENTERR : STR_PROTECTIONERR);
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	ScRange aMarkRange;
//STRIP001 	BOOL bSimple = FALSE;
//STRIP001 
//STRIP001 	ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 	if (bRecord && !pDoc->IsUndoEnabled())
//STRIP001 		bRecord = FALSE;
//STRIP001 
//STRIP001 	ScDocShellModificator aModificator( *pDocSh );
//STRIP001 
//STRIP001 	if ( !rMark.IsMarked() && !rMark.IsMultiMarked() )
//STRIP001 	{
//STRIP001 		aMarkRange.aStart.SetCol(GetViewData()->GetCurX());
//STRIP001 		aMarkRange.aStart.SetRow(GetViewData()->GetCurY());
//STRIP001 		aMarkRange.aStart.SetTab(GetViewData()->GetTabNo());
//STRIP001 		aMarkRange.aEnd = aMarkRange.aStart;
//STRIP001 		if ( pDoc->HasAttrib( aMarkRange, HASATTR_MERGED ) )
//STRIP001 		{
//STRIP001 			InitOwnBlockMode();
//STRIP001 			rMark.SetMarkArea( aMarkRange );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			bSimple = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	rMark.SetMarking(FALSE);		// for MarkToMulti
//STRIP001 	rMark.MarkToSimple();			// before bMulti test below
//STRIP001 
//STRIP001 	DBG_ASSERT( rMark.IsMarked() || rMark.IsMultiMarked() || bSimple, "was denn loeschen ???" )
//STRIP001 
//STRIP001 	ScDocument* pUndoDoc = NULL;
//STRIP001 	BOOL bMulti = !bSimple && rMark.IsMultiMarked();
//STRIP001 	if (!bSimple)
//STRIP001 	{
//STRIP001 		rMark.MarkToMulti();
//STRIP001 		rMark.GetMultiMarkArea( aMarkRange );
//STRIP001 	}
//STRIP001 	ScRange aExtendedRange(aMarkRange);
//STRIP001 	if (!bSimple)
//STRIP001 	{
//STRIP001 		if ( pDoc->ExtendMerge( aExtendedRange, TRUE ) )
//STRIP001 			bMulti = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// keine Objekte auf geschuetzten Tabellen
//STRIP001 	BOOL bObjects = FALSE;
//STRIP001 	if ( nFlags & IDF_OBJECTS )
//STRIP001 	{
//STRIP001 		bObjects = TRUE;
//STRIP001 		USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 		for (USHORT nTab=0; nTab<nTabCount; nTab++)
//STRIP001 			if (rMark.GetTableSelect(nTab) && pDoc->IsTabProtected(nTab))
//STRIP001 				bObjects = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nExtFlags = 0;						// Linien interessieren nur, wenn Attribute
//STRIP001 	if ( nFlags & IDF_ATTRIB )					// geloescht werden
//STRIP001 		if (pDoc->HasAttrib( aMarkRange, HASATTR_PAINTEXT ))
//STRIP001 			nExtFlags |= SC_PF_LINES;
//STRIP001 
//STRIP001 	//	Reihenfolge:
//STRIP001 	//	1) BeginDrawUndo
//STRIP001 	//	2) Objekte loeschen (DrawUndo wird gefuellt)
//STRIP001 	//	3) Inhalte fuer Undo kopieren
//STRIP001 	//	4) Inhalte loeschen
//STRIP001 	//	5) Undo-Aktion anlegen
//STRIP001 
//STRIP001 	if (bObjects)
//STRIP001 	{
//STRIP001 		if (bRecord)
//STRIP001 			pDoc->BeginDrawUndo();
//STRIP001 
//STRIP001 		if (bMulti)
//STRIP001 			pDoc->DeleteObjectsInSelection( rMark );
//STRIP001 		else
//STRIP001 			pDoc->DeleteObjectsInArea( aMarkRange.aStart.Col(), aMarkRange.aStart.Row(),
//STRIP001 /*!*/								   aMarkRange.aEnd.Col(),   aMarkRange.aEnd.Row(),
//STRIP001 									   rMark );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bRecord )
//STRIP001 	{
//STRIP001 		pUndoDoc = new ScDocument( SCDOCMODE_UNDO );
//STRIP001 		USHORT nTab = aMarkRange.aStart.Tab();
//STRIP001 		pUndoDoc->InitUndo( pDoc, nTab, nTab );
//STRIP001 		USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 		for (USHORT i=0; i<nTabCount; i++)
//STRIP001 			if (i != nTab && rMark.GetTableSelect(i))
//STRIP001 				pUndoDoc->AddUndoTab( i, i );
//STRIP001 		ScRange aCopyRange = aExtendedRange;
//STRIP001 		aCopyRange.aStart.SetTab(0);
//STRIP001 		aCopyRange.aEnd.SetTab(nTabCount-1);
//STRIP001 
//STRIP001 		//	bei "Format/Standard" alle Attribute kopieren, weil CopyToDocument
//STRIP001 		//	nur mit IDF_HARDATTR zu langsam ist:
//STRIP001 		USHORT nUndoDocFlags = nFlags;
//STRIP001 		if (nFlags & IDF_ATTRIB)
//STRIP001 			nUndoDocFlags |= IDF_ATTRIB;
//STRIP001 		if (nFlags & IDF_EDITATTR)			// Edit-Engine-Attribute
//STRIP001 			nUndoDocFlags |= IDF_STRING;	// -> Zellen werden geaendert
//STRIP001 		if (nFlags & IDF_NOTE)
//STRIP001 			nUndoDocFlags |= IDF_CONTENTS;	// #68795# copy all cells with their notes
//STRIP001 		pDoc->CopyToDocument( aCopyRange, nUndoDocFlags, bMulti, pUndoDoc, &rMark );
//STRIP001 	}
//STRIP001 
//STRIP001 	HideAllCursors();	// falls Zusammenfassung aufgehoben wird
//STRIP001 	if (bSimple)
//STRIP001 		pDoc->DeleteArea( aMarkRange.aStart.Col(), aMarkRange.aStart.Row(),
//STRIP001 						  aMarkRange.aEnd.Col(),   aMarkRange.aEnd.Row(),
//STRIP001 						  rMark, nFlags );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pDoc->DeleteSelection( nFlags, rMark );
//STRIP001 		rMark.MarkToSimple();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bRecord )
//STRIP001 	{
//STRIP001 		pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 			new ScUndoDeleteContents( pDocSh, rMark, aExtendedRange,
//STRIP001 									  pUndoDoc, bMulti, nFlags, bObjects ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!AdjustRowHeight( aExtendedRange.aStart.Row(), aExtendedRange.aEnd.Row() ))
//STRIP001 		pDocSh->PostPaint( aExtendedRange, PAINT_GRID, nExtFlags );
//STRIP001 
//STRIP001 	pDocSh->UpdateOle(GetViewData());
//STRIP001 	aModificator.SetDocumentModified();
//STRIP001 	CellContentChanged();
//STRIP001 	ShowAllCursors();
//STRIP001 
//STRIP001 	if ( nFlags & IDF_ATTRIB )
//STRIP001 	{
//STRIP001 		if ( nFlags & IDF_CONTENTS )
//STRIP001 			ForgetFormatArea();
//STRIP001 		else
//STRIP001 			StartFormatArea();				// Attribute loeschen ist auch Attributierung
//STRIP001 	}
//STRIP001 }

//	Spaltenbreiten/Zeilenhoehen (ueber Header) - Undo OK

//STRIP001 void ScViewFunc::SetWidthOrHeight( BOOL bWidth, USHORT nRangeCnt, USHORT* pRanges,
//STRIP001 									ScSizeMode eMode, USHORT nSizeTwips,
//STRIP001 									BOOL bRecord, BOOL bPaint, ScMarkData* pMarkData )
//STRIP001 {
//STRIP001 	if (!nRangeCnt)
//STRIP001 		return;
//STRIP001 
//STRIP001 	// use view's mark if none specified
//STRIP001 	if ( !pMarkData )
//STRIP001 		pMarkData = &GetViewData()->GetMarkData();
//STRIP001 
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 	USHORT nFirstTab = pMarkData->GetFirstSelected();
//STRIP001 	USHORT nCurTab = GetViewData()->GetTabNo();
//STRIP001 	USHORT nTab;
//STRIP001 	if (bRecord && !pDoc->IsUndoEnabled())
//STRIP001 		bRecord = FALSE;
//STRIP001 
//STRIP001 	ScDocShellModificator aModificator( *pDocSh );
//STRIP001 
//STRIP001 	BOOL bAllowed = TRUE;
//STRIP001 	for (nTab=0; nTab<nTabCount && bAllowed; nTab++)
//STRIP001 		if (pMarkData->GetTableSelect(nTab))
//STRIP001 		{
//STRIP001 			for ( USHORT i=0; i<nRangeCnt && bAllowed; i++ )
//STRIP001 			{
//STRIP001 				BOOL bOnlyMatrix;
//STRIP001 				if (bWidth)
//STRIP001 					bAllowed = pDoc->IsBlockEditable( nTab,
//STRIP001 										pRanges[2*i],0, pRanges[2*i+1],MAXROW, &bOnlyMatrix ) || bOnlyMatrix;
//STRIP001 				else
//STRIP001 					bAllowed = pDoc->IsBlockEditable( nTab,
//STRIP001 										0,pRanges[2*i], MAXCOL,pRanges[2*i+1], &bOnlyMatrix ) || bOnlyMatrix;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	if ( !bAllowed )
//STRIP001 	{
//STRIP001 		ErrorMessage(STR_PROTECTIONERR);
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nStart = pRanges[0];
//STRIP001 	USHORT nEnd = pRanges[2*nRangeCnt-1];
//STRIP001 
//STRIP001 	BOOL bFormula = FALSE;
//STRIP001 	if ( eMode == SC_SIZE_OPTIMAL )
//STRIP001 	{
//STRIP001 		const ScViewOptions& rOpts = GetViewData()->GetOptions();
//STRIP001 		bFormula = rOpts.GetOption( VOPT_FORMULAS );
//STRIP001 	}
//STRIP001 
//STRIP001 	ScDocument* 	pUndoDoc = NULL;
//STRIP001 	ScOutlineTable* pUndoTab = NULL;
//STRIP001 	USHORT*			pUndoRanges = NULL;
//STRIP001 
//STRIP001 	if ( bRecord )
//STRIP001 	{
//STRIP001 		pDoc->BeginDrawUndo();							// Drawing Updates
//STRIP001 
//STRIP001 		pUndoDoc = new ScDocument( SCDOCMODE_UNDO );
//STRIP001 		for (nTab=0; nTab<nTabCount; nTab++)
//STRIP001 			if (pMarkData->GetTableSelect(nTab))
//STRIP001 			{
//STRIP001 				if (bWidth)
//STRIP001 				{
//STRIP001 					if ( nTab == nFirstTab )
//STRIP001 						pUndoDoc->InitUndo( pDoc, nTab, nTab, TRUE, FALSE );
//STRIP001 					else
//STRIP001 						pUndoDoc->AddUndoTab( nTab, nTab, TRUE, FALSE );
//STRIP001 					pDoc->CopyToDocument( nStart, 0, nTab, nEnd, MAXROW, nTab, IDF_NONE, FALSE, pUndoDoc );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if ( nTab == nFirstTab )
//STRIP001 						pUndoDoc->InitUndo( pDoc, nTab, nTab, FALSE, TRUE );
//STRIP001 					else
//STRIP001 						pUndoDoc->AddUndoTab( nTab, nTab, FALSE, TRUE );
//STRIP001 					pDoc->CopyToDocument( 0, nStart, nTab, MAXCOL, nEnd, nTab, IDF_NONE, FALSE, pUndoDoc );
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 		pUndoRanges = new USHORT[ 2*nRangeCnt ];
//STRIP001 		memmove( pUndoRanges, pRanges, 2*nRangeCnt*sizeof(USHORT) );
//STRIP001 
//STRIP001 		//!	outlines from all tables?
//STRIP001 		ScOutlineTable* pTable = pDoc->GetOutlineTable( nCurTab );
//STRIP001 		if (pTable)
//STRIP001 			pUndoTab = new ScOutlineTable( *pTable );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( eMode==SC_SIZE_OPTIMAL || eMode==SC_SIZE_VISOPT )
//STRIP001 		pMarkData->MarkToMulti();
//STRIP001 
//STRIP001 	BOOL bShow = nSizeTwips > 0 || eMode != SC_SIZE_DIRECT;
//STRIP001 	BOOL bOutline = FALSE;
//STRIP001 
//STRIP001 	for (nTab=0; nTab<nTabCount; nTab++)
//STRIP001 		if (pMarkData->GetTableSelect(nTab))
//STRIP001 		{
//STRIP001 			const USHORT* pTabRanges = pRanges;
//STRIP001 
//STRIP001 			pDoc->IncSizeRecalcLevel( nTab );		// nicht fuer jede Spalte einzeln
//STRIP001 			for (USHORT nRangeNo=0; nRangeNo<nRangeCnt; nRangeNo++)
//STRIP001 			{
//STRIP001 				USHORT nStartNo = *(pTabRanges++);
//STRIP001 				USHORT nEndNo = *(pTabRanges++);
//STRIP001 
//STRIP001 				if ( !bWidth )						// Hoehen immer blockweise
//STRIP001 				{
//STRIP001 					if ( eMode==SC_SIZE_OPTIMAL || eMode==SC_SIZE_VISOPT )
//STRIP001 					{
//STRIP001 						BOOL bAll = ( eMode==SC_SIZE_OPTIMAL );
//STRIP001 						if (!bAll)
//STRIP001 						{
//STRIP001 							//	fuer alle eingeblendeten CR_MANUALSIZE loeschen,
//STRIP001 							//	dann SetOptimalHeight mit bShrink = FALSE
//STRIP001 							for (USHORT nRow=nStartNo; nRow<=nEndNo; nRow++)
//STRIP001 							{
//STRIP001 								BYTE nOld = pDoc->GetRowFlags(nRow,nTab);
//STRIP001 								if ( (nOld & CR_HIDDEN) == 0 && ( nOld & CR_MANUALSIZE ) )
//STRIP001 									pDoc->SetRowFlags( nRow, nTab, nOld & ~CR_MANUALSIZE );
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						double nPPTX = GetViewData()->GetPPTX();
//STRIP001 						double nPPTY = GetViewData()->GetPPTY();
//STRIP001 						Fraction aZoomX = GetViewData()->GetZoomX();
//STRIP001 						Fraction aZoomY = GetViewData()->GetZoomY();
//STRIP001 
//STRIP001 						ScSizeDeviceProvider aProv(pDocSh);
//STRIP001 						if (aProv.IsPrinter())
//STRIP001 						{
//STRIP001 							nPPTX = aProv.GetPPTX();
//STRIP001 							nPPTY = aProv.GetPPTY();
//STRIP001 							aZoomX = aZoomY = Fraction( 1, 1 );
//STRIP001 						}
//STRIP001 
//STRIP001 						pDoc->SetOptimalHeight( nStartNo, nEndNo, nTab, nSizeTwips, aProv.GetDevice(),
//STRIP001 													nPPTX, nPPTY, aZoomX, aZoomY, bAll );
//STRIP001 						if (bAll)
//STRIP001 							pDoc->ShowRows( nStartNo, nEndNo, nTab, TRUE );
//STRIP001 
//STRIP001 						//	Manual-Flag wird bei bAll=TRUE schon in SetOptimalHeight gesetzt
//STRIP001 						//	(an bei Extra-Height, sonst aus).
//STRIP001 					}
//STRIP001 					else if ( eMode==SC_SIZE_DIRECT )
//STRIP001 					{
//STRIP001 						if (nSizeTwips)
//STRIP001 						{
//STRIP001 							pDoc->SetRowHeightRange( nStartNo, nEndNo, nTab, nSizeTwips );
//STRIP001 							pDoc->SetManualHeight( nStartNo, nEndNo, nTab, TRUE );			// height was set manually
//STRIP001 						}
//STRIP001 						pDoc->ShowRows( nStartNo, nEndNo, nTab, nSizeTwips != 0 );
//STRIP001 					}
//STRIP001 					else if ( eMode==SC_SIZE_SHOW )
//STRIP001 					{
//STRIP001 						pDoc->ShowRows( nStartNo, nEndNo, nTab, TRUE );
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else								// Spaltenbreiten
//STRIP001 				{
//STRIP001 					for (USHORT nCol=nStartNo; nCol<=nEndNo; nCol++)
//STRIP001 					{
//STRIP001 						if ( eMode != SC_SIZE_VISOPT ||
//STRIP001 							 (pDoc->GetColFlags( nCol, nTab ) & CR_HIDDEN) == 0 )
//STRIP001 						{
//STRIP001 							USHORT nThisSize = nSizeTwips;
//STRIP001 
//STRIP001 							if ( eMode==SC_SIZE_OPTIMAL || eMode==SC_SIZE_VISOPT )
//STRIP001 								nThisSize = nSizeTwips + GetOptimalColWidth( nCol, nTab, bFormula );
//STRIP001 							if ( nThisSize )
//STRIP001 								pDoc->SetColWidth( nCol, nTab, nThisSize );
//STRIP001 
//STRIP001 							pDoc->ShowCol( nCol, nTab, bShow );
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 									//	Outline anpassen
//STRIP001 
//STRIP001 				if (bWidth)
//STRIP001 				{
//STRIP001 					if ( pDoc->UpdateOutlineCol( nStartNo, nEndNo, nTab, bShow ) )
//STRIP001 						bOutline = TRUE;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if ( pDoc->UpdateOutlineRow( nStartNo, nEndNo, nTab, bShow ) )
//STRIP001 						bOutline = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			pDoc->DecSizeRecalcLevel( nTab );		// nicht fuer jede Spalte einzeln
//STRIP001 		}
//STRIP001 
//STRIP001 
//STRIP001 	if (!bOutline)
//STRIP001 		DELETEZ(pUndoTab);
//STRIP001 
//STRIP001 	if (bRecord)
//STRIP001 	{
//STRIP001 		pDocSh->GetUndoManager()->AddUndoAction(
//STRIP001 			new ScUndoWidthOrHeight( pDocSh, *pMarkData,
//STRIP001 									 nStart, nCurTab, nEnd, nCurTab,
//STRIP001 									 pUndoDoc, nRangeCnt, pUndoRanges,
//STRIP001 									 pUndoTab, eMode, nSizeTwips, bWidth ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	for (nTab=0; nTab<nTabCount; nTab++)
//STRIP001 		if (pMarkData->GetTableSelect(nTab))
//STRIP001 			pDoc->UpdatePageBreaks( nTab );
//STRIP001 
//STRIP001 	GetViewData()->GetView()->UpdateScrollBars();
//STRIP001 
//STRIP001 	if (bPaint)
//STRIP001 	{
//STRIP001 		HideCursor();
//STRIP001 
//STRIP001 		for (nTab=0; nTab<nTabCount; nTab++)
//STRIP001 			if (pMarkData->GetTableSelect(nTab))
//STRIP001 			{
//STRIP001 				if (bWidth)
//STRIP001 				{
//STRIP001 					if (pDoc->HasAttrib( nStart,0,nTab, nEnd,MAXROW,nTab, HASATTR_MERGED | HASATTR_OVERLAPPED ))
//STRIP001 						nStart = 0;
//STRIP001 					if (nStart)				// weiter oben anfangen wegen Linien und Cursor
//STRIP001 						--nStart;
//STRIP001 					pDocSh->PostPaint( nStart, 0, nTab, MAXCOL, MAXROW, nTab, PAINT_GRID | PAINT_TOP );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if (pDoc->HasAttrib( 0,nStart,nTab, MAXCOL,nEnd,nTab, HASATTR_MERGED | HASATTR_OVERLAPPED ))
//STRIP001 						nStart = 0;
//STRIP001 					if (nStart)
//STRIP001 						--nStart;
//STRIP001 					pDocSh->PostPaint( 0, nStart, nTab, MAXCOL, MAXROW, nTab, PAINT_GRID | PAINT_LEFT );
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 		pDocSh->UpdateOle(GetViewData());
//STRIP001 		aModificator.SetDocumentModified();
//STRIP001 
//STRIP001 		ShowCursor();
//STRIP001 	}
//STRIP001 }

//	Spaltenbreiten/Zeilenhoehen (ueber Blockmarken)

//STRIP001 void ScViewFunc::SetMarkedWidthOrHeight( BOOL bWidth, ScSizeMode eMode, USHORT nSizeTwips,
//STRIP001 										BOOL bRecord, BOOL bPaint )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 	ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 
//STRIP001 	rMark.MarkToMulti();
//STRIP001 	if (!rMark.IsMultiMarked())
//STRIP001 	{
//STRIP001 		USHORT nCol = GetViewData()->GetCurX();
//STRIP001 		USHORT nRow = GetViewData()->GetCurY();
//STRIP001 		USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 		DoneBlockMode();
//STRIP001 		InitOwnBlockMode();
//STRIP001 		rMark.SetMultiMarkArea( ScRange( nCol,nRow,nTab ), TRUE );
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT* pRanges = new USHORT[MAXROW+1];
//STRIP001 	USHORT nRangeCnt = 0;
//STRIP001 
//STRIP001 	if ( bWidth )
//STRIP001 		nRangeCnt = rMark.GetMarkColumnRanges( pRanges );
//STRIP001 	else
//STRIP001 		nRangeCnt = rMark.GetMarkRowRanges( pRanges );
//STRIP001 
//STRIP001 	SetWidthOrHeight( bWidth, nRangeCnt, pRanges, eMode, nSizeTwips, bRecord, bPaint );
//STRIP001 
//STRIP001 	delete[] pRanges;
//STRIP001 	rMark.MarkToSimple();
//STRIP001 }

//STRIP001 void ScViewFunc::ModifyCellSize( ScDirection eDir, BOOL bOptimal )
//STRIP001 {
//STRIP001 	//!	Schrittweiten einstellbar
//STRIP001 	//	Schrittweite ist auch Minimum
//STRIP001 	USHORT nStepX = STD_COL_WIDTH / 5;
//STRIP001 	USHORT nStepY = ScGlobal::nStdRowHeight;
//STRIP001 
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	BOOL bAnyEdit = pScMod->IsInputMode();
//STRIP001 	USHORT nCol = GetViewData()->GetCurX();
//STRIP001 	USHORT nRow = GetViewData()->GetCurY();
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 
//STRIP001 	BOOL bAllowed, bOnlyMatrix;
//STRIP001 	if ( eDir == DIR_LEFT || eDir == DIR_RIGHT )
//STRIP001 		bAllowed = pDoc->IsBlockEditable( nTab, nCol,0, nCol,MAXROW, &bOnlyMatrix );
//STRIP001 	else
//STRIP001 		bAllowed = pDoc->IsBlockEditable( nTab, 0,nRow, MAXCOL,nRow, &bOnlyMatrix );
//STRIP001 	if ( !bAllowed && !bOnlyMatrix )
//STRIP001 	{
//STRIP001 		ErrorMessage(STR_PROTECTIONERR);
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	HideAllCursors();
//STRIP001 
//STRIP001 	USHORT nWidth = pDoc->GetColWidth( nCol, nTab );
//STRIP001 	USHORT nHeight = pDoc->GetRowHeight( nRow, nTab );
//STRIP001 	USHORT nRange[2];
//STRIP001 	if ( eDir == DIR_LEFT || eDir == DIR_RIGHT )
//STRIP001 	{
//STRIP001 		if (bOptimal)				// Breite dieser einen Zelle
//STRIP001 		{
//STRIP001 			if ( bAnyEdit )
//STRIP001 			{
//STRIP001 				//	beim Editieren die aktuelle Breite der Eingabe
//STRIP001 				ScInputHandler* pHdl = pScMod->GetInputHdl( GetViewData()->GetViewShell() );
//STRIP001 				if (pHdl)
//STRIP001 				{
//STRIP001 					long nEdit = pHdl->GetTextSize().Width();		// in 1/100mm
//STRIP001 
//STRIP001 					const ScPatternAttr* pPattern = pDoc->GetPattern( nCol, nRow, nTab );
//STRIP001 					const SvxMarginItem& rMItem =
//STRIP001 							(const SvxMarginItem&)pPattern->GetItem(ATTR_MARGIN);
//STRIP001 					USHORT nMargin = rMItem.GetLeftMargin() + rMItem.GetRightMargin();
//STRIP001 					if ( ((const SvxHorJustifyItem&) pPattern->
//STRIP001 							GetItem( ATTR_HOR_JUSTIFY )).GetValue() == SVX_HOR_JUSTIFY_LEFT )
//STRIP001 						nMargin += ((const SfxUInt16Item&)pPattern->GetItem(ATTR_INDENT)).GetValue();
//STRIP001 
//STRIP001 					ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 					nWidth = (USHORT)(nEdit * pDocSh->GetOutputFactor() / HMM_PER_TWIPS)
//STRIP001 								+ nMargin + STD_EXTRA_WIDTH;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				double nPPTX = GetViewData()->GetPPTX();
//STRIP001 				double nPPTY = GetViewData()->GetPPTY();
//STRIP001 				Fraction aZoomX = GetViewData()->GetZoomX();
//STRIP001 				Fraction aZoomY = GetViewData()->GetZoomY();
//STRIP001 
//STRIP001 				ScSizeDeviceProvider aProv(pDocSh);
//STRIP001 				if (aProv.IsPrinter())
//STRIP001 				{
//STRIP001 					nPPTX = aProv.GetPPTX();
//STRIP001 					nPPTY = aProv.GetPPTY();
//STRIP001 					aZoomX = aZoomY = Fraction( 1, 1 );
//STRIP001 				}
//STRIP001 
//STRIP001 				long nPixel = pDoc->GetNeededSize( nCol, nRow, nTab, aProv.GetDevice(),
//STRIP001 											nPPTX, nPPTY, aZoomX, aZoomY, TRUE );
//STRIP001 				USHORT nTwips = (USHORT)( nPixel / nPPTX );
//STRIP001 				if (nTwips != 0)
//STRIP001 					nWidth = nTwips + STD_EXTRA_WIDTH;
//STRIP001 				else
//STRIP001 					nWidth = STD_COL_WIDTH;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else						// vergroessern / verkleinern
//STRIP001 		{
//STRIP001 			if ( eDir == DIR_RIGHT )
//STRIP001 				nWidth += nStepX;
//STRIP001 			else if ( nWidth > nStepX )
//STRIP001 				nWidth -= nStepX;
//STRIP001 			if ( nWidth < nStepX ) nWidth = nStepX;
//STRIP001 			if ( nWidth > MAX_COL_WIDTH ) nWidth = MAX_COL_WIDTH;
//STRIP001 		}
//STRIP001 		nRange[0] = nRange[1] = nCol;
//STRIP001 		SetWidthOrHeight( TRUE, 1, nRange, SC_SIZE_DIRECT, nWidth );
//STRIP001 
//STRIP001 		//	hier bei Breite auch Hoehe anpassen (nur die eine Zeile)
//STRIP001 
//STRIP001 		if (!bAnyEdit)
//STRIP001 		{
//STRIP001 			const ScPatternAttr* pPattern = pDoc->GetPattern( nCol, nRow, nTab );
//STRIP001 			BOOL bNeedHeight =
//STRIP001 					((const SfxBoolItem&)pPattern->GetItem( ATTR_LINEBREAK )).GetValue() ||
//STRIP001 					((const SvxHorJustifyItem&)pPattern->
//STRIP001 						GetItem( ATTR_HOR_JUSTIFY )).GetValue() == SVX_HOR_JUSTIFY_BLOCK;
//STRIP001 			if (bNeedHeight)
//STRIP001 				AdjustRowHeight( nRow, nRow );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		ScSizeMode eMode;
//STRIP001 		if (bOptimal)
//STRIP001 		{
//STRIP001 			eMode = SC_SIZE_OPTIMAL;
//STRIP001 			nHeight = 0;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			eMode = SC_SIZE_DIRECT;
//STRIP001 			if ( eDir == DIR_BOTTOM )
//STRIP001 				nHeight += nStepY;
//STRIP001 			else if ( nHeight > nStepY )
//STRIP001 				nHeight -= nStepY;
//STRIP001 			if ( nHeight < nStepY ) nHeight = nStepY;
//STRIP001 			if ( nHeight > MAX_COL_HEIGHT ) nHeight = MAX_COL_HEIGHT;
//STRIP001 			//!	MAX_COL_HEIGHT umbenennen in MAX_ROW_HEIGHT in global.hxx !!!!!!
//STRIP001 		}
//STRIP001 		nRange[0] = nRange[1] = nRow;
//STRIP001 		SetWidthOrHeight( FALSE, 1, nRange, eMode, nHeight );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bAnyEdit )
//STRIP001 	{
//STRIP001 		UpdateEditView();
//STRIP001 		if ( pDoc->HasAttrib( nCol, nRow, nTab, nCol, nRow, nTab, HASATTR_NEEDHEIGHT ) )
//STRIP001 		{
//STRIP001 			ScInputHandler* pHdl = pScMod->GetInputHdl( GetViewData()->GetViewShell() );
//STRIP001 			if (pHdl)
//STRIP001 				pHdl->SetModified();	// damit bei Enter die Hoehe angepasst wird
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	ShowAllCursors();
//STRIP001 }

//STRIP001 void ScViewFunc::Protect( USHORT nTab, const String& rPassword )
//STRIP001 {
//STRIP001 	ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	ScDocFunc aFunc(*pDocSh);
//STRIP001 	BOOL bUndo(pDoc->IsUndoEnabled());
//STRIP001 
//STRIP001 	if ( nTab == TABLEID_DOC || rMark.GetSelectCount() <= 1 )
//STRIP001 		aFunc.Protect( nTab, rPassword, FALSE );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		//	modifying several tables is handled here
//STRIP001 
//STRIP001 		if (bUndo)
//STRIP001 		{
//STRIP001 			String aUndo = ScGlobal::GetRscString( STR_UNDO_PROTECT_TAB );
//STRIP001 			pDocSh->GetUndoManager()->EnterListAction( aUndo, aUndo );
//STRIP001 		}
//STRIP001 
//STRIP001 		USHORT nCount = pDocSh->GetDocument()->GetTableCount();
//STRIP001 		for ( USHORT i=0; i<nCount; i++ )
//STRIP001 			if ( rMark.GetTableSelect(i) )
//STRIP001 				aFunc.Protect( i, rPassword, FALSE );
//STRIP001 
//STRIP001 		if (bUndo)
//STRIP001 			pDocSh->GetUndoManager()->LeaveListAction();
//STRIP001 	}
//STRIP001 
//STRIP001 	UpdateLayerLocks();			//!	broadcast to all views
//STRIP001 }

//STRIP001 BOOL ScViewFunc::Unprotect( USHORT nTab, const String& rPassword )
//STRIP001 {
//STRIP001 	ScMarkData& rMark = GetViewData()->GetMarkData();
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	ScDocFunc aFunc(*pDocSh);
//STRIP001 	BOOL bChanged = FALSE;
//STRIP001 	BOOL bUndo (pDoc->IsUndoEnabled());
//STRIP001 
//STRIP001 	if ( nTab == TABLEID_DOC || rMark.GetSelectCount() <= 1 )
//STRIP001 		bChanged = aFunc.Unprotect( nTab, rPassword, FALSE );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		//	modifying several tables is handled here
//STRIP001 
//STRIP001 		if (bUndo)
//STRIP001 		{
//STRIP001 			String aUndo = ScGlobal::GetRscString( STR_UNDO_UNPROTECT_TAB );
//STRIP001 			pDocSh->GetUndoManager()->EnterListAction( aUndo, aUndo );
//STRIP001 		}
//STRIP001 
//STRIP001 		USHORT nCount = pDocSh->GetDocument()->GetTableCount();
//STRIP001 		for ( USHORT i=0; i<nCount; i++ )
//STRIP001 			if ( rMark.GetTableSelect(i) )
//STRIP001 				if ( aFunc.Unprotect( i, rPassword, FALSE ) )
//STRIP001 					bChanged = TRUE;
//STRIP001 
//STRIP001 		if (bUndo)
//STRIP001 			pDocSh->GetUndoManager()->LeaveListAction();
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bChanged)
//STRIP001 		UpdateLayerLocks();		//!	broadcast to all views
//STRIP001 
//STRIP001 	return bChanged;
//STRIP001 }

//STRIP001 void ScViewFunc::SetNote( USHORT nCol, USHORT nRow, USHORT nTab, const ScPostIt& rNote )
//STRIP001 {
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	pDocSh->GetDocFunc().SetNote( ScAddress(nCol,nRow,nTab), rNote, FALSE );
//STRIP001 }

//STRIP001 void ScViewFunc::SetNumberFormat( short nFormatType, ULONG nAdd )
//STRIP001 {
//STRIP001 	// nur wegen Matrix nicht editierbar? Attribute trotzdem ok
//STRIP001 	BOOL bOnlyNotBecauseOfMatrix;
//STRIP001 	if ( !SelectionEditable( &bOnlyNotBecauseOfMatrix ) && !bOnlyNotBecauseOfMatrix )
//STRIP001 	{
//STRIP001 		ErrorMessage(STR_PROTECTIONERR);
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	ULONG				nNumberFormat = 0;
//STRIP001 	ScViewData*			pViewData = GetViewData();
//STRIP001 	ScDocument*			pDoc = pViewData->GetDocument();
//STRIP001 	SvNumberFormatter*	pNumberFormatter = pDoc->GetFormatTable();
//STRIP001 	LanguageType		eLanguage = ScGlobal::eLnge;
//STRIP001 	ScPatternAttr		aNewAttrs( pDoc->GetPool() );
//STRIP001 
//STRIP001 	//	#67936# always take language from cursor position, even if there is a selection
//STRIP001 
//STRIP001 	ULONG nCurrentNumberFormat;
//STRIP001 	pDoc->GetNumberFormat( pViewData->GetCurX(),
//STRIP001 						   pViewData->GetCurY(),
//STRIP001 						   pViewData->GetTabNo(),
//STRIP001 						   nCurrentNumberFormat );
//STRIP001 	const SvNumberformat* pEntry = pNumberFormatter->GetEntry( nCurrentNumberFormat );
//STRIP001 	if (pEntry)
//STRIP001 		eLanguage = pEntry->GetLanguage();		// sonst ScGlobal::eLnge behalten
//STRIP001 
//STRIP001 	nNumberFormat =	pNumberFormatter->GetStandardFormat( nFormatType, eLanguage ) + nAdd;
//STRIP001 
//STRIP001 	SfxItemSet& rSet = aNewAttrs.GetItemSet();
//STRIP001 	rSet.Put( SfxUInt32Item( ATTR_VALUE_FORMAT, nNumberFormat ) );
//STRIP001 	//	ATTR_LANGUAGE_FORMAT nicht
//STRIP001 	ApplySelectionPattern( aNewAttrs, TRUE );
//STRIP001 }

//STRIP001 void ScViewFunc::SetNumFmtByStr( const String& rCode )
//STRIP001 {
//STRIP001 	// nur wegen Matrix nicht editierbar? Attribute trotzdem ok
//STRIP001 	BOOL bOnlyNotBecauseOfMatrix;
//STRIP001 	if ( !SelectionEditable( &bOnlyNotBecauseOfMatrix ) && !bOnlyNotBecauseOfMatrix )
//STRIP001 	{
//STRIP001 		ErrorMessage(STR_PROTECTIONERR);
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	ScViewData*			pViewData = GetViewData();
//STRIP001 	ScDocument*			pDoc = pViewData->GetDocument();
//STRIP001 	SvNumberFormatter*	pFormatter = pDoc->GetFormatTable();
//STRIP001 
//STRIP001 	//	Sprache immer von Cursorposition
//STRIP001 
//STRIP001 	ULONG nCurrentNumberFormat;
//STRIP001 	pDoc->GetNumberFormat( pViewData->GetCurX(), pViewData->GetCurY(),
//STRIP001 						   pViewData->GetTabNo(), nCurrentNumberFormat );
//STRIP001 	const SvNumberformat* pEntry = pFormatter->GetEntry( nCurrentNumberFormat );
//STRIP001 	LanguageType eLanguage = pEntry ? pEntry->GetLanguage() : ScGlobal::eLnge;
//STRIP001 
//STRIP001 	//	Index fuer String bestimmen
//STRIP001 
//STRIP001 	BOOL bOk = TRUE;
//STRIP001 	ULONG nNumberFormat = pFormatter->GetEntryKey( rCode, eLanguage );
//STRIP001 	if ( nNumberFormat == NUMBERFORMAT_ENTRY_NOT_FOUND )
//STRIP001 	{
//STRIP001 		//	neu eintragen
//STRIP001 
//STRIP001 		String		aFormat	= rCode;	// wird veraendert
//STRIP001 		xub_StrLen	nErrPos	= 0;
//STRIP001 		short		nType	= 0;		//! ???
//STRIP001 		bOk = pFormatter->PutEntry( aFormat, nErrPos, nType, nNumberFormat, eLanguage );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bOk )			// gueltiges Format?
//STRIP001 	{
//STRIP001 		ScPatternAttr aNewAttrs( pDoc->GetPool() );
//STRIP001 		SfxItemSet& rSet = aNewAttrs.GetItemSet();
//STRIP001 		rSet.Put( SfxUInt32Item( ATTR_VALUE_FORMAT, nNumberFormat ) );
//STRIP001 		rSet.Put( SvxLanguageItem( eLanguage, ATTR_LANGUAGE_FORMAT ) );
//STRIP001 		ApplySelectionPattern( aNewAttrs, TRUE );
//STRIP001 	}
//STRIP001 
//STRIP001 	//!	sonst Fehler zuerueckgeben / Meldung ausgeben ???
//STRIP001 }

//STRIP001 void ScViewFunc::ChangeNumFmtDecimals( BOOL bIncrement )
//STRIP001 {
//STRIP001 	// nur wegen Matrix nicht editierbar? Attribute trotzdem ok
//STRIP001 	BOOL bOnlyNotBecauseOfMatrix;
//STRIP001 	if ( !SelectionEditable( &bOnlyNotBecauseOfMatrix ) && !bOnlyNotBecauseOfMatrix )
//STRIP001 	{
//STRIP001 		ErrorMessage(STR_PROTECTIONERR);
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	ScDocument*			pDoc = GetViewData()->GetDocument();
//STRIP001 	SvNumberFormatter*	pFormatter = pDoc->GetFormatTable();
//STRIP001 
//STRIP001 	USHORT nCol = GetViewData()->GetCurX();
//STRIP001 	USHORT nRow = GetViewData()->GetCurY();
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 
//STRIP001 	ULONG nOldFormat;
//STRIP001 	pDoc->GetNumberFormat( nCol, nRow, nTab, nOldFormat );
//STRIP001 	const SvNumberformat* pOldEntry = pFormatter->GetEntry( nOldFormat );
//STRIP001 	if (!pOldEntry)
//STRIP001 	{
//STRIP001 		DBG_ERROR("Zahlformat nicht gefunden !!!");
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	//	was haben wir denn da?
//STRIP001 
//STRIP001 	ULONG nNewFormat = nOldFormat;
//STRIP001 	BOOL bError = FALSE;
//STRIP001 
//STRIP001 	LanguageType eLanguage = pOldEntry->GetLanguage();
//STRIP001 	BOOL bThousand, bNegRed;
//STRIP001 	USHORT nPrecision, nLeading;
//STRIP001 	pOldEntry->GetFormatSpecialInfo( bThousand, bNegRed, nPrecision, nLeading );
//STRIP001 
//STRIP001 	short nOldType = pOldEntry->GetType();
//STRIP001 	if ( 0 == ( nOldType & (
//STRIP001 				NUMBERFORMAT_NUMBER |  NUMBERFORMAT_CURRENCY | NUMBERFORMAT_PERCENT ) ) )
//STRIP001 	{
//STRIP001 		//	Datum, Zeit, Bruch, logisch, Text kann nicht angepasst werden
//STRIP001 		//!	bei Wisssenschaftlich kann es der Numberformatter auch nicht
//STRIP001 		bError = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	//!	Das SvNumberformat hat einen Member bStandard, verraet ihn aber nicht
//STRIP001 	BOOL bWasStandard = ( nOldFormat == pFormatter->GetStandardIndex( eLanguage ) );
//STRIP001 	if (bWasStandard)
//STRIP001 	{
//STRIP001 		//	bei "Standard" die Nachkommastellen abhaengig vom Zellinhalt
//STRIP001 		//	0 bei leer oder Text -> keine Nachkommastellen
//STRIP001 		double nVal = pDoc->GetValue( ScAddress( nCol, nRow, nTab ) );
//STRIP001 
//STRIP001 		//	Die Wege des Numberformatters sind unergruendlich, darum ausprobieren:
//STRIP001 		String aOut;
//STRIP001 		Color* pCol;
//STRIP001 		((SvNumberformat*)pOldEntry)->GetOutputString( nVal, aOut, &pCol );
//STRIP001 
//STRIP001 		nPrecision = 0;
//STRIP001 		// 'E' fuer Exponential ist fest im Numberformatter
//STRIP001 		if ( aOut.Search('E') != STRING_NOTFOUND )
//STRIP001 			bError = TRUE;								// Exponential nicht veraendern
//STRIP001 		else
//STRIP001 		{
//STRIP001 			String aDecSep( pFormatter->GetFormatDecimalSep( nOldFormat ) );
//STRIP001 			xub_StrLen nPos = aOut.Search( aDecSep );
//STRIP001 			if ( nPos != STRING_NOTFOUND )
//STRIP001 				nPrecision = aOut.Len() - nPos - aDecSep.Len();
//STRIP001 			// sonst 0 behalten
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!bError)
//STRIP001 	{
//STRIP001 		if (bIncrement)
//STRIP001 		{
//STRIP001 			if (nPrecision<20)
//STRIP001 				++nPrecision;			// erhoehen
//STRIP001 			else
//STRIP001 				bError = TRUE;			// 20 ist Maximum
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if (nPrecision)
//STRIP001 				--nPrecision;			// vermindern
//STRIP001 			else
//STRIP001 				bError = TRUE;			// weniger als 0 geht nicht
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!bError)
//STRIP001 	{
//STRIP001 		String aNewPicture;
//STRIP001 		pFormatter->GenerateFormat( aNewPicture, nOldFormat, eLanguage,
//STRIP001 									bThousand, bNegRed, nPrecision, nLeading );
//STRIP001 
//STRIP001 		nNewFormat = pFormatter->GetEntryKey( aNewPicture, eLanguage );
//STRIP001 		if ( nNewFormat == NUMBERFORMAT_ENTRY_NOT_FOUND )
//STRIP001 		{
//STRIP001 			xub_StrLen nErrPos = 0;
//STRIP001 			short nNewType = 0;
//STRIP001 			BOOL bOk = pFormatter->PutEntry( aNewPicture, nErrPos,
//STRIP001 												nNewType, nNewFormat, eLanguage );
//STRIP001 			DBG_ASSERT( bOk, "falsches Zahlformat generiert" );
//STRIP001 			if (!bOk)
//STRIP001 				bError = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!bError)
//STRIP001 	{
//STRIP001 		ScPatternAttr aNewAttrs( pDoc->GetPool() );
//STRIP001 		SfxItemSet& rSet = aNewAttrs.GetItemSet();
//STRIP001 		rSet.Put( SfxUInt32Item( ATTR_VALUE_FORMAT, nNewFormat ) );
//STRIP001 		//	ATTR_LANGUAGE_FORMAT nicht
//STRIP001 		ApplySelectionPattern( aNewAttrs, TRUE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		Sound::Beep();				// war nix
//STRIP001 }

//STRIP001 void ScViewFunc::ChangeIndent( BOOL bIncrement )
//STRIP001 {
//STRIP001 	ScViewData* pViewData = GetViewData();
//STRIP001 	ScDocShell* pDocSh	= pViewData->GetDocShell();
//STRIP001 	ScMarkData& rMark	= pViewData->GetMarkData();
//STRIP001 
//STRIP001 	ScMarkData aWorkMark = rMark;
//STRIP001 	aWorkMark.MarkToMulti();
//STRIP001 	if (!aWorkMark.IsMultiMarked())
//STRIP001 	{
//STRIP001 		USHORT nCol = pViewData->GetCurX();
//STRIP001 		USHORT nRow = pViewData->GetCurY();
//STRIP001 		USHORT nTab = pViewData->GetTabNo();
//STRIP001 		aWorkMark.SetMultiMarkArea( ScRange(nCol,nRow,nTab) );
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bSuccess = pDocSh->GetDocFunc().ChangeIndent( aWorkMark, bIncrement, FALSE );
//STRIP001 	if (bSuccess)
//STRIP001 	{
//STRIP001 		pDocSh->UpdateOle(pViewData);
//STRIP001 		StartFormatArea();
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL ScViewFunc::InsertName( const String& rName, const String& rSymbol,
//STRIP001 								const String& rType )
//STRIP001 {
//STRIP001 	//	Type = P,R,C,F (und Kombinationen)
//STRIP001 	//!	Undo...
//STRIP001 
//STRIP001 	BOOL bOk = FALSE;
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	ScDocument* pDoc = pDocSh->GetDocument();
//STRIP001 	USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 	ScRangeName* pList = pDoc->GetRangeName();
//STRIP001 
//STRIP001 	RangeType nType = RT_NAME;
//STRIP001     ScRangeData* pNewEntry = new ScRangeData( pDoc, rName, rSymbol,
//STRIP001             ScAddress( GetViewData()->GetCurX(), GetViewData()->GetCurY(),
//STRIP001                 nTab), nType );
//STRIP001 	String aUpType = rType;
//STRIP001 	aUpType.ToUpperAscii();
//STRIP001 	if ( aUpType.Search( 'P' ) != STRING_NOTFOUND )
//STRIP001 		nType |= RT_PRINTAREA;
//STRIP001 	if ( aUpType.Search( 'R' ) != STRING_NOTFOUND )
//STRIP001 		nType |= RT_ROWHEADER;
//STRIP001 	if ( aUpType.Search( 'C' ) != STRING_NOTFOUND )
//STRIP001 		nType |= RT_COLHEADER;
//STRIP001 	if ( aUpType.Search( 'F' ) != STRING_NOTFOUND )
//STRIP001 		nType |= RT_CRITERIA;
//STRIP001 	pNewEntry->AddType(nType);
//STRIP001 
//STRIP001 	if ( !pNewEntry->GetErrCode() )		//	Text gueltig?
//STRIP001 	{
//STRIP001 		ScDocShellModificator aModificator( *pDocSh );
//STRIP001 
//STRIP001 		pDoc->CompileNameFormula( TRUE );	// CreateFormulaString
//STRIP001 
//STRIP001 		// Eintrag bereits vorhanden? Dann vorher entfernen (=Aendern)
//STRIP001 		USHORT nFoundAt;
//STRIP001 		if ( pList->SearchName( rName, nFoundAt ) )
//STRIP001 		{									// alten Index uebernehmen
//STRIP001 			pNewEntry->SetIndex( ((ScRangeData*)pList->At(nFoundAt))->GetIndex() );
//STRIP001 			pList->AtFree( nFoundAt );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pList->Insert( pNewEntry ) )
//STRIP001 		{
//STRIP001 			pNewEntry = NULL;	// nicht loeschen
//STRIP001 			bOk = TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001 		pDoc->CompileNameFormula( FALSE );	// CompileFormulaString
//STRIP001 		aModificator.SetDocumentModified();
//STRIP001 		SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_AREAS_CHANGED ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pNewEntry;		// wenn er nicht eingefuegt wurde
//STRIP001 	return bOk;
//STRIP001 }

//STRIP001 void ScViewFunc::CreateNames( USHORT nFlags )
//STRIP001 {
//STRIP001 	BOOL bDone = FALSE;
//STRIP001 	ScRange aRange;
//STRIP001 	if ( GetViewData()->GetSimpleArea(aRange) )
//STRIP001 		bDone = GetViewData()->GetDocShell()->GetDocFunc().CreateNames( aRange, nFlags, FALSE );
//STRIP001 
//STRIP001 	if (!bDone)
//STRIP001 		ErrorMessage(STR_CREATENAME_MARKERR);
//STRIP001 }

//STRIP001 USHORT ScViewFunc::GetCreateNameFlags()
//STRIP001 {
//STRIP001 	USHORT nFlags = 0;
//STRIP001 
//STRIP001 	USHORT nStartCol,nStartRow,nEndCol,nEndRow;
//STRIP001 	USHORT nDummy;
//STRIP001 	if (GetViewData()->GetSimpleArea(nStartCol,nStartRow,nDummy,nEndCol,nEndRow,nDummy))
//STRIP001 	{
//STRIP001 		ScDocument* pDoc = GetViewData()->GetDocument();
//STRIP001 		USHORT nTab = GetViewData()->GetTabNo();
//STRIP001 		USHORT i;
//STRIP001 		BOOL bOk;
//STRIP001 
//STRIP001 		bOk = TRUE;
//STRIP001 		USHORT nFirstCol = nStartCol;
//STRIP001 		USHORT nLastCol  = nEndCol;
//STRIP001 		if (nStartCol+1 < nEndCol) { ++nFirstCol; --nLastCol; }
//STRIP001 		for (i=nFirstCol; i<=nLastCol && bOk; i++)
//STRIP001 			if (!pDoc->HasStringData( i,nStartRow,nTab ))
//STRIP001 				bOk = FALSE;
//STRIP001 		if (bOk)
//STRIP001 			nFlags |= NAME_TOP;
//STRIP001 		else							// Bottom nur wenn nicht Top
//STRIP001 		{
//STRIP001 			bOk = TRUE;
//STRIP001 			for (i=nFirstCol; i<=nLastCol && bOk; i++)
//STRIP001 				if (!pDoc->HasStringData( i,nEndRow,nTab ))
//STRIP001 					bOk = FALSE;
//STRIP001 			if (bOk)
//STRIP001 				nFlags |= NAME_BOTTOM;
//STRIP001 		}
//STRIP001 
//STRIP001 		bOk = TRUE;
//STRIP001 		USHORT nFirstRow = nStartRow;
//STRIP001 		USHORT nLastRow  = nEndRow;
//STRIP001 		if (nStartRow+1 < nEndRow) { ++nFirstRow; --nLastRow; }
//STRIP001 		for (i=nFirstRow; i<=nLastRow && bOk; i++)
//STRIP001 			if (!pDoc->HasStringData( nStartCol,i,nTab ))
//STRIP001 				bOk = FALSE;
//STRIP001 		if (bOk)
//STRIP001 			nFlags |= NAME_LEFT;
//STRIP001 		else							// Right nur wenn nicht Left
//STRIP001 		{
//STRIP001 			bOk = TRUE;
//STRIP001 			for (i=nFirstRow; i<=nLastRow && bOk; i++)
//STRIP001 				if (!pDoc->HasStringData( nEndCol,i,nTab ))
//STRIP001 					bOk = FALSE;
//STRIP001 			if (bOk)
//STRIP001 				nFlags |= NAME_RIGHT;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nStartCol == nEndCol)
//STRIP001 		nFlags &= ~( NAME_LEFT | NAME_RIGHT );
//STRIP001 	if (nStartRow == nEndRow)
//STRIP001 		nFlags &= ~( NAME_TOP | NAME_BOTTOM );
//STRIP001 
//STRIP001 	return nFlags;
//STRIP001 }

//STRIP001 void ScViewFunc::InsertNameList()
//STRIP001 {
//STRIP001 	ScAddress aPos( GetViewData()->GetCurX(), GetViewData()->GetCurY(), GetViewData()->GetTabNo() );
//STRIP001 	ScDocShell* pDocSh = GetViewData()->GetDocShell();
//STRIP001 	if ( pDocSh->GetDocFunc().InsertNameList( aPos, FALSE ) )
//STRIP001 		pDocSh->UpdateOle(GetViewData());
//STRIP001 }




}
