/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_SchRangeChecker.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:49:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {

/**	$Revision  
	@descr A RangeChecker has the task to test if the y value range of a given 
		data set complies with a given chart type.
	
	@author
		Andre Fischer (af)
*/

//STRIP001 #include	<SchRangeChecker.hxx>

//STRIP001 #include	<chaxis.hxx>
//STRIP001 #include	<chtmodel.hxx>


//STRIP001 SchRangeChecker::SchRangeChecker		(ChartModel * pChartModel)
//STRIP001 	:	mpChartModel (pChartModel)	
//STRIP001 {
//STRIP001 	//	We have to determine minimum and maximum values of the data set here, 
//STRIP001 	//	because the values returned by the y-axis are not sufficient.
//STRIP001 	
//STRIP001 	long	nColCount = pChartModel->GetColCount(),
//STRIP001 			nRowCount = pChartModel->GetRowCount(),
//STRIP001 			nCol,
//STRIP001 			nRow;
//STRIP001 	double	fVal;
//STRIP001 				
//STRIP001 	if ((nColCount <= 0) || (nRowCount <= 0))
//STRIP001 	{
//STRIP001 		//	Use default values if we have no data.
//STRIP001 		mfMin = mfMax = 0;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		mfMin = mfMax = pChartModel->GetData (0,0);
//STRIP001 		//	Just iterate over all data points.
//STRIP001 		for (nCol=0; nCol<nColCount; nCol++)
//STRIP001 			for (nRow=0; nRow<nRowCount; nRow++)
//STRIP001 			{
//STRIP001 				fVal = pChartModel->GetData (nCol,nRow);
//STRIP001 				if (fVal < mfMin)
//STRIP001 					mfMin = fVal;
//STRIP001 				if (fVal > mfMax)
//STRIP001 					mfMax = fVal;
//STRIP001 			}
//STRIP001 	}
//STRIP001 }


	
//STRIP001 SchRangeChecker::~SchRangeChecker	(void)	
//STRIP001 {
//STRIP001 }



//STRIP001 BOOL	SchRangeChecker::TestAbsoluteValues	(SvxChartStyle eChartStyle)
//STRIP001 {
//STRIP001 	return (	(mfMin < 0.0)
//STRIP001 			&&	(mfMax > 0.0) 
//STRIP001 			&&	( ! mpChartModel->IsSignedChart(&eChartStyle))	);
//STRIP001 }



//STRIP001 BOOL	SchRangeChecker::TestNegativeValues	(SvxChartStyle eChartStyle)
//STRIP001 {
//STRIP001 	return (	(mfMin < 0.0)
//STRIP001 			&&	( ! mpChartModel->IsNegativeChart(&eChartStyle))	);
//STRIP001 }



//STRIP001 BOOL	SchRangeChecker::TestLogarithmicValues	(void)
//STRIP001 {
//STRIP001 	return (	(mfMin <= 0.0)
//STRIP001 			&&	((const SfxBoolItem&)mpChartModel->GetAttr(CHOBJID_DIAGRAM_Y_AXIS).Get(
//STRIP001 						SCHATTR_AXIS_LOGARITHM)).GetValue());
//STRIP001 }
}
