/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_AccGrid.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 22:06:59 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "AccGrid.hxx"

// for SolarMutex
#ifndef _SV_SVAPP_HXX 
#include <vcl/svapp.hxx>
#endif

#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif

#include "objid.hxx"
namespace binfilter {

using ::rtl::OUString;

namespace accessibility
{

Grid::Grid( AccessibleBase * pParent, GridType eType ) :
        AccessibleChartElement( AccessibleUniqueId( static_cast< sal_uInt16 >( eType ) ),
                                pParent,
                                false /* has no children */,
                                true  /* always transparent */ ),
    m_eType( eType )
{
    ChartModel * pModel = GetChartModel();
    OSL_ASSERT( pModel );

    // /-- solar
    ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
    SetItemSet( pModel->GetGridAttr( static_cast< sal_uInt16 >( eType )) );
    // \-- solar
}

Grid::~Grid()
{}

SdrObject * Grid::GetDrawObject() const
{
    CheckDisposeState();

    SdrObject * pShape;

    ChartModel * pModel = GetChartModel();
    if( pModel != NULL )
    {
        sal_uInt16 nId = CHOBJID_ANY;
        switch( m_eType )
        {
            case X_MAJOR:
                nId = CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP;
                break;
            case Y_MAJOR:
                nId = CHOBJID_DIAGRAM_Y_GRID_MAIN_GROUP;
                break;
            case Z_MAJOR:
                nId = CHOBJID_DIAGRAM_Z_GRID_MAIN_GROUP;
                break;
            case X_MINOR:
                // note: this id is correct, x/y minor grids are interchanged
                nId = CHOBJID_DIAGRAM_Y_GRID_HELP_GROUP;
                break;
            case Y_MINOR:
                // note: this id is correct, x/y minor grids are interchanged
                nId = CHOBJID_DIAGRAM_X_GRID_HELP_GROUP;
                break;
            case Z_MINOR:
                nId = CHOBJID_DIAGRAM_Z_GRID_HELP_GROUP;
                break;
        }
        // /-- solar
        ::vos::OGuard aSolarGuard( Application::GetSolarMutex() );
        pShape = GetObjWithId( nId, *pModel->GetPage( 0 ), 0, IM_DEEPWITHGROUPS );
        // \-- solar
    }

    return pShape;
}

OUString SAL_CALL Grid::getAccessibleName()
    throw (::com::sun::star::uno::RuntimeException)
{
    return getToolTipText();
}

// OUString SAL_CALL Grid::getAccessibleDescription()
//     throw (::com::sun::star::uno::RuntimeException)
// {
// }

OUString SAL_CALL Grid::getImplementationName() 
    throw (::com::sun::star::uno::RuntimeException)
{
    return OUString( RTL_CONSTASCII_USTRINGPARAM( "AccGrid" ));
}

}  // namespace accessibility
}
