/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: attrib.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 22:44:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SCH_ATTRIB_HXX
#define _SCH_ATTRIB_HXX

#ifndef _SFXTABDLG_HXX
#include <bf_sfx2/tabdlg.hxx>
#endif

#ifndef _SVX_TAB_AREA_HXX
#include <bf_svx/tabarea.hxx>
#endif

#ifndef _SVX_CHRTITEM_HXX //autogen
#include <bf_svx/chrtitem.hxx>
#endif

class SfxObjectShell;
class ChartModel;

#ifndef WORIENT_HXX //autogen
#include <bf_svx/worient.hxx>
#endif
// header for FixedLine
#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif
namespace binfilter {

enum AttrType
{
	ATTR_TITLE,
	ATTR_LEGEND,
	ATTR_DATA_ROW,
	ATTR_DATA_LINE,
	ATTR_DATA_POINT,
	ATTR_AXIS,
	ATTR_X_AXIS_2D,
	ATTR_X_AXIS_3D,
	ATTR_Y_AXIS_2D,
	ATTR_Y_AXIS_3D,
	ATTR_Z_AXIS,
	ATTR_GRID,
	ATTR_DIAGRAM_AREA,
	ATTR_DIAGRAM_WALL,
	ATTR_DIAGRAM_FLOOR,
	ATTR_LINE,
	ATTR_DIAGRAM_STOCK_LOSS,
	ATTR_DIAGRAM_STOCK_PLUS
};

#define CHATTR_COUNT	(CHATTR_DIAGRAM_FLOOR + 1)

enum OrderMode
{
	CHORDMODE_NONE,
	CHORDMODE_X_AXIS,
	CHORDMODE_Y_AXIS
};

#define CHORDMODE_COUNT	(CHORDMODE_Y_AXIS + 1)

#define AxisTypeX 1
#define AxisTypeY 2
#define AxisTypeZ 3

/*************************************************************************
|*
|* Attributs-Tab-Dialog
|*
\************************************************************************/
//STRIP001 class SchAttribTabDlg : public SfxTabDialog
//STRIP001 {
//STRIP001 private:
//STRIP001 	Graphic			maSymbolGraphic;
//STRIP001 	ChartModel      *pMyModel;
//STRIP001 	XColorTable*  	pColorTab;
//STRIP001 	XGradientList*	pGradientList;
//STRIP001 	XHatchList*	  	pHatchingList;
//STRIP001 	XBitmapList*  	pBitmapList;
//STRIP001 	XDashList*	  	pDashList;
//STRIP001 	XLineEndList* 	pLineEndList;
//STRIP001 	long            nAxisType;
//STRIP001 
//STRIP001 	USHORT		  	nPageType;
//STRIP001 	USHORT		  	nDlgType;
//STRIP001 	USHORT		  	nPos;
//STRIP001 	ChangeType	  	nColorTableState;
//STRIP001 	ChangeType	  	nBitmapListState;
//STRIP001 	ChangeType	  	nGradientListState;
//STRIP001 	ChangeType	  	nHatchingListState;
//STRIP001 
//STRIP001 	const SfxItemSet *mpSymbolAttr;
//STRIP001 
//STRIP001 	AttrType eAttrType;
//STRIP001 
//STRIP001 	const SfxObjectShell& rDocShell;
//STRIP001 
//STRIP001 	static USHORT GetResId(AttrType eType);
//STRIP001 
//STRIP001 	virtual void PageCreated(USHORT nId, SfxTabPage& rPage);
//STRIP001 
//STRIP001 public:
//STRIP001 	SchAttribTabDlg(Window* pParent, AttrType eType,
//STRIP001 					const SfxItemSet* pAttr,
//STRIP001 					const SfxObjectShell* pDocShell,
//STRIP001 					const ChartModel* pModel,
//STRIP001 					int   nID,
//STRIP001 					int   nType,
//STRIP001 					const SfxItemSet* pSymbolAttr=NULL,
//STRIP001 					Graphic aSymbolGraphic=Graphic());
//STRIP001 	virtual ~SchAttribTabDlg();
//STRIP001 };

/*************************************************************************
|*
|* Legenden-Anordnungs-Tab-Page
|*
\************************************************************************/
//STRIP001 class SchLegendPosTabPage : public SfxTabPage
//STRIP001 {
//STRIP001 private:
//STRIP001 	FixedLine	aGrpLegend;
//STRIP001 	RadioButton	aRbtLeft;
//STRIP001 	RadioButton	aRbtTop;
//STRIP001 	RadioButton	aRbtBottom;
//STRIP001 	RadioButton	aRbtRight;
//STRIP001 
//STRIP001 	const SfxItemSet&	rOutAttrs;
//STRIP001 
//STRIP001 public:
//STRIP001 	SchLegendPosTabPage(Window* pParent, const SfxItemSet& rInAttrs);
//STRIP001 	virtual ~SchLegendPosTabPage();
//STRIP001 
//STRIP001 	static SfxTabPage* Create(Window* pParent, const SfxItemSet& rInAttrs);
//STRIP001 	virtual BOOL FillItemSet(SfxItemSet& rOutAttrs);
//STRIP001 	virtual void Reset(const SfxItemSet& rInAttrs);
//STRIP001 };

/*************************************************************************
|*
|* Layout-Tab-Page
|*
\************************************************************************/
//STRIP001 class SchLayoutTabPage : public SfxTabPage
//STRIP001 {
//STRIP001 private:
//STRIP001 	FixedText	aFtLayout;
//STRIP001 	ListBox     aListShapes;
//STRIP001 
//STRIP001 	const SfxItemSet&	rOutAttrs;
//STRIP001 
//STRIP001 public:
//STRIP001 	SchLayoutTabPage(Window* pParent, const SfxItemSet& rInAttrs);
//STRIP001 	virtual ~SchLayoutTabPage();
//STRIP001 
//STRIP001 	static SfxTabPage* Create(Window* pParent, const SfxItemSet& rInAttrs);
//STRIP001 	virtual BOOL FillItemSet(SfxItemSet& rOutAttrs);
//STRIP001 	virtual void Reset(const SfxItemSet& rInAttrs);
//STRIP001 };
/*************************************************************************
|*
|* Layout-Tab-Page
|*
\************************************************************************/
//STRIP001 class SchOptionTabPage : public SfxTabPage
//STRIP001 {
//STRIP001 private:
//STRIP001 	FixedLine	aGrpAxis;
//STRIP001     RadioButton aRbtAxis1;
//STRIP001     RadioButton aRbtAxis2;
//STRIP001 
//STRIP001 	FixedLine	aGrpBar;
//STRIP001 	FixedText   aFTGap;
//STRIP001 	MetricField aMTGap;
//STRIP001 	FixedText   aFTOverlap;
//STRIP001 	MetricField aMTOverlap;
//STRIP001 	CheckBox	aCBConnect;
//STRIP001 
//STRIP001     const SfxItemSet&   rOutAttrs;
//STRIP001 public:
//STRIP001 	SchOptionTabPage(Window* pParent, const SfxItemSet& rInAttrs);
//STRIP001 	virtual ~SchOptionTabPage();
//STRIP001 
//STRIP001 	static SfxTabPage* Create(Window* pParent, const SfxItemSet& rInAttrs);
//STRIP001 	virtual BOOL FillItemSet(SfxItemSet& rOutAttrs);
//STRIP001 	virtual void Reset(const SfxItemSet& rInAttrs);
//STRIP001 };
/*************************************************************************
|*
|* Datenbeschriftungs-Tab-Page
|*
\************************************************************************/
//STRIP001 class SchDataDescrTabPage : public SfxTabPage
//STRIP001 {
//STRIP001 private:
//STRIP001 	CheckBox			aCbValue;
//STRIP001 	RadioButton			aRbNumber;
//STRIP001 	RadioButton			aRbPercent;
//STRIP001 	CheckBox			aCbText;
//STRIP001 	CheckBox			aCbSymbol;
//STRIP001 
//STRIP001 	const SfxItemSet&	rOutAttrs;
//STRIP001 
//STRIP001 	DECL_LINK(EnableHdl, CheckBox * );
//STRIP001 
//STRIP001 public:
//STRIP001 	SchDataDescrTabPage(Window* pParent, const SfxItemSet& rInAttrs);
//STRIP001 	virtual ~SchDataDescrTabPage();
//STRIP001 
//STRIP001 	static SfxTabPage* Create(Window* pParent, const SfxItemSet& rInAttrs);
//STRIP001 	virtual BOOL FillItemSet(SfxItemSet& rOutAttrs);
//STRIP001 	virtual void Reset(const SfxItemSet& rInAttrs);
//STRIP001 };

/*************************************************************************
|*
|* Datenbeschriftungs-Tab-Page
|*
\************************************************************************/
//STRIP001 class SchStatisticTabPage : public SfxTabPage
//STRIP001 {
//STRIP001 private:
//STRIP001 	CheckBox    aCbxAverage;
//STRIP001 	FixedLine   aFlDescr;
//STRIP001 	RadioButton aRbtNone;
//STRIP001 	RadioButton aRbtVariant;
//STRIP001 	RadioButton aRbtSigma;
//STRIP001 	RadioButton aRbtPercent;
//STRIP001 	RadioButton aRbtBigError;
//STRIP001 	RadioButton aRbtConst;
//STRIP001 	MetricField aMtrFldPercent;
//STRIP001 	MetricField aMtrFldBigError;
//STRIP001 	FixedText	aFTConstPlus;
//STRIP001 	MetricField aMtrFldConstPlus;
//STRIP001 	FixedText	aFTConstMinus;
//STRIP001 	MetricField aMtrFldConstMinus;
//STRIP001 	FixedText	aFTIndicate;
//STRIP001 	ValueSet 	aSet;
//STRIP001 	FixedText	aFTRegress;
//STRIP001 	ValueSet 	aRegression;
//STRIP001 
//STRIP001 	BOOL                bRegressionDisabled;
//STRIP001 	BOOL                bDisabled;
//STRIP001 	SvxChartKindError   eKindError;
//STRIP001 	SvxChartIndicate    eIndicate;
//STRIP001 	SvxChartRegress     eRegression;
//STRIP001 
//STRIP001 	const SfxItemSet&	rOutAttrs;
//STRIP001 
//STRIP001 	DECL_LINK(CbxClick, CheckBox *);
//STRIP001 	DECL_LINK(RBtnClick, Button *);
//STRIP001 	DECL_LINK(SelectIndicate, void *);
//STRIP001 	DECL_LINK(SelectRegression, void *);
//STRIP001 	DECL_LINK(EditLoseFocusHdl, Control*);
//STRIP001 
//STRIP001     void FillValueSets();
//STRIP001 
//STRIP001 public:
//STRIP001 	SchStatisticTabPage (Window* pParent, const SfxItemSet& rInAttrs);
//STRIP001 	virtual ~SchStatisticTabPage ();
//STRIP001 
//STRIP001 	static SfxTabPage* Create(Window* pParent, const SfxItemSet& rInAttrs);
//STRIP001 	virtual BOOL FillItemSet(SfxItemSet& rOutAttrs);
//STRIP001 	virtual void Reset(const SfxItemSet& rInAttrs);
//STRIP001 
//STRIP001 	virtual void	DataChanged( const DataChangedEvent& rDCEvt );
//STRIP001 };

/*************************************************************************
|*
|* Textausrichtungs-Tab-Page
|*
\************************************************************************/
//STRIP001 class SchAlignmentTabPage : public SfxTabPage
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 
//STRIP001 	//Seit 4/1998 koennen Texte frei gedreht werden: SID_ATTR_ALIGN_DEGREES
//STRIP001 	SvxWinOrientation	aWinOrient;
//STRIP001 
//STRIP001 	CheckBox   	aCbxTextOverlap;
//STRIP001 
//STRIP001 	CheckBox   	aCbxTextBreak;
//STRIP001 	FixedLine  	aFlTextBreak;
//STRIP001 
//STRIP001 	RadioButton	aRbtSideBySide;
//STRIP001 	RadioButton	aRbtUpDown;
//STRIP001 	RadioButton	aRbtDownUp;
//STRIP001 	RadioButton	aRbtAutoOrder;
//STRIP001 	FixedLine	aFlOrder;
//STRIP001 	OrderMode	eOrderMode;
//STRIP001 
//STRIP001 	const SfxItemSet&	rOutAttrs;
//STRIP001 
//STRIP001 	DECL_LINK(CheckButtonHdl, Button*);
//STRIP001 	BOOL bTextCanOverlap;
//STRIP001 public:
//STRIP001 	SchAlignmentTabPage(Window* pParent, const SfxItemSet& rInAttrs);
//STRIP001 	virtual ~SchAlignmentTabPage();
//STRIP001 
//STRIP001 	static SfxTabPage* Create(Window* pParent, const SfxItemSet& rInAttrs);
//STRIP001 	virtual BOOL FillItemSet(SfxItemSet& rOutAttrs);
//STRIP001 	virtual void Reset(const SfxItemSet& rInAttrs);
//STRIP001 
//STRIP001 	void SetOrderMode(OrderMode eMode);
//STRIP001 	void SetTextCanOverlap(BOOL b){bTextCanOverlap=b;}
//STRIP001 };

} //namespace binfilter
#endif	// _SCH_ATTRIB_HXX

