/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_tpoption.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:04:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _COM_SUN_STAR_DOCUMENT_PRINTERINDEPENDENTLAYOUT_HPP_
#include <com/sun/star/document/PrinterIndependentLayout.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDESKTOP_HPP_
#include <com/sun/star/frame/XDesktop.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XENUMERATIONACCESS_HPP_
#include <com/sun/star/container/XEnumerationAccess.hpp>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_EXCEPTION_HPP_
#include <com/sun/star/uno/Exception.hpp>
#endif
#ifndef _SFXMODULE_HXX //autogen
#include <bf_sfx2/module.hxx>
#endif
#include <bf_sfx2/app.hxx>
#include <bf_svx/svxids.hrc>
#include <bf_svx/dialogs.hrc>
#include <bf_svx/strarray.hxx>
#include <bf_svx/dlgutil.hxx>

#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#include "sdattr.hxx"
#include "sdresid.hxx"
#include "optsitem.hxx"
#include "tpoption.hrc"
#include "tpoption.hxx"
#include "strings.hrc"
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
#define DLGWIN this->GetParent()->GetParent()
namespace binfilter {

using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;

/*************************************************************************
|*
|*	TabPage zum Einstellen der Fang-Optionen
|*
\************************************************************************/

//STRIP001 SdTpOptionsSnap::SdTpOptionsSnap( Window* pParent, const SfxItemSet& rInAttrs  ) :
//STRIP001         SvxGridTabPage(pParent, rInAttrs)
//STRIP001 {
//STRIP001     aGrpSnap.Show();
//STRIP001     aCbxSnapHelplines.Show();
//STRIP001     aCbxSnapBorder.Show();
//STRIP001     aCbxSnapFrame.Show();
//STRIP001     aCbxSnapPoints.Show();
//STRIP001     aFtSnapArea.Show();
//STRIP001     aMtrFldSnapArea.Show();
//STRIP001     aGrpOrtho.Show();
//STRIP001     aCbxOrtho.Show();
//STRIP001     aCbxBigOrtho.Show();
//STRIP001     aCbxRotate.Show();
//STRIP001     aMtrFldAngle.Show();
//STRIP001     aFtBezAngle.Show();
//STRIP001     aMtrFldBezAngle.Show();
//STRIP001     aSeparatorFL.Show();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SdTpOptionsSnap::~SdTpOptionsSnap()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SdTpOptionsSnap::FillItemSet( SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001     SvxGridTabPage::FillItemSet(rAttrs);
//STRIP001     SdOptionsSnapItem* pOptsItem = NULL;
//STRIP001 //    if(SFX_ITEM_SET != rAttrs.GetItemState( ATTR_OPTIONS_SNAP, FALSE, (const SfxPoolItem**)&pOptsItem ))
//STRIP001 //        pExampleSet->GetItemState( ATTR_OPTIONS_SNAP, FALSE, (const SfxPoolItem**)&pOptsItem );
//STRIP001 
//STRIP001 	SdOptionsSnapItem aOptsItem( ATTR_OPTIONS_SNAP );
//STRIP001 
//STRIP001 	aOptsItem.SetSnapHelplines( aCbxSnapHelplines.IsChecked() );
//STRIP001 	aOptsItem.SetSnapBorder( aCbxSnapBorder.IsChecked() );
//STRIP001 	aOptsItem.SetSnapFrame( aCbxSnapFrame.IsChecked() );
//STRIP001 	aOptsItem.SetSnapPoints( aCbxSnapPoints.IsChecked() );
//STRIP001 	aOptsItem.SetOrtho( aCbxOrtho.IsChecked() );
//STRIP001 	aOptsItem.SetBigOrtho( aCbxBigOrtho.IsChecked() );
//STRIP001 	aOptsItem.SetRotate( aCbxRotate.IsChecked() );
//STRIP001 	aOptsItem.SetSnapArea( (INT16) aMtrFldSnapArea.GetValue() );
//STRIP001 	aOptsItem.SetAngle( (INT16) aMtrFldAngle.GetValue() );
//STRIP001 	aOptsItem.SetEliminatePolyPointLimitAngle( (INT16) aMtrFldBezAngle.GetValue() );
//STRIP001 
//STRIP001 	if( pOptsItem == NULL || !(aOptsItem == *pOptsItem) )
//STRIP001 		rAttrs.Put( aOptsItem );
//STRIP001 
//STRIP001 	// Evtl. vorhandenes GridItem wird geholt, um nicht versehentlich
//STRIP001 	// irgendwelche Standardwerte einzustellen
//STRIP001 	const SfxPoolItem* pAttr = NULL;
//STRIP001 	return( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdTpOptionsSnap::Reset( const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001     SvxGridTabPage::Reset(rAttrs);
//STRIP001 
//STRIP001 	SdOptionsSnapItem aOptsItem( (const SdOptionsSnapItem&) rAttrs.
//STRIP001 						Get( ATTR_OPTIONS_SNAP ) );
//STRIP001 
//STRIP001 	aCbxSnapHelplines.Check( aOptsItem.IsSnapHelplines() );
//STRIP001 	aCbxSnapBorder.Check( aOptsItem.IsSnapBorder() );
//STRIP001 	aCbxSnapFrame.Check( aOptsItem.IsSnapFrame() );
//STRIP001 	aCbxSnapPoints.Check( aOptsItem.IsSnapPoints() );
//STRIP001 	aCbxOrtho.Check( aOptsItem.IsOrtho() );
//STRIP001 	aCbxBigOrtho.Check( aOptsItem.IsBigOrtho() );
//STRIP001 	aCbxRotate.Check( aOptsItem.IsRotate() );
//STRIP001 	aMtrFldSnapArea.SetValue( aOptsItem.GetSnapArea() );
//STRIP001 	aMtrFldAngle.SetValue( aOptsItem.GetAngle() );
//STRIP001 	aMtrFldBezAngle.SetValue( aOptsItem.GetEliminatePolyPointLimitAngle() );
//STRIP001 
//STRIP001     aCbxRotate.GetClickHdl().Call(0);
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SdTpOptionsSnap::Create( Window* pWindow,
//STRIP001 				const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	return( new SdTpOptionsSnap( pWindow, rAttrs ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	TabPage zum Einstellen der Inhalte-Optionen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SdTpOptionsContents::SdTpOptionsContents( Window* pParent, const SfxItemSet& rInAttrs  ) :
//STRIP001 		SfxTabPage          ( pParent, SdResId( TP_OPTIONS_CONTENTS ), rInAttrs ),
//STRIP001 		aCbxExternGraphic   ( this, SdResId( CBX_EXTERN_GRAPHIC ) ),
//STRIP001 		aCbxOutlineMode     ( this, SdResId( CBX_OUTLINEMODE ) ),
//STRIP001 		aCbxNoText          ( this, SdResId( CBX_NOTEXT ) ),
//STRIP001 		aCbxHairlineMode    ( this, SdResId( CBX_HAIRLINEMODE ) ),
//STRIP001 		aGrpViewSubstitute  ( this, SdResId( GRP_VIEW_SUBSTITUTE ) ),
//STRIP001         aCbxRuler           ( this, SdResId( CBX_RULER ) ),
//STRIP001 		aCbxMoveOutline     ( this, SdResId( CBX_MOVE_OUTLINE ) ),
//STRIP001 		aCbxDragStripes     ( this, SdResId( CBX_HELPLINES ) ),
//STRIP001 		aCbxHandlesBezier   ( this, SdResId( CBX_HANDLES_BEZIER ) ),
//STRIP001         aGrpDisplay         ( this, SdResId( GRP_DISPLAY ) )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SdTpOptionsContents::~SdTpOptionsContents()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SdTpOptionsContents::FillItemSet( SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 
//STRIP001 	if( aCbxExternGraphic.GetSavedValue() 	!= aCbxExternGraphic.IsChecked() ||
//STRIP001 		aCbxOutlineMode.GetSavedValue()		!= aCbxOutlineMode.IsChecked() ||
//STRIP001 		aCbxNoText.GetSavedValue()			!= aCbxNoText.IsChecked() ||
//STRIP001 		aCbxHairlineMode.GetSavedValue()	!= aCbxHairlineMode.IsChecked() )
//STRIP001 	{
//STRIP001 		SdOptionsContentsItem aOptsItem( ATTR_OPTIONS_CONTENTS );
//STRIP001 
//STRIP001 		aOptsItem.SetExternGraphic( aCbxExternGraphic.IsChecked() );
//STRIP001 		aOptsItem.SetOutlineMode( aCbxOutlineMode.IsChecked() );
//STRIP001 		aOptsItem.SetNoText( aCbxNoText.IsChecked() );
//STRIP001 		aOptsItem.SetHairlineMode( aCbxHairlineMode.IsChecked() );
//STRIP001 
//STRIP001 		rAttrs.Put( aOptsItem );
//STRIP001 
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001     if( aCbxRuler.GetSavedValue()           != aCbxRuler.IsChecked() ||
//STRIP001 		aCbxMoveOutline.GetSavedValue()		!= aCbxMoveOutline.IsChecked() ||
//STRIP001 		aCbxDragStripes.GetSavedValue()		!= aCbxDragStripes.IsChecked() ||
//STRIP001 		//aCbxHelplines.GetSavedValue()		!= aCbxHelplines.IsChecked() ||
//STRIP001 		aCbxHandlesBezier.GetSavedValue()	!= aCbxHandlesBezier.IsChecked() )
//STRIP001 	{
//STRIP001         SdOptionsLayoutItem aOptsItem( ATTR_OPTIONS_LAYOUT );
//STRIP001 
//STRIP001         aOptsItem.SetRulerVisible( aCbxRuler.IsChecked() );
//STRIP001         aOptsItem.SetMoveOutline( aCbxMoveOutline.IsChecked() );
//STRIP001         aOptsItem.SetDragStripes( aCbxDragStripes.IsChecked() );
//STRIP001         aOptsItem.SetHandlesBezier( aCbxHandlesBezier.IsChecked() );
//STRIP001         //aOptsItem.SetHelplines( aCbxHelplines.IsChecked() );
//STRIP001 
//STRIP001         rAttrs.Put( aOptsItem );
//STRIP001         bModified = TRUE;
//STRIP001 	}
//STRIP001     return( bModified );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdTpOptionsContents::Reset( const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	SdOptionsContentsItem aOptsItem( (const SdOptionsContentsItem&) rAttrs.
//STRIP001 						Get( ATTR_OPTIONS_CONTENTS ) );
//STRIP001 
//STRIP001 	aCbxExternGraphic.Check( aOptsItem.IsExternGraphic() );
//STRIP001 	aCbxOutlineMode.Check(aOptsItem.IsOutlineMode() );
//STRIP001 	aCbxNoText.Check( aOptsItem.IsNoText() );
//STRIP001 	aCbxHairlineMode.Check( aOptsItem.IsHairlineMode() );
//STRIP001 
//STRIP001 	aCbxExternGraphic.SaveValue();
//STRIP001 	aCbxOutlineMode.SaveValue();
//STRIP001 	aCbxNoText.SaveValue();
//STRIP001 	aCbxHairlineMode.SaveValue();
//STRIP001 
//STRIP001     SdOptionsLayoutItem aLayoutItem( (const SdOptionsLayoutItem&) rAttrs.
//STRIP001 						Get( ATTR_OPTIONS_LAYOUT ) );
//STRIP001 
//STRIP001     aCbxRuler.Check( aLayoutItem.IsRulerVisible() );
//STRIP001     aCbxMoveOutline.Check( aLayoutItem.IsMoveOutline() );
//STRIP001     aCbxDragStripes.Check( aLayoutItem.IsDragStripes() );
//STRIP001     aCbxHandlesBezier.Check( aLayoutItem.IsHandlesBezier() );
//STRIP001     //aCbxHelplines.Check( aLayoutItem.IsHelplines() );
//STRIP001 
//STRIP001 	aCbxRuler.SaveValue();
//STRIP001 	aCbxMoveOutline.SaveValue();
//STRIP001 	aCbxDragStripes.SaveValue();
//STRIP001 	aCbxHandlesBezier.SaveValue();
//STRIP001 	//aCbxHelplines.SaveValue();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SdTpOptionsContents::Create( Window* pWindow,
//STRIP001 				const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	return( new SdTpOptionsContents( pWindow, rAttrs ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*	TabPage zum Einstellen der Sonstige-Optionen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 #define TABLE_COUNT 12
//STRIP001 #define TOKEN (sal_Unicode(':'))
//STRIP001 
//STRIP001 SdTpOptionsMisc::SdTpOptionsMisc( Window* pParent, const SfxItemSet& rInAttrs  ) :
//STRIP001 		SfxTabPage          ( pParent, SdResId( TP_OPTIONS_MISC ), rInAttrs ),
//STRIP001 	aCbxQuickEdit               ( this, SdResId( CBX_QUICKEDIT ) ),
//STRIP001 	aCbxPickThrough             ( this, SdResId( CBX_PICKTHROUGH ) ),
//STRIP001 	aGrpText                    ( this, SdResId( GRP_TEXT ) ),
//STRIP001 
//STRIP001 	// Template & Layout laufen z.Z. synchron!
//STRIP001 	aCbxStartWithTemplate       ( this, SdResId( CBX_START_WITH_TEMPLATE ) ),
//STRIP001 	aGrpProgramStart            ( this, SdResId( GRP_PROGRAMSTART ) ),
//STRIP001 
//STRIP001 	aCbxMasterPageCache         ( this, SdResId( CBX_MASTERPAGE_CACHE ) ),
//STRIP001 
//STRIP001 	aCbxCopy                    ( this, SdResId( CBX_COPY ) ),
//STRIP001 	aCbxMarkedHitMovesAlways    ( this, SdResId( CBX_MARKED_HIT_MOVES_ALWAYS ) ),
//STRIP001 	aCbxCrookNoContortion       ( this, SdResId( CBX_CROOK_NO_CONTORTION ) ),
//STRIP001     aGrpSettings                ( this, SdResId( GRP_SETTINGS ) ),
//STRIP001 
//STRIP001     aTxtMetric                  ( this, SdResId( FT_METRIC ) ),
//STRIP001     aLbMetric                   ( this, SdResId( LB_METRIC ) ),
//STRIP001     aTxtTabstop                 ( this, SdResId( FT_TABSTOP ) ),
//STRIP001     aMtrFldTabstop              ( this, SdResId( MTR_FLD_TABSTOP ) ),
//STRIP001 
//STRIP001 	aCbxStartWithActualPage		( this, SdResId( CBX_START_WITH_ACTUAL_PAGE ) ),
//STRIP001 	aGrpStartWithActualPage     ( this, SdResId( GRP_START_WITH_ACTUAL_PAGE ) ),
//STRIP001 	aTxtCompatibility			( this, SdResId( FT_COMPATIBILITY ) ),
//STRIP001     aCbxUsePrinterMetrics       ( this, SdResId( CB_USE_PRINTER_METRICS ) ),
//STRIP001     aCbxCompatibility           ( this, SdResId( CB_MERGE_PARA_DIST ) ),
//STRIP001     aGrpScale                   ( this, SdResId( GRP_SCALE ) ),
//STRIP001     aFtScale                    ( this, SdResId( FT_SCALE ) ),
//STRIP001     aCbScale                    ( this, SdResId( CB_SCALE ) ),
//STRIP001     aFtOriginal                 ( this, SdResId( FT_ORIGINAL ) ),
//STRIP001     aFtEquivalent               ( this, SdResId( FT_EQUIVALENT ) ),
//STRIP001     aFtPageWidth                ( this, SdResId( FT_PAGEWIDTH ) ),
//STRIP001     aFiInfo1                    ( this, SdResId( FI_INFO_1 ) ),
//STRIP001     aMtrFldOriginalWidth        ( this, SdResId( MTR_FLD_ORIGINAL_WIDTH ) ),
//STRIP001     aFtPageHeight               ( this, SdResId( FT_PAGEHEIGHT ) ),
//STRIP001     aFiInfo2                    ( this, SdResId( FI_INFO_2 ) ),
//STRIP001     aMtrFldOriginalHeight       ( this, SdResId( MTR_FLD_ORIGINAL_HEIGHT ) ),
//STRIP001     aMtrFldInfo1                ( this, WinBits( WB_HIDE ) ),
//STRIP001     aMtrFldInfo2                ( this, WinBits( WB_HIDE ) )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001     SetExchangeSupport();
//STRIP001 
//STRIP001     // Metrik einstellen
//STRIP001 	FieldUnit eFUnit;
//STRIP001 
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_METRIC );
//STRIP001 	if ( rInAttrs.GetItemState( nWhich ) >= SFX_ITEM_AVAILABLE )
//STRIP001 	{
//STRIP001 		const SfxUInt16Item& rItem = (SfxUInt16Item&)rInAttrs.Get( nWhich );
//STRIP001 		eFUnit = (FieldUnit)rItem.GetValue();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		eFUnit = GetModuleFieldUnit();
//STRIP001 
//STRIP001 	SetFieldUnit( aMtrFldTabstop, eFUnit );
//STRIP001 
//STRIP001 	// ListBox mit Metriken f"ullen
//STRIP001 	SvxStringArray aMetricArr( RID_SVXSTR_FIELDUNIT_TABLE );
//STRIP001 
//STRIP001 	for ( USHORT i = 0; i < aMetricArr.Count(); ++i )
//STRIP001 	{
//STRIP001 		String sMetric = aMetricArr.GetStringByPos( i );
//STRIP001 		long nFieldUnit = aMetricArr.GetValue( i );
//STRIP001 		USHORT nPos = aLbMetric.InsertEntry( sMetric );
//STRIP001 		aLbMetric.SetEntryData( nPos, (void*)nFieldUnit );
//STRIP001 	}
//STRIP001     aLbMetric.SetSelectHdl( LINK( this, SdTpOptionsMisc, SelectMetricHdl_Impl ) );
//STRIP001 
//STRIP001     SetFieldUnit( aMtrFldOriginalWidth, eFUnit );
//STRIP001 	SetFieldUnit( aMtrFldOriginalHeight, eFUnit );
//STRIP001 	aMtrFldOriginalWidth.SetLast( 999999999 );
//STRIP001 	aMtrFldOriginalWidth.SetMax( 999999999 );
//STRIP001 	aMtrFldOriginalHeight.SetLast( 999999999 );
//STRIP001 	aMtrFldOriginalHeight.SetMax( 999999999 );
//STRIP001 
//STRIP001 	// Temporaere Fields fuer Info-Texte (fuer Formatierung/Berechnung)
//STRIP001 	aMtrFldInfo1.SetUnit( eFUnit );
//STRIP001 	aMtrFldInfo1.SetMax( 999999999 );
//STRIP001 	aMtrFldInfo1.SetDecimalDigits( 2 );
//STRIP001 	aMtrFldInfo2.SetUnit( eFUnit );
//STRIP001 	aMtrFldInfo2.SetMax( 999999999 );
//STRIP001 	aMtrFldInfo2.SetDecimalDigits( 2 );
//STRIP001 
//STRIP001 	// PoolUnit ermitteln
//STRIP001     SfxItemPool* pPool = rInAttrs.GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool?" );
//STRIP001 	ePoolUnit = pPool->GetMetric( SID_ATTR_FILL_HATCH );
//STRIP001 
//STRIP001 	// Fuellen der CB
//STRIP001 	USHORT aTable[ TABLE_COUNT ] =
//STRIP001 		{ 1, 2, 4, 5, 8, 10, 16, 20, 30, 40, 50, 100 };
//STRIP001 
//STRIP001     for( i = 0; i < TABLE_COUNT; i++ )
//STRIP001 		aCbScale.InsertEntry( GetScale( 1, aTable[i] ) );
//STRIP001 	for( i = 1; i < TABLE_COUNT; i++ )
//STRIP001 		aCbScale.InsertEntry( GetScale(  aTable[i], 1 ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SdTpOptionsMisc::~SdTpOptionsMisc()
//STRIP001 {
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 void SdTpOptionsMisc::ActivatePage( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	// Hier muss noch einmal SaveValue gerufen werden, da sonst u.U.
//STRIP001 	// der Wert in anderen TabPages keine Wirkung hat
//STRIP001 	aLbMetric.SaveValue();
//STRIP001     // Metrik ggfs. aendern (da TabPage im Dialog liegt,
//STRIP001 	// wo die Metrik eingestellt werden kann
//STRIP001 	const SfxPoolItem* pAttr = NULL;
//STRIP001 	if( SFX_ITEM_SET == rSet.GetItemState( SID_ATTR_METRIC , FALSE,
//STRIP001 									(const SfxPoolItem**)&pAttr ))
//STRIP001 	{
//STRIP001 		const SfxUInt16Item* pItem = (SfxUInt16Item*) pAttr;
//STRIP001 
//STRIP001 		FieldUnit eFUnit = (FieldUnit)(long)pItem->GetValue();
//STRIP001 
//STRIP001 		if( eFUnit != aMtrFldOriginalWidth.GetUnit() )
//STRIP001 		{
//STRIP001 			// Metriken einstellen
//STRIP001 			long nVal = aMtrFldOriginalWidth.Denormalize( aMtrFldOriginalWidth.GetValue( FUNIT_TWIP ) );
//STRIP001 			SetFieldUnit( aMtrFldOriginalWidth, eFUnit, TRUE );
//STRIP001 			aMtrFldOriginalWidth.SetValue( aMtrFldOriginalWidth.Normalize( nVal ), FUNIT_TWIP );
//STRIP001 
//STRIP001 			nVal = aMtrFldOriginalHeight.Denormalize( aMtrFldOriginalHeight.GetValue( FUNIT_TWIP ) );
//STRIP001 			SetFieldUnit( aMtrFldOriginalHeight, eFUnit, TRUE );
//STRIP001 			aMtrFldOriginalHeight.SetValue( aMtrFldOriginalHeight.Normalize( nVal ), FUNIT_TWIP );
//STRIP001 
//STRIP001 
//STRIP001 			if( nWidth != 0 && nHeight != 0 )
//STRIP001 			{
//STRIP001 				aMtrFldInfo1.SetUnit( eFUnit );
//STRIP001 				aMtrFldInfo2.SetUnit( eFUnit );
//STRIP001 
//STRIP001 				SetMetricValue( aMtrFldInfo1, nWidth, ePoolUnit );
//STRIP001 				aInfo1 = aMtrFldInfo1.GetText();
//STRIP001 				aFiInfo1.SetText( aInfo1 );
//STRIP001 
//STRIP001 				SetMetricValue( aMtrFldInfo2, nHeight, ePoolUnit );
//STRIP001 				aInfo2 = aMtrFldInfo2.GetText();
//STRIP001 				aFiInfo2.SetText( aInfo2 );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SdTpOptionsMisc::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001     // Parsercheck
//STRIP001 	INT32 nX, nY;
//STRIP001 	if( SetScale( aCbScale.GetText(), nX, nY ) )
//STRIP001 	{
//STRIP001 		if( pSet )
//STRIP001 			FillItemSet( *pSet );
//STRIP001         return( LEAVE_PAGE );
//STRIP001     }
//STRIP001 	WarningBox aWarnBox( GetParent(), WB_YES_NO, String( SdResId( STR_WARN_SCALE_FAIL ) ) );
//STRIP001 	short nReturn = aWarnBox.Execute();
//STRIP001 
//STRIP001 	if( nReturn == RET_YES )
//STRIP001 		return( KEEP_PAGE );
//STRIP001 
//STRIP001 	if( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 
//STRIP001 	return( LEAVE_PAGE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SdTpOptionsMisc::FillItemSet( SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 
//STRIP001 	if( aCbxStartWithTemplate.GetSavedValue() 	!= aCbxStartWithTemplate.IsChecked() ||
//STRIP001 		aCbxMarkedHitMovesAlways.GetSavedValue()!= aCbxMarkedHitMovesAlways.IsChecked() ||
//STRIP001 		aCbxCrookNoContortion.GetSavedValue() 	!= aCbxCrookNoContortion.IsChecked() ||
//STRIP001 		aCbxQuickEdit.GetSavedValue() 			!= aCbxQuickEdit.IsChecked() ||
//STRIP001 		aCbxPickThrough.GetSavedValue() 		!= aCbxPickThrough.IsChecked() ||
//STRIP001 		aCbxMasterPageCache.GetSavedValue() 	!= aCbxMasterPageCache.IsChecked() ||
//STRIP001 		aCbxCopy.GetSavedValue() 				!= aCbxCopy.IsChecked() ||
//STRIP001 		aCbxStartWithActualPage.GetSavedValue() != aCbxStartWithActualPage.IsChecked() ||
//STRIP001 		aCbxCompatibility.GetSavedValue()		!= aCbxCompatibility.IsChecked() ||
//STRIP001 		aCbxUsePrinterMetrics.GetSavedValue()   != aCbxUsePrinterMetrics.IsChecked() )
//STRIP001 	{
//STRIP001 		SdOptionsMiscItem aOptsItem( ATTR_OPTIONS_MISC );
//STRIP001 
//STRIP001 		aOptsItem.SetStartWithTemplate( aCbxStartWithTemplate.IsChecked() );
//STRIP001 		aOptsItem.SetMarkedHitMovesAlways( aCbxMarkedHitMovesAlways.IsChecked() );
//STRIP001 		aOptsItem.SetCrookNoContortion( aCbxCrookNoContortion.IsChecked() );
//STRIP001 		aOptsItem.SetQuickEdit( aCbxQuickEdit.IsChecked() );
//STRIP001 		aOptsItem.SetPickThrough( aCbxPickThrough.IsChecked() );
//STRIP001 		aOptsItem.SetMasterPagePaintCaching( aCbxMasterPageCache.IsChecked() );
//STRIP001 		aOptsItem.SetDragWithCopy( aCbxCopy.IsChecked() );
//STRIP001 		aOptsItem.SetStartWithActualPage( aCbxStartWithActualPage.IsChecked() );
//STRIP001         aOptsItem.SetSummationOfParagraphs( aCbxCompatibility.IsChecked() );
//STRIP001         aOptsItem.SetPrinterIndependentLayout (
//STRIP001             aCbxUsePrinterMetrics.IsChecked() 
//STRIP001             ? ::com::sun::star::document::PrinterIndependentLayout::DISABLED
//STRIP001             : ::com::sun::star::document::PrinterIndependentLayout::ENABLED);
//STRIP001 		rAttrs.Put( aOptsItem );
//STRIP001 
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Metrik
//STRIP001 	const USHORT nMPos = aLbMetric.GetSelectEntryPos();
//STRIP001 	if ( nMPos != aLbMetric.GetSavedValue() )
//STRIP001 	{
//STRIP001 		USHORT nFieldUnit = (USHORT)(long)aLbMetric.GetEntryData( nMPos );
//STRIP001 		rAttrs.Put( SfxUInt16Item( GetWhich( SID_ATTR_METRIC ),
//STRIP001 									 (UINT16)nFieldUnit ) );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Tabulatorabstand
//STRIP001 	if( aMtrFldTabstop.GetText() != aMtrFldTabstop.GetSavedValue() )
//STRIP001 	{
//STRIP001 		USHORT nWh = GetWhich( SID_ATTR_DEFTABSTOP );
//STRIP001 		SfxMapUnit eUnit = rAttrs.GetPool()->GetMetric( nWh );
//STRIP001 		SfxUInt16Item aDef( nWh,(USHORT)GetCoreValue( aMtrFldTabstop, eUnit ) );
//STRIP001 		rAttrs.Put( aDef );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	INT32 nX, nY;
//STRIP001 	if( SetScale( aCbScale.GetText(), nX, nY ) )
//STRIP001 	{
//STRIP001 		rAttrs.Put( SfxInt32Item( ATTR_OPTIONS_SCALE_X, nX ) );
//STRIP001 		rAttrs.Put( SfxInt32Item( ATTR_OPTIONS_SCALE_Y, nY ) );
//STRIP001 
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001     return( bModified );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdTpOptionsMisc::Reset( const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	SdOptionsMiscItem aOptsItem( (const SdOptionsMiscItem&) rAttrs.
//STRIP001 						Get( ATTR_OPTIONS_MISC ) );
//STRIP001 
//STRIP001 	aCbxStartWithTemplate.Check( aOptsItem.IsStartWithTemplate() );
//STRIP001 	aCbxMarkedHitMovesAlways.Check( aOptsItem.IsMarkedHitMovesAlways() );
//STRIP001 	aCbxCrookNoContortion.Check( aOptsItem.IsCrookNoContortion() );
//STRIP001 	aCbxQuickEdit.Check( aOptsItem.IsQuickEdit() );
//STRIP001 	aCbxPickThrough.Check( aOptsItem.IsPickThrough() );
//STRIP001 	aCbxMasterPageCache.Check( aOptsItem.IsMasterPagePaintCaching() );
//STRIP001 	aCbxCopy.Check( aOptsItem.IsDragWithCopy() );
//STRIP001 	aCbxStartWithActualPage.Check( aOptsItem.IsStartWithActualPage() );
//STRIP001 #if SUPD>627
//STRIP001     aCbxCompatibility.Check( aOptsItem.IsSummationOfParagraphs() );
//STRIP001     aCbxUsePrinterMetrics.Check( aOptsItem.GetPrinterIndependentLayout()==1 );
//STRIP001 #endif
//STRIP001 	aCbxStartWithTemplate.SaveValue();
//STRIP001 	aCbxMarkedHitMovesAlways.SaveValue();
//STRIP001 	aCbxCrookNoContortion.SaveValue();
//STRIP001 	aCbxQuickEdit.SaveValue();
//STRIP001 	aCbxPickThrough.SaveValue();
//STRIP001 
//STRIP001 	aCbxMasterPageCache.SaveValue();
//STRIP001 	aCbxCopy.SaveValue();
//STRIP001 	aCbxStartWithActualPage.SaveValue();
//STRIP001 	aCbxCompatibility.SaveValue();
//STRIP001 	aCbxUsePrinterMetrics.SaveValue();
//STRIP001 
//STRIP001     // Metrik
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_METRIC );
//STRIP001 	aLbMetric.SetNoSelection();
//STRIP001 
//STRIP001 	if ( rAttrs.GetItemState( nWhich ) >= SFX_ITEM_AVAILABLE )
//STRIP001 	{
//STRIP001 		const SfxUInt16Item& rItem = (SfxUInt16Item&)rAttrs.Get( nWhich );
//STRIP001 		long nFieldUnit = (long)rItem.GetValue();
//STRIP001 
//STRIP001 		for ( USHORT i = 0; i < aLbMetric.GetEntryCount(); ++i )
//STRIP001 		{
//STRIP001 			if ( (long)aLbMetric.GetEntryData( i ) == nFieldUnit )
//STRIP001 			{
//STRIP001 				aLbMetric.SelectEntryPos( i );
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Tabulatorabstand
//STRIP001 	nWhich = GetWhich( SID_ATTR_DEFTABSTOP );
//STRIP001 	if( rAttrs.GetItemState( nWhich ) >= SFX_ITEM_AVAILABLE )
//STRIP001 	{
//STRIP001 		SfxMapUnit eUnit = rAttrs.GetPool()->GetMetric( nWhich );
//STRIP001 		const SfxUInt16Item& rItem = (SfxUInt16Item&)rAttrs.Get( nWhich );
//STRIP001 		SetMetricValue( aMtrFldTabstop, rItem.GetValue(), eUnit );
//STRIP001 	}
//STRIP001 	aLbMetric.SaveValue();
//STRIP001 	aMtrFldTabstop.SaveValue();
//STRIP001     //Scale
//STRIP001     INT32 nX = ( (const SfxInt32Item&) rAttrs.
//STRIP001 				 Get( ATTR_OPTIONS_SCALE_X ) ).GetValue();
//STRIP001 	INT32 nY = ( (const SfxInt32Item&) rAttrs.
//STRIP001 				 Get( ATTR_OPTIONS_SCALE_Y ) ).GetValue();
//STRIP001 	nWidth = ( (const SfxUInt32Item&) rAttrs.
//STRIP001 					Get( ATTR_OPTIONS_SCALE_WIDTH ) ).GetValue();
//STRIP001 	nHeight = ( (const SfxUInt32Item&) rAttrs.
//STRIP001 					Get( ATTR_OPTIONS_SCALE_HEIGHT ) ).GetValue();
//STRIP001 
//STRIP001 	aCbScale.SetText( GetScale( nX, nY ) );
//STRIP001 
//STRIP001     // #92067# broken feature disabled for 6.0
//STRIP001     aFtOriginal.Hide();
//STRIP001     aFtEquivalent.Hide();
//STRIP001     aMtrFldOriginalWidth.Hide();
//STRIP001     aMtrFldOriginalWidth.SetText( aInfo1 ); // leer
//STRIP001     aMtrFldOriginalHeight.Hide();
//STRIP001     aMtrFldOriginalHeight.SetText( aInfo2 ); //leer
//STRIP001     aFtPageWidth.Hide();
//STRIP001     aFtPageHeight.Hide();
//STRIP001     aFiInfo1.Hide();
//STRIP001     aFiInfo2.Hide();
//STRIP001 
//STRIP001     UpdateCompatibilityControls ();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SdTpOptionsMisc::Create( Window* pWindow,
//STRIP001 				const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	return( new SdTpOptionsMisc( pWindow, rAttrs ) );
//STRIP001 }
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdTpOptionsMisc, SelectMetricHdl_Impl, ListBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	USHORT nPos = aLbMetric.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		FieldUnit eUnit = (FieldUnit)(long)aLbMetric.GetEntryData( nPos );
//STRIP001 		long nVal =
//STRIP001 			aMtrFldTabstop.Denormalize( aMtrFldTabstop.GetValue( FUNIT_TWIP ) );
//STRIP001 		SetFieldUnit( aMtrFldTabstop, eUnit );
//STRIP001 		aMtrFldTabstop.SetValue( aMtrFldTabstop.Normalize( nVal ), FUNIT_TWIP );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }


namespace {
//STRIP001 void lcl_MoveWin( Window& rWin, long nYDiff)
//STRIP001 {
//STRIP001     Point aPos(rWin.GetPosPixel());
//STRIP001     aPos.Y() += nYDiff;
//STRIP001     rWin.SetPosPixel (aPos);
//STRIP001 }

//STRIP001 void lcl_MoveWin( Window& rWin, long nXdiff, long nYdiff)
//STRIP001 {
//STRIP001     Point aPos(rWin.GetPosPixel());
//STRIP001     aPos.X() += nXdiff;
//STRIP001     aPos.Y() += nYdiff;
//STRIP001     rWin.SetPosPixel(aPos);
//STRIP001 }
}

//STRIP001 void SdTpOptionsMisc::SetImpressMode (void)
//STRIP001 {
//STRIP001     long nDialogWidth = GetSizePixel().Width();
//STRIP001     long nLineHeight = aCbxPickThrough.GetPosPixel().Y()
//STRIP001         - aCbxQuickEdit.GetPosPixel().Y();
//STRIP001 
//STRIP001     // Put both "Text objects" check boxes side by side.
//STRIP001     lcl_MoveWin (aCbxPickThrough, 
//STRIP001         nDialogWidth/2 - aCbxPickThrough.GetPosPixel().X(),
//STRIP001         -nLineHeight);
//STRIP001 
//STRIP001     // Move the other controls up one line.
//STRIP001     lcl_MoveWin (aGrpProgramStart, -nLineHeight);
//STRIP001     lcl_MoveWin (aCbxStartWithTemplate, -nLineHeight);
//STRIP001     lcl_MoveWin (aGrpSettings, -nLineHeight);
//STRIP001     lcl_MoveWin (aCbxMasterPageCache, -nLineHeight);
//STRIP001     lcl_MoveWin (aCbxCopy, -nLineHeight);
//STRIP001     lcl_MoveWin (aCbxMarkedHitMovesAlways, -nLineHeight);
//STRIP001     lcl_MoveWin (aCbxCrookNoContortion, -nLineHeight);
//STRIP001     lcl_MoveWin (aTxtMetric, -nLineHeight);
//STRIP001     lcl_MoveWin (aLbMetric, -nLineHeight);
//STRIP001     lcl_MoveWin (aTxtTabstop, -nLineHeight);
//STRIP001     lcl_MoveWin (aMtrFldTabstop, -nLineHeight);
//STRIP001     lcl_MoveWin (aGrpStartWithActualPage, -nLineHeight);
//STRIP001     lcl_MoveWin (aCbxStartWithActualPage, -nLineHeight);
//STRIP001     lcl_MoveWin (aTxtCompatibility, -nLineHeight);
//STRIP001 
//STRIP001     // Move the printer-independent-metrics check box up two lines to change
//STRIP001     // places with spacing-between-paragraphs check box.
//STRIP001     lcl_MoveWin (aCbxUsePrinterMetrics, -2*nLineHeight);
//STRIP001 }

//STRIP001 void    SdTpOptionsMisc::SetDrawMode()
//STRIP001 {
//STRIP001     aCbxStartWithTemplate.Hide();
//STRIP001     aGrpProgramStart.Hide();
//STRIP001     aCbxStartWithActualPage.Hide();
//STRIP001 	aCbxCompatibility.Hide();
//STRIP001     aGrpStartWithActualPage.Hide();
//STRIP001     aCbxCrookNoContortion.Show();
//STRIP001 
//STRIP001     aGrpScale.Show();
//STRIP001     aFtScale.Show();
//STRIP001     aCbScale.Show();
//STRIP001 
//STRIP001     aFtOriginal.Show();
//STRIP001     aFtEquivalent.Show();
//STRIP001 
//STRIP001     aFtPageWidth.Show();
//STRIP001     aFiInfo1.Show();
//STRIP001     aMtrFldOriginalWidth.Show();
//STRIP001 
//STRIP001     aFtPageHeight.Show();
//STRIP001     aFiInfo2.Show();
//STRIP001     aMtrFldOriginalHeight.Show();
//STRIP001 
//STRIP001     long nDiff = aGrpSettings.GetPosPixel().Y() - aGrpProgramStart.GetPosPixel().Y();
//STRIP001     lcl_MoveWin( aGrpSettings, -nDiff );
//STRIP001     lcl_MoveWin( aCbxMasterPageCache, -nDiff );
//STRIP001     lcl_MoveWin( aCbxCopy, -nDiff );
//STRIP001     lcl_MoveWin( aCbxMarkedHitMovesAlways, -nDiff );
//STRIP001     lcl_MoveWin( aCbxCrookNoContortion, -nDiff );
//STRIP001     nDiff -= aCbxCrookNoContortion.GetPosPixel().Y() - aCbxMarkedHitMovesAlways.GetPosPixel().Y();
//STRIP001     lcl_MoveWin( aTxtMetric, -nDiff );
//STRIP001     lcl_MoveWin( aLbMetric, -nDiff );
//STRIP001     lcl_MoveWin( aTxtTabstop, -nDiff );
//STRIP001     lcl_MoveWin( aMtrFldTabstop, -nDiff );
//STRIP001 
//STRIP001     // Move the scale controls so that they are visually centered betwen the
//STRIP001     // group controls above and below.
//STRIP001     lcl_MoveWin (aFtScale, -17);
//STRIP001     lcl_MoveWin (aCbScale, -17);
//STRIP001 
//STRIP001     // Move the printer-independent-metrics check box in the place that the
//STRIP001     // spacing-between-paragraphs check box normally is in.
//STRIP001     aCbxUsePrinterMetrics.SetPosPixel (aCbxCompatibility.GetPosPixel());
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdTpOptionsMisc, ModifyScaleHdl, void *, p )
//STRIP001 {
//STRIP001 	// Originalgroesse berechnen
//STRIP001 	INT32 nX, nY;
//STRIP001 	if( SetScale( aCbScale.GetText(), nX, nY ) )
//STRIP001 	{
//STRIP001 		INT32 nW = nWidth * nY / nX;
//STRIP001 		INT32 nH = nHeight * nY / nX;
//STRIP001 
//STRIP001 		SetMetricValue( aMtrFldOriginalWidth, nW, ePoolUnit );
//STRIP001 		SetMetricValue( aMtrFldOriginalHeight, nH, ePoolUnit );
//STRIP001 	}
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdTpOptionsMisc, ModifyOriginalScaleHdl, void *, p )
//STRIP001 {
//STRIP001 	// Berechnen des Massstabs
//STRIP001 	long nOrgW = aMtrFldOriginalWidth.GetValue();
//STRIP001 	long nOrgH = aMtrFldOriginalHeight.GetValue();
//STRIP001 
//STRIP001 	if( nOrgW == 0 || nOrgH == 0 )
//STRIP001 		return( 0L );
//STRIP001 
//STRIP001 	Fraction aFract1( nOrgW, aMtrFldInfo1.GetValue() );
//STRIP001 	Fraction aFract2( nOrgH, aMtrFldInfo2.GetValue() );
//STRIP001 	Fraction aFract( aFract1 > aFract2 ? aFract1 : aFract2 );
//STRIP001 
//STRIP001 	long nValue;
//STRIP001 	if( aFract < Fraction( 1, 1 ) )
//STRIP001 	{
//STRIP001 		// Fraction umdrehen
//STRIP001 		aFract1 = aFract;
//STRIP001 		aFract = Fraction( aFract1.GetDenominator(), aFract1.GetNumerator() );
//STRIP001 		nValue = aFract;
//STRIP001 
//STRIP001         // #92067# Swap nominator and denominator
//STRIP001 		aCbScale.SetText( GetScale( nValue, 1 ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		double fValue = aFract;
//STRIP001 		nValue = aFract;
//STRIP001 		if( fValue > (double)nValue )
//STRIP001 			nValue++;
//STRIP001 
//STRIP001         // #92067# Swap nominator and denominator
//STRIP001 		aCbScale.SetText( GetScale( 1, nValue ) );
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 String SdTpOptionsMisc::GetScale( INT32 nX, INT32 nY )
//STRIP001 {
//STRIP001 	String aScale( UniString::CreateFromInt32( nX ) );
//STRIP001 	aScale.Append( TOKEN );
//STRIP001 	aScale.Append( UniString::CreateFromInt32( nY ) );
//STRIP001 
//STRIP001 	return( aScale );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SdTpOptionsMisc::SetScale( const String& aScale, INT32& rX, INT32& rY )
//STRIP001 {
//STRIP001 	if( aScale.GetTokenCount( TOKEN ) != 2 )
//STRIP001 		return( FALSE );
//STRIP001 
//STRIP001 	ByteString aTmp( aScale.GetToken( 0, TOKEN ), RTL_TEXTENCODING_ASCII_US );
//STRIP001 	if( !aTmp.IsNumericAscii() )
//STRIP001 		return( FALSE );
//STRIP001 
//STRIP001 	rX = (long) aTmp.ToInt32();
//STRIP001 	if( rX == 0 )
//STRIP001 		return( FALSE );
//STRIP001 
//STRIP001 	aTmp = ByteString( aScale.GetToken( 1, TOKEN ), RTL_TEXTENCODING_ASCII_US );
//STRIP001 	if( !aTmp.IsNumericAscii() )
//STRIP001 		return( FALSE );
//STRIP001 
//STRIP001 	rY = (long) aTmp.ToInt32();
//STRIP001 	if( rY == 0 )
//STRIP001 		return( FALSE );
//STRIP001 
//STRIP001 	return( TRUE );
//STRIP001 }




//STRIP001 void SdTpOptionsMisc::UpdateCompatibilityControls (void)
//STRIP001 {
//STRIP001     // Disable the compatibility controls by default.  Enable them only when
//STRIP001     // there is at least one open document.
//STRIP001     sal_Bool bIsEnabled = sal_False;
//STRIP001 
//STRIP001     try
//STRIP001     {
//STRIP001         // Get a component enumeration from the desktop and search it for documents.
//STRIP001         Reference<lang::XMultiServiceFactory> xFactory (
//STRIP001             ::legacy_binfilters::getLegacyProcessServiceFactory());
//STRIP001         do
//STRIP001         {
//STRIP001             if ( ! xFactory.is())
//STRIP001                 break;
//STRIP001 
//STRIP001             Reference<frame::XDesktop> xDesktop (xFactory->createInstance (
//STRIP001                 ::rtl::OUString::createFromAscii("com.sun.star.frame.Desktop")), UNO_QUERY);
//STRIP001             if ( ! xDesktop.is())
//STRIP001                 break;
//STRIP001 
//STRIP001             Reference<container::XEnumerationAccess> xComponents (
//STRIP001                 xDesktop->getComponents(), UNO_QUERY);
//STRIP001             if ( ! xComponents.is())
//STRIP001                 break;
//STRIP001 
//STRIP001             Reference<container::XEnumeration> xEnumeration (
//STRIP001                 xComponents->createEnumeration());
//STRIP001             if ( ! xEnumeration.is())
//STRIP001                 break;
//STRIP001 
//STRIP001             while (xEnumeration->hasMoreElements())
//STRIP001             {
//STRIP001                 Reference<frame::XModel> xModel (xEnumeration->nextElement(), UNO_QUERY);
//STRIP001                 if (xModel.is())
//STRIP001                 {
//STRIP001                     // There is at leas one model/document: Enable the compatibility controls.
//STRIP001                     bIsEnabled = sal_True;
//STRIP001                     break;
//STRIP001                 }
//STRIP001             }
//STRIP001             
//STRIP001         }
//STRIP001         while (false); // One 'loop'.
//STRIP001     }
//STRIP001     catch (uno::Exception e)
//STRIP001     {
//STRIP001         // When there is an exception then simply use the default value of
//STRIP001         // bIsEnabled and disable the controls.
//STRIP001     }
//STRIP001     
//STRIP001     aTxtCompatibility.Enable (bIsEnabled);
//STRIP001 	aCbxCompatibility.Enable(bIsEnabled);
//STRIP001     aCbxUsePrinterMetrics.Enable (bIsEnabled);
//STRIP001 }

}
