/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_fusel.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:17:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

// auto strip #ifndef _VOS_PROCESS_HXX_
// auto strip #include <vos/process.hxx>
// auto strip #endif
// auto strip #ifndef _SB_SBSTAR_HXX //autogen
// auto strip #include <basic/sbstar.hxx>
// auto strip #endif
// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOGRP_HXX //autogen
// auto strip #include <bf_svx/svdogrp.hxx>
// auto strip #endif
// auto strip #ifndef _E3D_POLYSC3D_HXX //autogen
// auto strip #include <bf_svx/polysc3d.hxx>
// auto strip #endif
// auto strip #include "drawview.hxx"
// auto strip #ifndef _GOODIES_IMAPOBJ_HXX //autogen
// auto strip #include <svtools/imapobj.hxx>
// auto strip #endif
#ifndef _SV_SOUND_HXX //autogen
#include <vcl/sound.hxx>
#endif
// auto strip #include <svtools/urihelper.hxx>
// auto strip #include <unotools/localfilehelper.hxx>
#include <bf_svx/svxids.hrc>
// auto strip #include <bf_svx/xfillit0.hxx>

// auto strip #ifndef _SFXVIEWFRM_HXX //autogen
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif
// auto strip #ifndef _AEITEM_HXX //autogen
// auto strip #include <svtools/aeitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSTRITEM_HXX //autogen
// auto strip #include <svtools/stritem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXINTITEM_HXX //autogen
// auto strip #include <svtools/intitem.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _URLOBJ_HXX //autogen
// auto strip #include <tools/urlobj.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDOCFILE_HXX //autogen
// auto strip #include <bf_sfx2/docfile.hxx>
// auto strip #endif
// auto strip #ifndef _TOOLS_DEBUG_HXX
// auto strip #include <tools/debug.hxx>
// auto strip #endif
#ifndef _EEITEM_HXX //autogen
#include <bf_svx/eeitem.hxx>
#endif

#ifndef _SVX_ITEMDATA_HXX
#include <bf_svx/itemdata.hxx>
#endif

#define ITEMID_FIELD	EE_FEATURE_FIELD
// auto strip #include <bf_svx/flditem.hxx>

#include "app.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"

// auto strip #include "grdocsh.hxx"
// auto strip #include "app.hxx"
// auto strip #include "docshell.hxx"
// auto strip #include "stlpool.hxx"
// auto strip #include "anmdef.hxx"
// auto strip #include "anminfo.hxx"
// auto strip #include "fudraw.hxx"
#include "fusel.hxx"
// auto strip #include "viewshel.hxx"
// auto strip #include "frmview.hxx"
#include "sdview.hxx"
// auto strip #include "sdwindow.hxx"
// auto strip #include "drawdoc.hxx"
// auto strip #include "sdpage.hxx"
#include "drviewsh.hxx"
// auto strip #include "pgjump.hxx"
// auto strip #include <bf_svx/globl3d.hxx>
// auto strip #include "sdclient.hxx"

// #108981#
// auto strip #ifndef _SVDUNDO_HXX
// auto strip #include <bf_svx/svdundo.hxx>
// auto strip #endif
#include "so3/staticbaseurl.hxx"
namespace binfilter {

using namespace ::com::sun::star;

TYPEINIT1( FuSelection, FuDraw );

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

/*N*/ FuSelection::FuSelection(SdViewShell*	  pViewSh,
/*N*/ 						 SdWindow*		  pWin,
/*N*/ 						 SdView*		  pView,
/*N*/ 						 SdDrawDocument*  pDoc,
/*N*/ 						 SfxRequest&	  rReq) :
/*N*/ 	FuDraw(pViewSh, pWin, pView, pDoc, rReq),
/*N*/ 	bTempRotation(FALSE),
/*N*/     bHideAndAnimate(FALSE),
/*N*/     bSelectionChanged(FALSE),
/*N*/     pHdl(NULL),
/*N*/     bSuppressChangesOfSelection(FALSE),
/*N*/     bMirrorSide0(FALSE),
/*N*/     nEditMode(SID_BEZIER_MOVE),
/*N*/     pSound(NULL),
/*N*/     pWaterCanCandidate(NULL)
/*N*/ {
/*N*/     // Objektbar auswaehlen
/*N*/     SelectionHasChanged();
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ FuSelection::~FuSelection()
/*N*/ {
/*N*/ 	HPUX_DTOR_BUG;
/*N*/     pView->UnmarkAllPoints();
/*N*/     pView->ShowMirrored();
/*N*/     pView->ResetCreationActive();
/*N*/     delete pSound;
/*N*/     pSound = NULL;

/*N*/ 	if ( pView->GetDragMode() != SDRDRAG_MOVE )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pView->SetDragMode(SDRDRAG_MOVE);
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* MouseButtonDown-event
|*
\************************************************************************/

//STRIP001 BOOL FuSelection::MouseButtonDown(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	// Hack fuer #?????#
//STRIP001     bHideAndAnimate = FALSE;
//STRIP001 
//STRIP001 	pHdl = NULL;
//STRIP001 	BOOL bReturn = FuDraw::MouseButtonDown(rMEvt);
//STRIP001     BOOL bWaterCan = SD_MOD()->GetWaterCan();
//STRIP001 	const bool bReadOnly = pDocSh->IsReadOnly();
//STRIP001 
//STRIP001 	bMBDown = TRUE;
//STRIP001     bSelectionChanged = FALSE;
//STRIP001 
//STRIP001 	if ( pView->IsAction() )
//STRIP001 	{
//STRIP001 		if ( rMEvt.IsRight() )
//STRIP001 			pView->BckAction();
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nDrgLog = USHORT ( pWindow->PixelToLogic(Size(DRGPIX,0)).Width() );
//STRIP001 	USHORT nHitLog = USHORT ( pWindow->PixelToLogic(Size(HITPIX,0)).Width() );
//STRIP001 
//STRIP001     if (rMEvt.IsLeft() && !pView->IsAction() &&
//STRIP001         (pView->IsFrameDragSingles() || !pView->HasMarkablePoints()))
//STRIP001     {
        /******************************************************************
        * KEIN BEZIER_EDITOR
        ******************************************************************/
//STRIP001         pWindow->CaptureMouse();
//STRIP001         pHdl = pView->HitHandle(aMDPos, *pWindow);
//STRIP001         SdrObject* pObj;
//STRIP001         SdrPageView* pPV;
//STRIP001 
//STRIP001         long nAngle0  = GetAngle(aMDPos - pView->GetRef1());
//STRIP001         nAngle0 -= 27000;
//STRIP001         nAngle0 = NormAngle360(nAngle0);
//STRIP001         bMirrorSide0 = BOOL (nAngle0 < 18000L);
//STRIP001 
//STRIP001         if (!pHdl && pView->IsCreationActive())
//STRIP001         {
            /******************************************************************
            * Wenn 3D-Rotationskoerper erstellt werden sollen, jetzt
            * die Erstellung beenden
            ******************************************************************/
//STRIP001             bSuppressChangesOfSelection = TRUE;
//STRIP001 			if(pWindow)
//STRIP001 				pWindow->EnterWait();
//STRIP001             pView->End3DCreation();
//STRIP001             bSuppressChangesOfSelection = FALSE;
//STRIP001             pView->ResetCreationActive();
//STRIP001 			if(pWindow)
//STRIP001 				pWindow->LeaveWait();
//STRIP001         }
//STRIP001 
//STRIP001 		BOOL bTextEdit = FALSE;
//STRIP001         SdrViewEvent aVEvt;
//STRIP001 		SdrHitKind eHit = pView->PickAnything(rMEvt, SDRMOUSEBUTTONDOWN, aVEvt);
//STRIP001 
//STRIP001 		if ( pViewShell->GetFrameView()->IsQuickEdit() && eHit == SDRHIT_TEXTEDITOBJ )
//STRIP001 		{
//STRIP001 			bTextEdit = TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001         if(!bTextEdit
//STRIP001 			&& !pDocSh->IsReadOnly()
//STRIP001 			&& ((pView->IsMarkedHit(aMDPos, nHitLog) && !rMEvt.IsShift() && !rMEvt.IsMod2()) || pHdl != NULL)
//STRIP001 			&& (rMEvt.GetClicks() != 2)
//STRIP001 			)
//STRIP001         {
//STRIP001 			if (!pHdl && pView->IsCreationActive())
//STRIP001 			{
//STRIP001 				// Wechsel Rotationskoerper -> Selektion
//STRIP001 				pView->ShowMirrored();
//STRIP001 				pView->ResetCreationActive();
//STRIP001 			}
//STRIP001 			else if (bWaterCan)
//STRIP001             {
//STRIP001                 // Remember the selected object for proper handling in
//STRIP001                 // MouseButtonUp().
//STRIP001                 pWaterCanCandidate = pickObject (aMDPos);
//STRIP001             }
//STRIP001             else
//STRIP001 			{
//STRIP001 				// Handle oder markiertes Objekt getroffen
//STRIP001 				bFirstMouseMove = TRUE;
//STRIP001 				aDragTimer.Start();
//STRIP001 			}
//STRIP001 
//STRIP001 			pView->BegDragObj(aMDPos, (OutputDevice*) NULL, pHdl, nDrgLog);
//STRIP001 			bReturn = TRUE;
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             if (!rMEvt.IsMod2() && pView->PickObj(aMDPos, pObj, pPV, SDRSEARCH_PICKMACRO))
//STRIP001             {
//STRIP001                 pView->BegMacroObj(aMDPos, nHitLog, pObj, pPV, pWindow);
//STRIP001                 bReturn = TRUE;
//STRIP001             }
//STRIP001             else if ( bTextEdit )
//STRIP001             {
//STRIP001                 UINT16 nSdrObjKind = aVEvt.pObj->GetObjIdentifier();
//STRIP001 
//STRIP001                 if (aVEvt.pObj->GetObjInventor() == SdrInventor &&
//STRIP001                     (nSdrObjKind == OBJ_TEXT ||
//STRIP001                      nSdrObjKind == OBJ_TITLETEXT ||
//STRIP001                      nSdrObjKind == OBJ_OUTLINETEXT ||
//STRIP001                      !aVEvt.pObj->IsEmptyPresObj()))
//STRIP001                 {
//STRIP001                     // Seamless Editing: Verzweigen zur Texteingabe
//STRIP001 					if (!rMEvt.IsShift())
//STRIP001 						pView->UnmarkAll();
//STRIP001 
//STRIP001                     SfxUInt16Item aItem(SID_TEXTEDIT, 1);
//STRIP001                     pViewShell->GetViewFrame()->GetDispatcher()->
//STRIP001                     Execute(SID_TEXTEDIT, SFX_CALLMODE_SYNCHRON |
//STRIP001                             SFX_CALLMODE_RECORD, &aItem, 0L);
//STRIP001 					return bReturn; // VORSICHT, durch den synchronen Slot ist das objekt jetzt geloescht
//STRIP001                 }
//STRIP001             }
//STRIP001 			else if ( !rMEvt.IsMod2() && rMEvt.GetClicks() == 1 &&
//STRIP001 			          aVEvt.eEvent == SDREVENT_EXECUTEURL )
//STRIP001 	 		{
//STRIP001 	            pWindow->ReleaseMouse();
//STRIP001                 SfxStringItem aStrItem(SID_FILE_NAME, aVEvt.pURLField->GetURL());
//STRIP001                 SfxStringItem aReferer(SID_REFERER, pDocSh->GetMedium()->GetName());
//STRIP001                 SfxBoolItem aBrowseItem( SID_BROWSE, TRUE );
//STRIP001                 SfxViewFrame* pFrame = pViewShell->GetViewFrame();
//STRIP001 				pWindow->ReleaseMouse();
//STRIP001 
//STRIP001 				if (rMEvt.IsMod1())
//STRIP001 				{
//STRIP001 					// Im neuen Frame oeffnen
//STRIP001                 	pFrame->GetDispatcher()->Execute(SID_OPENDOC, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD,
//STRIP001                     		    &aStrItem, &aBrowseItem, &aReferer, 0L);
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					// Im aktuellen Frame oeffnen
//STRIP001 					SfxFrameItem aFrameItem(SID_DOCFRAME, pFrame);
//STRIP001                 	pFrame->GetDispatcher()->Execute(SID_OPENDOC, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD,
//STRIP001                     		    &aStrItem, &aFrameItem, &aBrowseItem, &aReferer, 0L);
//STRIP001 				}
//STRIP001 
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001             else if(!rMEvt.IsMod2()
//STRIP001 				&& pViewShell->ISA(SdDrawViewShell)
//STRIP001 				)
//STRIP001             {
//STRIP001 				if(pView->PickObj(aMDPos, pObj, pPV, SDRSEARCH_ALSOONMASTER))
//STRIP001 				{
//STRIP001 					// Objekt animieren
//STRIP001 					bReturn = AnimateObj(pObj, aMDPos);
//STRIP001 
//STRIP001 					if (!bReturn && (pObj->ISA(SdrObjGroup) || pObj->ISA(E3dPolyScene)))
//STRIP001 					{
//STRIP001 						if(rMEvt.GetClicks() == 1)
//STRIP001 						{
//STRIP001 							// In die Gruppe hineinschauen
//STRIP001 							if (pView->PickObj(aMDPos, pObj, pPV, SDRSEARCH_ALSOONMASTER | SDRSEARCH_DEEP))
//STRIP001 								bReturn = AnimateObj(pObj, aMDPos);
//STRIP001 						}
//STRIP001 						else if( !bReadOnly && rMEvt.GetClicks() == 2)
//STRIP001 						{
//STRIP001 							// Neu: Doppelklick auf selektiertes Gruppenobjekt
//STRIP001 							// Gruppe betreten
//STRIP001 							if(pObj && pObj->GetPage() == pPV->GetPage())
//STRIP001 								bReturn = pPV->EnterGroup(pObj);
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if(rMEvt.GetClicks() == 2)
//STRIP001 					{
//STRIP001 						// Neu: Doppelklick ins Leere
//STRIP001 						// Gruppe verlassen
//STRIP001 						pPV = pView->GetPageViewPvNum(0);
//STRIP001 
//STRIP001 						if(pPV && pPV->GetAktGroup())
//STRIP001 						{
//STRIP001 							pPV->LeaveOneGroup();
//STRIP001 						}
//STRIP001 						bReturn = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001             if (!bReturn)
//STRIP001             {
//STRIP001                 if (bWaterCan)
//STRIP001                 {
//STRIP001                     if ( ! (rMEvt.IsShift() || rMEvt.IsMod2()))
//STRIP001                     {
//STRIP001                         // Find the object under the current mouse position
//STRIP001                         // and store it for the MouseButtonUp() method to
//STRIP001                         // evaluate.
//STRIP001                         pWaterCanCandidate = pickObject (aMDPos);
//STRIP001                     }
//STRIP001                 }
//STRIP001                 else
//STRIP001                 {
//STRIP001                     bReturn = TRUE;
//STRIP001                     BOOL bDeactivateOLE = FALSE;
//STRIP001 
//STRIP001                     if ( !rMEvt.IsShift() && !rMEvt.IsMod2() )
//STRIP001                     {
//STRIP001                         SdClient* pIPClient = (SdClient*) pViewShell->GetIPClient();
//STRIP001                         
//STRIP001                         if (pIPClient && pIPClient->IsInPlaceActive())
//STRIP001                         {
//STRIP001                             // OLE-Objekt wird im nachfolgenden UnmarkAll() deaktiviert
//STRIP001                             bDeactivateOLE = TRUE;
//STRIP001                         }
//STRIP001                         
//STRIP001                         pView->UnmarkAll();
//STRIP001                     }
//STRIP001 
//STRIP001                     BOOL bMarked = FALSE;
//STRIP001 
//STRIP001                     if ( !rMEvt.IsMod1() && !bDeactivateOLE)
//STRIP001                     {
//STRIP001                         if ( rMEvt.IsMod2() )
//STRIP001                         {
//STRIP001                             bMarked = pView->MarkNextObj(aMDPos, nHitLog, rMEvt.IsShift() );
//STRIP001                         }
//STRIP001                         else
//STRIP001                         {
//STRIP001                             BOOL bToggle = FALSE;
//STRIP001 
//STRIP001                             if (rMEvt.IsShift() && pView->GetMarkList().GetMarkCount() > 1)
//STRIP001                             {
//STRIP001                                 // Bei Einfachselektion kein Toggle
//STRIP001                                 bToggle = TRUE;
//STRIP001                             }
//STRIP001 
//STRIP001                             bMarked = pView->MarkObj(aMDPos, nHitLog, bToggle, FALSE);
//STRIP001                         }
//STRIP001                     }
//STRIP001 
//STRIP001                     if ( !bReadOnly &&
//STRIP001                         bMarked                                                   &&
//STRIP001                         (!rMEvt.IsShift() || pView->IsMarkedHit(aMDPos, nHitLog)))
//STRIP001                     {
//STRIP001                         /**********************************************************
//STRIP001                         * Objekt verschieben
//STRIP001                         **********************************************************/
//STRIP001                         aDragTimer.Start();
//STRIP001                         
//STRIP001                         pHdl=pView->HitHandle(aMDPos, *pWindow);
//STRIP001                         pView->BegDragObj(aMDPos, (OutputDevice*) NULL, pHdl, nDrgLog);
//STRIP001                     }
//STRIP001                     else
//STRIP001                     {
//STRIP001                         /**********************************************************
//STRIP001                         * Objekt selektieren
//STRIP001                         **********************************************************/
//STRIP001                         pView->BegMarkObj(aMDPos);
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001     else if ( !bReadOnly && rMEvt.IsLeft() && !pView->IsAction())
//STRIP001     {
        /**********************************************************************
        * BEZIER-EDITOR
        **********************************************************************/
//STRIP001         pWindow->CaptureMouse();
//STRIP001         SdrViewEvent aVEvt;
//STRIP001         SdrHitKind eHit = pView->PickAnything(rMEvt, SDRMOUSEBUTTONDOWN, aVEvt);
//STRIP001 
//STRIP001         if (eHit == SDRHIT_HANDLE && aVEvt.pHdl->GetKind() == HDL_BWGT)
//STRIP001         {
            /******************************************************************
            * Handle draggen
            ******************************************************************/
//STRIP001             pView->BegDragObj(aMDPos, (OutputDevice*) NULL, aVEvt.pHdl, nDrgLog);
//STRIP001         }
//STRIP001         else if (eHit == SDRHIT_MARKEDOBJECT && nEditMode == SID_BEZIER_INSERT)
//STRIP001         {
//STRIP001             /******************************************************************
//STRIP001             * Klebepunkt einfuegen
//STRIP001             ******************************************************************/
//STRIP001             pView->BegInsObjPoint(aMDPos, rMEvt.IsMod1(), NULL, 0);
//STRIP001         }
//STRIP001         else if (eHit == SDRHIT_MARKEDOBJECT && rMEvt.IsMod1())
//STRIP001         {
            /******************************************************************
            * Klebepunkt selektieren
            ******************************************************************/
//STRIP001             if (!rMEvt.IsShift())
//STRIP001                 pView->UnmarkAllPoints();
//STRIP001 
//STRIP001             pView->BegMarkPoints(aMDPos, (OutputDevice*) NULL);
//STRIP001         }
//STRIP001         else if (eHit == SDRHIT_MARKEDOBJECT && !rMEvt.IsShift() && !rMEvt.IsMod2())
//STRIP001         {
            /******************************************************************
            * Objekt verschieben
            ******************************************************************/
//STRIP001             pView->BegDragObj(aMDPos, (OutputDevice*) NULL, NULL, nDrgLog);
//STRIP001         }
//STRIP001         else if (eHit == SDRHIT_HANDLE)
//STRIP001         {
            /******************************************************************
            * Klebepunkt selektieren
            ******************************************************************/
//STRIP001             if (!pView->IsPointMarked(*aVEvt.pHdl) || rMEvt.IsShift())
//STRIP001             {
//STRIP001                 if (!rMEvt.IsShift())
//STRIP001                 {
//STRIP001                     pView->UnmarkAllPoints();
//STRIP001                     pHdl = pView->HitHandle(aMDPos, *pWindow);
//STRIP001                 }
//STRIP001                 else
//STRIP001                 {
//STRIP001                     if (pView->IsPointMarked(*aVEvt.pHdl))
//STRIP001                     {
//STRIP001                         pView->UnmarkPoint(*aVEvt.pHdl);
//STRIP001                         pHdl = NULL;
//STRIP001                     }
//STRIP001                     else
//STRIP001                     {
//STRIP001                         pHdl = pView->HitHandle(aMDPos, *pWindow);
//STRIP001                     }
//STRIP001                 }
//STRIP001 
//STRIP001                 if (pHdl)
//STRIP001                 {
//STRIP001                     pView->MarkPoint(*pHdl);
//STRIP001                     pView->BegDragObj(aMDPos, (OutputDevice*) NULL, pHdl, nDrgLog);
//STRIP001                 }
//STRIP001             }
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// #90239# point IS marked and NO shift is pressed. Start
//STRIP001 				// dragging of selected point(s)
//STRIP001 				pHdl = pView->HitHandle(aMDPos, *pWindow);
//STRIP001 				if(pHdl)
//STRIP001 					pView->BegDragObj(aMDPos, (OutputDevice*)NULL, pHdl, nDrgLog);
//STRIP001 			}
//STRIP001         }
//STRIP001         else
//STRIP001         {
            /******************************************************************
            * Objekt selektieren oder draggen
            ******************************************************************/
//STRIP001             if (!rMEvt.IsShift() && !rMEvt.IsMod2() && eHit == SDRHIT_UNMARKEDOBJECT)
//STRIP001             {
//STRIP001                pView->UnmarkAllObj();
//STRIP001             }
//STRIP001 
//STRIP001             BOOL bMarked = FALSE;
//STRIP001 
//STRIP001             if (!rMEvt.IsMod1())
//STRIP001             {
//STRIP001                 if (rMEvt.IsMod2())
//STRIP001                 {
//STRIP001                     bMarked = pView->MarkNextObj(aMDPos, nHitLog, rMEvt.IsShift());
//STRIP001                 }
//STRIP001                 else
//STRIP001                 {
//STRIP001                     bMarked = pView->MarkObj(aMDPos, nHitLog, rMEvt.IsShift(), FALSE);
//STRIP001                 }
//STRIP001             }
//STRIP001 
//STRIP001             if (bMarked &&
//STRIP001                 (!rMEvt.IsShift() || eHit == SDRHIT_MARKEDOBJECT))
//STRIP001             {
//STRIP001                 // Objekt verschieben
//STRIP001                 pView->BegDragObj(aMDPos, (OutputDevice*) NULL, aVEvt.pHdl, nDrgLog);
//STRIP001             }
//STRIP001             else if (pView->HasMarkedObj())
//STRIP001             {
                /**************************************************************
                * Klebepunkt selektieren
                **************************************************************/
//STRIP001                 if (!rMEvt.IsShift())
//STRIP001                     pView->UnmarkAllPoints();
//STRIP001 
//STRIP001                 pView->BegMarkPoints(aMDPos, (OutputDevice*) NULL);
//STRIP001             }
//STRIP001             else
//STRIP001             {
                /**************************************************************
                * Objekt selektieren
                **************************************************************/
//STRIP001                 pView->BegMarkObj(aMDPos);
//STRIP001             }
//STRIP001 
//STRIP001             ForcePointer(&rMEvt);
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001 	if (!bIsInDragMode)
//STRIP001 	{
//STRIP001 		ForcePointer(&rMEvt);
//STRIP001 	}
//STRIP001 
//STRIP001 	return bReturn;
//STRIP001 }

/*************************************************************************
|*
|* MouseMove-event
|*
\************************************************************************/

//STRIP001 BOOL FuSelection::MouseMove(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	BOOL bReturn = FuDraw::MouseMove(rMEvt);
//STRIP001 
//STRIP001     if (aDragTimer.IsActive())
//STRIP001 	{
//STRIP001         if(bFirstMouseMove)
//STRIP001         {
//STRIP001 			bFirstMouseMove = FALSE;
//STRIP001         }
//STRIP001 		else
//STRIP001         {
//STRIP001             aDragTimer.Stop();
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001     if (pView->IsAction())
//STRIP001 	{
//STRIP001 		Point aPix(rMEvt.GetPosPixel());
//STRIP001 		Point aPnt(pWindow->PixelToLogic(aPix));
//STRIP001 
//STRIP001 		ForceScroll(aPix);
//STRIP001 
//STRIP001         if (pView->IsInsObjPoint())
//STRIP001         {
//STRIP001             pView->MovInsObjPoint(aPnt);
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             pView->MovAction(aPnt);
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001 	ForcePointer(&rMEvt);
//STRIP001 
//STRIP001 	return (bReturn);
//STRIP001 //STRIP001 }

/*************************************************************************
|*
|* MouseButtonUp-event
|*
\************************************************************************/

//STRIP001 BOOL FuSelection::MouseButtonUp(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001     BOOL bReturn = FALSE;
//STRIP001 
//STRIP001     if (bHideAndAnimate)
//STRIP001     {
//STRIP001         // Animation laeuft noch -> sofort returnieren
//STRIP001         bHideAndAnimate = FALSE;
//STRIP001         pHdl = NULL;
//STRIP001         pWindow->ReleaseMouse();
//STRIP001         return(TRUE);
//STRIP001     }
//STRIP001 
//STRIP001 	if (aDragTimer.IsActive() )
//STRIP001 	{
//STRIP001 		aDragTimer.Stop();
//STRIP001 		bIsInDragMode = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001     Point aPnt( pWindow->PixelToLogic( rMEvt.GetPosPixel() ) );
//STRIP001     USHORT nHitLog = USHORT ( pWindow->PixelToLogic(Size(HITPIX,0)).Width() );
//STRIP001     USHORT nDrgLog = USHORT ( pWindow->PixelToLogic(Size(DRGPIX,0)).Width() );
//STRIP001 
//STRIP001     if (pView->IsFrameDragSingles() || !pView->HasMarkablePoints())
//STRIP001     {
        /**********************************************************************
        * KEIN BEZIER_EDITOR
        **********************************************************************/
//STRIP001         if ( pView->IsDragObj() )
//STRIP001         {
            /******************************************************************
            * Objekt wurde verschoben
            ******************************************************************/
//STRIP001             FrameView* pFrameView = pViewShell->GetFrameView();
//STRIP001             BOOL bDragWithCopy = (rMEvt.IsMod1() && pFrameView->IsDragWithCopy());
//STRIP001 
//STRIP001             if (bDragWithCopy)
//STRIP001             {
//STRIP001                 bDragWithCopy = !pView->IsPresObjSelected(FALSE, TRUE);
//STRIP001             }
//STRIP001 
//STRIP001             pView->SetDragWithCopy(bDragWithCopy);
//STRIP001             pView->EndDragObj( pView->IsDragWithCopy() );
//STRIP001 
//STRIP001             pView->ForceMarkedToAnotherPage();
//STRIP001 
//STRIP001             if (!rMEvt.IsShift() && !rMEvt.IsMod1() && !rMEvt.IsMod2() &&
//STRIP001                 !bSelectionChanged                   &&
//STRIP001                 Abs(aPnt.X() - aMDPos.X()) < nDrgLog &&
//STRIP001                 Abs(aPnt.Y() - aMDPos.Y()) < nDrgLog)
//STRIP001             {
//STRIP001                 /**************************************************************
//STRIP001                 * Toggle zw. Selektion und Rotation
//STRIP001                 **************************************************************/
//STRIP001                 SdrObject* pSingleObj = NULL;
//STRIP001                 ULONG nMarkCount = pView->GetMarkList().GetMarkCount();
//STRIP001 
//STRIP001                 if (nMarkCount==1)
//STRIP001                 {
//STRIP001                     pSingleObj = pView->GetMarkList().GetMark(0)->GetObj();
//STRIP001                 }
//STRIP001 
//STRIP001                 if (nSlotId == SID_OBJECT_SELECT && pView->IsRotateAllowed() &&
//STRIP001                      (pViewShell->GetFrameView()->IsClickChangeRotation() ||
//STRIP001                       (pSingleObj && pSingleObj->GetObjInventor()==E3dInventor)))
//STRIP001 
//STRIP001                 {
//STRIP001                     bTempRotation = TRUE;
//STRIP001                     nSlotId = SID_OBJECT_ROTATE;
//STRIP001                     Activate();
//STRIP001                 }
//STRIP001                 else if (nSlotId == SID_OBJECT_ROTATE)
//STRIP001                 {
//STRIP001                     nSlotId = SID_OBJECT_SELECT;
//STRIP001                     Activate();
//STRIP001                 }
//STRIP001             }
//STRIP001             else if (nSlotId == SID_CONVERT_TO_3D_LATHE)
//STRIP001             {
//STRIP001                 if (!pHdl)
//STRIP001                 {
//STRIP001                     bSuppressChangesOfSelection = TRUE;
//STRIP001                     pView->Start3DCreation();
//STRIP001                     bSuppressChangesOfSelection = FALSE;
//STRIP001                 }
//STRIP001                 else if (pHdl->GetKind() != HDL_MIRX &&
//STRIP001                          pHdl->GetKind() != HDL_REF1 &&
//STRIP001                          pHdl->GetKind() != HDL_REF2 && pView->IsCreationActive())
//STRIP001                 {
                    /*********************************************************
                    * Wenn 3D-Rotationskoerper erstellt werden sollen, jetzt
                    * die Erstellung beenden
                    **********************************************************/
//STRIP001                      long nAngle1  = GetAngle(aPnt - pView->GetRef1());
//STRIP001                      nAngle1 -= 27000;
//STRIP001                      nAngle1 = NormAngle360(nAngle1);
//STRIP001                      BOOL bMirrorSide1 = BOOL (nAngle1 < 18000L);
//STRIP001 
//STRIP001                      if (bMirrorSide0 != bMirrorSide1)
//STRIP001                      {
//STRIP001                          bSuppressChangesOfSelection = TRUE;
//STRIP001 						if(pWindow)
//STRIP001 							pWindow->EnterWait();
//STRIP001                          pView->End3DCreation();
//STRIP001                          bSuppressChangesOfSelection = FALSE;
//STRIP001                          nSlotId = SID_OBJECT_SELECT;
//STRIP001 						if(pWindow)
//STRIP001 							pWindow->LeaveWait();
//STRIP001                          Activate();
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001         else if (rMEvt.IsMod1() && !rMEvt.IsMod2() &&
//STRIP001                  Abs(aPnt.X() - aMDPos.X()) < nDrgLog &&
//STRIP001                  Abs(aPnt.Y() - aMDPos.Y()) < nDrgLog)
//STRIP001         {
//STRIP001             // Gruppe betreten
//STRIP001             pView->MarkObj(aPnt, nHitLog, rMEvt.IsShift(), rMEvt.IsMod1());
//STRIP001         }
//STRIP001 
//STRIP001         if (pView->IsAction() )
//STRIP001         {
//STRIP001             pView->EndAction();
//STRIP001         }
//STRIP001 
//STRIP001         if( SD_MOD()->GetWaterCan() )
//STRIP001         {
//STRIP001             if( rMEvt.IsRight() )
//STRIP001             {
//STRIP001                 // Bei rechter Maustaste wird im Giesskannenmodus ein Undo ausgefuehrt
//STRIP001                 pViewShell->GetViewFrame()->GetDispatcher()->Execute( SID_UNDO, SFX_CALLMODE_ASYNCHRON );
//STRIP001             }
//STRIP001             else if (pWaterCanCandidate != NULL)
//STRIP001             {
//STRIP001                 // Is the candiate object still under the mouse?
//STRIP001                 if (pickObject (aPnt) == pWaterCanCandidate)
//STRIP001                 {
//STRIP001                     SdStyleSheetPool* pPool = static_cast<SdStyleSheetPool*>(
//STRIP001                         pDocSh->GetStyleSheetPool());
//STRIP001                     if (pPool != NULL)
//STRIP001                     {
//STRIP001                         SfxStyleSheet* pStyleSheet = static_cast<SfxStyleSheet*>(
//STRIP001                             pPool->GetActualStyleSheet());
//STRIP001                         if (pStyleSheet != NULL)
//STRIP001                         {
//STRIP001 							// #108981#
//STRIP001 							// Added UNDOs for the WaterCan mode. This was never done in
//STRIP001 							// the past, thus it was missing all the time.
//STRIP001 							SdrUndoAttrObj* pUndoAttr = new SdrUndoAttrObj(*pWaterCanCandidate, sal_True, sal_True);
//STRIP001 							pView->BegUndo(pUndoAttr->GetComment());
//STRIP001 							pView->AddUndo(new SdrUndoGeoObj(*pWaterCanCandidate));
//STRIP001 							pView->AddUndo(pUndoAttr);
//STRIP001                             
//STRIP001 							pWaterCanCandidate->SetStyleSheet (pStyleSheet, FALSE);
//STRIP001 							
//STRIP001 							// #108981#
//STRIP001 							pView->EndUndo();
//STRIP001                         }
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001             // else when there has been no object under the mouse when the
//STRIP001             // button was pressed then nothing happens even when there is
//STRIP001             // one now.
//STRIP001         }
//STRIP001 
//STRIP001         USHORT nClicks = rMEvt.GetClicks();
//STRIP001 
//STRIP001         if (nClicks == 2 && rMEvt.IsLeft() && bMBDown &&
//STRIP001             !rMEvt.IsMod1() && !rMEvt.IsShift() )
//STRIP001         {
//STRIP001             DoubleClick(rMEvt);
//STRIP001         }
//STRIP001 
//STRIP001         bMBDown = FALSE;
//STRIP001 
//STRIP001         ForcePointer(&rMEvt);
//STRIP001         pHdl = NULL;
//STRIP001         pWindow->ReleaseMouse();
//STRIP001         SdrObject* pSingleObj = NULL;
//STRIP001         ULONG nMarkCount = pView->GetMarkList().GetMarkCount();
//STRIP001 
//STRIP001         if (nMarkCount==1)
//STRIP001         {
//STRIP001             pSingleObj = pView->GetMarkList().GetMark(0)->GetObj();
//STRIP001         }
//STRIP001 
//STRIP001         if ( nSlotId != SID_OBJECT_SELECT                            &&
//STRIP001              (/* bTempRotation && */ nMarkCount==0)                    ||
//STRIP001              ( pView->GetDragMode() == SDRDRAG_CROOK &&
//STRIP001               !pView->IsCrookAllowed( pView->IsCrookNoContortion() ) ) ||
//STRIP001              ( pView->GetDragMode() == SDRDRAG_SHEAR &&
//STRIP001               !pView->IsShearAllowed() && !pView->IsDistortAllowed() ) ||
//STRIP001              ( nSlotId==SID_CONVERT_TO_3D_LATHE && pSingleObj &&
//STRIP001               (pSingleObj->GetObjInventor() != SdrInventor         ||
//STRIP001                pSingleObj->GetObjIdentifier() == OBJ_MEASURE) ) )
//STRIP001         {
//STRIP001 			bReturn = TRUE;
//STRIP001 	        ForcePointer(&rMEvt);
//STRIP001     	    pHdl = NULL;
//STRIP001         	pWindow->ReleaseMouse();
//STRIP001 	        FuDraw::MouseButtonUp(rMEvt);
//STRIP001 			pViewShell->GetViewFrame()->GetDispatcher()->Execute(SID_OBJECT_SELECT, SFX_CALLMODE_SYNCHRON);
//STRIP001 			return bReturn; // VORSICHT, durch den synchronen Slot ist das objekt jetzt geloescht
//STRIP001 		}
//STRIP001 
//STRIP001         FuDraw::MouseButtonUp(rMEvt);
//STRIP001     }
//STRIP001     else
//STRIP001     {
        /**********************************************************************
        * BEZIER_EDITOR
        **********************************************************************/
//STRIP001         if ( pView->IsAction() )
//STRIP001         {
//STRIP001             if ( pView->IsInsObjPoint() )
//STRIP001             {
//STRIP001                 pView->EndInsObjPoint(SDRCREATE_FORCEEND);
//STRIP001             }
//STRIP001             else if ( pView->IsDragObj() )
//STRIP001             {
//STRIP001                 FrameView* pFrameView = pViewShell->GetFrameView();
//STRIP001                 BOOL bDragWithCopy = (rMEvt.IsMod1() && pFrameView->IsDragWithCopy());
//STRIP001 
//STRIP001                 if (bDragWithCopy)
//STRIP001                 {
//STRIP001                     bDragWithCopy = !pView->IsPresObjSelected(FALSE, TRUE);
//STRIP001                 }
//STRIP001 
//STRIP001                 pView->SetDragWithCopy(bDragWithCopy);
//STRIP001                 pView->EndDragObj( pView->IsDragWithCopy() );
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 pView->EndAction();
//STRIP001 
//STRIP001                 USHORT nDrgLog = USHORT ( pWindow->PixelToLogic(Size(DRGPIX,0)).Width() );
//STRIP001                 Point aPos = pWindow->PixelToLogic( rMEvt.GetPosPixel() );
//STRIP001 
//STRIP001                 if (Abs(aMDPos.X() - aPos.X()) < nDrgLog &&
//STRIP001                     Abs(aMDPos.Y() - aPos.Y()) < nDrgLog &&
//STRIP001                     !rMEvt.IsShift() && !rMEvt.IsMod2())
//STRIP001                 {
//STRIP001                     SdrViewEvent aVEvt;
//STRIP001                     SdrHitKind eHit = pView->PickAnything(rMEvt, SDRMOUSEBUTTONDOWN, aVEvt);
//STRIP001 
//STRIP001                     if (eHit == SDRHIT_NONE)
//STRIP001                     {
//STRIP001                         // Klick auf der Stelle: deselektieren
//STRIP001                         pView->UnmarkAllObj();
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001         else if (!rMEvt.IsShift() && rMEvt.IsMod1() && !rMEvt.IsMod2() &&
//STRIP001                  Abs(aPnt.X() - aMDPos.X()) < nDrgLog &&
//STRIP001                  Abs(aPnt.Y() - aMDPos.Y()) < nDrgLog)
//STRIP001         {
//STRIP001             // Gruppe betreten
//STRIP001             pView->MarkObj(aPnt, nHitLog, FALSE, rMEvt.IsMod1());
//STRIP001         }
//STRIP001 
//STRIP001 
//STRIP001         ForcePointer(&rMEvt);
//STRIP001         pHdl = NULL;
//STRIP001         pWindow->ReleaseMouse();
//STRIP001 
//STRIP001         FuDraw::MouseButtonUp(rMEvt);
//STRIP001     }
//STRIP001 
//STRIP001 	return (bReturn);
//STRIP001 }

/*************************************************************************
|*
|* Tastaturereignisse bearbeiten
|*
|* Wird ein KeyEvent bearbeitet, so ist der Return-Wert TRUE, andernfalls
|* FALSE.
|*
\************************************************************************/

//STRIP001 BOOL FuSelection::KeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 	BOOL bSwitchToSelection = FALSE;
//STRIP001 
//STRIP001     switch (rKEvt.GetKeyCode().GetCode())
//STRIP001 	{
//STRIP001 		case KEY_ESCAPE:
//STRIP001 		{
//STRIP001 			bReturn = FuSelection::cancel();
//STRIP001         }
//STRIP001         break;
//STRIP001     }
//STRIP001 
//STRIP001 	if (!bReturn)
//STRIP001 	{
//STRIP001 		bReturn = FuDraw::KeyInput(rKEvt);
//STRIP001 
//STRIP001 		if(pView->GetMarkList().GetMarkCount() == 0)
//STRIP001 		{
//STRIP001 			pView->ShowMirrored();
//STRIP001 	        pView->ResetCreationActive();
//STRIP001 
//STRIP001 			pViewShell->GetViewFrame()->GetDispatcher()->Execute(SID_OBJECT_SELECT, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return(bReturn);
//STRIP001 
//STRIP001 }


/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

/*N*/ void FuSelection::Activate()
/*N*/ {
/*N*/ 	SdrDragMode eMode;
/*N*/     pView->ResetCreationActive();
/*N*/ 	pView->SetEditMode(SDREDITMODE_EDIT);
/*N*/ 
/*N*/ 	switch( nSlotId )
/*N*/ 	{
/*N*/ 		case SID_OBJECT_ROTATE:
/*N*/ 		{
/*?*/ 			// (gemapter) Slot wird explizit auf Rotate gesetzt #31052#
/*?*/ 			if( pViewShell->ISA( SdDrawViewShell) )
/*?*/ 			{
/*?*/ 				USHORT* pSlotArray = ( (SdDrawViewShell*) pViewShell )->GetSlotArray();
/*?*/ 				pSlotArray[ 1 ] = SID_OBJECT_ROTATE;
/*?*/ 			}
/*?*/ 
/*?*/ 			eMode = SDRDRAG_ROTATE;
/*?*/ 
/*?*/ 			if ( pView->GetDragMode() != eMode )
/*?*/ 				pView->SetDragMode(eMode);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_MIRROR:
/*?*/ 		{
/*?*/ 			eMode = SDRDRAG_MIRROR;
/*?*/ 
/*?*/ 			if ( pView->GetDragMode() != eMode )
/*?*/ 				pView->SetDragMode(eMode);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_TRANSPARENCE:
/*?*/ 		{
/*?*/ 			eMode = SDRDRAG_TRANSPARENCE;
/*?*/ 
/*?*/ 			if ( pView->GetDragMode() != eMode )
/*?*/ 				pView->SetDragMode(eMode);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_GRADIENT:
/*?*/ 		{
/*?*/ 			eMode = SDRDRAG_GRADIENT;
/*?*/ 
/*?*/ 			if ( pView->GetDragMode() != eMode )
/*?*/ 				pView->SetDragMode(eMode);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_SHEAR:
/*?*/ 		{
/*?*/ 			eMode = SDRDRAG_SHEAR;
/*?*/ 
/*?*/ 			if ( pView->GetDragMode() != eMode )
/*?*/ 				pView->SetDragMode(eMode);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_CROOK_ROTATE:
/*?*/ 		{
/*?*/ 			eMode = SDRDRAG_CROOK;
/*?*/ 
/*?*/ 			if ( pView->GetDragMode() != eMode )
/*?*/ 			{
/*?*/ 				pView->SetDragMode(eMode);
/*?*/ 				pView->SetCrookMode(SDRCROOK_ROTATE);
/*?*/ 			}
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_CROOK_SLANT:
/*?*/ 		{
/*?*/ 			eMode = SDRDRAG_CROOK;
/*?*/ 
/*?*/ 			if ( pView->GetDragMode() != eMode )
/*?*/ 			{
/*?*/ 				pView->SetDragMode(eMode);
/*?*/ 				pView->SetCrookMode(SDRCROOK_SLANT);
/*?*/ 			}
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OBJECT_CROOK_STRETCH:
/*?*/ 		{
/*?*/ 			eMode = SDRDRAG_CROOK;
/*?*/ 
/*?*/ 			if ( pView->GetDragMode() != eMode )
/*?*/ 			{
/*?*/ 				pView->SetDragMode(eMode);
/*?*/ 				pView->SetCrookMode(SDRCROOK_STRETCH);
/*?*/ 			}
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/         case SID_CONVERT_TO_3D_LATHE:
/*?*/ 		{
/*?*/ 			eMode = SDRDRAG_MIRROR;
/*?*/             bSuppressChangesOfSelection = TRUE;
/*?*/ 
/*?*/ 			if ( pView->GetDragMode() != eMode )
/*?*/ 				pView->SetDragMode(eMode);
/*?*/ 
/*?*/             if (!pView->IsCreationActive())
/*?*/             {DBG_BF_ASSERT(0, "STRIP");} //STRIP001     pView->Start3DCreation();
/*?*/ 
/*?*/             bSuppressChangesOfSelection = FALSE;
/*?*/         }
/*?*/         break;
/*?*/ 
/*N*/ 		default:
/*N*/ 		{
/*N*/ 			eMode = SDRDRAG_MOVE;
/*N*/ 
/*N*/ 			if ( pView->GetDragMode() != eMode )
/*N*/ 				pView->SetDragMode(eMode);
/*N*/ 		}
/*N*/ 		break;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (nSlotId != SID_OBJECT_ROTATE)
/*N*/ 	{
/*N*/ 		bTempRotation = FALSE;
/*N*/ 	}
/*N*/ 
/*N*/ 	FuDraw::Activate();
/*N*/ }



/*************************************************************************
|*
|* Function deaktivieren
|*
\************************************************************************/

/*N*/ void FuSelection::Deactivate()
/*N*/ {
/*N*/ 	FuDraw::Deactivate();
/*N*/ }


/*************************************************************************
|*
|* Selektion hat sich geaendert
|*
\************************************************************************/

/*N*/ void FuSelection::SelectionHasChanged()
/*N*/ {
/*N*/     bSelectionChanged = TRUE;
/*N*/ 
/*N*/     FuDraw::SelectionHasChanged();
/*N*/ 
/*N*/     if ((pView->IsCreationActive() && !bSuppressChangesOfSelection))
/*?*/     {
        // Wechsel Rotationskoerper -> Selektion
/*?*/         pView->ShowMirrored();
/*?*/         pView->ResetCreationActive();
/*?*/         nSlotId = SID_OBJECT_SELECT;
/*?*/         Activate();
/*?*/     }

    /**************************************************************************
    * ObjectBar einschalten
    **************************************************************************/
/*N*/     USHORT nObjBarId;
/*N*/ 
/*N*/     if (pView->GetContext() == SDRCONTEXT_POINTEDIT)
/*N*/         nObjBarId = RID_BEZIER_TOOLBOX;
/*N*/     else if (pView->GetContext() == SDRCONTEXT_GRAPHIC)
/*N*/         nObjBarId = RID_DRAW_GRAF_TOOLBOX;
/*N*/ 	else
/*N*/ 		nObjBarId = RID_DRAW_OBJ_TOOLBOX;
/*N*/ 
/*N*/     pViewShell->SwitchObjectBar(nObjBarId);
/*N*/ }


/*************************************************************************
|*
|* Aktuellen Bezier-Editmodus setzen
|*
\************************************************************************/

//STRIP001 void FuSelection::SetEditMode(USHORT nMode)
//STRIP001 {
//STRIP001     nEditMode = nMode;
//STRIP001 
//STRIP001     if (nEditMode == SID_BEZIER_INSERT)
//STRIP001     {
//STRIP001         pView->SetInsObjPointMode(TRUE);
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         pView->SetInsObjPointMode(FALSE);
//STRIP001     }
//STRIP001 
//STRIP001     ForcePointer();
//STRIP001 
//STRIP001     SfxBindings& rBindings = pViewShell->GetViewFrame()->GetBindings();
//STRIP001     rBindings.Invalidate(SID_BEZIER_MOVE);
//STRIP001     rBindings.Invalidate(SID_BEZIER_INSERT);
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( FuSelection, SoundHasStoppedHdl, void*, p )
//STRIP001 {
//STRIP001 	pSound->SetNotifyHdl( Link() );
//STRIP001 	pSound->SetSoundName( String() );
//STRIP001 	return 0L;
//STRIP001 }


/*************************************************************************
|*
|* Animation oder Interaktion ausfuehren
|*
\************************************************************************/

//STRIP001 BOOL FuSelection::AnimateObj(SdrObject* pObj, const Point& rPos)
//STRIP001 {
//STRIP001 	BOOL bAnimated = FALSE;
//STRIP001     BOOL bClosed = pObj->IsClosedObj();
//STRIP001     BOOL bFilled = FALSE;
//STRIP001 
//STRIP001     if (bClosed)
//STRIP001     {
//STRIP001 	    SfxItemSet aSet(pDoc->GetPool());
//STRIP001 
//STRIP001 //-/        pObj->TakeAttributes(aSet, TRUE, FALSE);
//STRIP001         aSet.Put(pObj->GetItemSet());
//STRIP001 
//STRIP001         const XFillStyleItem& rFillStyle = (const XFillStyleItem&) aSet.Get(XATTR_FILLSTYLE);
//STRIP001 	    bFilled = rFillStyle.GetValue() != XFILL_NONE;
//STRIP001     }
//STRIP001 
//STRIP001     const SetOfByte* pVisiLayer = &pView->GetPageViewPvNum(0)->GetVisibleLayers();
//STRIP001 	USHORT nHitLog = USHORT ( pWindow->PixelToLogic(Size(HITPIX,0)).Width() );
//STRIP001     const long  n2HitLog = nHitLog * 2;
//STRIP001     Point aHitPosR(rPos);
//STRIP001     Point aHitPosL(rPos);
//STRIP001     Point aHitPosT(rPos);
//STRIP001     Point aHitPosB(rPos);
//STRIP001 
//STRIP001     aHitPosR.X() += n2HitLog;
//STRIP001     aHitPosL.X() -= n2HitLog;
//STRIP001     aHitPosT.Y() += n2HitLog;
//STRIP001     aHitPosB.Y() -= n2HitLog;
//STRIP001 
//STRIP001     if ( !bClosed                                      ||
//STRIP001          !bFilled                                      ||
//STRIP001          (pObj->IsHit( aHitPosR, nHitLog, pVisiLayer ) &&
//STRIP001           pObj->IsHit( aHitPosL, nHitLog, pVisiLayer ) &&
//STRIP001           pObj->IsHit( aHitPosT, nHitLog, pVisiLayer ) &&
//STRIP001           pObj->IsHit( aHitPosB, nHitLog, pVisiLayer ) ) )
//STRIP001 	{
//STRIP001 		if ( pDoc->GetIMapInfo( pObj ) )
//STRIP001         {
//STRIP001 	        const IMapObject* pIMapObj = pDoc->GetHitIMapObject( pObj, rPos, *pWindow );
//STRIP001 
//STRIP001             if ( pIMapObj && pIMapObj->GetURL().Len() )
//STRIP001             {
//STRIP001 	            // Sprung zu Dokument
//STRIP001                 pWindow->ReleaseMouse();
//STRIP001                 SfxStringItem aStrItem(SID_FILE_NAME, pIMapObj->GetURL());
//STRIP001                 SfxStringItem aReferer(SID_REFERER, pDocSh->GetMedium()->GetName());
//STRIP001                 SfxViewFrame* pFrame = pViewShell->GetViewFrame();
//STRIP001                 SfxFrameItem aFrameItem(SID_DOCFRAME, pFrame);
//STRIP001                 SfxBoolItem aBrowseItem( SID_BROWSE, TRUE );
//STRIP001                 pWindow->ReleaseMouse();
//STRIP001                 pFrame->GetDispatcher()->
//STRIP001 	                Execute(SID_OPENDOC, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD,
//STRIP001 	                        &aStrItem, &aFrameItem, &aBrowseItem, &aReferer, 0L);
//STRIP001 
//STRIP001 	            bAnimated = TRUE;
//STRIP001 			}
//STRIP001         }
//STRIP001         else if (!pDocSh->ISA(SdGraphicDocShell)        &&
//STRIP001                  pView->ISA(SdDrawView)                 &&
//STRIP001                  ((SdDrawView*) pView)->IsActionMode()  &&
//STRIP001                  pDoc->GetAnimationInfo(pObj))
//STRIP001         {
	        /**********************************************************
	        * Animations-Objekt in der Mitte getroffen -> Interaktion
	        **********************************************************/
//STRIP001 	        SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pObj);
//STRIP001 	        SdDrawViewShell* pDrViewSh = (SdDrawViewShell*) pViewShell;
//STRIP001 	        pWindow->ReleaseMouse();
//STRIP001 
//STRIP001 			switch (pInfo->eClickAction)
//STRIP001             {
//STRIP001 	            case presentation::ClickAction_BOOKMARK:
//STRIP001 	            {
//STRIP001 	 	    	    // Sprung zu Bookmark (Seite oder Objekt)
//STRIP001 	    	        SfxStringItem aItem(SID_NAVIGATOR_OBJECT, pInfo->aBookmark);
//STRIP001 	                pViewShell->GetViewFrame()->GetDispatcher()->
//STRIP001 	                Execute(SID_NAVIGATOR_OBJECT, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD, &aItem, 0L);
//STRIP001                     bAnimated = TRUE;
//STRIP001                 }
//STRIP001                 break;
//STRIP001 
//STRIP001 	            case presentation::ClickAction_DOCUMENT:
//STRIP001 	            {
//STRIP001 	                // Sprung zu Dokument
//STRIP001 	                if (pInfo->aBookmark.Len())
//STRIP001 	                {
//STRIP001 						SfxStringItem aReferer(SID_REFERER, pDocSh->GetMedium()->GetName());
//STRIP001 	                    SfxStringItem aStrItem(SID_FILE_NAME, pInfo->aBookmark);
//STRIP001 	                    SfxViewFrame* pFrame = pViewShell->GetViewFrame();
//STRIP001 	                    SfxFrameItem aFrameItem(SID_DOCFRAME, pFrame);
//STRIP001 	                    SfxBoolItem aBrowseItem( SID_BROWSE, TRUE );
//STRIP001 	                    pFrame->GetDispatcher()->
//STRIP001 	                    Execute(SID_OPENDOC, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD,
//STRIP001 	                            &aStrItem, &aFrameItem, &aBrowseItem, &aReferer, 0L);
//STRIP001 	                }
//STRIP001 
//STRIP001 	                bAnimated = TRUE;
//STRIP001 	            }
//STRIP001 	            break;
//STRIP001 
//STRIP001 	            case presentation::ClickAction_PREVPAGE:
//STRIP001 	            {
//STRIP001 	                // Sprung zur vorherigen Seite
//STRIP001 	                SfxUInt16Item aItem(SID_NAVIGATOR_PAGE, PAGE_PREVIOUS);
//STRIP001 	                pViewShell->GetViewFrame()->GetDispatcher()->
//STRIP001 	                Execute(SID_NAVIGATOR_PAGE, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD,
//STRIP001 	                        &aItem, 0L);
//STRIP001 	                bAnimated = TRUE;
//STRIP001 	            }
//STRIP001 	            break;
//STRIP001 
//STRIP001 	            case presentation::ClickAction_NEXTPAGE:
//STRIP001 	            {
//STRIP001 	                // Sprung zur naechsten Seite
//STRIP001 	                SfxUInt16Item aItem(SID_NAVIGATOR_PAGE, PAGE_NEXT);
//STRIP001 	                pViewShell->GetViewFrame()->GetDispatcher()->
//STRIP001 	                Execute(SID_NAVIGATOR_PAGE, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD,
//STRIP001 	                        &aItem, 0L);
//STRIP001 	                bAnimated = TRUE;
//STRIP001 	            }
//STRIP001 	            break;
//STRIP001 
//STRIP001 	            case presentation::ClickAction_FIRSTPAGE:
//STRIP001 	            {
//STRIP001 	                // Sprung zu erster Seite
//STRIP001 	                SfxUInt16Item aItem(SID_NAVIGATOR_PAGE, PAGE_FIRST);
//STRIP001 	                pViewShell->GetViewFrame()->GetDispatcher()->
//STRIP001 	                Execute(SID_NAVIGATOR_PAGE, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD,
//STRIP001 	                        &aItem, 0L);
//STRIP001 	                bAnimated = TRUE;
//STRIP001 	            }
//STRIP001 	            break;
//STRIP001 
//STRIP001 	            case presentation::ClickAction_LASTPAGE:
//STRIP001 	            {
//STRIP001 	                // Sprung zu letzter Seite
//STRIP001 	                SfxUInt16Item aItem(SID_NAVIGATOR_PAGE, PAGE_LAST);
//STRIP001 	                pViewShell->GetViewFrame()->GetDispatcher()->
//STRIP001 	                Execute(SID_NAVIGATOR_PAGE, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD,
//STRIP001 	                        &aItem, 0L);
//STRIP001 	                bAnimated = TRUE;
//STRIP001 	            }
//STRIP001 	            break;
//STRIP001 
//STRIP001 	            case presentation::ClickAction_SOUND:
//STRIP001 	            {
//STRIP001 	                // Sound asynchron abspielen
//STRIP001 	                if( !pSound )
//STRIP001 	                {
//STRIP001 	                    pSound = new Sound();
//STRIP001 	                }
//STRIP001 
//STRIP001 	                pSound->SetNotifyHdl( LINK( this, FuSelection, SoundHasStoppedHdl ) );
//STRIP001 					pSound->SetSoundName( pInfo->aBookmark );
//STRIP001 	                pSound->Play();
//STRIP001 	                bAnimated = TRUE;
//STRIP001 	            }
//STRIP001 	            break;
//STRIP001 
//STRIP001 	            case presentation::ClickAction_VERB:
//STRIP001 	            {
//STRIP001 	                // Verb zuweisen
//STRIP001 	                pView->UnmarkAll();
//STRIP001 	                pView->MarkObj(pObj, pView->GetPageViewPvNum(0), FALSE, FALSE);
//STRIP001 	                pDrViewSh->DoVerb(pInfo->nVerb);
//STRIP001 	                bAnimated = TRUE;
//STRIP001 	            }
//STRIP001 	            break;
//STRIP001 
//STRIP001 	            case presentation::ClickAction_PROGRAM:
//STRIP001 	            {
//STRIP001 				   INetURLObject aURL( so3::StaticBaseUrl::SmartRelToAbs( pInfo->aBookmark, FALSE, INetURLObject::WAS_ENCODED, INetURLObject::DECODE_UNAMBIGUOUS ) );
//STRIP001 
//STRIP001 			       if( INET_PROT_FILE == aURL.GetProtocol() )
//STRIP001 				   {
//STRIP001 					   ::vos::OProcess                 aApp( aURL.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 					   ::vos::OArgumentList	           aParameters;
//STRIP001 					   ::vos::OProcess::TProcessError  eError = aApp.execute( (::vos::OProcess::TProcessOption) ( ::vos::OProcess::TOption_SearchPath |
//STRIP001 																												  ::vos::OProcess::TOption_Detached ),
//STRIP001 																			  aParameters );
//STRIP001 				   }
//STRIP001 
//STRIP001                     bAnimated = TRUE;
//STRIP001 	            }
//STRIP001 	            break;
//STRIP001 
//STRIP001 	            case presentation::ClickAction_MACRO:
//STRIP001 	            {
//STRIP001 	                // Execute makro
//STRIP001 	                String aMacro = pInfo->aBookmark;
//STRIP001 
//STRIP001 					// aMacro has got following format:
//STRIP001 	                // "Macroname.Modulname.Libname.Documentname" or
//STRIP001 	                // "Macroname.Modulname.Libname.Applicationsname"
//STRIP001 	                String aMacroName = aMacro.GetToken(0, sal_Unicode('.'));
//STRIP001 	                String aModulName = aMacro.GetToken(1, sal_Unicode('.'));
//STRIP001 	                String aLibName   = aMacro.GetToken(2, sal_Unicode('.'));
//STRIP001 	                String aDocName   = aMacro.GetToken(3, sal_Unicode('.'));
//STRIP001 
//STRIP001 					// In this moment the Call-method only
//STRIP001 					// resolves modulename+macroname
//STRIP001 	                String aExecMacro(aModulName);
//STRIP001 	                aExecMacro.Append( sal_Unicode('.') );
//STRIP001 	                aExecMacro.Append( aMacroName );
//STRIP001 	                bAnimated = pDocSh->GetBasic()->Call(aExecMacro);
//STRIP001 	            }
//STRIP001 	            break;
//STRIP001 
//STRIP001 	            default:
//STRIP001 	            {
//STRIP001 	                bAnimated = FALSE;
//STRIP001 	            }
//STRIP001 	            break;
//STRIP001 	        }
//STRIP001         }
//STRIP001 
//STRIP001 		if (!bAnimated                               &&
//STRIP001 	    	pView->ISA(SdDrawView)                 &&
//STRIP001 	    	!pDocSh->ISA(SdGraphicDocShell)        &&
//STRIP001 	    	((SdDrawView*) pView)->GetSlideShow()  &&
//STRIP001 	    	pDoc->GetAnimationInfo(pObj))
//STRIP001 		{
	    	/**********************************************************
	    	* Effekt-Objekt in der Mitte getroffen -> Effekt abspielen
	    	**********************************************************/
//STRIP001 	    	SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pObj);
//STRIP001 	    	SdDrawViewShell* pDrViewSh = (SdDrawViewShell*) pViewShell;
//STRIP001 
//STRIP001 	    	switch (pInfo->eClickAction)
//STRIP001 	    	{
//STRIP001 	        	case presentation::ClickAction_VANISH:
//STRIP001 	        	case presentation::ClickAction_INVISIBLE:
//STRIP001 	        	{
//STRIP001 	            	if (((SdDrawView*) pView)->GetSlideShow())
//STRIP001 	            	{
//STRIP001 	                	// Objekt ausblenden
//STRIP001 	                	bHideAndAnimate = TRUE;
//STRIP001 	                	pDrViewSh->LockInput();
//STRIP001 	                	((SdDrawView*) pView)->HideAndAnimateObject(pObj);
//STRIP001 	                	pDrViewSh->UnlockInput();
//STRIP001 	                	pWindow->ReleaseMouse();
//STRIP001 	                	bAnimated = TRUE;
//STRIP001 	            	}
//STRIP001 	        	}
//STRIP001 	        	break;
//STRIP001 
//STRIP001 	        	default:
//STRIP001 	        	{
//STRIP001 	            	bAnimated = FALSE;
//STRIP001 	        	}
//STRIP001 	        	break;
//STRIP001 	    	}
//STRIP001 
//STRIP001 	    	if (!bAnimated && ((SdDrawView*) pView)->GetSlideShow() &&
//STRIP001 	        	( pInfo->bActive &&
//STRIP001 					( pInfo->eEffect != presentation::AnimationEffect_NONE ||
//STRIP001 					pInfo->eTextEffect != presentation::AnimationEffect_NONE )))
//STRIP001 	    	{
//STRIP001 	        	// Objekt ausblenden
//STRIP001 	        	bHideAndAnimate = TRUE;
//STRIP001 	        	pDrViewSh->LockInput();
//STRIP001 	        	((SdDrawView*) pView)->HideAndAnimateObject(pObj);
//STRIP001 	        	pDrViewSh->UnlockInput();
//STRIP001 	        	pWindow->ReleaseMouse();
//STRIP001 	        	bAnimated = TRUE;
//STRIP001 	    	}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bAnimated;
//STRIP001 }



/** is called when the currenct function should be aborted. <p>
	This is used when a function gets a KEY_ESCAPE but can also
	be called directly.

	@returns true if a active function was aborted
*/
//STRIP001 bool FuSelection::cancel()
//STRIP001 {
//STRIP001     if (pView->IsCreationActive())
//STRIP001 	{
//STRIP001 		pView->ShowMirrored();
//STRIP001 		pView->ResetCreationActive();
//STRIP001 
//STRIP001 		pViewShell->GetViewFrame()->GetDispatcher()->Execute(SID_OBJECT_SELECT, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 		return true;
//STRIP001     }
//STRIP001 	else
//STRIP001 	{
//STRIP001 		return false;
//STRIP001 	}
//STRIP001 }




//STRIP001 SdrObject* FuSelection::pickObject (const Point& rTestPoint)
//STRIP001 {
//STRIP001 	SdrObject* pObject = NULL;
//STRIP001     SdrPageView* pPageView;
//STRIP001 	USHORT nHitLog = USHORT (pWindow->PixelToLogic(Size(HITPIX,0)).Width());
//STRIP001 	pView->PickObj (rTestPoint, nHitLog, pObject, pPageView, SDRSEARCH_PICKMARKABLE);
//STRIP001     return pObject;
//STRIP001 }
}
