/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_mover.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:23:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include <math.h>
// auto strip #include <tools/debug.hxx>
// auto strip #include <tools/poly.hxx>
// auto strip #include <vcl/wrkwin.hxx>
// auto strip #include <vcl/svapp.hxx>
// auto strip #include <bf_svx/xpoly.hxx>
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #include "mover.hxx"
// auto strip #include "fuslshow.hxx"
// auto strip #include "sprite.hxx"
// auto strip #include "showview.hxx"
// auto strip #include "docshell.hxx"
// auto strip #include "viewshel.hxx"
// auto strip #include "sdview.hxx"
namespace binfilter {

// -----------
// - Defines -
// -----------

#define SDBITMAPMOVER_PATHTYPE_UNDEFINED	0
#define SDBITMAPMOVER_PATHTYPE_LINE 		1
#define MOVER_MAGIC							0x23456789

// -----------------
// - SdBitmapMover -
// -----------------

//STRIP001 SdBitmapMover::SdBitmapMover( Window* pWindow, FuSlideShow* pFu ) :
//STRIP001 	pWin			( pWindow ),
//STRIP001 	pFuSlideShow	( pFu ),
//STRIP001 	pListOfImages	( NULL ),
//STRIP001 	pPolygon		( NULL ),
//STRIP001 	pInitDev		( NULL ),
//STRIP001 	pTopLayer		( NULL ),
//STRIP001 	ppTopMtf		( NULL ),
//STRIP001 	nMulti			( 1UL ),
//STRIP001 	nMagic			( MOVER_MAGIC )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SdBitmapMover::~SdBitmapMover()
//STRIP001 {
//STRIP001 	nMagic = 0L;
//STRIP001 	delete pPolygon;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdBitmapMover::SetPath( const Point& rStart, const Point& rEnd,
//STRIP001 							 const double* pStartScaleX, const double* pEndScaleX, 
//STRIP001 							 const double* pStartScaleY, const double* pEndScaleY )
//STRIP001 {
//STRIP001 	delete pPolygon;
//STRIP001 	pPolygon = new Polygon( 2 );
//STRIP001 	(*pPolygon)[ 0 ] = rStart;
//STRIP001 	(*pPolygon)[ 1 ] = rEnd;
//STRIP001 
//STRIP001 	mfStartScaleX = ( pStartScaleX ? *pStartScaleX : 1.0 );
//STRIP001 	mfEndScaleX = ( pEndScaleX ? *pEndScaleX : 1.0 );
//STRIP001 	
//STRIP001 	mfStartScaleY = ( pStartScaleY ? *pStartScaleY : 1.0 );
//STRIP001 	mfEndScaleY = ( pEndScaleY ? *pEndScaleY : 1.0 );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdBitmapMover::SetPath( const XPolyPolygon& rXPolyPolygon, 
//STRIP001 							 const double* pStartScaleX, const double* pEndScaleX,
//STRIP001 							 const double* pStartScaleY, const double* pEndScaleY )
//STRIP001 {
//STRIP001 	ULONG			nTotal = 0L;
//STRIP001 	ULONG			nMax = USHRT_MAX;
//STRIP001 	const USHORT	nXPoly = rXPolyPolygon.Count();
//STRIP001 	USHORT			n;
//STRIP001 
//STRIP001 	for ( n = 0; n < nXPoly; n++ )
//STRIP001 		nTotal += rXPolyPolygon.GetObject( n ).GetPointCount();
//STRIP001 
//STRIP001 	delete pPolygon;
//STRIP001 	pPolygon = new Polygon( (USHORT) Min( nMax, nTotal ) );
//STRIP001 
//STRIP001 	for( nTotal = n = 0; ( n < nXPoly ) && ( nTotal <= nMax ); n++ )
//STRIP001 	{
//STRIP001 		const XPolygon& rXPoly = rXPolyPolygon.GetObject( n );
//STRIP001 		USHORT			nPoints = rXPoly.GetPointCount();
//STRIP001 
//STRIP001 		for( USHORT i = 0; ( i < nPoints ) && ( nTotal <= nMax ); i++ )
//STRIP001 			(*pPolygon)[ (USHORT) ( nTotal++ ) ] = rXPoly[ i ];
//STRIP001 	}
//STRIP001 
//STRIP001 	mfStartScaleX = ( pStartScaleX ? *pStartScaleX : 1.0 );
//STRIP001 	mfEndScaleX = ( pEndScaleX ? *pEndScaleX : 1.0 );
//STRIP001 
//STRIP001 	mfStartScaleY = ( pStartScaleY ? *pStartScaleY : 1.0 );
//STRIP001 	mfEndScaleY = ( pEndScaleY ? *pEndScaleY : 1.0 );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SdBitmapMover::Move()
//STRIP001 {
//STRIP001 	DBG_ASSERT( pWin, "kein Fenster gesetzt" );
//STRIP001 	DBG_ASSERT( pListOfImages, "kein Liste gesetzt" );
//STRIP001 	DBG_ASSERT( pPolygon, "kein Polygon" );
//STRIP001 
//STRIP001 	Sprite			aSprite( pListOfImages );
//STRIP001 	const Region	aOldRegion( pWin->GetClipRegion() );
//STRIP001 	const Polygon&	rPoly = *pPolygon;
//STRIP001 	const USHORT	nPolySize = rPoly.GetSize();
//STRIP001 	const ULONG		nImageCount = (USHORT) pListOfImages->Count();
//STRIP001 	const BOOL		bIsClipRegion = pWin->IsClipRegion();
//STRIP001 	BOOL			bRet;
//STRIP001 
//STRIP001 	// Clip-Region setzen
//STRIP001 	if( !aClip.IsEmpty() )
//STRIP001 		pWin->SetClipRegion( aClip );
//STRIP001 
//STRIP001 	bRet = aSprite.StartMoving( pWin,pInitDev, pTopLayer, ppTopMtf, &aObjStartMarker, &aObjEndMarker );
//STRIP001 
//STRIP001 	if( bRet )
//STRIP001 	{
//STRIP001 		Application*	pApp = GetpApp();
//STRIP001 		SdView*			pView;
//STRIP001 		SdrPageView*	pPageView;
//STRIP001 		BOOL			bGrid = FALSE;
//STRIP001 
//STRIP001 		if( pFuSlideShow->GetAnimationMode() == ANIMATIONMODE_VIEW )
//STRIP001 		{
//STRIP001 			pView = pFuSlideShow->GetDocSh()->GetViewShell()->GetView();
//STRIP001 
//STRIP001 			if( pView->IsGridVisible() && pView->IsGridFront() )
//STRIP001 			{
//STRIP001 				pPageView = pView->GetPageView( (SdrPage*) pFuSlideShow->GetActualPage() );
//STRIP001 				bGrid = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( ( rPoly.GetSize() == 2 ) && ( rPoly[ 0 ] == rPoly[ 1 ] ) && ( nImageCount > 1 ) )
//STRIP001 		{
//STRIP001 			// Apspielen einer Sequenz an gleicher Stelle
//STRIP001 			const Point&	rPt = rPoly[ 0 ];
//STRIP001 			const ULONG		nLastTime = Time::GetSystemTicks();
//STRIP001 			ULONG			nTime = 250UL;
//STRIP001 
//STRIP001 			for( ULONG i = 0UL; ( i < nImageCount ) && ( nMagic == MOVER_MAGIC ); i++ )
//STRIP001 			{
//STRIP001 				const ULONG nLastTime = Time::GetSystemTicks();
//STRIP001 
//STRIP001 				aSprite.MoveTo( pWin, rPt );
//STRIP001 
//STRIP001 				if( bGrid )
//STRIP001 				{
//STRIP001 					const BOOL bOldMap = pWin->IsMapModeEnabled();
//STRIP001 					pWin->EnableMapMode( TRUE );
//STRIP001 					pPageView->DrawGrid( *pWin, pView->GetGridColor() );
//STRIP001 					pWin->EnableMapMode( bOldMap );
//STRIP001 				}
//STRIP001 
//STRIP001 				while( ( Time::GetSystemTicks() - nLastTime ) < nTime )
//STRIP001 				{
//STRIP001 					if( nMagic != MOVER_MAGIC )
//STRIP001 						break;
//STRIP001 
//STRIP001 					pApp->Reschedule();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// tatsaechliche Bewegung
//STRIP001 			Point			aPt;
//STRIP001 			double			fScaleX, fScaleY;
//STRIP001 			ULONG			nUnitsPerSec;
//STRIP001 			BOOL			bCont;
//STRIP001 
//STRIP001 			switch( eSpeed )
//STRIP001 			{
//STRIP001 				case( MOVE_SPEED_SLOW ):	nUnitsPerSec = 10000; break;
//STRIP001 				case( MOVE_SPEED_FAST ):	nUnitsPerSec = 56000; break;
//STRIP001 				default:					nUnitsPerSec = 32000; break;
//STRIP001 			}
//STRIP001 
//STRIP001 			aCtrl.Reset( rPoly, pWin, ( nMulti > 1UL ) ? nUnitsPerSec * nMulti : nUnitsPerSec,
//STRIP001 						 mfStartScaleX, mfEndScaleX, mfStartScaleY, mfEndScaleY );
//STRIP001 
//STRIP001 			do
//STRIP001 			{
//STRIP001 				if( nMagic != MOVER_MAGIC )
//STRIP001 					break;
//STRIP001 
//STRIP001 				bCont = aCtrl.GetNextPathPoint( aPt, fScaleX, fScaleY );
//STRIP001 
//STRIP001 				if( nMagic != MOVER_MAGIC )
//STRIP001 					break;
//STRIP001 
//STRIP001 				aSprite.MoveTo( pWin, aPt, fScaleX, fScaleY );
//STRIP001 
//STRIP001 				if( bGrid )
//STRIP001 				{
//STRIP001 					const BOOL bOldMap = pWin->IsMapModeEnabled();
//STRIP001 					pWin->EnableMapMode( TRUE );
//STRIP001 					pPageView->DrawGrid( *pWin, pView->GetGridColor() );
//STRIP001 					pWin->EnableMapMode( bOldMap );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			while( bCont );
//STRIP001 		}
//STRIP001 
//STRIP001 		// Falls wir zerstoert wurden, nicht mehr auf das Window zugreifen
//STRIP001 		if( MOVER_MAGIC == nMagic )
//STRIP001 		{
//STRIP001 			aSprite.EndMoving( pWin );
//STRIP001             pWin->Sync();
//STRIP001 
//STRIP001 			// ClipRegion zuruecksetzen
//STRIP001 			if( bIsClipRegion )
//STRIP001 				pWin->SetClipRegion( aOldRegion );
//STRIP001 			else
//STRIP001 				pWin->SetClipRegion();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
}
