/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_SdOutlinerIterator.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:33:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #include "SdOutlinerIterator.hxx"
#include "SdOutlinerIteratorImpl.hxx"

// auto strip #ifndef _SVDITER_HXX
// auto strip #include <bf_svx/svditer.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWFRM_HXX
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif

// auto strip #include "sdoutl.hxx"

// auto strip #include "drawdoc.hxx"
// auto strip #include "drviewsh.hxx"
// auto strip #include "drawview.hxx"
// auto strip #include "sdpage.hxx"
// auto strip #include "frmview.hxx"
// auto strip #include "docshell.hxx"
// auto strip #include "sdwindow.hxx"
namespace binfilter {

namespace sd { namespace outliner {


//===== IteratorPosition ======================================================

/*N*/ IteratorPosition::IteratorPosition (void)
/*N*/     : mpObject(NULL),mnPageIndex(-1),//mpView(NULL), 
/*N*/       mePageKind(PK_STANDARD), meEditMode(EM_PAGE)
/*N*/ {}

//STRIP001 IteratorPosition::IteratorPosition (const IteratorPosition& aPosition)
//STRIP001     : mpObject(aPosition.mpObject),
//STRIP001       mnPageIndex(aPosition.mnPageIndex),
//STRIP001       //      mpView(aPosition.mpView),
//STRIP001       mePageKind(aPosition.mePageKind),
//STRIP001       meEditMode(aPosition.meEditMode)
//STRIP001 {}

//STRIP001 IteratorPosition::IteratorPosition (SdrObject* pObject, sal_Int32 nPageIndex,// SdView* pView,
//STRIP001     PageKind ePageKind, EditMode eEditMode)
//STRIP001     : mpObject(pObject),
//STRIP001       mnPageIndex(nPageIndex),
//STRIP001       //      mpView(pView),
//STRIP001       mePageKind(ePageKind),
//STRIP001       meEditMode(eEditMode)
//STRIP001 {}

/*N*/ IteratorPosition::~IteratorPosition (void)
/*N*/ {}

//STRIP001 IteratorPosition& IteratorPosition::operator= (const IteratorPosition& aPosition)
//STRIP001 {
//STRIP001     mpObject = aPosition.mpObject;
//STRIP001     mnPageIndex = aPosition.mnPageIndex;
//STRIP001     //    mpView = aPosition.mpView;
//STRIP001     mePageKind = aPosition.mePageKind;
//STRIP001     meEditMode = aPosition.meEditMode;
//STRIP001     return *this;
//STRIP001 }

//STRIP001 bool IteratorPosition::operator== (const IteratorPosition& aPosition) const
//STRIP001 {
//STRIP001     return mpObject == aPosition.mpObject
//STRIP001         && mnPageIndex == aPosition.mnPageIndex
//STRIP001         //        && mpView == aPosition.mpView
//STRIP001         && mePageKind == aPosition.mePageKind
//STRIP001         && meEditMode == aPosition.meEditMode;
//STRIP001 }




//===== Iterator ==============================================================

/*N*/ Iterator::Iterator (void)
/*N*/ {
/*N*/     mpIterator = NULL;
/*N*/ }

//STRIP001 Iterator::Iterator (IteratorImplBase* pObject)
//STRIP001 {
//STRIP001     mpIterator = pObject;
//STRIP001 }

//STRIP001 Iterator::Iterator (const IteratorImplBase& rObject)
//STRIP001 {
//STRIP001     mpIterator = rObject.Clone();
//STRIP001 }

/*N*/ Iterator::~Iterator (void)
/*N*/ {
/*N*/     delete mpIterator;
/*N*/ }

//STRIP001 Iterator& Iterator::operator= (const Iterator& rIterator)
//STRIP001 {
//STRIP001     if (this != &rIterator)
//STRIP001     {
//STRIP001         delete mpIterator;
//STRIP001         if (rIterator.mpIterator != NULL)
//STRIP001             mpIterator = rIterator.mpIterator->Clone();
//STRIP001         else
//STRIP001             mpIterator = NULL;
//STRIP001     }
//STRIP001     return *this;
//STRIP001 }

//STRIP001 const IteratorPosition& Iterator::operator* () const
//STRIP001 {
//STRIP001     DBG_ASSERT (mpIterator!=NULL, "::sd::outliner::Iterator::operator* : missing implementation object");
//STRIP001     return mpIterator->GetPosition();
//STRIP001 }

//STRIP001 Iterator& Iterator::operator++ ()
//STRIP001 {
//STRIP001     if (mpIterator!=NULL)
//STRIP001         mpIterator->GotoNextObject();
//STRIP001     return *this;
//STRIP001 }

//STRIP001 Iterator Iterator::operator++ (int)
//STRIP001 {
//STRIP001     Iterator aTmp = *this;
//STRIP001     if (mpIterator!=NULL)
//STRIP001         mpIterator->GotoNextObject();
//STRIP001     return aTmp;
//STRIP001 }

//STRIP001 bool Iterator::operator== (const Iterator& rIterator)
//STRIP001 {
//STRIP001     if (mpIterator == NULL || rIterator.mpIterator==NULL)
//STRIP001         return mpIterator == rIterator.mpIterator;
//STRIP001     else
//STRIP001         return *mpIterator == *rIterator.mpIterator;
//STRIP001 }

//STRIP001 bool Iterator::operator!= (const Iterator& rIterator)
//STRIP001 {
//STRIP001     return ! operator==(rIterator);
//STRIP001 }




//STRIP001 void Iterator::Reverse (void)
//STRIP001 {
//STRIP001     if (mpIterator != NULL)
//STRIP001         mpIterator->Reverse();
//STRIP001 }




//===== IteratorFactory =======================================================

//STRIP001 OutlinerContainer::OutlinerContainer (SdOutliner* pOutliner)
//STRIP001     : mpOutliner(pOutliner)
//STRIP001 {}

//STRIP001 Iterator OutlinerContainer::begin (void)
//STRIP001 {
//STRIP001     return CreateIterator (BEGIN);
//STRIP001 }

//STRIP001 Iterator OutlinerContainer::end (void)
//STRIP001 {
//STRIP001     return CreateIterator (END);
//STRIP001 }

//STRIP001 Iterator OutlinerContainer::current (void)
//STRIP001 {
//STRIP001     return CreateIterator (CURRENT);
//STRIP001 }



//STRIP001 Iterator OutlinerContainer::CreateIterator (IteratorLocation aLocation)
//STRIP001 {
//STRIP001     // Decide on certain features of the outliner which kind of iterator to
//STRIP001     // use.
//STRIP001     if (mpOutliner->mbRestrictSearchToSelection)
//STRIP001         // There is a selection.  Search only in this.
//STRIP001         return CreateSelectionIterator (
//STRIP001             mpOutliner->maMarkListCopy,
//STRIP001             mpOutliner->mpDrawDocument,
//STRIP001             static_cast<SdDrawViewShell*>(mpOutliner->mpViewShell),
//STRIP001             mpOutliner->mbDirectionIsForward,
//STRIP001             aLocation);
//STRIP001     else
//STRIP001         // Search in the whole document.
//STRIP001         return CreateDocumentIterator (
//STRIP001             mpOutliner->mpDrawDocument,
//STRIP001             static_cast<SdDrawViewShell*>(mpOutliner->mpViewShell),
//STRIP001             mpOutliner->mbDirectionIsForward,
//STRIP001             aLocation);
//STRIP001 }




//STRIP001 Iterator OutlinerContainer::CreateSelectionIterator (
//STRIP001     const ::std::vector<SdrObject*>& rObjectList,
//STRIP001     SdDrawDocument* pDocument,
//STRIP001     SdDrawViewShell* pViewShell,
//STRIP001     bool bDirectionIsForward, 
//STRIP001     IteratorLocation aLocation)
//STRIP001 {
//STRIP001     sal_Int32 nObjectIndex;
//STRIP001 
//STRIP001     if (bDirectionIsForward)
//STRIP001         switch (aLocation)
//STRIP001         {
//STRIP001             case CURRENT:
//STRIP001             case BEGIN: 
//STRIP001             default:
//STRIP001                 nObjectIndex = 0;
//STRIP001                 break;
//STRIP001             case END:
//STRIP001                 nObjectIndex = rObjectList.size();
//STRIP001                 break;
//STRIP001         }
//STRIP001     else
//STRIP001         switch (aLocation)
//STRIP001         {
//STRIP001             case CURRENT:
//STRIP001             case BEGIN: 
//STRIP001             default:
//STRIP001                 nObjectIndex = rObjectList.size()-1;
//STRIP001                 break;
//STRIP001             case END:
//STRIP001                 nObjectIndex = -1;
//STRIP001                 break;
//STRIP001         }
//STRIP001 
//STRIP001     return Iterator (new SelectionIteratorImpl (
//STRIP001         rObjectList, nObjectIndex, pDocument, pViewShell, bDirectionIsForward));
//STRIP001 }

//STRIP001 Iterator OutlinerContainer::CreateViewIterator (
//STRIP001     SdDrawDocument* pDocument, 
//STRIP001     SdDrawViewShell* pViewShell,
//STRIP001     bool bDirectionIsForward,
//STRIP001     IteratorLocation aLocation)
//STRIP001 {
//STRIP001     sal_Int32 nPageIndex = GetPageIndex (pDocument, pViewShell,
//STRIP001         pViewShell->GetPageKind(), pViewShell->GetEditMode(),
//STRIP001         bDirectionIsForward, aLocation);
//STRIP001 
//STRIP001     return Iterator (new ViewIteratorImpl (
//STRIP001         nPageIndex, pDocument, pViewShell, bDirectionIsForward));
//STRIP001 }

//STRIP001 Iterator OutlinerContainer::CreateDocumentIterator (
//STRIP001     SdDrawDocument* pDocument, 
//STRIP001     SdDrawViewShell* pViewShell,
//STRIP001     bool bDirectionIsForward, 
//STRIP001     IteratorLocation aLocation)
//STRIP001 {
//STRIP001     PageKind ePageKind;
//STRIP001     EditMode eEditMode;
//STRIP001 
//STRIP001     if (bDirectionIsForward)
//STRIP001         switch (aLocation)
//STRIP001         {
//STRIP001             case BEGIN:
//STRIP001             default:
//STRIP001                 ePageKind = PK_STANDARD;
//STRIP001                 eEditMode = EM_PAGE;
//STRIP001                 break;
//STRIP001             case END:
//STRIP001                 ePageKind = PK_HANDOUT;
//STRIP001                 eEditMode = EM_MASTERPAGE;
//STRIP001                 break;
//STRIP001             case CURRENT:
//STRIP001                 ePageKind = pViewShell->GetPageKind();
//STRIP001                 eEditMode = pViewShell->GetEditMode();
//STRIP001                 break;
//STRIP001         }
//STRIP001     else
//STRIP001         switch (aLocation)
//STRIP001         {
//STRIP001             case BEGIN:
//STRIP001             default:
//STRIP001                 ePageKind = PK_HANDOUT;
//STRIP001                 eEditMode = EM_MASTERPAGE;
//STRIP001                 break;
//STRIP001             case END:
//STRIP001                 ePageKind = PK_STANDARD;
//STRIP001                 eEditMode = EM_PAGE;
//STRIP001                 break;
//STRIP001             case CURRENT:
//STRIP001                 ePageKind = pViewShell->GetPageKind();
//STRIP001                 eEditMode = pViewShell->GetEditMode();
//STRIP001                 break;
//STRIP001         }
//STRIP001 
//STRIP001     sal_Int32 nPageIndex = GetPageIndex (pDocument, pViewShell, 
//STRIP001         ePageKind, eEditMode, bDirectionIsForward, aLocation);
//STRIP001 
//STRIP001     return Iterator (
//STRIP001         new DocumentIteratorImpl (nPageIndex, ePageKind, eEditMode,
//STRIP001             pDocument, pViewShell, bDirectionIsForward));
//STRIP001 }

//STRIP001 sal_Int32 OutlinerContainer::GetPageIndex (
//STRIP001     SdDrawDocument* pDocument,
//STRIP001     SdDrawViewShell* pViewShell,
//STRIP001     PageKind ePageKind, 
//STRIP001     EditMode eEditMode,
//STRIP001     bool bDirectionIsForward,
//STRIP001     IteratorLocation aLocation)
//STRIP001 {
//STRIP001     sal_Int32 nPageIndex;
//STRIP001     sal_Int32 nPageCount;
//STRIP001 
//STRIP001     switch (eEditMode)
//STRIP001     {
//STRIP001         case EM_PAGE:
//STRIP001             nPageCount = pDocument->GetSdPageCount (ePageKind);
//STRIP001             break;
//STRIP001         case EM_MASTERPAGE:
//STRIP001             nPageCount = pDocument->GetMasterSdPageCount(ePageKind);
//STRIP001             break;
//STRIP001         default:
//STRIP001             nPageCount = 0;
//STRIP001     }
//STRIP001 
//STRIP001     if (bDirectionIsForward)
//STRIP001         switch (aLocation)
//STRIP001         {
//STRIP001             case CURRENT:
//STRIP001                 nPageIndex = pViewShell->GetCurPageId() - 1;
//STRIP001                 break;
//STRIP001             case BEGIN: 
//STRIP001             default:
//STRIP001                 nPageIndex = 0;
//STRIP001                 break;
//STRIP001             case END:
//STRIP001                 nPageIndex = nPageCount;
//STRIP001                 break;
//STRIP001         }
//STRIP001     else
//STRIP001         switch (aLocation)
//STRIP001         {
//STRIP001             case CURRENT:
//STRIP001                 nPageIndex = pViewShell->GetCurPageId() - 1;
//STRIP001                 break;
//STRIP001             case BEGIN: 
//STRIP001             default:
//STRIP001                 nPageIndex = nPageCount-1;
//STRIP001                 break;
//STRIP001             case END:
//STRIP001                 nPageIndex = -1;
//STRIP001                 break;
//STRIP001         }
//STRIP001 
//STRIP001     return nPageIndex;
//STRIP001 }




//===== IteratorImplBase ====================================================

//STRIP001 IteratorImplBase::IteratorImplBase (
//STRIP001     SdDrawDocument* pDocument, 
//STRIP001     SdDrawViewShell* pViewShell,
//STRIP001     bool bDirectionIsForward)
//STRIP001     : mpDocument (pDocument),
//STRIP001       mpViewShell (pViewShell),
//STRIP001       maPosition(),
//STRIP001       mbDirectionIsForward (bDirectionIsForward)
//STRIP001 {
//STRIP001     maPosition.mePageKind = pViewShell->GetPageKind();
//STRIP001     maPosition.meEditMode = pViewShell->GetEditMode();
//STRIP001 }

//STRIP001 IteratorImplBase::IteratorImplBase (
//STRIP001     SdDrawDocument* pDocument, 
//STRIP001     SdDrawViewShell* pViewShell,
//STRIP001     bool bDirectionIsForward,
//STRIP001     PageKind ePageKind,
//STRIP001     EditMode eEditMode)
//STRIP001     : mpDocument (pDocument),
//STRIP001       mpViewShell (pViewShell),
//STRIP001       maPosition(),
//STRIP001       mbDirectionIsForward (bDirectionIsForward)
//STRIP001 {
//STRIP001     maPosition.mePageKind = ePageKind;
//STRIP001     maPosition.meEditMode = eEditMode;
//STRIP001 }

//STRIP001 IteratorImplBase::~IteratorImplBase (void)
//STRIP001 {}

//STRIP001 bool IteratorImplBase::operator== (const IteratorImplBase& rIterator) const
//STRIP001 {
//STRIP001     return maPosition == rIterator.maPosition;
//STRIP001 }

//STRIP001 bool IteratorImplBase::IsEqual (const IteratorImplBase& rIterator, IteratorType aType) const
//STRIP001 {
//STRIP001     // When this method is executed instead of the ones from derived classes
//STRIP001     // then the argument is of another type then the object itself.  In this
//STRIP001     // just compare the position objects.
//STRIP001     return maPosition == rIterator.maPosition;
//STRIP001 }

//STRIP001 const IteratorPosition& IteratorImplBase::GetPosition (void)
//STRIP001 {
//STRIP001     return maPosition;
//STRIP001 }




//STRIP001 IteratorImplBase* IteratorImplBase::Clone (IteratorImplBase* pObject) const
//STRIP001 {
//STRIP001     if (pObject != NULL)
//STRIP001     {
//STRIP001         pObject->maPosition = maPosition;
//STRIP001         pObject->mpDocument = mpDocument;
//STRIP001         pObject->mpViewShell = mpViewShell;
//STRIP001         pObject->mbDirectionIsForward = mbDirectionIsForward;
//STRIP001     }
//STRIP001     return pObject;
//STRIP001 }



//STRIP001 void IteratorImplBase::Reverse (void)
//STRIP001 {
//STRIP001     mbDirectionIsForward = ! mbDirectionIsForward;
//STRIP001 }



//===== SelectionIteratorImpl ===========================================

//STRIP001 SelectionIteratorImpl::SelectionIteratorImpl (
//STRIP001     const ::std::vector<SdrObject*>& rObjectList,
//STRIP001     sal_Int32 nObjectIndex,
//STRIP001     SdDrawDocument* pDocument, 
//STRIP001     SdDrawViewShell* pViewShell,
//STRIP001     bool bDirectionIsForward)
//STRIP001     : IteratorImplBase (pDocument, pViewShell, bDirectionIsForward),
//STRIP001       mrObjectList(rObjectList),
//STRIP001       mnObjectIndex(nObjectIndex)
//STRIP001 {}

//STRIP001 SelectionIteratorImpl::~SelectionIteratorImpl (void)
//STRIP001 {}

//STRIP001 IteratorImplBase* SelectionIteratorImpl::Clone (IteratorImplBase* pObject) const
//STRIP001 {
//STRIP001     SelectionIteratorImpl* pIterator = static_cast<SelectionIteratorImpl*>(pObject);
//STRIP001     if (pIterator == NULL)
//STRIP001         pIterator = new SelectionIteratorImpl (
//STRIP001             mrObjectList, mnObjectIndex, mpDocument, mpViewShell, mbDirectionIsForward);
//STRIP001     return pIterator;
//STRIP001 }


//STRIP001 void SelectionIteratorImpl::GotoNextObject (void)
//STRIP001 {
//STRIP001     if (mbDirectionIsForward)
//STRIP001         ++mnObjectIndex;
//STRIP001     else
//STRIP001         --mnObjectIndex;
//STRIP001 }


//STRIP001 const IteratorPosition& SelectionIteratorImpl::GetPosition (void)
//STRIP001 {
//STRIP001     maPosition.mpObject = mrObjectList.at(mnObjectIndex);
//STRIP001 
//STRIP001     return maPosition;
//STRIP001 }


//STRIP001 bool SelectionIteratorImpl::operator== (const IteratorImplBase& rIterator) const
//STRIP001 {
//STRIP001     return rIterator.IsEqual (*this, SELECTION);
//STRIP001 }


//STRIP001 bool SelectionIteratorImpl::IsEqual (
//STRIP001     const IteratorImplBase& rIterator,
//STRIP001     IteratorType aType) const
//STRIP001 {
//STRIP001     if (aType == SELECTION)
//STRIP001     {
//STRIP001         const SelectionIteratorImpl* pSelectionIterator = 
//STRIP001             static_cast<const SelectionIteratorImpl*>(&rIterator);
//STRIP001         return mpDocument == pSelectionIterator->mpDocument 
//STRIP001             && mnObjectIndex == pSelectionIterator->mnObjectIndex;
//STRIP001     }
//STRIP001     else
//STRIP001         return false;
//STRIP001 }




//===== ViewIteratorImpl ================================================

//STRIP001 ViewIteratorImpl::ViewIteratorImpl (
//STRIP001     sal_Int32 nPageIndex,
//STRIP001     SdDrawDocument* pDocument, 
//STRIP001     SdDrawViewShell* pViewShell,
//STRIP001     bool bDirectionIsForward)
//STRIP001     : IteratorImplBase (pDocument, pViewShell, bDirectionIsForward),
//STRIP001       mbPageChangeOccured(false),
//STRIP001       mpPage(NULL),
//STRIP001       mpObjectIterator(NULL)
//STRIP001 {
//STRIP001     SetPage (nPageIndex);
//STRIP001 }




//STRIP001 ViewIteratorImpl::ViewIteratorImpl (
//STRIP001     sal_Int32 nPageIndex,
//STRIP001     SdDrawDocument* pDocument, 
//STRIP001     SdDrawViewShell* pViewShell,
//STRIP001     bool bDirectionIsForward,
//STRIP001     PageKind ePageKind,
//STRIP001     EditMode eEditMode)
//STRIP001     : IteratorImplBase (pDocument, pViewShell, bDirectionIsForward, ePageKind, eEditMode),
//STRIP001       mbPageChangeOccured(false),
//STRIP001       mpPage(NULL),
//STRIP001       mpObjectIterator(NULL)
//STRIP001 {
//STRIP001     SetPage (nPageIndex);
//STRIP001 }




//STRIP001 ViewIteratorImpl::~ViewIteratorImpl (void)
//STRIP001 {
//STRIP001 }




//STRIP001 IteratorImplBase* ViewIteratorImpl::Clone (IteratorImplBase* pObject) const
//STRIP001 {
//STRIP001     
//STRIP001     ViewIteratorImpl* pIterator = static_cast<ViewIteratorImpl*>(pObject);
//STRIP001     if (pIterator == NULL)
//STRIP001         pIterator = new ViewIteratorImpl (
//STRIP001             maPosition.mnPageIndex, mpDocument, mpViewShell, mbDirectionIsForward);
//STRIP001 
//STRIP001     IteratorImplBase::Clone (pObject);
//STRIP001 
//STRIP001     if (mpObjectIterator != NULL)
//STRIP001     {
//STRIP001         pIterator->mpObjectIterator = new SdrObjListIter(
//STRIP001             *mpPage, IM_DEEPNOGROUPS, !mbDirectionIsForward);
//STRIP001 
//STRIP001         // No direct way to set the object iterator to the current object.
//STRIP001         pIterator->maPosition.mpObject = NULL;
//STRIP001         while (pIterator->mpObjectIterator->IsMore() 
//STRIP001             && pIterator->maPosition.mpObject!=maPosition.mpObject)
//STRIP001             pIterator->maPosition.mpObject = pIterator->mpObjectIterator->Next();
//STRIP001     }
//STRIP001     else
//STRIP001         pIterator->mpObjectIterator = NULL;
//STRIP001 
//STRIP001     return pIterator;
//STRIP001 }




//STRIP001 void ViewIteratorImpl::GotoNextObject (void)
//STRIP001 {
//STRIP001     if (mpObjectIterator != NULL && mpObjectIterator->IsMore())
//STRIP001         maPosition.mpObject = mpObjectIterator->Next();
//STRIP001     else
//STRIP001         maPosition.mpObject = NULL;
//STRIP001 
//STRIP001     if (maPosition.mpObject == NULL)
//STRIP001     {
//STRIP001         if (mbDirectionIsForward)
//STRIP001             SetPage (maPosition.mnPageIndex+1);
//STRIP001         else
//STRIP001             SetPage (maPosition.mnPageIndex-1);
//STRIP001 
//STRIP001         if (mpPage != NULL)
//STRIP001             mpObjectIterator = new SdrObjListIter(*mpPage, IM_DEEPNOGROUPS, !mbDirectionIsForward);
//STRIP001         if (mpObjectIterator!=NULL && mpObjectIterator->IsMore())
//STRIP001             maPosition.mpObject = mpObjectIterator->Next();
//STRIP001         else
//STRIP001             maPosition.mpObject = NULL;
//STRIP001     }
//STRIP001 }




//STRIP001 void ViewIteratorImpl::SetPage (sal_Int32 nPageIndex)
//STRIP001 {
//STRIP001     mbPageChangeOccured = (maPosition.mnPageIndex!=nPageIndex);
//STRIP001     if (mbPageChangeOccured)
//STRIP001     {
//STRIP001         maPosition.mnPageIndex = nPageIndex;
//STRIP001 
//STRIP001         // Get page pointer.
//STRIP001         if (nPageIndex >= 0)
//STRIP001         {
//STRIP001             if (maPosition.meEditMode == EM_PAGE)
//STRIP001                 mpPage = mpDocument->GetSdPage ((USHORT)nPageIndex, maPosition.mePageKind);
//STRIP001             else
//STRIP001                 mpPage = mpDocument->GetMasterSdPage ((USHORT)nPageIndex, maPosition.mePageKind);
//STRIP001         }
//STRIP001         else
//STRIP001             mpPage = NULL;
//STRIP001     }
//STRIP001 
//STRIP001     // Set up object list iterator.
//STRIP001     if (mpPage != NULL)
//STRIP001         mpObjectIterator = new SdrObjListIter(*mpPage, IM_DEEPNOGROUPS, ! mbDirectionIsForward);
//STRIP001     else
//STRIP001         mpObjectIterator = NULL;
//STRIP001 
//STRIP001     // Get object pointer.
//STRIP001     if (mpObjectIterator!=NULL && mpObjectIterator->IsMore())
//STRIP001         maPosition.mpObject = mpObjectIterator->Next();
//STRIP001     else
//STRIP001         maPosition.mpObject = NULL;
//STRIP001 }




//STRIP001 void ViewIteratorImpl::Reverse (void)
//STRIP001 {
//STRIP001     IteratorImplBase::Reverse ();
//STRIP001 
//STRIP001     // Create reversed object list iterator.
//STRIP001     if (mpObjectIterator != NULL)
//STRIP001         delete mpObjectIterator;
//STRIP001     if (mpPage != NULL)
//STRIP001         mpObjectIterator = new SdrObjListIter(*mpPage, IM_DEEPNOGROUPS, ! mbDirectionIsForward);
//STRIP001     else
//STRIP001         mpObjectIterator = NULL;
//STRIP001 
//STRIP001     // Move iterator to the current object.
//STRIP001     SdrObject* pObject = maPosition.mpObject;
//STRIP001     maPosition.mpObject = NULL;
//STRIP001     while (mpObjectIterator->IsMore() && maPosition.mpObject!=pObject)
//STRIP001         maPosition.mpObject = mpObjectIterator->Next();
//STRIP001 }




//===== DocumentIteratorImpl ============================================

//STRIP001 DocumentIteratorImpl::DocumentIteratorImpl (
//STRIP001     sal_Int32 nPageIndex,
//STRIP001     PageKind ePageKind, EditMode eEditMode,
//STRIP001     SdDrawDocument* pDocument, SdDrawViewShell* pViewShell,
//STRIP001     bool bDirectionIsForward)
//STRIP001     : ViewIteratorImpl (nPageIndex, pDocument, pViewShell, bDirectionIsForward,
//STRIP001         ePageKind, eEditMode)
//STRIP001 {
//STRIP001     if (eEditMode == EM_PAGE)
//STRIP001         mnPageCount = pDocument->GetSdPageCount (ePageKind);
//STRIP001     else
//STRIP001         mnPageCount = pDocument->GetMasterSdPageCount(ePageKind);
//STRIP001 }




//STRIP001 DocumentIteratorImpl::~DocumentIteratorImpl (void)
//STRIP001 {}




//STRIP001 IteratorImplBase* DocumentIteratorImpl::Clone (IteratorImplBase* pObject) const
//STRIP001 {
//STRIP001     DocumentIteratorImpl* pIterator = static_cast<DocumentIteratorImpl*>(pObject);
//STRIP001     if (pIterator == NULL)
//STRIP001         pIterator = new DocumentIteratorImpl (
//STRIP001             maPosition.mnPageIndex, maPosition.mePageKind, maPosition.meEditMode,
//STRIP001             mpDocument, mpViewShell, mbDirectionIsForward);
//STRIP001     // Finish the cloning.
//STRIP001     return ViewIteratorImpl::Clone (pIterator);
//STRIP001 }




//STRIP001 void DocumentIteratorImpl::GotoNextObject (void)
//STRIP001 {
//STRIP001     bool bSetToOnePastLastPage = false;
//STRIP001     bool bViewChanged = false;
//STRIP001 
//STRIP001     ViewIteratorImpl::GotoNextObject();
//STRIP001 
//STRIP001     if (mbDirectionIsForward)
//STRIP001     {
//STRIP001         if (maPosition.mnPageIndex >= mnPageCount)
//STRIP001         {   
//STRIP001             // Switch to master page.
//STRIP001             if (maPosition.meEditMode == EM_PAGE)
//STRIP001             {
//STRIP001                 maPosition.meEditMode = EM_MASTERPAGE;
//STRIP001                 SetPage (0);
//STRIP001             }
//STRIP001             
//STRIP001             // Switch to next view mode.
//STRIP001             else
//STRIP001             {
//STRIP001                 if (maPosition.mePageKind == PK_HANDOUT)
//STRIP001                     // Not really necessary but makes things more clear.
//STRIP001                     bSetToOnePastLastPage = true;
//STRIP001                 else
//STRIP001                 {
//STRIP001                     maPosition.meEditMode = EM_PAGE;
//STRIP001                     if (maPosition.mePageKind == PK_STANDARD)
//STRIP001                         maPosition.mePageKind = PK_NOTES;
//STRIP001                     else if (maPosition.mePageKind == PK_NOTES)
//STRIP001                         maPosition.mePageKind = PK_HANDOUT;
//STRIP001                     SetPage (0);
//STRIP001                 }
//STRIP001             }
//STRIP001             bViewChanged = true;
//STRIP001         }
//STRIP001     }
//STRIP001     else
//STRIP001         if (maPosition.mnPageIndex < 0)
//STRIP001         {
//STRIP001             // Switch from master pages to draw pages.
//STRIP001             if (maPosition.meEditMode == EM_MASTERPAGE)
//STRIP001             {
//STRIP001                 maPosition.meEditMode = EM_PAGE;
//STRIP001                 bSetToOnePastLastPage = true;
//STRIP001             }
//STRIP001             
//STRIP001             // Switch to previous view mode.
//STRIP001             else
//STRIP001             {
//STRIP001                 if (maPosition.mePageKind == PK_STANDARD)
//STRIP001                     SetPage (-1);
//STRIP001                 else
//STRIP001                 {
//STRIP001                     maPosition.meEditMode = EM_MASTERPAGE;
//STRIP001                     if (maPosition.mePageKind == PK_HANDOUT)
//STRIP001                         maPosition.mePageKind = PK_NOTES;
//STRIP001                     else if (maPosition.mePageKind == PK_NOTES)
//STRIP001                         maPosition.mePageKind = PK_STANDARD;
//STRIP001                     bSetToOnePastLastPage = true;
//STRIP001                 }
//STRIP001             }
//STRIP001             bViewChanged = true;
//STRIP001         }
//STRIP001 
//STRIP001     if (bViewChanged)
//STRIP001     {
//STRIP001         // Get new page count;
//STRIP001         sal_Int32 nPageCount;
//STRIP001         if (maPosition.meEditMode == EM_PAGE)
//STRIP001             nPageCount = mpDocument->GetSdPageCount (maPosition.mePageKind);
//STRIP001         else
//STRIP001             nPageCount = mpDocument->GetMasterSdPageCount(maPosition.mePageKind);
//STRIP001                         
//STRIP001         // Now that we know the number of pages we can set the current page index.
//STRIP001         if (bSetToOnePastLastPage)
//STRIP001             SetPage (nPageCount);
//STRIP001     }
//STRIP001 }


} } // end of namespace ::sd::outliner
}
